---
lang: nl
title: Bouwen aan gastvrije gemeenschappen
description: Een gemeenschap opbouwen die mensen aanmoedigt om uw project te gebruiken, eraan bij te dragen en het te evangeliseren.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Uw project opzetten voor succes

Je hebt je project gelanceerd, je verspreidt het woord en mensen bekijken het. Geweldig! Nu, hoe zorg je ervoor dat ze blijven hangen?

Een gastvrije gemeenschap is een investering in de toekomst en reputatie van uw project. Als je project net zijn eerste bijdragen begint te zien, begin dan met het geven van een positieve ervaring aan vroege bijdragers en zorg ervoor dat ze gemakkelijk terug blijven komen.

### Zorg ervoor dat mensen zich welkom voelen

Een manier om na te denken over de gemeenschap van uw project is door wat @MikeMcQuaid het [bijdrager trechter](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/) noemt:

![bijdrager trechter](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Bedenk bij het opbouwen van uw community hoe iemand bovenaan de trechter (een potentiële gebruiker) theoretisch de weg naar de bodem kan vinden (een actieve onderhouder). Uw doel is om wrijving in elke fase van de bijdragerservaring te verminderen. Als mensen gemakkelijk winnen, voelen ze zich gestimuleerd om meer te doen.

Begin met uw documentatie:

* **Maak het voor iemand gemakkelijk om uw project te gebruiken.** [Een vriendelijke README](../starting-a-project/#een-readme-schrijven) en duidelijke codevoorbeelden maken het gemakkelijker voor iedereen die op uw project belandt om aan de slag te gaan.
* **Leg duidelijk uit hoe u kunt bijdragen**, gebruik [je CONTRIBUTING-bestand](../starting-a-project/#schrijven-van-uw-bijdrage-richtlijnen) en uw issues up-to-date houden.
* **Goede first issues**: Overweeg expliciet om nieuwe bijdragers op weg te helpen [label issues die eenvoudig genoeg zijn voor beginners om aan te pakken](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). GitHub zal deze issues vervolgens op verschillende plaatsen op het platform aan de oppervlakte brengen, waardoor nuttige bijdragen worden verhoogd en de wrijving wordt verminderd van gebruikers die problemen aanpakken die te moeilijk zijn voor hun niveau.
* [GitHub's Open Source-enquête 2017](http://opensourcesurvey.org/2017/) vertoonde onvolledige of verwarrende documentatie is het grootste probleem voor open source-gebruikers. Goede documentatie nodigt uit tot interactie met uw project. Uiteindelijk zal iemand een issue of pull request openen. Gebruik deze interacties als kansen om ze door de trechter te verplaatsen.

* **Als iemand nieuw op uw project komt, bedank hem dan voor zijn interesse!** Er is maar één negatieve ervaring nodig om ervoor te zorgen dat iemand niet meer terug wil komen.
* **Wees responsief.** Als u een maand lang niet op hun probleem reageert, is de kans groot dat ze uw project al zijn vergeten.
* **Sta open voor de soorten bijdragen die u accepteert.** Veel bijdragers beginnen met een bugrapport of een kleine oplossing. Er zijn [veel manieren om bij te dragen](../how-to-contribute/#waarom-bijdragen-aan-open-source) aan een project. Laat mensen helpen zoals ze willen helpen.
* **Als er een bijdrage is waar u het niet mee eens bent,** bedank ze voor hun idee, en [vertel waarom](../best-practices/#nee-leren-zeggen) het niet past in de scope van het project en linkt naar relevante documentatie als je die hebt.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Bijdragen aan open source is voor sommigen gemakkelijker dan voor anderen. Er is veel angst om te worden uitgescholden omdat ze iets niet goed doen of gewoon niet passen. (...) Door bijdragers een plek te geven om bij te dragen met een zeer lage technische vaardigheid (documentatie, afwaardering van webinhoud, enz.), Kunt u aanzienlijk verminderen die zorgen.

  _Contributing to open source is easier for some than others. There's a lot of fear of being yelled at for not doing something right or just not fitting in. (...) By giving contributors a place to contribute with very low technical proficiency (documentation, web content markdown, etc) you can greatly reduce those concerns._

  <p markdown="1" class="pquote-credit">
— @mikeal, ["Een bijdrage leveren in moderne open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

De meeste open source-bijdragers zijn "casual bijdragers": mensen die slechts af en toe bijdragen aan een project. Een toevallige bijdrager heeft misschien geen tijd om volledig op de hoogte te zijn van uw project, dus het is uw taak om het hem gemakkelijk te maken om bij te dragen.

Andere bijdragers aanmoedigen is ook een investering in uzelf. Als u uw grootste fans de kracht geeft om te rennen met het werk waar ze enthousiast over zijn, is er minder druk om alles zelf te doen.

### Documenteer alles

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Ben je ooit naar een (tech-) evenement geweest waar je niemand kende, maar iedereen leek in groepen te staan en te chatten als oude vrienden? (...) Stel je nu voor dat je wilt bijdragen aan een open source-project, maar je begrijpt niet waarom of hoe dit gebeurt.

  _Have you ever been to a (tech-) event where you didn't know anyone, but everyone else seemed to stand in groups and chat like old friends? (...) Now imagine you want to contribute to an open source project, but you don't see why or how this is happening._

  <p markdown="1" class="pquote-credit">
— @janl, ["Duurzame open source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Wanneer u aan een nieuw project begint, kan het natuurlijk aanvoelen om uw werk privé te houden. Maar open source-projecten gedijen goed wanneer u uw proces openbaar documenteert.

Als je dingen opschrijft, kunnen er bij elke stap meer mensen deelnemen. U kunt misschien hulp krijgen bij iets waarvan u niet eens wist dat u het nodig had.

Dingen opschrijven is meer dan alleen technische documentatie. Elke keer dat u de neiging voelt om iets op te schrijven of uw project privé te bespreken, vraag uzelf dan af of u het openbaar kunt maken.

Wees transparant over de roadmap van uw project, de soorten bijdragen die u zoekt, hoe bijdragen worden beoordeeld of waarom u bepaalde beslissingen hebt genomen.

Als u merkt dat meerdere gebruikers tegen hetzelfde probleem aanlopen, documenteer de antwoorden dan in de README.

Overweeg voor vergaderingen uw aantekeningen of afhaalrestaurants te publiceren in een relevant nummer. De feedback die u van dit transparantieniveau krijgt, zal u misschien verbazen.

Alles documenteren is ook van toepassing op het werk dat u doet. Als u aan een substantiële update van uw project werkt, plaatst u dit in een pull-aanvraag en markeert u het als een work in progress (_Werk in uitvoering_) (WIP). Op die manier kunnen andere mensen zich al vroeg bij het proces betrokken voelen.

### Wees responsief

Als jij [je project promoot](../finding-users), zullen mensen feedback voor je hebben. Ze hebben misschien vragen over hoe dingen werken of hebben hulp nodig om aan de slag te gaan.

Probeer responsief te zijn wanneer iemand een probleem issue, een pull-verzoek indient of een vraag stelt over uw project. Als je snel reageert, zullen mensen het gevoel hebben dat ze deel uitmaken van een dialoog en zullen ze enthousiaster zijn over deelname.

Zelfs als u het verzoek niet onmiddellijk kunt beoordelen, helpt het vroegtijdig erkennen van het verzoek de betrokkenheid te vergroten. Hier is hoe @tdreyno reageerde op een pull-verzoek op [Middleman](https://github.com/middleman/middleman/pull/1466):

![Middleman pull request](/assets/images/building-community/middleman_pr.png)

[Een Mozilla-studie zag dat](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) bijdragers die binnen 48 uur codebeoordelingen ontvingen, een veel hoger rendement hadden en een veel hogere bijdrage.

Gesprekken over uw project kunnen ook plaatsvinden op andere plaatsen op internet, zoals Stack Overflow, Twitter of Reddit. U kunt op sommige van deze plaatsen meldingen instellen, zodat u wordt gewaarschuwd wanneer iemand uw project noemt.

### Geef uw gemeenschap een plek om samen te komen

Er zijn twee redenen om uw gemeenschap een plek te geven om samen te komen.

De eerste reden is voor hen. Help mensen elkaar te leren kennen. Mensen met gemeenschappelijke interesses zullen onvermijdelijk een plek willen hebben om erover te praten. En als communicatie openbaar en toegankelijk is, kan iedereen archieven uit het verleden lezen om op de hoogte te blijven en deel te nemen.

De tweede reden is voor jou. Als je mensen geen openbare plek geeft om over je project te praten, zullen ze waarschijnlijk rechtstreeks contact met je opnemen. In het begin lijkt het misschien eenvoudig genoeg om "voor een keer" op privéberichten te reageren. Maar na verloop van tijd, vooral als uw project populair wordt, zult u zich uitgeput voelen. Weersta de verleiding om privé met mensen over uw project te communiceren. Verwijs ze in plaats daarvan naar een aangewezen openbaar kanaal.

Openbare communicatie kan zo simpel zijn als mensen sturen om een ​​probleem te openen in plaats van u rechtstreeks te e-mailen of te reageren op uw blog. Je kunt ook een mailinglijst opzetten, of een Twitter-account, Slack- of IRC-kanaal maken zodat mensen over je project kunnen praten. Of probeer al het bovenstaande!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) reserveert om de week kantooruren om leden van de gemeenschap te helpen:

> Kops heeft ook om de week tijd vrijgemaakt om hulp en begeleiding te bieden aan de gemeenschap. De beheerders van Kops zijn overeengekomen om tijd vrij te maken die specifiek is bedoeld voor het werken met nieuwkomers, het helpen met PR's en het bespreken van nieuwe functies.

Uitzonderingen op openbare communicatie zijn: 1) beveiligingskwesties en 2) schendingen van gevoelige gedragscodes. U moet altijd een manier hebben waarop mensen deze problemen privé kunnen melden. Als u uw persoonlijke e-mailadres niet wilt gebruiken, stelt u een speciaal e-mailadres in.

## Je community laten groeien

Gemeenschappen zijn buitengewoon krachtig. Die macht kan een zegen of een vloek zijn, afhankelijk van hoe u die uitoefent. Naarmate de gemeenschap van uw project groeit, zijn er manieren om het te helpen een bouwkracht te worden, geen vernietiging.

### Sta geen slechte acteurs toe

Elk populair project zal onvermijdelijk mensen aantrekken die uw gemeenschap schaden in plaats van helpen. Ze kunnen onnodige debatten beginnen, kibbelen over triviale kenmerken of anderen pesten.

Doe je best om een nultolerantiebeleid te voeren ten aanzien van dit soort mensen. Als dit niet wordt aangevinkt, zullen negatieve mensen andere mensen in uw gemeenschap ongemakkelijk maken. Ze kunnen zelfs vertrekken.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  De waarheid is dat het hebben van een ondersteunende gemeenschap de sleutel is. Ik zou dit werk nooit kunnen doen zonder de hulp van mijn collega's, vriendelijke internetvreemdelingen en spraakzame IRC-kanalen. (...) Neem geen genoegen met minder. Neem geen genoegen met klootzakken.

  _The truth is that having a supportive community is key. I'd never be able to do this work without the help of my colleagues, friendly internet strangers, and chatty IRC channels. (...) Don't settle for less. Don't settle for assholes._

  <p markdown="1" class="pquote-credit">
— @okdistribute, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Regelmatige debatten over triviale aspecten van uw project leiden anderen, waaronder u, af om zich op belangrijke taken te concentreren. Nieuwe mensen die naar uw project komen, kunnen deze gesprekken zien en willen niet deelnemen.

Als u negatief gedrag in uw project ziet gebeuren, meld dit dan in het openbaar. Leg op vriendelijke maar krachtige toon uit waarom hun gedrag niet acceptabel is. Als het probleem aanhoudt, kan het nodig zijn [om te vragen om te vertrekken](../code-of-conduct/#handhaving-van-uw-gedragscode). Uw [gedragsregels](../code-of-conduct/) kan een constructieve gids zijn voor deze gesprekken.

### Ontmoet bijdragers waar ze zijn

Goede documentatie wordt alleen maar belangrijker naarmate uw gemeenschap groeit. Toevallige bijdragers, die anders misschien niet bekend zijn met uw project, lezen uw documentatie om snel de context te krijgen die ze nodig hebben.

Vertel nieuwe bijdragers in uw CONTRIBUTORS-bestand expliciet hoe ze aan de slag kunnen. Misschien wilt u voor dit doel zelfs een speciale sectie maken. [Django](https://github.com/django/django), heeft bijvoorbeeld een speciale bestemmingspagina om nieuwe bijdragers te verwelkomen.

![Django niewe bijdragers pagina](/assets/images/building-community/django_new_contributors.png)

Label in uw issue wachtrij bugs die geschikt zijn voor verschillende soorten bijdragers: bijvoorbeeld [_"alleen first timers"_](https://kentcdodds.com/blog/first-timers-only), _"good first issue"_, or _"documentatie"_. [Deze labels](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) maken het gemakkelijk voor iemand die nieuw is bij uw project om snel uw problemen te scannen en aan de slag te gaan.

Gebruik ten slotte uw documentatie om ervoor te zorgen dat mensen zich bij elke stap welkom voelen.

U zult nooit contact hebben met de meeste mensen die op uw project terechtkomen. Er kunnen bijdragen zijn die u niet hebt ontvangen omdat iemand zich geïntimideerd voelde of niet wist waar hij moest beginnen. Zelfs een paar vriendelijke woorden kunnen iemand ervan weerhouden uw project gefrustreerd te verlaten.

Hier is bijvoorbeeld hoe [Rubinius](https://github.com/rubinius/rubinius/) startte [zijn bijdrage gids](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> Om te beginnen willen we u bedanken voor het gebruik van Rubinius. Dit project is een werk van liefde, en we waarderen alle gebruikers die bugs ontdekken, prestatieverbeteringen aanbrengen en helpen met documentatie. Elke bijdrage is zinvol, dus bedankt voor je deelname. Dat gezegd hebbende, zijn hier enkele richtlijnen die we u vragen te volgen, zodat we uw probleem met succes kunnen oplossen.

### Deel het eigendom van uw project

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  Je leiders zullen verschillende meningen hebben, zoals alle gezonde gemeenschappen zouden moeten! U moet echter maatregelen nemen om ervoor te zorgen dat de luidste stem niet altijd wint door mensen uit te putten, en dat minder prominente stemmen en minderheidsstemmen worden gehoord.

  _Your leaders will have different opinions, as all healthy communities should! However, you need to take steps to ensure the loudest voice doesn't always win by tiring people out, and that less prominent and minority voices are heard._

  <p markdown="1" class="pquote-credit">
— @sagesharp, ["Wat maakt een goede gemeenschap?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Mensen zijn enthousiast om bij te dragen aan projecten als ze een gevoel van eigenaarschap voelen. Dat betekent niet dat u de visie van uw project moet overdragen of bijdragen moet accepteren die u niet wilt. Maar hoe meer je anderen erkent, hoe meer ze blijven hangen.

Kijk of je manieren kunt vinden om het eigendom zoveel mogelijk met je gemeenschap te delen. Hier zijn enkele ideeën:

* **Weersta het oplossen van gemakkelijke (niet-kritieke) bugs.** Gebruik ze in plaats daarvan als kansen om nieuwe bijdragers te werven of iemand te begeleiden die een bijdrage wil leveren. In het begin lijkt het misschien onnatuurlijk, maar uw investering zal zich na verloop van tijd terugbetalen. @Michaeljoseph vroeg bijvoorbeeld een bijdrager om een pull-verzoek in te dienen voor een [Cookiecutter](https://github.com/audreyr/cookiecutter) issue hieronder, in plaats van het zelf te repareren.

![Cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Start een CONTRIBUTORS- of AUTHORS-bestand in uw project** met een lijst van iedereen die aan uw project heeft bijgedragen, zoals [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md) doet.

* Als je een omvangrijke community hebt, **stuur dan een nieuwsbrief of schrijf een blogpost** om bijdragers te bedanken. Rust's [Deze week in Rust](https://this-week-in-rust.org/) en Hoodie's [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) zijn twee goede voorbeelden.

* **Geef elke bijdrager toegang tot commit.** @felixge ontdekte dat dit mensen [meer enthousiast maakte om hun patches op te poetsen](https://felixge.de/2013/03/11/the-pull-request-hack.html), en hij vond zelfs nieuwe beheerders voor projecten waaraan hij al een tijdje niet had gewerkt.

* Als uw project zich op GitHub bevindt, **verplaats uw project dan van uw persoonlijke account naar een [Organisatie](https://help.github.com/articles/creating-a-new-organization-account/)** en voeg minstens één back-upbeheerder toe. Organisaties maken het gemakkelijker om met externe medewerkers aan projecten te werken.

De realiteit is dat bij [de meeste projecten]
(https://peerj.com/preprints/1233/) een of twee beheerders die het meeste werk doen. Hoe groter uw project en hoe groter uw gemeenschap, hoe gemakkelijker het is om hulp te vinden.

Hoewel je misschien niet altijd iemand vindt om de oproep te beantwoorden, vergroot het geven van een signaal de kans dat andere mensen meedoen. En hoe eerder je begint, hoe eerder mensen kunnen helpen.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[Het is in uw belang\] om bijdragers te werven die plezier hebben en die in staat zijn om de dingen te doen die u niet bent. Houd je van coderen, maar beantwoord je geen problemen? Identificeer vervolgens die personen in uw gemeenschap die dat wel doen en laat ze het hebben.

  _\[It's in your\] best interest to recruit contributors who enjoy and who are capable of doing the things that you are not. Do you enjoy coding, but not answering issues? Then identify those individuals in your community who do and let them have it._

  <p markdown="1" class="pquote-credit">
— @gr2m, ["Gastvrije gemeenschappen"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Conflicten oplossen

In de vroege stadia van uw project is het nemen van belangrijke beslissingen eenvoudig. Als je iets wilt doen, doe het dan gewoon.

Naarmate uw project populairder wordt, zullen meer mensen belangstelling tonen voor de beslissingen die u neemt. Zelfs als je geen grote gemeenschap van bijdragers hebt, als je project veel gebruikers heeft, zul je merken dat mensen een afweging maken bij beslissingen of hun eigen problemen aan de orde stellen.

Als je een vriendelijke, respectvolle gemeenschap hebt ontwikkeld en je processen openlijk hebt gedocumenteerd, zou je gemeenschap voor het grootste deel een oplossing moeten kunnen vinden. Maar soms kom je een probleem tegen dat wat moeilijker op te lossen is.

### Leg de lat voor vriendelijkheid

Wanneer uw gemeenschap worstelt met een moeilijk probleem, kunnen de gemoederen stijgen. Mensen kunnen boos of gefrustreerd worden en het op elkaar of op jou afkraken.

Het is jouw taak als onderhouder om te voorkomen dat deze situaties escaleren. Zelfs als je een uitgesproken mening over het onderwerp hebt, probeer dan de positie van moderator of facilitator in te nemen, in plaats van de strijd aan te gaan en je mening te benadrukken. Als iemand onaardig is of het gesprek monopoliseert, [reageer meteen](../building-community/#sta-geen-slechte-acteurs-toe) discussies netjes en productief houden.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  Als projectonderhouder is het uiterst belangrijk om respectvol te zijn voor uw bijdragers. Ze vatten wat je zegt vaak heel persoonlijk op.

  _As a project maintainer, it's extremely important to be respectful to your contributors. They often take what you say very personally._

  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Wees hartelijk of ga op weg"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Andere mensen vragen je om advies. Geef een goed voorbeeld. U kunt nog steeds teleurstelling, ongeluk of bezorgdheid uiten, maar doe dit rustig.

Het hoofd koel houden is niet eenvoudig, maar leiderschap tonen verbetert de gezondheid van uw gemeenschap. Het internet dankt je.

### Behandel uw README als een grondwet

Uw README is [meer dan alleen een reeks instructies](../starting-a-project/#een-readme-schrijven). Het is ook een plek om te praten over uw doelen, productvisie en roadmap. Als mensen overdreven gefocust zijn op het bespreken van de waarde van een bepaalde functie, kan het helpen om je README opnieuw te bekijken en te praten over de hogere visie van je project. Focussen op je README maakt het gesprek ook onpersoonlijk, zodat je een constructieve discussie kunt voeren.

### Concentreer u op de reis, niet op de bestemming

Sommige projecten gebruiken een stemproces om belangrijke beslissingen te nemen. Hoewel stemmen op het eerste gezicht verstandig zijn, legt het de nadruk op het vinden van een 'antwoord' in plaats van naar elkaars zorgen te luisteren en erop in te gaan.

Stemmen kan politiek worden, waarbij leden van de gemeenschap onder druk gezet worden om elkaar goed te doen of op een bepaalde manier te stemmen. Ook niet iedereen stemt of het de [stille meerderheid](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) is in uw gemeenschap, of huidige gebruikers die niet wisten dat er gestemd werd.

Soms is stemmen een noodzakelijk kwaad. Zoveel als je kunt, leg echter de nadruk op ["consensus zoeken"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) in plaats van consensus.

In het kader van een proces voor het zoeken naar consensus, bespreken leden van de gemeenschap belangrijke zorgen totdat ze vinden dat ze voldoende zijn gehoord. Als er nog maar kleine zorgen zijn, gaat de gemeenschap vooruit. "Consensus zoeken" erkent dat een gemeenschap misschien niet in staat zal zijn om tot een perfect antwoord te komen. In plaats daarvan geeft het prioriteit aan luisteren en discussiëren.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Een deel van de reden waarom er geen stemsysteem bestaat voor Atom Issues is dat het Atom-team niet in alle gevallen een stemsysteem gaat volgen. Soms moeten we kiezen wat we vinden dat juist is, zelfs als het niet populair is. (...) Wat ik kan bieden en beloven te doen ... is dat het mijn taak is om naar de gemeenschap te luisteren.

  _Part of the reason why a voting system doesn't exist for Atom Issues is because the Atom team isn't going to follow a voting system in all cases. Sometimes we have to choose what we feel is right even if it is unpopular. (...) What I can offer and pledge to do...is that it is my job to listen to the community._

  <p markdown="1" class="pquote-credit">
— @lee-dohm on Atom's besluitvormingsproces
  </p>
</aside>

Zelfs als u niet echt een consensuszoekproces toepast, is het als projectonderhouder belangrijk dat mensen weten dat u luistert. Door ervoor te zorgen dat andere mensen zich gehoord voelen en zich ertoe verbinden hun zorgen op te lossen, kunnen gevoelige situaties aanzienlijk worden verspreid. Volg vervolgens uw woorden met daden.

Overhaast geen beslissing om een oplossing te hebben. Zorg ervoor dat iedereen zich gehoord voelt en dat alle informatie openbaar is gemaakt voordat u naar een oplossing gaat.

### Houd het gesprek gericht op actie

Discussie is belangrijk, maar er is een verschil tussen productieve en onproductieve gesprekken.

Moedig discussie aan zolang deze actief naar een oplossing toe evolueert. Als het duidelijk is dat een gesprek wegkwijnt of afwijkt van het onderwerp, prikkels persoonlijk worden of mensen kibbelen over kleine details, is het tijd om het af te sluiten.

Deze gesprekken laten doorgaan is niet alleen slecht voor het betreffende probleem, maar ook slecht voor de gezondheid van uw gemeenschap. Het geeft een bericht dat dit soort gesprekken is toegestaan ​​of zelfs aangemoedigd, en het kan mensen ontmoedigen om toekomstige problemen aan de orde te stellen of op te lossen.

Stel uzelf bij elk punt dat door u of anderen wordt gemaakt, de vraag: _"Hoe brengt dit ons dichter bij een oplossing?"_

Als het gesprek begint te ontrafelen, vraag dan aan de groep: _"Welke stappen moeten we hierna nemen?"_ Om het gesprek opnieuw te focussen.

Als een gesprek duidelijk nergens heen gaat, er geen duidelijke acties kunnen worden ondernomen, of als de juiste actie al is ondernomen, sluit dan het probleem af en leg uit waarom je het hebt gesloten.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Een draad naar bruikbaarheid leiden zonder opdringerig te zijn, is een kunst. Het zal niet werken om mensen simpelweg te vermanen om te stoppen met het verspillen van hun tijd, of om hen te vragen niet te posten tenzij ze iets constructiefs te melden hebben. (...) In plaats daarvan moet je voorwaarden stellen voor verdere vooruitgang: geef mensen een route, een pad om te volgen dat leidt tot de resultaten die je wilt, maar zonder dat het lijkt alsof je gedrag dicteert.

  _Guiding a thread toward usefulness without being pushy is an art. It won't work to simply admonish people to stop wasting their time, or to ask them not to post unless they have something constructive to say. (...) Instead, you have to suggest conditions for further progress: give people a route, a path to follow that leads to the results you want, yet without sounding like you're dictating conduct._

  <p markdown="1" class="pquote-credit">
— @kfogel, [_OSS Produceren_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Kies je gevechten verstandig

Context is belangrijk. Bedenk wie er bij de discussie betrokken is en hoe zij de rest van de gemeenschap vertegenwoordigen.

Is iedereen in de gemeenschap boos over of zelfs betrokken bij deze kwestie? Of is het een eenzame onruststoker? Vergeet niet rekening te houden met uw stille gemeenschapsleden, niet alleen met de actieve stemmen.

Als het probleem niet de bredere behoeften van uw gemeenschap weerspiegelt, moet u misschien de zorgen van een paar mensen erkennen. Als dit een terugkerend probleem is zonder een duidelijke oplossing, verwijs ze dan naar eerdere discussies over het onderwerp en sluit de thread.

### Identificeer een schiftingspercentage van de gemeenschap

Met een goede instelling en duidelijke communicatie zijn de meeste moeilijke situaties op te lossen. Maar zelfs in een productief gesprek kan er eenvoudig een verschil in mening zijn over hoe verder te gaan. Identificeer in deze gevallen een persoon of een groep mensen die als schiftingsvariant kunnen dienen.

Een doorslag kan de primaire instandhouder van het project zijn, of het kan een kleine groep mensen zijn die een beslissing neemt op basis van stemmen. Idealiter heb je een schiftingspercentage en het bijbehorende proces geïdentificeerd in een GOVERNANCE-bestand voordat je het ooit hoeft te gebruiken.

Je schifting zou een laatste redmiddel moeten zijn. Kwesties die verdeeldheid zaaien, zijn een kans voor uw gemeenschap om te groeien en te leren. Omarm deze kansen en gebruik een samenwerkingsproces om waar mogelijk tot een oplossing te komen.

## Community is het ❤️ van open source

Gezonde, bloeiende gemeenschappen voeden de duizenden uren die elke week in open source worden gestoken. Veel bijdragers wijzen op andere mensen als de reden om wel of niet aan open source te werken. Door constructief te leren hoe je die kracht kunt aanboren, help je iemand daarbuiten een onvergetelijke open source-ervaring te hebben.
