---
lang: ms
title: Memulakan Projek Sumber Terbuka
description: Ketahui lebih lanjut mengenai dunia sumber terbuka dan bersiap sedia untuk melancarkan projek anda sendiri.
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## "apa" dan "mengapa" sumber terbuka

Oleh itu, anda berfikir untuk memulakan dengan sumber terbuka? Tahniah! Dunia menghargai sumbangan anda. Mari kita bincangkan apa itu sumber terbuka dan mengapa orang melakukannya.

### Apa maksud "sumber terbuka"?

Apabila projek adalah sumber terbuka, itu bermaksud **siapa sahaja bebas menggunakan, mengkaji, mengubah dan menyebarkan projek anda untuk tujuan apa pun.** Kebenaran ini diberlakukan melalui[an open source license](https://opensource.org/licenses).

Sumber terbuka sangat kuat kerana ia dapat mengurangkan halangan untuk menerima pakai dan berkolaborasi, memungkinkan orang menyebarkan dan memperbaiki projek dengan cepat. Juga kerana memberi pengguna potensi untuk mengendalikan pengkomputeran mereka sendiri, berbanding dengan sumber tertutup. Sebagai contoh, perniagaan yang menggunakan perisian sumber terbuka mempunyai pilihan untuk mengupah seseorang untuk membuat penambahbaikan khusus pada perisian, daripada hanya bergantung pada keputusan produk penjual sumber tertutup.

_Perisian percuma_ merujuk kepada set projek yang sama dengan _open source_. Kadang-kadang anda juga akan melihat[these terms](https://en.wikipedia.org/wiki/Free_and_open-source_software) digabungkan sebagai "perisian sumber bebas dan terbuka" (FOSS) atau "perisian bebas, bebas, dan sumber terbuka" (FLOSS). _Free_ dan _libre_ merujuk kepada kebebasan,[bukan harga](#adakah-sumber-terbuka-bermaksud-percuma).

### Mengapa orang membuka sumber pekerjaan mereka?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">
  Salah satu pengalaman paling bermanfaat yang saya dapat daripada menggunakan dan berkolaborasi pada sumber terbuka berasal dari hubungan yang saya bina dengan pembangun lain yang menghadapi banyak masalah yang sama dengan saya.
  <p markdown="1" class="pquote-credit">
— @kentcdodds, ["How getting into Open Source has been awesome for me"](https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me)
  </p>
</aside>

[There are many reasons](https://ben.balter.com/2015/11/23/why-open-source/) mengapa seseorang atau organisasi ingin membuka sumber projek. Beberapa contoh merangkumi:

* **Kerjasama:** Projek sumber terbuka dapat menerima perubahan dari sesiapa sahaja di dunia. [Exercism](https://github.com/exercism/), sebagai contoh, adalah platform latihan pengaturcaraan dengan lebih daripada 350 penyumbang.

* **Adopsi dan pencampuran semula:** Projek sumber terbuka dapat digunakan oleh siapa saja untuk hampir semua tujuan. Orang bahkan boleh menggunakannya untuk membina perkara lain.[WordPress](https://github.com/WordPress),sebagai contoh, dimulakan sebagai garpu projek sedia ada yang dipanggil [b2](https://github.com/WordPress/book/blob/HEAD/Content/Part%201/2-b2-cafelog.md).

* **Ketelusan:** Sesiapa sahaja dapat memeriksa projek sumber terbuka untuk kesilapan atau ketidakkonsistenan. Perkara ketelusan kepada kerajaan seperti [Bulgaria](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-open-source-98bf626cf70a) or the [United States](https://www.cio.gov/2016/08/11/peoples-code.html),industri terkawal seperti perbankan atau penjagaan kesihatan, dan perisian keselamatan seperti [Let's Encrypt](https://github.com/letsencrypt).

Sumber terbuka bukan hanya untuk perisian. Anda boleh membuka sumber semuanya dari set data hingga buku. Lihatlah[GitHub Explore](https://github.com/explore)untuk idea mengenai apa lagi yang boleh anda buka sumber.

### Adakah sumber terbuka bermaksud "percuma"?

Salah satu tarikan terbesar sumber terbuka adalah bahawa ia tidak memerlukan wang. "Percuma", bagaimanapun, adalah hasil sampingan dari nilai keseluruhan sumber terbuka.

Kerana [an open source license requires](https://opensource.org/osd-annotated)bahawa sesiapa sahaja boleh menggunakan, mengubah suai, dan berkongsi projek anda untuk hampir semua tujuan, projek itu sendiri cenderung percuma. Sekiranya projek itu memerlukan wang untuk digunakan, sesiapa sahaja boleh membuat salinan secara sah dan menggunakan versi percuma sebagai gantinya.

Akibatnya, kebanyakan projek sumber terbuka adalah percuma, tetapi "percuma" bukan sebahagian daripada definisi sumber terbuka. Terdapat cara untuk mengenakan bayaran untuk projek sumber terbuka secara tidak langsung melalui pelesenan ganda atau ciri terhad, sementara masih mematuhi definisi rasmi sumber terbuka.

## Perlukah saya melancarkan projek sumber terbuka saya sendiri?

Jawapan ringkasnya adalah ya, kerana tidak kira hasilnya, melancarkan projek anda sendiri adalah cara terbaik untuk mengetahui bagaimana sumber terbuka berfungsi.

Sekiranya anda tidak pernah membuka projek bersumber sebelumnya, anda mungkin merasa gementar dengan apa yang orang akan katakan, atau adakah orang akan melihatnya sama sekali. Sekiranya ini terdengar seperti anda, anda tidak bersendirian!

Karya sumber terbuka adalah seperti aktiviti kreatif lain, sama ada penulisan atau lukisan. Rasanya menakutkan untuk berkongsi karya anda dengan dunia, tetapi satu-satunya cara untuk menjadi lebih baik adalah berlatih - walaupun anda tidak mempunyai penonton.

Sekiranya anda belum yakin, luangkan masa untuk memikirkan apakah matlamat anda.

### Menetapkan matlamat anda

Matlamat dapat membantu anda mengetahui apa yang harus diusahakan, apa yang harus dikatakan tidak, dan di mana anda memerlukan bantuan daripada orang lain. Mulakan dengan bertanya pada diri sendiri, _mengapa saya membuka sumber projek ini?_

Tidak ada satu jawapan yang tepat untuk soalan ini. Anda mungkin mempunyai banyak tujuan untuk satu projek, atau projek yang berbeza dengan tujuan yang berbeza.

Sekiranya satu-satunya tujuan anda adalah untuk mempamerkan hasil kerja anda, anda mungkin tidak mahukan sumbangan, dan bahkan mengatakannya dalam README anda. Sebaliknya, jika anda mahukan penyumbang, anda akan meluangkan masa untuk membuat dokumentasi yang jelas dan membuat pendatang baru merasa diterima.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">
  Pada satu ketika saya membuat UIAlertView khusus yang saya gunakan ... dan saya memutuskan untuk menjadikannya sumber terbuka. Oleh itu, saya mengubahnya menjadi lebih dinamik dan memuat naiknya ke GitHub. Saya juga menulis dokumentasi pertama saya yang menerangkan kepada pemaju lain bagaimana menggunakannya pada projek mereka. Mungkin tidak ada yang menggunakannya kerana ini adalah projek yang mudah tetapi saya berasa gembira dengan sumbangan saya.
  <p markdown="1" class="pquote-credit">
— @mavris, ["Self-taught Software Developers: Why Open Source is important to us"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

Semasa projek anda berkembang, komuniti anda mungkin memerlukan lebih daripada sekadar kod dari anda. Menanggapi masalah, mengkaji kod, dan menginjil projek anda adalah semua tugas penting dalam projek sumber terbuka.

Walaupun jumlah masa yang anda habiskan untuk tugas bukan pengekodan bergantung pada ukuran dan ruang lingkup projek anda, anda harus bersedia sebagai penyelenggara untuk mengatasinya sendiri atau mencari seseorang untuk membantu anda.

**Sekiranya anda merupakan sebahagian daripada syarikat yang memperoleh projek terbuka,** pastikan projek anda mempunyai sumber dalaman yang diperlukan untuk berkembang maju. Anda ingin mengenal pasti siapa yang bertanggungjawab untuk mengekalkan projek tersebut selepas pelancaran, dan bagaimana anda akan berkongsi tugas tersebut dengan komuniti anda.

Sekiranya anda memerlukan anggaran atau kakitangan khusus untuk promosi, operasi dan penyelenggaraan projek, mulailah perbincangan tersebut lebih awal.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">
  Semasa anda mula membuka sumber projek, penting untuk memastikan bahawa proses pengurusan anda mengambil kira sumbangan dan kemampuan masyarakat di sekitar projek anda. Jangan takut untuk melibatkan penyumbang yang tidak bekerja dalam perniagaan anda dalam aspek utama projek - terutamanya jika mereka sering menjadi penyumbang.
  <p markdown="1" class="pquote-credit">
— @captainsafia, ["So you wanna open source a project, eh?"](https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779)
  </p>
</aside>

### Menyumbang kepada projek lain

Sekiranya matlamat anda adalah untuk belajar bagaimana berkolaborasi dengan orang lain atau memahami bagaimana sumber terbuka berfungsi, pertimbangkan untuk menyumbang kepada projek yang ada. Mulakan dengan projek yang sudah anda gunakan dan sukai. Menyumbang kepada projek boleh semudah memperbaiki kesalahan ketik atau mengemas kini dokumentasi.

Sekiranya anda tidak pasti cara memulakan sebagai penyumbang, lihat kami [How to Contribute to Open Source guide](../how-to-contribute/).

## Melancarkan projek sumber terbuka anda sendiri

Tidak ada masa yang tepat untuk membuka sumber pekerjaan anda. Anda boleh membuka sumber idea, karya yang sedang berjalan, atau setelah bertahun-tahun menjadi sumber tertutup.

Secara umum, anda harus membuka sumber projek anda apabila anda merasa selesa melihat orang lain, dan memberi maklum balas mengenai kerja anda.

Tidak kira tahap mana anda memutuskan untuk membuka sumber projek anda, setiap projek harus merangkumi dokumentasi berikut:

* [Open source license](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [Contributing guidelines](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [Code of conduct](../code-of-conduct/)

Sebagai penyelenggara, komponen ini akan membantu anda menyampaikan harapan, menguruskan sumbangan, dan melindungi hak undang-undang setiap orang (termasuk milik anda). Mereka meningkatkan peluang anda untuk mendapat pengalaman positif.

Sekiranya projek anda berada di GitHub, meletakkan fail-fail ini di direktori root anda dengan nama fail yang disyorkan akan membantu GitHub mengenali dan memaparkannya secara automatik kepada pembaca anda.

### Memilih lesen

Lesen sumber terbuka menjamin bahawa orang lain dapat menggunakan, menyalin, mengubah suai, dan menyumbang kembali ke projek anda tanpa kesan. Ia juga melindungi anda dari situasi undang-undang yang melekit. **Anda mesti menyertakan lesen semasa melancarkan projek sumber terbuka.**

Kerja undang-undang tidak menyeronokkan. Berita baiknya ialah anda boleh menyalin dan menampal lesen yang ada ke dalam repositori anda. Hanya perlu satu minit untuk melindungi kerja keras anda.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), and [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) adalah lesen sumber terbuka yang paling popular, tetapi[there are other options](https://choosealicense.com) untuk dipilih.

Apabila anda membuat projek baru di GitHub, anda diberi pilihan untuk memilih lesen. Menyertakan lesen sumber terbuka akan menjadikan projek GitHub anda sebagai sumber terbuka.

![Pick a license](/assets/images/starting-a-project/repository-license-picker.png)

Sekiranya anda mempunyai pertanyaan atau kebimbangan lain mengenai aspek undang-undang dalam menguruskan projek sumber terbuka, [we've got you covered](../legal/).

### Menulis README

README melakukan lebih daripada sekadar menjelaskan cara menggunakan projek anda. Mereka juga menjelaskan mengapa projek anda penting, dan apa yang pengguna anda boleh lakukan dengannya.

Dalam README anda, cuba jawab soalan berikut:

* Apa yang dilakukan oleh projek ini?
* Mengapa projek ini berguna?
* Bagaimana saya memulakan?
* Di mana saya boleh mendapatkan lebih banyak pertolongan, jika saya memerlukannya?

Anda boleh menggunakan README anda untuk menjawab soalan lain, seperti bagaimana anda menangani sumbangan, apakah matlamat projek tersebut, dan maklumat mengenai lesen dan atribusi. Sekiranya anda tidak mahu menerima sumbangan, atau projek anda belum siap untuk dihasilkan, tuliskan maklumat ini.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">
  Dokumentasi yang lebih baik bermaksud lebih banyak pengguna, kurang permintaan sokongan, dan lebih banyak penyumbang. (...) Ingat bahawa pembaca anda bukan anda. Ada orang yang mungkin datang ke projek yang mempunyai pengalaman yang sama sekali berbeza.
  <p markdown="1" class="pquote-credit">
— @tracymakes, ["Writing So Your Words Are Read (video)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

Kadang-kadang, orang mengelak daripada menulis README kerana mereka merasa projek ini belum selesai, atau mereka tidak mahu sumbangan. Ini semua adalah alasan yang baik untuk menulisnya.

Untuk lebih banyak inspirasi, cuba gunakan @ dguo's ["Make a README" guide](https://www.makeareadme.com/) or @PurpleBooth's [README template](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2)untuk menulis BACAAN lengkap.

Apabila anda memasukkan fail README dalam direktori root, GitHub akan memaparkannya secara automatik di halaman utama repositori.

### Menulis garis panduan penyumbang anda

Fail CONTRIBUTING memberitahu penonton anda bagaimana untuk mengambil bahagian dalam projek anda. Contohnya, anda mungkin memasukkan maklumat mengenai:

* Cara memfailkan laporan pepijat (try using [issue and pull request templates](https://github.com/blog/2111-issue-and-pull-request-templates))
* Cara mencadangkan ciri baru
* Cara mengatur persekitaran anda dan menjalankan ujian

Sebagai tambahan kepada butiran teknikal, fail CONTRIBUTING adalah peluang untuk menyampaikan harapan anda terhadap sumbangan, seperti:

* Jenis sumbangan yang anda cari
* Peta jalan atau visi anda untuk projek tersebut
* Bagaimana penyumbang seharusnya (atau tidak seharusnya) menghubungi anda

Menggunakan nada yang mesra dan mesra serta memberikan cadangan khusus untuk sumbangan (seperti menulis dokumentasi, atau membuat laman web) dapat membuat pendatang baru merasa disambut dan teruja untuk turut serta.

Sebagai contoh, [Active Admin](https://github.com/activeadmin/activeadmin/) memulai [its contributing guide](https://github.com/activeadmin/activeadmin/blob/HEAD/CONTRIBUTING.md)dengan:

> Pertama, terima kasih kerana mempertimbangkan untuk menyumbang kepada Admin Aktif. Orang seperti anda menjadikan Admin Aktif sebagai alat yang hebat.

Pada peringkat awal projek anda, fail CONTRIBUTING anda boleh dibuat dengan mudah. Anda harus selalu menerangkan cara melaporkan pepijat atau masalah fail, dan sebarang keperluan teknikal (seperti ujian) untuk memberi sumbangan.

Lama kelamaan, anda mungkin menambahkan soalan lain yang sering diajukan ke fail CONTRIBUTING anda. Menulis maklumat ini bermaksud semakin sedikit orang yang akan menanyakan soalan yang sama berulang kali kepada anda.

Untuk lebih banyak bantuan dalam menulis fail CONTRIBUTING anda, lihat@nayafia's [contributing guide template](https://github.com/nayafia/contributing-template/blob/HEAD/CONTRIBUTING-template.md) atau @mozilla's ["How to Build a CONTRIBUTING.md"](https://mozillascience.github.io/working-open-workshop/contributing/).

Pautkan ke fail CONTRIBUTING anda dari README anda, sehingga lebih banyak orang melihatnya. Jika awak [place the CONTRIBUTING file in your project's repository](https://help.github.com/articles/setting-guidelines-for-repository-contributors/),GitHub akan memaut ke fail anda secara automatik apabila penyumbang membuat masalah atau membuka permintaan tarik.

![Contributing guidelines](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### Menetapkan tatakelakuan

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">
  Kita semua mempunyai pengalaman di mana kita menghadapi apa yang mungkin disalahgunakan baik sebagai penyelenggara yang berusaha menjelaskan mengapa sesuatu harus menjadi cara tertentu, atau sebagai pengguna ... mengajukan soalan mudah. (...) Tatakelakuan menjadi dokumen yang mudah dirujuk dan dihubungkan yang menunjukkan bahawa pasukan anda mengambil wacana konstruktif dengan sangat serius.
  <p markdown="1" class="pquote-credit">
— @mlynch, ["Making Open Source a Happier Place"](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

Akhirnya, kod tingkah laku membantu menetapkan peraturan asas untuk tingkah laku bagi peserta projek anda. Ini amat berharga jika anda melancarkan projek sumber terbuka untuk komuniti atau syarikat. Kod tingkah laku memberi kuasa kepada anda untuk memfasilitasi tingkah laku masyarakat yang sihat dan membina, yang akan mengurangkan tekanan anda sebagai penjaga.

Untuk maklumat lebih lanjut, lihat kami [Code of Conduct guide](../code-of-conduct/).

Selain berkomunikasi _how_ anda mengharapkan peserta berkelakuan, kod tingkah laku juga cenderung menggambarkan kepada siapa harapan ini berlaku, ketika berlaku, dan apa yang harus dilakukan jika pelanggaran berlaku.

Sama seperti lesen sumber terbuka, terdapat juga piawaian kod tingkah laku yang muncul, jadi anda tidak perlu menulis sendiri. The[Contributor Covenant](https://contributor-covenant.org/) adalah tatakelakuan drop-in yang digunakan oleh [over 40,000 open source projects](https://www.contributor-covenant.org/adopters), termasuk Kubernetes, Rails, dan Swift. Tidak kira teks yang anda gunakan, anda harus bersiap sedia untuk menegakkan tatakelakuan anda bila perlu.

Tampal teks terus ke fail CODE_OF_CONDUCT di repositori anda. Simpan fail tersebut di direktori root projek anda sehingga mudah dicari, dan pautkan ke sana dari README anda.

## Menamakan dan menjenamakan projek anda

Penjenamaan lebih daripada sekadar logo yang mencolok atau nama projek yang menarik. Ini mengenai bagaimana anda membincangkan projek anda, dan siapa yang anda sampaikan dengan mesej anda.

### Memilih nama yang betul

Pilih nama yang senang diingat dan, idealnya, memberi idea tentang apa yang dilakukan oleh projek itu. Sebagai contoh:

* [Sentry](https://github.com/getsentry/sentry) memantau aplikasi untuk pelaporan kerosakan
* [Thin](https://github.com/macournoyer/thin) adalah pelayan web Ruby yang pantas dan ringkas

Sekiranya anda membina projek yang ada, menggunakan nama mereka sebagai awalan dapat membantu menjelaskan apa yang dilakukan oleh projek anda (contohnya, [node-fetch](https://github.com/bitinn/node-fetch) bawah `window.fetch` ke Node.js).

Pertimbangkan kejelasan di atas semua. Rasa tidak senang, tetapi ingat bahawa beberapa lelucon mungkin tidak diterjemahkan ke budaya lain atau orang yang mempunyai pengalaman berbeza dari anda. Sebilangan pengguna berpotensi anda mungkin merupakan pekerja syarikat: anda tidak mahu membuat mereka tidak selesa apabila mereka harus menjelaskan projek anda di tempat kerja!

### Mengelakkan konflik nama

[Check for open source projects with a similar name](http://ivantomic.com/projects/ospnc/),terutamanya jika anda berkongsi bahasa atau ekosistem yang sama. Sekiranya nama anda bertindih dengan projek sedia ada yang popular, anda mungkin membingungkan khalayak anda.

Sekiranya anda mahukan laman web, pemegang Twitter, atau sifat lain untuk mewakili projek anda, pastikan anda dapat memperoleh nama yang anda mahukan. Sebaik-baiknya, [reserve those names now](https://instantdomainsearch.com/) untuk ketenangan fikiran, walaupun anda belum mahu menggunakannya

Pastikan bahawa nama projek anda tidak melanggar tanda dagangan. Syarikat mungkin meminta anda untuk menghentikan projek anda di kemudian hari, atau bahkan mengambil tindakan undang-undang terhadap anda. Ia tidak sepadan dengan risikonya.

Anda boleh menyemak [WIPO Global Brand Database](http://www.wipo.int/branddb/en/) untuk konflik tanda dagangan. Sekiranya anda berada di syarikat, ini adalah salah satu perkara yang anda miliki [legal team can help you with](../legal/).

Akhirnya, buat carian Google dengan cepat untuk nama projek anda. Adakah orang dapat mencari projek anda dengan mudah? Adakah perkara lain muncul dalam hasil carian yang anda tidak mahu mereka lihat?

### Cara anda menulis (dan kod) juga mempengaruhi jenama anda!

Sepanjang hayat projek anda, anda akan melakukan banyak penulisan: README, tutorial, dokumen komuniti, menanggapi masalah, bahkan mungkin buletin dan senarai surat.

Sama ada dokumentasi rasmi atau e-mel biasa, gaya penulisan anda adalah sebahagian daripada jenama projek anda. Pertimbangkan bagaimana anda dapat menemui audiens anda dan apakah itu nada yang ingin anda sampaikan.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Saya cuba terlibat dengan setiap urutan dalam senarai mel, dan menunjukkan tingkah laku teladan, bersikap baik kepada orang lain, memandang serius masalah mereka dan berusaha untuk membantu secara keseluruhan. Selepas beberapa ketika, orang-orang tidak hanya bertanya, tetapi membantu menjawabnya, dan dengan rasa gembira saya, mereka meniru gaya saya.
  <p markdown="1" class="pquote-credit">
— @janl on [CouchDB](https://github.com/apache/couchdb), ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Menggunakan bahasa yang mesra dan inklusif (seperti "mereka", walaupun merujuk kepada orang bujang) dapat membuat projek anda terasa senang menerima penyumbang baru. Berpeganglah pada bahasa yang mudah, kerana kebanyakan pembaca anda mungkin bukan penutur bahasa Inggeris asli.

Di luar cara anda menulis perkataan, gaya pengekodan anda juga boleh menjadi sebahagian daripada jenama projek anda. [Angular](https://angular.io/guide/styleguide) dan [jQuery](https://contribute.jquery.org/style-guide/js/) adalah dua contoh projek dengan gaya dan garis panduan pengkodan yang ketat.

Anda tidak perlu menulis panduan gaya untuk projek anda semasa anda baru memulakannya, dan anda mungkin merasa senang untuk memasukkan gaya pengkodan yang berbeza ke dalam projek anda pula. Tetapi anda harus menjangkakan bagaimana gaya penulisan dan pengekodan anda dapat menarik atau mencegah pelbagai jenis orang. Peringkat awal projek anda adalah peluang anda untuk menetapkan preseden yang ingin anda lihat.

## Senarai semak pra-pelancaran anda

Bersedia untuk membuka sumber projek anda? Berikut adalah senarai semak untuk membantu. Tandakan semua kotak? Anda sudah bersedia untuk pergi! [Click "publish"](https://help.github.com/articles/making-a-private-repository-public/) dan tepuk punggung.

**Dokumentasi**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    Projek mempunyai fail LICENSE dengan lesen sumber terbuka
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    Projek mempunyai dokumentasi asas (README, CONTRIBUTING, CODE_OF_CONDUCT)
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    Nama itu mudah diingat, memberikan beberapa idea tentang apa yang dilakukan oleh projek itu, dan tidak bertentangan dengan projek yang ada atau melanggar tanda dagang
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    Antrean masalah terkini, dengan isu yang teratur dan dilabel dengan jelas
  </label>
</div>

**Code**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Projek menggunakan konvensyen kod yang konsisten dan fungsi / kaedah / nama pemboleh ubah yang jelas
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Kod tersebut dikomentari dengan jelas, mendokumentasikan niat dan kes-kes kelebihan
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Tidak ada bahan sensitif dalam sejarah semakan, masalah, atau permintaan tarik (misalnya, kata laluan atau maklumat bukan umum lain)
  </label>
</div>

**Orang**

Sekiranya anda seorang individu:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  Anda telah berbincang dengan jabatan undang-undang dan / atau memahami dasar IP dan sumber terbuka syarikat anda (jika anda seorang pekerja di suatu tempat)
  </label>
</div>

Sekiranya anda syarikat atau organisasi:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Anda telah bercakap dengan jabatan undang-undang anda
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Anda mempunyai rancangan pemasaran untuk mengumumkan dan mempromosikan projek tersebut
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Seseorang komited untuk mengurus interaksi masyarakat (menanggapi masalah, mengkaji dan menggabungkan permintaan tarik)
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Sekurang-kurangnya dua orang mempunyai akses pentadbiran ke projek ini
  </label>
</div>

## Kamu lakukan!

Tahniah kerana sumber terbuka projek pertama anda. Tidak kira hasilnya, bekerja di khalayak ramai adalah hadiah untuk masyarakat. Dengan setiap komitmen, komen, dan permintaan tarik, anda mencipta peluang untuk diri sendiri dan orang lain untuk belajar dan berkembang.
