---
lang: ms
title: Kepimpinan dan Pemerintahan
description: Projek sumber terbuka yang berkembang dapat memanfaatkan peraturan formal untuk membuat keputusan.
class: leadership
order: 6
image: /assets/images/cards/leadership.png
related:
  - best-practices
  - metrics
---

## Memahami tadbir urus untuk projek anda yang sedang berkembang

Projek anda berkembang, orang terlibat, dan anda komited untuk memastikan perkara ini berjalan. Pada tahap ini, anda mungkin tertanya-tanya bagaimana memasukkan penyumbang projek biasa ke dalam aliran kerja anda, sama ada memberi seseorang akses atau menyelesaikan perbahasan masyarakat. Sekiranya anda mempunyai soalan, kami mempunyai jawapan.

## Apa contoh peranan formal yang digunakan dalam projek sumber terbuka?

Banyak projek mengikuti struktur yang serupa untuk peranan dan pengiktirafan penyumbang.

Walaupun begitu, maksud peranan ini sepenuhnya bergantung kepada anda. Berikut adalah beberapa jenis peranan yang mungkin anda kenali:

* **Penyelenggara**
* **Penyumbang**
* **Komersial**

**Untuk beberapa projek, "penyelenggara"** adalah satu-satunya orang dalam projek yang mempunyai akses komit. Dalam projek lain, mereka hanyalah orang yang disenaraikan dalam README sebagai penyelenggara.

Penyelenggara tidak semestinya menjadi seseorang yang menulis kod untuk projek anda. Mungkin seseorang yang telah melakukan banyak pekerjaan menginjil projek anda, atau dokumentasi bertulis yang menjadikan projek ini lebih mudah diakses oleh orang lain. Terlepas dari apa yang mereka lakukan sehari-hari, penyelenggara mungkin adalah seseorang yang merasa bertanggungjawab atas arahan projek dan komited untuk memperbaikinya.

**"Penyumbang" boleh jadi sesiapa sahaja** yang memberi komen mengenai sesuatu isu atau permintaan penarik, orang yang menambah nilai pada projek (sama ada ia mencetuskan masalah, menulis kod, atau menganjurkan acara), atau sesiapa sahaja dengan permintaan tarik gabungan (mungkin definisi penyumbang yang paling sempit).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  \[For Node.js,\] setiap orang yang muncul untuk memberi komen mengenai sesuatu masalah atau menghantar kod adalah anggota komuniti projek. Hanya dapat melihat mereka bermaksud bahawa mereka telah melewati batas dari menjadi pengguna hingga menjadi penyumbang.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Healthy Open Source"](https://medium.com/the-javascript-collection/healthy-open-source-967fa8be7951)
  </p>
</aside>

**Istilah "committer"** mungkin digunakan untuk membezakan akses komit, yang merupakan jenis tanggungjawab tertentu, dari bentuk sumbangan lain.

Walaupun anda dapat menentukan peranan projek anda dengan cara yang anda mahukan, [pertimbangkan untuk menggunakan definisi yang lebih luas](../how-to-contribute/#apa-maksudnya-menyumbang) untuk mendorong lebih banyak bentuk sumbangan. Anda boleh menggunakan peranan kepemimpinan untuk mengenali secara rasmi orang yang telah memberikan sumbangan yang luar biasa untuk projek anda, tanpa mengira kemahiran teknikal mereka.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jacobian?s=180" class="pquote-avatar" alt="avatar">
  Anda mungkin mengenali saya sebagai "penemu" Django ... tetapi sebenarnya saya adalah lelaki yang diupah untuk mengerjakan sesuatu setahun setelah ia dibuat. (...) Orang mengesyaki bahawa saya berjaya kerana kemahiran pengaturcaraan saya ... tetapi saya paling baik rata-rata pengaturcara.
  <p markdown="1" class="pquote-credit">
— @jacobian, ["PyCon 2015 Keynote" (video)](https://www.youtube.com/watch?v=hIJdFxYlEKE#t=5m0s)
  </p>
</aside>

## Bagaimana saya memformalkan peranan kepemimpinan ini?

Memformalkan peranan kepemimpinan anda membantu orang merasakan kepemilikan dan memberitahu ahli komuniti lain yang ingin meminta pertolongan.

Untuk projek yang lebih kecil, menetapkan pemimpin boleh semudah menambahkan nama mereka ke nama anda dalam fail README atau fail CONTRIBUTORS.

Untuk projek yang lebih besar, jika anda mempunyai laman web, buat halaman pasukan atau senaraikan pemimpin projek anda di sana. Sebagai contoh, [Postgres](https://github.com/postgres/postgres/) mempunyai [comprehensive team page](https://www.postgresql.org/community/contributors/) dengan profil pendek untuk setiap penyumbang.

Sekiranya projek anda mempunyai komuniti penyumbang yang sangat aktif, anda mungkin membentuk "pasukan teras" penyelenggara, atau bahkan jawatankuasa kecil orang yang mengambil alih bidang isu yang berbeza (contohnya keselamatan, pencetus masalah, atau tingkah laku masyarakat). Biarkan orang mengatur diri sendiri dan menjadi sukarelawan untuk peranan yang paling mereka gemari, daripada menyerahkannya.

<aside markdown="1" class="pquote">
  \[We\] lengkapkan pasukan teras dengan beberapa "subteam". Setiap subtumpuan difokuskan pada bidang tertentu, misalnya, reka bentuk bahasa atau perpustakaan. (...) Untuk memastikan koordinasi global dan visi yang kuat dan koheren untuk projek secara keseluruhan, setiap subteam diketuai oleh anggota pasukan teras.
  <p markdown="1" class="pquote-credit">
— ["Rust Governance RFC"](https://github.com/rust-lang/rfcs/blob/HEAD/text/1068-rust-governance.md)
  </p>
</aside>

Pasukan kepemimpinan mungkin ingin membuat saluran yang ditentukan (seperti di IRC) atau bertemu secara berkala untuk membincangkan projek tersebut (seperti di Gitter atau Google Hangout). Anda juga boleh membuat perjumpaan itu umum sehingga orang lain dapat mendengar. [Cucumber-ruby](https://github.com/cucumber/cucumber-ruby), sebagai contoh, [hosts office hours every week](https://github.com/cucumber/cucumber-ruby/blob/HEAD/CONTRIBUTING.md#talking-with-other-devs).

Setelah anda menentukan peranan kepemimpinan, jangan lupa untuk mendokumentasikan bagaimana orang dapat mencapainya! Buat proses yang jelas bagaimana seseorang boleh menjadi penyelenggara atau bergabung dengan jawatankuasa kecil dalam projek anda, dan tuliskannya ke dalam GOVERNANCE.md. anda.

Alatan seperti [Vossibility](https://github.com/icecrime/vossibility-stack) dapat membantu anda mengesan secara terbuka siapa (atau tidak) yang menyumbang kepada projek tersebut. Mendokumentasikan maklumat ini mengelakkan persepsi masyarakat bahawa penyelenggara adalah klise yang membuat keputusannya secara tertutup.

Akhirnya, jika projek anda berada di GitHub, pertimbangkan untuk memindahkan projek anda dari akaun peribadi anda ke Organisasi dan tambahkan sekurang-kurangnya satu pentadbir sandaran. [GitHub Organizations](https://help.github.com/articles/creating-a-new-organization-account/)mempermudah untuk menguruskan kebenaran dan beberapa repositori dan melindungi warisan projek anda melalui [pemilikan bersama](../building-community/#kongsi-pemilikan-projek-anda).

## Bilakah saya harus memberikan akses kepada seseorang?

Sebilangan orang berpendapat bahawa anda harus memberikan akses kepada semua orang yang memberikan sumbangan. Melakukannya dapat mendorong lebih banyak orang merasakan pemilikan projek anda.

Sebaliknya, terutamanya untuk projek yang lebih besar dan lebih kompleks, anda mungkin hanya ingin memberikan akses kepada orang yang telah menunjukkan komitmen mereka. Tidak ada cara yang betul untuk melakukannya - lakukan perkara yang membuat anda paling selesa!

Sekiranya projek anda berada di GitHub, anda boleh menggunakannya [protected branches](https://help.github.com/articles/about-protected-branches/) untuk menguruskan siapa yang boleh mendorong ke cabang tertentu, dan dalam keadaan apa.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/felixge?s=180" class="pquote-avatar" alt="avatar">
  Setiap kali seseorang menghantar permintaan tarikan kepada anda, berikan mereka akses ke projek anda. Walaupun mungkin terdengar sangat bodoh pada mulanya, menggunakan strategi ini akan membolehkan anda melepaskan kekuatan sebenar GitHub. (...) Setelah orang membuat akses, mereka tidak lagi khawatir tambalan mereka tidak digabungkan ... menyebabkan mereka meletakkan lebih banyak pekerjaan ke dalamnya.
  <p markdown="1" class="pquote-credit">
— @felixge, ["The Pull Request Hack"](https://felixge.de/2013/03/11/the-pull-request-hack.html)
  </p>
</aside>

## Apa saja struktur pemerintahan biasa untuk projek sumber terbuka?

Terdapat tiga struktur pemerintahan bersama yang berkaitan dengan projek sumber terbuka.

* **BDFL:** BDFL bermaksud "Benevolent Dictator for Life". Di bawah struktur ini, satu orang (biasanya penulis awal projek) mempunyai pendapat akhir mengenai semua keputusan projek utama.[Python](https://github.com/python) adalah contoh klasik. Projek yang lebih kecil mungkin BDFL secara lalai, kerana hanya ada satu atau dua penyelenggara. Projek yang berasal dari syarikat mungkin juga termasuk dalam kategori BDFL.

* **Meritokrasi:** **(Catatan: istilah "meritokrasi" membawa konotasi negatif bagi beberapa komuniti dan mempunyai [complex social and political history](http://geekfeminism.wikia.com/wiki/Meritocracy).)** Di bawah meritokrasi, penyumbang projek aktif (mereka yang menunjukkan "prestasi") diberi peranan membuat keputusan secara rasmi. Keputusan biasanya dibuat berdasarkan konsensus suara yang murni. Konsep meritokrasi dipelopori oleh [Apache Foundation](https://www.apache.org/); [all Apache projects](https://www.apache.org/index.html#projects-list)adalah meritokrasi. Sumbangan hanya boleh dibuat oleh individu yang mewakili diri mereka sendiri, bukan oleh syarikat.

* **Sumbangan liberal:** Di bawah model sumbangan liberal, orang yang melakukan kerja paling banyak diakui sebagai yang paling berpengaruh, tetapi ini berdasarkan karya semasa dan bukan sumbangan bersejarah. Keputusan projek utama dibuat berdasarkan proses mencari konsensus (membincangkan rungutan utama) dan bukannya suara murni, dan berusaha untuk memasukkan sebanyak mungkin perspektif masyarakat. Contoh popular projek yang menggunakan model sumbangan liberal termasuk [Node.js](https://foundation.nodejs.org/) dan [Rust](https://www.rust-lang.org/).

Yang mana yang harus anda gunakan? Terpulang pada anda! Setiap model mempunyai kelebihan dan pertukaran. Dan walaupun pada awalnya mereka kelihatan agak berbeza, ketiga-tiga model mempunyai lebih banyak persamaan daripada yang kelihatan. Sekiranya anda berminat untuk menggunakan salah satu model ini, lihat templat ini:

* [BDFL model template](http://oss-watch.ac.uk/resources/benevolentdictatorgovernancemodel)
* [Meritocracy model template](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel)
* [Node.js's liberal contribution policy](https://medium.com/the-node-js-collection/healthy-open-source-967fa8be7951)

## Adakah saya memerlukan dokumen tadbir urus semasa melancarkan projek saya?

Tidak ada masa yang tepat untuk menuliskan urus tadbir projek anda, tetapi lebih mudah untuk ditentukan setelah anda melihat dinamika komuniti anda berjalan. Bahagian terbaik (dan paling sukar) mengenai pemerintahan sumber terbuka adalah ia dibentuk oleh masyarakat!

Beberapa dokumentasi awal pasti akan menyumbang kepada tadbir urus projek anda, jadi mulailah menuliskan apa yang anda boleh. Sebagai contoh, anda dapat menentukan harapan yang jelas untuk tingkah laku, atau bagaimana proses penyumbang anda berfungsi, walaupun pada pelancaran projek anda.

Sekiranya anda merupakan sebahagian daripada syarikat yang melancarkan projek sumber terbuka, ada baiknya anda mengadakan perbincangan dalaman sebelum melancarkan bagaimana syarikat anda mengharapkan untuk mengekalkan dan membuat keputusan mengenai projek tersebut ke hadapan. Anda juga mungkin ingin menerangkan secara terbuka sesuatu yang khusus mengenai bagaimana syarikat anda (atau tidak akan) terlibat dengan projek ini.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/caabernathy?s=180" class="pquote-avatar" alt="avatar">
  Kami menugaskan pasukan kecil untuk menguruskan projek di GitHub yang sebenarnya mengusahakannya di Facebook. Contohnya, React dikendalikan oleh jurutera React.
  <p markdown="1" class="pquote-credit">
— @caabernathy, ["An inside look at open source at Facebook"](https://opensource.com/life/15/10/ato-interview-christine-abernathy-facebook)
  </p>
</aside>

## Apa yang berlaku sekiranya pekerja korporat mula menghantar sumbangan?

Projek sumber terbuka yang berjaya digunakan oleh banyak orang dan syarikat, dan beberapa syarikat akhirnya mempunyai aliran pendapatan yang akhirnya terikat dengan projek tersebut. Sebagai contoh, syarikat boleh menggunakan kod projek sebagai salah satu komponen dalam penawaran perkhidmatan komersial.

Oleh kerana projek ini semakin banyak digunakan, orang yang mempunyai kepakaran di dalamnya menjadi lebih banyak permintaan - anda mungkin salah satunya! - dan kadangkala akan dibayar untuk pekerjaan yang mereka lakukan dalam projek tersebut.

Penting untuk memperlakukan aktiviti komersial seperti biasa dan sebagai sumber tenaga pembangunan yang lain. Pembangun berbayar tidak semestinya mendapat layanan istimewa berbanding yang belum dibayar, tentu saja; setiap sumbangan mesti dinilai berdasarkan kelebihan teknikalnya. Namun, orang harus merasa senang terlibat dalam kegiatan komersial, dan merasa selesa menyatakan kes penggunaannya ketika berdebat untuk memihak kepada peningkatan atau ciri tertentu.

"Komersial" sepenuhnya serasi dengan "sumber terbuka". "Komersial" bermaksud ada wang yang terlibat di suatu tempat - perisian itu digunakan dalam perdagangan, yang semakin besar kemungkinan apabila projek mendapat penerapan. (Apabila perisian sumber terbuka digunakan sebagai bagian dari produk sumber bukan terbuka, produk keseluruhan masih merupakan perisian "proprietari", namun, seperti sumber terbuka, ia mungkin digunakan untuk tujuan komersial atau bukan komersial.)

Seperti orang lain, pemaju yang bermotivasi komersial mendapat pengaruh dalam projek melalui kualiti dan kuantiti sumbangan mereka. Jelas sekali, pembangun yang dibayar untuk waktunya mungkin dapat melakukan lebih banyak daripada seseorang yang tidak dibayar, tetapi tidak mengapa: pembayaran adalah salah satu daripada banyak kemungkinan faktor yang boleh mempengaruhi berapa banyak yang dilakukan seseorang. Pastikan perbincangan projek anda tertumpu pada sumbangan, bukan pada faktor luaran yang membolehkan orang membuat sumbangan tersebut.

## Adakah saya memerlukan entiti undang-undang untuk menyokong projek saya?

Anda tidak memerlukan entiti undang-undang untuk menyokong projek sumber terbuka anda kecuali anda mengendalikan wang.

Contohnya, jika anda ingin membuat perniagaan komersial, anda boleh menubuhkan C Corp atau LLC (jika anda berpusat di AS). Sekiranya anda hanya membuat kerja kontrak yang berkaitan dengan projek sumber terbuka anda, anda boleh menerima wang sebagai pemilik tunggal, atau menubuhkan LLC (jika anda berpusat di AS).

Sekiranya anda ingin menerima sumbangan untuk projek sumber terbuka anda, anda boleh menyiapkan butang derma (misalnya menggunakan PayPal atau Stripe), tetapi wang tersebut tidak akan ditolak cukai melainkan anda bukan untung yang layak (501c3, jika anda berada di AS).

Sebilangan besar projek tidak mahu mengalami masalah untuk menubuhkan organisasi bukan untung, jadi mereka mencari penaja fiskal bukan untung. Penaja fiskal menerima sumbangan bagi pihak anda, biasanya sebagai pertukaran untuk peratusan sumbangan. [Software Freedom Conservancy](https://sfconservancy.org/), [Apache Foundation](https://www.apache.org/), [Eclipse Foundation](https://eclipse.org/org/foundation/), [Linux Foundation](https://www.linuxfoundation.org/projects) dan [Open Collective](https://opencollective.com/opensource)adalah contoh organisasi yang berfungsi sebagai penaja fiskal untuk projek sumber terbuka.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/piamancini?s=180" class="pquote-avatar" alt="avatar">
  Matlamat kami adalah untuk menyediakan infrastruktur yang dapat digunakan oleh masyarakat agar dapat bertahan hidup, sehingga mewujudkan persekitaran di mana setiap orang - penyumbang, penyokong, penaja - mendapat manfaat konkrit daripadanya.
  <p markdown="1" class="pquote-credit">
— @piamancini, ["Moving beyond the charity framework"](https://medium.com/open-collective/moving-beyond-the-charity-framework-b1191c33141)
  </p>
</aside>

Sekiranya projek anda berkait rapat dengan bahasa atau ekosistem tertentu, mungkin ada asas perisian berkaitan yang boleh anda bekerjasama. Sebagai contoh, [Python Software Foundation](https://www.python.org/psf/) menolong menyokong[PyPI](https://pypi.org/), pengurus pakej Python, dan [Node.js Foundation](https://foundation.nodejs.org/) menolong menyokong [Express.js](https://expressjs.com/), rangka kerja berasaskan Node.
