---
lang: ms
title: Mendapat Bayaran untuk Kerja Sumber Terbuka
description: Pertahankan kerja anda dalam sumber terbuka dengan mendapatkan sokongan kewangan untuk masa atau projek anda.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Mengapa sebilangan orang meminta sokongan kewangan

Sebilangan besar kerja sumber terbuka adalah sukarela. Sebagai contoh, seseorang mungkin menemui bug dalam projek yang mereka gunakan dan mengirimkan perbaikan cepat, atau mereka mungkin senang bermain-main dengan projek sumber terbuka di masa lapang mereka.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Saya mencari projek pengaturcaraan "hobi" yang akan membuat saya sibuk sepanjang minggu sekitar Krismas. (...) Saya mempunyai komputer di rumah, dan tidak banyak yang lain di tangan saya. Saya memutuskan untuk menulis jurubahasa untuk bahasa skrip baru yang saya fikirkan akhir-akhir ini. (...) Saya memilih Python sebagai tajuk kerja.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Terdapat banyak sebab mengapa seseorang tidak mahu dibayar untuk pekerjaan sumber terbuka mereka.

* **Mereka mungkin sudah mempunyai pekerjaan sepenuh masa yang mereka sukai,** yang membolehkan mereka menyumbang kepada sumber terbuka pada masa lapang.
* **Mereka gemar memikirkan sumber terbuka sebagai hobi** atau melarikan diri secara kreatif dan tidak ingin merasa berkewajiban dari segi kewangan untuk mengerjakan projek mereka.
* **Mereka mendapat faedah lain dari memberikan sumbangan kepada sumber terbuka,** seperti membangun reputasi atau portfolio mereka, mempelajari kemahiran baru, atau merasa lebih dekat dengan komuniti.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Sumbangan kewangan menambah rasa tanggungjawab, bagi sebilangan orang. (...) Penting bagi kita, di dunia yang serentak dengan dunia pantas, di mana kita hidup, untuk dapat mengatakan "tidak sekarang, saya merasa seperti melakukan sesuatu yang sama sekali berbeza".
  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Bagi yang lain, terutamanya ketika sumbangan sedang berlangsung atau memerlukan masa yang besar, bayaran untuk menyumbang kepada sumber terbuka adalah satu-satunya cara mereka dapat mengambil bahagian, sama ada kerana projek itu memerlukannya, atau atas sebab peribadi.

Menyelenggara projek popular boleh menjadi tanggungjawab yang besar, memakan masa 10 atau 20 jam seminggu dan bukannya beberapa jam sebulan.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Tanya mana-mana penyelenggara projek sumber terbuka, dan mereka akan memberitahu anda mengenai realiti jumlah kerja yang diperlukan untuk menguruskan projek. Anda mempunyai pelanggan. Anda sedang menyelesaikan masalah untuknya. Anda membuat ciri baru. Ini menjadi permintaan sebenar pada masa anda.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Pekerjaan bergaji juga membolehkan orang dari pelbagai lapisan masyarakat memberikan sumbangan yang bermakna. Sebilangan orang tidak mampu meluangkan masa yang belum dibayar untuk projek sumber terbuka, berdasarkan kedudukan kewangan semasa, hutang, atau keluarga atau kewajipan menjaga mereka yang lain. Ini bermakna dunia tidak pernah melihat sumbangan daripada orang-orang berbakat yang tidak dapat meluangkan masa mereka secara sukarela. Ini mempunyai implikasi etika, seperti @ashedryden [has described](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), kerana pekerjaan yang dilakukan berat sebelah memihak kepada mereka yang sudah mempunyai kelebihan dalam hidup, yang kemudian memperoleh kelebihan tambahan berdasarkan sumbangan sukarelawan mereka, sementara yang lain yang tidak dapat menjadi sukarelawan kemudian tidak mendapat peluang kemudian, yang memperkuat saat ini kekurangan kepelbagaian dalam komuniti sumber terbuka.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   OSS memberikan faedah besar kepada industri teknologi, yang pada gilirannya, memberi manfaat kepada semua industri. (...) Namun, jika satu-satunya orang yang dapat memusatkan perhatiannya adalah orang yang beruntung dan yang taksub, maka ada potensi yang belum dimanfaatkan.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Sekiranya anda mencari sokongan kewangan, ada dua jalan yang perlu dipertimbangkan. Anda boleh membiayai masa anda sendiri sebagai penyumbang, atau anda dapat mencari dana organisasi untuk projek tersebut.

## Membiayai masa anda sendiri

Hari ini, banyak orang dibayar untuk bekerja secara sambilan atau sepenuh masa di sumber terbuka. Cara yang paling biasa untuk dibayar untuk masa anda adalah dengan berbincang dengan majikan anda.

Lebih mudah untuk membuat kes untuk kerja sumber terbuka jika majikan anda benar-benar menggunakan projek ini, tetapi kreatif dengan usaha anda. Mungkin majikan anda tidak menggunakan projek itu, tetapi mereka menggunakan Python, dan mengekalkan projek Python yang popular membantu menarik pemaju Python baru. Mungkin itu menjadikan majikan anda kelihatan lebih mesra pemaju secara amnya.

Sekiranya anda tidak mempunyai projek sumber terbuka yang sedia ada, anda ingin mengusahakannya, tetapi lebih suka bahawa hasil kerja anda sekarang bersumber terbuka, buatlah majikan anda membuka sumber perisian dalaman mereka.

Banyak syarikat sedang mengembangkan program sumber terbuka untuk membina jenama mereka dan merekrut bakat berkualiti.

@hueniverse, misalnya, mendapati bahawa ada alasan kewangan untuk membenarkannya [Walmart's investment in open source](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). Dan @jamesgpearce mendapati bahawa program sumber terbuka Facebook [made a difference](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) dalam merekrut:

> Ini sejalan dengan budaya penggodam kami, dan bagaimana organisasi kami dirasakan. Kami bertanya kepada pekerja kami, "Adakah anda mengetahui program perisian sumber terbuka di Facebook?". Dua pertiga berkata "Ya". Separuh mengatakan bahawa program ini memberi sumbangan positif kepada keputusan mereka untuk bekerja untuk kita. Ini bukan angka marginal, dan saya harap, trend yang berterusan.

Sekiranya syarikat anda melalui laluan ini, penting untuk menjaga batas antara aktiviti komuniti dan syarikat. Pada akhirnya, sumber terbuka mempertahankan dirinya melalui sumbangan daripada orang di seluruh dunia, dan itu lebih besar daripada satu syarikat atau lokasi mana pun.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Mendapat gaji untuk bekerja di sumber terbuka adalah peluang yang jarang dan luar biasa, tetapi anda tidak harus melepaskan semangat anda dalam proses ini. Kesungguhan anda adalah mengapa syarikat mahu membayar anda.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Sekiranya anda tidak dapat meyakinkan majikan anda untuk memprioritaskan pekerjaan sumber terbuka, pertimbangkan untuk mencari majikan baru yang mendorong sumbangan pekerja kepada sumber terbuka. Cari syarikat yang membuat dedikasi mereka untuk kerja sumber terbuka secara eksplisit. Sebagai contoh:

* Beberapa syarikat, seperti [Netflix](https://netflix.github.io/), mempunyai laman web yang menonjolkan penglibatan mereka dalam sumber terbuka
* [Zalando](https://opensource.zalando.com) menerbitkannya [open source contribution policy](https://opensource.zalando.com/docs/using/contributing/) untuk pekerja

Projek yang berasal dari syarikat besar, seperti [Go](https://github.com/golang) atau [React](https://github.com/facebook/react), kemungkinan juga akan menggaji orang untuk bekerja di sumber terbuka.

Bergantung pada keadaan peribadi anda, anda boleh mencuba mengumpulkan wang secara bebas untuk membiayai kerja sumber terbuka anda. Sebagai contoh:

* @Homebrew (and [many other maintainers and organizations](https://github.com/sponsors/community)) fund their work through [GitHub Sponsors](https://github.com/sponsors)
* @gaearon membiayai kerjanya [Redux](https://github.com/reactjs/redux) melalui [Patreon crowdfunding campaign](https://redux.js.org/)
* @andrewgodwin membiayai kerja migrasi skema Django [through a Kickstarter campaign](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

Akhirnya, kadang-kadang projek sumber terbuka memberi banyak manfaat kepada masalah yang mungkin anda pertimbangkan untuk membantu.

* @ConnorChristie dapat dibayar[helping](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol berfungsi di perpustakaan JavaScript mereka [through a bounty on gitcoin](https://gitcoin.co/).
* @mamiM melakukan terjemahan Jepun untuk @MetaMask selepas [issue was funded on Bounties Network](https://explorer.bounties.network/bounty/134).

## Mencari dana untuk projek anda

Di luar pengaturan untuk penyumbang individu, kadang-kadang projek mengumpulkan wang dari syarikat, individu, atau yang lain untuk membiayai kerja yang sedang berjalan.

Pembiayaan organisasi mungkin dilakukan untuk membayar penyumbang semasa, meliputi kos menjalankan projek (seperti biaya hosting), atau melabur ke dalam ciri atau idea baru.

Apabila populariti sumber terbuka meningkat, mencari dana untuk projek masih eksperimen, tetapi ada beberapa pilihan umum yang tersedia.

### Kumpulkan wang untuk pekerjaan anda melalui kempen crowdfunding atau tajaan

Mencari tajaan berfungsi dengan baik jika anda sudah mempunyai khalayak atau reputasi yang kuat, atau projek anda sangat popular.
Beberapa contoh projek yang ditaja termasuk:

* **[webpack](https://github.com/webpack)** raises money from companies and individuals [through OpenCollective](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** organisasi bukan untung yang membayar untuk bekerja [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), dan projek infrastruktur Ruby yang lain

### Buat aliran pendapatan

Bergantung pada projek anda, anda mungkin dapat mengenakan bayaran untuk sokongan komersial, pilihan yang dihoskan, atau ciri tambahan. Beberapa contoh termasuk:

* **[Sidekiq](https://github.com/mperham/sidekiq)** menawarkan versi berbayar untuk sokongan tambahan
* **[Travis CI](https://github.com/travis-ci)** menawarkan versi berbayar produknya
* **[Ghost](https://github.com/TryGhost/Ghost)** is a nonprofit with a paid managed service

Beberapa projek popular, seperti [npm](https://github.com/npm/cli) and [Docker](https://github.com/docker/docker),malah mengumpulkan modal teroka untuk menyokong pertumbuhan perniagaan mereka.

### Memohon pembiayaan geran

Beberapa yayasan dan syarikat perisian menawarkan geran untuk kerja sumber terbuka. Kadang kala, geran boleh dibayar kepada individu tanpa menubuhkan entiti undang-undang untuk projek tersebut.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** menerima geran dari [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* **[OpenMRS](https://github.com/openmrs)**kerja dibiayai oleh[Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** menerima geran dari[Sloan Foundation](https://sloan.org/programs/digital-technology)
* The **[Python Software Foundation](https://www.python.org/psf/grants/)** offers grants for Python-related work

Untuk pilihan dan kajian kes yang lebih terperinci, @nayafia [wrote a guide](https://github.com/nayafia/lemonade-stand) mendapat bayaran untuk kerja sumber terbuka. Jenis pembiayaan yang berbeza memerlukan kemahiran yang berbeza, jadi pertimbangkan kekuatan anda untuk mengetahui pilihan mana yang paling sesuai untuk anda.

## Membangun kes untuk sokongan kewangan

Sama ada projek anda adalah idea baru, atau sudah ada selama bertahun-tahun, anda harus meletakkan pemikiran penting untuk mengenal pasti sasaran anda dan membuat kes yang menarik.

Sama ada anda ingin membayar untuk masa anda sendiri, atau mengumpul dana untuk projek, anda seharusnya dapat menjawab soalan berikut.

### Kesan

Mengapa projek ini berguna? Mengapa pengguna anda, atau calon pengguna, sangat menyukainya? Di mana ia akan berada dalam lima tahun?

### Daya tarikan

Cuba kumpulkan bukti bahawa projek anda penting, sama ada metrik, anekdot, atau testimoni. Adakah terdapat syarikat atau orang terkenal yang menggunakan projek anda sekarang? Sekiranya tidak, adakah orang ternama menyokongnya?

### Nilai untuk pengembara

Pemberi dana, sama ada majikan anda atau yayasan pemberian dana, sering didekati dengan peluang. Mengapa mereka harus menyokong projek anda berbanding peluang lain? Bagaimana mereka mendapat keuntungan secara peribadi?

### Penggunaan dana

Apa sebenarnya yang akan anda capai dengan dana yang dicadangkan? Fokus pada pencapaian projek atau hasil daripada membayar gaji.

### Bagaimana anda akan menerima dana

Adakah pemegang dana mempunyai keperluan sekitar pengeluaran? Sebagai contoh, anda mungkin perlu menjadi bukan untung atau mempunyai penaja fiskal bukan untung. Atau mungkin dana mesti diberikan kepada kontraktor individu dan bukannya organisasi. Keperluan ini berbeza antara pemberi dana, jadi pastikan anda melakukan penyelidikan terlebih dahulu.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  Selama bertahun-tahun, kami menjadi sumber utama ikon mesra laman web, dengan komuniti lebih daripada 20 juta orang dan telah dipaparkan di lebih daripada 70 juta laman web, termasuk Whitehouse.gov. (...) Versi 4 adalah tiga tahun yang lalu. Teknologi laman web telah banyak berubah sejak itu, dan terus terang, Font Awesome semakin basi. (...) Itulah sebabnya kami memperkenalkan Font Awesome 5. Kami memodenkan dan menulis semula CSS dan merancang semula setiap ikon dari atas ke bawah. Kami bercakap reka bentuk yang lebih baik, konsistensi yang lebih baik, dan mudah dibaca.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Eksperimen dan jangan menyerah

Mengumpulkan wang tidak mudah, sama ada anda projek sumber terbuka, bukan untung, atau permulaan perisian, dan dalam kebanyakan kes memerlukan anda untuk kreatif. Mengenal pasti bagaimana anda mahu dibayar, melakukan penyelidikan anda, dan meletakkan diri anda di kasut penyokong anda akan membantu anda membina kes pembiayaan yang meyakinkan.
