---
lang: ms
title: Mencari Pengguna untuk Projek Anda
description: Bantu projek sumber terbuka anda berkembang dengan mendapatkannya di tangan pengguna yang gembira.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Menyebarkan berita

Tidak ada peraturan yang mengatakan bahawa anda harus mempromosikan projek sumber terbuka semasa anda melancarkan. Terdapat banyak alasan yang memuaskan untuk bekerja di sumber terbuka yang tidak ada kaitan dengan populariti. Daripada berharap orang lain mencari dan menggunakan projek sumber terbuka anda, anda harus menyebarkan berita mengenai kerja keras anda!

## Cari tahu mesej anda

Sebelum anda memulakan kerja mempromosikan projek anda, anda seharusnya dapat menjelaskan apa yang dilakukannya dan mengapa ia penting.

Apa yang menjadikan projek anda berbeza atau menarik? Mengapa anda membuatnya? Menjawab soalan-soalan ini untuk diri sendiri akan membantu anda menyampaikan kepentingan projek anda.

Ingatlah bahawa orang terlibat sebagai pengguna, dan akhirnya menjadi penyumbang, kerana projek anda menyelesaikan masalah bagi mereka. Semasa anda memikirkan mesej dan nilai projek anda, cubalah melihatnya melalui apa yang diinginkan oleh pengguna dan penyumbang.

Sebagai contoh, @robb menggunakan contoh kod untuk menyampaikan dengan jelas mengapa projeknya, [Cartography](https://github.com/robb/Cartography), berguna:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Untuk mengetahui lebih mendalam mengenai pemesejan, periksa Mozilla["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/)latihan untuk mengembangkan personaliti pengguna.

## Bantu orang mencari dan mengikuti projek anda

<aside markdown="1" class="pquote">
  Anda semestinya memerlukan satu URL "home" yang boleh anda promosikan dan arahkan orang berkaitan dengan projek anda. Anda tidak perlu memaparkan templat mewah atau bahkan nama domain, tetapi projek anda memerlukan titik fokus.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Bantu orang mencari dan mengingati projek anda dengan menunjukkan mereka ke satu ruang nama.

**Mempunyai pegangan yang jelas untuk mempromosikan karya anda.** Pegangan Twitter, URL GitHub, atau saluran IRC adalah cara mudah untuk mengarahkan orang ke projek anda. Kedai-kedai ini juga memberi tempat kepada komuniti yang sedang berkembang untuk bersidang.

Sekiranya anda belum mahu menyediakan kedai untuk projek anda, promosikan pegangan Twitter atau GitHub anda sendiri dalam semua yang anda lakukan. Mempromosikan pegangan Twitter atau GitHub anda akan memberi tahu orang bagaimana menghubungi anda atau mengikuti kerja anda. Sekiranya anda bercakap di perjumpaan atau acara, pastikan maklumat hubungan anda disertakan dalam bio atau slaid anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Kesalahan yang saya buat pada hari-hari awal (...) tidak memulakan akaun Twitter untuk projek tersebut. Twitter adalah kaedah terbaik untuk membuat orang sentiasa mengetahui tentang sesuatu projek dan juga sentiasa memberi pendedahan kepada orang tentang projek tersebut.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Pertimbangkan untuk membuat laman web untuk projek anda.** Laman web menjadikan projek anda lebih mesra dan lebih mudah dilayari, terutama jika dipasangkan dengan dokumentasi dan tutorial yang jelas. Mempunyai laman web juga menunjukkan bahawa projek anda aktif yang akan membuatkan penonton anda merasa lebih selesa menggunakannya. Berikan contoh untuk memberi idea kepada orang ramai tentang cara menggunakan projek anda.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), pencipta bersama Django, mengatakan bahawa laman web adalah _"sejauh ini adalah perkara terbaik yang kami lakukan dengan Django pada masa awal"_.

Sekiranya projek anda dihoskan di GitHub, anda boleh menggunakan [GitHub Pages](https://pages.github.com/) untuk membuat laman web dengan mudah. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), dan [Middleman](https://middlemanapp.com/) ialah [a few examples](https://github.com/showcases/github-pages-examples) laman web yang sangat baik dan komprehensif.

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

Sekarang kerana anda mempunyai mesej untuk projek anda, dan cara mudah bagi orang lain untuk mencari projek anda, mari keluar ke sana dan berbincang dengan khalayak anda!

## Pergi ke tempat penonton projek anda (dalam talian)

Jangkauan dalam talian adalah kaedah terbaik untuk berkongsi dan menyebarkan berita dengan cepat. Dengan menggunakan saluran dalam talian, anda berpotensi menjangkau khalayak yang sangat luas.

Manfaatkan komuniti dan platform dalam talian yang ada untuk menjangkau khalayak anda. Sekiranya projek sumber terbuka anda adalah projek perisian, anda mungkin dapat mencari khalayak anda [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), or [Quora](https://www.quora.com/).Cari saluran di mana anda fikir orang akan mendapat banyak faedah atau teruja dengan kerja anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
 Setiap program mempunyai fungsi yang sangat spesifik yang hanya berguna bagi sebahagian pengguna. Jangan spam sebanyak mungkin orang. Sebaliknya, sasarkan usaha anda kepada komuniti yang akan mendapat manfaat daripada mengetahui tentang projek anda.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Lihat apakah anda dapat mencari cara untuk berkongsi projek anda dengan cara yang relevan:

* **Kenali projek dan komuniti sumber terbuka yang relevan.** Kadang kala, anda tidak perlu mempromosikan projek anda secara langsung. Sekiranya projek anda sesuai untuk saintis data yang menggunakan Python, kenali komuniti sains data Python. Apabila orang mengenali anda, peluang semula jadi akan timbul untuk membincangkan dan berkongsi kerja anda.
* **Cari orang yang mengalami masalah yang diselesaikan oleh projek anda.** Cari melalui forum yang berkaitan untuk orang yang menjadi sasaran khalayak projek anda. Jawab soalan mereka dan cari cara yang bijaksana, bila sesuai, untuk mencadangkan projek anda sebagai jalan penyelesaian.
* **Minta maklum balas.** Perkenalkan diri anda dan karya anda kepada penonton yang menganggapnya relevan dan menarik. Jadilah spesifik mengenai siapa yang anda fikir akan mendapat manfaat daripada projek anda. Cuba selesaikan ayat: _"Saya rasa projek saya akan benar-benar membantu X, yang berusaha melakukan Y_". Dengarkan dan balas maklum balas orang lain, bukan sekadar mempromosikan karya anda.

Secara umumnya, fokus menolong orang lain sebelum meminta sesuatu sebagai balasan. Kerana sesiapa sahaja dapat mempromosikan projek dalam talian dengan mudah, akan ada banyak kebisingan. Untuk menonjol dari orang ramai, beri orang konteks untuk siapa anda dan bukan hanya yang anda mahukan.

Sekiranya tidak ada yang memberi perhatian atau menanggapi jangkauan awal anda, jangan putus asa! Sebilangan besar pelancaran projek adalah proses berulang yang boleh memakan masa berbulan-bulan atau bertahun-tahun. Sekiranya anda tidak mendapat sambutan pada kali pertama, cubalah taktik lain, atau cari cara untuk menambah nilai pekerjaan orang lain terlebih dahulu. Mempromosikan dan melancarkan projek anda memerlukan masa dan dedikasi.

## Pergi ke tempat penonton projek anda (luar talian)

![Public speaking](/assets/images/finding-users/public_speaking.jpg)

Acara luar talian adalah kaedah popular untuk mempromosikan projek baru kepada khalayak. Mereka adalah kaedah yang baik untuk menjangkau khalayak yang terlibat dan membina hubungan manusia yang lebih mendalam, terutamanya jika anda berminat untuk menjangkau pembangun.

Jika anda [new to public speaking](https://speaking.io/), mulakan dengan mencari pertemuan tempatan yang berkaitan dengan bahasa atau ekosistem projek anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Saya agak gementar pergi ke PyCon. Saya memberi ceramah, saya hanya akan mengetahui beberapa orang di sana, saya akan pergi selama seminggu. (...) Saya tidak seharusnya risau. PyCon sangat hebat! (...) Semua orang sangat ramah dan ramah, sehinggakan saya jarang mendapat masa untuk tidak bercakap dengan orang!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Sekiranya anda tidak pernah bercakap di acara sebelumnya, adalah normal untuk merasa gementar! Ingatlah bahawa khalayak anda hadir kerana mereka benar-benar ingin mendengar tentang karya anda.

Semasa anda menulis ceramah anda, tumpukan perhatian kepada perkara yang menarik dan menarik perhatian penonton anda. Pastikan bahasa anda mesra dan mudah didekati. Senyum, bernafas, dan bersenang-senang.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Apabila anda mula menulis ceramah anda, tidak kira apa topik anda, ia dapat membantu sekiranya anda melihat perbincangan anda sebagai cerita yang anda sampaikan kepada orang lain.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Apabila anda merasa bersedia, pertimbangkan untuk bercakap di persidangan untuk mempromosikan projek anda. Persidangan dapat membantu anda menjangkau lebih banyak orang, kadang-kadang dari seluruh dunia.

Cari persidangan yang khusus untuk bahasa atau ekosistem anda. Sebelum anda menyampaikan ceramah anda, selidiki persidangan untuk menyesuaikan ceramah anda untuk hadirin dan tingkatkan peluang anda untuk diterima untuk bercakap di persidangan. Anda sering dapat mengetahui penonton anda dengan melihat penceramah persidangan.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Saya menulis dengan sangat baik kepada orang-orang JSConf dan meminta mereka memberi saya slot di mana saya dapat membentangkannya di JSConf EU. (...) Saya sangat takut, menunjukkan perkara ini yang telah saya kerjakan selama enam bulan. (...) Sepanjang masa saya hanya berfikir, ya Tuhan. Apa yang saya buat di sini?
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Membangun reputasi

Sebagai tambahan kepada strategi yang dinyatakan di atas, cara terbaik untuk mengajak orang untuk berkongsi dan menyumbang kepada projek anda adalah dengan berkongsi dan menyumbang kepada projek mereka.

Membantu pendatang baru, berkongsi sumber, dan memberikan sumbangan yang teliti untuk projek orang lain akan membantu anda membina reputasi positif. Menjadi ahli yang aktif dalam komuniti sumber terbuka akan membantu orang mempunyai konteks untuk pekerjaan anda dan lebih cenderung untuk memberi perhatian dan berkongsi projek anda. Membangun hubungan dengan projek sumber terbuka yang lain malah boleh menjalin kerjasama rasmi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  Satu-satunya sebab urllib3 adalah perpustakaan Python pihak ketiga yang paling popular hari ini adalah kerana ia adalah sebahagian daripada permintaan.
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Tidak terlalu awal, atau terlambat, untuk mula membina reputasi anda Walaupun anda sudah melancarkan projek anda sendiri, teruskan mencari cara untuk menolong orang lain.

Tidak ada penyelesaian semalam untuk membina penonton. Memperoleh kepercayaan dan penghormatan orang lain memerlukan masa, dan membina reputasi anda tidak akan pernah berakhir.

## Terus!

Mungkin memerlukan masa yang lama sebelum orang melihat projek sumber terbuka anda. Tak mengapa! Beberapa projek yang paling popular hari ini mengambil masa bertahun-tahun untuk mencapai tahap aktiviti yang tinggi. Fokus pada membina hubungan dan bukannya berharap projek anda mendapat populariti secara spontan. Bersabarlah, dan teruskan berkongsi karya anda dengan mereka yang menghargainya.
