---
lang: ms
title: Tatakelakuan Anda
description: Memudahkan tingkah laku masyarakat yang sihat dan konstruktif dengan menerapkan dan menguatkuasakan tatakelakuan.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Mengapa saya memerlukan tatakelakuan?

Kod tingkah laku adalah dokumen yang menetapkan harapan untuk tingkah laku bagi peserta projek anda. Mengamalkan, dan menegakkan, kod tingkah laku dapat membantu mewujudkan suasana sosial yang positif untuk komuniti anda.

Tata kelakuan membantu melindungi bukan hanya peserta anda, tetapi diri anda sendiri. Sekiranya anda mengekalkan projek, anda mungkin mendapati bahawa sikap yang tidak produktif dari peserta lain dapat membuat anda merasa kecewa atau tidak senang dengan kerja anda dari masa ke masa.

Kod tingkah laku memberi kuasa kepada anda untuk memudahkan tingkah laku masyarakat yang sihat dan membina. Bersikap proaktif mengurangkan kemungkinan anda, atau orang lain, menjadi letih dengan projek anda, dan membantu anda mengambil tindakan ketika seseorang melakukan sesuatu yang tidak anda setujui.

## Menetapkan tatakelakuan

Cuba buat kod tingkah laku seawal mungkin: idealnya, ketika pertama kali membuat projek anda.

Selain menyampaikan harapan anda, kod tingkah laku menerangkan perkara berikut:

* Di mana tatakelakuan berkuatkuasa _(hanya pada isu dan permintaan tarik, atau aktiviti masyarakat seperti acara?)_
* Siapa yang mematuhi tata kelakuan _(anggota masyarakat dan penyelenggara, tetapi bagaimana dengan penaja?)_
* Apa yang berlaku sekiranya seseorang melanggar tatakelakuan
* Bagaimana seseorang dapat melaporkan pelanggaran

Di mana sahaja anda boleh, gunakan seni sebelumnya. [Contributor Covenant](https://contributor-covenant.org/) adalah tatakelakuan drop-in yang digunakan oleh lebih dari 40,000 projek sumber terbuka, termasuk Kubernetes, Rails, dan Swift.

[Django Code of Conduct](https://www.djangoproject.com/conduct/) dan [Citizen Code of Conduct](https://web.archive.org/web/20200330154000/http://citizencodeofconduct.org/) juga merupakan dua contoh tatakelakuan yang baik.

Letakkan fail CODE_OF_CONDUCT di direktori root projek anda, dan jadikan ia dapat dilihat oleh komuniti anda dengan menghubungkannya dari fail CONTRIBUTING atau README anda.

## Memutuskan bagaimana anda akan menguatkuasakan tatakelakuan anda

<aside markdown="1" class="pquote">
  Kod tingkah laku yang tidak (atau tidak dapat) ditegakkan lebih buruk daripada tidak ada kod tingkah laku sama sekali: ia menghantar mesej bahawa nilai-nilai dalam kod tingkah laku sebenarnya tidak penting atau dihormati dalam komuniti anda.
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://webcache.googleusercontent.com/search?q=cache:YfqdTk5H9ikJ:https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community)
  </p>
</aside>

Anda harus menjelaskan bagaimana tatakelakuan anda akan ditegakkan **_sebelum_** pelanggaran berlaku. Terdapat beberapa sebab untuk melakukannya:

* Ini menunjukkan bahawa anda serius mengambil tindakan ketika diperlukan.

* Komuniti anda akan merasa lebih yakin bahawa aduan benar-benar dikaji.

* Anda akan meyakinkan komuniti anda bahawa proses peninjauan dilakukan dengan adil dan telus, sekiranya mereka mendapati diri mereka disiasat atas pelanggaran.

Anda harus memberi orang cara persendirian (seperti alamat e-mel) untuk melaporkan pelanggaran tatakelakuan dan menjelaskan siapa yang menerima laporan tersebut. Ini boleh menjadi penyelenggara, sekumpulan penyelenggara, atau kumpulan kerja kod etika.

Jangan lupa bahawa seseorang mungkin ingin melaporkan pelanggaran mengenai orang yang menerima laporan tersebut. Dalam kes ini, beri mereka pilihan untuk melaporkan pelanggaran kepada orang lain. Contohnya, @ctb dan @mr-c [explain on their project](https://github.com/dib-lab/khmer/blob/HEAD/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> Contoh tingkah laku kasar, melecehkan, atau tidak boleh diterima mungkin dilaporkan dengan menghantar e-mel **khmer-project@idyll.org** melalui email yang hanya ditujukan kepada C. Titus Brown dan Michael R. Crusoe. Untuk melaporkan masalah yang melibatkan salah satu daripada mereka, sila hantarkan e-mel **Judi Brown Clarke, Ph.D.** Diversity Director kat BEACON Center for the Study of Evolution in Action, Pusat Sains dan Teknologi NSF. 

Untuk inspirasi, lihatlah Django's [enforcement manual](https://www.djangoproject.com/conduct/enforcement-manual/) (walaupun anda mungkin tidak memerlukan sesuatu yang komprehensif, bergantung pada ukuran projek anda).

## Menguatkuasakan tatakelakuan anda

Kadang kala, walaupun ada usaha terbaik anda, seseorang akan melakukan sesuatu yang melanggar kod ini. Terdapat beberapa cara untuk mengatasi tingkah laku negatif atau berbahaya ketika muncul.

### Kumpulkan maklumat mengenai keadaan

Perlakukan suara setiap ahli komuniti sama pentingnya dengan suara anda. Sekiranya anda menerima laporan bahawa seseorang melanggar tatakelakuan, ambil serius dan selidiki masalah tersebut, walaupun tidak sesuai dengan pengalaman anda sendiri dengan orang itu. Melakukannya memberi isyarat kepada komuniti anda bahawa anda menghargai perspektif mereka dan mempercayai penilaian mereka.

Anggota komuniti yang berkenaan mungkin merupakan pesalah berulang yang secara konsisten membuat orang lain merasa tidak selesa, atau mereka mungkin hanya pernah mengatakan atau melakukan sesuatu sekali. Kedua-duanya boleh menjadi alasan untuk mengambil tindakan, bergantung pada konteksnya.

Sebelum anda bertindak balas, berikan masa untuk memahami apa yang berlaku. Baca komen dan perbualan orang yang lalu untuk lebih memahami siapa mereka dan mengapa mereka bertindak sedemikian. Cuba kumpulkan perspektif selain pandangan anda mengenai orang ini dan tingkah laku mereka.

<aside markdown="1" class="pquote">
  Jangan tertarik dengan hujah. Jangan sesekali berurusan dengan tingkah laku orang lain sebelum anda selesai menangani masalah tersebut. Fokus pada perkara yang anda perlukan.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Lakukan tindakan yang sewajarnya

Setelah mengumpulkan dan memproses maklumat yang mencukupi, anda perlu memutuskan apa yang harus dilakukan. Semasa anda mempertimbangkan langkah seterusnya, ingat bahawa matlamat anda sebagai moderator adalah untuk memupuk persekitaran yang selamat, hormat, dan bekerjasama. Pertimbangkan bukan sahaja bagaimana menangani situasi yang dimaksudkan, tetapi bagaimana tindak balas anda akan mempengaruhi tingkah laku dan harapan masyarakat anda yang lain untuk terus maju.

Apabila seseorang melaporkan pelanggaran tatakelakuan, itu adalah tugas anda, bukan tugas mereka untuk mengatasinya. Kadang kala, wartawan mendedahkan maklumat yang berisiko besar terhadap kerjaya, reputasi, atau keselamatan fizikal mereka. Memaksa mereka untuk berhadapan dengan pelaku gangguan mereka dapat menempatkan wartawan dalam posisi yang berkompromi. Anda harus mengendalikan komunikasi langsung dengan orang yang berkenaan, kecuali wartawan secara terang-terangan meminta sebaliknya.

Terdapat beberapa cara untuk menanggapi pelanggaran tatakelakuan:

* **Beri amaran umum kepada orang yang dimaksudkan** dan terangkan bagaimana tingkah laku mereka memberi kesan negatif kepada orang lain, lebih baik di saluran di mana ia berlaku. Sekiranya mungkin, komunikasi awam menyampaikan kepada masyarakat lain bahawa anda memandang serius tatakelakuan. Bersikap baik, tetapi tegas dalam komunikasi anda.

* **Hubungi orang itu secara peribadi** untuk menjelaskan bagaimana tingkah laku mereka memberi kesan negatif kepada orang lain. Anda mungkin mahu menggunakan saluran komunikasi peribadi jika keadaan tersebut melibatkan maklumat peribadi yang sensitif. Sekiranya anda berkomunikasi dengan seseorang secara peribadi, adalah idea yang baik untuk menghubungi mereka yang pertama kali melaporkan keadaan, jadi mereka tahu bahawa anda telah mengambil tindakan. Minta persetujuan orang yang melapor sebelum meminta mereka.

Kadang kala, penyelesaian tidak dapat dicapai. Orang yang dimaksudkan boleh menjadi agresif atau bermusuhan ketika berhadapan atau tidak mengubah tingkah laku mereka. Dalam keadaan ini, anda mungkin ingin mempertimbangkan untuk mengambil tindakan yang lebih kuat. Sebagai contoh:

* **Tangguhkan orang yang dimaksudkan dari projek tersebut** , yang diberlakukan melalui larangan sementara untuk mengambil bahagian dalam aspek apa pun projek

* **Larangan secara kekal** orang dari projek

Melarang anggota tidak boleh dipandang ringan dan mewakili perbezaan perspektif yang tetap dan tidak dapat diselesaikan. Anda hanya harus mengambil langkah-langkah ini apabila sudah jelas bahawa penyelesaian tidak dapat dicapai.

## Tanggungjawab anda sebagai penjaga

Tata kelakuan bukanlah undang-undang yang dikuatkuasakan dengan sewenang-wenangnya. Anda adalah penguatkuasa kod tingkah laku dan menjadi tanggungjawab anda untuk mengikuti peraturan yang ditetapkan oleh kod tingkah laku.

Sebagai penjaga, anda menetapkan garis panduan untuk komuniti anda dan menguatkuasakan garis panduan tersebut sesuai dengan peraturan yang dinyatakan dalam tatakelakuan anda. Ini bermaksud memandang serius setiap laporan pelanggaran tatakelakuan. Wartawan tersebut harus meneliti aduan mereka secara menyeluruh dan adil. Sekiranya anda menentukan bahawa tingkah laku yang mereka laporkan bukanlah pelanggaran, sampaikan dengan jelas kepada mereka dan terangkan mengapa anda tidak akan mengambil tindakan terhadapnya. Apa yang mereka lakukan adalah bergantung kepada mereka: bertolak ansur dengan tingkah laku yang mereka hadapi, atau berhenti mengambil bahagian dalam komuniti.

Laporan tingkah laku yang tidak secara teknikal_ melanggar tatakelakuan mungkin masih menunjukkan bahawa terdapat masalah dalam komuniti anda, dan anda harus menyiasat potensi masalah ini dan bertindak sewajarnya. Ini mungkin termasuk menyemak semula kod tingkah laku anda untuk menjelaskan tingkah laku yang dapat diterima dan / atau berbicara dengan orang yang perilakunya dilaporkan dan memberitahu mereka bahawa walaupun mereka tidak melanggar kod tingkah laku, mereka melewati apa yang diharapkan dan memastikan peserta berasa tidak selesa.

Pada akhirnya, sebagai penjaga, anda menetapkan dan menegakkan piawaian untuk tingkah laku yang boleh diterima. Anda mempunyai kemampuan untuk membentuk nilai-nilai komuniti projek tersebut, dan para peserta mengharapkan anda untuk menerapkan nilai-nilai tersebut dengan adil dan adil.

## Galakkan tingkah laku yang anda ingin lihat di dunia 🌎

Apabila projek kelihatan bermusuhan atau tidak disenangi, walaupun hanya satu orang yang tingkah lakunya ditoleransi oleh orang lain, anda berisiko kehilangan banyak lagi penyumbang, yang mungkin tidak pernah anda temui. Tidak selalunya mudah untuk menerapkan atau menegakkan kod tingkah laku, tetapi memupuk persekitaran yang ramah akan membantu komuniti anda berkembang.
