---
lang: ms
title: Membina Komuniti Sambutan
description: Membangun komuniti yang mendorong orang untuk menggunakan, menyumbang, dan menginjil projek anda.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Menyiapkan projek anda untuk berjaya

Anda telah melancarkan projek anda, anda menyebarkan berita, dan orang-orang memeriksanya. Hebat! Sekarang, bagaimana anda membuat mereka bertahan?

Komuniti yang ramah adalah pelaburan untuk masa depan dan reputasi projek anda. Sekiranya projek anda baru mula melihat sumbangan pertamanya, mulakan dengan memberi pengalaman positif kepada penyumbang awal, dan permudahkan mereka terus kembali.

### Buat orang merasa diterima

Salah satu cara untuk memikirkan komuniti projek anda adalah melalui apa yang disebut oleh @MikeMcQuaid [contributor funnel](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![Contributor funnel](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Semasa anda membina komuniti, pertimbangkan bagaimana seseorang di bahagian atas corong (pengguna berpotensi) mungkin secara teorinya melangkah ke bahagian bawah (penyelenggara aktif). Matlamat anda adalah untuk mengurangkan geseran pada setiap tahap pengalaman penyumbang. Apabila orang memperoleh kemenangan dengan mudah, mereka akan merasa terdorong untuk melakukan lebih banyak perkara.

Mulakan dengan dokumentasi anda:

* **Permudahkan seseorang untuk menggunakan projek anda.**[README yang mesra](../starting-a-project/#menulis-readme) dan contoh kod yang jelas akan memudahkan sesiapa sahaja yang memasuki projek anda untuk memulakan.
* **Terangkan dengan jelas cara menyumbang**, menggunakan [fail CONTRIBUTING anda](../starting-a-project/#menulis-garis-panduan-penyumbang-anda) dan mengemas kini masalah anda.
* **Isu pertama yang baik**: Untuk membantu penyumbang baru memulakan, pertimbangkan secara jelas [masalah pelabelan yang cukup mudah untuk diatasi oleh pemula](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). GitHub kemudian akan memaparkan isu-isu ini di berbagai tempat di platform, meningkatkan sumbangan berguna, dan mengurangkan geseran dari pengguna menangani masalah yang terlalu sukar untuk tahap mereka.

[GitHub's 2017 Open Source Survey](http://opensourcesurvey.org/2017/) menunjukkan dokumentasi yang tidak lengkap atau membingungkan adalah masalah terbesar bagi pengguna sumber terbuka. Dokumentasi yang baik mengundang orang untuk berinteraksi dengan projek anda. Akhirnya, seseorang akan membuka masalah atau menarik permintaan. Gunakan interaksi ini sebagai peluang untuk mengalihkannya ke corong.

* **Apabila seseorang baru memasuki projek anda, terima kasih atas minat mereka!** Hanya memerlukan satu pengalaman negatif untuk membuat seseorang tidak mahu kembali.
* **Bersikap responsif.** Sekiranya anda tidak menjawab masalah mereka selama sebulan, kemungkinannya, mereka sudah melupakan projek anda.
* **Berfikiran terbuka tentang jenis sumbangan yang akan anda terima.** Banyak penyumbang bermula dengan laporan bug atau perbaikan kecil. Disana ada[banyak cara untuk menyumbang](../how-to-contribute/#apa-maksudnya-menyumbang) ke projek. Biarkan orang menolong bagaimana mereka mahu menolong.
* **Sekiranya ada sumbangan yang anda tidak setuju,** terima kasih atas idea mereka dan [terangkan mengapa](../best-practices/#belajar-bila-untuk-mengatakan-tidak) ini tidak sesuai dengan skop projek, menghubungkan ke dokumentasi yang relevan jika anda memilikinya.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Menyumbang kepada sumber terbuka lebih mudah bagi sesetengah orang daripada yang lain. Terdapat banyak ketakutan untuk ditengking kerana tidak melakukan sesuatu yang betul atau tidak sesuai. (...) Dengan memberi para penyumbang tempat untuk menyumbang dengan kecekapan teknikal yang sangat rendah (dokumentasi, penurunan kandungan web, dll.) Anda dapat mengurangkan kebimbangan itu.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

Sebilangan besar penyumbang sumber terbuka adalah "penyumbang kasual": orang yang menyumbang kepada projek hanya sekali-sekala. Penyumbang kasual mungkin tidak mempunyai masa untuk mencapai kemajuan sepenuhnya dengan projek anda, jadi tugas anda adalah untuk memudahkan mereka menyumbang.

Mendorong penyumbang lain adalah pelaburan dalam diri anda juga. Apabila anda memberi peluang kepada peminat terbesar anda untuk berlari dengan karya yang mereka sukai, tidak ada tekanan untuk melakukan semuanya sendiri.

### Mendokumentasikan semuanya

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Pernahkah anda ke acara (berteknologi) di mana anda tidak mengenali sesiapa, tetapi orang lain sepertinya berdiri dalam kumpulan dan berbual seperti rakan lama? (...) Sekarang bayangkan anda mahu menyumbang kepada projek sumber terbuka, tetapi anda tidak melihat mengapa atau bagaimana ini berlaku.
  <p markdown="1" class="pquote-credit">
— @janl, ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Apabila anda memulakan projek baru, mungkin terasa wajar untuk menjaga kerahsiaan kerja anda. Tetapi projek sumber terbuka berkembang apabila anda mendokumentasikan proses anda di khalayak ramai.

Apabila anda menuliskan sesuatu, lebih banyak orang dapat mengambil bahagian dalam setiap langkah. Anda mungkin mendapat pertolongan mengenai sesuatu yang anda tidak tahu bahawa anda perlukan.

Menulis perkara bermaksud lebih daripada sekadar dokumentasi teknikal. Bila-bila masa anda merasa terdorong untuk menulis sesuatu atau membincangkan projek anda secara tertutup, tanyakan pada diri anda sama ada anda boleh membuatnya terbuka.

Bersikap telus mengenai peta jalan projek anda, jenis sumbangan yang anda cari, bagaimana sumbangan dikaji, atau mengapa anda membuat keputusan tertentu.

Sekiranya anda melihat banyak pengguna menghadapi masalah yang sama, dokumentasikan jawapannya di README.

Untuk perjumpaan, pertimbangkan untuk menerbitkan nota atau catatan anda dalam isu yang berkaitan. Maklum balas yang anda dapat dari tahap ketelusan ini mungkin akan mengejutkan anda.

Mendokumentasikan segala-galanya juga berlaku untuk pekerjaan yang anda lakukan. Sekiranya anda sedang mengemas kini projek anda, masukkan ke dalam permintaan tarik dan tandakan sebagai kerja yang sedang berjalan (WIP). Dengan cara itu, orang lain dapat merasa terlibat dalam proses tersebut sejak awal.

### Bersikap responsif

Seperti awak[mempromosikan projek anda](../finding-users), orang akan mempunyai maklum balas untuk anda. Mereka mungkin mempunyai pertanyaan tentang bagaimana sesuatu berfungsi, atau memerlukan bantuan untuk memulai.

Try responsif ketika seseorang mengajukan masalah, mengajukan permintaan tarik, atau mengajukan pertanyaan mengenai projek anda. Apabila anda bertindak balas dengan cepat, orang akan merasakan mereka adalah sebahagian daripada dialog, dan mereka akan lebih bersemangat untuk turut serta.

Walaupun anda tidak dapat segera meninjau permintaan tersebut, mengakuinya lebih awal dapat meningkatkan pertunangan. Inilah cara @tdreyno menanggapi permintaan penarikan [Middleman](https://github.com/middleman/middleman/pull/1466):

![Middleman pull request](/assets/images/building-community/middleman_pr.png)

[A Mozilla study found that](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) penyumbang yang menerima ulasan kod dalam masa 48 jam mempunyai kadar pulangan dan sumbangan berulang yang jauh lebih tinggi.

Perbualan mengenai projek anda juga boleh berlaku di tempat lain di internet, seperti Stack Overflow, Twitter, atau Reddit. Anda boleh mengatur pemberitahuan di beberapa tempat ini sehingga anda diberi amaran ketika seseorang menyebutkan projek anda.

### Beri komuniti anda tempat untuk berkumpul

Terdapat dua sebab untuk memberi tempat kepada komuniti anda untuk berkumpul.

Sebab pertama adalah untuk mereka. Tolong orang mengenali antara satu sama lain. Orang yang mempunyai kepentingan bersama pasti menginginkan tempat untuk membincangkannya. Dan apabila komunikasi bersifat umum dan mudah diakses, sesiapa sahaja boleh membaca arkib masa lalu untuk mencapai kelajuan dan mengambil bahagian.

Sebab kedua adalah untuk anda. Sekiranya anda tidak memberi orang awam tempat untuk membincangkan projek anda, mereka mungkin akan menghubungi anda secara langsung. Pada mulanya, nampaknya cukup mudah untuk membalas mesej peribadi "hanya sekali ini". Tetapi lama-kelamaan, terutamanya jika projek anda menjadi popular, anda akan merasa letih. Tahan godaan untuk berkomunikasi dengan orang lain mengenai projek anda secara tertutup. Sebaliknya, arahkan mereka ke saluran awam yang ditentukan.

Komunikasi awam semudah mengarahkan orang untuk membuka masalah dan bukannya menghantar e-mel kepada anda secara langsung atau memberi komen di blog anda. Anda juga boleh membuat senarai mel, atau membuat akaun Twitter, Slack, atau saluran IRC agar orang dapat membincangkan projek anda. Atau cuba semua perkara di atas!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) mengetepikan waktu pejabat setiap minggu untuk membantu anggota masyarakat:

> Kops juga mempunyai masa yang diperuntukkan setiap minggu untuk menawarkan pertolongan dan bimbingan kepada masyarakat. Penyelenggara Kops telah bersetuju untuk meluangkan masa yang khusus dikhaskan untuk bekerja dengan pendatang baru, membantu PR, dan membincangkan ciri baru.

Pengecualian untuk komunikasi awam adalah: 1) masalah keselamatan dan 2) pelanggaran tatakelakuan sensitif. Anda semestinya mempunyai cara untuk orang melaporkan masalah ini secara peribadi. Sekiranya anda tidak mahu menggunakan e-mel peribadi anda, sediakan alamat e-mel khusus.

## Memperkembangkan komuniti anda

Masyarakat sangat kuat. Kekuatan itu boleh menjadi berkat atau kutukan, bergantung pada bagaimana Anda menggunakannya. Apabila komuniti projek anda berkembang, ada cara untuk menolongnya menjadi kekuatan pembinaan, bukan kehancuran.

### Jangan bertolak ansur dengan pelakon jahat

Mana-mana projek yang popular pasti akan menarik orang yang membahayakan, dan bukannya membantu, komuniti anda. Mereka mungkin memulakan perbahasan yang tidak perlu, bertengkar dengan ciri-ciri remeh, atau menggertak orang lain.

Lakukan yang terbaik untuk mengamalkan dasar toleransi sifar terhadap jenis orang ini. Sekiranya dibiarkan, orang negatif akan membuat orang lain dalam komuniti anda tidak selesa. Mereka mungkin juga pergi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  Yang benar adalah bahawa mempunyai komuniti yang menyokong adalah kunci. Saya tidak akan dapat melakukan kerja ini tanpa bantuan rakan sekerja, orang asing yang ramah, dan saluran IRC yang cerewet. (...) Jangan berpuas hati. Jangan berpuas hati dengan orang yang teruk.
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Perbahasan berkala mengenai aspek sepele projek anda mengalihkan perhatian orang lain, termasuk anda, daripada memfokus pada tugas penting. Orang baru yang tiba ke projek anda mungkin melihat perbualan ini dan tidak mahu mengambil bahagian.

Apabila anda melihat tingkah laku negatif berlaku pada projek anda, panggilnya secara terbuka. Jelaskan, dengan nada yang baik tetapi tegas, mengapa tingkah laku mereka tidak dapat diterima. Sekiranya masalah itu berlanjutan, anda mungkin perlu [minta mereka pergi](../code-of-conduct/#menguatkuasakan-tatakelakuan-anda). Kamu punya [tatakelakuan](../code-of-conduct/) boleh menjadi panduan yang membina untuk perbualan ini.

### Temui penyumbang di mana mereka berada

Dokumentasi yang baik hanya menjadi lebih penting apabila komuniti anda berkembang. Penyumbang kasual, yang mungkin tidak biasa dengan projek anda, membaca dokumentasi anda untuk mendapatkan konteks yang mereka perlukan dengan cepat.

Dalam fail CONTRIBUTING anda, jelaskan cara penyumbang baru kepada penyumbang baru. Anda mungkin mahu membuat bahagian khusus untuk tujuan ini. [Django](https://github.com/django/django), sebagai contoh, mempunyai halaman arahan khas untuk mengalu-alukan penyumbang baru.

![Django new contributors page](/assets/images/building-community/django_new_contributors.png)

Dalam barisan masalah anda, labelkan pepijat yang sesuai untuk pelbagai jenis penyumbang: sebagai contoh, [_"first timers only"_](https://kentcdodds.com/blog/first-timers-only),_"terbitan pertama yang baik"_, atau _"dokumentasi"_. [These labels](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) permudahkan seseorang yang baru dalam projek anda untuk mengimbas masalah anda dengan cepat dan memulakannya.

Akhirnya, gunakan dokumentasi anda untuk membuat orang merasa diterima di setiap langkah.

Anda tidak akan pernah berinteraksi dengan kebanyakan orang yang menggunakan projek anda. Mungkin ada sumbangan yang tidak anda terima kerana seseorang merasa terintimidasi atau tidak tahu di mana hendak memulakannya. Bahkan beberapa kata yang baik dapat membuat seseorang tidak meninggalkan projek anda dalam kekecewaan.

Contohnya, inilah caranya [Rubinius](https://github.com/rubinius/rubinius/) bermula [its contributing guide](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> Kami ingin memulai dengan mengucapkan terima kasih kerana menggunakan Rubinius. Projek ini adalah usaha cinta, dan kami menghargai semua pengguna yang menangkap pepijat, membuat peningkatan prestasi, dan membantu dengan dokumentasi. Setiap sumbangan amat bermakna, jadi terima kasih kerana turut serta. Oleh itu, berikut adalah beberapa panduan yang kami minta anda ikuti sehingga kami dapat menyelesaikan masalah anda dengan jayanya.

### Kongsi pemilikan projek anda

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  Pemimpin anda akan berbeza pendapat, sebagaimana seharusnya semua komuniti sihat! Namun, anda perlu mengambil langkah untuk memastikan suara yang paling keras tidak selalu menang dengan melelahkan orang, dan suara yang kurang menonjol dan minoriti kedengaran.
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["What makes a good community?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Orang ramai teruja untuk menyumbang kepada projek apabila mereka merasakan kepemilikan. Itu tidak bermaksud anda perlu membalikkan visi projek anda atau menerima sumbangan yang tidak anda mahukan. Tetapi semakin banyak anda memberi penghargaan kepada orang lain, semakin banyak mereka tetap bertahan.

Lihat apakah anda boleh mencari cara untuk berkongsi pemilikan dengan komuniti anda sebanyak mungkin. Berikut adalah beberapa idea:

* **Tahan untuk memperbaiki pepijat yang mudah (tidak kritikal).** Sebagai gantinya, gunakannya sebagai peluang untuk merekrut penyumbang baru, atau membimbing seseorang yang ingin menyumbang. Mungkin kelihatan tidak wajar pada mulanya, tetapi pelaburan anda akan membuahkan hasil dari masa ke masa. Sebagai contoh, @michaeljoseph meminta penyumbang untuk mengemukakan permintaan tarik pada a[Cookiecutter](https://github.com/audreyr/cookiecutter) masalah di bawah, bukannya membetulkannya sendiri.

![Cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Mulakan fail CONTRIBUTORS atau AUTHORS dalam projek anda** yang menyenaraikan semua orang yang menyumbang untuk projek anda, seperti [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md)

* Sekiranya anda mempunyai komuniti yang cukup besar, **menghantar surat berita atau menulis catatan blog** mengucapkan terima kasih kepada penyumbang. Penyumbang Rust [This Week in Rust](https://this-week-in-rust.org/) dan penyumbang Hoodie [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) adalah dua contoh yang baik.

* **Berikan akses kepada setiap penyumbang.** @felixge mendapati bahawa ini menjadikan orang [lebih teruja untuk menggilap patch mereka](https://felixge.de/2013/03/11/the-pull-request-hack.html), dan dia malah menjumpai penyelenggara baru untuk projek-projek yang belum pernah dia kerjakan sebentar lagi.

* Sekiranya projek anda berada di GitHub, **pindahkan projek anda dari akaun peribadi anda ke [Organization](https://help.github.com/articles/creating-a-new-organization-account/)** dan tambahkan sekurang-kurangnya satu pentadbir sandaran. Organisasi menjadikannya lebih mudah untuk mengerjakan projek dengan kolaborator luar.

Kenyataannya adalah bahawa[most projects only have](https://peerj.com/preprints/1233/)satu atau dua penyelenggara yang melakukan sebahagian besar kerja. Semakin besar projek anda, dan semakin besar komuniti anda, semakin mudah mendapatkan bantuan.

Walaupun anda mungkin tidak selalu menjumpai seseorang untuk menjawab panggilan tersebut, memberi isyarat di luar sana akan meningkatkan kemungkinan orang lain akan masuk. Dan lebih awal anda memulakannya, semakin cepat orang dapat membantu.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[Ia ada di dalam anda\] minat terbaik untuk merekrut penyumbang yang menikmati dan yang mampu melakukan perkara yang bukan anda lakukan. Adakah anda menikmati pengekodan, tetapi tidak menjawab masalah? Kemudian kenal pasti individu-individu dalam komuniti anda yang melakukannya dan biarkan mereka memilikinya.
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Menyelesaikan konflik

Pada peringkat awal projek anda, membuat keputusan besar adalah mudah. Apabila anda ingin melakukan sesuatu, anda hanya melakukannya.

Oleh kerana projek anda menjadi lebih popular, lebih ramai orang akan tertarik dengan keputusan yang anda buat. Walaupun anda tidak mempunyai komuniti penyumbang yang besar, jika projek anda mempunyai banyak pengguna, anda akan mendapati orang mempertimbangkan keputusan atau membangkitkan masalah mereka sendiri.

Sebahagian besarnya, jika anda telah membina komuniti yang ramah, hormat dan mendokumentasikan proses anda secara terbuka, komuniti anda seharusnya dapat mencari penyelesaian. Tetapi kadang-kadang anda menghadapi masalah yang agak sukar untuk ditangani.

### Tetapkan bar untuk kebaikan

Apabila komuniti anda bergelut dengan masalah yang sukar, kemarahan mungkin akan meningkat. Orang mungkin menjadi marah atau kecewa dan mengeluarkannya satu sama lain, atau pada anda.

Tugas anda sebagai penyelenggara adalah untuk memastikan situasi ini tidak meningkat. Walaupun anda mempunyai pendapat yang kuat mengenai topik ini, cubalah mengambil kedudukan sebagai moderator atau fasilitator, daripada melompat ke dalam pertengkaran dan mendorong pandangan anda. Sekiranya seseorang bersikap tidak baik atau memonopoli perbualan, [bertindak segera](../building-community/#jangan-bertolak-ansur-dengan-pelakon-jahat) agar perbincangan tetap sopan dan produktif.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
 Sebagai penyelenggara projek, sangat penting untuk menghormati penyumbang anda. Mereka sering mengambil apa yang anda katakan secara peribadi.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Orang lain mencari bimbingan anda. Berikan contoh yang baik. Anda masih dapat menyatakan kekecewaan, ketidakbahagiaan, atau keprihatinan, tetapi melakukannya dengan tenang.

Menjaga kesegaran anda tidak mudah, tetapi menunjukkan kepemimpinan dapat meningkatkan kesihatan komuniti anda. Internet terima kasih.

### Perlakukan README anda sebagai perlembagaan

README anda adalah [lebih daripada sekumpulan arahan](../starting-a-project/#menulis-readme). Ia juga merupakan tempat untuk membincangkan tujuan, visi produk, dan peta jalan anda. Sekiranya orang terlalu fokus memperdebatkan kelebihan ciri tertentu, ia mungkin dapat meninjau semula README anda dan membincangkan visi projek anda yang lebih tinggi. Memfokuskan pada README anda juga melumpuhkan perbualan, sehingga anda dapat mengadakan perbincangan yang membina.

### Fokus pada perjalanan, bukan destinasi

Beberapa projek menggunakan proses pengundian untuk membuat keputusan utama. Walaupun masuk akal pada pandangan pertama, pemungutan suara menekankan mendapatkan "jawaban", daripada mendengarkan dan menangani masalah satu sama lain.

Pengundian boleh menjadi politik, di mana anggota masyarakat merasa tertekan untuk saling memilih atau memilih dengan cara tertentu. Tidak semua orang memilih, sama ada ia [silent majority](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) dalam komuniti anda, atau pengguna semasa yang tidak tahu ada suara.

Kadang kala, pengundian adalah pemangkin yang perlu. Walau seberapa banyak yang anda mampu, tekankan ["consensus seeking"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) bukannya muafakat.

Di bawah proses pencarian konsensus, anggota masyarakat membincangkan masalah utama sehingga mereka merasa mereka telah didengar dengan cukup. Apabila hanya ada masalah kecil, masyarakat bergerak maju. "Pencarian konsensus" mengakui bahawa masyarakat mungkin tidak dapat mencapai jawapan yang sempurna. Sebaliknya, ia mengutamakan pendengaran dan perbincangan.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Sebahagian daripada sebab mengapa sistem pemungutan suara tidak ada untuk Masalah Atom adalah kerana pasukan Atom tidak akan mengikuti sistem pengundian dalam semua hal. Kadang-kadang kita harus memilih apa yang kita rasa betul walaupun tidak popular. (...) Apa yang dapat saya tawarkan dan berjanji untuk dilakukan ... adalah tugas saya untuk mendengarkan masyarakat.
  <p markdown="1" class="pquote-credit">
— @lee-dohm on Atom's decision making process
  </p>
</aside>

Walaupun anda tidak benar-benar menggunakan proses mencari konsensus, sebagai penyelenggara projek, penting bagi orang untuk mengetahui bahawa anda sedang mendengar. Membuat orang lain merasa terdengar, dan berkomitmen untuk menyelesaikan masalah mereka, banyak membantu menangani situasi sensitif. Kemudian, ikuti kata-kata anda dengan tindakan.

Jangan terburu-buru membuat keputusan kerana mempunyai keputusan. Pastikan bahawa semua orang merasa terdengar dan bahawa semua maklumat telah diumumkan sebelum membuat keputusan.

### Pastikan perbualan tertumpu pada tindakan

Perbincangan itu penting, tetapi ada perbezaan antara perbualan produktif dan tidak produktif.

Galakkan perbincangan selagi ia bergerak secara aktif ke arah penyelesaian. Sekiranya jelas bahawa perbualan mereda atau di luar topik, jab menjadi lebih peribadi, atau orang-orang membicarakan perincian kecil, sudah waktunya untuk mematikannya.

Membiarkan perbualan ini diteruskan bukan hanya buruk untuk masalah yang dihadapi, tetapi juga buruk bagi kesihatan komuniti anda. Ini mengirimkan mesej bahawa jenis percakapan ini diizinkan atau bahkan digalakkan, dan ini dapat mendorong orang untuk membangkitkan atau menyelesaikan masalah di masa depan.

Dengan setiap titik yang dibuat oleh anda atau oleh orang lain, tanyakan pada diri sendiri, _"Bagaimana ini mendekatkan kita dengan penyelesaian?"_

Sekiranya perbualan mula terungkai, tanyakan kepada kumpulan, _"Langkah mana yang harus kita ambil selanjutnya?"_ Untuk memfokuskan kembali perbualan.

Sekiranya perbualan jelas tidak akan ke mana-mana, tidak ada tindakan yang jelas untuk diambil, atau tindakan yang sesuai telah diambil, tutup masalahnya dan terangkan mengapa anda menutupnya.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Membimbing utas ke arah berguna tanpa memaksa adalah seni. Tidak akan berguna hanya untuk memberi nasihat kepada orang ramai agar berhenti membuang masa mereka, atau meminta mereka untuk tidak mengeposkan melainkan mereka mempunyai sesuatu yang membina. (...) Sebagai gantinya, anda harus mencadangkan syarat untuk kemajuan lebih lanjut: beri laluan kepada orang lain, jalan untuk diikuti yang membawa kepada hasil yang anda mahukan, namun tanpa terdengar seperti anda menentukan tingkah laku.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Pilih pertempuran anda dengan bijak

Konteks adalah penting. Pertimbangkan siapa yang terlibat dalam perbincangan dan bagaimana mereka mewakili masyarakat yang lain.

Adakah semua orang dalam komuniti kesal dengan, atau bahkan terlibat dengan, masalah ini? Atau adakah pengacau sendirian? Jangan lupa untuk mempertimbangkan ahli komuniti anda yang senyap, bukan hanya suara aktif.

Sekiranya masalah ini tidak mewakili keperluan masyarakat anda yang lebih luas, anda mungkin perlu mengakui keprihatinan segelintir orang. Sekiranya ini adalah masalah berulang tanpa penyelesaian yang jelas, arahkan mereka ke perbincangan sebelumnya mengenai topik ini dan tutup utasnya.

### Kenal pasti tiebreak komuniti

Dengan sikap yang baik dan komunikasi yang jelas, situasi yang paling sukar dapat diselesaikan. Namun, walaupun dalam perbualan yang produktif, hanya ada perbezaan pendapat tentang cara meneruskannya. Dalam kes ini, kenal pasti individu atau sekumpulan orang yang boleh berfungsi sebagai pemula.

Tiebreaker dapat menjadi penyelenggara utama proyek, atau mungkin sekelompok kecil orang yang membuat keputusan berdasarkan pengundian. Sebaik-baiknya, anda telah mengenal pasti tiebreak dan proses yang berkaitan dalam fail GOVERNANCE sebelum anda mesti menggunakannya.

Tiebreaker anda harus menjadi pilihan terakhir. Isu memecah belah adalah peluang untuk komuniti anda berkembang dan belajar. Rebut peluang ini dan gunakan proses kolaboratif untuk beralih ke penyelesaian sedapat mungkin.

## Komuniti adalah ❤️ sumber terbuka

Komuniti yang sihat dan berkembang menghasilkan ribuan jam yang dicurahkan ke sumber terbuka setiap minggu. Banyak penyumbang menunjukkan kepada orang lain sebagai alasan untuk bekerja - atau tidak bekerja - di sumber terbuka. Dengan belajar bagaimana memanfaatkan kekuatan itu secara konstruktif, anda akan membantu seseorang di luar sana mempunyai pengalaman sumber terbuka yang tidak dapat dilupakan.
