---
lang: ms
title: Memulakan projek sumber terbuka
description: Ketahui lebih lanjut mengenai dunia sumber terbuka dan bersiap sedia untuk melancarkan projek anda sendiri.
class: best-practices
order: 5
image: /assets/images/cards/best-practices.png
related:
  - metrics
  - leadership
---

## Apa maksudnya menjadi penyelenggara projek sumber terbuka ?

Sekiranya anda mengekalkan projek sumber terbuka yang digunakan oleh banyak orang, anda mungkin menyedari bahawa anda kurang mengekod dan lebih banyak menjawab masalah.

Pada peringkat awal projek, anda bereksperimen dengan idea baru dan membuat keputusan berdasarkan apa yang anda mahukan. Apabila projek anda semakin popular, anda akan dapat bekerja dengan pengguna dan penyumbang anda lebih banyak.

Menyelenggara projek memerlukan lebih daripada sekadar kod. Tugas-tugas ini sering tidak dijangka, tetapi sama pentingnya dengan projek yang sedang berkembang. Kami telah mengumpulkan beberapa cara untuk menjadikan hidup anda lebih mudah, dari proses pendokumentasian hingga memanfaatkan komuniti anda.

## Mendokumentasikan proses anda

Menulis perkara adalah salah satu perkara terpenting yang boleh anda lakukan sebagai penyelenggara.

Dokumentasi bukan sahaja menjelaskan pemikiran anda sendiri, tetapi membantu orang lain memahami apa yang anda perlukan atau harapkan, bahkan sebelum mereka bertanya.

Menulis perkara menjadi lebih mudah untuk mengatakan tidak apabila sesuatu tidak sesuai dengan skop anda. Ini juga memudahkan orang untuk masuk dan menolong. Anda tidak pernah tahu siapa yang mungkin membaca atau menggunakan projek anda.

Walaupun anda tidak menggunakan perenggan penuh, mencatat titik peluru lebih baik daripada tidak menulis sama sekali.

Ingatlah untuk memastikan dokumentasi anda sentiasa terkini. Sekiranya anda tidak dapat selalu melakukan ini, hapus dokumentasi anda yang sudah lapuk atau nyatakan bahawa ia sudah lapuk sehingga penyumbang tahu kemas kini dialu-alukan.

### Tuliskan visi projek anda

Mulakan dengan menuliskan matlamat projek anda. Tambahkan mereka ke README anda, atau buat fail berasingan yang disebut VISION. Sekiranya ada artifak lain yang dapat membantu, seperti peta jalan projek, buat juga umum.

Mempunyai visi yang jelas dan didokumentasikan membuat anda tetap fokus dan membantu anda mengelakkan "jangkauan skop" dari sumbangan orang lain.

Sebagai contoh, @lord mendapati bahawa mempunyai visi projek membantunya mengetahui permintaan mana yang perlu diluangkan. Sebagai penyelenggara baru, dia menyesal tidak berpegang pada skop projeknya ketika dia mendapat permintaan fitur pertama untuk [Slate] (<https://github.com/lord/slate>).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lord?s=180" class="pquote-avatar" alt="avatar">
  Saya meraba-raba. Saya tidak berusaha mencari penyelesaian yang lengkap. Sebagai ganti penyelesaian separuh, saya harap saya mengatakan "Saya tidak mempunyai masa untuk ini sekarang, tetapi saya akan menambahkannya ke dalam senarai jangka panjang yang bagus."
  <p markdown="1" class="pquote-credit">
— @lord, ["Petua untuk penyelenggara sumber terbuka baru"](https://lord.io/blog/2014/oss-tips/)
  </p>
</aside>

### Sampaikan harapan anda

Peraturan boleh mengganggu untuk menuliskannya. Kadang-kadang anda mungkin merasa seperti mengawal tingkah laku orang lain atau membunuh semua keseronokan.

Ditulis dan dikuatkuasakan dengan adil, bagaimanapun, peraturan yang baik memberi kuasa kepada penyelenggara. Mereka menghalang anda daripada diseret untuk melakukan perkara yang tidak mahu anda lakukan.

Sebilangan besar orang yang menemui projek anda tidak mengetahui apa-apa tentang anda atau keadaan anda. Mereka mungkin menganggap anda dibayar untuk mengusahakannya, terutamanya jika ia adalah sesuatu yang selalu mereka gunakan dan bergantung. Mungkin pada satu ketika anda meluangkan banyak masa ke dalam projek anda, tetapi sekarang anda sibuk dengan pekerjaan baru atau ahli keluarga.

Semua ini baik-baik saja! Pastikan orang lain tahu mengenainya.

Sekiranya mengekalkan projek anda secara sambilan atau secara sukarela, jujurlah berapa banyak masa yang anda ada. Ini tidak sama dengan berapa banyak masa yang anda fikirkan memerlukan projek itu, atau berapa banyak masa yang orang lain mahu anda habiskan.

Berikut adalah beberapa peraturan yang perlu ditulis:

* Bagaimana sumbangan dikaji dan diterima (_Adakah mereka memerlukan ujian? Templat masalah?_)
* Jenis sumbangan yang akan anda terima (_Adakah anda hanya memerlukan bantuan dengan bahagian tertentu kod anda?_)
* Bila sesuai untuk ditindaklanjuti (_sebagai contoh, "Anda dapat mengharapkan tindak balas dari penjaga dalam masa 7 hari. Sekiranya anda belum mendengar apa-apa pada masa itu, jangan ragu untuk melakukan ping."_)
* Berapa banyak masa yang anda habiskan untuk projek itu (_sebagai contoh, "Kami hanya menghabiskan kira-kira 5 jam seminggu untuk projek ini"_)

[Jekyll](https://github.com/jekyll/jekyll/tree/master/docs), [CocoaPods](https://github.com/CocoaPods/CocoaPods/wiki/Communication-&-Design-Rules), dan [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Maintainers-Avoiding-Burnout.md) adalah beberapa contoh projek dengan peraturan asas untuk penyelenggara dan penyumbang.

### Jaga komunikasi secara terbuka

Jangan lupa untuk mendokumentasikan interaksi anda juga. Di mana sahaja anda boleh, teruskan komunikasi mengenai projek anda kepada umum. Sekiranya seseorang cuba menghubungi anda secara peribadi untuk membincangkan permintaan ciri atau keperluan sokongan, arahkan mereka dengan sopan ke saluran komunikasi awam, seperti senarai mel atau pelacak masalah.

Sekiranya anda bertemu dengan penyelenggara lain, atau membuat keputusan utama secara tertutup, dokumentasikan perbualan ini di khalayak ramai, walaupun hanya menghantar catatan anda.

Dengan cara itu, sesiapa sahaja yang menyertai komuniti anda akan mendapat akses kepada maklumat yang sama dengan seseorang yang berada di sana selama bertahun-tahun.

## Belajar bila untuk mengatakan tidak

Anda telah menulis perkara. Sebaik-baiknya, semua orang akan membaca dokumentasi anda, tetapi pada hakikatnya, anda harus mengingatkan orang lain bahawa pengetahuan ini ada.

Akan tetapi, segala sesuatu yang ditulis dapat membantu melumpuhkan situasi ketika anda perlu menguatkuasakan peraturan anda.

Mengatakan tidak menyenangkan, tetapi _"Sumbangan anda tidak sesuai dengan kriteria projek ini"_ terasa kurang peribadi daripada _"Saya tidak suka sumbangan anda"_.

Mengatakan tidak berlaku untuk banyak situasi yang akan anda hadapi sebagai penjaga: permintaan ciri yang tidak sesuai dengan ruang lingkup, seseorang menggelincirkan perbincangan, melakukan pekerjaan yang tidak perlu untuk orang lain.

### Pastikan perbualan tetap mesra

Salah satu tempat paling penting yang akan anda praktikkan dengan mengatakan tidak adalah masalah anda dan tarik permintaan. Sebagai penyelenggara projek, anda pasti akan menerima cadangan yang tidak mahu anda terima.

Mungkin sumbangan itu mengubah skop projek anda atau tidak sesuai dengan visi anda. Mungkin idea itu bagus, tetapi pelaksanaannya kurang baik.

Terlepas dari alasannya, adalah mungkin untuk menangani sumbangan yang tidak sesuai dengan standard projek anda.

Sekiranya anda menerima sumbangan yang tidak mahu anda terima, reaksi pertama anda mungkin adalah mengabaikannya atau berpura-pura tidak melihatnya. Melakukannya boleh menyakitkan perasaan orang lain dan bahkan menurunkan semangat penyumbang lain dalam komuniti anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/krausefx?s=180" class="pquote-avatar" alt="avatar">
  Kunci untuk menangani sokongan untuk projek sumber terbuka berskala besar adalah memastikan masalah terus berjalan. Cuba untuk mengelakkan masalah. Sekiranya anda seorang pembangun iOS, anda pasti tahu betapa sukarnya menghantar radar. Anda mungkin akan mendengar 2 tahun kemudian, dan diberitahu untuk mencuba lagi dengan versi iOS terkini.
  <p markdown="1" class="pquote-credit">
— @KrauseFx, ["Scaling open source communities"](https://krausefx.com/blog/scaling-open-source-communities)
  </p>
</aside>

Jangan biarkan sumbangan yang tidak diingini terbuka kerana anda merasa bersalah atau mahu bersikap baik. Lama kelamaan, masalah dan PR anda yang tidak dijawab akan menjadikan kerja projek anda terasa lebih tertekan dan menakutkan.

Lebih baik segera menutup sumbangan yang anda tahu yang anda tidak mahu terima. Sekiranya projek anda sudah mengalami tunggakan yang besar, @steveklabnik mempunyai cadangan untuk [bagaimana menyelesaikan masalah dengan cekap](https://words.steveklabnik.com/how-to-be-an-open-source-gardener).

Kedua, mengabaikan sumbangan akan memberi isyarat negatif kepada komuniti anda. Menyumbang kepada projek boleh menakutkan, terutamanya jika ini pertama kali seseorang. Walaupun anda tidak menerima sumbangan mereka, terima kasih orang yang berada di belakangnya dan terima kasih atas minat mereka. Ini pujian besar!

Sekiranya anda tidak mahu menerima sumbangan:

* **Mengucapkan Terima kasih** atas sumbangan mereka
* **Jelaskan mengapa ia tidak sesuai** dengan skop projek, dan berikan cadangan yang jelas untuk penambahbaikan, jika anda mampu. Bersikap baik, tetapi tegas.
* **Pautan ke dokumentasi yang relevan**, jika anda memilikinya. Sekiranya anda melihat permintaan berulang untuk perkara yang tidak mahu anda terima, tambahkan permintaan tersebut ke dalam dokumentasi anda untuk mengelakkan diri anda berulang.
* **Tutup permintaan**

Anda tidak memerlukan lebih daripada 1-2 ayat untuk bertindak balas. Sebagai contoh, apabila pengguna[celery](https://github.com/celery/celery/) melaporkan ralat berkaitan Windows, @berkerpeksag [responded with](https://github.com/celery/celery/issues/3383):

![Celery screenshot](/assets/images/best-practices/celery.png)

Sekiranya memikirkan untuk tidak menakutkan anda, anda tidak sendirian. Sebagai @jessfraz [put it](https://blog.jessfraz.com/post/the-art-of-closing/):

> Saya telah bercakap dengan penyelenggara dari beberapa projek sumber terbuka yang berbeza, Mesos, Kubernetes, Chromium, dan mereka semua bersetuju bahawa salah satu bahagian yang paling sukar untuk menjadi penyelenggara adalah mengatakan "Tidak" untuk membetulkan yang tidak anda mahukan.

Jangan merasa bersalah kerana tidak mahu menerima sumbangan seseorang. Peraturan pertama sumber terbuka, [according to](https://twitter.com/solomonstre/status/715277134978113536) @shykes: _"Tidak adalah sementara, ya adalah selamanya."_ Walaupun berempati dengan semangat orang lain adalah perkara yang baik, menolak sumbangan tidak sama dengan menolak orang di belakangnya."

Pada akhirnya, jika sumbangan tidak cukup baik, anda tidak berkewajiban untuk menerimanya. Bersikap baik dan responsif apabila orang menyumbang kepada projek anda, tetapi hanya menerima perubahan yang anda benar-benar yakin akan menjadikan projek anda lebih baik. Semakin kerap anda berlatih mengatakan tidak, semakin mudah. Janji.

### Bersikap proaktif

Untuk mengurangkan jumlah sumbangan yang tidak diingini, terangkan proses projek anda untuk menghantar dan menerima sumbangan dalam panduan penyumbang anda.

Sekiranya anda menerima terlalu banyak sumbangan berkualiti rendah, minta penyumbang melakukan sedikit kerja terlebih dahulu, misalnya:

* Isi isu atau templat PR / senarai semak
* Buka masalah sebelum menghantar PR

Sekiranya mereka tidak mematuhi peraturan anda, segera tutup masalahnya dan arahkan ke dokumentasi anda.

Walaupun pendekatan ini mungkin terasa tidak baik pada mulanya, proaktif sebenarnya baik untuk kedua-dua pihak. Ini mengurangkan peluang seseorang untuk meletakkan banyak waktu kerja yang terbuang menjadi permintaan tarik yang tidak akan Anda terima. Dan ini menjadikan beban kerja anda lebih mudah diuruskan.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
  Sebaik-baiknya, jelaskan kepada mereka dan dalam fail CONTRIBUTING.md bagaimana mereka dapat memperoleh petunjuk yang lebih baik di masa depan mengenai perkara yang akan atau tidak akan diterima sebelum mereka memulakan kerja.
  <p markdown="1" class="pquote-credit">
— @MikeMcQuaid, ["Permintaan Tarik Penutup dengan Baik"](https://github.com/blog/2124-kindly-closing-pull-requests)
  </p>
</aside>

Kadang kala, apabila anda mengatakan tidak, calon penyumbang anda mungkin marah atau mengecam keputusan anda. Sekiranya tingkah laku mereka menjadi bermusuhan, [ambil langkah untuk meredakan keadaan](https://github.com/jonschlinkert/maintainers-guide-to-staying-positive#action-items) or even remove them from your community, if they're not willing to collaborate constructively.

### Ikuti bimbingan

Mungkin seseorang dalam komuniti anda kerap menghantar sumbangan yang tidak memenuhi piawaian projek anda. Ini boleh membuat frustasi bagi kedua-dua pihak untuk berulang kali menolak.

Sekiranya anda melihat bahawa seseorang berminat dengan projek anda, tetapi memerlukan sedikit penggilap, bersabarlah. Terangkan dengan jelas dalam setiap situasi mengapa sumbangan mereka tidak memenuhi jangkaan projek. Cuba arahkan mereka ke tugas yang lebih mudah atau tidak samar-samar, seperti masalah yang ditandai _"isu pertama yang baik",_ agar kaki mereka basah. Sekiranya anda mempunyai masa, pertimbangkan untuk membimbing mereka melalui sumbangan pertama mereka, atau cari orang lain dalam komuniti anda yang mungkin bersedia membimbing mereka.

## Macamana manfaatkan komuniti anda

Anda tidak perlu melakukan semuanya sendiri. Komuniti projek anda wujud dengan alasan! Walaupun anda belum mempunyai komuniti penyumbang aktif, jika anda mempunyai banyak pengguna, buat mereka bekerja.

### Berkongsi beban kerja

Sekiranya anda sedang mencari orang lain, mulakan dengan bertanya-tanya

Salah satu cara untuk mendapatkan penyumbang baru adalah dengan secara eksplisit [melabelkan masalah yang cukup mudah untuk ditangani oleh pemula](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). GitHub kemudian akan mengemukakan permasalahan ini di pelbagai tempat di platform, sehingga meningkatkan keterlihatannya.

Apabila anda melihat penyumbang baru memberikan sumbangan berulang, kenali karya mereka dengan menawarkan lebih banyak tanggungjawab. Mendokumentasikan bagaimana orang lain dapat berkembang menjadi peranan kepemimpinan jika mereka mahu.

Menggalakkan orang lain untuk [berkongsi pemilikan projek](../building-community/#kongsi-pemilikan-projek-anda) dapat mengurangkan beban kerja anda sendiri, seperti yang dijumpai oleh @lmccart pada projeknya, [p5.js](https://github.com/processing/p5.js).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lmccart?s=180" class="pquote-avatar" alt="avatar">
  Saya pernah berkata, "Ya, sesiapa sahaja boleh terlibat, anda tidak perlu mempunyai banyak kepakaran pengekodan [...]." Kami ada orang yang mendaftar untuk datang [ke suatu acara] dan ketika itulah saya benar-benar bertanya-tanya: adakah ini benar, apa yang saya katakan? Akan ada 40 orang yang muncul, dan sepertinya saya tidak boleh duduk bersama mereka masing-masing ... Tetapi orang-orang datang bersama, dan ia cukup berjaya. Sebaik sahaja seseorang mendapatkannya, mereka dapat mengajar jiran mereka.
  <p markdown="1" class="pquote-credit">
—  @lmccart, ["What Does "Open Source" Even Mean? p5.js Edition"](https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39)
  </p>
</aside>

Sekiranya anda perlu menjauhkan diri dari projek anda, sama ada dalam masa rehat atau kekal, tidak ada rasa malu untuk meminta orang lain mengambil alih tugas anda.

Sekiranya orang lain berminat dengan arahannya, beri mereka akses atau menyerahkan kawalan secara rasmi kepada orang lain. Sekiranya seseorang membuat projek anda secara aktif dan secara aktif menyelenggarakannya di tempat lain, pertimbangkan untuk menghubungkan ke garpu dari projek asal anda. Senang sekali bahawa ramai orang mahu projek anda terus berjalan!

@progrium [found that](https://web.archive.org/web/20151204215958/https://progrium.com/blog/2015/12/04/leadership-guilt-and-pull-requests/) mendokumentasikan visi untuk projeknya, [Dokku](https://github.com/dokku/dokku), membantu tujuan tersebut terus dicapai walaupun dia melangkah keluar dari projek:

> Saya menulis halaman wiki yang menerangkan apa yang saya mahukan dan mengapa saya menginginkannya. Atas sebab-sebab tertentu, mengejutkan saya bahawa penyelenggara mula memindahkan projek ke arah itu! Adakah ia berlaku seperti bagaimana saya melakukannya? Tidak selalu. Tetapi projek ini masih mendekatkan apa yang saya tulis.

### Biarkan orang lain membina penyelesaian yang mereka perlukan

Sekiranya calon penyumbang mempunyai pendapat yang berbeza mengenai apa yang harus dilakukan oleh projek anda, anda mungkin ingin mendorong mereka untuk mengusahakan garpu mereka dengan lembut.

Memaksa projek tidak harus menjadi perkara yang buruk. Mampu menyalin dan mengubahsuai projek adalah salah satu perkara terbaik mengenai sumber terbuka. Menggalakkan ahli komuniti anda untuk bekerja di garpu mereka sendiri dapat menyediakan saluran kreatif yang mereka perlukan, tanpa bertentangan dengan visi projek anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/geerlingguy?s=180" class="pquote-avatar" alt="avatar">
  Saya memenuhi kes penggunaan 80%. Sekiranya anda adalah salah satu unicorn, sila buat kerja saya. Saya tidak akan tersinggung! Projek awam saya hampir selalu bertujuan untuk menyelesaikan masalah yang paling biasa; Saya berusaha mempermudah saya dengan lebih mendalam dengan mengerjakan kerja saya atau memanjangkannya.
  <p markdown="1" class="pquote-credit">
— @geerlingguy, ["Why I Close PRs"](https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes)
  </p>
</aside>

Perkara yang sama berlaku untuk pengguna yang benar-benar mahukan penyelesaian yang anda tidak mempunyai lebar jalur untuk dibina. Menawarkan API dan penyesuaian dapat membantu orang lain memenuhi keperluan mereka sendiri, tanpa harus mengubah sumbernya secara langsung. @orta [found that](https://artsy.github.io/blog/2016/07/03/handling-big-projects/) pemalam yang menggalakkan untuk CocoaPod membawa kepada "beberapa idea yang paling menarik":

> Hampir tidak dapat dielakkan apabila projek menjadi besar, penyelenggara harus menjadi lebih konservatif mengenai bagaimana mereka memperkenalkan kod baru. Anda menjadi pandai mengatakan "tidak", tetapi banyak orang mempunyai keperluan yang sah. Oleh itu, anda akhirnya menukar alat anda menjadi platform.

## Belajar proses mana yang perlu automatik (robots)

Sama seperti ada tugas yang dapat ditolong oleh orang lain, ada juga tugas yang tidak perlu dilakukan oleh manusia. Robot adalah rakan anda. Gunakan mereka untuk menjadikan hidup anda sebagai penyelenggara lebih mudah.

### Memerlukan ujian dan pemeriksaan lain untuk meningkatkan kualiti kod anda

Salah satu cara terpenting untuk mengautomasikan projek anda adalah dengan menambahkan ujian.

Ujian membantu penyumbang merasa yakin bahawa mereka tidak akan merosakkan apa-apa. Mereka juga memudahkan anda menyemak dan menerima sumbangan dengan cepat. Semakin responsif anda, semakin aktif komuniti anda.

Sediakan ujian automatik yang akan dijalankan pada semua sumbangan yang masuk, dan pastikan ujian anda dapat dijalankan dengan mudah secara tempatan oleh penyumbang. Wajibkan semua sumbangan kod lulus ujian anda sebelum dapat dihantar. Anda akan membantu menetapkan standard kualiti minimum untuk semua penyerahan. [Pemeriksaan status yang diperlukan] (<https://help.github.com/articles/about-required-status-checks/>) di GitHub dapat membantu memastikan tiada perubahan digabungkan tanpa ujian anda lulus.

Sekiranya anda menambahkan ujian, pastikan untuk menerangkan bagaimana ia berfungsi dalam fail CONTRIBUTING anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/edunham?s=180" class="pquote-avatar" alt="avatar">
  Saya percaya bahawa ujian diperlukan untuk semua kod yang diusahakan oleh orang lain. Sekiranya kodnya betul dan betul, ia tidak memerlukan perubahan - kami hanya menulis kod apabila ada yang tidak kena, sama ada "Ia rosak" atau "Tidak mempunyai ciri seperti itu". Dan tanpa mengira perubahan yang anda buat, ujian sangat penting untuk mengatasi kemunduran yang mungkin anda buat secara tidak sengaja.
  <p markdown="1" class="pquote-credit">
— @edunham, ["Rust's Community Automation"](https://edunham.net/2016/09/27/rust_s_community_automation.html)
  </p>
</aside>

### Gunakan alat untuk mengautomasikan tugas penyelenggaraan asas

Berita baik tentang mengekalkan projek yang popular ialah penyelenggara lain mungkin menghadapi masalah serupa dan membina jalan penyelesaian untuknya.

Terdapat [pelbagai alat tersedia](https://github.com/showcases/tools-for-open-source)untuk membantu mengautomasikan beberapa aspek kerja penyelenggaraan. Beberapa contoh:

* [semantic-release](https://github.com/semantic-release/semantic-release) mengautomasikan siaran anda
* [mention-bot](https://github.com/facebook/mention-bot) menyebut pengulas berpotensi untuk permintaan tarik
* [Danger](https://github.com/danger/danger) membantu mengautomasikan semakan kod
* [no-response](https://github.com/probot/no-response) menutup masalah di mana pengarang tidak menjawab permintaan untuk mendapatkan maklumat lebih lanjut
* [dependabot](https://github.com/dependabot) memeriksa fail kebergantungan anda setiap hari untuk keperluan yang ketinggalan zaman dan membuka permintaan tarikan individu untuk apa sahaja yang dijumpainya

Fatau laporan pepijat dan sumbangan umum lain, GitHub mempunyai [Templat Masalah dan Templat Tarik Permintaan] (<https://github.com/blog/2111-issue-and-pull-request-templates>), yang boleh anda buat untuk melancarkan komunikasi anda terima. @TalAter membuat [Pilih panduan Pengembaraan Anda Sendiri] (<https://www.talater.com/open-source-templates/#/>) untuk membantu anda menulis isu dan templat PR anda.

Untuk menguruskan pemberitahuan e-mel anda, anda boleh menyiapkan [penapis e-mel] (<https://github.com/blog/2203-email-updates-about-your-own-activity>) untuk disusun mengikut keutamaan.

Sekiranya anda ingin mendapatkan sedikit lebih maju, panduan gaya dan pelapis dapat menyeragamkan sumbangan projek dan menjadikannya lebih mudah untuk disemak dan diterima.

Namun, jika piawaian anda terlalu rumit, ia dapat meningkatkan halangan untuk menyumbang. Pastikan anda hanya menambahkan peraturan yang cukup untuk menjadikan kehidupan semua orang lebih mudah.

Sekiranya anda tidak pasti alat mana yang harus digunakan, perhatikan apa yang dilakukan oleh projek popular lain, terutamanya yang ada di ekosistem anda. Sebagai contoh, bagaimana proses sumbangan untuk modul Node yang lain? Menggunakan alat dan pendekatan yang serupa juga akan menjadikan proses anda lebih akrab dengan penyumbang sasaran anda.

## Tidak apa-apa untuk berhenti sebentar

Kerja sumber terbuka sekali memberikan kegembiraan kepada anda. Mungkin sekarang ini mula membuat anda merasa terhindar atau bersalah.

Mungkin anda merasa terharu atau rasa takut yang semakin meningkat ketika anda memikirkan projek anda. Sementara itu, permasalahan dan permintaan tarik semakin bertambah.

Burnout adalah masalah yang nyata dan meluas dalam kerja sumber terbuka, terutama di kalangan penyelenggara. Sebagai penjaga, kebahagiaan anda adalah syarat yang tidak dapat dirundingkan untuk kelangsungan projek sumber terbuka mana pun.

Walaupun tidak boleh dikatakan, berehat sebentar! Anda tidak perlu menunggu sehingga anda merasa terbakar untuk bercuti. @brettcannon, pemaju teras Python, memutuskan untuk mengambil [percutian selama sebulan] (<https://snarky.ca/why-i-took-october-off-from-oss-volunteering/>) setelah 14 tahun OSS sukarela bekerja.

Sama seperti jenis pekerjaan lain, berehat sebentar akan membuat anda segar, gembira, dan gembira dengan pekerjaan anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielbachhuber?s=180" class="pquote-avatar" alt="avatar">
  Dalam mengekalkan WP-CLI, saya mendapati bahawa saya harus membuat diri saya bahagia terlebih dahulu, dan menetapkan batasan yang jelas mengenai penglibatan saya. Imbangan terbaik yang saya dapati adalah 2-5 jam seminggu, sebagai sebahagian daripada jadual kerja biasa saya. Ini menjadikan penglibatan saya menjadi minat, dan daripada merasa terlalu suka bekerja. Kerana saya mengutamakan masalah yang sedang saya jalankan, saya dapat membuat kemajuan secara berkala terhadap perkara yang saya rasa paling penting.
  <p markdown="1" class="pquote-credit">
— @danielbachhuber, ["Takziah, anda sekarang menjadi penyelenggara projek sumber terbuka yang popular"](https://web.archive.org/web/20220306014037/https://danielbachhuber.com/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/)
  </p>
</aside>

Kadang-kadang, sukar untuk mengambil cuti dari kerja sumber terbuka apabila terasa seperti semua orang memerlukan anda. Orang mungkin juga berusaha membuat anda merasa bersalah kerana melangkah pergi.

Lakukan yang terbaik untuk mencari sokongan untuk pengguna dan komuniti anda semasa anda jauh dari projek. Sekiranya anda tidak dapat mencari sokongan yang anda perlukan, istirahatlah pula. Pastikan anda berkomunikasi ketika anda tidak ada, sehingga orang tidak bingung dengan kekurangan respons anda.

Beristirahat juga berlaku untuk lebih daripada sekadar percutian. Sekiranya anda tidak mahu melakukan kerja sumber terbuka pada hujung minggu, atau semasa waktu kerja, sampaikan harapan tersebut kepada orang lain, sehingga mereka tahu untuk tidak mengganggu anda.

## Jaga diri anda terlebih dahulu!

Mengekalkan projek yang popular memerlukan kemahiran yang berbeza daripada tahap pertumbuhan yang lebih awal, tetapi ia tidak kurang memberangsangkan. Sebagai penyelenggara, anda akan mempraktikkan kepemimpinan dan kemahiran peribadi pada tahap yang dapat dialami oleh beberapa orang. Walaupun tidak selalu mudah dikendalikan, menetapkan batas yang jelas dan hanya mengambil perkara yang anda selesa akan membantu anda tetap bahagia, segar, dan produktif.
