---
lang: ko
title: 오픈소스에 기여하는 방법
description: 오픈소스에 기여하고 싶으세요? 초보자와 숙련자를 위한 오픈소스 기여 가이드입니다.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## 왜 오픈소스에 기여할까요?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Working on \[freenode\] helped me earn many of the skills I later used for my studies in university and my actual job. I think working on open source projects helps me as much as it helps the project!
  <p markdown="1" class="pquote-credit">
— @errietta, ["Why I love contributing to open source software”](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

오픈소스에 기여하는 것은 여러분이 상상할 수 있는 모든 기술을 배우고, 가르치고, 구현하는 보람찬 방법이 될 수 있습니다.

왜 사람들은 오픈소스에 기여할까요? 많은 이유가 있습니다!

### 기존 기술을 향상시키세요

코딩, 사용자 인터페이스 디자인, 그래픽 디자인, 글쓰기 또는 조직화 등의 실습을 원한다면 여러분이 맡을 수 있는 오픈소스 프로젝트 작업이 기다리고 있습니다.

### 비슷한 것에 관심 있는 사람들을 만나세요

따뜻한 커뮤니티가 있는 오픈소스 프로젝트는 사람들은 오래 머물게 합니다. 많은 사람들이 오픈소스에 참여하며 평생의 우정을 다지고 있습니다. 그게 회의에서 서로를 마주치는 것이든 한밤중에 부리토에 관해 채팅을 하는 것이든 상관없이요.

### 멘토를 찾고 사람들과 배움을 주고받으세요

공유 프로젝트에서 다른 사람들과 함께 일한다는 것은 여러분이 무엇을 어떻게 하는지 설명하고, 다른 사람들에게 도움을 요청해야 함을 의미합니다. 학습하고 가르치는 행위는 관련된 모든 사람들에게 성취감 있는 활동이 될 수 있습니다.

### 평판(과 경력)을 쌓는 데 도움이 되는 예제를 만드세요

정의에 따라 모든 오픈소스 저작물은 공개되어 있으므로, 당신이 할 수 있는 것을 보여줄 예제를 가질 수 있는 셈입니다.

### 사람을 대하는 기술을 습득하세요

오픈소스는 충돌 해결, 팀 구성, 작업 우선순위 지정과 같은 리더십 및 관리 기술을 연습할 수 있는 기회를 제공합니다.

### 작은 것조차도 바꿀 수 있는 힘이 있습니다

오픈소스에 참여하는 것을 즐기는 평생 기여자가 될 필요는 없습니다. 웹 사이트에서 오타를 발견하고 누군가가 고쳐주길 바란 적 있나요? 오픈소스 프로젝트에서 여러분은 그렇게 할 수 있습니다. 오픈소스는 사람들이 삶에 대해 어떻게 대처하고 그들이 세상을 경험하는지를 느끼도록 도와줍니다.

## 기여한다는 것의 의미

새로운 오픈소스 기여자라면, 기여하는 과정이 겁날 수도 있습니다. 알맞은 프로젝트를 어떻게 찾아야 할까요? 코딩을 할 줄 모른다면요? 뭔가 잘못되면 어떡하죠?

걱정 마세요! 오픈소스 프로젝트에 참여하는 데는 여러 가지 방법이 있으며, 몇 가지 팁을 통해 경험을 최대한 활용할 수 있습니다.

### 코드를 제공할 필요가 없습니다

오픈소스에 기여하는 것에 대한 일반적인 오해는 코드를 작성해야 한다는 것입니다. 사실, 프로젝트의 다른 부분이 [무시되거나 간과되는 경우](https://github.com/blog/2195-the-shape-of-open-source)가 더 많습니다. 이러한 유형의 기여에 동참하겠다고 제안하면 프로젝트에 큰 도움이 될 것입니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  I’ve been renowned for my work on CocoaPods, but most people don’t know that I actually don’t do any real work on the CocoaPods tool itself. My time on the project is mostly spent doing things like documentation and working on branding.
  <p markdown="1" class="pquote-credit">
— @orta, ["Moving to OSS by default”](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

코드를 작성하는 것을 좋아해도, 다른 유형의 기여는 프로젝트에 참여하고 다른 커뮤니티 구성원을 만날 수 있는 좋은 방법입니다. 이러한 관계를 구축하면 프로젝트의 다른 부분에서 작업할 기회를 얻을 수 있습니다.

### 행사 계획 짜는 걸 좋아하세요?

* [NodeSchool을 위해 @fzamperin이 했던 것처럼](https://github.com/nodeschool/organizers/issues/406), 프로젝트에 관한 워크샵이나 미팅 조직하기
* 프로젝트 컨퍼런스 구성하기 (있는 경우)
* 커뮤니티 구성원이 적합한 컨퍼런스를 찾고 발언을 위한 제안서를 제출할 수 있도록 지원하기

### 디자인을 하고 싶으세요?

* 프로젝트의 유용성을 높이기 위해 레이아웃 재구성하기
* [Drupal의 제안](https://www.drupal.org/community-initiatives/drupal-core/usability)처럼, 사용자 조사를 통해 프로젝트의 네비게이션 또는 메뉴를 재구성하고 개선하기
* 프로젝트가 일관성 있는 시각적 디자인을 가질 수 있도록 스타일 가이드 작성하기
* [hapi.js의 기여](https://github.com/hapijs/contrib/issues/68)처럼, 티셔츠 혹은 새로운 로고를 위한 예술 작품 만들기

### 글을 쓰고 싶으신가요?

* 프로젝트 문서 작성 및 개선하기
* 프로젝트 사용법을 보여주는 예제 폴더 선별하기
* 프로젝트의 뉴스레터 발행을 시작하거나 메일링 리스트의 하이라이트를 관리하기
* [PyPA의 기여처럼](https://packaging.python.org/), 프로젝트 튜토리얼 작성하기
* 프로젝트 문서 번역 작성하기

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Seriously, \[documentation\] is mega-important. The documentation so far has been great and has been a killer feature of Babel. There are sections that could certainly use some work and even the addition of a paragraph here or there is extremely appreciated.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Call for contributors”](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### 조직하는 것을 좋아하세요?

* 중복된 이슈에 대한 링크 및 새로운 이슈 라벨 제안, 정리된 상태 유지하기
* [ESLint의 @nzakas](https://github.com/eslint/eslint/issues/6765)처럼, 열려있는 이슈를 검토하고 오래된 이슈를 닫을 것을 제안하기 
* 최근 열린 이슈에 대한 질문을 명확히 하여 토론으로 나아가게 하기

### 코드를 작성하고 싶으세요?

* [Leaflet의 @dianjin처럼](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560), 해결할 문제를 찾기
* 새로운 기능을 작성하는 데 도움을 줄 수 있는지 물어보기
* 프로젝트 설정 자동화하기
* 툴링 및 테스트 개선하기

### 사람들을 돕는 것을 좋아하세요?

* Stack Overflow([Postgres 예시](http://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) 혹은 Reddit에서 프로젝트에 관련된 질문에 답변하기
* 열린 이슈에서 사람들의 질문에 답변하기
* 토론 게시판이나 대화 채널 관리 돕기

### 사람들의 코드 작성을 돕고 싶으세요?

* 사람들이 제출한 코드 리뷰하기
* 프로젝트를 어떻게 이용하는가에 대한 튜토리얼 작성하기
* [Rust의 @ereichert가 @bronzdoc에게 해준 것처럼](https://github.com/rust-lang/book/issues/123#issuecomment-238049666), 다른 기여자의 멘토가 되는 것을 제안하기

### 꼭 소프트웨어 프로젝트에서 작업할 필요는 없습니다!

"오픈소스"는 보통 소프트웨어를 의미하지만, 무엇이든 간에 거의 협력할 수 있습니다. 오픈소스 프로젝트로 개발되는 책, 요리법, 리스트 및 수업도 있습니다.

예를 들면:

* @sindresorhus는 [list of "awesome" lists](https://github.com/sindresorhus/awesome)를 만들었습니다
* @h5bp는 프론트엔드 개발자 후보군용 [list of potential interview questions](https://github.com/h5bp/Front-end-Developer-Interview-Questions)을 관리하고 있습니다
* @stuartlynn과 @nicole-a-tesla는 [collection of fun facts about puffins](https://github.com/stuartlynn/puffin_facts)를 만들었습니다

비록 당신이 소프트웨어 개발자일지라도, 문서 프로젝트 작업은 오픈소스에서 시작하는 데 도움이 될 수 있습니다. 코드를 포함하지 않는 프로젝트에서 작업하는 것은 보통 어렵지 않으며, 협력하는 과정에서 여러분의 자신감과 경험을 쌓을 수 있을 것입니다.

## 새 프로젝트로 향하기

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  If you go to an issue tracker and things seem confusing, it's not just you. These tools require a lot of implicit knowledge, but people can help you navigate it and you can ask them questions.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["How to Contribute to Open Source”](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

오타를 수정하는 것 이상으로 오픈소스에 기여하는 것은 파티에서 낯선 사람들에게 다가가는 것과 같습니다. 사람들이 금붕어에 대한 깊은 토론에 빠져 있을 때 라마에 대해 이야기한다면 그들은 아마 여러분을 약간 이상하게 볼 겁니다.

맹목적으로 여러분의 제안을 펼치기 전에, 방의 분위기를 읽는 법을 배우는 것부터 시작하세요. 그러면 여러분의 아이디어에 귀 기울여 줄 가능성이 높아집니다.

### 오픈소스 프로젝트의 해부학

모든 오픈소스 커뮤니티는 서로 다릅니다.

여러 해 동안 한 오픈소스 프로젝트에 투자했다면 그 프로젝트를 잘 알게 됐을 것입니다. 다른 프로젝트로 넘어가면 어휘, 표준, 커뮤니케이션 스타일이 완전히 다르다는 것을 알 수 있습니다.

많은 오픈소스 프로젝트는 비슷한 조직 구조를 따릅니다. 다양한 커뮤니티 역할과 전반적인 프로세스를 이해하면 새로운 프로젝트에 빠르게 적응할 수 있습니다.

일반적인 오픈소스 프로젝트에서 사람들은 다음과 같은 유형으로 나뉩니다.

* **작성자:** 이 프로젝트를 만든 사람 혹은 조직
* **소유자:** 조직 또는 저장소에 대한 관리 권한을 가진 사람 (항상 원래 작성자와 동일하지는 않음)
* **메인테이너:** 비전을 주도하고 프로젝트의 조직 측면을 관리하는 책임이 있는 기여자 (그들은 프로젝트의 저자 또는 소유자일 수도 있습니다.)
* **기여자:** 프로젝트에 기여한 모든 사람.
* **커뮤니티 맴버:** 프로젝트를 사용하는 사람들. 적극적으로 대화에 참여하거나 프로젝트 방향에 대한 의견을 제시할 수도 있습니다.

더 큰 프로젝트에는 툴링, 선별, 커뮤니티 중재 및 이벤트 조직과 같은 다양한 업무에 초점을 둔 소위원회 또는 실무 그룹이 있을 수도 있습니다. 프로젝트 웹 사이트에서 "팀" 페이지를 찾거나 거버넌스 문서 저장소에서 정보를 찾아보세요.

프로젝트에도 문서가 있습니다. 이러한 파일은 대개 저장소의 최상위 레벨에 나열됩니다.

* **LICENSE:** 정의에 의해, 모든 오픈소스 프로젝트는 반드시 [오픈소스 라이선스를 가져야 합니다](https://choosealicense.com). 만약 프로젝트가 라이선스를 가지지 않는다면, 이건  오픈소스가 아닙니다.
* **README:** README는 새로운 커뮤니티 구성원을 프로젝트에 환영하는 지침서입니다. 왜 프로젝트가 유용한지, 어떻게 시작해야 할지 설명합니다.
* **CONTRIBUTING:** README는 사람들이 프로젝트를 사용하는 데 도움이되지만, CONTRIBUTING 문서는 사람들이 프로젝트에 _기여_하는 데 도움이 됩니다. 필요한 기여 유형과 프로세스 작동 방식을 설명합니다. 모든 프로젝트가 CONTRIBUTING 파일을 갖고 있는 것은 아니지만, 이 파일이 있다면 여러분의 기여를 환영한다는 뜻입니다.
* **CODE_OF_CONDUCT:** Code of Conduct(윤리 강령)는 참가자의 행동에 대한 기본 원칙을 정하고, 친절하고 따뜻한 환경을 조성하는 데 도움이 됩니다. 마찬가지로 모든 프로젝트가 CODE_OF_CONDUCT 파일을 가지고 있지는 않지만, 이 파일이 있다면 여러분의 기여를 환영한다는 뜻입니다.
* **다른 문서:** (특히 큰 프로젝트의 경우) 튜토리얼, 연습장 또는 거버넌스 정책과 같은 추가 문서가 있을 수 있습니다.

마지막으로 오픈소스 프로젝트는 다음 도구를 사용하여 토론을 구성합니다. 기록 보관소를 읽으면 커뮤니티가 어떻게 사고하고 작동하는지 잘 알 수 있습니다.

* **Issue tracker:** 프로젝트와 관련된 이슈를 토론하는 공간입니다.
* **Pull requests:** 지금 진행 중인 변경 사항에 대해 논의하고 검토하는 공간입니다.
* **토론 포럼 혹은 메일링 리스트:** 일부 프로젝트는 회화성 주제(버그 제보나 기능 요구 대신 _"...하려면 어떻게 하나요?"_ 또는 _"...에 대해 어떻게 생각하세요?"_ 같은 주제)에 대해 이러한 채널을 사용할 수 있습니다. 나머지 프로젝트는 모든 대화에 이슈 트래커를 사용합니다.
* **채팅 채널:** 일부 프로젝트에서는 일상 대화, 협업 및 빠른 의사소통을 위해 Slack이나 IRC 같은 채팅 채널을 사용합니다.

## 기여할 프로젝트 찾기

오픈소스 프로젝트가 어떻게 작동하는지 알았으니, 이제 기여할 프로젝트를 찾아야 합니다!

이전에 오픈 소스에 기여한 적이 없다면, 미국 존 케네디 대통령의 명언을 떠올려보세요. 
_"Ask not what your country can do for you - ask what you can do for your country."_
_"국가가 나를 위해 무엇을 해줄 것을 바라기에 앞서, 내가 국가를 위해 무엇을 할 것인가를 생각해야 한다."_

오픈소스에 기여하는 것은 프로젝트 전반에 걸쳐 모든 수준에서 발생합니다. 여러분의 첫 번째 기여가 정확히 무엇이고 어떻게 보일지 생각할 필요가 없습니다.

대신, 이미 사용하고 있거나 사용하고 싶은 프로젝트에 대해 생각하는 것으로 시작하세요. 여러분이 적극적으로 기여하게 될 프로젝트는 여러분이 계속 사용하게 되는 프로젝트입니다.

그 프로젝트에서, 뭔가가 더 좋거나 다를 수 있다고 생각할 때마다 본능에 따라 행동하세요.

오픈소스는 독점적인 클럽이 아닙니다. 여러분과 같은 사람들에 의해 만들어졌습니다. "오픈소스"는 전세계의 문제들을 유연하게 해결할 수 있는 멋진 용어입니다.

README를 스캔하여 깨진 링크나 오타를 찾을 수 있습니다. 또는 여러분이 새로운 사용자로서 제대로 동작하지 않거나 문서에서 다뤄져야 할 이슈를 발견할 수도 있습니다. 그것을 무시하거나 다른 사람에게 그것을 고쳐달라고 하는 대신, 여러분이 직접 도움을 줄 수 있는지 알아보세요. 그것이 바로 오픈소스입니다!

> [일반적인 기여의 28%](http://www.igor.pro.br/publica/papers/saner2016.pdf)는 오타 수정, 서식 재지정 또는 번역 작성과 같은 문서입니다.

다음 리소스 중 하나를 사용하여 새 프로젝트를 찾고 기여할 수 있습니다.

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)

### 기여하기 전 확인할 사항

기여하고 싶은 프로젝트를 찾았으면, 프로젝트가 기여를 받기에 적합한지 빠르게 확인하세요. 그렇지 않으면, 노력이 영원히 응답을 받지 못할 수도 있습니다.

다음은 프로젝트가 새로운 기여자에게 적합한지 평가할 수 있는 편리한 체크리스트입니다.

**오픈소스의 정의를 충족시킬 것**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  라이선스가 있나요? 대부분, 저장소의 최상단에 있는 LICENSE라 불리는 파일입니다.
  </label>
</div>

**프로젝트가 적극적으로 기여를 받아들일 것**

마스터 브랜치에서 커밋 활동을 살펴보세요. GitHub에서는 이 정보를 저장소의 홈페이지에서 볼 수 있습니다.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  마지막 커밋은 언제였나요?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  몇 명의 기여자가 프로젝트에 참여했나요?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  사람들이 얼마나 자주 커밋하나요? (GitHub에서는 상단 바에 있는 "Commits"를 클릭하면 볼 수 있습니다.)
  </label>
</div>

다음으로, 프로젝트의 이슈를 보세요.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    얼마나 많은 열린 이슈가 있나요?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    관리자가 열린 이슈에 신속하게 대응하나요?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    이슈에 대한 활발한 토론이 있나요?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    최근에 이슈가 있나요?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    이슈가 닫히고 있나요? (GitHub에서는, Issues 페이지에서 닫힌 이슈를 "closed" 탭을 눌러 볼 수 있습니다.)
  </label>
</div>

이번엔 프로젝트의 풀 리퀘스트(PR)를 확인하세요.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    얼마나 많은 PR이 열려 있나요?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    관리자가 열린 PR에 신속하게 대응하나요?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    PR에서 활발한 토론이 진행되나요?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    최근에 PR이 있나요?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    최근에 PR이 병합된 건 언제인가요? (GitHub에서는, Pull requests 페이지에서 "closed" 탭을 눌러 닫힌 PR을 볼 수 있습니다.)
  </label>
</div>

**프로젝트가 기여자를 환영할 것**

친근하고 환영하는 분위기의 프로젝트는 새로운 기여자를 기꺼이 맞이합니다.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    관리자가 이슈의 질문에 도움이 되는 답변을 주나요?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    이슈, 토론 포럼 및 채팅(IRC 혹은 Slack 등)에 있는 사람들이 친절한가요?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    PR이 리뷰를 받고 있나요?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    관리자가 기여자들에게 감사를 표하고 있나요?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Whenever you see a long thread, spot check responses from core developers coming late in the thread. Are they summarizing constructively, and taking steps to bring the thread to a decision while remaining polite? If you see a lot of flame wars going on, that's often a sign that energy is going into argument instead of into development.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](http://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## 기여하는 방법

기여하고 싶은 프로젝트를 찾았나요? 드디어! 기여하는 올바른 방법은 다음과 같습니다.

### 효과적으로 의사소통하기

하나의 기여를 하든 커뮤니티에 참여하려고 하든, 관계없이 다른 사람들과 협력하는 것은 오픈소스에서 개발할 가장 중요한 기술 중 하나입니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[As a new contributor,\] I quickly realized I had to ask questions if I wanted to be able to close the issue. I skimmed through the code base. Once I had some sense of what was going on, I asked for more direction. And voilà! I was able to solve the issue after getting all the relevant details I needed.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [A Beginner’s Very Bumpy Journey Through The World of Open Source](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

이슈나 PR을 열거나 채팅에서 질문을 하기 전에 아이디어를 효과적으로 전달할 수 있도록 아래와 같은 사항을 명심하세요.

**맥락을 제공하세요.** 다른 사람들이 빨리 속도를 낼 수 있도록 도와주세요. 오류가 발생하면 수행하려는 작업과 오류를 재현하는 방법을 설명하세요. 새로운 아이디어를 제안하는 경우 그것이 (여러분이 아닌) 프로젝트에 유용하다고 생각하는 이유를 설명하세요.

> 😇 _"Y를 할 때 X가 안 돼요."_
>
> 😢 _"X가 안 돼요! 이거 고쳐주세요."_

**과제를 미리 하세요.** 이해하지는 못하지만 시도해봤다는 것을 보여주세요. 도움을 요청하기 전에 프로젝트의 README, 문서, (열린 혹은 닫힌) 이슈, 메일링 리스트를 확인하고 인터넷에서 해결책을 검색해보세요. 당신이 배우려는 자세를 보이면 사람들은 존중할 것입니다.

> 😇 _"X를 구현하는 방법을 잘 모르겠어요. 도움말 문서를 확인했지만 관련 언급을 찾지 못했어요."_
>
> 😢 _"X는 어떻게 해요?"_

**짧고 직접적으로 요청하세요.** 이메일을 보내는 것과 마찬가지로, 모든 기여는 아무리 간단하거나 도움이 된다 하더라도 다른 사람의 검토가 필요합니다. 많은 프로젝트가 사람들이 도울 수 있는 것보다 많은 요청을 받고 있습니다. 간결하게 적으세요. 누군가 당신을 도울 가능성이 늘어날 것입니다.

> 😇 _"API 튜토리얼을 작성하고 싶어요."_
>
> 😢 _"요전날 고속도로를 따라 차를 몰고 가다가 주유소에 들렀는데, 우리가 해야 할 일에 대한 놀라운 아이디어가 떠올랐어요. 하지만 설명해드리기 전에 보셔야 할 게 있는데요…"_

**모든 의사소통을 공개하세요.** 매혹적이긴 하지만 보안 문제나 심각한 규칙 위반 같은 중요한 정보를 공유해야 하는 경우가 아니면 관리자에게 개인적으로 연락하지 마세요. 대화를 공개해야 더 많은 사람들이 여러분의 교류를 통해 배우고 이익을 얻을 수 있습니다. 토론은 그 자체로 기여가 됩니다.

> 😇 _(댓글로) "@-관리자 안녕하세요! 이 PR은 어떻게 진행되고 있나요?"_
>
> 😢 _(이메일로) "안녕하세요, 메일로 귀찮게 해서 죄송합니다만 제 PR을 검토해보셨는가 해서요."_

**질문하는 것은 좋지만 참을성을 가지세요.** 누구나 프로젝트를 처음 접했을 때가 있으며 경험 많은 기여자도 새로운 프로젝트에는 가속이 필요합니다. 마찬가지로 오랜 관리자도 프로젝트의 모든 부분을 항상 잘 알고 있는 것은 아닙니다. 여러분이 기대하는 만큼의 인내심을 사람들에게 보여주세요.

> 😇 _"이 오류를 알아봐 주셔서 감사합니다. 제안을 따라 고쳐 봤어요. 이렇게 출력되네요."_
>
> 😢 _"왜 이 문제를 해결할 수 없는 거죠? 이 프로젝트는 관리자님이 만든 게 아닌가요?"_

**커뮤니티의 결정을 존중하세요.** 여러분의 아이디어는 커뮤니티의 우선순위나 비전과 다를 수 있습니다. 그들은 개선점을 제시하거나 여러분의 아이디어를 도입하지 않기로 결정할 수 있습니다. 절충안을 논의하는 동안 관리자는 여러분보다 오래 여러분의 결정을 고려해야 합니다. 여러분이 커뮤니티의 비전에 동의하지 않는다면 여러분의 포크에서 작업하거나 따로 프로젝트를 시작하는 방법도 있습니다.

> 😇 _"제 유즈케이스를 지원할 수 없다는 점은 아쉽지만 일부 사용자에게만 영향을 미친다는 관리자님의 설명은 이해가 되네요. 들어주셔서 감사합니다."_
>
> 😢 _"왜 제 유즈케이스를 지원하지 않나요? 납득할 수가 없네요!"_

**무엇보다도 세련된 자세를 유지하세요.** 오픈소스는 전 세계의 협력자로 구성되어 있습니다. 맥락은 언어, 문화, 지역, 시간대에 걸쳐 점점 손실됩니다. 게다가 글을 통한 의사소통은 말투나 분위기를 전달하기가 어렵습니다. 대화에 좋은 의도를 가지고 참여한다고 생각하세요. 예의를 갖추면 아이디어를 밀어붙여도, 더 자세한 설명을 요구해도, 여러분의 입장을 명확히 해도 좋습니다. 다만 인터넷 세계를 여러분의 첫인상보다 좋은 곳으로 만들어 주세요.

### 정보 수집

무언가 시작하기 전에, 여러분의 아이디어가 다른 곳에서 논의되지 않았는지 빠르게 확인해 보세요. 프로젝트의 README, 이슈, 메일링 리스트 및 스택 오버플로우를 훑어보세요. 모든 것을 찾아보는 데 몇 시간을 투자할 필요는 없지만, 몇 가지 핵심 용어에 대한 검색이면 충분할 것입니다.

다른 곳에서 여러분의 아이디어를 찾을 수 없다면, 움직일 때가 되었습니다. 프로젝트가 GitHub에 있는 경우 다음과 같이 이슈나 PR을 열어 소통할 수 있습니다.

* **이슈**는 대화나 토론을 시작하는 것과 같습니다.
* **풀 리퀘스트**는 솔루션에 대한 작업을 시작하기 위한 것입니다.
* 명확한 질문이나 방법 질문과 같은 **간단한 커뮤니케이션**은 스택 오버플로우 또는 IRC, 슬랙 같은 프로젝트 채팅 채널에 물어보세요.

이슈나 PR을 열기 전에 프로젝트의 기여 문서(일반적으로 CONTRIBUTING 또는 README 파일)에서 뭔가 구체적인 내용을 포함해야 하는지 확인하세요. 프로젝트에서 여러분에게 특정 템플릿을 따르거나 테스트를 사용하도록 요구할 수 있습니다.

실질적인 기여를 하고 싶다면, 작업하기 전에 이슈를 열고 물어보세요. 승인되지 않을 수도 있는 작업을 하기 전에(깃허브에서는, ["Watch"를 클릭](https://help.github.com/articles/watching-repositories/)해서 토론을 알림 받을 수 있습니다), 커뮤니티 구성원들을 알게 되면 도움이 됩니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  You'll learn <em>a lot</em> from taking a single project you actively use, "watching" it on GitHub and reading every issue and PR.
<p markdown="1" class="pquote-credit">
— @gaearon [on joining projects](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### 이슈 열기

일반적으로 다음 상황에서 이슈를 열어야 합니다.

* 스스로 해결할 수 없는 오류 보고
* 커뮤니티, 비전, 정책 등 높은 수준의 주제 또는 아이디어 토론
* 새로운 기능이나 다른 프로젝트 아이디어 제안

이슈에서 소통할 때의 팁은 다음과 같습니다.

* **열린 이슈에 대해 작업하려고 한다면** 사람들이 알 수 있게 댓글을 달아두세요. 그렇게 하면 다른 사람과 같은 부분을 작업할 가능성이 줄어듭니다.
* **이슈가 오래 전부터 열려 있었다면** 내용이 다른 곳에서 논의되고 있거나 이미 해결됐을 수도 있으므로 작업을 시작하기 전에 확인을 요청하세요.
* **이슈를 열었지만 나중에 해결법을 알아냈다면** 이슈에 댓글을 달아 사람들에게 알리고 이슈를 닫으세요. 그 결과에 대한 문서화도 프로젝트에의 기여가 됩니다.

### PR 열기

일반적으로 다음 상황에서 PR을 열어야 합니다.

* 오타, 깨진 링크, 명백한 오류 등 사소한 수정 사항 제출
* 요구되고 있거나 이슈에서 논의한 내용에 대한 작업 시작

PR이 반드시 완료된 작업을 포함할 필요는 없습니다. 보통 다른 사람들이 여러분의 진행 상황을 확인하거나 피드백을 줄 수 있도록 PR을 일찍 여는 것이 좋습니다. 제목 줄에 "WIP"(Work In Progress; 진행 중인 작업)라고 표시하세요. 나중에 얼마든지 커밋을 더 추가해도 됩니다.

프로젝트가 GitHub에 있는 경우 PR을 제출하는 방법은 다음과 같습니다.

* **[저장소를 포크](https://guides.github.com/activities/forking/)**하고 로컬에 복제(Clone)합니다. 리모트로 추가하여 로컬을 원래의 "업스트림" 저장소에 연결하세요. PR을 제출할 때 충돌이 발생할 가능성을 낮추기 위해 "업스트림"의 변경 사항을 자주 가져 와서 최신 상태로 유지하세요. (자세한 내용은 [여기](https://help.github.com/articles/syncing-a-fork/)를 참조하세요.)
* 수정을 위한 **[브랜치를 생성](https://guides.github.com/introduction/flow/)**하세요.
* **모든 관련 이슈** 혹은 지원 문서를 참조하세요. (ex. "Closes #37.")
* 변경 사항에 HTML/CSS가 포함되어 있는 경우 **적용 전/후 스크린샷을 첨부**하세요. PR의 본문에 이미지를 끌어다 놓으면 됩니다.
* **변경 사항을 테스트**하세요! 변경 사항에 대해 이미 있는 테스트를 수행하고 필요한 경우 새 테스트를 작성하세요. 테스트의 존재 여부와 상관없이 변경 사항이 기존 프로젝트를 손상시키지 않는지 확인하세요.
* 최선을 다해 **프로젝트 스타일에 기여**하세요. 들여쓰기, 세미콜론 또는 주석을 여러분의 평소 스타일과 다르게 사용해야 할 수도 있지만, 관리자가 PR을 병합하기 더 용이하고 향후의 유지보수가 쉬워질 것입니다.

만약 첫 PR을 열려고 한다면 @kentcdodds가 무료 영상 튜토리얼로 공개한 [Make a Pull Request](http://makeapullrequest.com/)를 참조하세요. @Roshanjossey의 [First Contributions](https://github.com/Roshanjossey/first-contributions) 저장소에서 연습해볼 수도 있습니다.

## 기여한 후에 일어나는 일

해내셨군요! 오픈소스 기여자가 되신 것을 축하드립니다. 앞으로도 많이 기여하실 수 있기를 바랍니다.

기여를 제출하면 다음 중 하나의 일이 일어날 것입니다.

### 😭 답변을 받지 못했어요.

기여하기 전에 [활동의 징조가 있는지 프로젝트를 확인](#기여하기-전-확인할-사항)했기를 바랍니다. 그러나 활발한 프로젝트에서도 기여가 반응을 얻지 못할 수도 있습니다.

일주일 넘게 답변을 받지 못했다면 누군가에게 검토를 부탁하며 공손하게 대응하는 것이 좋습니다. 여러분의 기여를 검토할 수 있는 적절한 사람의 이름을 안다면 골뱅이표(@)를 이용한 멘션으로 리뷰를 요청할 수 있습니다.

**절대** 그 사람에게 개인적으로 연락하지 마세요. 공개적인 의사소통은 오픈소스 프로젝트에서 필수적이라는 것을 기억하세요.

여러분이 예의 있게 행동했음에도 아무도 답변을 주지 않을 수도 있습니다. 기분이 좋지는 않겠지만 너무 낙담하지 마세요. 누구나 겪는 일입니다! 답변을 받지 못하는 데에는 어쩔 수 없는 개인적인 사정 등 다양한 이유가 있을 수 있습니다. 기여할 다른 방법이나 프로젝트를 찾아보세요. 다른 커뮤니티 구성원들이 참여하고 반응하기 전에 기여에 너무 많은 시간을 투자하지 않는 게 오히려 좋습니다.

### 🚧 기여에 대한 수정을 요청받았어요.

아이디어에 대한 피드백이든 코드의 수정이든 기여 내용을 수정해 달라는 요청을 받는 경우가 많습니다.

누군가 수정을 요청하면 적극적으로 그에 응답하세요. 그들은 여러분의 기여를 리뷰하기 위해 기꺼이 시간을 들였습니다. PR을 열고 내버려 두는 것은 좋지 않습니다. 어떻게 수정해야 할지 모르겠다면 문제에 대해 조사하고 필요한 경우 도움을 요청하세요.

대화가 몇 달 동안 진행되다가 상황이 변한 경우처럼, 더 이상 문제를 해결할 시간이 없다면 관리자에게 알리세요. 누군가 다른 사람이 기꺼이 작업을 맡아줄 지도 모릅니다.

### 👎 기여가 받아들여지지 않았어요.

여러분의 기여는 받아들여질 수도 있고 그렇지 않을 수도 있습니다. 이미 너무 많은 작업을 하지 않았으면 합니다. 왜 그것이 받아들여지지 않았는지 잘 모르겠다면 관리자에게 피드백과 설명을 요청하는 것이 합리적입니다. 그러나 궁극적으로는 이것이 그들의 결정이라는 것을 존중할 필요가 있습니다. 논쟁하거나 적대적인 태도를 취하지 마세요. 동의하지 않으면 언제든 여러분의 버전을 포크하고 따로 작업할 수 있습니다!

### 🎉 기여가 받아들여졌어요.

만세! 오픈소스에 기여하는 데 성공했습니다!

## 해냈어요!

처음으로 오픈소스에 기여한 사람이든, 기여할 새로운 방법을 찾고 있든, 이 문서가 그것을 행동에 옮길 수 있는 계기가 되었길 바랍니다. 비록 기여가 받아들여지지 않더라도, 관리자가 당신을 도우려 할 때 감사의 말을 하는 것을 잊지 마세요. 오픈소스의 이슈, PR, 댓글 하나하나는 여러분에 의해 만들어집니다. 
