---
lang: ko
title: 오픈소스 작업에 대한 비용 지불하기
description: 시간이나 프로젝트에 대한 재정적 지원을 받음으로써 오픈소스에서의 작업을 지속합니다.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## 왜 누군가는 재정적 지원을 찾을까

대부분의 오픈소스 작업은 자원봉사입니다. 예를 들어, 누군가가 사용하는 프로젝트에서 버그를 발견하고 빠른 버그픽스를 제출하거나, 여가 시간에 오픈소스 프로젝트를 사용하여 재미있는 작업을 할 수 있습니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
I was looking for a "hobby" programming project that would keep me occupied during the week around Christmas. (...) I had a home computer, and not much else on my hands. I decided to write an interpreter for the new scripting language I had been thinking about lately. (...) I chose Python as a working title.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["파이썬 프로그래밍"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

사람들이 오픈소스 작업을 위해 돈을 내고 싶어하지 않는 데에는 여러 가지 이유가 있습니다.

* **그들은 이미 좋아하는 정규직 직업을 가질 예정이여서,** 여유 시간에 오픈소스에 기여할 수 있습니다.
* **그들은 오픈소스를 취미** 또는 창조적인 탈출구로 생각하고 프로젝트에 대한 재정적 의무를 느끼고 싶지 않습니다.
* **그들은 오픈소스에 기여함으로써 사적인 이익을 얻고,** 자신의 평판이나 포트폴리오를 구축하고, 새로운 기술을 배우며, 커뮤니티에 더 가까이 다가가는 느낌을 주는 일을 합니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Financial donations do add a feeling of responsibility, for some. (...) It's important for us, in the globally connected, fast-paced world we live in, to be able to say "not now, I feel like doing something completely different".
  <p markdown="1" class="pquote-credit">
— @alloy, ["우리가 왜 기여를 허락하면 안되는가"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

다른 사람들에게, 특히 기여가 진행 중이거나 상당한 시간이 필요한 경우, 프로젝트가 요구하거나 개인적인 이유로 참여할 수 있는 유일한 방법은 오픈소스에 기여하기 위해 값을 지불하는 것입니다.

대중적인 프로젝트를 유지하는 것은 한 달에 몇 시간이라 하기보다는 주당 10-20시간을 소비하는 중요한 책임입니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Ask any open source project maintainer, and they will tell you about the reality of the amount of work that goes into managing a project. You have clients. You are fixing issues for them. You are creating new features. This becomes a real demand on your time.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["무보수 노동 및 OSS 커뮤니티의 윤리"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

또한 유료 작업을 통해 여러 계층의 사람들이 의미있는 기여를 할 수 있습니다. 어떤 사람들은 현재 재무 상태, 부채, 또는 가족 또는 다른 보살필 의무를 다하지않고 오픈소스 프로젝트에 시간을 보낼 여력이 없습니다. 즉, 세상은 자신의 시간을 자원봉사할 여력이없는 재능있는 사람들에게서 기여를 결코 볼 수 없다는 것을 의미합니다. @ashedryden이 [설명한대로](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community) 윤리적 함의가 있습니다. 이미 인생에 여유가 있는 사람들에게 치우친다는 것은, 자원 봉사자들의 기여에 기초하여 추가적인 이점을 얻는 반면, 자원봉사를 할 수 없는 사람들에게는 나중에 기회를 얻지 못하여, 더더욱 오픈소스의 다양성이 부족해집니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   OSS yields massive benefits to the technology industry, which, in turn, means benefits to all industries. (...) However, if the only people who can focus on it are the lucky and the obsessed, then there's a huge untapped potential.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["현금과 오픈소스"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

재정 지원을 찾고 있다면, 고려해야 할 두 가지 경로가 있습니다. 기여자로서 자신의 시간을 투자하거나, 프로젝트에 대한 조직 자금을 찾을 수 있습니다.

## 당신이 들인 시간에 대한 펀딩을 받기

오늘날, 많은 사람들이 오픈소스에서 파트 타임 또는 풀 타임으로 일하기 위해 돈을 받습니다. 당신의 시간에 대한 대금을 받는 가장 일반적인 방법은 고용주와 상담하는 것입니다.

고용주가 프로젝트를 실제로 사용하고 오픈소스 작업에 대한 사례를 만드는 것이 더 쉽지만, 자신의 계획대로 창의력을 발휘하십시오. 어쩌면 고용주가 프로젝트를 사용하지 않고 파이썬을 이용한 인기있는 파이썬 프로젝트를 유지한다면, 새로운 파이썬 개발자를 유치할 수 있습니다. 어쩌면 고용주가 일반적으로 더 개발자 친화적인 것처럼 보일 수도 있습니다.

기존의 오픈소스 프로젝트가 없지만 현재 작업 결과물이 오픈소스인 경우, 고용주가 내부 소프트웨어의 일부를 스스로 오픈할 수 있는 사례를 작성하십시오.

많은 기업들이 브랜드를 구축하고 우수한 인재를 영입하기 위해 오픈소스 프로그램을 개발하고 있습니다.

예를 들어 @hueniverse는, [Walmart의 오픈소스에 대한 투자](http://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html)를 정당화 할 재정적인 이유가 있음을 발견했습니다. 그리고 @jamesgpearce는 Facebook의 오픈소스 프로그램이 채용에서 [차이를 만들었다](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon)는 사실을 발견했습니다:

> 이는 해커 문화와 밀접하게 연계되어 있으며, 조직이 어떻게 인식되었는지를 보여줍니다. 우리는 직원들에게 "페이스북에서 쓰이는 오픈소스 소프트웨어 프로그램에 대해 알고 있었습니까?"라고 물었습니다. 3분의2가 "그렇다"고 답했습니다. 절반정도는 이 프로그램이 우리를 위해 일하기로 한 결정에 긍정적으로 기여했다고 전했습니다. 이것들은 한계적인 숫자가 아니며 희망을 말합니다.

회사가 이 경로를 따라 간다면, 커뮤니티와 기업 활동의 경계를 분명하게 유지하는 것이 중요합니다. 궁극적으로 오픈소스는 전 세계 모든 사람들의 공헌을 통해 스스로를 유지하며, 이는 어느 회사의 위치보다 큽니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Getting paid to work on open source is a rare and wonderful opportunity, but you should not have to give up your passion in the process. Your passion should be why companies want to pay you.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["흐린 선"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

현 고용주가 오픈소스 업무의 우선 순위를 결정할 수 없다면, 직원의 오픈소스 기여도를 높이는 새로운 고용주를 찾는 것이 좋습니다. 오픈소스 작업에 대한 헌신을 분명히 하는 회사를 찾아보십시오. 예시입니다 :

* 일부 회사는, [넷플릭스](https://netflix.github.io/), 오픈소스에 대한 그들의 참여를 강조하는 웹 사이트를 가지고있습니다
* [Zalando](https://opensource.zalando.com)는 직원을 위한 [오픈소스 기여 정책](https://opensource.zalando.com/docs/using/contributing/)을 게시했습니다

[Go](https://github.com/golang)또는 [React](https://github.com/facebook/react)와 같은 대기업에서 시작된 프로젝트도, 오픈소스 작업에 사람들을 고용 할 가능성이 높습니다.

마지막으로, 개인적인 상황에 따라, 오픈소스 작업을 위해 독립적으로 돈을 모으는 노력을 할 수 있습니다. 예시:

* @Homebrew (and [many other maintainers and organizations](https://github.com/sponsors/community)) fund their work through [GitHub Sponsors](https://github.com/sponsors)
* @gaearon은 [Patreon crowdfunding campaign](https://redux.js.org/)을 통해 [Redux](https://github.com/reactjs/redux)에 대한 그의 작업에 펀드했습니다.
* @andrewgodwin은 Django 스키마 마이그레이션 작업을 [Kickstarter 캠페인을 통해](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django) 펀드했습니다.

## 당신의 프로젝트에 대한 펀딩을 찾기

개인 기여자를 위한 준비 외에도, 때로는 프로젝트가 회사, 개인 또는 다른 사람들로부터 지속적인 자금 마련을 위해 펀드를 모으는 경우가 있습니다.

조직 펀딩은 현재 참여자에게 비용을 지불하거나, 프로젝트 수행 비용(호스팅 비용 등)을 충당하거나, 새로운 기능이나 아이디어에 투자하는 쪽으로 갈 수 있습니다.

오픈소스의 대중성이 높아짐에 따라, 프로젝트 펀딩은 아직 실험적이지만, 몇가지 공통적인 옵션이 있습니다.

### 크라우드 펀딩(crowdfunding) 캠페인이나 스폰서십을 통해 당신의 업무에 돈을 모으기

스폰서십을 찾는 것은 이미 강력한 잠재 고객이나 평판이 있거나, 프로젝트의 인기가 있는 경우에 효과적입니다.
스폰서 프로젝트의 몇 가지 예는 다음과 같습니다.

* **[webpack](https://github.com/webpack)** 는 [OpenCollective를 통해](https://opencollective.com/webpack) 회사와 개인에게 돈을 모읍니다
* **[Ruby Together](https://rubytogether.org/)는,** [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems) 및 기타 Ruby 인프라 프로젝트에 대한 비용을 지불하는 비영리 단체입니다.

### 수입원 만들기

프로젝트에 따라 상업적 지원, 호스팅 옵션 또는 추가 기능에 대해 요금을 부과할 수 있습니다. 몇 가지 예는 다음과 같습니다:

* **[Sidekiq](https://github.com/mperham/sidekiq)** 은 추가 지원을 위해 유료 버전을 제공합니다
* **[Travis CI](https://github.com/travis-ci)** 는 제품의 유료 버전을 제공합니다
* **[Ghost](https://github.com/TryGhost/Ghost)** 는 유료 관리 서비스가 있는 비영리 단체입니다

[npm](https://github.com/npm/cli) 및 [Docker](https://github.com/docker/docker)와 같은 일부 인기있는 프로젝트는, 사업 성장을 지원하기 위해 벤처 캐피탈을 조성하기까지 합니다.

### 보조금 신청하기

일부 소프트웨어 재단 및 회사는 오픈소스 작업에 대한 보조금을 제공합니다. 때로는 프로젝트에 대한 법적 주체를 설정하지 않고 개인에게 보조금을 지급할 수 있습니다.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)**는 [Mozilla 오픈소스 지원](https://www.mozilla.org/en-US/grants/)으로부터 보조금을 받았습니다
* **[OpenMRS](https://github.com/openmrs)** work는 [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)으로부터 펀드받았습니다
* **[Libraries.io](https://github.com/librariesio)**는 [Sloan 재단](https://sloan.org/programs/digital-technology)으로부터 보조금을 받았습니다
* **[Python 소프트웨어 재단](https://www.python.org/psf/grants/)**은 파이썬 관련 작업에 대한 보조금을 제공합니다

보다 자세한 옵션과 사례 연구를 원할 경우, @nayafia [가이드 작성](https://github.com/nayafia/lemonade-stand)을 통해 오픈소스 저작물에 대한 대가를 받을 수 있습니다. 다른 유형의 기금에는 여러 가지 기술이 필요하기 때문에 어떤 옵션이 가장 적합한 지 알아 내려면 장점을 고려하십시오.

## 재정적 지원을 받기 위한 근거를 갖추기

프로젝트가 새로운 아이디어이든, 수년간 지속되어 왔든 타겟 기금 제공자를 파악하고 중요한 사건을 만드는데 중요하게 고려되야합니다.

자신의 시간에 돈을 내거나, 프로젝트 기금 모금을 원하는 경우 다음 질문에 답할 수 있어야합니다.

### 임펙트

이 프로젝트가 왜 유용한가요? 사용자 또는 잠재적 사용자가 그렇게 좋아하는 이유는 무엇입니까? 5년후에는 어디에 있을까요?

### 끌어주기

메트릭, 일화 또는 고객의 견해와 상관없이 프로젝트가 중요하다는 증거를 수집하십시오. 현재 귀사의 프로젝트를 사용하고 있는 회사나, 주목할만한 사람들이 있습니까? 그렇지 않다면 저명한 사람이 그것을 지지합니까?

### 자금 제공자에 주는 가치

기금 제공자는 고용주 또는 보조금 재단에 관계없이 자주 기회를 제공받습니다. 다른 어떤 기회보다 프로젝트를 지원해야하는 이유는 무엇입니까? 그들은 개인적으로 어떻게 이익을 얻습니까?

### 펀드 사용

제안된 자금으로 정확히 무엇을 달성할 수 있습니까? 급여를 지급하기보다는 프로젝트 이정표 또는 결과에 중점을 둡니다.

### 펀드로 송금하기

기금 제공자의 관련 요구 사항이 있습니까? 예를 들어 비영리 단체 또는 비영리 단체 재정 보증인이 필요할 수 있습니다. 또는 자금을 조직이 아닌 개별 계약자에게 제공해야합니다. 이러한 요구 사항은 자금 제공자마다 다르므로 사전에 연구해야합니다.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  For years, we've been the leading resource of website friendly icons, with a community of over 20 million people and been featured on over 70 million websites, including Whitehouse.gov. (...) Version 4 was three years ago. Web tech's changed a lot since then, and frankly, Font Awesome's gotten a bit stale. (...) That's why we're introducing Font Awesome 5. We're modernizing and rewriting the CSS and redesigning every icon from top to bottom. We're talking better design, better consistency, and better readability.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome 킥스타터 영상](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## 시도해 보고 포기하지 마세요!

오픈소스 프로젝트, 비영리 단체, 소프트웨어 스타트업 등 많은 돈을 모으는 것은 쉽지 않습니다. 대부분의 경우 창의력을 발휘해야합니다. 어떻게 돈을 받고, 연구를 하고, 재밌는 사람의 신발에 몸을 두는지를 확인하면 자금 지원에 대한 설득력있는 사례를 구축하는 데 도움이됩니다.
