---
lang: ja
title: オープンソースで金銭を得る
description: プロジェクト活動に対して金銭的サポートを得ることで、オープンソース活動を持続可能にしよう。
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## なぜ金銭的サポートを探している人がいるのか？

多くのオープンソース活動はボランティアで行われています。例えば、ある人は自分が使っているプロジェクトでバグを見つけて簡単な修正を提出したのかもしれませんし、他の人は自分の空いた時間にオープンソースプロジェクトをいじるのを楽しんでいるのかもしれません。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
私は、クリスマスの週に取り掛かれる「趣味の」プログラミングプロジェクトを探していました。(...) 家にコンピュータを持っていて、他には特に手持ちがなかったのです。そこで、私は最近考えていた新しいスクリプト言語のインタープリタを書くことにしました。(...) その作品の名前は Python としました。
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

人がオープンソース活動で金銭を受け取りたくないと思う理由はたくさんあります。

* **既に気に入っているフルタイムの仕事を持っているかもしれません。** これによって空いた時間にオープンソースにコントリビュートすることが可能になっています。
* **オープンソースを趣味として楽しんでいるのかもしれません。** もしくは創造的な現実逃避として活動していて、金銭を得ることでそのプロジェクトに取り掛かるのに義務感を持ちたくないのかもしれません。
* **オープンソースにコントリビュートすることで他のメリットを得ているのかもしれません。** 例えば、評判やポートフォリオを築いたり、新しいスキルを学んだり、コミュニティの近くにいると感じたり。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  金銭的な寄付を得ることによって、ある程度責任感が植え付けられます。(...) 世界中がつながっていて動きが早いこの世界で、「今は全く違うことがやりたい気分なんです」と言えるようになることは重要です。
  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

他の人にとっては、特にコントリビュートが現在進行中でまとまった時間が必要なときには、オープンソース活動によって金銭を得るのは、彼らがプロジェクトに参加できるようになるための唯一の方法です。たとえそれがプロジェクト側の要求であっても、個人的な理由であっても。

有名なプロジェクトを運営するのは大きな責任になるかもしれず、月に数時間ではなく週に10〜20時間も必要となるかもしれません。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  オープンソースプロジェクトのメンテナーに話を聞いてみてください。そうすると、彼らはプロジェクトを運営するのにどのくらいの仕事量が必要なのか、現実の話を教えてくれるでしょう。あなたには顧客がいます。彼らのために問題を解決しています。あなたは新しい機能を作っています。こういったことがあなたの時間を要求するのです。
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

有償で仕事ができることで、異なる人生の歩み方をしている人が、コントリビュートを可能にします。現在の財政的状況や負債、家族、その他世話が必要な人がいる等の理由で、オープンソース活動を無償で行う余裕がない人もいます。この事は、ボランティアではオープンソース活動を行う余裕がない人たちからのコントリビュートが実現しないということを意味します。これは @ashedryden [が述べたように](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)、倫理的な問題があります。コントリビュートが、既に余裕のある人からだけに偏ってしまい、このボランティア活動によって彼らが更にメリットを得ることになるのです。その一方、ボランティア活動を行うことのできない人は機会を得ることができず、オープンソースコミュニティにおける多様性の不足がより増長されてしまいます。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   OSS はテクノロジー業界に多大なメリットを生み出し、ひいてはあらゆる産業にメリットをもたらします。 (...) しかし、オープンソース活動に従事できるのがラッキーで夢中になっている人だけであるとしたら、それは大きな機会損失です。
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c#.ftnd5qez0)
  </p>
</aside>

もし金銭的なサポートを探しているのであれば、考えられる道は2つあります。コントリビューターとして有償で活動をするか、プロジェクトの支援をしてくれる組織を探すかです。

## あなたの時間に資金を出してもらおう

今日では、多くの人がオープンソース活動でパートタイムやフルタイムの給与を得ています。これを実現するもっともよくあるケースは、雇用主に話してみることです。

もし雇用主がそのプロジェクトを使っているのであれば、オープンソース活動をするのはより簡単になるでしょう。しかし、説明の仕方はよく練る必要があります。そのプロジェクトを使っていないかもしれませんが、 Python を使っているとすれば、 Python の有名なプロジェクトに関わることで新しい Python 開発者を惹き付ける役に立つでしょう。こう説明することで、雇用主はより友好的になるでしょう。

もし取り組みたい既存のオープンソース活動がないけれども、現在の仕事の成果をオープンソースにしたいと望んでいる場合は、社内のソフトウェアをオープンソース化する事例を作りましょう。

多くの企業が、ブランド構築と有能な開発者の採用のためにオープンソースプログラムを作っています。

例えば @hueniverse は、[ウォルマートがオープンソースに投資する](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html)べき金銭的理由がある事に気づきました。そして、 @jamesgpearce は、 Facebook のオープンソースプログラムが採用に関して[差別化になる](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon)と気づきました：

> それは私達のハッカー文化や私達の組織の認知のされ方と緊密に整合していました。私達は従業員に対して、「 Facebook のオープンソースソフトウェアプログラムを知っていますか？」と聞いてみました。三分の二は「はい」と答え、半分は仕事上の決定を行う際に良い影響を与えていると答えました。これは小さな値ではありませんし、これは今後も続いていくトレンドだと信じています。

あなたの会社がこれと同じ道をたどるのであれば、コミュニティと企業の活動の境界を明確に引いておくことが重要です。結局、オープンソースは世界中の人々のコントリビュートによって維持されており、それはどんな企業や場所よりも大きいのです。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  オープンソース活動で金銭を得るのは稀で素晴らしい機会です。しかし、そうなる過程であなたの熱意を諦めるべきではありません。あなたの熱意こそが、会社がお金を払う理由であるはずだからです。
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

オープンソース活動を優先するということを現在の雇用主に納得してもらえなかった場合、オープンソースへのコントリビュートを奨励している新しい雇用主を探すことを検討しましょう。オープンソース活動へのコントリビュートを明確にしている企業を探しましょう。例えば：

* [Netflix](https://netflix.github.io/) といった企業は、彼らのオープンソースへの関わりをまとめたウェブサイトを持っています。
* [Rackspace](https://www.rackspace.com/en-us) は従業員向けに[オープンソースコントリビュートポリシー](https://blog.rackspace.com/rackspaces-policy-on-contributing-to-open-source/)を公開しています

[Go](https://github.com/golang) や [React](https://github.com/facebook/react) のような大企業がはじめたプロジェクトでは、オープンソース活動を行う人々を採用する可能性があります。

あなた個人の状況によっては、あなた個人でオープンソース活動に資金を出してもらう試みをすることも可能です。例えば：

* @Homebrew (and [many other maintainers and organizations](https://github.com/sponsors/community)) fund their work through [GitHub Sponsors](https://github.com/sponsors)
* @gaearon は [Patreon でのクラウドファンディング](https://redux.js.org/)を通じて、 [Redux](https://github.com/reactjs/redux) の活動の資金を得ています。
* @andrewgodwin は [Kickstarter のキャンペーン](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)を通じて、 Django のスキーママイグレーションの活動の資金を得ています。

最後に、オープンソースプロジェクトの中には問題解決を手伝ってもらうために報奨金を提示しているものもあります。

* @ConnorChristie は [gitcoin の報奨金制度](https://gitcoin.co/)で @MARKETProtocol が JavaScript ライブラリの作業を[手伝う](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14)ことで金銭を得ました。
* @mamiM は @MetaMask の日本語訳作業が [Bounties Network に資金提供された際に](https://beta.bounties.network/bounty/v1/134)、その作業を行いました。

## あなたのプロジェクトへの資金提供を探そう

個人のコントリビューターの作業を超えて、時には企業、個人や他の人たちから現在進行中の作業に対して資金提供を得るプロジェクトもあります。

組織の資金は、現在のコントリビューターへの支払いや、（ホスティング費用などの）プロジェクト運営費の補填、新しい機能やアイデアへの投資に充てられます。

オープンソースの知名度が向上しているため、プロジェクトへの資金提供は未だに手探り状態ではあるものの、幾つかのよくある選択肢が利用可能です。

### クラウドファンディングやスポンサーを通じて資金を得る

あなたが既に協力者や強力な名声を築いていたり、プロジェクトが非常に有名なのであれば、スポンサーを探すのはうまくいくでしょう。スポンサーを得たプロジェクトの例を幾つか挙げます：

* **[webpack](https://github.com/webpack)** は [OpenCollective を通じて](https://opencollective.com/webpack)企業や個人から資金を得ています。
* **[Ruby Together](https://rubytogether.org/)** という非営利団体は [bundler](https://github.com/bundler/bundler) や [RubyGems](https://github.com/rubygems/rubygems) といった Ruby の基盤プロジェクトに資金を提供しています。

### 収益源を作る

プロジェクトによっては、商用サポートやホスティング、追加機能によって課金することができるかもしれません。幾つか例を挙げます：

* **[Sidekiq](https://github.com/mperham/sidekiq)** は、サポートを追加することで有償版を提供しています。
* **[Travis CI](https://github.com/travis-ci)** は、製品の有償版を提供しています。
* **[Ghost](https://github.com/TryGhost/Ghost)** は、有償のマネージドサービスを提供する非営利サービスです。

[npm](https://github.com/npm/cli) や [Docker](https://github.com/docker/docker) のような有名なプロジェクトでは、ビジネスの成長を支えるためにベンチャーキャピタルから資金調達をしています。

### 助成金に応募する

ソフトウェア財団や企業の中にはオープンソース活動に対して助成金を提供しているところもあります。プロジェクト用の法人を設置は不要で、個人に対して支払いをする助成金もあります。

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** は [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/) から助成金を得ています。
* **[OpenMRS](https://github.com/openmrs)** は [Stripe の Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees) から資金を得ています。
* **[Libraries.io](https://github.com/librariesio)** は [Sloan Foundation](https://sloan.org/programs/digital-technology) から助成金を得ています。
* **[Python Software Foundation](https://www.python.org/psf/grants/)** は Python 関連のプロジェクトに対して助成金を提供しています。

更に詳細な選択肢や事例については、 @nayafia がオープンソース活動において資金を得るための[ガイドを書いています](https://github.com/nayafia/lemonade-stand)。資金調達方法によって必要なスキルは異なるので、あなたの強みを分析してどの選択肢が最善か検討しましょう。

## 資金援助のための論拠を構築しよう

あなたのプロジェクトが新しいアイデアであろうと、何年も取り掛かってきたものだろうと、ターゲットとなる資金提供者を特定し、説得力のある論拠をつくるために考慮する必要があります。

あなた自身の活動に対して資金を得るにせよ、プロジェクトの資金調達をするにせよ、下記の質問に答えられるようにしておくべきです。

### インパクト

なぜこのプロジェクトが役に立つのでしょうか？ユーザーや潜在的なユーザーはあなたのプロジェクトを気に入っているのでしょうか？5年後はどうなっているでしょうか？

### トラクション

あなたのプロジェクトが重要である証拠を集めましょう。それはメトリクスでも良いですし、事例でもユーザーの声でも構いません。今現在、あなたのプロジェクトを使っている企業や特筆すべき人々はいるでしょうか？もしいないのであれば、有名な人が支援してくれないでしょうか？

### 資金提供者への価値

雇用主であれ助成金を出す財団であれ、資金提供者は多くの人から相談を受けています。他の人ではなくあなたのプロジェクトを支援するべき理由は何でしょう？彼ら自身にはどういったメリットがあるでしょうか？

### 資金の使い道

資金を得たら、あなたはそれを使って具体的に何を達成するつもりでしょうか？給与の支払いではなく、プロジェクトのマイルストーンやプロジェクトの成果に焦点を当てましょう。

### 資金をどのように受け取る予定か？

資金提供者は、支払いに関して何か要求していることはあるでしょうか？例えば、非営利である必要があったり、非営利の資金スポンサーがついている必要があるかもしれません。もしくは、資金が組織に対してではなく個人の請負として提供される必要があるかもしれません。これらの要求は資金提供者によって異なるので、事前に確かめておきましょう。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  何年もの間、私達はウェブサイトで使いやすいアイコンの提供する先進的なプロジェクトです。コミュニティには2000万人以上のメンバーがおり、7000万以上のウェブサイトで使われてきました。その中には、Whitehouse.gov も含まれています。 (...) バージョン4は3年前にリリースされました。その当時からウェブ技術は大きく変わりましたが、率直に言うと Font Awesome は少し古くなってしまいました。 (...) そのため、私達は Font Awesome 5 を作りました。 CSS をモダンにするために書き直し、すべてのアイコンを再デザインしています。私達は、よりよいデザイン、よりよい一貫性、よりよい可読性について話しています。
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## 実験し、諦めないようにしよう

資金調達は簡単ではありません、たとえそれがオープンソースプロジェクトであれ、非営利であれ、ソフトウェアスタートアップであれ。そして、多くの場合では創造的である必要があります。どのように支払ってほしいかを特定し、調査をし、資金提供者の立場で考えることで、資金調達に向けて納得感のある論拠を構築できるようになるでしょう。
