---
lang: ja
title: あなたのプロジェクトのユーザーを見つけよう
description: あなたのプロジェクトを喜んで使ってくれるユーザーを獲得してプロジェクトを拡大しよう。
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## あなたのメッセージを広めよう

プロジェクトを立ち上げた時に、そのプロジェクトを宣伝しないといけないというルールはありません。オープンソースに取り組む理由の中には、プロジェクトの人気とは関係のないものがたくさんあります。他の人があなたのプロジェクトを見つけて使ってくれるだろうと願う代わりに、あなたの頑張りを言葉で広める必要があります！

## メッセージを見つけ出そう

実際にプロジェクトの宣伝を始める前に、そのプロジェクトが何をするもので、なぜ重要なのかを説明できるようになる必要があります。

あなたのプロジェクトが他のプロジェクトと比べて異なっている部分や興味を引く部分はどこでしょうか？なぜあなたはそれを作ったのでしょうか？こういった質問に自分で答えることで、あなたのプロジェクトの重要性を伝える助けになるでしょう。

人々ははじめはユーザーとしてプロジェクトに関わり始め、あなたのプロジェクトが彼らの問題を解決することで、その後コントリビューターになるということを忘れないようにしましょう。プロジェクトのメッセージや価値を考える際に、 _ユーザーとコントリビューター_ が何を望むだろうかという視点で考えるようにしましょう。

例えば、 @robb はなぜ彼のプロジェクトである [Cartography](https://github.com/robb/Cartography) が便利なのかをコードの例を通してわかりやすく伝えています:

![Cartography README](/assets/images/finding-users/cartography.jpg)

メッセージ作成についてより深掘りするために、 Mozilla の ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) に目を通してみましょう。これはユーザーペルソナを作る練習になります。

## 人々にあなたのプロジェクトを見つけてフォローしてもらいやすくしよう

<aside markdown="1" class="pquote">
  理想的には、あなたのプロジェクトに関して宣伝したり人に伝えたりできる一つの「ホーム」 URL が必要です。きれいなテンプレートを使ったり、きれいなドメイン名を使う必要はありませんが、中心となる場所が必要です。
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

単一の名前空間に向かわせることで、人々がプロジェクトを見つけて覚えてもらいやすくしましょう。

**あなたの作業を宣伝するためにわかりやすいハンドルを使いましょう** Twitter のハンドル、 GitHub の URL や IRC チャンネルは、あなたのプロジェクトを人々に示す事ができる簡単な方法です。こうした場所は、拡大するコミュニティに対して集まる場所を提供することにもなります。

もしそういった場所を作るにはまだ早いと思うのであれば、あなた自身の Twitter やあなたが実際に活動している GitHub のハンドルを宣伝しましょう。あなたの Twitter や GitHub のハンドルを宣伝することで、人々はどうやってあなたに接したり、あなたの仕事をフォローできるのか知ることができます。もしミートアップやイベントで発表するのであれば、自己紹介やスライドに連絡先情報を含めているか確認しましょう。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  プロジェクトの初期段階で私が犯したミスは、（中略）プロジェクトのための Twitter アカウントを作らなかったことです。 Twitter を使うことで、プロジェクトについての最新情報を人々に伝え続けることができるだけでなく、プロジェクトについて定期的に人々に示すことができます。
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**ウェブサイトを作ることを検討しましょう** ウェブサイトを作ることで、あなたのプロジェクトはより友好的で簡単に誘導することができます。特にそのウェブサイトにわかりやすいドキュメントとチュートリアルがあればなおさらです。ウェブサイトがあることで、あなたのプロジェクトが活動をしているということも示すことができます。これによって、プロジェクトを見ている人は安心して使うことができるようになります。あなたのプロジェクトをどのように使うのかの例も提供しましょう。

Django の共同作者の [@adrianholovaty](https://news.ycombinator.com/item?id=7531689) は、 _「ウェブサイトを作ったことは Django の初期段階でやったことの中で圧倒的に最善のことでした」_ と言っています。

プロジェクトを GitHub 上でホストしているのであれば、 [GitHub Pages](https://pages.github.com/) を使うことで簡単にウェブサイトを作ることができます。 [Yeoman](http://yeoman.io/) や [Vagrant](https://www.vagrantup.com/) 、 [Middleman](https://middlemanapp.com/) は、網羅的で素晴らしいウェブサイトの[例](https://github.com/showcases/github-pages-examples)です。

![Vagrant のホームページ](/assets/images/finding-users/vagrant_homepage.png)

ここまでで、あなたはプロジェクトのメッセージを作り、人々があなたのプロジェクトを簡単に見つけることができる方法を提供しました。次は、外に出てユーザーと話しましょう！

## ユーザーがいる場所に行こう（オンライン）

オンラインでの働きかけは、素早くあなたのメッセージを広めるのに良い方法です。オンラインの媒体を使うことで、非常に広い範囲のユーザーと接点を持つことができる可能性があります。

ユーザーと接点を持つのに、既存のオンラインコミュニティやプラットフォームを利用しましょう。あなたのオープンソースプロジェクトがソフトウェアのプロジェクトであれば、おそらく [Stack Overflow](https://stackoverflow.com/) や [Reddit](https://www.reddit.com) 、 [Hacker News](https://news.ycombinator.com/) 、 [Quora](https://www.quora.com/) でユーザーを見つけることができるでしょう。人々に最もメリットがあったり、あなたの仕事に喜んでくれる人がいると思う媒体を見つけましょう。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  あらゆるプログラムは、ごく一部のユーザーのみが便利だと思うような特殊な機能を持っています。可能な限り多くのユーザーにスパムを送りつけるようなことはやめましょう。そのかわりに、あなたのプロジェクトを知ることで利益を得るような人に伝えるように狙いをつけましょう。
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](http://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

あなたのプロジェクトを共有するのに、あなたにとって適切な方法があるか確かめてみましょう：

* **関連するオープンソースプロジェクトやコミュニティと知り合いになろう。** 直接プロジェクトを宣伝する必要がない場合もあります。もしあなたのプロジェクトが Python を使っているデータサイエンティストにぴったりだとすれば、 Python のデータサイエンスコミュニティと知り合いになりましょう。人々があなたのことを知るにつれて、あなたのやっていることについて話して共有する機会が自然とやってくるでしょう。
* **あなたのプロジェクトが解決する問題に遭遇している人を探そう。** あなたのプロジェクトのターゲットに該当する人をフォーラムを通して探しましょう。彼らの質問に答え、機転を利かせて適切なタイミングで、あなたのプロジェクトが解決策となることを提案しましょう。
* **フィードバックを求めよう。** あなたのプロジェクトが適切であり面白いと感じてくれるであろう人々に対して、あなた自身とあなたのプロジェクトを紹介しましょう。あなたのプロジェクトから利益を得るであろう人を具体的にしましょう。そして、次のように話を締めくくりましょう： _「私のプロジェクトは Y をしようとしている X にとって本当に役に立つと考えています」。_ そして、単にあなたのやったことを宣伝するのではなく、フィードバックをもらい、それに対応しましょう。

一般的に、何かをお願いする前に人々を助けることに専念しましょう。プロジェクトをオンラインで宣伝するのは誰でも簡単にできるので、ノイズが多いのです。そういった大勢の中で目立つために、あなたが望むものだけでなく、あなたが誰であるかという背景を人々に伝えましょう。

もし誰も注意を払ってくれなかったり、あなたに反応してくれない場合でも、がっかりしないで下さい！ほとんどのプロジェクトの立ち上げは、数ヶ月や数年もかかる、反復プロセスなのです。初回で反応が得られなくても、他の戦術で試してみたり、他の人のやっていることに価値を追加するやり方を探しましょう。プロジェクトの宣伝や立ち上げには時間と献身が必要なのです。

## ユーザーがいる場所に行こう（オフライン）

![Public speaking](/assets/images/finding-users/public_speaking.jpg)

オフラインのイベントは新しいプロジェクトを人々に紹介するためによく用いられる方法です。これは多忙な人々に接触して、より深い関係を構築するのに非常に良い方法です。開発者に接触しようとしている場合は特に有効です。

もし[公の場で話すことに慣れていない](http://speaking.io/)のであれば、あなたのプロジェクトの言語やエコシステムに関連する地元のミートアップを探すところから始めてみましょう。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  私は PyCon に行くのに非常に緊張していました。発表をし、そこで数名としか知り合いになれず、それがまる1週間続くのではないかと。（中略）しかし、私は心配する必要はなかったのです。 PyCon は並外れて素晴らしかった！（中略）誰もが驚くほど友好的で社交的だったので、誰かと話していない時間が殆どないほどでした。
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

これまで一度もイベントで発表をしたことがないのであれば、緊張するのは全くもって普通のことです！あなたの聴衆はあなたの話が聞きたいと心から思っているからそこにいるのだということを忘れないようにしましょう。

あなたの発表に準備する時に、聞き手にとって何が面白く、価値を得られるのかという点に集中しましょう。言葉遣いを友好的で親しみやすいものにしましょう。笑って、深呼吸して、楽しみましょう。

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  あなたの発表の準備を始める時に、トピックが何であれ、あなたの発表が人々に物語を伝えるのだと考える事は助けになるでしょう。
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

準備ができたと感じたら、あなたのプロジェクトを宣伝するためにカンファレンスで発表することを検討しましょう。カンファレンスは、より多くの人々、時には世界中の人々と接点を持つ役に立ちます。

あなたの言語やエコシステムに特化したカンファレンスを探しましょう。発表の申込みをする前に、カンファレンスについて調査をして、あなたの発表を参加者に合うよう調整し、カンファレンスでの発表が採用されるチャンスを増やしましょう。カンファレンスの発表者を調べることで、聴衆についての感覚を得ることができることもあります。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  私は JSConf のメンバーに JSConf EU で発表する枠をもらえるようにお願いをしました。（中略）私は、半年をかけてやってきたことについて発表することが完全に怖くなってしまいました。（中略）常に、なんてこった、自分はここで何をしようとしているんだ、とだけ考えていました。
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## 評判を築こう

ここまでに書いた戦略に加えて、あなたのプロジェクトを人々に共有してコントリビュートしてもらうのに最も良い方法は、彼らのプロジェクトを共有してコントリビュートすることです。

他の人のプロジェクトで、新しく来た人を助け、リソースを共有し、親切なコントリビュートをすることで、あなたは良い評判を築く事ができるでしょう。オープンソースコミュニティのメンバーとして活発に活動することで、あなたのやっていることの文脈を伝え、あなたのプロジェクトに注意を払ってもらいやすくなります。他のオープンソースプロジェクトと関係を構築することで公式なパートナーシップに繋がることさえあります。

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  今日 urllib3 が Python の最も有名なサードパーティライブラリになった唯一の理由は、 requests の一部であったためです。
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov)
  </p>
</aside>

評判を築くのに早すぎたり遅すぎることはありません。既にプロジェクトを立ち上げていたとしても、他の人を助ける方法を探し続けましょう。

一夜で人々を引きつけるようなやり方はありません。信頼や尊敬を得るには時間がかかりますし、評判を築く事は永遠に終わることはありません。

## やり続けよう！

人々があなたのオープンソースプロジェクトに気づくまでには時間がかかるかもしれません。それで良いのです！今日最も有名なプロジェクトの中には活発になるまでに何年もかかったものもあります。あなたのプロジェクトが自然と人気を獲得するのを願うのではなく、関係を構築することに集中しましょう。あなたのプロジェクトを喜んでくれる人に対して、辛抱強く、やっていることを伝え続けましょう。
