---
lang: it
untranslated: true
title: Mantenere l'equilibrio per i sostenitori dell'open source
description: Suggerimenti per la cura di sé ed evitare il burnout come caregiver.
class: balance
order: 0
image: /assets/images/cards/maintaining-balance-for-open-source-maintainers.png
---

Man mano che il progetto open source cresce in popolarità, diventa importante stabilire confini chiari per aiutarti a mantenere un equilibrio e rimanere aggiornato e produttivo a lungo termine.

Per ottenere informazioni dettagliate sulle esperienze dei manutentori e sulle loro strategie di bilanciamento, abbiamo condotto un workshop con 40 membri della <a href="http://maintainers.github.com/">comunità dei manutentori</a>, che ci ha permesso di imparare da le loro esperienze di prima mano con il burnout open source e le pratiche che li hanno aiutati a mantenere l'equilibrio nel loro lavoro. È qui che entra in gioco il concetto di ecologia personale.

Allora, cos'è l'ecologia personale? Come <a href="https://rockwoodleadership.org/nonprofit-four-day-workweek-can-take-care-still-change-world/#:~:text=personal%20ecology%3A%20maintaining%20balance% 2C%20pacing%20and%20efficiency%20to%20sustain%20your%20energy%20over%20a%20lifetime%20of%20activism">descritto dal Rockwood Leadership Institute</a>, implica "<strong>mantenere equilibrio, ritmo ed efficienza per sostenere la nostra energia per tutta la vita</strong>". Questo inquadra le nostre conversazioni, aiutando i sostenitori a riconoscere le loro azioni e i loro contributi come parti di un ecosistema più ampio che si evolve nel tempo. Burnout, una sindrome derivante dallo stress cronico sul lavoro, come [definita dall'OMS](https://icd.who.int/browse11/l-m/en#/http://id.who.int/icd/entity/129180281), non è raro tra i manutentori. Ciò spesso porta a una perdita di motivazione, incapacità di concentrazione e mancanza di empatia verso i colleghi e la comunità con cui lavori.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  Non riuscivo a concentrarmi o ad avviare un'attività. Mi mancava l'empatia nei confronti del consumatore.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, che supporta il server di streaming live Owncast, sull'impatto del burnout sul suo funzionamento open source
  </p>
</aside>

Abbracciando il concetto di ecologia personale, gli operatori sanitari possono evitare in modo proattivo il burnout, dare priorità alla cura di sé e mantenere un senso di equilibrio per svolgere al meglio il proprio lavoro.

## Suggerimenti per la cura di sé ed evitare il burnout come personale di supporto:

### Determina le tue motivazioni per lavorare con l'open source

Prenditi del tempo per pensare a quali parti del supporto open source ti danno energia. Comprendere la tua motivazione può aiutarti a dare priorità al lavoro in un modo che ti mantenga impegnato e pronto per nuove sfide. Che si tratti del feedback positivo degli utenti, della gioia di collaborare e interagire con la community o della soddisfazione di immergersi nel codice, riconoscere le proprie motivazioni può aiutarti a dirigere la tua attenzione.

### Pensa a cosa ti fa sentire sbilanciato e stressato

È importante capire cosa ci fa bruciare. Ecco alcuni temi comuni che abbiamo riscontrato tra i sostenitori dell'open source:

* **Mancanza di feedback positivo:** è molto più probabile che gli utenti si mettano in contatto con noi in caso di reclamo. Se tutto funziona bene, tendono a tacere. Può essere scoraggiante vedere un elenco crescente di problemi senza il feedback positivo che mostri come il tuo contributo stia facendo la differenza.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/thisisnic?s=180" class="pquote-avatar" alt="avatar">
  A volte è un po' come gridare nel vuoto e trovo che il feedback mi dia davvero energia. Abbiamo molti utenti felici ma tranquilli.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/thisisnic">@thisisnic</a>, supporto Apache Arrow
  </p>
</aside>

* **Non dire di "NO":** Può essere facile assumersi più responsabilità del dovuto per un progetto open source. Che si tratti di utenti, contributori o altri sostenitori, non sempre possiamo essere all'altezza delle loro aspettative.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/agnostic-apollo?s=180" class="pquote-avatar" alt="avatar">
 Mi sono ritrovato ad assumerne più di uno e a dover svolgere il lavoro di più persone come di solito si fa in FOSS.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/agnostic-apollo">@agnostic-apollo</a>, supporto Termux, su cosa causa il burnout nel loro lavoro
  </p>
</aside>

* **Lavorare da soli:** Essere un manutentore può essere incredibilmente solitario. Anche se lavori con un gruppo di manutentori, negli ultimi anni è stato difficile convocare di persona i team distribuiti.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
 Soprattutto dopo il COVID e il lavoro da casa, è più difficile non vedere né parlare mai con nessuno.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, che supporta il server di streaming live Owncast, sull'impatto del burnout sul suo funzionamento open source
  </p>
</aside>

* **Tempo o risorse insufficienti:** Ciò è particolarmente vero per i volontari di supporto che devono sacrificare il proprio tempo libero per lavorare a un progetto.

<aside markdown="1" class="pquote">
  [Mi piacerebbe avere] più sostegno finanziario in modo da potermi concentrare sul lavoro open source senza spendere i miei risparmi e sapendo che dovrò stipulare molti contratti per compensare in seguito.
  <p markdown="1" class="pquote-credit">
— supporto open source
  </p>
</aside>

* **Richieste contrastanti:** L'open source è pieno di gruppi con motivazioni diverse che possono essere difficili da orientare. Se sei pagato per lavorare nell'open source, gli interessi del tuo datore di lavoro a volte possono essere in contrasto con quelli della comunità.

<aside markdown="1" class="pquote">
  Con l'open source a pagamento, il conflitto tra l'attenzione del datore di lavoro e ciò che è meglio per la comunità
  <p markdown="1" class="pquote-credit">
— supporto open source
  </p>
</aside>

### Fai attenzione ai segni di esaurimento

Riesci a mantenere il tuo ritmo per 10 settimane? 10 mesi? 10 anni?

Esistono strumenti come [Burnout Checklist](https://governingopen.com/resources/signs-of-burnout-checklist.html) di [@shaunagm](https://github.com/shaunagm) che possono aiutarti a riflettere sul tuo ritmo attuale e vedi se ci sono modifiche che puoi apportare. Alcuni operatori sanitari utilizzano anche la tecnologia indossabile per monitorare parametri come la qualità del sonno e la variabilità della frequenza cardiaca (entrambi legati allo stress).

<aside markdown="1" class="pquote">
 Sono un grande fan dei bei vestiti. Con la scienza alla base, puoi capire come potresti fare meglio e come arrivare allo stato ottimale di ciò che vuoi fare.
  <p markdown="1" class="pquote-credit">
— supporto open source
  </p>
</aside>

### Di cosa hai bisogno per continuare a sostenere te stesso e la tua comunità?

Questo apparirà diverso per ogni manutentore e cambierà a seconda della fase della tua vita e di altri fattori esterni. Ma ecco alcuni temi che abbiamo sentito:

* **Affidati alla community:** Delegare e trovare collaboratori può alleggerire il carico di lavoro. Avere più punti di contatto per un progetto può aiutarti a stare tranquillo. Connettiti con altri manutentori e con la comunità più ampia - in gruppi come [Comunità dei manutentori](http://maintainers.github.com/). Questa può essere una grande risorsa per il supporto e la formazione tra pari.

  Puoi anche cercare modi per interagire con la comunità di utenti in modo da poter ascoltare regolarmente feedback e comprendere l'impatto del tuo lavoro open source.

* **Esplora i finanziamenti:** Che tu stia cercando dei soldi per la pizza o stia cercando di passare a tempo pieno all'open source, ci sono molte risorse per aiutarti! Come primo passo, valuta la possibilità di attivare [Sponsor Github](https://github.com/sponsors) per consentire ad altri di sponsorizzare il tuo lavoro open source. Se stai pensando di trasferirti a tempo pieno, fai domanda per il turno successivo [GitHub Accelerator](http://accelerator.github.com/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mansona?s=180" class="pquote-avatar" alt="avatar">
 Ero su un podcast poco fa e stavamo parlando di supporto e sostenibilità open source. Ho scoperto che anche un piccolo numero di persone che supportano il mio lavoro su GitHub mi hanno aiutato a prendere la rapida decisione di non sedermi davanti a un gioco e invece di fare una piccola cosa open source.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mansona">@mansona</a>, supporto EmberJS
  </p>
</aside>

* **Utilizza gli strumenti:** esplora strumenti come [GitHub Copilot](https://github.com/features/copilot/) e [GitHub Actions](https://github.com/features/actions), per automatizzare le attività banali e liberare tempo per contributi più significativi.

<aside markdown="1" class="pquote">
 Usa [Copilot](https://github.com/features/copilot/) per le cose noiose, fai le cose divertenti
  <p markdown="1" class="pquote-credit">
— supporto open source
  </p>
</aside>

* **Riposati e ricaricati:** prenditi del tempo per i tuoi hobby e interessi al di fuori dell'open source. Prenditi dei giorni liberi per rilassarti e rigenerarti e imposta il tuo [stato GitHub](https://docs.github.com/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/personalizing-your-profile#setting-a-status), per riflettere la tua disponibilità! Una buona notte di sonno può fare una grande differenza nella tua capacità di sostenere i tuoi sforzi a lungo termine.

   Se trovi particolarmente piacevoli alcuni aspetti del tuo progetto, prova a strutturare il tuo lavoro in modo da poterlo sperimentare durante tutta la giornata.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielroe?s=180" class="pquote-avatar" alt="avatar">
 Trovo più opportunità per dedicarmi a "momenti di creatività" a metà giornata invece di cercare di staccare la spina la sera.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/danielroe">@danielroe</a>, supporto Nuxt
  </p>
</aside>

* **Imposta dei limiti:** non puoi dire sì a ogni richiesta. Può essere semplice come dire "Non posso farlo adesso e non ho piani per il futuro" o specificare cosa vuoi fare e cosa non fare nel README. Ad esempio, potresti dire: "Unisco solo i PR che hanno chiaramente elencato i motivi per cui sono stati creati" oppure "Esamino i problemi solo il giovedì dalle 18:00 alle 19:00". Ciò definisce le aspettative per gli altri e ti dà qualcosa a cui puntare in altri momenti per ridurre le richieste di tempo da parte di collaboratori o utenti.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
Per fidarsi significativamente degli altri lungo questi assi, non puoi essere qualcuno che dice sì a ogni richiesta. In questo modo, non manterrai alcun confine, professionale o personale, e non sarai un collega affidabile.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mikemcquaid">@mikemcquaid</a>, supporto Homebrew di [Dire NO](https://mikemcquaid.com/saying-no/)
  </p>
</aside>

  Impara ad essere fermo nel fermare comportamenti tossici e interazioni negative. È bene non dare energia a cose che non ti interessano.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/IvanSanchez?s=180" class="pquote-avatar" alt="avatar">
    Il mio software è gratuito, ma il mio tempo e la mia attenzione no.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/IvanSanchez">@IvanSanchez</a>, supporto Leaflet
  </p>
</aside>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/foosel?s=180" class="pquote-avatar" alt="avatar">
    Non è un segreto che il supporto open source abbia i suoi lati oscuri, e uno di questi a volte è dover interagire con persone piuttosto ingrate, autorizzate o addirittura tossiche. Man mano che la popolarità di un progetto cresce, aumenta anche la frequenza di questo tipo di interazione, aumentando il carico sui manutentori e diventando forse un fattore di rischio significativo per il burnout dei manutentori..  
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/foosel">@foosel</a>, supporto Octoprint di [How to deal with toxic people](https://www.youtube.com/watch?v=7lIpP3GEyXs)
  </p>
</aside>

Ricorda che l'ecologia personale è una pratica continua che si evolverà man mano che avanzi nel tuo viaggio open source. Dando priorità alla cura di sé e mantenendo un senso di equilibrio, puoi contribuire alla comunità open source in modo efficace e sostenibile, garantendo sia il tuo benessere che il successo a lungo termine dei tuoi progetti.

## Risorse addizionali

* [Maintainer Community](http://maintainers.github.com/)
* [The social contract of open source](https://snarky.ca/the-social-contract-of-open-source/), Brett Cannon
* [Uncurled](https://daniel.haxx.se/uncurled/), Daniel Stenberg 
* [How to deal with toxic people](https://www.youtube.com/watch?v=7lIpP3GEyXs), Gina Häußge
* [SustainOSS](https://sustainoss.org/)
* [Rockwood Art of Leadership](https://rockwoodleadership.org/art-of-leadership/)
* [Saying No](https://mikemcquaid.com/saying-no/), Mike McQuaid
* [Governing Open](https://governingopen.com/)
* Il programma del seminario è un remix della serie di [Mozilla's Movement Building from Home](https://foundation.mozilla.org/en/blog/its-a-wrap-movement-building-from-home/)

## Associati

Mille grazie a tutti i manutentori che hanno condiviso con noi la loro esperienza e i loro consigli per questa guida!

Questa guida è stata scritta da [@abbycabs](https://github.com/abbycabs) con il contributo di:

[@agnostic-apollo](https://github.com/agnostic-apollo)
[@AndreaGriffiths11](https://github.com/AndreaGriffiths11)
[@antfu](https://github.com/antfu)
[@anthonyronda](https://github.com/anthonyronda)
[@CBID2](https://github.com/CBID2)
[@Cli4d](https://github.com/Cli4d)
[@confused-Techie](https://github.com/confused-Techie)
[@danielroe](https://github.com/danielroe)
[@Dexters-Hub](https://github.com/Dexters-Hub)
[@eddiejaoude](https://github.com/eddiejaoude)
[@Eugeny](https://github.com/Eugeny)
[@ferki](https://github.com/ferki)
[@gabek](https://github.com/gabek)
[@geromegrignon](https://github.com/geromegrignon)
[@hynek](https://github.com/hynek)
[@IvanSanchez](https://github.com/IvanSanchez)
[@karasowles](https://github.com/karasowles)
[@KoolTheba](https://github.com/KoolTheba)
[@leereilly](https://github.com/leereilly)
[@ljharb](https://github.com/ljharb)
[@nightlark](https://github.com/nightlark)
[@plarson3427](https://github.com/plarson3427)
[@Pradumnasaraf](https://github.com/Pradumnasaraf)
[@RichardLitt](https://github.com/RichardLitt)
[@rrousselGit](https://github.com/rrousselGit)
[@sansyrox](https://github.com/sansyrox)
[@schlessera](https://github.com/schlessera)
[@shyim](https://github.com/shyim)
[@smashah](https://github.com/smashah)
[@ssalbdivad](https://github.com/ssalbdivad)
[@The-Compiler](https://github.com/The-Compiler)
[@thehale](https://github.com/thehale)
[@thisisnic](https://github.com/thisisnic)
[@tudoramariei](https://github.com/tudoramariei)
[@UlisesGascon](https://github.com/UlisesGascon)
[@waldyrious](https://github.com/waldyrious) + moltri altri!
