---
lang: it
title: Come contribuire all'open source
description: Vuoi contribuire all'open source? Una guida per fornire contributi open source sia per principianti che per veterani.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Perché contribuire all'Open Source?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Lavorare su \[freenode\] mi ha aiutato ad acquisire molte delle competenze che poi ho utilizzato per i miei studi universitari e per il mio lavoro vero e proprio. Penso che lavorare su progetti open source mi aiuti tanto quanto il progetto stesso!
  <p markdown="1" class="pquote-credit">
— [@errietta](https://github.com/errietta), ["Perché amo contribuire al software open source"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Contribuire all'open source può essere un modo gratificante per apprendere, insegnare e sviluppare competenze in quasi tutte le competenze immaginabili.

Perché le persone contribuiscono all'open source? Molte ragioni!

### Migliora il software su cui fai affidamento

Molti contributori open source iniziano come utenti del software a cui contribuiscono. Quando trovi un bug nel software open source che stai utilizzando, potresti voler guardare la fonte per vedere se puoi risolverlo da solo. Se questo è il caso, ripristinare la patch è il modo migliore per garantire che i tuoi amici (e te stesso quando aggiorni alla versione successiva) possano trarne vantaggio.

### Migliorare le competenze esistenti

Che si tratti di codifica, progettazione dell'interfaccia utente, progettazione grafica, scrittura o organizzazione, se stai cercando pratica, c'è un progetto open source adatto a te.

### Incontra persone interessate a cose simili

I progetti open source con comunità calorose e accoglienti fanno sì che le persone ritornino per anni. Molte persone stringono amicizie durature attraverso la loro partecipazione all'open source, sia che si incontrino alle conferenze o alle chat di burrito online a tarda notte.

### Trova mentori e insegna agli altri

Lavorare con altri su un progetto condiviso significa che dovrai spiegare come stai facendo le cose e chiedere aiuto ad altre persone. Gli atti di apprendimento e insegnamento possono essere un'attività soddisfacente per tutti i soggetti coinvolti.

### Costruisci artefatti pubblici che ti aiutino a sviluppare una reputazione (e una carriera)

Per definizione, tutto il tuo lavoro open source è pubblico, il che significa che ottieni esempi gratuiti da portare ovunque come dimostrazione di ciò che sai fare.

### Impara le abilità delle persone

L'open source offre opportunità per esercitare capacità di leadership e gestione, come la risoluzione dei conflitti, l'organizzazione di gruppi di persone e la definizione delle priorità del lavoro.

### Essere in grado di apportare cambiamenti, anche piccoli, dà potere

Non è necessario essere un collaboratore permanente per apprezzare la partecipazione all'open source. Hai mai visto un errore di battitura su un sito web e vorresti che qualcuno lo correggesse? In un progetto open source, puoi fare proprio questo. L'open source aiuta le persone a sentirsi indipendenti riguardo alla propria vita e al modo in cui sperimentano il mondo, e questo di per sé è soddisfacente.

## Cosa significa contribuire

Se sei un nuovo collaboratore open source, il processo può creare confusione. Come trovi il progetto giusto? E se non sai programmare? E se qualcosa va storto?

Non preoccuparti! Esistono molti modi per essere coinvolti in un progetto open source e alcuni suggerimenti ti aiuteranno a ottenere il massimo dalla tua esperienza.

### Non è necessario aggiungere alcun codice

Un malinteso comune riguardo al contributo all'open source è che si debba contribuire con il codice. In effetti, sono spesso le altre parti del progetto ad essere [più trascurate o trascurate](https://github.com/blog/2195-the-shape-of-open-source). Farai un _enorme_ favore al progetto offrendoti di contribuire con questo tipo di contributi!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Sono conosciuto per il mio lavoro su CocoaPods, ma la maggior parte delle persone non sa che in realtà non svolgo alcun lavoro reale sullo strumento CocoaPods stesso. Il mio tempo nel progetto è dedicato principalmente a cose come la documentazione e il lavoro di branding.
  <p markdown="1" class="pquote-credit">
— [@orta](https://github.com/orta), ["Passa a OSS per impostazione predefinita"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Anche se ti piace scrivere codice, altri tipi di contributi sono un ottimo modo per essere coinvolto in un progetto e incontrare altri membri della comunità. Costruire queste relazioni ti darà l'opportunità di lavorare su altre parti del progetto.

### Ti piace pianificare eventi?

* Organizzare workshop o incontri per il progetto, [come ha fatto @fzamperin per NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Organizzare una conferenza di progetto (se applicabile)
* Aiuta i membri della comunità a trovare le conferenze giuste e a inviare proposte di interventi

### Ti piace progettare?

* Ristrutturare i layout per migliorare l'usabilità del progetto
* Condurre ricerche sugli utenti per riorganizzare e perfezionare la navigazione o i menu del progetto, [come suggerito da Drupal](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Compila una guida di stile per aiutare il progetto ad avere un design visivo coerente
* Crea una grafica per la maglietta o un nuovo logo, [come hanno fatto i contributori di hapi.js](https://github.com/hapijs/contrib/issues/68)

### Ti piace scrivere?

* Scrivi e migliora la documentazione del progetto, [come ha fatto @CBID2 per la documentazione di OpenSauced](https://github.com/open-sauced/docs/pull/151)
* Preparare una cartella di esempi che mostrano come viene utilizzato il progetto
* Avvia una newsletter del progetto o cura i punti salienti della mailing list, [come ha fatto @opensauced per il suo prodotto](https://news.opensauced.pizza/about/)
* Scrivi tutorial per il progetto, [come hanno fatto i contributori PyPA](https://packaging.python.org/)
* Scrivi una traduzione per la documentazione del progetto, [come ha fatto @frontendwizard per le istruzioni CSS Flexbox della sfida freeCodeCamp](https://github.com/freeCodeCamp/freeCodeCamp/pull/19077)

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Seriamente, la \[documentazione\] è estremamente importante. La documentazione finora è stata eccezionale ed è una caratteristica fondamentale di Babel. Ci sono sezioni che potrebbero sicuramente funzionare, e anche aggiungere un paragrafo qua o là è molto apprezzato.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Invito per contribuire"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Ti piace organizzare?

* Collegamento a problemi duplicati e suggerimento di nuovi thread di problemi per mantenerti organizzato
* Esamina i problemi aperti e suggerisci di chiudere quelli vecchi, [come ha fatto @nzakas per ESLint](https://github.com/eslint/eslint/issues/6765)
* Fai domande chiarificatrici sui problemi appena scoperti per portare avanti la discussione

### Ti piace programmare?

* Trova un problema aperto da risolvere, [come ha fatto @dianjin per Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Chiedi se puoi aiutare a registrare una nuova funzionalità
* Automatizza le impostazioni del progetto
* Migliorare strumenti e test

### Ti piace aiutare le persone?

* Rispondi alle domande sul progetto, ad es. Stack Overflow ([come questo esempio di Postgres](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) o Reddit
* Rispondi alle domande delle persone in domande aperte
* Aiuta a moderare forum di discussione o canali di chat

### Ti piace aiutare gli altri a programmare?

* Rivedi il codice delle dichiarazioni di altre persone
* Scrivi tutorial su come utilizzare un progetto
* Offrirti di fare da mentore a un altro collaboratore, [come ha fatto @ereichert per @bronzdoc in Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Non devi lavorare solo su progetti software!

Sebbene "open source" si riferisca spesso al software, puoi collaborare praticamente su qualsiasi cosa. Ci sono libri, ricette, elenchi e lezioni che vengono sviluppati come progetti open source.

Per esempio:

* @sindresorhus preparare [un elenco di elenchi "grandi".](https://github.com/sindresorhus/awesome)
* @h5bp mantenere un [elenco di potenziali domande per l'intervista](https://github.com/h5bp/Front-end-Developer-Interview-Questions) per i candidati sviluppatori front-end
* @stuartlynn e @nicole-a-tesla hanno realizzato una [raccolta di curiosità sui puffini](https://github.com/stuartlynn/puffin_facts)

Anche se sei uno sviluppatore di software, lavorare su un progetto di documentazione può aiutarti a iniziare con l'open source. Spesso è meno intimidatorio lavorare su progetti che non implicano codice e il processo collaborativo aumenterà la tua sicurezza e la tua esperienza.

## Orientamento verso un nuovo progetto

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Se vai a un rilevatore di problemi e le cose sembrano confuse, non sei solo tu. Questi strumenti richiedono molta conoscenza implicita, ma le persone possono aiutarti a esplorarli e puoi porre loro domande.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["Come contribuire all'open source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Oltre a correggere un errore di battitura, contribuire all'open source è come avvicinarsi a un gruppo di sconosciuti a una festa. Se inizi a parlare dei lama mentre sono immersi in una discussione sui pesci rossi, probabilmente ti guarderanno in modo un po' strano.

Prima di lanciarti alla cieca con i tuoi suggerimenti, inizia imparando a leggere la stanza. In questo modo aumenti le possibilità che le tue idee vengano notate e ascoltate.

### Anatomia di un progetto open source

Ogni comunità open source è diversa.

Trascorrere anni su un progetto open source significa che hai acquisito familiarità con un progetto open source. Passa a un altro progetto e potresti scoprire che il vocabolario, le norme e gli stili di comunicazione sono completamente diversi.

Tuttavia, molti progetti open source seguono una struttura organizzativa simile. Comprendere i diversi ruoli nella comunità e il processo complessivo ti aiuterà a navigare rapidamente in qualsiasi nuovo progetto.

Un tipico progetto open source prevede i seguenti tipi di persone:

* **Autore:** La/e persona/e o organizzazione che ha creato il progetto
* **Proprietario:** la/e persona/e che ha la proprietà amministrativa dell'organizzazione o del repository (non sempre coincide con l'autore originale)
* **Sostenitori:** Collaboratori responsabili della gestione della visione e della gestione degli aspetti organizzativi del progetto (possono anche essere autori o proprietari del progetto.)
* **Contributori:** chiunque abbia contribuito con qualcosa al progetto
* **Membri della comunità:** le persone che utilizzano il progetto. Possono essere attivi nelle conversazioni o esprimere la loro opinione sulla direzione del progetto

I progetti più grandi possono anche avere sottocomitati o gruppi di lavoro focalizzati su compiti diversi, come strumenti, smistamento, moderazione della comunità e organizzazione di eventi. Cerca nel sito web di un progetto una pagina "team" o il repository della documentazione di gestione per trovare queste informazioni.

C'è anche la documentazione del progetto. Questi file sono generalmente elencati al livello più alto del repository.

* **LICENZA:** Per definizione, ogni progetto open source deve avere una [licenza open source](https://choosealicense.com). Se il progetto non ha una licenza, non è open source.
* **README:** Il README è la guida pratica che accoglie i nuovi membri della comunità nel progetto. Spiega perché il progetto è utile e come iniziare.
* **CONTRIBUTO:** Mentre i README aiutano le persone a _utilizzare_ il progetto, i documenti che contribuiscono aiutano le persone a _contribuire_ al progetto. Spiega quali tipi di contributi sono richiesti e come funziona il processo. Anche se non tutti i progetti hanno un file CONTRIBUTOR, la sua presenza segnala che è un progetto accogliente a cui contribuire. Un buon esempio di guida ai contributi efficace sarebbe questo dal [repository di documenti Codecademy](https://www.codecademy.com/resources/docs/contribution-guide).
* **CODE_OF_CONDUCT:** Il Codice di condotta stabilisce le regole di base per la condotta associata dei partecipanti e aiuta a creare un ambiente amichevole e accogliente. Anche se non tutti i progetti hanno un file CODE_OF_CONDUCT, la sua presenza segnala che si tratta di un progetto accogliente a cui contribuire.
* **Altra documentazione:** Potrebbe essere presente documentazione aggiuntiva come tutorial, istruzioni o politiche di gestione, in particolare per progetti più grandi come [Astro Docs](https://docs.astro.build/en/contribute/#contributing-to-docs).

Infine, i progetti open source utilizzano i seguenti strumenti per organizzare la discussione. Leggere gli archivi ti darà una buona idea di come pensa e funziona la comunità.

* **Tracciamento dei problemi:** dove le persone discutono questioni relative al progetto.
* **Richieste pull:** quando le persone discutono e rivedono le modifiche in corso, sia che si tratti di migliorare l'ordine del codice dei contributori, l'utilizzo della grammatica, l'utilizzo delle immagini, ecc. Alcuni progetti, come [MDN Web Docs](https://github.com/mdn/content/blob/main/.github/workflows/markdown-lint.yml), utilizzano determinati flussi di azioni GitHub per automatizzare e velocizzare le loro revisioni del codice.
* **Forum di discussione o mailing list:** Alcuni progetti possono utilizzare questi canali per argomenti di conversazione (ad esempio _"Come..."_ o _"Cosa ne pensi di..."_ invece di segnalazioni di bug o richieste per le funzioni). Altri utilizzano il tracker dei problemi per tutte le chiamate. Un buon esempio di ciò potrebbe essere la [newsletter settimanale CHAOSS](https://chaoss.community/news/)
* **Canale di chat sincrono:** alcuni progetti utilizzano canali di chat (come Slack o IRC) per conversazioni informali, collaborazione e scambi rapidi. Un buon esempio di ciò potrebbe essere [EddieHub Discord Community](http://discord.eddiehub.org/).

## Trova un progetto a cui contribuire

Ora che hai capito come funzionano i progetti open source, è il momento di trovare un progetto a cui contribuire!

Se non hai mai contribuito all'open source prima, segui il consiglio del presidente degli Stati Uniti John F. Kennedy, che una volta disse: "Non chiederti cosa può fare il tuo paese per te, chiediti cosa puoi fare tu per il tuo paese".

<aside markdown="1" class="pquote">
  <img src="/assets/images/how-to-contribute/johnfkennedy.jpg" class="pquote-avatar" alt="avatar">
  Non chiederti cosa può fare il tuo Paese per te: chiediti cosa puoi fare tu per il tuo Paese.
  <p markdown="1" class="pquote-credit">
— [_Biblioteca John F. Kennedy_](https://www.jfklibrary.org/learn/education/teachers/curricular-resources/ask-not-what-your-country-can-do-for-you)
  </p>
</aside>

Il contributo all'open source avviene a tutti i livelli, in tutti i progetti. Non devi pensare troppo a quale sarà esattamente il tuo primo contributo o come sarà.

Inizia invece pensando ai progetti che già usi o che desideri utilizzare. I progetti a cui partecipi attivamente sono quelli a cui continui a tornare.

All'interno di questi progetti, ogni volta che ti sorprendi a pensare che qualcosa potrebbe essere migliore o diverso, agisci secondo il tuo istinto.

L'open source non è un club esclusivo; è fatto da persone proprio come te. "Open source" è solo un termine elegante per considerare i problemi del mondo come risolvibili.

È possibile eseguire la scansione del README e trovare un collegamento interrotto o un errore di battitura. O sei un nuovo utente e hai notato che qualcosa non funziona, oppure c'è un problema che ritieni dovrebbe essere presente nella documentazione. Invece di ignorarlo e andare avanti o chiedere a qualcun altro di risolverlo, vedi se puoi aiutare partecipando. Ecco cos'è l'open source!

> Secondo uno studio di Igor Steinmacher e altri ricercatori di informatica, [il 28% dei contributi accessori](https://www.igor.pro.br/publica/papers/saner2016.pdf) in open source sono documenti, come come correzioni di errori di battitura, riformattazione o scrittura di traduzioni.

Se stai cercando problemi esistenti che puoi risolvere, ogni progetto open source ha una pagina "/contribute" che evidenzia problemi adatti ai principianti con cui puoi iniziare. Vai alla pagina principale del repository GitHub e aggiungi "/contribute" alla fine dell'URL (ad es.[`https://github.com/facebook/react/contribute`](https://github.com/facebook/react/contribute)).

Puoi anche utilizzare una delle seguenti risorse per aiutarti a scoprire e contribuire a nuovi progetti:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)
* [OpenSauced](https://opensauced.pizza/)

### Lista di controllo prima di contribuire

Quando trovi un progetto a cui vuoi contribuire, esegui una rapida scansione per assicurarti che il progetto sia idoneo ad accettare contributi. Altrimenti, il tuo duro lavoro potrebbe non ricevere mai risposta.

Ecco una pratica lista di controllo per valutare se un progetto è adatto ai nuovi contributori.

**Soddisfa la definizione di open source**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  Ha la licenza? Di solito c'è un file chiamato LICENSE nella radice del repository.
  </label>
</div>

**Il progetto accetta attivamente contributi**

Guarda l'attività di commit sul ramo master. Su GitHub, puoi vedere queste informazioni nella scheda Approfondimenti della home page di un repository, ad esempio[Virtual-Coffee](https://github.com/Virtual-Coffee/virtualcoffee.io/pulse)

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  Quando è stato l'ultimo fidanzamento?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Quanti collaboratori ha il progetto?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Quanto spesso le persone si impegnano? (Su GitHub, puoi trovarlo facendo clic su "Commit" nella barra in alto.)
  </label>
</div>

Poi guarda i problemi del progetto.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Quante domande aperte ci sono?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    I manutentori sono rapidi nel rispondere ai problemi quando vengono sollevati?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    C’è una discussione attiva sulle questioni?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    I problemi sono recenti?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    I problemi stanno finendo? (Su GitHub, fai clic sulla scheda "chiuso" nella pagina dei problemi per visualizzare i problemi chiusi.)
  </label>
</div>

Ora fai lo stesso per le richieste pull del progetto.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Quante richieste pull aperte ci sono?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    I manutentori rispondono rapidamente alle richieste pull quando vengono aperte?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Esiste una discussione attiva sulle richieste pull?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Le richieste di download sono recenti?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Quanto tempo fa sono state unite tutte le richieste pull? (Su GitHub, fai clic sulla scheda "chiuso" nella pagina Pull Requests per vedere i PR chiusi.)
  </label>
</div>

**Il progetto è accogliente**

Un progetto amichevole e accogliente segnala che saranno ricettivi verso nuovi collaboratori.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    I manutentori rispondono in modo utile alle domande sui problemi?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    Le persone sono amichevoli nei problemi, nei forum di discussione e nelle chat (ad esempio IRC o Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    Vengono prese in considerazione le richieste pull?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    I manutentori ringraziano le persone per i loro contributi?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Ogni volta che vedi un thread lungo, controlla a campione le risposte degli sviluppatori principali che arrivano alla fine del thread. Riassumono in modo costruttivo e adottano misure per portare il thread a una risoluzione pur rimanendo educati? Se vedi molte guerre di fiamma in corso, spesso è un segno che l'energia viene utilizzata nella discussione invece che nello sviluppo.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Produrre OSS_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Come inviare un contributo

Hai trovato un progetto che ti piace e sei pronto a contribuire. Finalmente! Ecco come ottenere il tuo contributo nel modo giusto.

### Comunicazione effettiva

Che tu collabori occasionalmente o cerchi di entrare a far parte di una comunità, lavorare con gli altri è una delle competenze più importanti che svilupperai nell'open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[Come nuovo collaboratore,\] mi sono reso conto subito che dovevo fare domande se volevo riuscire a chiudere la questione. Ho dato una rapida occhiata al codice base. Dopo aver percepito cosa stava succedendo, ho chiesto ulteriori indicazioni. E fatto! Sono riuscito a risolvere il problema dopo aver ottenuto tutti i dettagli di cui avevo bisogno.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [Un viaggio molto accidentato per principianti attraverso il mondo dell'open source](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

Prima di aprire un problema o una richiesta pull o porre una domanda in chat, tieni a mente questi punti per aiutare le tue idee a prendere vita in modo efficace.

**Fornisci contesto.** Aiuta gli altri a salire a bordo rapidamente. Se riscontri un errore, spiega cosa stai cercando di fare e come riprodurlo. Se stai proponendo una nuova idea, spiega perché pensi che sarebbe utile per il progetto (non solo per te!).

> 😇 _"X non accade quando faccio Y"_
>
> 😢 _"X è rotto! Per favore aggiustalo."_

**Fai i compiti in anticipo.** Va bene non sapere le cose, ma dimostra che ci hai provato. Prima di chiedere aiuto, assicurati di controllare il README del progetto, la documentazione, i problemi (aperti o chiusi), la mailing list e cerca una risposta in Internet. Le persone apprezzeranno quando dimostrerai che stai cercando di imparare.

> 😇 _"Non sono sicuro di come implementare X. Ho controllato i documenti di aiuto e non ho trovato alcuna menzione."_
>
> 😢 _"Come faccio X?"_

**Mantieni le richieste brevi e dirette.** Come inviare un'email, qualsiasi contributo, non importa quanto semplice o utile, richiede che qualcun altro lo esamini. Molti progetti hanno più richieste in arrivo che persone che possono aiutare. Sii breve. Aumenterai le possibilità che qualcuno possa aiutarti.

> 😇 _"Vorrei scrivere un tutorial API."_
>
> 😢 _"L'altro giorno stavo guidando lungo l'autostrada e mi sono fermato per fare benzina e poi ho avuto questa fantastica idea di qualcosa che dovremmo fare, ma prima di spiegartelo, lascia che te lo mostri..."_

**Mantieni pubbliche tutte le comunicazioni.** Sebbene sia allettante, non contattare personalmente i manutentori a meno che non sia necessario condividere informazioni sensibili (come un problema di sicurezza o una cattiva condotta grave). Quando mantieni pubblica la conversazione, più persone possono imparare e trarre vantaggio dal tuo scambio. Le discussioni possono essere di per sé un contributo.

> 😇 _(come commento) "@-maintainer Ciao! Come procediamo con questo PR?"_
>
> 😢 _(come email) "Ciao, scusa se ti disturbo via email, ma mi chiedevo se avessi la possibilità di rivedere il mio PR"_

**Va bene fare domande (ma sii paziente!).** Tutti sono stati nuovi ad un progetto ad un certo punto, e anche i contributori più esperti devono aggiornarsi quando guardano un nuovo progetto. Allo stesso modo, anche i manutentori di lunga data non hanno sempre familiarità con ogni parte del progetto. Mostra loro la stessa pazienza che vorresti che mostrassero a te.

> 😇 _"Grazie per aver esaminato questo errore. Ho seguito i tuoi suggerimenti. Ecco il risultato."_
>
> 😢 _"Perché non riesci a risolvere il mio problema? Non è questo il tuo progetto?"_

**Rispetta le decisioni della comunità.** Le tue idee potrebbero differire dalle priorità o dalla visione della comunità. Potrebbero offrire feedback o decidere di non perseguire la tua idea. Anche se dovresti discutere e trovare un compromesso, i manutentori devono convivere con la tua decisione più a lungo di te. Se non sei d'accordo con la loro direzione, puoi sempre lavorare sul tuo fork o iniziare il tuo progetto.

> 😇 _"Mi dispiace che tu non possa supportare il mio caso d'uso, ma come hai spiegato tu riguarda solo una piccola parte di utenti, capisco il motivo. Grazie per l'ascolto."_
>
> 😢 _"Perché non supporti il ​​mio caso d'uso? Questo è inaccettabile!"_

**Soprattutto, mantienilo elegante.** L'open source è composto da contributori provenienti da tutto il mondo. Si perde il contesto tra lingue, culture, aree geografiche e fusi orari. Inoltre, la comunicazione scritta rende più difficile trasmettere il tono o l'umore. Assumi buone intenzioni in queste conversazioni. Va bene rifiutare educatamente un'idea, chiedere più contesto o chiarire ulteriormente la tua posizione. Prova solo a lasciare Internet in un posto migliore di quando l'hai trovato.

### Raccogli il contesto

Prima di agire, fai un rapido controllo per assicurarti che la tua idea non sia stata discussa altrove. Visualizza il README del progetto, i problemi (aperti e chiusi), la mailing list e Stack Overflow. Non devi passare ore a esaminare tutto, ma una rapida ricerca di alcuni termini chiave può fare molto.

Se non riesci a trovare la tua idea altrove, sei pronto a fare una mossa. Se il progetto è su GitHub, probabilmente comunicherai nel modo seguente:

* **Sollevare un problema:** è come avviare una conversazione o una discussione
* **Le richieste pull** servono per iniziare a lavorare su una soluzione.
* **Canali di comunicazione:** se il progetto ha un canale Discord, IRC o Slack designato, valuta la possibilità di avviare una conversazione o chiedere chiarimenti sul tuo contributo.

Prima di aprire un problema o una richiesta pull, controlla i documenti che contribuiscono al progetto (di solito un file chiamato CONTRIBUTING o nel README) per vedere se è necessario includere qualcosa di specifico. Ad esempio, potrebbero chiederti di seguire uno schema o richiederti di utilizzare dei test.

Se vuoi dare un contributo significativo, apri un issue da chiedere prima di lavorarci. È utile guardare il progetto per un po' (su GitHub, [puoi fare clic su "Guarda"](https://help.github.com/articles/watching-repositories/) per ricevere una notifica di tutte le conversazioni) e accedere a conoscere i membri della comunità prima di svolgere lavori che potrebbero non essere accettati.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Imparerai <em>molto</em> prendendo un progetto che stai utilizzando attivamente, "guardandolo" su GitHub e leggendo ogni numero e PR.
<p markdown="1" class="pquote-credit">
— @gaearon [per partecipare ai progetti](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Apertura di un problema

Di solito dovresti aprire un problema nelle seguenti situazioni:

* Segnala un bug che non puoi risolvere da solo
* Discutere un argomento o un'idea di alto livello (ad esempio comunità, visione o politiche)
* Suggerisci una nuova funzionalità o un'altra idea di progetto

Suggerimenti per comunicare sui problemi:

* **Se vedi un problema aperto su cui vuoi lavorare**, commenta il problema per far sapere alle persone che ci stai lavorando. In questo modo, le persone avranno meno probabilità di duplicare il tuo lavoro.
* **Se un problema è stato scoperto qualche tempo fa,** potrebbe essere stato risolto altrove o già risolto, quindi commenta per chiedere conferma prima di iniziare il lavoro.
* **Se hai aperto un problema ma hai trovato la risposta da solo in seguito,** commenta il problema per farlo sapere alle persone, quindi chiudi il problema. Anche documentare questo risultato è un contributo al progetto.

### Apertura di una richiesta pull

Di solito dovresti aprire una richiesta pull nelle seguenti situazioni:

* Invia correzioni minori come errori di battitura, collegamenti interrotti o errori evidenti.
* Inizia a lavorare su un contributo che ti è già stato richiesto o di cui hai già parlato in un numero.

Una richiesta pull non deve rappresentare un lavoro completato. Di solito è meglio aprire una richiesta pull in anticipo in modo che altri possano guardare o fornire feedback sui tuoi progressi. Basta aprirlo come "bozza" o contrassegnarlo come "WIP" (Lavori in corso) nella riga dell'oggetto o nelle sezioni "Note ai revisori" se fornite (oppure puoi semplicemente crearne una tua. In questo modo: `** # # Note per il revisore**`). Puoi sempre aggiungere altri impegni in un secondo momento.

Se il progetto è su GitHub, ecco come inviare una richiesta pull:

* **[Fork il repository](https://guides.github.com/activities/forking/)** e clonalo localmente. Connetti il ​​tuo locale al repository upstream originale aggiungendolo come remoto. Estrai spesso le modifiche da "upstream" per rimanere aggiornato, quindi quando invii la tua richiesta di pull, i conflitti di unione saranno meno probabili. (Vedi istruzioni più dettagliate [qui](https://help.github.com/articles/syncing-a-fork/).)
* **[Crea un ramo](https://guides.github.com/introduction/flow/)** per le tue modifiche.
* **Elenca eventuali problemi rilevanti** o documentazione di supporto nel tuo PR (ad esempio "Chiude n. 37.")
* **Includi screenshot prima e dopo** se le modifiche comportano differenze HTML/CSS. Trascina e rilascia le immagini nel corpo della tua richiesta pull.
* **Testa le tue modifiche!** Esegui le tue modifiche confrontandole con eventuali test esistenti, se presenti, e creane di nuovi quando necessario. È importante assicurarsi che le modifiche non interrompano il progetto esistente.
* **Contribuisci allo stile del progetto** secondo le tue capacità. Ciò può significare utilizzare il rientro, il punto e virgola o i commenti in modo diverso rispetto a quanto faresti nel tuo repository, ma rende più facile per il manutentore unirli e per gli altri comprenderli e mantenerli in futuro.

Se questa è la tua prima richiesta pull, dai un'occhiata a [Crea una richiesta pull](http://makeapullrequest.com/) che @kentcdodds ha creato come tutorial video dimostrativo. Puoi anche esercitarti a creare una richiesta pull sul repository [First Contributions](https://github.com/Roshanjossey/first-contributions) creato da @Roshanjossey.

## Cosa succede dopo aver inviato il tuo contributo

Prima di iniziare a festeggiare, dopo che avrai inviato il tuo contributo si verificherà una delle seguenti situazioni:

### 😭 Non riceverai risposta

Ci auguriamo che tu abbia [controllato eventuali segni di attività nel progetto](#lista-di-controllo-prima-di-contribuire) prima di contribuire. Anche con un progetto attivo, però, è possibile che il tuo contributo non riceva risposta.

Se non ricevi notizie da più di una settimana, è giusto rispondere educatamente nello stesso thread chiedendo a qualcuno di recensire. Se conosci il nome della persona giusta per rivedere il tuo contributo, puoi @ menzionarla in questo thread.

**Non contattare personalmente questa persona**; ricorda che la comunicazione pubblica è vitale per i progetti open source.

Se fai un cortese promemoria e continui a non ricevere risposta, è possibile che nessuno risponderà mai. Non è una sensazione fantastica, ma non lasciarti scoraggiare! 😄 Esistono molte possibili ragioni per cui non hai ricevuto una risposta, comprese circostanze personali che potrebbero andare oltre il tuo controllo. Prova a trovare un altro progetto o un modo per contribuire. Se non altro, è un buon motivo per non investire troppo tempo nel contribuire prima che gli altri membri della comunità siano coinvolti e reattivi.

### 🚧 Qualcuno vuole modifiche al tuo contributo

È comune che ti venga chiesto di apportare modifiche al tuo contributo, che si tratti di feedback sulla portata della tua idea o di modifiche al tuo codice.

Quando qualcuno chiede modifiche, sii reattivo. Si sono presi il tempo per rivedere il tuo contributo. Aprire un PR e andarsene è una cattiva forma. Se non sai come apportare modifiche, ricerca il problema e poi chiedi aiuto se ne hai bisogno. Un buon esempio di ciò potrebbe essere [il feedback che un altro collaboratore ha dato a @a-m-lamb sulla sua richiesta di pull ai documenti Codecademy](https://github.com/Codecademy/docs/pull/3239#pullrequestreview-1628036286).

Se non hai più tempo per lavorare sul problema perché la conversazione va avanti da mesi e le tue circostanze sono cambiate o non riesci a trovare una soluzione, informa un manutentore in modo che possa aprire il problema a qualcun altro , come ha fatto [@RitaDee per un problema nelle applicazioni OpenSauced](https://github.com/open-sauced/app/issues/1656#issuecomment-1729353346).

### 👎 Il tuo contributo non è accettato

Il tuo contributo potrebbe essere accettato o meno alla fine. Spero che tu non ci abbia già dedicato troppo lavoro. Se non sei sicuro del motivo per cui non è stato accettato, è perfettamente ragionevole chiedere al manutentore feedback e chiarimenti. Alla fine, però, dovrai rispettare il fatto che è una loro decisione. Non discutere e non essere ostile. Sei sempre il benvenuto ad espanderti e lavorare sulla tua versione se non sei d'accordo!

### 🎉 Il tuo contributo è accettato

Evviva! Hai dato con successo un contributo open source!

## Fallo! 🎉

Se hai appena dato il tuo primo contributo open source o stai cercando nuovi modi per contribuire, speriamo che tu sia ispirato ad agire. Anche se il tuo contributo non è stato accettato, assicurati di dire grazie quando il manutentore ha fatto uno sforzo per aiutarti. L'open source è creato da persone come te: un problema, una richiesta pull, un commento o il cinque alla volta.
