---
lang: it
title: Essere pagati per il lavoro open source
description: Mantieni il tuo lavoro open source ottenendo supporto finanziario per il tuo tempo o il tuo progetto.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Perché alcune persone cercano un sostegno finanziario

Gran parte del lavoro open source è volontario. Ad esempio, qualcuno potrebbe imbattersi in un bug in un progetto che sta utilizzando e inviare una soluzione rapida, oppure potrebbe divertirsi armeggiare con un progetto open source nel tempo libero.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Stavo cercando un progetto di programmazione "hobby" per tenermi occupato durante la settimana intorno a Natale. (...) Avevo tra le mani un computer di casa e nient'altro. Ho deciso di scrivere un interprete per il nuovo linguaggio di scripting a cui ho pensato ultimamente. (...) Ho scelto Python come titolo provvisorio.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programmazione di Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Ci sono molte ragioni per cui non si vorrebbe essere pagati per il proprio lavoro open source.

* **Potrebbero già avere un lavoro a tempo pieno che amano,** che consente loro di contribuire all'open source nel tempo libero.
* **A loro piace pensare all'open source come a un hobby** o a una fuga creativa e non vogliono sentirsi finanziariamente obbligati a lavorare sui propri progetti.
* **Ottengono altri vantaggi dal contributo all'open source,** come costruire una reputazione o un portfolio, apprendere nuove competenze o sentirsi vicini a una comunità.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Le donazioni finanziarie aggiungono un senso di responsabilità per alcuni. (...) È importante per noi, nel mondo globalmente connesso e frenetico in cui viviamo, poter dire "non ora, voglio fare qualcosa di completamente diverso".
  <p markdown="1" class="pquote-credit">
— @alloy, ["Perchè non accettiamo donazioni?"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Per altri, soprattutto quando il contributo è in corso o richiede molto tempo, essere pagati per contribuire all'open source è l'unico modo per partecipare, sia perché il progetto lo richiede sia per motivi personali.

Mantenere progetti popolari può essere una responsabilità significativa, impiegando 10 o 20 ore a settimana invece di poche ore al mese.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Chiedi a qualsiasi sostenitore di progetti open source e ti diranno la realtà della quantità di lavoro necessaria per gestire un progetto. Hai clienti. Risolvi i problemi per loro. Crei nuove funzionalità. Diventa una vera e propria richiesta del tuo tempo.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["L'etica del lavoro non retribuito e la comunità OSS"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Il lavoro retribuito consente inoltre a persone provenienti da percorsi di vita diversi di dare un contributo significativo. Alcune persone non possono permettersi di dedicare tempo non retribuito a progetti open source a causa della loro attuale situazione finanziaria, dei debiti, delle responsabilità familiari o di altro tipo. Ciò significa che il mondo non vede mai contributi da parte di persone di talento che non possono permettersi di offrire volontariato. Ciò ha implicazioni etiche, come @ashedryden [descritto](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community) poiché il lavoro svolto è distorto nel favorire coloro che hanno già vantaggi nella vita, che poi ricevono ulteriori vantaggi in base ai loro contributi volontari, mentre ad altri che non possono fare volontariato vengono negate opportunità successive, rafforzando l'attuale mancanza di diversità nella comunità open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   L’OSS apporta enormi vantaggi al settore tecnologico, che a loro volta si traducono in vantaggi per tutti i settori. (...) Tuttavia, se le uniche persone che riescono a focalizzarsi su di esso sono i fortunati e gli ossessionati, allora c'è un enorme potenziale non sfruttato.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Soldi e open source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Se stai cercando un sostegno finanziario, ci sono due modi da considerare. Puoi finanziare il tuo tempo come collaboratore oppure puoi trovare finanziamenti organizzativi per il progetto.

## Finanziare il proprio tempo

Oggi molte persone vengono pagate per lavorare part-time o full-time nell'open source. Il modo più comune per essere pagato per il tuo tempo è parlare con il tuo datore di lavoro.

È più semplice sostenere il lavoro open source se il tuo datore di lavoro utilizza effettivamente il progetto, ma sii creativo con la tua presentazione. Forse il tuo datore di lavoro non utilizza il progetto, ma usa Python e il mantenimento di un progetto Python popolare aiuta ad attrarre nuovi sviluppatori Python. Forse fa sembrare il tuo datore di lavoro più amichevole agli sviluppatori in generale.

Se non hai un progetto open source esistente su cui ti piacerebbe lavorare, ma preferisci che il tuo lavoro attuale sia open source, chiedi al tuo datore di lavoro di rendere open source alcuni dei loro software interni.

Molte aziende stanno sviluppando programmi open source per rafforzare il proprio marchio e assumere talenti di qualità.

@hueniverse ad esempio, ha scoperto che c'erano ragioni finanziarie per giustificare [l'investimento di Walmart nell'open source](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). E @jamesgpearce ha scoperto che il programma open source di Facebook [è importante](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) nel reclutamento:

> È strettamente correlato alla nostra cultura hacker e al modo in cui la nostra organizzazione veniva percepita. Abbiamo chiesto ai nostri dipendenti: "Conoscevi il programma software open source di Facebook?". Due terzi hanno detto "Sì". La metà ha affermato che il programma ha contribuito positivamente alla decisione di lavorare per noi. Questi non sono numeri estremi e spero che la tendenza continui.

Se la tua azienda segue questa strada, è importante mantenere chiari i confini tra le operazioni comunitarie e aziendali. Dopotutto, l'open source è supportato dal contributo di persone di tutto il mondo, e questo è più grande di quello di qualsiasi altra azienda o luogo.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Essere pagati per un lavoro open source è un'opportunità rara e meravigliosa, ma non devi rinunciare alla tua passione nel processo. La tua passione dovrebbe essere il motivo per cui le aziende vogliono pagarti.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Linee sfocate"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Se non riesci a convincere il tuo attuale datore di lavoro a dare priorità al lavoro open source, valuta la possibilità di trovare un nuovo datore di lavoro che incoraggi il contributo dei dipendenti all'open source. Cerca aziende che sottolineano il loro impegno verso l'open source. Per esempio:

* Ad alcune aziende piace [Netflix](https://netflix.github.io/), hanno siti web che evidenziano il loro coinvolgimento nell'open source
* [Zalando](https://opensource.zalando.com) пdivulga la sua [politica di contributo open source](https://opensource.zalando.com/docs/using/contributing/) per i dipendenti

È probabile che anche i progetti che provengono da una grande azienda, come [Go](https://github.com/golang) o [React](https://github.com/facebook/react), assumano persone per lavorare con l'open source.

A seconda delle tue circostanze personali, puoi provare a raccogliere fondi in modo indipendente per finanziare il tuo lavoro open source. Per esempio:

* @Homebrew (e [molti altri sostenitori e organizzazioni](https://github.com/sponsors/community)) finanziano il loro lavoro tramite [Sponsor Github](https://github.com/sponsors)
* @gaearon ha finanziato il suo lavoro su [Redux](https://github.com/reactjs/redux) attraverso una [campagna di crowdfunding Patreon](https://redux.js.org/)
* I fondi @andrewgodwin lavorano sulle migrazioni dello schema Django [tramite campagna Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

Infine, a volte i progetti open source offrono premi per problemi che potresti considerare di aiutare.

* @ConnorChristie è riuscito a essere pagato per [aiuto](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol stanno lavorando sulla propria libreria JavaScript [tramite ricompensa gitcoin](https://gitcoin.co/).
* @mamiM ha realizzato traduzioni giapponesi per @MetaMask dopo [il rilascio è stato finanziato da Bounties Network](https://explorer.bounties.network/bounty/134).

## Trovare finanziamenti per il tuo progetto

Oltre agli accordi per i singoli contributori, i progetti a volte raccolgono fondi da aziende, individui o altri per finanziare il lavoro in corso.

I finanziamenti organizzativi possono essere utilizzati per pagare i contributori attuali, coprire i costi di gestione del progetto (come le tariffe di hosting) o investire in nuove funzionalità o idee.

Con la crescente popolarità dell'open source, trovare finanziamenti per i progetti è ancora sperimentale, ma esistono alcune opzioni comuni.

### Raccogli fondi per il tuo lavoro attraverso il crowdfunding o campagne di sponsorizzazione

Trovare una sponsorizzazione funziona bene se hai già un pubblico o una reputazione forti o se il tuo progetto è molto popolare.
Alcuni esempi di progetti sponsorizzati includono:

* **[webpack](https://github.com/webpack)** raccoglie denaro da aziende e privati ​​[via OpenCollective](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** organizzazione no-profit che paga il lavoro di [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems) e altri progetti infrastrutturali di Ruby

### Crea un flusso di reddito

A seconda del tuo progetto, potresti essere in grado di addebitare il supporto commerciale, le opzioni di hosting o le funzionalità aggiuntive. Alcuni esempi includono:

* **[Sidekiq](https://github.com/mperham/sidekiq)** offre versioni a pagamento per ulteriore supporto
* **[Travis CI](https://github.com/travis-ci)** offre versioni a pagamento del suo prodotto
* **[Ghost](https://github.com/TryGhost/Ghost)** è un'organizzazione no-profit con un servizio gestito a pagamento

Alcuni progetti popolari, come [npm](https://github.com/npm/cli) e [Docker](https://github.com/docker/docker), stanno addirittura raccogliendo capitali di rischio per sostenere la crescita di i loro affari.

### Richiedi un finanziamento

Alcune fondazioni e aziende di software offrono sovvenzioni per il lavoro open source. A volte le sovvenzioni possono essere pagate a individui senza creare un'entità legale per il progetto.

* **[Leggi i documenti](https://github.com/rtfd/readthedocs.org)** ha ricevuto una sovvenzione da [Support of Mozilla Open Source](https://www.mozilla.org/en-US/grants/)
* Il lavoro su **[OpenMRS](https://github.com/openmrs)** è finanziato dall'[Open Source Retreat of Stripe](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** ha ricevuto una sovvenzione dalla [Fondazione Sloan](https://sloan.org/programs/digital-technology)
* **[Python Software Foundation](https://www.python.org/psf/grants/)** offre sovvenzioni per lavori legati a Python

Per opzioni più dettagliate e casi di studio @nayafia [ha scritto una guida](https://github.com/nayafia/lemonade-stand) su come essere pagato per il lavoro open source. Diversi tipi di finanziamento richiedono competenze diverse, quindi considera i tuoi punti di forza per scoprire quale opzione funziona meglio per te.

## Costruire una causa per il sostegno finanziario

Che il tuo progetto sia una nuova idea o sia in circolazione da anni, dovresti aspettarti di dedicare molta attenzione all'identificazione del finanziatore target e alla presentazione di un caso convincente.

Sia che tu voglia pagare per il tuo tempo libero o raccogliere fondi per un progetto, devi essere in grado di rispondere alle seguenti domande.

### Impatto

Perchè è utile questo progetto? Perché piace così tanto ai tuoi utenti o potenziali utenti? Dove sarà tra cinque anni?

### Trazione

Cerca di raccogliere prove dell'importanza del tuo progetto, che si tratti di parametri, aneddoti o testimonianze. Ci sono aziende o persone importanti che utilizzano il tuo progetto in questo momento? In caso contrario, una persona di spicco lo ha approvato?

### Valore per il finanziatore

Ai finanziatori, siano essi il tuo datore di lavoro o una fondazione che concede sovvenzioni, vengono spesso offerte opportunità. Perché dovrebbero sostenere il tuo progetto rispetto a qualsiasi altra opzione? Come ne traggono beneficio personalmente?

### Utilizzo dei fondi

Cosa otterrete esattamente con il finanziamento proposto? Concentrarsi sulle tappe fondamentali o sui risultati finali del progetto piuttosto che sul pagamento di uno stipendio.

### Come riceverai i fondi

Il finanziatore ha dei requisiti di rimborso? Ad esempio, potrebbe essere necessario essere un'organizzazione senza scopo di lucro o avere uno sponsor fiscale senza scopo di lucro. O forse i fondi dovrebbero essere assegnati a un singolo appaltatore piuttosto che a un'organizzazione. Questi requisiti variano tra i finanziatori, quindi assicurati di fare le tue ricerche in anticipo.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  Per anni siamo stati la risorsa principale per le icone ottimizzate per i siti Web, con una community di oltre 20 milioni di persone e presenti su oltre 70 milioni di siti Web, incluso Whitehouse.gov. (...) La versione 4 risale a tre anni fa. La tecnologia web è cambiata molto da allora e, a dire il vero, Font Awesome è invecchiato. (...) Ecco perché stiamo introducendo Font Awesome 5. Stiamo modernizzando e riscrivendo i CSS e rifacendo ogni icona dall'alto verso il basso. Stiamo parlando di un design migliore, di una migliore coerenza e di una migliore leggibilità.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Sperimenta e non mollare

Raccogliere fondi non è facile, che tu sia un progetto open source, un'organizzazione no profit o una startup di software, e nella maggior parte dei casi richiede che tu sia creativo. Determinare come vuoi essere pagato, fare le tue ricerche e metterti nei panni del tuo finanziatore ti aiuterà a costruire un caso convincente per il finanziamento.
