---
lang: it
title: Trovare utenti per il tuo progetto
description: Aiuta il tuo progetto open source a crescere mettendolo nelle mani di utenti soddisfatti.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Diffondere la parola

Non esiste una regola che dice che devi pubblicizzare un progetto open source al momento del lancio. Ci sono molte buone ragioni per passare all'open source che non hanno nulla a che fare con la popolarità. Invece di sperare che altri trovino e utilizzino il tuo progetto open source, dovresti spargere la voce sul tuo duro lavoro!

## Trasmetti il ​​tuo messaggio

Prima di iniziare il lavoro vero e proprio di promozione del tuo progetto, devi essere in grado di spiegare cosa fa e perché è importante.

Cosa rende il tuo progetto diverso o interessante? Perché l'hai creato? Rispondere solo a queste domande ti aiuterà a comunicare l'importanza del tuo progetto.

Ricorda che le persone vengono coinvolte come utenti e alla fine diventano contributori perché il tuo progetto risolve loro un problema. Mentre pensi al messaggio e al valore del tuo progetto, prova a vederlo attraverso la lente di ciò che _utenti e contributori_ potrebbero desiderare.

Ad esempio, @robb utilizza esempi di codice per comunicare chiaramente perché il suo progetto, [Cartography](https://github.com/robb/Cartography), è utile:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Per un approfondimento sulla messaggistica, consulta l'esercizio ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) di Mozilla sullo sviluppo dei personaggi degli utenti.

## Aiuta le persone a trovare e seguire il tuo progetto

<aside markdown="1" class="pquote">
  Idealmente, hai bisogno di un URL "home" che puoi promuovere e indirizzare le persone al tuo progetto. Non devi preoccuparti di un modello fantasioso o addirittura di un nome di dominio, ma il tuo progetto ha bisogno di un punto focale.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["Come distribuire le informazioni sul tuo codice"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Aiuta le persone a trovare e ricordare il tuo progetto indirizzandole a un singolo spazio dei nomi.

**Avere un approccio chiaro per promuovere il tuo lavoro.** Un handle di Twitter, un URL GitHub o un canale IRC è un modo semplice per indirizzare le persone al tuo progetto. Questi punti vendita forniscono anche un luogo di ritrovo per la crescente comunità del tuo progetto.

Se ancora non vuoi creare output per il tuo progetto, promuovi il tuo account Twitter o GitHub in tutto ciò che fai. Promuovere il tuo Twitter o GitHub permetterà alle persone di sapere come contattarti o seguire il tuo lavoro. Se parli a una riunione o a un evento, assicurati che le informazioni di contatto siano incluse nella biografia o nelle diapositive.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Un errore che ho commesso in quei primi giorni (...) è stato non creare un account Twitter per il progetto. Twitter è un ottimo modo per mantenere le persone informate su un progetto e per esporre costantemente le persone alle informazioni sul progetto.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["Storia di Apache Storm e lezioni apprese"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Considera l'idea di creare un sito web per il tuo progetto.** Un sito web rende il tuo progetto più user-friendly e facile da navigare, soprattutto se abbinato a documentazione e tutorial chiari. Avere un sito web suggerisce anche che il tuo progetto è attivo, il che farà sentire il tuo pubblico più a suo agio nell'utilizzarlo. Fornisci esempi per dare alle persone idee su come utilizzare il tuo progetto.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), сco-creatore di Django, ha detto che il sito web è stato _"di gran lunga la cosa migliore che abbiamo fatto con Django nei primi giorni"_.

Se il tuo progetto è ospitato su GitHub, puoi utilizzare [GitHub Pages](https://pages.github.com/) per creare facilmente un sito web. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/) e [Middleman](https://middlemanapp.com/) sono [alcuni esempi](https://github.com/showcases/github-pages-examples) di siti Web eccellenti e completi.

![Pagina iniziale di Vagrant](/assets/images/finding-users/vagrant_homepage.png)

Ora che hai un annuncio sul tuo progetto e un modo semplice per consentire alle persone di trovarlo, usciamo e parliamo con il tuo pubblico!

## Vai dove si trova il pubblico del tuo progetto (online)

La sensibilizzazione online è un ottimo modo per condividere e spargere rapidamente la voce. Utilizzando i canali online, hai il potenziale per raggiungere un pubblico molto vasto.

Sfrutta le community e le piattaforme online esistenti per raggiungere il tuo pubblico. Se il tuo progetto open source è un progetto software, probabilmente puoi trovare il tuo pubblico in [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/) o [Quora](https://www.quora.com/). Trova i canali in cui ritieni che le persone trarranno maggiori benefici o saranno entusiaste del tuo lavoro.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Ogni programma ha funzionalità molto specifiche che solo una minoranza di utenti troverà utili. Non inviare spam a quante più persone possibile. Concentra invece i tuoi sforzi sulle comunità che trarranno beneficio dalla conoscenza del tuo progetto.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing per progetti open source"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Vedi se riesci a trovare modi per condividere il tuo progetto in modi appropriati:

* **Conosci progetti e comunità open source rilevanti.** A volte non è necessario pubblicizzare direttamente il tuo progetto. Se il tuo progetto è perfetto per i data scientist che utilizzano Python, consulta la community di data science di Python. Man mano che le persone ti conosceranno, ci saranno opportunità naturali per parlare e condividere il tuo lavoro.
* **Trova persone che affrontano il problema risolto dal tuo progetto.** Cerca nei forum correlati le persone che rientrano nel pubblico target del tuo progetto. Rispondi alla loro domanda e trova un modo discreto, se appropriato, per presentare il tuo progetto come soluzione.
* **Chiedi feedback.** Presenta te stesso e il tuo lavoro a un pubblico che lo troverà pertinente e interessante. Sii specifico su chi ritieni trarrà beneficio dal tuo progetto. Prova a completare la frase: _"Penso che il mio progetto aiuterà davvero X persone che stanno cercando di fare Y_". Ascolta e rispondi al feedback degli altri invece di limitarti a promuovere il tuo lavoro.

In generale, concentrati sull'aiutare gli altri prima di chiedere qualcosa in cambio. Dato che chiunque può facilmente pubblicizzare un progetto online, ci sarà molto fermento. Per distinguerti dalla massa, dai alle persone un contesto su chi sei, non solo cosa vuoi.

Se nessuno presta attenzione o risponde al tuo contatto iniziale, non scoraggiarti! La maggior parte dei lanci di progetti sono un processo iterativo che può richiedere mesi o anni. Se non ricevi risposta la prima volta, prova una tattica diversa o cerca prima modi per aggiungere valore al lavoro degli altri. Promuovere e lanciare il tuo progetto richiede tempo e dedizione.

## Vai dove si trova il pubblico del tuo progetto (offline)

![Discorso pubblico](/assets/images/finding-users/public_speaking.jpg)

Gli eventi offline sono un modo popolare per promuovere nuovi progetti al pubblico. Sono un ottimo modo per raggiungere un pubblico coinvolto e creare connessioni umane più profonde, soprattutto se sei interessato a raggiungere gli sviluppatori.

Se sei [nuovo nel parlare in pubblico](https://Speaking.io/), inizia trovando un incontro locale correlato alla lingua o all'ecosistema del tuo progetto.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Ero piuttosto nervoso andando a PyCon. Stavo tenendo una conferenza, avrei incontrato solo poche persone lì, sono andato per un'intera settimana. (...) Non avrei dovuto preoccuparmi però. PyCon è stato straordinariamente fantastico! (...) Tutti erano incredibilmente cordiali e socievoli, tanto che raramente avevo il tempo di non parlare con la gente!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["Come ho imparato a smettere di preoccuparmi e ad amare PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Se non hai mai parlato a un evento prima, è del tutto normale sentirsi nervoso! Ricorda che il tuo pubblico è lì perché vuole davvero conoscere il tuo lavoro.

Mentre scrivi il tuo discorso, concentrati su ciò che il tuo pubblico troverà interessante e da cui trarrà beneficio. Mantieni il tuo linguaggio amichevole e accessibile. Sorridi, respira e divertiti.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Quando inizi a scrivere il tuo discorso, indipendentemente dall'argomento, può essere utile vedere il tuo discorso come una storia da raccontare alla gente.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["Come preparare e scrivere un discorso di conferenza tecnica"](https://web.archive.org/web/20201128162836/http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Quando ti senti pronto, considera di parlare a una conferenza per promuovere il tuo progetto. Le conferenze possono aiutarti a raggiungere più persone, a volte da tutto il mondo.

Cerca conferenze specifiche per la tua lingua o ecosistema. Prima di inviare il tuo discorso, fai ricerche sulla conferenza per adattare il tuo discorso ai tuoi partecipanti e aumentare le tue possibilità di essere accettato a parlare alla conferenza. Spesso puoi farti un'idea del tuo pubblico guardando i relatori della conferenza.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Ho scritto molto gentilmente al personale di JSConf e ho chiesto loro di darmi un posto dove avrei potuto presentarlo al JSConf EU. (...) Avevo una grandissima paura nel presentare questa cosa su cui stavo lavorando da sei mesi. (...) Per tutto il tempo ho pensato, oh mio Dio. Cosa sto facendo qui?
  <p markdown="1" class="pquote-credit">
— @ry, ["История на Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Costruisci una reputazione

Oltre alle strategie sopra descritte, il modo migliore per invitare le persone a condividere e contribuire al tuo progetto è condividere e contribuire ai loro progetti.

Aiutare i nuovi arrivati, condividere risorse e contribuire in modo ponderato ai progetti di altre persone ti aiuterà a costruire una reputazione positiva. Essere un membro attivo della comunità open source aiuterà le persone a trovare un contesto per il tuo lavoro e ad essere più propense a prestare attenzione e a condividere il tuo progetto. Lo sviluppo di collegamenti con altri progetti open source può anche portare a partenariati formali.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  L'unico motivo per cui urllib3 è oggi la libreria Python di terze parti più popolare è perché fa parte delle richieste.
  <p markdown="1" class="pquote-credit">
— @shazow, ["Come far prosperare il tuo progetto open source"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Non è mai troppo presto o troppo tardi per iniziare a costruire la tua reputazione. Anche se hai già avviato il tuo progetto, continua a cercare modi per aiutare gli altri.

Non esiste una soluzione immediata per creare un pubblico. Guadagnarsi la fiducia e il rispetto degli altri richiede tempo e costruire la propria reputazione non finisce mai.

## Continuare!

Può volerci molto tempo prima che le persone notino il tuo progetto open source. Questo è buono! Alcuni dei progetti più popolari oggi hanno impiegato anni per raggiungere livelli elevati di attività. Concentrati sulla costruzione di relazioni invece di sperare che il tuo progetto ottenga spontaneamente popolarità. Sii paziente e continua a condividere il tuo lavoro con chi lo apprezza.
