---
lang: it
title: Il tuo codice di condotta
description: Facilitare un comportamento comunitario sano e costruttivo adottando e applicando un codice di condotta.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Perché ho bisogno di un codice di condotta?

Un codice di condotta è un documento che definisce le aspettative comportamentali dei partecipanti al tuo progetto. L'adozione e l'applicazione di un codice di condotta può contribuire a creare un'atmosfera sociale positiva per la tua comunità.

I codici di condotta aiutano a proteggere non solo i tuoi partecipanti ma anche te stesso. Se stai portando avanti un progetto, potresti scoprire che l'atteggiamento improduttivo degli altri partecipanti può farti sentire svuotato o insoddisfatto del tuo lavoro nel tempo.

Un Codice di condotta ti consente di facilitare un comportamento sano e costruttivo nella comunità. Essere proattivi riduce le probabilità che tu o gli altri vi stanchiate del vostro progetto e vi aiuta ad agire quando qualcuno fa qualcosa con cui non siete d'accordo.

## Stabilire un codice di condotta

Cerca di creare un codice di condotta il prima possibile: idealmente quando crei per la prima volta il tuo progetto.

Oltre a comunicare le vostre aspettative, il codice di condotta descrive quanto segue:

* Dove entra in vigore il codice di condotta _(solo per problemi e pull request o attività della community come eventi?)_
* A chi si applica il codice di condotta _(membri della comunità e sostenitori, ma per quanto riguarda gli sponsor?)_
* Cosa succede se qualcuno infrange il codice di condotta
* Come qualcuno può segnalare violazioni

Usa la tecnica precedente dove puoi. [Accordo dei contributori](https://contributor-covenant.org/) è un codice di comportamento utilizzato da oltre 40.000 progetti open source, inclusi Kubernetes, Rails e Swift.

[Il codice di condotta di Django](https://www.djangoproject.com/conduct/) e [Il codice di condotta dei cittadini](https://web.archive.org/web/20200330154000/http://citizencodeofconduct.org/) sono due buoni esempi di codice di condotta.

Inserisci un file CODE_OF_CONDUCT nella directory principale del tuo progetto e rendilo visibile alla tua comunità collegandolo dal tuo file CONTRIBUTING o README.

## Decidi come applicherai il tuo codice di condotta

<aside markdown="1" class="pquote">
  Un codice di condotta non applicato (o inapplicabile) è peggio di nessun codice di condotta: invia il messaggio che i valori del codice di condotta non sono realmente importanti o rispettati nella tua comunità.
  <p markdown="1" class="pquote-credit">
— [Iniziativa di Ada](https://webcache.googleusercontent.com/search?q=cache:YfqdTk5H9ikJ:https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community)
  </p>
</aside>

È necessario spiegare come verrà applicato il codice di condotta **_prima_** di una violazione. Ci sono diversi motivi per farlo:

* Dimostra che sei seriamente intenzionato ad agire quando necessario.

* La tua comunità si sentirà più sicura che i reclami vengano effettivamente esaminati.

* Assicurerai alla tua comunità che il processo di revisione è giusto e trasparente nel caso in cui si trovassero indagati per una violazione.

Dovresti fornire alle persone un modo personale (ad esempio un indirizzo e-mail) per segnalare una violazione del codice di condotta e spiegare chi riceve tale segnalazione. Potrebbe trattarsi di un manutentore, di un gruppo di manutentori o di un gruppo di lavoro sul codice di condotta.

Ricorda che qualcuno può chiedere di segnalare una violazione a una persona che riceve queste segnalazioni. In questo caso, date loro la possibilità di segnalare le violazioni a qualcun altro. Ad esempio, @ctb e @mr-c [spiegano il loro progetto](https://github.com/dib-lab/khmer/blob/HEAD/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> Casi di abuso, molestie o comportamenti altrimenti inaccettabili possono essere segnalati inviando un'e-mail a **khmer-project@idyll.org** solo a C. Titus Brown e Michael R. Crusoe. Per segnalare un problema con uno di questi, inviare un'e-mail a **Judi Brown Clarke, Ph.D.** Direttore della Diversità presso il BEACON Center for the Study of Evolution in Action, NSF Science and Technology Center.*

Per trovare ispirazione, consulta il [manuale di applicazione delle norme](https://www.djangoproject.com/conduct/enforcement-manual/) di Django (anche se potresti non aver bisogno di qualcosa di così completo, a seconda delle dimensioni del tuo progetto).

## Applicare il codice di condotta

A volte, nonostante i tuoi migliori sforzi, qualcuno fa qualcosa che viola questo codice. Esistono diversi modi per affrontare un comportamento negativo o dannoso quando si verifica.

### Raccogli informazioni sulla situazione

Considera la voce di ogni membro della comunità importante quanto la tua. Se ricevi una segnalazione secondo cui qualcuno ha violato il codice di condotta, prendila sul serio e indaga sulla questione, anche se non corrisponde alla tua esperienza con quella persona. Ciò segnala alla tua comunità che apprezzi la loro prospettiva e ti fidi del loro giudizio.

Il membro della comunità in questione potrebbe essere un recidivo che mette costantemente a disagio gli altri, o potrebbe aver detto o fatto qualcosa solo una volta. In entrambi i casi, possono costituire motivo di azione a seconda del contesto.

Prima di rispondere, concediti il ​​tempo di capire cosa è successo. Leggi i commenti e le conversazioni passate della persona per capire meglio chi è e perché potrebbe essersi comportato in quel modo. Prova a raccogliere punti di vista diversi dal tuo su questa persona e sul suo comportamento.

<aside markdown="1" class="pquote">
  Non entrare in una discussione. Non esitare ad affrontare il comportamento di qualcun altro prima di aver finito di esaminare la questione. Concentrati su ciò di cui hai bisogno.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["Quindi avete una politica. E adesso?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Intraprendi le azioni appropriate

Una volta raccolte ed elaborate informazioni sufficienti, dovrai decidere cosa fare. Mentre consideri i passaggi successivi, ricorda che il tuo obiettivo come moderatore è promuovere un ambiente sicuro, rispettoso e collaborativo. Considera non solo come gestire la situazione in questione, ma anche come la tua risposta influenzerà il comportamento e le aspettative del resto della tua comunità in futuro.

Quando qualcuno segnala una violazione del codice di condotta, è compito tuo, non suo, occupartene. A volte un giornalista rivela informazioni che mettono a grave rischio la sua carriera, reputazione o incolumità fisica. Costringerli ad affrontare il loro aggressore può mettere il giornalista in una posizione compromettente. È necessario mantenere una comunicazione diretta con la persona in questione, a meno che chi ha segnalato non richieda espressamente il contrario.

Esistono diversi modi per rispondere a una violazione del codice di condotta:

* **Dai alla persona in questione un avvertimento pubblico** e spiega come il suo comportamento ha influenzato negativamente gli altri, preferibilmente nel canale in cui è successo. Quando possibile, la comunicazione pubblica comunica al resto della comunità che si prende sul serio il codice di condotta. Sii gentile ma fermo nella tua comunicazione.

* **Contatta di persona la persona in questione** per spiegare in che modo il suo comportamento ha influenzato negativamente gli altri. Potresti voler utilizzare un canale di comunicazione privato se la situazione coinvolge informazioni personali sensibili. Se stai comunicando con qualcuno in privato, è una buona idea mettere in copia coloro che per primi hanno segnalato la situazione in modo che sappiano che hai preso provvedimenti. Chiedere il consenso all'informatore prima di inviarlo in CC.

A volte non è possibile raggiungere alcuna soluzione. La persona in questione può diventare aggressiva o ostile quando confrontata o non cambiare il proprio comportamento. In questa situazione, potresti prendere in considerazione l'idea di intraprendere azioni più drastiche. Per esempio:

* **Espulsione della persona in questione** dal progetto, imposta tramite un'interdizione temporanea dalla partecipazione a qualsiasi aspetto del progetto

* **Permanente** banna la persona dal progetto

L'esclusione dei membri non dovrebbe essere presa alla leggera e rappresenta una divergenza di opinioni permanente e inconciliabile. Dovresti adottare queste misure solo quando è chiaro che non è possibile raggiungere una soluzione.

## Le tue responsabilità come manutentore

Un codice di condotta non è una legge applicata arbitrariamente. Tu sei il garante del codice di condotta ed è tua responsabilità seguire le regole stabilite dal codice di condotta.

In qualità di manutentore, stabilisci le linee guida per la tua comunità e applichi tali linee guida secondo le regole stabilite nel tuo codice di condotta. Ciò significa prendere sul serio ogni segnalazione di violazione del codice di condotta. Al giornalista è dovuta un'analisi approfondita e corretta della sua denuncia. Se ritieni che il comportamento segnalato non costituisca una violazione, chiariscilo e spiega perché non intendi intraprendere alcuna azione in merito. Ciò che fanno dipende da loro: tollerare il comportamento con cui hanno avuto problemi o smettere di partecipare alla comunità.

Segnalare un comportamento che _tecnicamente_ non viola il codice di condotta può comunque indicare che c'è un problema nella tua comunità e dovresti indagare su quel potenziale problema e agire di conseguenza. Ciò potrebbe comportare la revisione del codice di condotta per chiarire quale sia il comportamento accettabile e/o parlare alla persona il cui comportamento è stato segnalato e dirle che, sebbene non abbia violato il codice di condotta, sta aggirando il limite di ciò che ci si aspetta e assicurarsi che i partecipanti si sentano a disagio.

In definitiva, come sostenitore, definisci e applichi gli standard di comportamento accettabile. Hai la capacità di plasmare i valori della comunità del progetto e i partecipanti si aspettano che tu applichi tali valori in modo giusto ed equo.

## Incoraggia il comportamento che vuoi vedere nel mondo 🌎

Quando un progetto appare ostile o inospitale, anche se si tratta di una sola persona il cui comportamento è tollerato dagli altri, rischi di perdere molti altri contributori, alcuni dei quali potresti non incontrare nemmeno. Non è sempre facile adottare o far rispettare un codice di condotta, ma promuovere un ambiente accogliente aiuterà la tua comunità a crescere.
