---
lang: it
title: Costruire comunità accoglienti
description: Costruire una comunità che incoraggi le persone a utilizzare, contribuire ed educare con il tuo progetto
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Prepara il tuo progetto per il successo

Hai appena lanciato il tuo progetto, stai spargendo la voce e le persone ti seguono. Brillante! Ora, come fai a farli restare?

Una comunità accogliente è un investimento sul futuro del tuo progetto e della tua reputazione. Se il tuo progetto sta appena iniziando a vedere i primi contributi, inizia offrendo ai primi contributori un'esperienza positiva e rendendo facile per loro continuare a tornare.

### Fai sentire le persone benvenute

Un modo di pensare alla community del tuo progetto è attraverso quello che @MikeMcQuaid chiama [funnel del collaboratore](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![Canalizzazione del collaboratore](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Mentre costruisci la tua community, considera come qualcuno in cima alla canalizzazione (un potenziale utente) potrebbe teoricamente scendere verso il basso (un sostenitore attivo). Il tuo obiettivo è ridurre l'attrito in ogni fase dell'esperienza associata. Quando le persone ottengono vittorie facili, saranno motivate a fare di più.

Inizia con la tua documentazione:

* **Semplifica le cose per coloro che hanno bisogno di utilizzare il progetto.** [Documento README intuitivo](../starting-a-project/#scrivi-readme) e chiari esempi di codice lo renderanno facile da usare. È un inizio facile per chiunque si imbatta nel tuo progetto.
* **Spiega chiaramente come contribuire** utilizzando [CONTRIBUTING file](../starting-a-project/#scrivi-le-linee-guida-per-il-tuo-contributo) e mantieni aggiornati i tuoi problemi.
* **Buone prime edizioni**: per aiutare i nuovi contributori a iniziare, pensa chiaramente a [sottolineare gli argomenti che sono abbastanza semplici da poter essere gestiti da un principiante](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). GitHub mostrerà quindi questi problemi in vari punti della piattaforma, aumentando i contributi utili e riducendo la pressione degli utenti che affrontano questioni troppo difficili per il loro livello.

[Sondaggio open source GitHub 2017](http://opensourcesurvey.org/2017/) ha dimostrato che la documentazione incompleta o confusa è il problema più grande per gli utenti open source. Una buona documentazione invita le persone a interagire con il tuo progetto. Alla fine, qualcuno aprirà un problema o una richiesta. Usa queste interazioni come opportunità per spostarle lungo la canalizzazione.

* **Quando qualcuno di nuovo si unisce al tuo progetto, ringrazialo per il suo interesse!** Basta un'esperienza negativa per far sì che qualcuno non voglia più tornare.
* **Sii reattivo.** Se non rispondi alla loro domanda per un mese, è probabile che si siano già dimenticati del tuo progetto.
* **Sii di mentalità aperta riguardo ai tipi di contributi che accetti.** Molti contributori iniziano segnalando un bug o apportando una piccola correzione. Ci sono [molti modi per contribuire](../how-to-contribute/#cosa-significa-contribuire) ad un progetto. Lascia che le persone aiutino nel modo in cui vogliono aiutare.
* **Se c'è un contributo con cui non sei d'accordo,** ringrazialo per la sua idea e [spiegate perchè](../best-practices/#impara-a-dire-di-no) non soddisfa lo scopo del progetto, con un collegamento alla documentazione pertinente, se disponibile.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Contribuire all'open source è più facile per alcuni che per altri. C’è una grande paura di essere accusati di non aver fatto qualcosa di giusto o semplicemente di non adattarsi. (...) Dando ai contributori un posto dove contribuire con competenze tecniche molto basse (documentazione, markup di contenuti web, ecc.), puoi ridurre notevolmente queste preoccupazioni.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Crescere una base di contributori nel moderno open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

La maggior parte dei contributori open source sono "collaboratori occasionali": persone che contribuiscono a un progetto solo occasionalmente. Un collaboratore occasionale potrebbe non avere il tempo di familiarizzare completamente con il tuo progetto, quindi il tuo compito è facilitare il suo contributo.

Incoraggiare altri contributori è anche un investimento su te stesso. Quando permetti ai tuoi più grandi fan di lavorare sul lavoro che li appassiona, c'è meno pressione nel dover fare tutto da solo.

### Documenta tutto

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Sei mai stato a un evento (tecnologico) in cui non conosci nessuno, ma tutti gli altri sembrano essere in gruppo a chiacchierare come vecchi amici? (...) Ora immagina di voler contribuire ad un progetto open source, ma non capisci perché e come ciò avvenga.
  <p markdown="1" class="pquote-credit">
— @janl, ["Open source sostenibile"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Quando si inizia un nuovo progetto, può sembrare naturale mantenere segreto il proprio lavoro. Ma i progetti open source prosperano quando documenti pubblicamente il tuo processo.

Quando documenti le cose, più persone possono essere coinvolte in ogni fase del processo. Potresti ricevere aiuto per qualcosa di cui non sapevi nemmeno di aver bisogno.

Annotare le cose significa molto più che una semplice documentazione tecnica. Ogni volta che senti il ​​bisogno di scrivere qualcosa o discutere del tuo lavoro in privato, chiediti se puoi renderlo pubblico.

Sii trasparente riguardo alla roadmap del tuo progetto, ai tipi di contributi che stai cercando, a come vengono considerati i contributi o al motivo per cui hai preso determinate decisioni.

Se noti che molti utenti hanno lo stesso problema, documenta le risposte nel README.

Per le riunioni, valuta la possibilità di pubblicare i tuoi appunti o i tuoi appunti in un thread correlato. Il feedback che otterrai da questo livello di trasparenza potrebbe sorprenderti.

Documentare tutto vale anche per il lavoro che svolgi. Se stai lavorando a un aggiornamento importante del tuo progetto, inseriscilo in una richiesta pull e contrassegnalo come work in progress (WIP). In questo modo, altre persone possono sentirsi coinvolte fin dall'inizio nel processo.

### Sii reattivo

Mentre [promuovi il tuo progetto](../finding-users), le persone avranno feedback su di te. Potrebbero avere domande su come funzionano le cose o aver bisogno di aiuto per iniziare.

Cerca di essere reattivo quando qualcuno segnala un problema, invia una richiesta pull o pone una domanda sul tuo progetto. Quando rispondi rapidamente, le persone si sentiranno parte di un dialogo e saranno più entusiaste di partecipare.

Anche se non puoi esaminare immediatamente la richiesta, confermarla tempestivamente aiuta ad aumentare il coinvolgimento. Ecco come @tdreyno ha risposto a una richiesta pull su [Middleman](https://github.com/middleman/middleman/pull/1466):

![Middleman richiesta di download](/assets/images/building-community/middleman_pr.png)

[Questo è ciò che ha scoperto uno studio Mozilla](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) i contributori che hanno ricevuto revisioni del codice entro 48 ore hanno avuto un tasso di rendimento e ricontribuzione molto più elevato.

Le discussioni sul tuo progetto potrebbero svolgersi anche altrove sul Web, come Stack Overflow, Twitter o Reddit. Puoi impostare le notifiche in alcuni di questi luoghi in modo da ricevere una notifica quando qualcuno menziona il tuo progetto.

### Offri alla tua comunità un luogo in cui riunirsi

Ci sono due ragioni per dare alla tua comunità un luogo in cui riunirsi.

Il primo motivo è per loro. Aiuta le persone a conoscersi. Le persone con interessi comuni vorranno inevitabilmente un posto dove parlarne. E quando la comunicazione è pubblica e accessibile, chiunque può leggere gli archivi del passato per imparare e partecipare.

Il secondo motivo è per te. Se non offri alle persone un luogo pubblico in cui parlare del tuo progetto, probabilmente ti contatteranno direttamente. All'inizio può sembrare abbastanza semplice rispondere ai messaggi privati ​​"solo per questa volta". Ma col tempo, soprattutto se il tuo progetto diventa popolare, ti sentirai esausto. Resisti alla tentazione di comunicare in privato con le persone riguardo al tuo progetto. Indirizzali invece a un canale pubblico specifico.

La comunicazione pubblica può essere semplice come invitare le persone ad aprire un problema invece di inviarti direttamente un'e-mail o commentare sul tuo blog. Puoi anche impostare una mailing list o creare un account Twitter, Slack o un canale IRC affinché le persone possano parlare del tuo progetto. Oppure prova tutto quanto sopra!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) dedica ore di lavoro ogni due settimane per aiutare i membri della comunità:

> Kops inoltre dedica del tempo ogni settimana per offrire aiuto e guida alla comunità. I manutentori di Kops hanno concordato di dedicare del tempo specificatamente dedicato al lavoro con i nuovi arrivati, aiutando con le PR e discutendo le nuove funzionalità.

Eccezioni notevoli alla comunicazione pubblica sono: 1) questioni di sicurezza e 2) violazioni sensibili del codice di condotta. Dovresti sempre avere la possibilità che le persone possano segnalare questi problemi di persona. Se non desideri utilizzare la tua email personale, imposta un indirizzo email dedicato.

## Fai crescere la tua comunità

Le comunità sono estremamente forti. Questo potere può essere una benedizione o una maledizione, a seconda di come lo eserciti. Man mano che la community del tuo progetto cresce, ci sono modi per aiutarla a diventare una forza di costruzione, non di demolizione.

### Non tollerare i cattivi attori

Qualsiasi progetto popolare attirerà inevitabilmente persone che danneggiano, non aiutano, la tua comunità. Potrebbero avviare dibattiti non necessari, discutere su aspetti banali o fare il prepotente con gli altri.

Fai del tuo meglio per adottare una politica di tolleranza zero nei confronti di questo tipo di persone. Se lasciate senza controllo, le persone negative metteranno a disagio le altre persone nella tua comunità. Potrebbero anche andarsene.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  La verità è che avere una comunità solidale è fondamentale. Non avrei mai potuto svolgere questo lavoro senza l'aiuto dei miei colleghi, di amichevoli sconosciuti su Internet e di canali IRC chiacchieroni. (...) Non accontentarti di meno. Non accontentarti degli sciocchi.
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["Come gestire un progetto FOSS"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Discussioni regolari su aspetti banali del tuo progetto distraggono gli altri, te compreso, dal concentrarsi su compiti importanti. Le nuove persone che arrivano al tuo progetto potrebbero vedere queste conversazioni e non voler partecipare.

Quando vedi che si verifica un comportamento negativo, fai un'osservazione pubblica al riguardo. Spiegare in tono amichevole perché tale comportamento non è accettabile. Se il problema persiste, potrebbe essere necessario [chiedergli di andarsene](../code-of-conduct/#le-tue-responsabilità-come-manutentore). Il tuo [codice di condotta](../code-of-conduct/) può essere una guida costruttiva per queste conversazioni.

### Incontra i contributori ovunque si trovino

Una buona documentazione diventa sempre più importante man mano che la tua comunità cresce. I contributori occasionali che altrimenti potrebbero non avere familiarità con il tuo progetto leggono la tua documentazione per ottenere rapidamente il contesto di cui hanno bisogno.

Nel tuo file CONTRIBUTING, indica esplicitamente ai nuovi contributori come iniziare. Potresti anche voler creare una sezione speciale per questo scopo. [Django](https://github.com/django/django), ad esempio, ha una pagina di destinazione speciale per accogliere i nuovi contributori.

![Django pagin acon i nuovi contributori](/assets/images/building-community/django_new_contributors.png)

Nella coda degli argomenti, contrassegna i bug appropriati per i diversi tipi di contributori: ad esempio [_"per principianti"_](https://kentcdodds.com/blog/first-timers-only), _"buon primo argomento"_ o _"documentazione"_. [Questi appunti](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) rendi facile per qualcuno che non conosce il tuo progetto scansionare rapidamente i tuoi argomenti e iniziare.

Infine, usa la tua documentazione per far sentire le persone benvenute in ogni fase del processo.

Non interagirai mai con la maggior parte delle persone che saranno coinvolte nel tuo progetto. Potrebbero esserci contributi che non hai ricevuto perché qualcuno si è sentito intimidito o non sapeva da dove cominciare. Anche poche parole gentili possono evitare che qualcuno lasci deluso il tuo progetto.

Ad esempio, ecco come [Rubinius](https://github.com/rubinius/rubinius/) ha iniziato [la sua guida che contribuisce](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> Vogliamo iniziare ringraziandoti per aver utilizzato Rubinius. Questo progetto è un lavoro d'amore e apprezziamo tutti gli utenti che rilevano bug, apportano miglioramenti alle prestazioni e aiutano con la documentazione. Ogni contributo conta, quindi grazie per aver partecipato. Tenendo questo a mente, ecco alcune linee guida che ti chiediamo di seguire per poter risolvere con successo il tuo problema.

### Condividi la proprietà del tuo progetto

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  I tuoi leader avranno opinioni diverse, come dovrebbero fare tutte le comunità sane! Tuttavia, è necessario adottare misure per garantire che la voce più forte non sempre prevalga, logorando le persone, e che le voci meno importanti e minoritarie siano ascoltate.
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["Ciò che rende una buona comunità?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Le persone sono entusiaste di contribuire ai progetti quando sentono un senso di appartenenza. Ciò non significa che devi stravolgere la visione del tuo progetto o accettare input che non desideri. Ma più riconosci gli altri, più rimarranno presenti.

Vedi se riesci a trovare modi per condividere il più possibile la proprietà con la tua comunità. Ecco alcune idee:

* **Evita di correggere bug facili (non critici).** Usali invece come opportunità per reclutare nuovi contributori o fare da mentore a qualcuno che vorrebbe contribuire. All'inizio può sembrare innaturale, ma il tuo investimento verrà ripagato nel tempo. Ad esempio, @michaeljoseph ha chiesto a un collaboratore di inviare una richiesta pull per il problema [Cookiecutter](https://github.com/audreyr/cookiecutter) di seguito invece di risolverlo da solo.

![Cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Avvia un file CONTRIBUTORI o AUTORI nel tuo progetto** che elenca tutti coloro che hanno contribuito al tuo progetto come [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md).

* Se hai una community numerosa, **invia una newsletter o scrivi un post sul blog** ringraziando i contributori. [This Week in Rust](https://this-week-in-rust.org/) di Rust e [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) di Hood sono due ottimi esempi.

* **Concedi l'accesso al commit a ogni collaboratore.** @felixge ha scoperto che rendeva le persone [più entusiaste di migliorare le proprie soluzioni](https://felixge.de/2013/03/11/the-pull-request-hack.html) e ha anche trovato nuovi manutentori per progetti su cui non lavorava da un po'.

* Se il tuo progetto è su GitHub, **sposta il tuo progetto dal tuo account personale a [Organizzazione](https://help.github.com/articles/creating-a-new-organization-account/)** e aggiungilo a almeno un amministratore di backup. Le organizzazioni facilitano il lavoro di progetto con collaboratori esterni.

La realtà è che [la maggior parte dei progetti ha solo](https://peerj.com/preprints/1233/) uno o due manutentori che svolgono la maggior parte del lavoro. Più grande è il tuo progetto e la tua comunità, più facile sarà trovare aiuto.

Anche se potresti non trovare sempre qualcuno che risponda alla chiamata, diffondere il segnale aumenta le possibilità che altre persone vengano coinvolte. E prima inizi, prima le persone potranno aiutarti.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[Nel tuo\] miglior interesse è reclutare collaboratori che si divertano e siano capaci di fare cose che tu non sei. Ti piace programmare ma non rispondi alle domande? Quindi identifica le persone nella tua comunità che lo fanno e consenti loro di farlo.
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Comunità accoglienti"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Risoluzione dei conflitti

Nelle prime fasi del tuo progetto, prendere decisioni importanti è facile. Quando vuoi fare qualcosa, fallo e basta.

Man mano che il tuo progetto diventa più popolare, sempre più persone saranno interessate alle decisioni che prendi. Anche se non hai una grande comunità di contributori, se il tuo progetto ha molti utenti, troverai persone che valutano soluzioni o sollevano i propri problemi.

Nella maggior parte dei casi, se hai coltivato una comunità amichevole e rispettosa e hai documentato apertamente i tuoi processi, la tua comunità dovrebbe essere in grado di trovare una soluzione. Ma a volte ti imbatti in un problema un po' più difficile da risolvere.

### Stabilisci lo standard di civiltà

Quando la tua comunità è alle prese con una questione difficile, il morale può risollevarsi. Le persone potrebbero arrabbiarsi o frustrarsi e prendersela con gli altri o con te.

Il tuo compito come sostenitore è evitare che queste situazioni peggiorino. Anche se hai una forte opinione sulla questione, prova ad assumere la posizione di moderatore o facilitatore invece di buttarti nella mischia e promuovere le tue opinioni. Se qualcuno è scortese o monopolizza la conversazione, [agisci immediatamente](../building-community/#non-tollerare-i-cattivi-attori) per mantenere la discussione civile e produttiva.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  Essendo un progetto di supporto, è estremamente importante trattare i tuoi contributori con rispetto. Spesso prendono quello che dici in modo molto personale.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Sii cordiale o vai per la tua strada"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Altre persone si rivolgono a te per avere una guida. Dai il buon esempio. Puoi ancora esprimere frustrazione, infelicità o preoccupazione, ma fallo con calma.

Mantenere la calma non è facile, ma mostrare leadership migliora la salute della tua comunità. Internet ti ringrazia.

### Tratta il tuo README come una costituzione

Il tuo README è [più di un semplice insieme di istruzioni](../starting-a-project/#scrivi-readme). È anche un luogo in cui parlare dei tuoi obiettivi, della visione del prodotto e della tabella di marcia. Se le persone sono troppo concentrate nel discutere i meriti di una particolare funzionalità, potrebbe essere utile rivisitare il tuo README e parlare della visione più elevata del tuo progetto. Concentrarsi sul README spersonalizza anche la conversazione in modo da poter avere una discussione costruttiva.

### Concentrati sul viaggio, non sulla destinazione

Alcuni progetti utilizzano un processo di voto per prendere decisioni importanti. Anche se a prima vista ragionevole, il voto enfatizza il raggiungimento di una "risposta" piuttosto che l'ascolto e la considerazione delle preoccupazioni degli altri.

Il voto può diventare politico quando i membri della comunità si sentono spinti a fare favori o a votare in un certo modo. Non tutti votano, siano essi [la maggioranza silenziosa](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) nella tua comunità o tra gli utenti attuali che non sapevano che fosse in corso una votazione.

A volte è richiesto un voto di parità. Tuttavia, per quanto puoi, enfatizza ["la ricerca del consenso"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making), piuttosto che consenso.

In un processo di ricerca del consenso, i membri della comunità discutono le preoccupazioni chiave finché non sentono di essere stati adeguatamente ascoltati. Quando rimangono solo preoccupazioni secondarie, la comunità va avanti. La ricerca del consenso riconosce che una comunità potrebbe non essere in grado di arrivare a una risposta perfetta. Invece, dà priorità all'ascolto e alla discussione.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  ЧParte del motivo per cui non esiste un sistema di voto per gli argomenti Atom è che il team Atom non seguirà un sistema di voto in tutti i casi. A volte dobbiamo scegliere ciò che riteniamo giusto, anche se non è popolare. (...) Ciò che posso offrire e mi impegno a fare... è che il mio lavoro è ascoltare la comunità.
  <p markdown="1" class="pquote-credit">
— @lee-dohm sul processo decisionale di Atom
  </p>
</aside>

Anche se in realtà non adotti un processo di ricerca del consenso, come progetto di supporto è importante che le persone sappiano che stai ascoltando. Far sì che le altre persone si sentano ascoltate e impegnate a risolvere le loro preoccupazioni è molto utile per allentare la tensione in situazioni delicate. Quindi segui le tue parole con l'azione.

Non affrettarti a prendere una decisione per il gusto di prendere una decisione. Assicurati che tutti si sentano ascoltati e che tutte le informazioni siano condivise prima di passare a una decisione.

### Mantieni la conversazione focalizzata sull'azione

La discussione è importante, ma esiste una differenza tra conversazioni produttive e improduttive.

Incoraggiare la discussione fintanto che si muove attivamente verso la risoluzione. Se è chiaro che la conversazione sta morendo o sta andando fuori tema, che il fastidio sta diventando personale o che le persone litigano su dettagli minori, è ora di chiuderla.

Consentire che queste conversazioni continuino non è solo dannoso per il problema in questione, ma anche per la salute della tua comunità. Invia il messaggio che questo tipo di conversazione è consentito o addirittura incoraggiato e potrebbe scoraggiare le persone dal sollevare o risolvere problemi futuri.

Per ogni punto sollevato da te o da altri, chiediti: "In che modo questo ci avvicina a una soluzione?"_

Se la conversazione inizia a sgretolarsi, chiedi al gruppo _"Quali passi dovremmo intraprendere dopo?"_ per reindirizzare la conversazione.

Se la conversazione non sta chiaramente andando da nessuna parte, non c'è alcuna azione chiara da intraprendere o l'azione appropriata è già stata intrapresa, chiudi il problema e spiega perché l'hai chiuso.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Rendere utile un thread senza essere invadente è un'arte. Dire semplicemente alle persone di smettere di sprecare il loro tempo o chiedere loro di non postare a meno che non abbiano qualcosa di costruttivo da dire non funzionerà. (...) Bisogna invece offrire le condizioni per ulteriori progressi: dare alle persone una rotta, un percorso da seguire che porti ai risultati desiderati, ma senza dare l'impressione di dettare comportamenti.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Produzione OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Scegli saggiamente le tue battaglie

Il contesto è importante. Considera chi partecipa alla conversazione e come rappresenta il resto della comunità.

Tutti nella comunità sono sconvolti o addirittura preoccupati per questo? Oppure è un piantagrane solitario? Ricorda di considerare i membri silenziosi della tua comunità, non solo le voci attive.

Se il problema non rappresenta le esigenze più ampie della tua comunità, potresti dover semplicemente accogliere le preoccupazioni di alcune persone. Se si tratta di un problema ricorrente senza una soluzione chiara, rimandali alle discussioni precedenti sull'argomento e chiudi l'argomento.

### Definire il criterio di equilibrio comunitario

Con un buon comportamento e una comunicazione chiara, le situazioni più difficili vengono risolte. Tuttavia, anche in una discussione produttiva, potrebbe esserci semplicemente una divergenza di opinioni su come procedere. In questi casi, identifica una persona o un gruppo di persone che possano fungere da equilibratore.

Un livellatore può essere il principale sostenitore del progetto, oppure può essere un piccolo gruppo di persone che prendono una decisione in base a un voto. Idealmente, è necessario definire un livellatore e la procedura associata in un file GOVERNANCE prima di doverlo utilizzare.

La decisione sulla parità dovrebbe essere l'ultima risorsa. Le questioni di divisione rappresentano un'opportunità per la tua comunità di crescere e imparare. Cogli queste opportunità e utilizza un processo collaborativo per procedere verso la risoluzione quando possibile.

## La community è ❤️ open source

Comunità sane e fiorenti alimentano le migliaia di ore investite ogni settimana nell'open source. Molti contributori citano altre persone come motivo per lavorare - o non lavorare - con l'open source. Imparando a sfruttare questo potere in modo costruttivo, aiuterai qualcuno a vivere un'esperienza open source indimenticabile.
