---
lang: id
title: Dibayar untuk Pekerjaan Open Source
description: Pertahankan pekerjaan Anda pada open source dengan mendapatkan dukungan finansial untuk waktu Anda pada proyek.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Kenapa beberapa orang mencari dukungan finansial

Banyak dari pekerjaan open source adalah sukarela. Sebagai contoh, seseorang mungkin menemukan sebuah kesalahan dalam sebuah proyek yang mereka gunakan dan mengirimkan sebuah perbaikan, atau mereka menikmati menggunakan proyek open source dalam waktu senggang mereka.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Saya sedang mencari proyek pemrograman sebagai "hobi" yang bisa membuat saya sibuk saat menjelang Natal. (...) Saya memiliki komputer dirumah dan tidak banyak yang bisa dikerjakan. Saya memutuskan untuk menulis sebuah penterjemah untuk bahasa pemrograman script yang sudah saya pikirkan belakangan ini. (...) Saya memilih Python sebagai judul pekerjaan saya.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Terdapat banyak alasan kenapa seseorang tidak ingin dibayar untuk pekerjaan open source mereka.

* **Mereka sudah memiliki pekerjaan yang mereka sukai,** yang memungkinkan mereka berkontribusi pada open source di waktu senggang mereka.
* **Mereka menikmati pemikiran open source sebagai hobi** atau pelampiasan kreatif dan tidak ingin terikat secara finansial untuk bekerja pada proyek mereka.
* **Mereka mendapatkan keuntungan lainnya untuk berkontribusi pada open source,** seperti membangun reputasi atau portofolio mereka, mempelajari ketrampilan baru, atau merasa lebih dekat pada komunitas.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Donasi finansial memang menambahkan perasaan tanggung jawab untuk beberapa orang. (...) Merupakan sesuatu yang penting bagi kami yang hidup pada dunia yang sangat cepat dan terkoneksi secara global untuk bisa mengatakan "belum waktunya, saya merasa melakukan sesuatunya dengan cara yang berbeda".
  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Bagi orang lain, terutama bagi membutuhkan waktu yang cukup signifikan untuk kontribusi mereka, mendapatkan dana untuk berkontribusi pada open source adalah satu-satunya cara mereka untuk bisa berpartisipasi, entah karena proyek tersebut membutuhkannya, atau karena alasan pribadi.

Mengelola proyek yang terkenal merupakan tanggung jawab besar, yang membutuhkan waktu 10 atau 20 jam per minggu dibandingkan beberapa jam setiap bulannya.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Tanyakan kepada sembarang pengelola proyek open source, dan mereka akan memberikan informasi tentang realitas pekerjaan yang diperlukan untuk mengelola sebuah proyek. Anda memiliki klien. Anda memperbaiki masalah untuk mereka. Anda menciptakan fitur baru. Hal ini membutuhkan waktu Anda.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Pekerjaan yang dibayar juga memungkinkan orang-orang dari berbagai latar belakang untuk membuat kontribusi yang berarti. Beberapa orang tidak bisa meluangkan waktu tanpa dibayar pada proyek open source, mengingat posisi finansial mereka, hutang, atau tanggung jawab mengelola keluarga. Hal ini berarti dunia tidak akan melihat kontribusi dari orang-orang bertalenta yang tidak mampu menyumbangkan waktu mereka secara sukarela. Hal ini meiliki implikasi etika, seperti [yang dijelaskan](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community) @ashedryden, karena pekerjaan yang dilakukan bias terhadap mereka yang telah memiliki keuntungan dalam hidupnya, yang kemudian mendapatkan keuntungan tambahan karena kontribusi sukarela mereka, sedangkan orang lain yang tidak mampu meluangkan waktunya tidak mendapatkan kesempatan lainnya, sehingga mengakibatkan kurangnya perbedaan pada komunitas open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   OSS menghasilkan keuntungan yang besar pada industri teknologi, yang akan menguntungkan semua industri. (...) Namun, jika satu-satunya orang yang bisa berfokus padanya adalah orang yang beruntung dan terobsesi, maka terdapat potensi yang sangat besar.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Jika Anda mencari dukungan finansial, terdapat dua jalan yang bisa dipertimbangkan. Anda bisa mendanai sendiri sebagai kontributor, atau Anda mencari organisasi pendanaan untuk proyek Anda.

## Mendanai waktu Anda sendiri

Saat ini, banyak orang dibayar untuk bekerja secara paruh waktu atau penuh pada open source. Cara yang paling umum untuk mendapatkan pendanaan untuk waktu Anda adalah berbicara dengan yang mempekerjakan Anda.

Akan lebih mudah untuk mendiskusikan proyek open source jika yang mempekerjakan Anda menggunakan proyek tersebut, tetapi tetap kreatiflah dalam usaha negosiasi Anda. Mungkin mereka tidak menggunakan proyek tersebut, tetapi mereka menggunakan Python, dan mengelola proyek Python yang populer akan membantu mengundang pengembang Python yang baru. Mungkin hal ini membuat perusahaan Anda lebih ramah terhadap pengembang secara umum.

Jika Anda tidak memiliki proyek open source yang ingin Anda kerjakan, tetapi Anda berharap pekerjaan Anda saat ini dibuat dalam bentuk open source, ajukan ke perusahaan Anda untuk membuka perangkat lunak internal mereka pada open source.

Banyak perusahaan mengembangkan program open source untuk membangun citra mereka dan merekrut talenta berkualitas.

@hueniverse, misalnya, menemukan bahwa terdapat alasan finansial untuk mendukung [investasi Walmart pada open source](http://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). @jamesgpearce juga menemukan bahwa program open source milik Facebook [membuat perbedaan](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) dalam proses perekrutan:

> Hal ini terkait erat dengan budaya hacker kami, dan bagaimana organisasi kami dipandang. Kami menanyakan pada karyawan kami, "Apakah Anda sadar tentang program pengembang open source pada Facebook?". Dua pertiga menjawab "Ya". Setengah mengatakan bahwa program  tersebut berkontribusi positif terhadap keputusan mereka untuk bekerja pada Facebook. Itu bukan angka marginal, dan saya berharap menjadi sebuah tren yang berkelanjutan.

Jika perusahaan Anda mengikuti rute ini, merupakan hal yang penting untuk menjaga batas antar aktivitas komunitas dan korporasi. Akhirnya, open source bertahan melalui kontribusi dari orang-orang diseluruh dunia, dan itu sesuatu yang lebih besar dari satu perusahaan atau lokasi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Dibayar untuk bekerja pada open source adalah kesempatan yang langka dan indah, tetapi Anda tidak boleh menyerah pada minat Anda dalam prosesnya. Minat Anda harus menjadi alasan kenapa perusahaan mau membayar Anda.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Jika Anda tidak mampu meyakinkan perusahaan untuk memprioritaskan pekerjaan open source, pertimbangkan untuk mencari perusahaan lain yang mendorong kontribusi karyawan pada open source. Cari perusahaan yang mendedikasikan pada pekerjaan open source secara eksplisit. Sebagai contoh:

* Beberapa perusahaan, seperti [Netflix](https://netflix.github.io/), memiliki halaman web yang menunjukan keterlibatan mereka pada open source
* [Zalando](https://opensource.zalando.com) mempublikasikan [kebijakan kontribusi open source](https://opensource.zalando.com/docs/using/contributing/) bagi pegawai

Proyek-proyek yang berasal dari perusahaan besar, seperti [Go](https://github.com/golang) atau [React](https://github.com/facebook/react), juga akan memperkerjakan orang-orang untuk bekerja pada open source.

Akhirnya, melihat dari kondisi pribadi Anda, Anda bisa mencoba mengumpulkan uang secara mandiri untuk mendanai proyek open source Anda. Sebagai contoh:

* @Homebrew (and [many other maintainers and organizations](https://github.com/sponsors/community)) fund their work through [GitHub Sponsors](https://github.com/sponsors)
* @gaearon mendanai pekerjaannya pada [Redux](https://github.com/reactjs/redux) melalui [kampanye Patreon crowdfunding](https://redux.js.org/)
* @andrewgodwin mendanai pekerjaan pada migrasi skema Django [melalui kampanye Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

## Mencari pendanaan untuk proyek Anda

Diluar pengelolaan untuk kontributor individual, seringkali beberapa proyek mencari pendanaan dari perusahaan, individual, atau yang lain untuk mendanai pekerjaan yang berlangsung.

Organisasi pendanaan mungkin akan mendanai kontributor yang ada, mulai dari pembiayaan operasional (seperti biaya hosting), atau investasi pada fitur atau ide baru.

Seiring dengan popularitas open source, menemukan pendanaan untuk proyek masih bersifat eksperimental, tetapi terdapat beberapa opsi umum yang tersedia.

### Mencari pendanaan untuk pekerjaan Anda melalui kampanye crowdfunding atau sponsor

Mencari sponsor bisa dilakukan jika Anda memiliki pengguna atau reputasi yang kuat, atau proyek Anda sangat populer. Beberapa proyek yang disponsori meliputi:

* **[webpack](https://github.com/webpack)** mendapatkan pendanaan dari perusahaan dan perseorangan [melalui OpenCollective](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** organisasi nirlaba yang membayar untuk bekerja pada [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), dan proyek infrastruktur Ruby lainnya.

### Menciptakan pendapatan

Anda mungkin memberikan tambahan biaya untuk dukungan komersial, opsi hosting, atau fitur tambahan lainnya, tergantung dari proyek Anda. Beberapa contoh diantaranya:

* **[Sidekiq](https://github.com/mperham/sidekiq)** menawarkan versi berbayar untuk dukungan tambahan
* **[Travis CI](https://github.com/travis-ci)** menawarkan versi berbayar untuk produknya
* **[Ghost](https://github.com/TryGhost/Ghost)** bersifat nirlaba dengan layanan pembayaran

Beberapa proyek yang populer, seperti [npm](https://github.com/npm/cli) dan [Docker](https://github.com/docker/docker), bahkan mengajukan pendanaan pada venture capital untuk mendukung pertumbuhan bisnisnya.

### Mengajukan hibah pendanaan

Beberapa yayasan perangkat lunak dan perusahaan menawarkan hibah untuk pekerjaan open source. Seringkali hibah bisa dibayarkan pada individu tanpa perlu membuat entitas legal untuk proyek.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** menerima hibah dari [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* **[OpenMRS](https://github.com/openmrs)** didanai oleh [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** menerima hibah dari [Sloan Foundation](https://sloan.org/programs/digital-technology)
* **[Python Software Foundation](https://www.python.org/psf/grants/)** menawarkan hibah untuk pekerjaan yang berhubungan dengan Python.

Untuk opsi lebih detail dan studi kasus, @nayafia [menuliskan panduan](https://github.com/nayafia/lemonade-stand) untuk mendapatkan pendanaan dari pekerjaan open source. Jenis pendanaan yang berbeda akan membutuhkan ketrampilan yang berbeda, sehingga tentukan kekuatan Anda untuk menentukan opsi mana yang paling sesuai untuk Anda.

## Membangun kasus untuk dukungan finansial

Apakah proyek Anda merupakan ide baru, atau sudah ada sejak beberapa tahun, Anda perlu menekankan tentang mengindentifikasi siapa target donatur Anda dan membuat sebuah kasus yang menarik.

Terlepas dari apakah Anda mencari pendanaan untuk waktu Anda sendiri atau mencari pendanaan untuk proyek, Anda harus mampu menjawab pertanyaan berikut.

### Pengaruh

Kenapa proyek ini berguna? Kenapa pengguna Anda menyukainya? Akan dibawa kemana dalam lima tahun kedepan?

### Daya tarik

Cobalah mengumpulkan barang bukti yang menunjukkan bahwa proyek Anda memang berarti, baik dalam bentuk metrik, anekdot, atau testimoni. Apakah ada perusahaan atau orang-orang yang cukup terkenal menggunakan proyek Anda saat ini? Jika tidak, apakah ada orang yang menyarankannya?

### Nilai bagi donatur

Pemberi dana, baik perusahaan atau yayasan pemberi hibah, seringkali didekati dengan banyak kesempatan. Kenapa mereka harus mendukung proyek Anda dibandingkan proyek lain? Bagaimana mereka bisa mendapatkan keuntungan pribadi?

### Penggunaan dana

Apa yang akan Anda raih dengan dana yang diajukan? Fokuslah pada tonggakan proyek atau hasil keluaran dibandingkan untuk membayar gaji.

### Bagaimana Anda akan menerima dana

Apakah pemberi dana memiliki persyaratan? Misalnya Anda harus bersifat nirlaba atau memiliki sponsor dana nirlaba. Atau misalnya dana harus diberikan pada kontraktor individu dan bukan pada organisasi. Kebutuhan ini akan berbeda diantara pemberi dana, jadi pastikan Anda melakukan pekerjaan Anda terlebih dahulu.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  Bertahun-tahun kami menjadi sumber daya unggulan untuk ikon website yang ramah, dengan jumlah komunitas lebih dari 20 juta orang dan telah ditampilkan di lebih dari 70 juta halaman web, termasuk Whitehouse.gov. (...) Versi 4 dikembangkan tiga tahun yang lalu. Teknologi web telah banyak berubah semenjak itu, dan jujur, Font Awesome tampak stagnan. (...) Itulah sebabnya kami memperkenalkan Font Awesome 5. Kami melakukan modernisasi dan menuliskan ulang CSS dan merancang ulang semua ikon dari atas ke bawah. Kami menawarkan desain  yang lebih baik, konsisten, dan mudah dibaca.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Eksperimen dan jangan menyerah

Mendapatkan pendanaan tidaklah mudah, baik untuk proyek open source, nirlaba, atau startup perangkat lunak, dan pada banyak kasus, Anda harus kreatif. mengindentifikasi bagaimana Anda hendak didanai, melakukan riset, dan menempatkan diri Anda pada penyandang dana akan membantu Anda membangun kasus yang meyakinkan untuk pendanaan.
