---
lang: id
title: Membangun Komunitas yang Ramah
description: Membangun komunitas yang mendorong orang lain untuk menggunakan, berkontribusi, dan mempromosikan proyek Anda.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## Mengarahkan proyek Anda untuk kesuksesan

Anda telah merilis proyek Anda, Anda telah menyebarkan berita, dan orang-orang mulai melihat. Menarik! Sekarang, bagaimana membuat mereka bertahan?

Sebuah komunitas yang ramah merupakan investasi pada masa depan dan reputasi proyek Anda. Jika proyek Anda mulai menerima adanya kontribusi awal, mulailah dengan memberikan pengalaman yang positif, dan permudah akses sehingga mereka akan kembali lagi.

### Buatlah agar orang-orang merasa diterima

Satu cara untuk memikirkan komunitas proyek Anda adalah melalui apa yang disebut @MikeMcQuaid sebagai  [saluran kontributor](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/):

![contributor funnel](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

Ketika Anda membangun komunitas Anda, perhatikan bagaimana orang yang berada di bagian atas (potensi pengguna) secara teori akan bergerak menuju kebawah (sebagai pengelola aktif). Tujuan Anda adalah mengurangi hambatan pada setiap tahapan pengalaman kontributor. Ketika orang tidak mengalami hambatan, mereka akan termotivasi untuk melakukan sesuatu yang lebih.

Mulailah dengan dokumentasi Anda:

* **Permudah orang lain untuk menggunakan proyek Anda.** [README yang ramah](../starting-a-project/#menulis-dokumen-readme) dan contoh kode yang jelas akan mempermudah siapapun untuk bisa langsung menggunakan proyek Anda.
* **Jelaskan dengan jelas bagaimana berkontribusi**, menggunakan [dokumen CONTRIBUTING Anda](../starting-a-project/#menulis-panduan-kontribusi-anda) dan menjaga laporan permasalahan terus diperbarui.

[Survei Open Source GitHub 2017](http://opensourcesurvey.org/2017/) menunjukkan dokumentasi yang tidak lengkap atau membingungkan adalah masalah terbesar bagi pengguna open source. Dokumentasi yang baik akan mengundang orang untuk berinterasi dengan proyek Anda. Akhirnya seseorang akan membuka laporan masalah atau mengirimkan pull request. Gunakan interaksi ini sebagai kesempatan untuk memindahkan mereka ke bagian bawah.

* **Ketika orang baru hadir pada proyek Anda, ucapkan terima kasih!** Cukup satu pengalaman negatif untuk membuat orang tidak ingin kembali.
* **Responsif.** Jika Anda tidak merespon laporan permasalahan selama satu bulan, kemungkinan besar mereka sudah melupakan proyek Anda.
* **Terbuka terhadap jenis kontribusi yang Anda terima.** Banyak kontributor memulai dengan melaporkan permasalahan atau perbaikan sederhana. Terdapat [banyak cara untuk berkontribusi](../how-to-contribute/#apa-artinya-berkontribusi) pada sebuah proyek. Biarkan orang membantu sesuai keinginan mereka untuk membantu.
* **Jika terdapat kontribusi yang tidak Anda setujui,** ucapkan terima kasih atas idenya dan [jelaskan kenapa](../best-practices/#belajar-untuk-mengatakan-tidak) ide tersebut tidak sesuai dengan proyek, dan menghubungkan dengan dokumen yang relevan jika Anda memilikinya.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  Berkontribusi pada open source sangat mudah bagi sebagian orang dibandingkan orang lain. Terdapat ketakutan karena melakukan kesalahan atau tidak sesuai. (...) Dengan memberikan tempat bagi kontributor yang memiliki kemampuan kurang baik (dokumentasi, isi web, dll) Anda bisa mengurangi kecemasan tersebut.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

Mayoritas dari kontributor open source adalah "kontributor umum": orang-orang yang berkontribusi pada sebuah proyek secara tidak rutin. Seorang kontributor jenis ini mungkin tidak memiliki waktu untuk terus mengikuti perkembangan proyek, sehingga tugas Anda alah mempermudah mereka untuk bisa berkontribusi.

Mendorong kontributor lain adalah sebuah investasi pada diri Anda juga. Ketika Anda memberdayakan fans Anda untuk mengerjakan pekerjaan yang mereka sukai, maka tekanan bagi Anda untuk mengerjakan semuanya akan berkurang.

### Dokumentasikan segalanya

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Apakah Anda pernah menghadiri sebuah acara dimana Anda tidak mengenal siapapun, tetapi orang lain tampak saling mengenal satu sama lain dan berbicara seperti sahabat dekat? (...) Sekarang bayangkan Anda ingin berkontribusi pada proyek open source, namun Anda tidak dapat melihat kenapa dan bagaimana ini bisa terjadi.
  <p markdown="1" class="pquote-credit">
— @janl, ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Ketika Anda memulai proyek baru, sangatlah umum untuk membuat proyek Anda secara privat. Tetapi proyek open source berkembang ketika Anda mendokumentasikan proses Anda secara terbuka.

Ketika Anda menuliskan segala sesuatunya, banyak orang bisa berpartisipasi pada setiap langkah. Anda mungkin akan mendapatkan bantuan pada sesuatu yang mungkin tidak Anda bayangkan.

Menuliskan segala sesuatunya berarti lebih dari sekedar dokumentasi teknis. Setiap kali Anda merasa perlu untuk menuliskan sesuatu atau mendiskusikan proyek Anda secara pribadi, tanyakan diri Anda apakah bisa membuatnya menjadi terbuka.

Bersikap transparan terhadap perjalanan proyek Anda, jenis kontribusi yang Anda harapkan, bagaimana kontribusi akan di-review, dan mengapa Anda membuat beberapa keputusan.

Jika Anda melihat beberapa orang mengalami masalah yang sama, dokumentasikan jawabannya pada README.

Untuk acara rapat, pertimbangkan untuk mempublikasikan hasil catatan pada masalah yang relevan. Masukkan yang Anda dapatkan dari transparansi ini mungkin akan mengejutkan Anda.

Mendokumentasikan segalanya juga berlaku pada pekerjaan yang Anda lakukan juga. Jika Anda mengerjakan sebuah perubahan besar pada proyek Anda, simpan pada pull request dan tandai sebagai _work in progress_ (WIP). Dengan cara itu, orang lain bisa merasa terlibat pada fase awal.

### Bersikap responsif

Ketika Anda [mempromosikan proyek Anda](../finding-users), orang lain akan memberikan masukan untuk Anda. Mereka mungkin memiliki pertanyaan tentang bagaimana segala sesuatunya bekerja, atau membutuhkan bantuan untuk memulainya.

Cobalah untuk responsif ketika seseorang membuat laporan masalah, mengirimkan pull request, atau bertanya tentang proyek Anda. Ketika Anda menjawab dengan cepat, orang lain akan merasa bahwa mereka merupakan bagian dari dialog, dan akan merasa lebih berminat untuk berpartisipasi.

Meskipun Anda tidak bisa melakukan review secara langsung, mengkonfirmasinya di awal akan meningkatkan hubungan. Berikut cara @tdreyno merespon terhadap pull request pada [Middleman](https://github.com/middleman/middleman/pull/1466):

![middleman pull request](/assets/images/building-community/middleman_pr.png)

[Penelitian Mozilla menemukan bahwa](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) kontributor yang menerima review kode dalam 48 jam pertama memiliki peluang kembali dan kontribusi berkelanjutan yang lebih tinggi.

Diskusi tentang proyek Anda juga bisa terjadi pada berbagai tempat lain di Internet, seperti Stack Overflow, Twitter, atau Reddit. Anda bisa membuat notifikasi pada beberapa tempat sehingga Anda akan diberitahu apabila seseorang menyebutkan proyek Anda.

### Berikan komunitas Anda tempat untuk berkumpul

Terdapat dua alasan untuk memberikan komunitas Anda tempat untuk berkumpul.

Alasan pertama adalah untuk mereka. Bantu orang-orang untuk saling mengenal. Orang-orang dengan ketertarikan yang sama tentu membutuhkan tempat untuk berdiskusi. Ketika komunikasi terjadi secara publik dan dapat diakses, setiap orang dapat membaca arsip lama untuk bisa dengan cepat memahami kondisi terbaru dan berpartisipasi.

Alasan kedua adalah untuk Anda. Jika Anda tidak memberikan orang lain sebuah tempat publik untuk berbicara tentang proyek Anda, mereka akan menghubungi Anda secara langsung. Di awal, terasa mudah untuk merespon terhadap pesan pribadi "hanya kali ini". Seiring berjalannya waktu, terutama jika proyek Anda menjadi terkenal, Anda akan merasa capek. Hindari keinginan untuk berkomunikasi dengan orang-orang tentang proyek Anda secara pribadi. Arahkan mereka untuk menggunakan media publik.

Komunikasi publik bisa sangat sederhana seperti mengarahkan orang-orang untuk membuka laporan masalah dibandingkan mengirimkan pada Anda secara pribadi atau berkomentar pada blog Anda. Anda juga bisa membuat sebuah mailing list, atau membuat akun Twitter, Slack, atau chanel IRC untuk orang-orang bisa berbicara tentang proyek Anda. Atau coba kesemuanya!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) menyempatkan waktu jam bekerja setiap mingguna untuk membantu anggota komunitas:

> Kops juga memiliki waktu setiap minggunya untuk menawarkan bantuan dan panduan kepada komunitas. Pengelola kop sudah sepakat untuk menyediakan waktu khusus untuk membantu pengguna baru, membantu PR, dan mendiskusikan fitur baru.

Pengecualian terhadap komunikasi publik adalah: 1) masalah keamanan dan 2) pelanggaran kode etik yang sensitif. Anda harus memiliki sebuah cara bagi orang lain untuk melaporkan masalah ini secara pribadi. Jika Anda tidak ingin menggunakan alamat email pribadi, gunakan alamat email yang khusus untuk hal ini.

## Mengembangkan komunitas Anda

Komunitas sangatlah kuat. Kekuratan itu bisa menjadi berkat atau kutukan, tergantung bagaimana Anda menggunakannya. Seiring dengan berkembangnya komunitas proyek Anda, terdapat banyak cara untuk membuatnya menjadi kekuatan yang bersifat membangun, bukan menghancurkan.

### Tidak mentolerir aktor jahat

Sembarang proyek yang terkenal akan menarik orang lain untuk merusak dibandingkan membantu komunitas Anda. Mereka mungkin memulainya dengan debat yang tidak perlu, beralasan tentang fitur yang sederhana, atau bahkan menganggu yang lain.

Lakukan yang terbaik untuk mengadopsi kebijakan tanpa toleransi terhadap orang-orang jenis ini. Jika dibiarkan, orang-orang negatif ini akan membuat orang lain menjadi tidak nyaman. Bahkan mereka bisa meninggalkan proyek Anda.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  Memiliki komunitas yang mendukung adalah kuncinya. Saya tidak akan pernah bisa melakukan pekerjaan ini tanpa rekan-rekan saya, orang asing di Internet yang ramah, dan chanel IRC yang ramai (...).
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

Debat pada hal-hal kecil bisa menganggu yang lain, termasuk Anda dari pekerjaan penting. Orang baru yang hadir pada proyek Anda mungkin melihat diskusi ini dan tidak jadi berpartisipasi.

Ketika Anda melihat perilaku negatif terjadi pada proyek Anda, hentikan segera. Jelaskan dengan cara yang sopan tetapi tegas kenapa perilaku semacam ini tidak dapat diterima. Jika hal ini masih berlanjut, Anda bisa saja [meminta mereka untuk pergi](../code-of-conduct/#menerapkan-kode-etik). [Kode etik](../code-of-conduct/) Anda bisa menjadi panduan yang konstruktif untuk diskusi semacam ini.

### Temui kontributor dimana mereka berada

Dokumentasi yang bagus akan semakin penting ketika komunitas Anda berkembang. Kontributor umum, yang mungkin tidak fasih dengan proyek Anda akan membaca dokumentasi untuk bisa memahami konteks yang mereka perlu ketahui.

Pada dokumen CONTRIBUTING, jelaskan secara eksplisit bagaimana kontributor baru bisa memulainya. Anda mungkin bisa mempersiapkan satu bagian khusus untuk tujuan ini. Sebagai contoh, [Django](https://github.com/django/django), memiliki halaman awal khusus untuk menyambut kontributor baru.

![django new contributors page](/assets/images/building-community/django_new_contributors.png)

Pada daftar laporan masalah Anda, tandai masalah yang cocok untuk setiap jenis kontributor yang berbeda: misalnya, [_"hanya pemula"_](https://kentcdodds.com/blog/first-timers-only), _"laporan kesalahan pertama"_, atau _"dokumentasi"_. [Label ini](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) mempermudah orang yang baru pada proyek Anda untuk mencari daftar laporan masalah dan mulai berkontribusi.

Akhirnya, gunakan dokumentasi Anda untuk membuat orang lain nyaman pada setiap langkahnya.

Anda tidak akan pernah berinteraksi dengan sebagian besar orang-orang yang hadir pada proyek Anda. Bisa jadi terdapat kontribusi yang tidak Anda dapatkan karena seseorang merasa terintimidasi atau tidak tahu bagaimana memulainya. Sebuah kata-kata sederhana bisa menjaga mereka untuk tetap bertahan dan bebas dari rasa frustasi.

Sebagai contoh, berikut bagaimana cara [Rubinius](https://github.com/rubinius/rubinius/) memulai [panduan kontribusinya](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> Kita ingin memulainya dengan mengucapkan terima kasih karena menggunakan Rubinius. Proyek ini merupakan hasil cinta kami, dan kami menghargai semua pengguna yang menemukan kesalahan, membuat perbaikan performa, dan membantu dengan dokumentasi. Setiap kontribusi sangat berharga, sehingga kami mengucapkan terima kasih untuk berpartisipasi. Meski demikian, berikut adalah beberapa panduan yang kami harapkan untuk bisa diikuti sehingga kami bisa menyelesaikan permasalahan Anda dengan baik.

### Berbagi kepemilikan dari proyek Anda

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  Pemimpin Anda akan memiliki opini  yang berbeda, seperti halnya komunitas lainnya! Namun, Anda perlu mengambil langkah-langkah untuk memastikan bahwa suara terbesar tidak selalu menang, dan suara minoritas akan selalu didengarkan.
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["What makes a good community?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

Orang-orang tertarik untuk berkontribusi pada proyek apabila mereka merasa perasaan memiliki. Hal itu bukan berarti Anda perlu memberikan visi proyek Anda kepada mereka atau menerima kontribusi yang tidak Anda kehendaki. Tetapi semakin banyak Anda memberikan penghargaan kepada orang lain, semakin besar kemungkinan mereka akan bertahan.

Cari cara untuk bisa berbagi kepemilikan dengan komunitas Anda sebanyak mungkin. Berikut beberapa ide:

* **Menahan diri memperbaiki kesalahan sederhana.** Gunakan kesempatan ini untuk merekrut kontributor baru, atau menjadi mentor bagi orang lain yang ingin berkontribusi. Hal ini tampaknya tidak biasa pada awalnya, namun investasi Anda akan berbuah hasil dikemudian hari. Sebagai contoh @michaeljoseph meminta kontributor untuk mengirimkan pull request pada masalah [Cookiecutter](https://github.com/audreyr/cookiecutter), dan tidak menyelesaikannya sendiri.

![cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **Bualah dokumen CONTRIBUTORS atau AUTHORS pada proyek Anda** yang mendata semua orang yang berkontribusi pada proyek Anda, seperti [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md).

* Jika Anda memiliki komunitas yang cukup besar, **kirimkan surat berita atau tuliskan blog** dan ucapkan terima kasih pada kontributor. [This Week in Rust](https://this-week-in-rust.org/) milik Rust dan [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) milik Hoodie adalah dua contoh bagus.

* **Berikan setiap kontributor akses commit.** @felixge menemukan bahwa hal ini membuat orang lain [lebih tertarik untuk memperbaiki perbaikan mereka](https://felixge.de/2013/03/11/the-pull-request-hack.html), dan dia juga menemukan pengelola baru untuk proyek yang tidak dia kelola selama beberapa waktu.

* Jika proyek Anda berada pada GitHub, **pindahkan proyek Anda dari akun personal ke [Organisasi](https://help.github.com/articles/creating-a-new-organization-account/)** dan tambahkan paling tidak satu admin cadangan. Organisasi mempermudah pekerjaan kolaborasi dengan kolaborator eksternal.

Kenyataannya adalah [sebagian besar proyek hanya memiliki](https://peerj.com/preprints/1233/) satu atau dua pengeloa yang melakukan sebagian besar pekerjaan. Semakin besar proyek Anda, dan semakin besar komunitas Anda, semakin mudah untuk menemukan bantuan.

Meskipun tidak selalu mudah untuk mendapatkan orang yang memenuhi panggilan Anda, memberikan sinyal akan meningkatkan peluang dimana orang lain akan ikut terlibat. Dan semakin cepat Anda melakukannya, semakin cepat pula orang akan datang membantu.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  Pastikan untuk merekrut kontributor yang menikmati dan mampu melakukan sesuatu yang tidak Anda bisa lakukan. Apakah Anda suka membuat kode, tetapi tidak suka menjawab laporan permasalahan? Maka cari orang-orang pada komunitas Anda yang suka dengan hal itu dan biarkan mereka untuk melakukannya.
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## Menyelesaikan konflik

Pada awal proyek, membuat keputusan besar terasa mudah. Ketika Anda hendak melakukan sesuatu, Anda langsung melakukannya.

Seiring dengan proyek Anda semakin populer, semakin banyak orang akan memperhatikan setiap keputusan yang Anda ambil. Meskipun Anda tidak memiliki komunitas kontributor yang besar sekalipun, apabila proyek Anda memiliki banyak pengguna, Anda akan mendapati bahwa orang lain akan berusaha mempengaruhi keputusan atau mengangkat masalah mereka sendiri.

Pada sebagian besar kasus, jika Anda telah membangun komunitas yang ramah dan saling menghargai serta mendokumentasikan proses Anda secara terbuka, komunitas Anda akan mudah menemukan solusinya. Namun seringkali Anda akan menjumpai masalah yang susah diselesaikan.

### Tentukan tingkat kesabaran

Ketika komunitas Anda berjuang dengan masalah yang rumit, emosi bisa meningkat. Orang-orang bisa menjadi marah dan frustasi dan melimpahkannya pada orang lain, atau pada Anda.

Tugas Anda sebagai pengelola adalah menjaga situasi ini agar tidak sampai memuncak. Meskipun Anda memiliki opini yang kuat pada topik tersebut, cobalah untuk membuat posisi Anda sebagai moderator atau fasilitator dan jangan memaksakan kehendak Anda. Jika seseorang mencoba memonopoli diskusi, [ambil tindakan secepatnya](../building-community/#tidak-mentolerir-aktor-jahat) untuk memastikan diskusi tetap terjaga dan produktif.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  Sebagai pengelola proyek, sangatlah penting untuk menghargai kontributor Anda. Mereka seringkali menerima apa yang Anda sampaikan secara personal.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

Orang lain melihat Anda sebagai panutan. Berikan contoh yang baik. Anda bisa mengutarakan kekecewaan, kesedihan, atau kekhawatiran, tetapi lakukan secara perlahan.

Mempertahankan hal yang baik bukanlah sesuatu yang mudah, tetapi mendemonstrasikan kepemimpinan akan meningkatkan kesehatan dari komunitas Anda. Intrnet akan berterima kasih kepada Anda.

### Perlakukan README sebagai konstitusi

Dokumen README [lebih dari sekedar sekumpulan instruksi](../starting-a-project/#menulis-dokumen-readme). Dokumen itu juga tempat untuk mendiskusikan tujuan, visi, dan peta proyek Anda. Jika orang-orang terlalu fokus berdebat pada fitur tertentu, mungkin akan membantu untuk melihat kembali dokumen README dan diskusikan visi yang lebih jauh dari proyek Anda. Berfokus pada README juga memperdalam diskusi sehingga Anda bisa mendapatkan diskusi yang konstruktif.

### Fokus pada perjalanan, bukan tujuan

Beberapa proyek menggunakan proses pemilihan suara model voting untuk pengambilan keputusan yang besar. Meskipun masuk akal di awal, voting berfokus pada mendapatkan "jawaban", dan bukan pada mendengarkan dan menjawab kekhawatiran orang lain.

Voting bisa sangat politis, dimana anggota komunitas merasa tertekan untuk melakukannya. Tidak semua memberikan suaranya, baik sebagai [silent majority](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) pada komunitas Anda, atau pengguna yang tidak tahu bahwa terjadi voting.

Seringkali voting memang diperlukan untuk memecah kebuntuan. Namun tekankan ["consensus seeking"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) daripada konsensus.

Pada proses _consensus seeking_, anggota komunitas mendiskusikan masalah utama sampai mereka merasa didengarkan. Ketika tersisa masalah kecil, maka komunitas akan bergerak maju. "Consensus seeking" mengakui bahwa sebuah komunitas mungkin tidak akan mendapatkan jawaban yang sempurna. Namun proses ini memprioritaskan proses untuk mendengarkan dan diskusi.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  Salah satu alasan kenapa sistem voting tidak berlaku untuk masalah Atom adalah karena tim Atom tidak akan mengikuti sistem voting pada setiap kasusnya. Seringkali kami harus memilih apa yang kami rasa benar meskipun tidak populer. (...) Apa yang bisa saya tawarkan dan janjikan...adalah karena itu merupakan pekerjaan saya untuk mendengarkan komunitas.
  <p markdown="1" class="pquote-credit">
— @lee-dohm on Atom's decision making process
  </p>
</aside>

Meskipun Anda tidak mengadopsi proses _consensus seeking_, sebagai seorang pengelola proyek, sangatlah penting bahwa orang lain tahu bahwa Anda mendengarkan. Membuat orang lain merasa didengarkan, dan berkomitmen untuk menyelesaikan masalah mereka akan membantu menyelesaikan situasi yang sensitif. Lanjutkan ucapan Anda dengan tindakan.

Jangan tergesa-gesa untuk mengambil keputusan untuk mendapatkan resolusi. Pastikan semua orang merasa didengarkan dan semua informasi sudah dipublikasikan sebelum melanjutkan pada penyelesaian.

### Jaga diskusi agar berfokus pada tindakan

Diskusi penting, tetapi terdapat perbedaan antara diskusi yang produktif dan tidak produktif.

Dorong terjadinya diskusi selama mengarah pada jawaban. Jika diskusi sudah tidak jelas dan keluar dari topik, mengarah ke individual, atau mulai memperhatikan hal-hal kecil yang tidak relevan, waktunya untuk menghentikan diskusi tersebut.

Mengijinkan diskusi semacam ini untuk terus berlanjut tidak hanya jelek untuk masalah yang dibahas, namun juga pada komunitas Anda. Diskusi semacam ini mengirimkan pesan bahwa jenis diskusi semacam ini diijinkan atau bahkan malah disarankan, dan bisa membuat orang lain untuk tidak bersedia mengirimkan atau menyelesaikan masalah di masa depan.

Dengan setiap poin yang dibuat oleh Anda atau orang lain, tanyakan kepada diri Anda, _"Bagaimana hal ini bisa membawa kita lebih dekat pada penyelesaian?"_

Jika diskusi sudah mulai tidak mengarah, tanyakan pada grup, _"Langkah apa yang sebaiknya kita ambil berikutnya?"_ untuk memfokuskan ulang pada diskusi.

Jika sebuah diskusi tidak mengarah kemana-mana, tidak ada tindakan yang jelas yang harus diambil, atau tindakan yang benar sudah dilakukan, tutup laporan dan jelaskan kenapa.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Mengarahkan sebuah diskusi pada sebuah kegunaan tanpa bersifat memaksa adalah sebuah seni. Hal ini tidak semudah untuk meminta orang-orang untuk menghabiskan waktu mereka, atau meminta mereka untuk tidak memberikan komentar kecuali mereka memiliki ide yang konstruktif. (...) Anda harus menyarankan kondisi untuk peningkatan lebih lanjut: berikan rute kepada orang, jalur yang bisa diikuti yang mengarah pada hasil yang Anda inginkan, tanpa seolah-olah Anda mengatur perilaku mereka.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### Tentukan perang Anda secara bijaksana

Konteks itu penting. Pertimbangkan siapa yang harus terlibat pada diskusi dan bagaimana mereka bisa merepresentasikan komunitas secara luas.

Jika semua orang pada komunitas tidak suka, atau terlibat dengan masalah ini? Atau cuma individual? Jangan lupa untuk memperhatikan anggota komunitas yang hanya mendengarkan, tetapi tidak memberikan suaranya secara aktif.

Jika masalah tersebut tidak merepresentasikan kebutuhan yang lebih luas dari komunitas Anda, Anda mungkin cukup meminta pendapat dari sebagian kecil orang. Jika hal ini merupakan masalah yang terjadi berulang-ulang tanpa penyelesaian yang jelas, hubungkan dengan diskusi sebelumnya dan tutup laporan masalah.

### Identifikasi pemecah kebuntuan pada komunitas

Dengan perilaku yang baik dan komunikasi yang jelas, sebagian besar situasi akan dapat terselesaikan. Meski demikian, bahkan pada diskusi yang produktif sekalipun, seringkali terdapat perbedaan pendapat tentang apa yang harus dilakukan. Pada kasus ini, identifikasi individu atau sekelompok orang yang bisa memecah kebuntuan.

Orang ini bisa pengelola utama pada proyek, atau sekelompok orang yang mengambil keputusan berdasarkan voting. Idealnya Anda sudah mengindentifikasi orang-orang ini dan menuliskan prosesnya pada dokumen GOVERNANCE sebelum Anda harus menggunakannya.

Gunakan ini sebagai jalan terakhir. Masalah semacam ini merupakan kesempatan bagi komunitas Anda untuk berkembang dan belajar. Manfaatkan kesempatan ini dan gunakan proses kolaboratif untuk berpidah pada penyelesaian sebisa mungkin.

## Komunitas adalah ❤️ dari open source

Komunitas yang sehat dan berkembang akan mengisi ribuan jam yang dihabiskan pada open source setiap minggunya. Banyak kontributor akan menunjuk orang lain sebagai alasan ia bekerja - atau tidak bekerja - pada open source. Dengan mempelajari bagaimana menggunakan kekuatan tersebut secara positif dan konstruktif, Anda akan membantu orang-orang diluar sana untuk mendapatkan pengalaman open source yang tak terlupakan.
