---
lang: hu
title: Nyílt forráskódú projekt indítása
description: Tudj meg többet a nyílt forráskód világáról, és állj készen a saját projekted elindítására.
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## A nyílt forráskód "mit" és "hogyan"-ja

Szóval arra gondoltál, hogy elkezded a nyílt forráskódú projekted. Gratulálunk! A világ nagyra fogja értékeli a részvételed. Beszéljünk kicsi arról, hogy mi is az a nyílt forráskód, és miért csinálják az emberek.

### Mit jelent a nyílt forráskód?

Amikor egy projekt nyílt forráskódú, az azt jelenti, hogy **bárki szabadon használhatja, tanulmányozhatja, módosíthatja és terjesztheti bármilyen céllal.** Ezt a lehetőséget [az nyílt forráskódú licenc biztosítja](https://opensource.org/licenses).

A nyílt forráskód azért hatásos, mert elhárítja az akadályt az együttműködés és a felhasználás elől, lehetővé teszi az emberek számára a gyors fejlesztést és terjesztést. És még azért is, mert a felhasználók számára lehetővé teszi, hogy kontrolljuk legyen a saját szoftvereik felett, ellenben a zárt forráskóddal. Például egy vállalkozás, amely nyílt forráskódot használ, képes lehet arra, hogy felbérel egy olyan fejelsztőt, aki elvégzi számára a szükséges fejlesztéseket, ahelyett, hogy kizárólag a zárt forrásúkódú szoftvert fejlesztő cég termékdöntéseire támaszkodna.

_Free software_ kifejezés ugyanazokra a projektekre vonatkozik, mint amire az _open source_. Néhol láthatod [ezen kifejezések](https://en.wikipedia.org/wiki/Free_and_open-source_software) kombinációját is, mint például "free and open source software" (FOSS) vagy "free, libre, and open source software" (FLOSS). A _Free_ és _libre_ a _szabadságra_ utal, [nem az árra](#a-nyílt-forráskódú-projekt-ingyenességet-jelent).

### Miért vesznek részt az emberek a nyílt forráskódú projektekben?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">
  Az egyik leghasznosabb tapasztalat, amit a nyílt forráskódú felhasználásból, és együttműködésből fel tudok használni az, hogy együtt építjük fel olyanokkal, akik már szintén szembesültek ugyanazokkal a problémákkal, amivel én.
  <p markdown="1" class="pquote-credit">
— @kentcdodds, ["How getting into Open Source has been awesome for me"](https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me)
  </p>
</aside>

[Számos oka van](https://ben.balter.com/2015/11/23/why-open-source/) hogy valaki, vagy akár egy cég a nyílt forráskódban részt vesz. Csak néhány példa:

* **Együttműködés:** A nyílt forráskódú projektek bárkitől elfogadnak módosítást a világ bármely részéről. [Exercism](https://github.com/exercism/), például egy programozási gyakorlást segítő projekt több, mint 350 fejlesztő részvételével.

* **Elterjedés és újrafelhasználás:** A nyílt forráskódú projekteket bárki használhatja szinte bármilyen célra. Az emberek akár más dolgok létrehozására is felhasználhatják. A [WordPress](https://github.com/WordPress) például úgy kezdte, hogy egy létező, [b2](https://github.com/WordPress/book/blob/HEAD/Content/Part%201/2-b2-cafelog.md) nevű projektet elágaztattak.

* **Átláthatóság:** A nyílt forráskódú projektet bárki megvizsgálhatja, vagy hibákat kereshet benne. Az átláthatóság a kormányoknak is fontos, mint ahogy [Bulgária](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-open-source-98bf626cf70a) teszi ezt, vagy ahogy az [Amerikai Egyesült Államok](https://www.cio.gov/2016/08/11/peoples-code.html) szabályozza a bank, és egészségügy iparát, de fontos a biztonsági szoftverek esetén is, mint a [Let's Encrypt](https://github.com/letsencrypt).

A nyílt forráskódú projekt nem csak szoftver lehet. Lehet ez adat, vagy könyv is akár, de bármi más is. Nézd meg a [GitHub Explore](https://github.com/explore) helyen, hogy mi minden lehet nyílt forráskódú projekt.

### A nyílt forráskódú projekt ingyenességet jelent?

A legtöbb nyílt forráskódú projekt nem kerül pénzbe. Az ingyenesség általában a nyílt forráskód következménye.

Mivel [a nyílt forráskódú licenc előírja](https://opensource.org/osd-annotated) azt, hogy mindenki használhatja, módosíthatja és megoszthatja a projektet bármilyen célra, ezért maga a _projekt_ ingyenes. Ha a projekt úgy döntene, hogy pénzt kér tőled, akkor bárki legálisan másolatot készíthet róla és használhatja az ingyenes verziót helyette.

Bár a nyílt forráskódú projekt önmagában ingyenes, a nyílt forráskód nem definiálja magát az ingyenességet. Van lehetőség arra, hogy pénzt kérj egy nyílt forráskódú projektért, a kettős licencelés, vagy a korlátozott funkciókon keresztül, ez még nem ütközik a nyílt forráskód definíciójával.

## Elindíthatom a saját nyílt forráskódú projektemet?

A rövid válasz igen, mert a saját projekten keresztül megismered a nyílt forráskódú projektek működését.

Ha sohasem vettél részt még nyílt forráskódú projektben, akkor bátortalan lehetsz majd, ha majd az emberek reakcíója miatt, vagy ha felhívják a figyelmedet pár dologra. De emiatt ne aggódj, mert ez természetes, mással is így van!

A nyílt forráskód egy kreatív viselkedést igénylő dolog, mint az írás vagy a festés. Lehet, először félelmetesnek tűnik, hogy megosztod a munkádat a világgal, de ez a legjobb módja annak, hogy fejlődj, hiszen nem leszel jobb, ha nem kapsz kritikákat.

Ha még mindig nem lettél meggyőzve, akkor gondolkozz el azon, hogy mi is az igazi célod!

### Célok kijelölése

A célok segíthetnek abban, hogy kitaláld, min kell dolgoznod, mit kell mondanod, és hol van szükséged mások segítségére. Kérdezd meg magadtól, hogy _miért nyitom meg ezt a projektet?_

Nincs tökéletes válasz erre a kérdésre. Többféle célod lehet akár egy projekt esetén is, más projekteknél viszont más célok fognak vezérelni.

Ha csak az a célod, hogy a munkádat megmutasd, akkor nem akarsz résztvevőket és ezt a README-ben le is írhatod. Másrészről, ha akarsz résztvevőket a projekteden, akkor időt kell szánnod az alapos dokumentációra, hogy az újonnan érkezők könnyen csatlakozhassanak.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">
  Készítettem egy UIAlertView komponenst, amit korábban már használtam saját célra... és eldöntöttem, hogy nyílt forráskódú projektet csinálok belőle. Így kicsit módosítottam rajta és feltöltöttem a GitHub-ra. Ekkor írtam az első dokumentációt is, amelyben leírtam, hogy más fejlesztők hogyan használhatják ezt a programjaikban. Persze lehet, hogy soha senki nem használta, de engem mégis örömmel töltött el, mert ez volt életem első nyílt forráskódú projektje.
  <p markdown="1" class="pquote-credit">
— @mavris, ["Self-taught Software Developers: Why Open Source is important to us"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

Ahogy a projekt növekszik, a közösségednek többre lehet szüksége, mint pusztán csak a kód. A nyílt forráskódú projektek fontos feladata a kérdések megválaszolása, a kódok áttekintése, és a projekt hírnevének terjesztése.

A nem kódolási feladatokra fordított idő függ a projekt nagyságától és terjedelmétől, mint karbantartónak, neked is fel kell készülnöd arra, hogy találj valakit, aki segíthet ebben.

**Ha egy olyan cég tagja van, aki nyílt forráskódú projekttel rendelkezik,** bizonyosodj meg arról, hogy vannak megfelelő belső erőforrások a projekthez. Azonosítsd azokat az embereket, akik a karbantartói feladatot fognak végezni rajta, és oszd meg a közösséggel ezeket a feladatokat.

Ha szükséges fix költségvetés, vagy alkalmazotti kör a fejlesztéshez, vagy fenntartáshoz, akkor kezd el ezeket a egyeztetéseket minél korábban.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">
  Ahogy megkezded a forráskód megnyitását, fontos, hogy gondoskodj arról, hogy annak folyamatai figyelembe vegyék a közösség részvételét és képességeit a projektben. Ne félj, bevonni a kulcsfontosságú részletekbe azokat a közreműködőket, akik nem dolgoznak a cégben - különösen, ha gyakori közreműködők lesznek.
  <p markdown="1" class="pquote-credit">
— @captainsafia, ["So you wanna open source a project, eh?"](https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779)
  </p>
</aside>

### Hozzájárulás más projektekhez

Ha a cél az, hogy megtanuld, hogyan működj együtt másokkal, vagy megértsd, hogyan működik a nyílt forráskód, fontold meg egy meglévő projekthez való hozzájárulást. Kezd azzal a projektel, amelyet már használsz, és szeretsz. A projekthez való hozzájárulást kezd olyan egyszerű dolgokkal, mint a helyesírási hibák javítása, vagy a dokumentáció frissítése.

Ha nem vagy biztos abban, hogy hogyan kezdj neki, mint résztvevő, akkor nézd meg ezt: [How to Contribute to Open Source guide](../how-to-contribute/).

## Saját nyílt forráskódú projekt indítása

Nincs tökéletes időpont a forráskód megnyitására. Megnyithatsz egy ötletet, egy folyamatban lévő munkát, vagy akár egy olyan kódot is, ami évekig zárt volt.

Általánosságban elmondható, hogy akkor kell a projekt forrását megnyitni, ha úgy érzed, hogy ha mások látják, és visszajelzést adnak a munkádról, az neked jó.

Függetlenül attól, hogy melyik szakaszban döntöd el a projekt forrásának megnyitását, minden projektnek tartalmaznia kell a következő dokumentációt:

* [Nyílt forráskódú licenc](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [Résztvevőknek útmutató](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [Magatartási kódex](../code-of-conduct/)

Karbantartóként ezek az összetevők segítenek az elvárásaid közlésében, a résztvevők kezelésében és mindenki jogának a védelmében (beleértve a sajátodat is). Jelentősen növelik az esélyt arra, hogy pozitív tapasztalatokat szerezz.

Ha a projekted a GitHub-on van, akkor ezek a fájlok a gyökérkönyvtárba kerüljenek az ajánlott fájlnevekkel, így a GitHub felismeri és automatikusan értesíti az olvasókat.

### Licence választás

A nyílt forráskódú licenc garantálja, hogy mások használhassák, másolhassák, módosíthassák és hozzájárulhassanak a projekthez szabadon. Emellett megvéd a kiszámíthatatlan jogi helyzetektől. **A licencet a nyílt forráskódú projekt indításával együtt kell megadni.**

A jogi munka nem öröm. A jó hír azonban az, hogy a licencet egyszerűen elhelyezheted a projektedben, csak be kell másolni. Csak néhány percet igényel az, hogy megvédd a munkádat.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), és a [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) a leghíresebb licencek, de [van számos másik is](https://choosealicense.com) amelyből választhatsz.

Amikor új projektet hozol létre a GitHub-on, lehetőséget kapsz licenc választásra. Nyílt forráskódú licenccel a projekted nyílt forráskódú lesz.

![Válassz egy licencet!](/assets/images/starting-a-project/repository-license-picker.png)

Ha egyéb kérdésed, vagy kételyed van a nyílt forráskódú projektek jogi részével kapcsolatban, akkor [bővebb információt itt találsz](../legal/).

### README írása

README több annál, mint hogy leírod azt, hogy hogyan kell a projektet használni. Elmagyarázza azt is, hogy miért lényeges a projekted, és hogy hogyan tud abban más is részt venni.

A README-ben próbáld meg az alábbiakra megadni a választ:

* Mit csinál a projekt?
* Miért hasznos a projekt?
* Hogyan lehet elkezdeni vele dolgozni?
* Hol találok további segítséget, ha szükségem van rá?

A README meg tudja még válaszolni azt, hogy hogyan fogadsz el közreműködést, mi a projekt célja, és információkat ad a licencről és további részletekről. Ha nem fogadsz el közreműködést a projektben, vagy a projekted nincs még abban az állapotban, hogy éles működésben használható legyen, akkor szintén írd le ezeket az információkat a README-ben.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">
  A jobb dokumentáció, több felhasználót, kevesebb szupportot, és több közreműködőt jelent.
  (...) Emlékezz arra, hogy aki olvasni fogja, az nem te vagy. Olyan emberek olvassák, akik lehet teljesen más projektből érkeztek ide, és teljesen más tapasztalatokkal rendelkeznek.
  <p markdown="1" class="pquote-credit">
— @tracymakes, ["Writing So Your Words Are Read (video)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

Néha az emberek épp azért nem írnak README-t, mert úgy hiszik, hogy még nincs befejezve projektjük, vagy úgy gondolják hogy nem akarnak részvételt benne. Pedig éppen ezek nagyon jó okok arra, hogy a README-t megírjuk.

Továbbiakért nézd meg @dguo ["README" útmutató készítése](https://www.makeareadme.com/) vagy @PurpleBooth [README űrlap](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2) című munkáját, így jó README-t írhatsz.

Amikor a README állományt a főkönyvtárba teszed, a GitHub automatikusan megjeleníti azt a kódtározó főoldalán.

### Részvételi irányelvek leírása

A CONTRIBUTING állomány közli az emberekkel, hogy hogyan lehet részt venni a projektben. Például ezeket az információkat lehet megadni:

* Hogyan jelents egy hibát (próbáld használni a [hiba és beolvasztási kérés űrlapokat](https://github.com/blog/2111-issue-and-pull-request-templates))
* Hogyan javasolj új funkciót
* Hogyan állítsd be a környezetedet, és futtasd a teszteket

A műszaki adatokon kívül, a CONTRIBUTING fájl lehetőséget nyújt arra, hogy közölje a résztvevőkkel, a részvételre vonatkozó elvárásaid, például:

* Milyen típusú résztvevőket vársz
* A roadmap-je és víziója a projektednek
* A résztvevők hogyan (vagy hogyan nem) léphetnek veled kapcsolatba

Kedves, barátságos hang használata, és konkrét javaslatok nyújtása a hozzájárulásokhoz (például dokumentáció készítése vagy weboldal készítése) nagyban hozzájárulhat ahhoz, hogy az újonnan érkezők azt érezzék, hogy szívesen látják őket, és örüljenek a részvételnek.

Például az [Active Admin](https://github.com/activeadmin/activeadmin/) a [saját részvételi szabályzatát](https://github.com/activeadmin/activeadmin/blob/HEAD/CONTRIBUTING.md) ezzel kezdi:

> Legelőször is, köszönöm hogy részt kívánsz venni az Active Admin projektben. Az olyan emberek mint te, tehetik az Active Admin ilyen nagyszerű eszközzé.

A CONTRIBUTING állomány a projekt korai fázisában egyszerű. Mindig el kell megmagyaráznod benne, hogy hogyan lehet hibát vagy egyéb problémát jelezni, a szükséges technikai igényeket, például a teszteket is le kell írni benne ahhoz, hogy valaki a projekten tudjon dolgozni.

Idővel további gyakori kérdéseket adhatsz hozzá a CONTRIBUTING fájlhoz. Ezen információk írása azt jelenti, hogy kevesebb ember fogja újra és újra ugyanazt a kérdést feltenni.

További segítségért a CONTRIBUTING írásához, nézd meg @nayafia [részvételi útmutató űrlapját](https://github.com/nayafia/contributing-template/blob/HEAD/CONTRIBUTING-template.md) vagy a @mozilla's ["Hogyan építs CONTRIBUTING.md-t?"](https://mozillascience.github.io/working-open-workshop/contributing/).

A CONTRIBUTING állományra hivatkozhatsz a README állományból, így az emberek azonnal látják azt. Ha [elhelyezed a CONTRIBUTING állományt a projekt alatt](https://help.github.com/articles/setting-guidelines-for-repository-contributors/), akkor a GitHub automatikusan linkelni fogja azt, ha valaki hibát jelent, vagy beolvasztási kérést hoz létre.

![Contributing guidelines](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### Magatartási kódex létrehozása

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">
  Mindannyian tapasztalatuk már azt, hogy valaki durván próbálta elmagyarázni a dolgokat, mint például egy karbantartó, hogy mit, miért úgy kell csinálni, vagy egy felhasználó, aki egy kérdést tett fel nem túl szép hangnemben. (...) A magatartási kódex könnyen meghivatkozható dokumentum, amely azt jelzi, hogy a csapat nagyon komolyan veszi a konstruktív diskurzust.
  <p markdown="1" class="pquote-credit">
— @mlynch, ["Making Open Source a Happier Place"](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

A magatartási kódex segít az alapjait lefektetni a viselkedési szabályoknak a projekt résztvevők számára. Különösen értékes, ha egy nyílt forráskódú projektet indítasz egy közösség, vagy a cég számára. A magatartási kódex erősíti az egészséges, konstruktív, közösségi viselkedést, ami csökkenteni fogja a stresszt a karbantartók számára is.

További információkért nézd meg: [Magatartási kódex útmutató](../code-of-conduct/).

Amellett, hogy a magatartási kódex leírja, hogy hogyan kell viselkedni, azt is megadja, hogy kikre vonatkozik, mikor vonatkozik rájuk, és mi történik akkor, hogyha azt megsértik.

Mint a nyílt forráskódú licenc esetén, itt is számos standard van a viselkedési szabály kódexre, így nem kell sajátot írnod. A [Résztvevői Megállapodás](https://contributor-covenant.org/) egy azonnal használható magatartási kódex, amelyet több mint [40,000 nyílt forráskódú projekt](https://www.contributor-covenant.org/adopters) használ, mint például a Kubernetes, Rails, vagy a Swift. Lényegtelen, hogy mit használsz ezekből, de az fontos, hogy kikényszerítsd ennek betartását.

A kód mellé helyezd el CODE_OF_CONDUCT állományt. A főkönyvtárba tedd a README mellé, és hivatkozd meg a README állományból.

## A projekt elnevezése és brand építés

A brand építés több mint egy vagány logó, vagy egy megkapó projekt név. Arról szól, hogy hogyan kommunikálod a projektet, és kiket akarsz elérni vele.

### A megfelelő név kiválasztása

Válassz egy nevet, amelyet könnyen megjegyezhetsz, és ideális esetben sugall valamit arról, hogy mit is csinál a projekt. Például:

* [Sentry](https://github.com/getsentry/sentry) Őrszem – monitorozza az alkalmazás hibákat
* [Thin](https://github.com/macournoyer/thin) Vékony – gyors, és egyszerű Ruby webszerver

Ha már létező projektre alapozol, a nevét előtagként használva segít tisztázni, hogy mit csinál a projekt (például [node-fetch](https://github.com/bitinn/node-fetch) a `window.fetch` funkciót valósítja meg a Node.js alatt).

Gondolj mindenekelőtt az egyértelműségre. A szójáték szórakoztató, de ne feledd, hogy néhány vicc érthetetlen más kultúrák, vagy emberek számára. Lehet, hogy a potenciális felhasználók egy része vállalati alkalmazott: nem akarod, hogy kényelmetlenül érezzék magukat, ha munkájuk során elő kell adniuk a projektedet!

### Kerüld el a névütközést

[Ellenőrizd a hasonló nevű, nyílt forráskódú projekteket](http://ivantomic.com/projects/ospnc/), különösen akkor, ha ugyanaz a fejlesztői nyelv vagy ökoszisztéma érintett. Ha a neve átfed egy népszerű, meglévő projektével, akkor az zavart okozhat.

Ha weboldalt akarsz, vagy Twitter bejegyzéseket, vagy egyéb dolgot, amely a projektedet reprezentálja, akkor is legyél biztos a projekt nevében. Jó esetben [előre le kell foglalnod a domain nevet](https://instantdomainsearch.com/) a nyugalmad érdekében, még akkor is, ha most nem akarod használni.

Győződj meg róla, hogy a projekt neve nem sért védjegyeket. Egy vállalat kérheti később, hogy állítsd le a projekted, vagy akár jogi lépéseket is tehet ellened. Ez nem éri meg a kockázatot.

Ezen az oldalon [WIPO Global Brand Database](http://www.wipo.int/branddb/en/) tudod ellenőrizni a bejegyzett kereskedelmi neveket. Ha cégnél dolgozol, akkor ezt a [cég jogi osztálya is el tudja végezni](../legal/).

És végül, végezz egy gyors Google keresést a projekt nevével. Az emberek könnyen megtalálják majd a projektet? Van olyan dolog, ami a keresési eredményekben jelenik meg, és amit nem szeretnél ott látni?

### Ahogyan írsz (akár kódot is) az hatással van a brand-re!

A projekt élettartama alatt rengeteg írást készítesz: README-k, oktatóanyagok, közösségi dokumentumok, kérdésekre adott válaszok, talán még hírleveleket és levelezőlistákat is.

Akár hivatalos dokumentáció, akár alkalmi e-mail, az írási stílusa része a projekt brand-nek. Fontold meg, hogy az a hangnem, amit szeretnél közvetíteni, befogadható-e a közösségnek akiknek szánod.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Megpróbáltam részt venni a levelezőlista minden szálában, és példamutató magatartást mutatni, kedves voltam az emberekkel, komolyan vettem a kérdéseket, és általában mindenkinek segítettem. Egy idő múlva az emberek úgy kezdtek el viselkedni mint én, és nem csak kérdéseket tettek fel, hanem a válaszokat is adtak az én stílusomban, ennek nagyon örültem.
  <p markdown="1" class="pquote-credit">
— @janl [CouchDB](https://github.com/apache/couchdb), ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

A kedves, befogadó nyelv használatával jó úton jársz a projekt résztvevőinek megszerzésében és megtartásában. Használj egyszerű nyelvezetet, mivel sok olvasó nem feltétlenül angol (vagy a projekt nyelvnek megfelelő) anyanyelvű.

A viselkedési stílusodon túl, a kód stílusa is része lehet a projekt márkájának. [Angular](https://angular.io/guide/styleguide) és a [jQuery](https://contribute.jquery.org/style-guide/js/) két példa a szigorú kódolási stílusokkal, és iránymutatásokkal rendelkező projektekre.

Nem kell stílus útmutatót írni a projekthez, amikor éppen elkezdted, vagy ha esetleg különböző kódolási stílusokat használsz a projektben. De tisztában kell lenni azzal, hogy az írási és kódolási stílus hogyan vonzhatja, vagy riaszthatja el a különböző típusú embereket. A projekt legkorábbi szakasza lehetőséget ad arra, hogy meghatározd a kívánt mintát, amit elvársz a későbbiekben a résztvevőktől.

## Indulás előtti ellenőrző lista

Készen állsz a nyílt forráskódú projektre? Itt egy ellenőrzőlista, amely ebben segít. Leellenőrizted az összes pontot? Akkor készen állsz! [Válaszd a "publish" linket](https://help.github.com/articles/making-a-private-repository-public/) és indulhat a publikálás!

**Dokumentáció**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    Van LICENSE állomány, nyílt forráskódú licenccel
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    Van README, CONTRIBUTING és CODE_OF_CONDUCT állomány
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    A név könnyen megjegyezhető és utal a projektre hogy, mit csinál. A név nem ütközik más projekt nevével, vagy kereskedelmi, védjegy, esetleg márkanevekkel
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    Naprakész a hiba lista, amelyek átláthatóan vannak csoportosítva és címkézve
  </label>
</div>

**Code**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    A projekt konzisztens megjelenésű, ha kódot tartalmaz, akkor egységes a konvenció, és tisztán érthetőek a metódusok/függvények/változók nevei
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Az elgondolás, és a kivételek dokumentáltak, és a kód (ha van) szépen kommentezett
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Nincs érzéken, vagy titkos adat a git _history-ban,_ vagy a beolvasztási kérelmekben, mint például: jelszavak, nem publikus információk, üzleti titkok, személyes adatok (GDPR betartása)
  </label>
</div>

**Emberek**

Ha magánszemély vagy, akkor:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  Beszéltél a jogi osztállyal és/vagy megértetted a vállalatod és a közted lévő munkaszerződésed nyílt forráskódra vonatkozó politikáját (ha valahol alkalmazott vagy)
  </label>
</div>

Ha szervezet, vagy cég vagy, akkor:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Beszéltél a jogi osztállyal
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Van marketing terved a bejelentésre, és a projekt támogatására
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Van olyan ember, aki elkötelezett a közösségi interakciók kezelésében (válaszol a problémákra, a beolvasztási kérelmek felülvizsgálatára és beolvasztására)
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Legalább két adminisztrátora van a projektnek
  </label>
</div>

## Megcsináltad!

Gratulálunk, az első nyílt forráskódú projektedhez! Az eredménytől függetlenül a nyilvános munkád jelentős ajándék a közösségnek. Minden _commit_-tal, kommenttel és beolvasztási kérelemmel lehetőséget teremtettél magadnak és másoknak, hogy tanuljanak és fejlődhessenek.
