---
lang: hu
title: Hogyan lehet hozzájárulni a nyílt forráskódhoz
description: Szeretnél hozzájárulni a nyílt forráskódhoz? Ez egy útmutató a nyílt forráskódú fejlesztésekben történő részvételhez kezdők és haladók számára.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Miért vegyél részt a Nyílt Forráskódú fejlesztésben?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Amikor a \[freenode\]-on dolgoztam, akkor sok olyan jártasságot szereztem, amelyet később az egyetemi tanulmányaimban és a munkámban is használtam. Úgy gondolom, hogy a nyílt forráskódon végzett munka legalább annyira segít engem, mint a projektet!
  <p markdown="1" class="pquote-credit">
— @errietta, ["Miért szeretek hozzájárulni a nyílt forráskódú projektekhez?"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

A nyílt forráskódhoz való hozzájárulás a tanulás, a tanítás és a tapasztalatok megszerzésének a legjobb útja bármiben, amit csak el tudsz képzelni.

Miért járulnak hozzá az emberek a nyílt forráskódhoz? Rengeteg oka van!

### Készségfejlesztés

Kódolás, felhasználói felület tervezése, grafikai tervezés, írás vagy akár szervezés – ha gyakorlatot keresel, akkor találsz feladatot nyílt forráskódú projekten.

### Találkozz hasonló érdeklődésű emberekkel

A nyílt forráskódú projektek befogadó, barátságos közösségek, ahová évek múlva is visszatérnek az emberek. Sokan egy egész életen át tartó barátságot kötnek a nyílt forráskódú részvételük révén, függetlenül attól, hogy konferenciákon vagy késő esti online beszélgetéseken ismerkednek-e meg.

### Keress mentorokat és taníts másokat

Közös projekten dolgozni másokkal azt jelenti, hogy el kell magyaráznod, hogy hogyan működnek a dolgok, vagy más embereket kell megkérned, hogy segítsenek. A tanításban és tanulásban minden résztvevő ki tud teljesedni.

### Növeld a hírnevedet és támogasd a karriered azzal, hogy közzéteszed a munkád

Alapértelmezés szerint minden nyílt forráskódú munka publikus, amit azt jelenti, hogy bárhol megjelenhetsz a munkáiddal bemutatva azt, hogy mire vagy képes.

### Emberi készségek fejlesztése

A nyílt forráskód számos kihívást tartogat a vezetői és szervezői készségek gyakorlásában, úgy mint konfliktus megoldás, csapatszervezés és a feladatok priorizálása.

### Lehetőséged van változtatni, még ha kicsit is

Ahhoz, hogy sikerélményed legyen egy nyílt forráskódú projektben, nem kell egy életen át részt venned a munkában. Láttál már valaha egy elgépelést egy weboldalon, és kívántad már azt, hogy valaki bárcsak kijavítaná? Egy nyílt forráskódú projektben éppen ezt tudod megtenni. A nyílt forráskód segít abban, hogy az emberek a saját életüket irányítsák és azt, hogy hogyan alakítsák a világot a maguk örömére.

## Mit jelent a hozzájárulás?

Ha új vagy a nyílt forráskódban, akkor a folyamat először félelmetes lehet. Hogyan találd meg a jó projektet? Mi van, ha nem jól kódolsz? Mi történik, ha valami nem működik?

Ne aggódj! Rengeteg módja van annak, hogy részt vegyél a nyílt forráskódú fejlesztésekben, és számos tipp segít abban, hogy a legtöbbet hozd ki magadból.

### Nem kell kóddal hozzájárulnod

Gyakori tévhit a nyílt forráskódhoz való hozzájárulásról, hogy programozni kell hozzá. Valójában gyakran a projekt többi része az, amely [elhanyagolt, vagy mellőzött](https://github.com/blog/2195-the-shape-of-open-source). Óriási segítség a projektnek, ha ilyen jellegű munkával járulsz hozzá!

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Híres vagyok a CocoaPods-szal végzett munkámról, de a legtöbb ember nem is tudja, hogy nem is dolgozom magán a CocoaPods kódján. Az időm nagy részét a projekten dokumentációval és márkaépítéssel töltöm.
  <p markdown="1" class="pquote-credit">
— @orta, ["Természetes az OSS-re való átállás"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Még ha szeretsz is programozni, akkor is nagyszerű módja a projektben való részvételnek vagy hogy találkozz közösségi tagokkal az, hogy más jellegű hozzájárulásod van a projekthez. Ezeknek a kapcsolatoknak a kiépítése lehetőséget teremt arra, hogy a projekt egyéb részein dolgozz.

### Szeretsz rendezvényt szervezni?

* Szervezz gyakorlati előadásokat vagy találkozókat a projektről, [ahogy @fzamperin csinálja a NodeSchool-nál](https://github.com/nodeschool/organizers/issues/406)
* Szervezd meg a projekttel kapcsolatos konferenciát (ha van ilyen)
* Segíts a közösség tagjainak megtalálni a megfelelő rendezvényeket és írj javaslatokat az előadások témáira

### Szereted a grafikai tervezést?

* Alakítsd át a megjelenést, hogy a projekt jobban áttekinthető legyen
* Végezz felhasználói igényfelmérést, hogy javítsd vagy finomítsd a projekt oldal navigációját vagy menürendszerét, [például ahogy a Drupal javasolja](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Állíts össze egy stílus útmutatót ezzel segítve az egységes vizuális megjelenést
* Készíts póló terveket vagy új logót, [ahogy a hapi.js fejlesztői tették](https://github.com/hapijs/contrib/issues/68)

### Szeretsz írni?

* Írd és javítsd a projekt dokumentációját
* Tarts karban egy példa könyvtárat a projekt használatáról
* Indíts hírlevelet a projektről, vagy a levelező listáról készít összefoglalót
* Írj útmutatókat a projektről, [ahogy PyPA fejlesztői tették](https://packaging.python.org/)
* Fordíts le a projekt dokumentációját

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Komolyan: a \[dokumentáció\] rendkívül fontos. A dokumentáció eddig is nagyszerű volt, és továbbra is a Babel legütősebb része. Biztosan vannak azonban olyan bekezdések, amin lehetne még dolgozni és akár egy bekezdés hozzáadása is nagyon értékes munka.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Részvételre való felhívás"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Szeretsz szervezni?

* Kapcsold össze a duplikált hibajegyeket és javasolj más címkéket, hogy jobban szervezett legyen a projekt
* Nézd át a nyitott hibajegyeket és javasold a régiek lezárását, [ahogy @nzakas csinálta az ESLint esetén](https://github.com/eslint/eslint/issues/6765)
* Tegyél fel tisztázandó kérdéseket a közelmúltban megnyitott felvetésekről, problémákról a vita előmozdítása érdekében

### Szeretsz kódolni?

* Keress nyitott problémákat, amelyeket megoldhatsz, [mint ahogy @dianjin csinálta a Leaflet esetén](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Kérdezd meg, hogy tudsz-e segíteni valamely új funkció kifejlesztésében
* Automatizáld a projektet
* Fejleszd az eszközöket és a teszteket

### Szeretsz segíteni embereken?

* Válaszolj a projekttel kapcsolatos kérdésekre, például a StackOverflow-n, ([mint ez a Postgres példa](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) vagy a Reddit-en
* Válaszold meg a kérdéseket a nyitott problémákról
* Segíts moderálni a beszélgetést a fórumokon vagy egyéb csatornákon

### Szeretsz másoknak segíteni a kódolásban?

* Nézd át más emberek kódját, amellyel a projekthez járulnak hozzá
* Írj útmutatót arról, hogyan kell a projektben dolgozni
* Ajánld fel a segítségedet a kódolásban résztvevőnek, légy mentor [mint ahogy @ereichert csinálta @bronzdoc esetén a Rust projektben](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Nem csak szoftver projekten tudsz dolgozni!

Bár a "nyílt forráskód" gyakran szoftverre utal, bármi másban is részt tudsz venni. Vannak könyvek, receptek, válogatott listák és útmutatók, amelyeket nyílt forráskódú projektként fejlesztenek.

Például:

* @sindresorhus karbantart egy [listát a nagyszerű dolgokat listázó oldalakról](https://github.com/sindresorhus/awesome)
* @h5bp kezeli [a listát a lehetséges munkainterjú kérdésekről](https://github.com/h5bp/Front-end-Developer-Interview-Questions) a front-end fejlesztő jelölteknek
* @stuartlynn és @nicole-a-tesla készített egy [gyűjteményt az északi madarak érdekességeiről](https://github.com/stuartlynn/puffin_facts)

Még ha szoftverfejlesztő is vagy, egy dokumentációs projekt könnyebbé teszi az elindulást a nyílt forráskód világában. Kevésbé ijesztő, ha olyan projektben veszel részt először, ami nem tartalmaz kódot és a másokkal való együttműködés folyamán alakul ki az önbizalmad és nő a tapasztalatod.

## Kezdetek egy új projektben

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Ha megnyitsz egy hibakövető rendszert és a dolgok furának tűnnek, akkor ezzel nem vagy egyedül. Ezek használatához ismerned kell a projektet, de ebben a többi résztvevő tud segíteni, irányt mutatni, csak kérdezned kell.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["Hogyan vegyél részt Nyílt Forráskódú projektben"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Bármi más dolog, mint mondjuk egy elírás javítása olyan, mintha idegenekkel állnál le beszélgetni. Ha elkezdesz a lámákról beszélni, miközben ők elmélyedt párbeszédet folytatnak az aranyhalakról, akkor lehet kicsit furán fognak rád nézni.

Mielőtt vakon javasolnál valamit, próbálj elmélyedni a témában, hogy megértsd azt. Ha így teszel, nagyobb eséllyel figyelnek oda a véleményedre és javaslataidra.

### Egy nyílt forráskódú projekt anatómiája

Minden nyílt forráskódú közösség más.

Éveket eltölteni ugyanazzal a nyílt forráskódú projekttel azt jelenti, hogy ismersz egy nyílt forráskódú projektet. Egy másik projekt esetén teljesen más fogalmakkal, viselkedési normákkal és kommunikációs módszerekkel találkozhatsz.

Ugyanakkor számos nyílt forráskódú projekt hasonló módon működik. Az eltérő közösségi szerepek vagy folyamatok megértése segít abban, hogy gyorsan alkalmazkodni tudj bármely új projekthez.

Egy tipikus nyílt forráskódú projekt esetén az alábbi szerepek vannak:

* **Szerző:** Személy(ek), esetleg szervezet, aki létrehozta a projektet
* **Tulajdonos:** Személy(ek), akinek adminisztrációs joga van a szervezet vagy a nyílt forrás felett (nem mindig egyezik a Szerzővel a személye)
* **Karbantartók:** Olyan résztvevők, akiknek felelőssége a projekt irányítása, az elképzelések formába öntése. (Ők lehetnek akár a Szerzői vagy a Tulajdonosai is a projektnek.)
* **Közreműködők:** Bárki, aki hozzájárul valamivel a projekthez.
* **Közösség tagjai:** Emberek, akik használják a projektet. Aktívak lehetnek a vitákban, vagy jelezhetik észrevételeiket a projekttel kapcsolatban.

A nagyobb projekteknek lehetnek olyan albizottságai vagy munkacsoportjai is, amelyek különböző feladatokra összpontosítanak, mint például eszközök, prioritás, közösségi moderálás és rendezvényszervezés. Ezt az információt megtalálod a projekt honlapján a "csapat" oldalon, vagy a működési szabályok dokumentációi között.

A projektnek dokumentációja is van. Ezek a fájlok általában a forráskód legfelső szintjén vannak felsorolva.

* **LICENSE:** Alapértelmezés szerint minden nyílt forráskódú projektnek kell rendelkeznie egy [nyílt forráskód licenccel](https://choosealicense.com). Ha a projektnek nincs ilyen licence, akkor az nem nyílt forráskód.
* **README:** A README egy használati útmutató a közösség új tagjainak. Elmagyarázza, hogy miért hasznos a projekt és hogy hogyan lehet használni.
* **CONTRIBUTING:** Míg a README segíti az embereket a _használatban_, addig a CONTRIBUTING a projektben való _részvétel_ módját dokumentálja. Elmagyarázza, hogy mivel járulhatsz hozzá a projekthez és hogyan működnek a folyamatok. Bár nem minden projektnek van ilyen dokumentációja, a jelenléte azt mutatja, hogy számítanak a részvételedre és a hozzájárulásodra.
* **CODE_OF_CONDUCT:** Magatartási kódex, amely meghatározza a résztvevők magatartásának alapszabályait és elősegíti a barátságos környezet kialakítását. Bár nem minden projektnek van ilyen dokumentációja, a jelenléte azt mutatja, hogy barátságos projekt, amely számít a részvételedre.
* **Egyéb dokumentációk:** Lehetnek további dokumentációk, különösen nagyobb projektek esetén, mint például oktató anyagok, fejlesztési útmutatók, irányítási szabályok.

A nyílt forráskódú projektek az alábbi eszközöket használják az egyeztetések szervezéséhez. A korábbi anyagok elolvasása jó képet ad arról, hogyan gondolkodik és működik a közösség.

* **Issue tracker:** A résztvevők ennek segítségével beszélik meg a projekttel kapcsolatos problémákat.
* **Pull requests:** A résztvevők ezek segítségével vitatják meg és tekintik át a folyamatban lévő változtatásokat.
* **Internetes fórumok vagy levelező listák:** Néhány projekt használhatja ezen csatornákat is a különböző témák átbeszélésére (például, _"Hogyan tudom...?"_ vagy _"Mit gondolsz arról, hogy...?"_ című témát indít a _hiba jelentés,_ vagy _új funkció létrehozása_ helyett). Mások minden beszélgetést az _Issue tracker_-en keresztül kezelnek.
* **Csevegő csatorna:** Néhány projekt azonnali üzenetküldő (IM) csevegő csatornákat használ (mint amilyen a Slack vagy az IRC) általános beszélgetésre, együttműködésre és gyors üzenet váltásra.

## Találd meg a projektedet!

Most, hogy már tudod, hogy hogyan működnek a nyílt forráskódú projektek, itt az idő megtalálni azt, amelyben részt veszel!

Ha még sohasem vettél részt nyílt forráskódú fejlesztésben korábban, akkor fogadd meg John F. Kennedy volt amerikai elnök egyik tanácsát: _"Ne azt kérdezd, hogy az ország mit tud tenni érted – kérdezd azt, hogy te mit tehetsz az országért."_

Hozzájárulás egy nyílt forráskódú projekthez bárhogy lehetséges, bármelyik projektben. Nem kell túlgondolni azt, hogy pontosan mi lesz az első hozzájárulásod, vagy azt, hogy az hogyan fog kinézni.

Gondolkozz olyan projektben, amelyet már használsz, vagy használni akarsz. Azokat a projekteket, amelyekben aktívan részt veszel, szívesebben használni fogod a jövőben is.

Ezekben a projektekben, amikor azon kapod magad, hogy gondolkozol egy jobb vagy más megoldásban, cselekedj ösztönösen!

A nyílt forráskód nem egy zártkörű klub; ugyanolyan emberek dolgoznak rajta, mint te. A "Nyílt Forráskód" csak egy divatos kifejezés arra, hogy a világ problémáit megoldhatóként is lehet kezelni.

Talán épp a README-t olvasod és találsz egy rossz hivatkozást, vagy egy elírást. De az is lehet, hogy új felhasználó vagy és észreveszel valami hibát, vagy egy problémát, amit dokumentálni kellene. Ahelyett, hogy nem törődsz vele és továbblépsz vagy megkérsz valakit, hogy javítsa, inkább ajánld fel a segítséged. Ez az amiről a nyílt forráskód szól!

> [a nyílt forráskódú alkalmi hozzájárulások 28%-a](https://www.igor.pro.br/publica/papers/saner2016.pdf) a dokumentációt érinti, mint például egy elírás javítása, formázás, vagy fordítás.

Ha szeretnél egy hibát javítani, akkor minden nyílt forráskódú projekt esetén találsz egy `/contribute` oldalt, amely segít abban, hogy kezdőként kijavítsd az első hibát. A projekt GitHub kezdőoldal URL-jét egészítsd ki a `/contribute` résszel a végén, (például [`https://github.com/facebook/react/contribute`](https://github.com/facebook/react/contribute)).

Az alábbiakban találsz néhány oldalt, amelyek segítenek abban, hogy felfedezd és megtaláld az új projektedet:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)

### Egy ellenőrző lista, mielőtt részt vennél a projektben

Ha találtál egy projektet, amelyhez hozzájárulnál, végezz előtte egy gyors ellenőrzést. Bizonyosodj meg arról, hogy alkalmas-e a külső hozzájárulások fogadására. Máskülönben előfordulhat, hogy a kemény munkádnak nem lesz eredménye.

Itt egy lista, aminek segítségével kiértékelheted, hogy a projekt alkalmas-e egy új résztvevőnek.

**Megfelel a nyílt forráskód definíciójának**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  Van nyílt forráskódú licence? Gyakran ez a LICENSE nevű állomány a projekt főkönyvtárában.
  </label>
</div>

**A projekt aktívan fogadja a hozzájárulásokat**

Nézd meg a közösség aktivitását a _master_ ágon. A GitHub-on ezeket az információkat a projekt főoldalán eléred.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  Mikor volt az utolsó kód változás (commit)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Hány résztvevője van a projektnek?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  Milyen gyakran módosítják a kódot a résztvevők? A GitHub-on, a képernyő felsőrészén a _"Commits"_ linkre klikkentve ezt eléred.
  </label>
</div>

Nézd meg a projekt hibakezelőjét.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Mennyi nyitott hibajegy van?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    A projekt karbantartói gyorsan reagálnak egy új hibajelzésekre?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Van párbeszéd a hibákról, észrevételekről?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Frissek a hibakezelőben szereplő hibák vagy észrevételek?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    A hibák, észrevételek megoldásra kerülnek? A GitHub-on, az _Issues_ fül kiválasztása után a szürke _closed_ linkre klikkentve látod a lezárt hibákat.
  </label>
</div>

Most csináljuk meg ugyanezt a projekt kódbeolvasztási kéréseire (_pull request_).

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Mennyi nyitott kódbeolvasztási kérés van?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    A karbantartók gyorsan reagálnak egy új kódbeolvasztási kérésre?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Van-e aktív párbeszéd a kódbeolvasztási kérésekről?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Frissek a kód beolvasztási kérések?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Mennyire régen vezettek át kódbeolvasztási kérést a kódon? A GitHub-on, a _Pull Requests_ fülön klikkents a szürke _closed_ linkre hogy lásd, mennyi beolvasztási kérés került lezárásra.
  </label>
</div>

**Barátságos projekt**

Egy barátságos és befogadó projekt azt jelzi, hogy az új résztvevőket szívesen várják.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    A karbantartók segítőkészen válaszolnak a problémákkal kapcsolatos kérdésekre?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    A résztvevők barátságosak a problémákról szóló párbeszédekben, a fórumokon és csevegésekben?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    A beolvasztási kéréseket áttekintik, felülvizsgálják?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    A karbantartók megköszönik a hozzájárulásokat?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  Bármikor amikor hosszú beszélgetést látsz, keresd meg a fő fejlesztők hozzászólásait. Konstruktívak, és előre mozdítják a döntéshozatalt, miközben udvariasak maradnak? Ha sok hitvitát látsz, az gyakran annak a jele, hogy az energia az érvelésre megy el és nem a fejlesztésre.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Hogyan kell hozzájárulni?

Végül megtaláltad a projekted és készen állsz a részvételre! Nézzük, hogyan tudsz valóban jól hozzájárulni!

### Hatékony kommunikáció

Akár csak egyszeri résztvevő vagy, vagy csatlakoznál a közösséghez, a másokkal való együttműködés az egyik legfontosabb képesség, amit a nyílt forráskódú munkád során fejleszteni tudsz.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[Mint új résztvevő,\] gyorsan észrevettem azt, hogy kérdéseket kell feltennem, ha a végére akarok járni egy problémának. Átrágtam magam a kódon és amint némileg megértettem, hogy hogyan működnek a dolgok, további iránymutatást kértem. És _voilà!_ meg tudtam oldani a problémát, miután megkaptam a szükséges részleteket.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [A Beginner's Very Bumpy Journey Through The World of Open Source](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

Mielőtt hibát jelzel, beolvasztást kérelmezel vagy esetleg kérdéseket teszel fel a csevegésben, tartsd szem előtt ezeket a pontokat a hatékonyabb munka érdekében.

**Add meg a téma leírását!** Ezzel segítesz másoknak, hogy gyorsan felvegyék a téma fonalát. Ha belefutsz egy hibába, akkor magyarázd el részletesen hogyan idézted azt elő, és hogy hogyan lehet reprodukálni. Ha új ötlettel állsz elő, magyarázd el, hogy miért gondolod úgy, hogy az hasznos lesz a projektnek (és nem csak neked)?

> 😇 _"X nem történik, ha azt csinálom, hogy Y"_
>
> 😢 _"X hibás! Kérlek, javítsátok!"_

**Először végezd el a házi feladatot!** Teljesen rendben van ha nem értesz dolgokhoz, de mutasd meg azt, hogy megpróbáltad! Mielőtt segítséget kérsz, győződj meg róla, hogy átnézted a projekt README-jét, dokumentációját, nyitott és lezárt hibajelzéseit, a levelező listát és keress rá a problémára az interneten. Az emberek értékelni fogják, ha látják, hogy próbálsz tanulni.

> 😇 _"Nem vagyok benne biztos, hogy hogyan oldjam meg az X dolgot. Átnéztem az útmutatókat, de nem találtam erről említést."_
>
> 😢 _"Hogyan csináljam meg az X dolgot?"_

**Légy tömör és egyértelmű!** Hasonlóan az email küldéséhez, minden hozzájárulás esetén szükséges az – függetlenül attól, hogy mennyire egyszerű vagy mennyit segít –, hogy más is átnézze. Számos projektnek több beérkező módosítási igénye van, mint ahányan dolgoznak rajta. Ezért az észrevételeid legyenek tömörek és egyértelműek, így nagyobb eséllyel kapsz segítséget.

> 😇 _"Szeretnék írni egy API útmutatót."_
>
> 😢 _"Épp vezettem az autópálya lehajtón egy nap és megálltam tankolni, és ekkor egy hatalmas ötlet jutott az eszembe, amit meg kellene csinálnunk, de mielőtt elmagyaráznám, hadd meséljek a ..."_

**Legyen nyilvános a kommunikációd!** Bár csábító, de a karbantartókat ne privát csatornákon keresd; kivéve, ha érzékeny információt (biztonsági incidens, komoly viselkedési szabályok megsértése) kell megosztanod. Ha a kommunikáció publikus, akkor több ember tud tanulni belőle, mindenkinek hasznára válik. A publikus megbeszélések már önmagukban is hozzájárulások a projekthez.

> 😇 _(megjegyzésként:) "@-karbantartó Szia! Mi legyen ennek a Pull Request-nek a sorsa?"_
>
> 😢 _(emailként:) "Szia! Sajnálom, hogy a levelemmel zavarlak, de kíváncsi lennék rá, hogy van-e esély a Pull Requestem beolvasztására?"_

**Rendben van, hogy kérdezel, de legyél türelmes!** Mindenki volt kezdő az adott projekten, még a gyakorlott résztvevőknek is fel kell venni a tempót egy új projekt esetén. Ugyanígy, még a régebbi karbantartók sem mindig ismerik a projekt minden részét. Légy velük olyan türelmes, mint amilyet te is elvárnál tőlük.

> 😇 _"Köszönöm, hogy megnézted ezt a hibát. Követtem az utasításaidat, itt a végeredménye:"_
>
> 😢 _"Miért nem javítod a jelzett problémámat? Ez nem a te projekted?"_

**Tartsd tiszteletben a közösség döntéseit!** Az ötleteid eltérhetnek a közösség céljaitól vagy jövőképétől. Ötleteidre kaphatsz visszajelzést, vagy akár el is utasíthatják azt. Míg lényeges, hogy egyeztess és keresd a kompromisszumot, tartsd észben, hogy a karbantartóknak a hosszabb távon kell a te döntéseddel együtt élni, mint neked. Ha nem értesz egyet az iránnyal, bármikor létrehozhatod a saját elágazásodat (_fork_) a kódból, vagy akár kezdhetsz egy új projektet.

> 😇 _"Bár szomorú vagyok, hogy nem támogatjátok az ötletemet, de ahogy elmagyaráztátok, megértettem azt, hogy ez az eset csak kevés embert érint. Köszönöm, hogy meghallgattatok!"_
>
> 😢 _"Miért nem támogatjátok az ötletem? Ez elfogadhatatlan!"_

**Mindenekelőtt: ne légy ízléstelen!** A nyílt forráskódon együttműködők a világ számos részéről származnak. A kontextus gyakran elveszik a nyelvi-, kulturális-, földrajzi- és időzóna különbségek miatt. Ráadásul az írott kommunikáció megnehezíti a hangulat vagy a hozzászólás érzelmi részének közvetítését. Tételezz fel jó szándékot a beszélgetésekben. Teljesen elfogadható, ha udvariasan visszautasítasz egy ötletet, vagy megkérsz valakit, hogy adjon további információt a problémáiról. Próbáld az Internetet tisztábban ott hagyni, mint ahogy találtad.

### Összefoglalás

Mielőtt bármibe belekezdenél, győződjön meg róla, hogy az ötletedet nem vitatták-e már meg máshol. Nézd meg a projekt README-jét, a nyitott és lezárt hibajegyeket és kérdéseket, a levelezőlistát és a StackOverflow-t. Nem kell órákat töltened azzal, hogy átnézz mindent, de egy gyors keresés néhány kulcsszóra nem tart semeddig.

Ha nem találod meg a felvetést sehol, akkor mehetsz tovább. Ha a projekt a GitHub-on van, akkor nyithatsz egy hibajegyet vagy létrehozhatsz egy beolvasztási kérést a módosított kód alapján:

* **Issues** (hiba, észrevétel) olyanok mint egy párbeszéd, vagy egy megbeszélés
* **Pull requests** (beolvasztási kérelem) szolgál a munka megkezdésére
* **Egyszerű kommunikációra,** például tisztázó- vagy a "Hogyan..." kérdésekre használd a StackOverflow-t, IRC-t, Slack-et vagy egyéb rendelkezésre álló csevegő csatornát, ha van ilyen a projektben

Mielőtt hibajegyet, észrevételt vennél fel, vagy egy beolvasztási kérelmet benyújtanál, ellenőrizd a projektben való részvételről szóló dokumentációt (ezt gyakran a CONTRIBUTING vagy a README tartalmazza), mert lehetséges, hogy mellékelned kell valamilyen specifikus információt is. Például, a projekt kérheti azt, hogy egy űrlapot tölts ki, vagy megkövetelheti a teszteket.

Ha jelentősebb munkával akarsz részt venni, akkor nyiss egy probléma felvetést tartalmazó jegyet, ahol a kérdéseket meg lehet vitatni, mielőtt még nekikezdenél. Hasznos, ha egy darabig csak nyomon követed a projektet és a közösséget (a GitHub-on, [klikkents a "Watch" linkre](https://help.github.com/articles/watching-repositories/) hogy értesítést kapj az összes beszélgetésről), hogy megismerd a tagjait, mielőtt olyan munkát végeznél benne, amit nem fogadnak el.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Rendkívül <em>sokat</em> fogsz tanulni egy projektből, amelyen aktívan részt veszel azzal, hogy "figyeled" a GitHub-on és olvasod az összes megnyitott kérdést és beolvasztási kérelmet.
<p markdown="1" class="pquote-credit">
— @gaearon [on joining projects](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Hibajegy nyitása

Általában a következő helyzetekben kell hibajegyet (_Issue_) nyitni:

* Hiba jelentése, amelyet nem tudsz megoldani egymagad
* Magas szintű probléma vagy téma, esetleg ötlet megbeszélése (például: közösség, vízió vagy szabályok)
* Új funkció javasolása, vagy más projekt célok, ötletek

Tippek a jó párbeszédhez:

* **Ha nyitsz egy hibajegyet, amit meg szeretnél oldani,** kommenteld azt, így más is tudja, hogy foglalkozol vele. Így mások nem dolgoznak ugyanezen feleslegesen.
* **Ha a hibajegy már régóta nyitott,** akkor lehetséges, hogy már máshol foglalkoznak vele, vagy már meg van oldva, így célszerű egy kommentben megkérdezni az állapotát, mielőtt elkezdesz rajta dolgozni.
* **Ha nyitottál egy hibajegyet és később magadtól rájöttél a megoldásra,** akkor kommentezz, hogy más is megismerje azt, majd zárd le a hibajegyet. Az eredmény dokumentálása is nagyon fontos a projektnek.

### Beolvasztási kérelem megnyitása

Általában a következő esetekben szükséges beolvasztási kérelmet nyitni:

* Triviális javítások küldése (például egy gépelési hiba, hibás link vagy nyilvánvaló hiba)
* Olyan feladaton történő munka elkezdése, amelyet már a közösség kitárgyalt, átbeszélt és tisztáztad a kérdéseket

A beolvasztási kérelem nem feltétlen jelent befejezett munkát. Gyakran jobb korán megnyitni ezt, így mások megfigyelhetik és visszajelzéseket adhatnak róla. Csak jelöld meg "WIP" (Work in Progress) jelzéssel a tárgy soron. Ezek után bármikor, szabadon adhatsz hozzá új kódot (commit és push).

Ha a projekt a GitHub-on van, akkor a következőképpen kell beolvasztási kérelmet benyújtani:

* **[Ágaztasd (fork) el a kód tározót](https://guides.github.com/activities/forking/)** és klónozd le magadhoz lokálisan. A lokális másolatodat kapcsold az eredeti tárolóhoz (original "upstream") egy _remote_ hozzáadásával. Frissítsd minél gyakrabban a változásokat az "upstream"-ről, hogy naprakész maradj. Így beolvasztás esetén kisebb eséllyel lesz ütközés a kódok összefésülésekor. (Részletes instrukciókat [itt találsz](https://help.github.com/articles/syncing-a-fork/).)
* **[Hozz létre egy új ágat (branch)](https://guides.github.com/introduction/flow/)** a módosításaidhoz.
* **Hivatkozz meg bármilyen releváns hibajegyet** vagy a dokumentációt a beolvasztási kérelmedben (például, "Closes #37.")
* **Adj hozzá a kérelmedhez "előtte" és "utána" képernyőképeket** ha HTML/CSS változás történt. Húzd be a képeket a beolvasztási kérelembe.
* **Teszteld a változtatásokat!** Mindig futtasd le a meglévő teszteket a kódodon, vagy írj újakat ha szükséges. Függetlenül a tesztektől bizonyosodj meg arról, hogy a módosításod nem rontja-e el a projektet.
* **A módosításaidnál alkalmazkodj a projekt kódolási stílusához** a legjobb tudásod szerint. Ez jelentheti azt, hogy más sorbehúzást kell használni a szövegben, lehet hogy a projekt használ pontosvesszőt, de te nem szoktál, vagy másként írják a kód kommenteket, mint ahogy te szoktad. Ha ezt betartod, a karbantartóknak könnyebb a kódot összefésülni (merge), másoknak pedig karbantartani és megérteni azt.

Ha ez lesz az első beolvasztási kérelmed (Pull Request), akkor nézd ezt meg előtte: [Make a Pull Request](http://makeapullrequest.com/), amelyben @kentcdodds egy részletes videó anyagot készített. A beolvasztási kérelmek benyújtását a @Roshanjossey által készített [First Contributions](https://github.com/Roshanjossey/first-contributions) GitHub projekten is gyakorolhatod.

## Mi történik miután beküldted a kész beolvasztási kérelmedet?

Megcsináltad! Gratulálunk, a nyílt forráskód résztvevője lettél. Reméljük ezt az első lépést majd még számos követi.

Miután beküldted a végleges hozzájárulásod a projekthez, a következők történhetnek:

### 😭 Nem kapsz választ

Remélhetőleg [ellenőrizted a projekt aktivitását](#egy-ellenőrző-lista-mielőtt-részt-vennél-a-projektben) mielőtt csatlakoztál hozzá. Még egy aktív projekt esetén is előfordulhat, hogy nem kap választ azonnal a résztvevő.

Ha nem kapsz válasz egy hét alatt sem, akkor udvariasan, ugyanazon a szálon kérj meg valakit, hogy nézze át a munkádat, ez így elfogadható. Ha tudod, ki lenne ez a személy akkor meg is említheted őt a @-mention forma használatával.

**Soha** ne követlenül, privát csatornán lépj kapcsolatba ezzel a személlyel; emlékezz, a publikus kommunikáció az egyik fontos alapja a nyílt forráskódnak.

Ha az udvarias kérésedre sem reagált senki, akkor lehet, hogy soha nem is fog. Ez lehangoló lehet, de ne add fel, mindenkivel megtörténhet! Számos oka lehet annak, hogy nem kaptál választ, mint például olyan személyes problémák, körülmények, melyekre nincsen ráhatásod. Próbálj meg másik projektet találni, vagy más módon hozzájárulni a projekthez. Ez egy jó példa arra, hogy miért ne tegyél bele túl sok munkát, mielőtt a közösség többi tagja nem reagál az ötletedre.

### 🚧 Valaki módosítást kér a munkádon

Gyakran előfordul, hogy valaki módosítást kér a munkádon, amely lehet egy tisztázó kérdés, vagy egy kód módosítási igény.

Amikor valaki ilyet kér, reagálj rá, hiszen vette a fáradtságot és időt áldozott rá, hogy a munkádat áttekintse. Nagyon rossz gyakorlat az, ha beolvasztási kérelmedet leadtad és utána nem foglalkozol már vele. Ha nem tudod, hogy a kérést hogyan teljesíthetnéd, akkor kutass, olvass és ha szükséges kérdezz vagy kérj segítséget.

Ha már nincs többé időd, hogy a problémán dolgozz (például időközben több hónap eltelt és megváltoztak a körülményeid), akkor jelezd a karbantartók felé, hogy tudják ezt. Lehet, hogy valaki más örömmel átvenné a feladatot.

### 👎 Nem fogadták el a munkád

A munkádat végül vagy elfogadják, vagy nem. Remélhetőleg még nem tettél bele túl sok munkát. Ha nem vagy benne biztos, hogy miért utasították el a hozzájárulásodat, nyugodtan kérdezz és tisztázd az okokat. De végül mindig tartsd tiszteletben a döntést! Ne vitatkozz feleslegesen és ne légy ellenséges! Bármikor megteheted, hogy elágaztatod a projektet (fork) és a saját verziódon dolgozol, ha nem értesz egyet.

### 🎉 Elfogadták a munkád

Hurrá! Sikeresen hozzájárultál a nyílt forráskódhoz!

## Megcsináltad!

Legyen szó az első nyílt forráskódú munkádról, vagy arról hogy új módját keresed a hozzájárulásnak, reméljük adtunk egy kis inspirációt a cselekvéshez. Még ha nem is fogadták el a hozzájárulásodat, ne feledj el köszönetet mondani a karbantartóknak, hogy energiát szántak rád és a munkádra. A nyílt forráskódot épp olyan emberek alakítják mint te: egy hibajelzés, egy beolvasztási kérés (Pull Request), néhány komment, vagy csak egy egyszerű köszönet.
