---
lang: hu
title: Fizetés a nyílt forráskódú munkaért
description: Tartsd fenn a nyílt forráskódú projektedet azáltal, hogy pénzügyi támogatókat szerzel.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Miért keresünk pénzügyi támogatást?

A legtöbb nyílt forráskódú munka önkéntes. Például, ha valaki találkozik egy hibával egy projektben amelyet használ, akkor gyors javítást nyújt be, vagy szabadidejében a nyílt forráskódú projektet javítgatja.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Kerestem egy hobbi projektet, amivel a Karácsonyi szabadságom alatt elfoglalhatom magam. (...) Volt egy PC-m, de azon kívül más nem nagyon. Gondoltam írok egy értelmezőt ahhoz a programnyelvhez, amin már régóta gondolkodtam. (...) Akkor választottam a Python nevet.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Számos oka lehet annak, hogy valaki nem akar fizetést a nyílt forráskódú munkájáért.

* **Lehet, hogy már főállásban dolgozik, amit szeret,** és ami lehetővé teszi, hogy szabadidejében nyílt forráskódon is dolgozhasson.
* **Hobbiként tekint a nyílt forráskódú fejlesztésre** vagy a kreatív szabadság kiteljesedéseként és nem akarja magát korlátozni.
* **Más előnye származik a nyílt forráskódú munkájából,** például a hírnév vagy portfólió építés, tanulás, vagy a közösségi munka öröme.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  A pénzügyi támogatás sok embernek felelősséget is jelent. (...) Számunkra viszont fontos, hogy a világszerte összekapcsolt, gyors tempójú világban, amelyben élünk, azt mondhassuk „ezt nem akarom, úgy érzem, hogy ezt teljesen másként szeretném csinálni”.
  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Mások számára, különösen, ha a hozzájárulásuk folyamatosak vagy jelentős időre van szükségük, a nyílt forráskódban való munkájuk megfizetése az egyetlen módja annak, hogy részt vehessenek benne, akár a projekt igényei, akár személyes okok miatt.

A népszerű projektek fenntartása jelentős felelősséggel járhat, havi néhány óra helyett akár heti 10 vagy 20 órát is igénybe vehet.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Kérdezz meg egy nyílt forráskódú karbantartót, és el fogja mondani, hogy a valóságban mennyi munkával is jár fenntartani a projektet. Vannak ügyfeleid. Végzel javításokat nekik. Létrehozol új funkciókat. Ez valós igény a te idődre és munkádra.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

A fizetett munka az élet különböző területein élő emberek számára is lehetővé teszi, hogy érdemi hozzájárulást nyújtsanak a projekthez. Egyesek nem engedhetik meg maguknak, hogy fizetetlen időt töltsenek a nyílt forráskódú projekteken a jelenlegi pénzügyi helyzetük, adósságuk, családi vagy egyéb gondoskodási kötelezettségeik miatt. Ez azt jelenti, soha nem jutnak el a világba azoknak a tehetséges embereknek a hozzájárulásai, akik nem engedhetik meg maguknak, hogy ingyen dolgozzanak. Ennek etikai következményei vannak, ahogy @ashedryden [írta](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), azoknak akiknek nincs szüksége pénzügyi támogatásra könnyebben végezhetnek nyílt forráskódú munkát, így azzal további előnyöket szerezhetnek, míg aki nem tud pénzügyi okokból ilyen munkát végezni, ezt az előnyt értelemszerűen nem is szerezheti meg, ezzel tovább erősítve a sokszínűség hiányát a nyílt forráskódú közösségben.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   Az OSS (nyílt forráskódú szoftver) jelentős előnyökkel jár a technológiai ipar számára, ami viszont minden iparág számára előnyöket jelent. (...) Ha azonban csak azok tudnak ezzel foglalkozni, akik szerencsések és megszállottak, hatalmas a kihasználatlan potenciál.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Ha pénzügyi támogatást keresel, akkor két irány lehet. Résztvevőként finanszírozhatod a saját idődet vagy találsz egy szervezetet, aki támogatja a projektet.

## Saját időnk finanszírozása

Ma sok embernek fizetnek részmunkaidőben vagy teljes munkaidőben nyílt forráskódú munkáért. A leggyakoribb módja annak, hogy fizessenek az idődért az, hogy megbeszéled a saját munkáltatóddal.

Egyszerűbb elérni ezt, ha az adott nyílt forráskódú projektet a munkaadód is használja. Lehet, hogy a munkaadód nem használja a projektet, de használja a Python-t, és egy népszerű Python projekt fenntartása segíti, hogy új Python fejlesztőket találjon a munkaadód. Ezzel a munkaadód még fejlesztő-barátabbnak tűnik.

Ha még nincs nyílt forráskódú projekted, amin dolgoznál, de szeretnéd, ha munkád eredménye nyílt forrású lenne, győzd meg a munkaadódat, hogy valamelyik belső projekt forráskódját tegye nyílttá.

Számos cég fejleszt nyílt forráskódú programokat azért, hogy az imázsukat javítsák és a tehetséges fejlesztőket megszerezzék.

@hueniverse, például úgy találta, hogy a pénzügyi okok miatt kezdett a [Walmart a nyílt forráskódba fektetni](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). És @jamesgpearce szerint a Facebook nyílt forráskódú programja [változtatott a munkaerő toborzáson](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon):

> Ez szorosan illeszkedik a fejlesztői kultúránkhoz és a szervezetünk megítéléséhez. Megkérdeztük a kollégáinkat, "Tudtad-e, hogy a Facebooknak vannak nyílt forráskódú projektjei?". Kétharmad válaszolt igennel. A megkérdezettek fele mondta azt, hogy ez jelentősen hozzájárult a döntésükhöz, hogy nálunk dolgozzanak! Ezek nem elhanyagolható számok, és remélem, hogy ez a trend folytatódik.

Ha a vállalatod ezt az utat választja, fontos, hogy a közösségi és a vállalati tevékenység jól elhatárolódjon. Végső soron a nyílt forráskód fenntartja saját magát a világ minden tájáról érkező emberek hozzájárulásaival, és ez jóval nagyobb, mint bármelyik vállalat vagy hely.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  A nyílt forráskódú munkádért fizetést kapni ritka és csodálatos lehetőség, de eközben nem kell lemondanod a szenvedélyedről. A szenvedélyed kell hogy legyen az, amiért a cégek meg akarnak fizetni téged.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Ha nem tudod meggyőzni a jelenlegi munkáltatót a nyílt forráskódú munka fontosságáról, fontold meg, hogy keresel egy új munkaadót, aki ösztönzi a munkavállalók hozzájárulását a nyílt forráskódhoz. Keress olyan cégeket, amelyek kifejezetten a nyílt forráskódú munkát támogatják. Például:

* Néhány cégnek, mint a [Netflix](https://netflix.github.io/), külön weboldala van, amin a nyílt forráskódú munkát támogatják
* [Zalando](https://opensource.zalando.com) publikálta a [nyílt forráskódban történő részvétel feltételeit](https://opensource.zalando.com/docs/using/contributing/) a munkavállalói számára

A nagy cégektől származó projektek, mint a [Go](https://github.com/golang) vagy a [React](https://github.com/facebook/react), szintén nagy valószínűséggel foglalkoztatnak embereket, hogy nyílt forráskódon dolgozzanak.

A személyes körülményeidtől függően megpróbálhatsz önállóan pénzt gyűjteni a nyílt forráskódú munkád finanszírozásához. Például:

* @Homebrew (and [many other maintainers and organizations](https://github.com/sponsors/community)) fund their work through [GitHub Sponsors](https://github.com/sponsors)
* @gaearon a [Redux](https://github.com/reactjs/redux) projektet egy [Patreon crowdfunding kampányon](https://redux.js.org/) keresztül finanszírozta (önkéntes támogatás)
* @andrewgodwin a Django schema migrációkat [egy Kickstarter kampányon keresztül](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django) finanszírozta.

Végül, néha a nyílt forráskódú projektek díjakat tűznek ki a hibák megoldására, amelyekkel kapcsolatban akár érdemes lehet segítséget nyújtani.

* @ConnorChristie fizetséget kapott azért, mert [segített](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol -nak a JavaScript könyvtár fejlesztésében, mindezt a [gitcoin rendszeren keresztül](https://gitcoin.co/).
* @mamiM elvégezte a japán nyelvi fordítást @MetaMask részére, melyet [a Bounties Network-ön keresztül finanszíroztak](https://explorer.bounties.network/bounty/134).

## Találd meg a projekt finanszírozását

Az egyéni közreműködőkkel történő megállapodásokon túl, a projektek néha pénzt szereznek vállalatoktól, magánszemélyektől vagy másoktól a folyamatban lévő munka finanszírozásához.

A szervezeti finanszírozás elkölthető a résztvevők támogatására, a projekt működtetésére (például a tárhely díjakra, hosztingra), illetve új funkciók vagy ötletek megvalósítására.

Miközben a nyílt forráskód népszerűsége növekszik, a projektek finanszírozásának megtalálása még mindig kísérleti jellegű, de azért van pár elterjedt lehetőség.

### Szerezz pénzt a munkádhoz közösségi finanszírozási kampányok vagy szponzorálás révén

Könnyű szponzorokat találni, ha már erős közönséged vagy jó hírneved van, vagy ha nagyon népszerű a projekted.

Néhány példa:

* **[webpack](https://github.com/webpack)** magánszemélyektől és cégektől is támogatáshoz jut [az OpenCollective-en keresztül](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** egy non-profit szervezet, amely támogatja a [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), és egyéb Ruby infrastruktúra projekteket

### Hozz létre bevételi forrást

A projektedtől függően kérhetsz támogatást szupportért, új funkcióért, vagy szolgáltatásért. Néhány példa:

* **[Sidekiq](https://github.com/mperham/sidekiq)** kínál fizetős verziót támogatásért cserébe
* **[Travis CI](https://github.com/travis-ci)** kínál fizetős verziót privát használatra
* **[Ghost](https://github.com/TryGhost/Ghost)** alapvetően non-profit, de a felügyelt szolgáltatásért fizetni kell

Néhány híres projekt, mint az [npm](https://github.com/npm/cli) és a [Docker](https://github.com/docker/docker), még kockázati tőkét is bevontak a növekedés finanszírozásához.

### Jelentkezz pályázatokra

Egyes szoftveralapítványok és cégek támogatást nyújtanak a nyílt forráskódú munkákhoz. Előfordul, hogy a támogatásokat magánszemélyek is megkaphatják anélkül, hogy jogi személyt hoznának létre a projekthez.

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** támogatást kapott a [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)-tól
* **[OpenMRS](https://github.com/openmrs)** támogatásban részesült a [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees) által
* **[Libraries.io](https://github.com/librariesio)**  támogatást kapott a [Sloan Foundation](https://sloan.org/programs/digital-technology)-től
* A **[Python Software Foundation](https://www.python.org/psf/grants/)** támogatást kínál a Python-hoz kapcsolódó projekteknek

Ha érdekelnek a lehetőségek vagy esettanulmányok részletesebben, @nayafia [írt egy útmutatót](https://github.com/nayafia/lemonade-stand), hogy hogyan juthatunk pénzhez a nyílt forráskódú munkával.
A különböző finanszírozási lehetőségek különböző képességeket igényelnek, a választásnál vedd figyelembe az erősségeidet.

## Pénzügyi támogatás kiépítése

Függetlenül attól, hogy a projekted új ötlet-e, vagy már évek óta létezik, készülj arra, hogy jelentős figyelmet kell fordítanod a lehetséges támogatók megtalálására és meggyőzésére.

Akár a saját időd finanszírozására, akár a projekted részére gyűjtesz támogatást, meg kell tudnod válaszolni a következő kérdéseket.

### Hatás

Miért olyan hasznos ez a projekt? Miért szeretik a felhasználók vagy a potenciális felhasználók a projektet? Hol fog tartani öt év múlva a projekt?

### Elfogadottság

Próbálj meg  tényeket gyűjteni arra vonatkozóan, hogy a projekt lényeges, legyenek számok, anekdoták vagy ajánlások. Vannak-e olyan cégek vagy ismert emberek, akik most is használják a projektet? Ha nincs ilyen, akkor van-e olyan prominens személy, aki pozitívan nyilatkozott róla?

### Érték a támogató részére

A finanszírozók, akár a munkáltatód, akár egy alapítvány, gyakran a lehetőségek irányából közelítik meg a támogatás kérdését. Miért kellene támogatniuk a projektedet a kihívások ellenére? Hogyan részesülnek a hozadékából, milyen előnyöket jelent számukra a támogatás?

### A támogatás felhasználása

Pontosan mit fogsz elérni a javasolt finanszírozással? Az emberek fizetése helyett inkább a projekt mérföldköveire vagy eredményeire összpontosíts.

### Hogyan kapod meg a támogatást

A támogatónak vannak kikötései a kifizetéssel kapcsolatosan? Például lehet, hogy non-profit vállalkozásnak kell lenned vagy rendelkezned kell egy non-profit támogatóval. Lehetséges, hogy csak magánszemélyt támogatnak, szervezeteket vagy cégeket nem. Az igények támogatónként eltérhetnek, ezért érdemes ezeket előre felderíteni.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  Évek óta a weboldal barát ikonok piacvezető forrása, több mint 20 millió ember részvételével, és több mint 70 millió webhelyen szerepelt, beleértve Whitehouse.gov oldalt is. (...) A v4 verzió 3 éves. Azóta a webes technológia sokat változott, és őszintén szólva, a Font Awesome egy kicsit elavult. (...) Épp ezért bevezettük a Font Awesome 5-öt. Modernizáljuk és újraírjuk a CSS-eket és újratervezünk minden ikont elejétől a végéig. Szebb megjelenésről, egységesebb kinézetről és jobb olvashatóságról beszélünk.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Kísérletezz és ne add fel

Pénzügyi támogatást kapni nem könnyű dolog, legyen szó nyílt forráskódról, non-profit szervezetről, vagy szoftver startupról, legtöbb esetben kreatívnak kell lenned. El kell döntened, hogyan szeretnéd a támogatást megkapni, kutatnod kell, és a támogató helyébe kell képzelned magad, hogy meggyőzhesd a támogatásról.

>
