---
lang: hu
title: Magatartási kódex
description: Az egészséges és konstruktív közösség építéséhez a magatartási kódex elfogadásával és érvényesítésével lehet hozzájárulni.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## Miért kell magatartási kódex?

A magatartási kódex egy olyan dokumentum, amelyben a viselkedéssel kapcsolatos elvárásokat fogalmazzák meg a projekt tagjai számára. A magatartási kódex elfogadásával és betartásával segítheted a közösség egészséges szociális légkörének kialakítását és megtartását.

A magatartási kódex nem csak a résztvevőket, téged is meg tud védeni. Karbantartóként találkozhatsz olyan lehangoló résztvevőkkel, akik a negatív hozzáállásukkal elkedvetlenítenek és elszívják az energiáidat.

A magatartási kódex lehetőséget ad arra, hogy az egészséges és konstruktív közösségi viselkedést megtarthasd. A pro-aktív viselkedésed segíthet abban, hogy te vagy a közösség tagjai elfásuljanak a projekteden, és fel tudsz lépni azok ellen, akik a kódex szabályait megsértik.

## A magatartási kódex létrehozása

Próbáld létrehozni a magatartási kódexet olyan korán amennyire csak lehet, ideális esetben a projekt indulásakor.

Az elvárásaid mellett a magatartási kódex az alábbiakat írja még le:

* Mire érvényes a magatartási kódex? _(csak a hibakövető rendszerre és beolvasztási kérelmekre, vagy más közösségi eseményekre, mint például rendezvények?)_
* Kikre vonatkozik a magatartási kódex? _(karbantartókra és közösségi tagokra, de vajon vonatkozik-e a szponzorokra?)_
* Mi történik, ha valaki vét a szabályok ellen?
* Hogyan kell jelenteni, ha szabálysértést tapasztal valaki?

Lehetőség szerint használj már létező, publikus dokumentumot. A [Contributor Covenant](https://contributor-covenant.org/) egy azonnal használható magatartási kódex, amelyet már több mint 40,000 nyílt forráskódú projekt használ, mint például a Kubernetes, Rails, és a Swift.

A [Django Code of Conduct](https://www.djangoproject.com/conduct/) és a [Citizen Code of Conduct](https://web.archive.org/web/20200330154000/http://citizencodeofconduct.org/) szintén nagyon jó minták.

Helyezd el a CODE_OF_CONDUCT állomány a projekt gyökérkönyvtárában, és hivatkozd meg őket a CONTRIBUTING és README állományokból, hogy mindenkinek látható legyen.

## Dönts arról, hogy fogod betartatni a szabályzatot

<aside markdown="1" class="pquote">
  Az a magatartási kódex, amelyet nem (vagy nem tudnak) betartatni rosszabb, mintha nem lenne: azt üzeni, hogy az értékek, amelyek benne megfogalmazásra kerültek nem fontosak és lényegtelenek a közösség számára.
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://webcache.googleusercontent.com/search?q=cache:YfqdTk5H9ikJ:https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community)
  </p>
</aside>

Magyarázd el részletesen, hogy a magatartási kódexnek hogyan szerzel érvényt, **mielőtt** még szabályszegés történne. Ez több szempontból előnyös:

* Megmutatja, hogy komolyan gondolod, hogy szükség esetén cselekszel.

* A közösség nyugodtabbnak fogja érezni magát, mert a panaszok ténylegesen felülvizsgálatra kerülnek.

* Meggyőzi a közösséget arról, hogy a felülvizsgálati folyamat tisztességes és átlátható, ha esetleg valakit felelősségre kell vonni a szabálysértés miatt.

Praktikus biztosítani egy privát csatornát (pl. e-mail cím), amin a magatartási kódex megsértését jelenteni tudják. Add meg azt is, hogy ki vagy kik kapják a jelentést. Ez lehet egy vagy több karbantartó, esetleg egy külön testület.

Ne feledd, előfordulhat, hogy épp olyan személyre vonatkozóan érkezik kifogás aki szintén kapja a jelentést. Ebben az esetben adj lehetőséget arra, hogy más személy részére jelentsék a szabálysértést. Például, @ctb és @mr-c [kifejtik ezt a projektjükben](https://github.com/dib-lab/khmer/blob/HEAD/CODE_OF_CONDUCT.rst), [khmer](https://github.com/dib-lab/khmer):

> A zaklató, erőszakos vagy egyéb elfogadhatatlan viselkedést emailben lehet jelenteni **khmer-project@idyll.org** címre, amelyet csak C. Titus Brown és Michael R. Crusoe kap meg. Ha bármelyikük érintett a szabálysértésben, akkor **Judi Brown Clarke, Ph.D.** Sokszínűségért Felelős Igazgató legyen a címzett.*

További inspirációért nézd meg a Django magatartás kódexét [enforcement manual](https://www.djangoproject.com/conduct/enforcement-manual/) (nem biztos hogy, ennyire részletes kódexre van szükséged, ez a projekt méretétől függ).

## A magatartási kódex érvényesítése

Annak ellenére, hogy mindent megtettél, néha előfordul, hogy valaki vét a szabályok ellen. Ekkor számos módja van a negatív vagy káros viselkedés kezelésének.

### Gyűjts információt a helyzetről

A közösség minden tagjának hangja ugyanolyan fontos, mint a tiéd. Ha olyan jelentést kapsz, hogy valaki megsértette a magatartási kódexet, akkor vedd komolyan és vizsgáld meg az ügyet, még akkor is, ha nem feltételezel ilyet az adott személyről. Ezzel jelzed a közösségnek, hogy értékeled a szempontjaikat és bízol az ítélőképességükben.

A szóban forgó illető lehet ismétlődő elkövető, aki rendszeresen kényelmetlen helyzetbe hoz másokat, vagy csak egyszer mondott vagy tett valamit. Mindkettő indok lehet a cselekvésre a témától függően.

Mielőtt válaszolnál, adj magadnak időt, hogy megértsd, mi történt. Olvasd el a személy múltbeli észrevételeit és beszélgetéseit, hogy jobban megértsd, ki ő és miért cselekedett ilyen módon. Próbáld meg más emberek véleményét kikérni az adott emberről és viselkedéséről.

<aside markdown="1" class="pquote">
  Ne menj bele vitákba. Ne hagyd magad elterelni, ne foglalkozz más viselkedésével, amíg nem kezelted le a kérdéses helyzetet. Fókuszálj arra, amire valóban szükség van.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### Tedd meg a megfelelő lépéseket

A szükséges információk összegyűjtése és feldolgozása után el kell döntened, hogy mit teszel. Miközben megteszed a szükséges lépéseket, ne feledd, hogy a moderátor célja az, hogy biztonságos, tiszteletteljes és együttműködő környezetet teremtsen. Ne csak arra gondolj, hogy hogyan kell kezelni a szóban forgó helyzetet, hanem arra is, hogy a válasz hogyan befolyásolja a közösség további viselkedését és elvárásait.

Amikor valaki bejelenti a magatartási kódex megsértését, akkor annak kezelése a te feladatod és nem az övé. Néha a bejelentő olyan információkat tár fel, amelyek nagy kockázatot jelenthetnek karrierjük, hírnevük vagy fizikai biztonságuk szempontjából. Ha arra kényszeríted őket, hogy szálljanak szembe a szabálysértővel, azzal kompromittálod őket. A közvetlen kommunikációt neked kell lefolytatnod ebben az ügyben, kivéve, ha a bejelentő mást kér.

Számos lehetőséged van arra, hogy eljárj a szabálysértőkkel szemben:

* **Publikusan figyelmeztesd a kérdéses személyt** és magyarázd el, hogy a viselkedése negatívan hatott másokra, lehetőleg azon a csatornán, ahol történt. A nyilvános kommunikáció, ahol lehetséges, azt közvetíti a közösség többi tagja felé, hogy komolyan veszed a magatartási kódexet. Légy kedves, de szilárd a kommunikációban.

* **Privát módon lépj kapcsolatba a kérdéses személlyel** és magyarázd el, hogy a viselkedése negatívan hatott másokra. Szenzitív információk esetén privát csatornákat használj. Ha valakivel privát levelezést folytatsz, akkor jó ötlet CC mezőben értesíteni a bejelentőt, így értesül róla, hogy megtetted a szükséges lépéseket. Mindenképpen kérd a bejelentő hozzájárulását mielőtt a CC mezőbe teszed.

Néha a fentiek nem érnek célt. A kérdéses személy agresszív vagy ellenséges lesz és nem változtatja meg a viselkedését. Ebben a helyzetben meg kell fontolnod keményebb intézkedéseket is, mint például:

* **A kérdéses személyt felfüggeszted** a projekten, átmenetileg megtiltva neki, hogy a projektben bármilyen módon részt vegyen.

* **A kérdéses személyt véglegesen kizárod** a projektből.

A felfüggesztés és kizárás súlyos büntetés, és azt mutatja, hogy valaki összeegyeztethetetlen a projekttel és szabályaival. Csak akkor alkalmazd ezeket, ha biztos vagy benne, hogy nem lehet megoldani a problémát.

## A felelősséged karbantartóként

A magatartási kódex nem tetszőlegesen betartatott törvény. Te vagy a kódex végrehajtója és a te felelősséged, hogy az abban megállapított szabályok be legyenek tartva.

Karbantartóként te állapítod meg a közösségére vonatkozó iránymutatásokat, és ezeket neked kell betartatni a magatartási kódexben meghatározott szabályok szerint. Ez azt jelenti, hogy a magatartási kódex bármilyen megsértését komolyan kell venned. A bejelentők felé kötelességgel tartozol a panaszok alapos és tisztességes felülvizsgálatával. Ha úgy ítéled meg, hogy az általuk jelentett magatartás nem sérti a kódexet, azt kommunikáld egyértelműen feléjük és magyarázd meg, miért nem teszel lépéseket. Ezután már rájuk van bízva, hogy a mit tesznek: eltűrik a magatartást, amelyet bejelentettek, vagy abbahagyják a közösségben való részvételt.

Az olyan viselkedésről szóló jelentés, amely _technikailag_ nem sérti a magatartási kódexet, még mindig jelezheti azt, hogy probléma van a közösségben. Ilyenkor meg kell vizsgálnod ezt, mint lehetséges problémát és szükség esetén cselekedned is kell. Lehet, hogy felül kell vizsgálnod a magatartási kódexet, hogy tisztázódjon, mi az elfogadható viselkedés. Esetleg beszélned kell a viselkedési problémában érintett személyekkel, hogy bár nem sértették meg a szabályokat, nagyon közel álltak hozzá, és ezzel másokat kellemetlen helyzetbe hoztak.

Végeredményben, karbantartóként te vagy az, aki lefekteti és betartatja az elfogadható viselkedés szabályait. Megvan a lehetőséged, hogy alakítsd a projekt közösségi értékeit és a résztvevők elvárják, hogy ezeket az értékeket tisztességesen és következetesen képviseld.

## Erősítsd azt a viselkedést amit látni akarsz a világban 🌎

Ha egy projekt ellenségesnek vagy nem befogadónak tűnik &ndash; akkor is, ha csak egyetlen ember az oka, akinek a viselkedését mások tolerálják &ndash;, azt kockáztatod, hogy rengeteg közreműködőt elveszítesz. Ezek között olyanokat is, akikkel akár soha többé nem találkozhatsz. Nem mindig könnyű a magatartási kódex elfogadása vagy érvényesítése, de a barátságos környezet elősegítése segít a közösség növekedésében.
