---
lang: hi
title: ओपन सोर्स मेट्रिक्स
description: अपने ओपन सोर्स प्रोजेक्ट की सफलता को मापने और ट्रैक करके उसे फलने-फूलने में मदद करने के लिए सोच-समझकर निर्णय लें।
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
---

## किसी भी चीज़ को क्यों मापें?

डेटा, जब बुद्धिमानी से उपयोग किया जाता है, तो आपको ओपन सोर्स अनुरक्षक के रूप में बेहतर निर्णय लेने में मदद मिल सकती है।

अधिक जानकारी के साथ, आप यह कर सकते हैं:

* समझें कि उपयोगकर्ता किसी नई सुविधा पर कैसे प्रतिक्रिया देते हैं
* पता लगाएं कि नए उपयोगकर्ता कहां से आते हैं
* बाहरी उपयोग के मामले या कार्यक्षमता को पहचानें और निर्णय लें कि इसका समर्थन करना है या नहीं
* अपने प्रोजेक्ट की लोकप्रियता का आकलन करें
* समझें कि आपके प्रोजेक्ट का उपयोग कैसे किया जाता है
* प्रायोजन और अनुदान के माध्यम से धन जुटाएं

उदाहरण के लिए, [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md) ने पाया कि Google Analytics उन्हें काम को प्राथमिकता देने में मदद करता है:

> होमब्रू निःशुल्क प्रदान किया जाता है और इसे पूरी तरह से स्वयंसेवकों द्वारा अपने खाली समय में चलाया जाता है। परिणामस्वरूप, हमारे पास भविष्य की सुविधाओं को सर्वोत्तम तरीके से डिज़ाइन करने और वर्तमान कार्य को प्राथमिकता देने के तरीके पर निर्णय लेने के लिए होमब्रू उपयोगकर्ताओं का विस्तृत उपयोगकर्ता अध्ययन करने के लिए संसाधन नहीं हैं। अनाम समग्र उपयोगकर्ता विश्लेषण हमें लोग होमब्रू का उपयोग कैसे, कहां और कब करते हैं, इसके आधार पर सुधारों और सुविधाओं को प्राथमिकता देने की अनुमति देते हैं।

लोकप्रियता ही सब कुछ नहीं है. हर कोई अलग-अलग कारणों से खुले स्रोत में आ जाता है। यदि एक ओपन सोर्स अनुरक्षक के रूप में आपका लक्ष्य अपना काम दिखाना है, अपने कोड के बारे में पारदर्शी होना है, या सिर्फ मनोरंजन करना है, तो मेट्रिक्स आपके लिए महत्वपूर्ण नहीं हो सकते हैं।

यदि आप अपने प्रोजेक्ट को गहराई से समझने में रुचि रखते हैं, तो अपने प्रोजेक्ट की गतिविधि का विश्लेषण करने के तरीकों के लिए आगे पढ़ें।

## खोज

इससे पहले कि कोई भी आपके प्रोजेक्ट का उपयोग कर सके या उसमें योगदान कर सके, उन्हें यह जानना होगा कि यह मौजूद है। अपने आप से पूछें: _क्या लोगों को यह प्रोजेक्ट मिल रहा है?_

![Traffic graph](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

यदि आपका प्रोजेक्ट GitHub पर होस्ट किया गया है, [आप देख सकते हैं](https://help.github.com/articles/about-repository-graphs/#traffic) आपके प्रोजेक्ट पर कितने लोग आते हैं और वे कहाँ से आते हैं। अपने प्रोजेक्ट के पेज से, "इनसाइट्स" पर क्लिक करें, फिर "ट्रैफ़िक" पर क्लिक करें। इस पृष्ठ पर, आप देख सकते हैं:

* **कुल पृष्ठ दृश्य:** आपको बताता है कि आपका प्रोजेक्ट कितनी बार देखा गया

* **कुल अद्वितीय विज़िटर:** आपको बताता है कि कितने लोगों ने आपका प्रोजेक्ट देखा

* **रेफ़रिंग साइटें:** आपको बताती हैं कि विज़िटर कहाँ से आए। यह मीट्रिक आपको यह पता लगाने में मदद कर सकता है कि आपको अपने दर्शकों तक कहां पहुंचना है और क्या आपके प्रचार प्रयास काम कर रहे हैं।

* **लोकप्रिय सामग्री:** आपको बताती है कि विज़िटर आपके प्रोजेक्ट पर कहां जाते हैं, पृष्ठ दृश्य और अद्वितीय विज़िटर के आधार पर।

[गिटहब सितारे](https://help.github.com/articles/about-stars/) लोकप्रियता का आधारभूत माप प्रदान करने में भी मदद मिल सकती है। हालाँकि GitHub सितारे आवश्यक रूप से डाउनलोड और उपयोग से संबंधित नहीं हैं, वे आपको बता सकते हैं कि कितने लोग आपके काम पर ध्यान दे रहे हैं।

आप भी चाहते होंगे [tविशिष्ट स्थानों में रैक खोज योग्यता](https://opensource.com/business/16/6/pirate-metrics): उदाहरण के लिए, Google पेजरैंक, आपके प्रोजेक्ट की वेबसाइट से रेफरल ट्रैफ़िक, या अन्य ओपन सोर्स प्रोजेक्ट या वेबसाइट से रेफरल।

## उपयोग

लोग आपके प्रोजेक्ट को इस जंगली और पागलपन वाली चीज़ पर ढूंढ रहे हैं जिसे हम इंटरनेट कहते हैं। आदर्श रूप से, जब वे आपका प्रोजेक्ट देखेंगे, तो वे कुछ करने के लिए मजबूर महसूस करेंगे। दूसरा प्रश्न जो आप पूछना चाहेंगे वह है: _क्या लोग इस परियोजना का उपयोग कर रहे हैं?_

यदि आप अपने प्रोजेक्ट को वितरित करने के लिए npm या RubyGems.org जैसे पैकेज मैनेजर का उपयोग करते हैं, तो आप अपने प्रोजेक्ट के डाउनलोड को ट्रैक करने में सक्षम हो सकते हैं।

प्रत्येक पैकेज प्रबंधक "डाउनलोड" की थोड़ी अलग परिभाषा का उपयोग कर सकता है, और डाउनलोड आवश्यक रूप से इंस्टॉल या उपयोग से संबंधित नहीं है, लेकिन यह तुलना के लिए कुछ आधार रेखा प्रदान करता है। कई लोकप्रिय पैकेज प्रबंधकों में उपयोग के आंकड़ों को ट्रैक करने के लिए [Libraries.io](https://libraries.io/) का उपयोग करने का प्रयास करें।

यदि आपका प्रोजेक्ट GitHub पर है, तो "ट्रैफ़िक" पृष्ठ पर फिर से नेविगेट करें। आप यह देखने के लिए [क्लोन ग्राफ](https://github.com/blog/1873-clone-graphs) का उपयोग कर सकते हैं कि आपके प्रोजेक्ट को किसी दिए गए दिन में कितनी बार क्लोन किया गया है, कुल क्लोन और अद्वितीय क्लोनर्स द्वारा विभाजित किया गया है।

![क्लोन ग्राफ़](/assets/images/metrics/clone_graph.png)

यदि आपके प्रोजेक्ट को खोजने वाले लोगों की संख्या की तुलना में उपयोग कम है, तो विचार करने के लिए दो मुद्दे हैं। दोनों में से एक:

* आपका प्रोजेक्ट आपके दर्शकों को सफलतापूर्वक परिवर्तित नहीं कर रहा है, या
* आप गलत दर्शकों को आकर्षित कर रहे हैं

उदाहरण के लिए, यदि आपका प्रोजेक्ट हैकर न्यूज़ के पहले पन्ने पर आता है, तो आपको संभवतः खोज (ट्रैफ़िक) में वृद्धि दिखाई देगी, लेकिन रूपांतरण दर कम होगी, क्योंकि आप हैकर न्यूज़ पर सभी तक पहुंच रहे हैं। हालाँकि, यदि आपका रूबी प्रोजेक्ट रूबी सम्मेलन में प्रदर्शित किया गया है, तो आपको लक्षित दर्शकों से उच्च रूपांतरण दर देखने की अधिक संभावना है।

यह पता लगाने का प्रयास करें कि आपके दर्शक कहां से आ रहे हैं और अपने प्रोजेक्ट पेज पर दूसरों से फीडबैक मांगें ताकि यह पता चल सके कि आप इन दोनों में से किस समस्या का सामना कर रहे हैं।

एक बार जब आप जान जाते हैं कि लोग आपके प्रोजेक्ट का उपयोग कर रहे हैं, तो आप यह पता लगाने की कोशिश करना चाहेंगे कि वे इसके साथ क्या कर रहे हैं। क्या वे आपके कोड को फोर्क करके और सुविधाएँ जोड़कर इस पर निर्माण कर रहे हैं? क्या वे इसका उपयोग विज्ञान या व्यवसाय के लिए कर रहे हैं?

## अवधारण

लोगों को आपका प्रोजेक्ट मिल रहा है और वे इसका उपयोग कर रहे हैं। अगला प्रश्न जो आप स्वयं से पूछना चाहेंगे वह है: _क्या लोग इस परियोजना में योगदान दे रहे हैं?_

योगदानकर्ताओं के बारे में सोचना शुरू करना कभी भी जल्दी नहीं है। अन्य लोगों के हस्तक्षेप के बिना, आप अपने आप को एक अस्वस्थ स्थिति में डालने का जोखिम उठाते हैं जहां आपका प्रोजेक्ट लोकप्रिय है (कई लोग इसका उपयोग करते हैं) लेकिन समर्थित नहीं है (मांग को पूरा करने के लिए रखरखाव के लिए पर्याप्त समय नहीं है)।

प्रतिधारण के लिए [नए योगदानकर्ताओं की आमद](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2), की भी आवश्यकता होती है, चूँकि पहले सक्रिय योगदानकर्ता अंततः अन्य चीज़ों की ओर बढ़ेंगे।

सामुदायिक मेट्रिक्स के उदाहरण जिन्हें आप नियमित रूप से ट्रैक करना चाहते हैं उनमें शामिल हैं:

* **कुल योगदानकर्ता संख्या और प्रति योगदानकर्ता प्रतिबद्धताओं की संख्या:** आपको बताता है कि आपके पास कितने योगदानकर्ता हैं, और कौन कम या ज्यादा सक्रिय है। GitHub पर, आप इसे "अंतर्दृष्टि" -> "योगदानकर्ता" के अंतर्गत देख सकते हैं। अभी, यह ग्राफ़ केवल उन योगदानकर्ताओं की गणना करता है जिन्होंने रिपॉजिटरी की डिफ़ॉल्ट शाखा के लिए प्रतिबद्ध किया है।

![योगदानकर्ता ग्राफ](/assets/images/metrics/repo_contributors_specific_graph.png)

* **पहली बार, आकस्मिक और बार-बार योगदान देने वाले:** आपको यह ट्रैक करने में मदद करता है कि क्या आपको नए योगदानकर्ता मिल रहे हैं, और क्या वे वापस आते हैं। (आकस्मिक योगदानकर्ता कम संख्या में कमिट वाले योगदानकर्ता होते हैं। चाहे वह एक कमिट हो, पांच से कम कमिट हो, या कुछ और यह आप पर निर्भर है।) नए योगदानकर्ताओं के बिना, आपके प्रोजेक्ट का समुदाय स्थिर हो सकता है।

* **खुले मुद्दों और खुले पुल अनुरोधों की संख्या:** यदि ये संख्या बहुत अधिक हो जाती है, तो आपको समस्या परीक्षण और कोड समीक्षा में मदद की आवश्यकता हो सकती है।

* **_खुले हुए_ मुद्दों और _खुले_पुल अनुरोधों की संख्या:** खुले हुए मुद्दों का मतलब है कि किसी को आपके प्रोजेक्ट की इतनी परवाह है कि वह किसी मुद्दे को खोल सके। यदि वह संख्या समय के साथ बढ़ती है, तो यह दर्शाता है कि लोग आपके प्रोजेक्ट में रुचि रखते हैं।

* **योगदान के प्रकार:** उदाहरण के लिए, कमिट करना, टाइपो या बग को ठीक करना, या किसी मुद्दे पर टिप्पणी करना।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
  ओपन सोर्स सिर्फ कोड से कहीं अधिक है। सफल ओपन सोर्स परियोजनाओं में इन परिवर्तनों के बारे में बातचीत के साथ-साथ कोड और दस्तावेज़ीकरण योगदान भी शामिल हैं।
  <p markdown="1" class="pquote-credit">
— @arfon, ["ओपन सोर्स का आकार"](https://github.com/blog/2195-the-shape-of-open-source)
  </p>
</aside>

## अनुरक्षक गतिविधि

अंत में, आप यह सुनिश्चित करके लूप को बंद करना चाहेंगे कि आपके प्रोजेक्ट के अनुरक्षक प्राप्त योगदान की मात्रा को संभालने में सक्षम हैं। आखिरी सवाल जो आप खुद से पूछना चाहेंगे वह है: _क्या मैं (या हम) अपने समुदाय को जवाब दे रहे हैं?_

अनुत्तरदायी अनुरक्षक खुले स्रोत परियोजनाओं के लिए एक बाधा बन जाते हैं। यदि कोई योगदान जमा करता है लेकिन रखरखावकर्ता से कभी जवाब नहीं मिलता है, तो वे निराश महसूस कर सकते हैं और छोड़ सकते हैं।

[मोज़िला से अनुसंधान](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) सुझाव देता है कि बार-बार योगदान को प्रोत्साहित करने में अनुरक्षक प्रतिक्रिया एक महत्वपूर्ण कारक है।

विचार करना [यह ट्रैक करना कि आपको (या किसी अन्य अनुरक्षक को) योगदान का जवाब देने में कितना समय लगता है](https://github.blog/2023-07-19-metrics-for-issues-pull-requests-and-discussions/), चाहे कोई समस्या हो या पुल अनुरोध। प्रतिक्रिया देने के लिए कार्रवाई की आवश्यकता नहीं है. यह कहने जितना सरल हो सकता है: _"आपके सबमिशन के लिए धन्यवाद! मैं अगले सप्ताह के भीतर इसकी समीक्षा करूंगा।"_

आप योगदान प्रक्रिया के चरणों के बीच लगने वाले समय को भी माप सकते हैं, जैसे:

* किसी अंक के खुले रहने का औसत समय
* क्या मुद्दे पीआर द्वारा बंद कर दिए जाते हैं
* क्या बासी मुद्दे बंद हो जाते हैं
* पुल अनुरोध को मर्ज करने का औसत समय

## लोगों के बारे में जानने के लिए 📊 का प्रयोग करें

मेट्रिक्स को समझने से आपको एक सक्रिय, बढ़ता हुआ ओपन सोर्स प्रोजेक्ट बनाने में मदद मिलेगी। भले ही आप डैशबोर्ड पर प्रत्येक मीट्रिक को ट्रैक नहीं करते हैं, फिर भी अपना ध्यान उस प्रकार के व्यवहार पर केंद्रित करने के लिए उपरोक्त ढांचे का उपयोग करें जो आपके प्रोजेक्ट को आगे बढ़ाने में मदद करेगा।

[CHAOSS](https://chaoss.community/) एक स्वागतयोग्य, खुला स्रोत समुदाय है जो सामुदायिक स्वास्थ्य के लिए एनालिटिक्स, मेट्रिक्स और सॉफ्टवेयर पर केंद्रित है।
