---
lang: hi
title: ओपन सोर्स कार्य के लिए भुगतान प्राप्त करना
description: अपने समय या अपने प्रोजेक्ट के लिए वित्तीय सहायता प्राप्त करके अपने काम को खुले स्रोत में बनाए रखें।
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## कुछ लोग वित्तीय सहायता क्यों चाहते हैं?

ओपन सोर्स का अधिकांश कार्य स्वैच्छिक है। उदाहरण के लिए, हो सकता है कि किसी को अपने द्वारा उपयोग किए जा रहे किसी प्रोजेक्ट में बग का सामना करना पड़े और वह त्वरित समाधान सबमिट कर दे, या हो सकता है कि वे अपने खाली समय में किसी ओपन सोर्स प्रोजेक्ट के साथ छेड़छाड़ करने का आनंद लें।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
मैं एक "शौक" प्रोग्रामिंग प्रोजेक्ट की तलाश में था जो क्रिसमस के आसपास के सप्ताह के दौरान मुझे व्यस्त रखे। (...) मेरे पास एक घरेलू कंप्यूटर था, और मेरे हाथ में और कुछ नहीं था। मैंने उस नई स्क्रिप्टिंग भाषा के लिए एक दुभाषिया लिखने का निर्णय लिया जिसके बारे में मैं हाल ही में सोच रहा था। (...) मैंने कार्यकारी शीर्षक के रूप में पायथन को चुना।
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["प्रोग्रामिंग Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

ऐसे कई कारण हैं जिनकी वजह से कोई व्यक्ति अपने ओपन सोर्स कार्य के लिए भुगतान नहीं करना चाहेगा।

* **उनके पास पहले से ही एक पूर्णकालिक नौकरी हो सकती है जो उन्हें पसंद है,** जो उन्हें अपने खाली समय में ओपन सोर्स में योगदान करने में सक्षम बनाती है।
* **वे ओपन सोर्स को एक शौक** या रचनात्मक पलायन के रूप में सोचने का आनंद लेते हैं और अपनी परियोजनाओं पर काम करने के लिए वित्तीय रूप से बाध्य महसूस नहीं करना चाहते हैं।
* **उन्हें ओपन सोर्स में योगदान करने से अन्य लाभ मिलते हैं,** जैसे कि उनकी प्रतिष्ठा या पोर्टफोलियो बनाना, एक नया कौशल सीखना, या किसी समुदाय के करीब महसूस करना।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  वित्तीय दान कुछ लोगों के लिए ज़िम्मेदारी की भावना जोड़ता है। (...) यह हमारे लिए महत्वपूर्ण है, विश्व स्तर पर जुड़ी हुई, तेज़ गति वाली दुनिया में जिसमें हम रहते हैं, यह कहने में सक्षम होना कि "अभी नहीं, मुझे कुछ पूरी तरह से अलग करने का मन है"।
  <p markdown="1" class="pquote-credit">
— @alloy, ["हम दान स्वीकार क्यों नहीं करते?"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

दूसरों के लिए, विशेष रूप से जब योगदान जारी है या महत्वपूर्ण समय की आवश्यकता है, तो ओपन सोर्स में योगदान करने के लिए भुगतान प्राप्त करना ही एकमात्र तरीका है जिससे वे भाग ले सकते हैं, या तो क्योंकि परियोजना को इसकी आवश्यकता है, या व्यक्तिगत कारणों से।

लोकप्रिय परियोजनाओं को बनाए रखना एक महत्वपूर्ण जिम्मेदारी हो सकती है, जिसमें प्रति माह कुछ घंटों के बजाय प्रति सप्ताह 10 या 20 घंटे लगते हैं।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  किसी भी ओपन सोर्स प्रोजेक्ट अनुरक्षक से पूछें, और वे आपको किसी प्रोजेक्ट को प्रबंधित करने में लगने वाले काम की मात्रा की वास्तविकता के बारे में बताएंगे। आपके पास ग्राहक हैं. आप उनके लिए समस्याएं ठीक कर रहे हैं. आप नई सुविधाएँ बना रहे हैं. यह आपके समय की वास्तविक मांग बन जाती है।
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["अवैतनिक श्रम की नैतिकता और ओएसएस समुदाय"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

भुगतान किया गया कार्य जीवन के विभिन्न क्षेत्रों के लोगों को सार्थक योगदान देने में भी सक्षम बनाता है। कुछ लोग अपनी वर्तमान वित्तीय स्थिति, ऋण, या परिवार या अन्य देखभाल संबंधी दायित्वों के आधार पर, ओपन सोर्स परियोजनाओं पर अवैतनिक समय बिताने का जोखिम नहीं उठा सकते हैं। इसका मतलब है कि दुनिया कभी भी उन प्रतिभाशाली लोगों के योगदान को नहीं देखती है जो स्वेच्छा से अपना समय नहीं दे सकते। इसके नैतिक निहितार्थ हैं, जैसा कि @ashedryden [ने वर्णन किया है](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), क्योंकि जो काम किया गया है वह है उन लोगों के पक्ष में पक्षपातपूर्ण जिनके पास पहले से ही जीवन में लाभ हैं, जो बाद में अपने स्वैच्छिक योगदान के आधार पर अतिरिक्त लाभ प्राप्त करते हैं, जबकि अन्य जो स्वयंसेवा करने में सक्षम नहीं होते हैं उन्हें बाद में अवसर नहीं मिलते हैं, जो खुले स्रोत में विविधता की वर्तमान कमी को मजबूत करता है समुदाय।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar"> 
OSS प्रौद्योगिकी उद्योग को बड़े पैमाने पर लाभ पहुंचाता है, जिसका अर्थ है सभी उद्योगों को लाभ। (...) हालाँकि, यदि केवल वे लोग ही भाग्यशाली और जुनूनी हैं जो इस पर ध्यान केंद्रित कर सकते हैं, तो इसमें एक बड़ी अप्रयुक्त क्षमता है।
  <p markdown="1" class="pquote-credit">
— @isaacs, ["पैसा और ओपन सोर्स"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

यदि आप वित्तीय सहायता की तलाश में हैं, तो विचार करने के लिए दो रास्ते हैं। आप एक योगदानकर्ता के रूप में अपने समय का वित्तपोषण कर सकते हैं, या आप परियोजना के लिए संगठनात्मक वित्तपोषण पा सकते हैं।

## अपने समय का वित्तपोषण करना

आज, कई लोगों को ओपन सोर्स पर अंशकालिक या पूर्णकालिक काम करने के लिए भुगतान मिलता है। अपने समय के लिए भुगतान पाने का सबसे आम तरीका अपने नियोक्ता से बात करना है।

यदि आपका नियोक्ता वास्तव में परियोजना का उपयोग करता है, तो ओपन सोर्स कार्य के लिए मामला बनाना आसान है, लेकिन अपनी पिच के साथ रचनात्मक बनें। हो सकता है कि आपका नियोक्ता प्रोजेक्ट का उपयोग नहीं करता हो, लेकिन वे पायथन का उपयोग करते हैं, और एक लोकप्रिय पायथन प्रोजेक्ट को बनाए रखने से नए पायथन डेवलपर्स को आकर्षित करने में मदद मिलती है। शायद यह आपके नियोक्ता को सामान्य रूप से अधिक डेवलपर-अनुकूल बनाता है।

यदि आपके पास कोई मौजूदा ओपन सोर्स प्रोजेक्ट नहीं है जिस पर आप काम करना चाहेंगे, बल्कि चाहेंगे कि आपका वर्तमान कार्य आउटपुट ओपन सोर्स हो, तो अपने नियोक्ता के लिए उनके कुछ आंतरिक सॉफ़्टवेयर को ओपन सोर्स करने का मामला बनाएं।

कई कंपनियां अपना ब्रांड बनाने और गुणवत्तापूर्ण प्रतिभाओं की भर्ती के लिए ओपन सोर्स प्रोग्राम विकसित कर रही हैं।

उदाहरण के लिए, @hueniverse ने पाया कि औचित्य सिद्ध करने के लिए वित्तीय कारण थे [ओपन सोर्स में वॉलमार्ट का निवेश](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). और @jamesgpearce ने पाया वह फेसबुक का ओपन सोर्स प्रोग्राम है [make a difference](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) 
भर्ती में:

> यह हमारी हैकर संस्कृति और हमारे संगठन को कैसे समझा जाता है, के साथ निकटता से जुड़ा हुआ है। हमने अपने कर्मचारियों से पूछा, "क्या आप फेसबुक के ओपन सोर्स सॉफ़्टवेयर प्रोग्राम के बारे में जानते थे?" दो-तिहाई ने कहा "हाँ"। एक-आधे ने कहा कि कार्यक्रम ने हमारे लिए काम करने के उनके निर्णय में सकारात्मक योगदान दिया। ये सीमांत संख्याएं नहीं हैं, और मुझे आशा है कि यह प्रवृत्ति जारी रहेगी।

यदि आपकी कंपनी इस मार्ग पर चलती है, तो समुदाय और कॉर्पोरेट गतिविधि के बीच की सीमाओं को स्पष्ट रखना महत्वपूर्ण है। अंततः, ओपन सोर्स दुनिया भर के लोगों के योगदान के माध्यम से खुद को कायम रखता है, और यह किसी एक कंपनी या स्थान से बड़ा है।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  ओपन सोर्स पर काम करने के लिए भुगतान प्राप्त करना एक दुर्लभ और अद्भुत अवसर है, लेकिन आपको इस प्रक्रिया में अपना जुनून नहीं छोड़ना चाहिए। आपका जुनून यह होना चाहिए कि कंपनियां आपको भुगतान क्यों करना चाहती हैं।
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

यदि आप अपने वर्तमान नियोक्ता को ओपन सोर्स कार्य को प्राथमिकता देने के लिए मना नहीं सकते हैं, तो एक नया नियोक्ता ढूंढने पर विचार करें जो ओपन सोर्स में कर्मचारी योगदान को प्रोत्साहित करता हो। ऐसी कंपनियों की तलाश करें जो ओपन सोर्स कार्य के प्रति अपना समर्पण स्पष्ट करती हों। उदाहरण के लिए:

* कुछ कंपनियाँ, जैसे [Netflix](https://netflix.github.io/), के पास ऐसी वेबसाइटें हैं जो ओपन सोर्स में उनकी भागीदारी को उजागर करती हैं।
* [Zalando](https://opensource.zalando.com) ने [open source contribution policy](https://opensource.zalando.com/docs/using/contributing/) उनके कर्मचारियों के लिए प्रकाशन किया।

ऐसी परियोजनाएँ जो किसी बड़ी कंपनी में उत्पन्न हुईं, जैसे [Go](https://github.com/golang) या [React](https://github.com/facebook/react), ओपन सोर्स पर काम करने के लिए लोगों को नियोजित करने की भी संभावना है।

अपनी व्यक्तिगत परिस्थितियों के आधार पर, आप अपने ओपन सोर्स कार्य के वित्तपोषण के लिए स्वतंत्र रूप से धन जुटाने का प्रयास कर सकते हैं। उदाहरण के लिए:

* @Homebrew (और [कई अन्य अनुरक्षक और संगठन](https://github.com/sponsors/community)) [GitHub Sponsors](https://github.com/sponsors) के माध्यम से उनके काम को वित्तपोषित करें
* @gaearon उसके काम को वित्त पोषित किया [Redux](https://github.com/reactjs/redux) पर, और [Patreon crowdfunding campaign](https://redux.js.org/) के जरिए
* @andrewgodwin स्कीमा माइग्रेशन पर वित्त पोषित कार्य [through a Kickstarter campaign](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

अंत में, कभी-कभी ओपन सोर्स प्रोजेक्ट उन मुद्दों पर इनाम देते हैं जिनमें आप मदद करने पर विचार कर सकते हैं।

* @ConnorChristie भुगतान पाने में सक्षम था [helping](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) @MARKETProtocol अपनी JavaScript लाइब्रेरी पर काम करता है [gitcoin पर इनाम के माध्यम से](https://gitcoin.co/).
* @mamiM ने इसके बाद @MetaMask का जापानी अनुवाद किया [इस मुद्दे को बाउंटीज़ नेटवर्क पर वित्त पोषित किया गया था](https://explorer.bounties.network/bounty/134).

## अपने प्रोजेक्ट के लिए फंडिंग ढूँढना

व्यक्तिगत योगदानकर्ताओं के लिए व्यवस्था से परे, कभी-कभी परियोजनाएं चल रहे काम को निधि देने के लिए कंपनियों, व्यक्तियों या अन्य लोगों से धन जुटाती हैं।

संगठनात्मक फंडिंग वर्तमान योगदानकर्ताओं को भुगतान करने, परियोजना चलाने की लागत (जैसे होस्टिंग शुल्क) को कवर करने, या नई सुविधाओं या विचारों में निवेश करने में जा सकती है।

जैसे-जैसे ओपन सोर्स की लोकप्रियता बढ़ती है, परियोजनाओं के लिए फंडिंग ढूंढना अभी भी प्रयोगात्मक है, लेकिन कुछ सामान्य विकल्प उपलब्ध हैं।

### क्राउडफंडिंग अभियानों या प्रायोजन के माध्यम से अपने काम के लिए धन जुटाएं

यदि आपके पास पहले से ही एक मजबूत दर्शक वर्ग या प्रतिष्ठा है, या आपका प्रोजेक्ट बहुत लोकप्रिय है, तो प्रायोजन ढूँढना अच्छा काम करता है।
प्रायोजित परियोजनाओं के कुछ उदाहरणों में शामिल हैं:

* **[webpack](https://github.com/webpack)** कंपनियों और व्यक्तियों से धन जुटाता है [through OpenCollective](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** एक गैर-लाभकारी संगठन जो काम के लिए भुगतान करता है [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), and other Ruby infrastructure projects

### एक राजस्व धारा बनाएँ

आपके प्रोजेक्ट के आधार पर, आप व्यावसायिक सहायता, होस्ट किए गए विकल्पों या अतिरिक्त सुविधाओं के लिए शुल्क लेने में सक्षम हो सकते हैं। कुछ उदाहरणों में शामिल हैं:

* **[Sidekiq](https://github.com/mperham/sidekiq)** अतिरिक्त सहायता के लिए सशुल्क संस्करण प्रदान करता है
* **[Travis CI](https://github.com/travis-ci)** अपने उत्पाद के सशुल्क संस्करण प्रदान करता है
* **[Ghost](https://github.com/TryGhost/Ghost)** सशुल्क प्रबंधित सेवा वाला एक गैर-लाभकारी संगठन है

कुछ लोकप्रिय परियोजनाएँ, जैसे [npm](https://github.com/npm/cli) और [Docker](https://github.com/docker/docker), यहां तक ​​कि अपने व्यवसाय के विकास को समर्थन देने के लिए उद्यम पूंजी भी जुटाते हैं।

### अनुदान निधि के लिए आवेदन करें

कुछ सॉफ़्टवेयर फ़ाउंडेशन और कंपनियाँ ओपन सोर्स कार्य के लिए अनुदान प्रदान करती हैं। कभी-कभी, परियोजना के लिए कानूनी इकाई स्थापित किए बिना व्यक्तियों को अनुदान का भुगतान किया जा सकता है।

* **[Read the Docs](https://github.com/rtfd/readthedocs.org)** को [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/) से अनुदान प्राप्त हुआ।
* **[OpenMRS](https://github.com/openmrs)** कार्य द्वारा वित्त पोषित किया गया था [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** को [Sloan Foundation](https://sloan.org/programs/digital-technology) से अनुदान प्राप्त हुआ।
* **[Python Software Foundation](https://www.python.org/psf/grants/)** पायथन से संबंधित कार्यों के लिए अनुदान प्रदान करता है।

अधिक विस्तृत विकल्पों और केस अध्ययन के लिए, @nayafia  [एक गाइड लिखा](https://github.com/nayafia/lemonade-stand) 
ओपन सोर्स कार्य के लिए भुगतान प्राप्त करना। विभिन्न प्रकार की फंडिंग के लिए अलग-अलग कौशल की आवश्यकता होती है, इसलिए यह पता लगाने के लिए अपनी ताकत पर विचार करें कि कौन सा विकल्प आपके लिए सबसे अच्छा काम करता है।

## वित्तीय सहायता के लिए मामला बनाना

चाहे आपका प्रोजेक्ट एक नया विचार हो, या वर्षों से चला आ रहा हो, आपको अपने लक्षित फंडर की पहचान करने और एक सम्मोहक मामला बनाने में महत्वपूर्ण विचार करने की उम्मीद करनी चाहिए।

चाहे आप अपने समय के लिए भुगतान करना चाह रहे हों, या किसी परियोजना के लिए धन जुटाना चाह रहे हों, आपको निम्नलिखित प्रश्नों का उत्तर देने में सक्षम होना चाहिए।

### प्रभाव

यह प्रोजेक्ट उपयोगी क्यों है? आपके उपयोगकर्ता, या संभावित उपयोगकर्ता, इसे इतना पसंद क्यों करते हैं? पांच साल में यह कहां होगा?

### संकर्षण

सबूत इकट्ठा करने की कोशिश करें कि आपका प्रोजेक्ट मायने रखता है, चाहे वह मेट्रिक्स, उपाख्यान या प्रशंसापत्र हो। क्या अभी कोई कंपनी या उल्लेखनीय लोग आपके प्रोजेक्ट का उपयोग कर रहे हैं? यदि नहीं, तो क्या किसी प्रमुख व्यक्ति ने इसका समर्थन किया है?

### फंड देने वाले के लिए मूल्य

फंडर्स, चाहे आपका नियोक्ता हो या अनुदान देने वाला फाउंडेशन, अक्सर अवसरों के साथ संपर्क किया जाता है। उन्हें किसी अन्य अवसर की अपेक्षा आपके प्रोजेक्ट का समर्थन क्यों करना चाहिए? वे व्यक्तिगत रूप से कैसे लाभान्वित होते हैं?

### धन का उपयोग

प्रस्तावित फंडिंग से आप वास्तव में क्या हासिल करेंगे? वेतन देने के बजाय परियोजना की उपलब्धियों या परिणामों पर ध्यान दें।

### आपको धनराशि कैसे प्राप्त होगी

क्या फंडर को संवितरण से संबंधित कोई आवश्यकता है? उदाहरण के लिए, आपको एक गैर-लाभकारी संस्था होने या एक गैर-लाभकारी वित्तीय प्रायोजक होने की आवश्यकता हो सकती है। या शायद धनराशि किसी संगठन के बजाय किसी व्यक्तिगत ठेकेदार को दी जानी चाहिए। ये आवश्यकताएं फंडर्स के बीच अलग-अलग होती हैं, इसलिए पहले से ही अपना शोध करना सुनिश्चित करें।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  वर्षों से, हम 20 मिलियन से अधिक लोगों के समुदाय के साथ वेबसाइट फ्रेंडली आइकन के अग्रणी संसाधन रहे हैं और Whitehouse.gov सहित 70 मिलियन से अधिक वेबसाइटों पर प्रदर्शित हुए हैं। (...) संस्करण 4 तीन साल पहले था। तब से वेब तकनीक बहुत बदल गई है, और स्पष्ट रूप से, फ़ॉन्ट विस्मयकारी थोड़ा पुराना हो गया है। (...) इसीलिए हम फ़ॉन्ट विस्मयकारी 5 पेश कर रहे हैं। हम सीएसएस का आधुनिकीकरण और पुनर्लेखन कर रहे हैं और ऊपर से नीचे तक हर आइकन को फिर से डिज़ाइन कर रहे हैं। हम बेहतर डिज़ाइन, बेहतर स्थिरता और बेहतर पठनीयता की बात कर रहे हैं।
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## प्रयोग करो और हार मत मानो

पैसा जुटाना आसान नहीं है, चाहे आप एक ओपन सोर्स प्रोजेक्ट हों, एक गैर-लाभकारी संस्था हों, या एक सॉफ्टवेयर स्टार्टअप हों, और ज्यादातर मामलों में आपको रचनात्मक होने की आवश्यकता होती है। यह पहचानना कि आप भुगतान कैसे प्राप्त करना चाहते हैं, अपना शोध करना, और अपने आप को अपने फंडर के स्थान पर रखना आपको फंडिंग के लिए एक ठोस मामला बनाने में मदद करेगा।
