---
lang: hi
title: स्वागत योग्य समुदायों का निर्माण
description: एक ऐसे समुदाय का निर्माण करना जो लोगों को आपके प्रोजेक्ट का उपयोग करने, उसमें योगदान करने और उसका प्रचार-प्रसार करने के लिए प्रोत्साहित करे।
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## सफलता के लिए अपना प्रोजेक्ट तैयार करना

आपने अपना प्रोजेक्ट लॉन्च कर दिया है, आप इसका प्रचार-प्रसार कर रहे हैं और लोग इसकी जांच कर रहे हैं। बहुत बढ़िया! अब, आप उन्हें अपने साथ कैसे जोड़े रखेंगे?

स्वागत करने वाला समुदाय आपके प्रोजेक्ट के भविष्य और प्रतिष्ठा में एक निवेश है। यदि आपका प्रोजेक्ट अभी अपना पहला योगदान देखना शुरू कर रहा है, तो शुरुआती योगदानकर्ताओं को एक सकारात्मक अनुभव देकर शुरुआत करें, और उनके लिए वापस आना आसान बनाएं।

### लोगों को स्वागत का एहसास कराएं

आपके प्रोजेक्ट के समुदाय के बारे में सोचने का एक तरीका यह है कि @MikeMcQuaid इसे [योगदानकर्ता फ़नल](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/) कहता है:

![योगदानकर्ता फ़नल](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

जैसे ही आप अपना समुदाय बनाते हैं, इस बात पर विचार करें कि फ़नल के शीर्ष पर कोई व्यक्ति (एक संभावित उपयोगकर्ता) सैद्धांतिक रूप से नीचे (एक सक्रिय अनुरक्षक) तक अपना रास्ता कैसे बना सकता है। आपका लक्ष्य योगदानकर्ता अनुभव के प्रत्येक चरण में घर्षण को कम करना है। जब लोगों को आसानी से जीत मिलती है, तो वे और अधिक करने के लिए प्रोत्साहित महसूस करेंगे।

अपने दस्तावेज़ से प्रारंभ करें:

* **किसी के लिए आपके प्रोजेक्ट का उपयोग करना आसान बनाएं।** [एक मैत्रीपूर्ण README लिखना](../starting-a-project/#एक-रीडमी-लिखना) 
और स्पष्ट कोड उदाहरण आपके प्रोजेक्ट पर आने वाले किसी भी व्यक्ति के लिए आरंभ करना आसान बना देंगे।  
* **स्पष्ट रूप से बताएं कि योगदान कैसे करना है**, आपकी [योगदान CONTRIBUTING फ़ाइल का उपयोग करके](../starting-a-project/#अपने-योगदान-संबंधी-दिशानिर्देश-लिखना) और अपने मुद्दों को अद्यतन रखते हुए।
* **अच्छे प्रथम अंक**: नए योगदानकर्ताओं को आरंभ करने में मदद करने के लिए, स्पष्ट रूप से विचार करें [उन मुद्दों को लेबल करना जो शुरुआती लोगों के लिए निपटने के लिए काफी सरल हैं](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). इसके बाद GitHub इन मुद्दों को प्लेटफ़ॉर्म पर विभिन्न स्थानों पर सामने लाएगा, उपयोगी योगदान बढ़ाएगा, और उन मुद्दों से निपटने वाले उपयोगकर्ताओं के मनमुटाव को कम करेगा जो उनके स्तर के लिए बहुत कठिन हैं।

[GitHub का 2017 ओपन सोर्स सर्वेक्षण](http://opensourcesurvey.org/2017/) अपूर्ण या भ्रमित करने वाला दस्तावेज़ दिखाना ओपन सोर्स उपयोगकर्ताओं के लिए सबसे बड़ी समस्या है। अच्छा दस्तावेज़ीकरण लोगों को आपके प्रोजेक्ट के साथ बातचीत करने के लिए आमंत्रित करता है। अंततः, कोई व्यक्ति कोई समस्या खोलेगा या अनुरोध खींच लेगा। इन इंटरैक्शन को फ़नल से नीचे ले जाने के अवसर के रूप में उपयोग करें।

* **जब कोई नया व्यक्ति आपके प्रोजेक्ट पर आता है, तो उनकी रुचि के लिए उन्हें धन्यवाद दें!** किसी को वापस आने से रोकने के लिए केवल एक नकारात्मक अनुभव की आवश्यकता होती है।
* **उत्तरदायी बनें।** यदि आप एक महीने तक उनके मुद्दे पर प्रतिक्रिया नहीं देते हैं, तो संभावना है कि वे पहले ही आपके प्रोजेक्ट के बारे में भूल चुके होंगे।
* **आप जिस प्रकार के योगदान स्वीकार करेंगे, उसके बारे में खुले दिमाग से काम करें।** कई योगदानकर्ता बग रिपोर्ट या छोटे सुधार के साथ शुरुआत करते हैं। [योगदान करने के कई तरीके](../how-to-contribute/#योगदान-देने-का-क्या-मतलब-है) हैं। लोग जिस तरह से मदद करना चाहते हैं, उन्हें मदद करने दें।
* **यदि कोई योगदान है जिससे आप असहमत हैं,** उनके विचार के लिए उन्हें धन्यवाद दें और [समझाइए क्यों](../best-practices/#ना-कहना-सीखना) यह परियोजना के दायरे में फिट नहीं बैठता है, यदि आपके पास प्रासंगिक दस्तावेज हैं तो इसे लिंक करें।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  कुछ लोगों के लिए ओपन सोर्स में योगदान करना दूसरों की तुलना में आसान है। कुछ सही न करने या उसमें फिट न बैठने के कारण चिल्लाए जाने का बहुत डर है। (...) योगदानकर्ताओं को बहुत कम तकनीकी दक्षता (दस्तावेज़ीकरण, वेब सामग्री मार्कडाउन, आदि) के साथ योगदान करने की जगह देकर आप बहुत कम कर सकते हैं वे चिंताएँ.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["आधुनिक ओपन सोर्स में योगदानकर्ता आधार बढ़ाना"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

अधिकांश ओपन सोर्स योगदानकर्ता "आकस्मिक योगदानकर्ता" हैं: वे लोग जो कभी-कभार ही किसी परियोजना में योगदान करते हैं। एक आकस्मिक योगदानकर्ता के पास आपके प्रोजेक्ट को पूरी तरह से गति देने का समय नहीं हो सकता है, इसलिए आपका काम उनके लिए योगदान करना आसान बनाना है।

अन्य योगदानकर्ताओं को प्रोत्साहित करना आपके लिए भी एक निवेश है। जब आप अपने सबसे बड़े प्रशंसकों को उस काम के लिए सशक्त बनाते हैं जिसके लिए वे उत्साहित हैं, तो सब कुछ स्वयं करने का दबाव कम होता है।

### हर चीज़ का दस्तावेजीकरण करें

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  क्या आप कभी किसी (tech) कार्यक्रम में गए हैं जहां आप किसी को नहीं जानते थे, लेकिन बाकी सभी लोग समूहों में खड़े थे और पुराने दोस्तों की तरह बातचीत कर रहे थे? (...) अब कल्पना करें कि आप एक ओपन सोर्स प्रोजेक्ट में योगदान देना चाहते हैं, लेकिन आपको समझ नहीं आ रहा कि ऐसा क्यों या कैसे हो रहा है।
  <p markdown="1" class="pquote-credit">
— @janl, ["सतत खुला स्रोत"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

जब आप कोई नया प्रोजेक्ट शुरू करते हैं, तो अपने काम को निजी रखना स्वाभाविक लग सकता है। लेकिन जब आप अपनी प्रक्रिया को सार्वजनिक रूप से दस्तावेज़ित करते हैं तो ओपन सोर्स प्रोजेक्ट फलते-फूलते हैं।

जब आप चीज़ें लिखते हैं, तो हर कदम पर अधिक लोग भाग ले सकते हैं। आपको किसी ऐसी चीज़ पर मदद मिल सकती है जिसके बारे में आपको पता भी नहीं था कि आपको इसकी ज़रूरत है।

चीज़ों को लिखने का अर्थ केवल तकनीकी दस्तावेज़ीकरण से कहीं अधिक है। जब भी आपको कुछ लिखने या अपने प्रोजेक्ट पर निजी तौर पर चर्चा करने की इच्छा महसूस हो, तो अपने आप से पूछें कि क्या आप इसे सार्वजनिक कर सकते हैं।

अपने प्रोजेक्ट के रोडमैप, आप किस प्रकार के योगदान की तलाश कर रहे हैं, योगदान की समीक्षा कैसे की जाती है, या आपने कुछ निर्णय क्यों लिए, इस बारे में पारदर्शी रहें।

यदि आप देखते हैं कि कई उपयोगकर्ता एक ही समस्या से जूझ रहे हैं, तो उत्तरों को README में दर्ज करें।

बैठकों के लिए, किसी प्रासंगिक मुद्दे पर अपने नोट्स या निष्कर्ष प्रकाशित करने पर विचार करें। पारदर्शिता के इस स्तर से आपको जो फीडबैक मिलेगा वह आपको आश्चर्यचकित कर सकता है।

हर चीज़ का दस्तावेज़ीकरण आपके द्वारा किए जाने वाले काम पर भी लागू होता है। यदि आप अपने प्रोजेक्ट में पर्याप्त अपडेट पर काम कर रहे हैं, तो इसे पुल अनुरोध में डालें और इसे कार्य प्रगति पर (डब्ल्यूआईपी) के रूप में चिह्नित करें। इस तरह, अन्य लोग शुरू से ही इस प्रक्रिया में शामिल महसूस कर सकते हैं।

### उत्तरदायी बनें

जैसे ही आप [अपने प्रोजेक्ट का प्रचार करें](../finding-users), लोगों के पास आपके लिए प्रतिक्रिया होगी. उनके मन में यह सवाल हो सकता है कि चीज़ें कैसे काम करती हैं, या उन्हें आरंभ करने में सहायता की आवश्यकता हो सकती है।

जब कोई व्यक्ति कोई समस्या दर्ज करता है, पुल अनुरोध सबमिट करता है, या आपके प्रोजेक्ट के बारे में कोई प्रश्न पूछता है तो प्रतिक्रियाशील बनने का प्रयास करें। जब आप तुरंत प्रतिक्रिया देते हैं, तो लोगों को लगेगा कि वे एक संवाद का हिस्सा हैं, और वे भाग लेने के लिए अधिक उत्साहित होंगे।

भले ही आप तुरंत अनुरोध की समीक्षा नहीं कर सकते, लेकिन इसे जल्दी स्वीकार करने से जुड़ाव बढ़ाने में मदद मिलती है। यहां बताया गया है कि @tdreyno ने [मिडिलमैन](https://github.com/middleman/middleman/pull/1466) पर पुल अनुरोध का जवाब कैसे दिया:

![बिचौलिए का अनुरोध](/assets/images/building-community/middleman_pr.png)

[मोज़िला के एक अध्ययन में यह पाया गया](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) जिन योगदानकर्ताओं को 48 घंटों के भीतर कोड समीक्षाएँ प्राप्त हुईं, उनकी वापसी और दोहराव योगदान की दर बहुत अधिक थी।

आपके प्रोजेक्ट के बारे में बातचीत इंटरनेट पर स्टैक ओवरफ्लो, ट्विटर या रेडिट जैसे अन्य स्थानों पर भी हो सकती है। आप इनमें से कुछ स्थानों पर सूचनाएं सेट कर सकते हैं ताकि जब कोई आपके प्रोजेक्ट का उल्लेख करे तो आप सतर्क हो जाएं।

### अपने समुदाय को एकत्र होने के लिए जगह दें

अपने समुदाय को एकत्रित होने के लिए जगह देने के दो कारण हैं।

पहला कारण उनके लिए है. लोगों को एक-दूसरे को जानने में मदद करें। समान रुचि वाले लोग अनिवार्य रूप से इसके बारे में बात करने के लिए जगह चाहेंगे। और जब संचार सार्वजनिक और सुलभ होता है, तो कोई भी गति प्राप्त करने और भाग लेने के लिए पिछले अभिलेखों को पढ़ सकता है।

दूसरा कारण आपके लिए है. यदि आप लोगों को अपने प्रोजेक्ट के बारे में बात करने के लिए सार्वजनिक स्थान नहीं देते हैं, तो वे संभवतः आपसे सीधे संपर्क करेंगे। शुरुआत में, निजी संदेशों का "सिर्फ एक बार" जवाब देना काफी आसान लग सकता है। लेकिन समय के साथ, खासकर यदि आपका प्रोजेक्ट लोकप्रिय हो जाता है, तो आप थकावट महसूस करेंगे। अपने प्रोजेक्ट के बारे में लोगों से निजी तौर पर संवाद करने के प्रलोभन से बचें। इसके बजाय, उन्हें एक निर्दिष्ट सार्वजनिक चैनल पर निर्देशित करें।

सार्वजनिक संचार उतना ही सरल हो सकता है जितना लोगों को आपको सीधे ईमेल करने या आपके ब्लॉग पर टिप्पणी करने के बजाय किसी मुद्दे को खोलने के लिए निर्देशित करना। आप अपने प्रोजेक्ट के बारे में लोगों से बात करने के लिए एक मेलिंग सूची भी सेट कर सकते हैं, या एक ट्विटर अकाउंट, स्लैक या आईआरसी चैनल बना सकते हैं। या उपरोक्त सभी प्रयास करें!
[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) समुदाय के सदस्यों की सहायता के लिए हर दूसरे सप्ताह कार्यालय समय अलग रखें:

> कोप्स के पास समुदाय को सहायता और मार्गदर्शन प्रदान करने के लिए हर दूसरे सप्ताह का समय भी निर्धारित होता है। कोप्स अनुरक्षकों ने नवागंतुकों के साथ काम करने, पीआर के साथ मदद करने और नई सुविधाओं पर चर्चा करने के लिए विशेष रूप से समर्पित समय निर्धारित करने पर सहमति व्यक्त की है।

सार्वजनिक संचार के उल्लेखनीय अपवाद हैं: 1. सुरक्षा मुद्दे और 2. संवेदनशील आचार संहिता का उल्लंघन। आपके पास लोगों के लिए इन मुद्दों की निजी तौर पर रिपोर्ट करने का हमेशा एक तरीका होना चाहिए। यदि आप अपने व्यक्तिगत ईमेल का उपयोग नहीं करना चाहते हैं, तो एक समर्पित ईमेल पता सेट करें।

## अपने समुदाय को बढ़ाना

समुदाय अत्यंत शक्तिशाली हैं. वह शक्ति वरदान या अभिशाप हो सकती है, यह इस बात पर निर्भर करता है कि आप उसका उपयोग कैसे करते हैं। जैसे-जैसे आपके प्रोजेक्ट का समुदाय बढ़ता है, उसे विनाश की नहीं बल्कि निर्माण की शक्ति बनने में मदद करने के कई तरीके हैं।

### बुरे अभिनेताओं को बर्दाश्त न करें

कोई भी लोकप्रिय परियोजना अनिवार्य रूप से ऐसे लोगों को आकर्षित करेगी जो आपके समुदाय को मदद करने के बजाय नुकसान पहुंचाते हैं। वे अनावश्यक बहस शुरू कर सकते हैं, छोटी-छोटी बातों पर विवाद कर सकते हैं, या दूसरों को धमका सकते हैं।

इस प्रकार के लोगों के प्रति शून्य-सहिष्णुता की नीति अपनाने की पूरी कोशिश करें। यदि अनियंत्रित छोड़ दिया जाए, तो नकारात्मक लोग आपके समुदाय के अन्य लोगों को असहज कर देंगे। वे चले भी सकते हैं.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  सच तो यह है कि एक सहायक समुदाय का होना महत्वपूर्ण है। मैं अपने सहकर्मियों, मित्रवत इंटरनेट अजनबियों और बातूनी आईआरसी चैनलों की मदद के बिना यह काम कभी नहीं कर पाऊंगा। (...) इससे कम पर समझौता न करें। बेवकूफों के लिए समझौता मत करो.
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["FOSS प्रोजेक्ट कैसे चलाएं"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

आपके प्रोजेक्ट के तुच्छ पहलुओं पर नियमित बहस आपके सहित दूसरों को महत्वपूर्ण कार्यों पर ध्यान केंद्रित करने से विचलित करती है। आपके प्रोजेक्ट में आने वाले नए लोग इन वार्तालापों को देख सकते हैं और भाग नहीं लेना चाहेंगे।

जब आप अपने प्रोजेक्ट पर नकारात्मक व्यवहार होते देखें, तो उसे सार्वजनिक रूप से बताएं। दयालु लेकिन दृढ़ स्वर में बताएं कि उनका व्यवहार स्वीकार्य क्यों नहीं है। यदि समस्या बनी रहती है, तो आपको इसकी आवश्यकता हो सकती है [उन्हें जाने के लिए कहो](../code-of-conduct/#अपनी-आचार-संहिता-लागू-करना). आपके [आचार संहिता](../code-of-conduct/) इन वार्तालापों के लिए एक रचनात्मक मार्गदर्शक हो सकता है।

### योगदानकर्ताओं से वहीं मिलें जहां वे हैं

जैसे-जैसे आपका समुदाय बढ़ता है, अच्छा दस्तावेज़ीकरण और अधिक महत्वपूर्ण हो जाता है। आकस्मिक योगदानकर्ता, जो अन्यथा आपके प्रोजेक्ट से परिचित नहीं हो सकते हैं, उन्हें जिस संदर्भ की आवश्यकता है उसे तुरंत प्राप्त करने के लिए आपके दस्तावेज़ को पढ़ें।

अपनी योगदान फ़ाइल में, नए योगदानकर्ताओं को स्पष्ट रूप से बताएं कि शुरुआत कैसे करें। आप इस उद्देश्य के लिए एक समर्पित अनुभाग भी बनाना चाह सकते हैं। उदाहरण के लिए, [Django](https://github.com/django/django) के पास नए योगदानकर्ताओं का स्वागत करने के लिए एक विशेष लैंडिंग पृष्ठ है।

![Django नया योगदानकर्ता पृष्ठ](/assets/images/building-community/django_new_contributors.png)

अपनी समस्या कतार में, ऐसे बग लेबल करें जो विभिन्न प्रकार के योगदानकर्ताओं के लिए उपयुक्त हों: उदाहरण के लिए, [_"first timers only"_](https://kentcdodds.com/blog/first-timers-only), _"good first issue"_, or _"documentation"_. [These labels](https://github.com/librariesio/libraries.io/blob/6afea1a3354aef4672d9b3a9fc4cc308d60020c8/app/models/github_issue.rb#L8-L14) आपके प्रोजेक्ट में नए व्यक्ति के लिए आपके मुद्दों को तुरंत स्कैन करना और आरंभ करना आसान बनाएं।

अंत में, लोगों को हर कदम पर स्वागत महसूस कराने के लिए अपने दस्तावेज़ का उपयोग करें।

आप उन अधिकांश लोगों के साथ कभी बातचीत नहीं करेंगे जो आपके प्रोजेक्ट पर आते हैं। ऐसे योगदान भी हो सकते हैं जो आपको इसलिए नहीं मिले क्योंकि कोई व्यक्ति डरा हुआ महसूस कर रहा था या नहीं जानता था कि कहां से शुरुआत करें। यहां तक ​​कि कुछ दयालु शब्द भी किसी को हताशा में आपका प्रोजेक्ट छोड़ने से रोक सकते हैं।

उदाहरण के लिए, यहां बताया गया है कि कैसे [Rubinius](https://github.com/rubinius/rubinius/) प्रारंभ होगा [its contributing guide](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md):

> हम रुबिनियस का उपयोग करने के लिए आपको धन्यवाद कहकर शुरुआत करना चाहते हैं। यह परियोजना प्यार का परिश्रम है, और हम उन सभी उपयोगकर्ताओं की सराहना करते हैं जो बग पकड़ते हैं, प्रदर्शन में सुधार करते हैं और दस्तावेज़ीकरण में मदद करते हैं। प्रत्येक योगदान सार्थक है, इसलिए भाग लेने के लिए धन्यवाद। जैसा कि कहा जा रहा है, यहां कुछ दिशानिर्देश दिए गए हैं जिनका पालन करने के लिए हम आपसे कहते हैं ताकि हम आपकी समस्या का सफलतापूर्वक समाधान कर सकें।

### अपने प्रोजेक्ट का स्वामित्व साझा करें

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  आपके नेताओं की अलग-अलग राय होगी, जैसा कि सभी स्वस्थ समुदायों को होना चाहिए! हालाँकि, आपको यह सुनिश्चित करने के लिए कदम उठाने की ज़रूरत है कि सबसे ऊँची आवाज़ हमेशा लोगों को थका कर जीत न दिलाए, और कम प्रमुख और अल्पसंख्यक आवाज़ें सुनी जाएँ।
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["एक अच्छा समुदाय क्या बनता है?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

जब लोग स्वामित्व की भावना महसूस करते हैं तो वे परियोजनाओं में योगदान देने के लिए उत्साहित होते हैं। इसका मतलब यह नहीं है कि आपको अपने प्रोजेक्ट के दृष्टिकोण को बदलना होगा या उन योगदानों को स्वीकार करना होगा जो आप नहीं चाहते हैं। लेकिन जितना अधिक आप दूसरों को श्रेय देंगे, उतना ही अधिक वे आपके साथ बने रहेंगे।

देखें कि क्या आप अपने समुदाय के साथ स्वामित्व को यथासंभव साझा करने के तरीके ढूंढ सकते हैं। यहाँ कुछ विचार हैं:

* **आसान (गैर-महत्वपूर्ण) बग को ठीक करने का विरोध करें।** इसके बजाय, उन्हें नए योगदानकर्ताओं को भर्ती करने के अवसर के रूप में उपयोग करें, या किसी ऐसे व्यक्ति का मार्गदर्शन करें जो योगदान देना चाहता है। यह पहली बार में अस्वाभाविक लग सकता है, लेकिन आपका निवेश समय के साथ फल देगा। उदाहरण के लिए, @michaeljoseph ने एक योगदानकर्ता से इसे स्वयं ठीक करने के बजाय नीचे दिए गए [कुकीकटर](https://github.com/audreyr/cookiecutter) मुद्दे पर एक पुल अनुरोध सबमिट करने के लिए कहा।

![Cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **अपने प्रोजेक्ट में एक योगदानकर्ता या लेखक फ़ाइल प्रारंभ करें** जिसमें आपके प्रोजेक्ट में योगदान देने वाले सभी लोगों की सूची हो, जैसे [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md) 
करता है.

* यदि आपके पास एक बड़ा समुदाय है, तो **एक समाचार पत्र भेजें या एक ब्लॉग पोस्ट लिखें** योगदानकर्ताओं को धन्यवाद दें। जंग का [This Week in Rust](https://this-week-in-rust.org/) और हुडीज़ [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) दो अच्छे उदाहरण हैं.

* **प्रत्येक योगदानकर्ता को पहुंच प्रदान करें** @felixge ने पाया कि इसने लोगों को बनाया है [more excited to polish their patches](https://felixge.de/2013/03/11/the-pull-request-hack.html), और उन्हें उन परियोजनाओं के लिए नए अनुरक्षक भी मिल गए जिन पर उन्होंने कुछ समय से काम नहीं किया था।

* यदि आपका प्रोजेक्ट GitHub पर है, **move your project from your personal account to an [Organization](https://help.github.com/articles/creating-a-new-organization-account/)** और कम से कम एक बैकअप व्यवस्थापक जोड़ें. संगठन बाहरी सहयोगियों के साथ परियोजनाओं पर काम करना आसान बनाते हैं।

हकीकत तो यही है [most projects only have](https://peerj.com/preprints/1233/) एक या दो अनुरक्षक जो अधिकांश कार्य करते हैं। आपका प्रोजेक्ट जितना बड़ा होगा, और आपका समुदाय जितना बड़ा होगा, सहायता पाना उतना ही आसान होगा।

हालाँकि आपको कॉल का उत्तर देने के लिए हमेशा कोई नहीं मिल सकता है, लेकिन वहाँ सिग्नल लगाने से अन्य लोगों के कॉल करने की संभावना बढ़ जाती है। और आप जितनी जल्दी शुरुआत करेंगे, उतनी जल्दी लोग मदद कर सकते हैं।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  \[यह आपके हित में है\] ऐसे योगदानकर्ताओं को भर्ती करना जो आनंद लेते हैं और जो वह काम करने में सक्षम हैं जो आप नहीं कर सकते। क्या आपको कोडिंग में मजा आता है, लेकिन मुद्दों का जवाब देना नहीं? फिर अपने समुदाय में उन व्यक्तियों की पहचान करें जो ऐसा करते हैं और उन्हें ऐसा करने दें।
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## विवादों का समाधान

आपके प्रोजेक्ट के शुरुआती चरणों में, बड़े निर्णय लेना आसान होता है। जब आप कुछ करना चाहते हैं, तो आप बस उसे करते हैं।

जैसे-जैसे आपका प्रोजेक्ट अधिक लोकप्रिय होगा, अधिक लोग आपके निर्णयों में रुचि लेंगे। भले ही आपके पास योगदानकर्ताओं का एक बड़ा समुदाय न हो, यदि आपके प्रोजेक्ट में बहुत सारे उपयोगकर्ता हैं, तो आप पाएंगे कि लोग निर्णयों पर विचार कर रहे हैं या अपने स्वयं के मुद्दे उठा रहे हैं।

अधिकांश भाग के लिए, यदि आपने एक मैत्रीपूर्ण, सम्मानजनक समुदाय विकसित किया है और अपनी प्रक्रियाओं को खुले तौर पर प्रलेखित किया है, तो आपका समुदाय समाधान खोजने में सक्षम होना चाहिए। लेकिन कभी-कभी आप ऐसे मुद्दे में फंस जाते हैं जिसका समाधान करना थोड़ा कठिन होता है।

### दयालुता का स्तर निर्धारित करें

जब आपका समुदाय किसी कठिन मुद्दे से जूझ रहा हो, तो गुस्सा बढ़ सकता है। लोग क्रोधित या निराश हो सकते हैं और इसे एक-दूसरे पर या आप पर निकाल सकते हैं।

एक अनुरक्षक के रूप में आपका काम इन स्थितियों को बढ़ने से रोकना है। भले ही विषय पर आपकी राय मजबूत हो, लड़ाई में कूदने और अपने विचारों को आगे बढ़ाने के बजाय एक मॉडरेटर या फैसिलिटेटर की स्थिति लेने का प्रयास करें। यदि कोई निर्दयी हो रहा है या बातचीत पर एकाधिकार जमा रहा है, [तुरंत कार्रवाई करें](../building-community/#बुरे-अभिनेताओं-को-बर्दाश्त-न-करें) 
चर्चाओं को सभ्य और उत्पादक बनाए रखना।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
एक प्रोजेक्ट अनुरक्षक के रूप में, अपने योगदानकर्ताओं के प्रति सम्मानजनक होना बेहद महत्वपूर्ण है। वे अक्सर आप जो कहते हैं उसे बहुत व्यक्तिगत रूप से लेते हैं।
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

अन्य लोग मार्गदर्शन के लिए आपकी ओर देख रहे हैं। अच्छा उदाहरण स्थापित करो। आप अभी भी निराशा, नाखुशी या चिंता व्यक्त कर सकते हैं, लेकिन ऐसा शांति से करें।

खुद को शांत रखना आसान नहीं है, लेकिन नेतृत्व प्रदर्शित करने से आपके समुदाय के स्वास्थ्य में सुधार होता है। इंटरनेट आपका धन्यवाद करता है.

### अपने README को एक संविधान मानें

आपका README है [निर्देशों के एक संग्रह से कहीं अधिक](../starting-a-project/#एक-रीडमी-लिखना). यह आपके लक्ष्यों, उत्पाद दृष्टिकोण और रोडमैप के बारे में बात करने का भी स्थान है। यदि लोग किसी विशेष सुविधा की योग्यता पर बहस करने पर अत्यधिक ध्यान केंद्रित कर रहे हैं, तो यह आपके README पर दोबारा गौर करने और आपके प्रोजेक्ट की उच्च दृष्टि के बारे में बात करने में मदद कर सकता है। अपने README पर ध्यान केंद्रित करने से बातचीत भी अवैयक्तिक हो जाती है, जिससे आप रचनात्मक चर्चा कर सकते हैं।

### यात्रा पर ध्यान दें, मंजिल पर नहीं

कुछ परियोजनाएँ प्रमुख निर्णय लेने के लिए मतदान प्रक्रिया का उपयोग करती हैं। पहली नज़र में समझदार होते हुए भी, मतदान एक-दूसरे की चिंताओं को सुनने और संबोधित करने के बजाय "उत्तर" पाने पर जोर देता है।

मतदान राजनीतिक हो सकता है, जहां समुदाय के सदस्य एक-दूसरे का पक्ष लेने या एक निश्चित तरीके से मतदान करने के लिए दबाव महसूस करते हैं। चाहे वह कोई भी हो, हर कोई वोट नहीं देता [silent majority](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) आपके समुदाय में, या वर्तमान उपयोगकर्ताओं को, जिन्हें नहीं पता था कि वोट हो रहा है।

कभी-कभी, मतदान एक आवश्यक टाईब्रेकर होता है। हालाँकि, जितना आप सक्षम हैं, आम सहमति के बजाय ["आम सहमति की तलाश"](https://en.wikipedia.org/wiki/Consensus-seeking_decision-making) पर जोर दें।

सर्वसम्मति प्राप्त करने की प्रक्रिया के तहत, समुदाय के सदस्य प्रमुख चिंताओं पर तब तक चर्चा करते हैं जब तक उन्हें नहीं लगता कि उन्हें पर्याप्त रूप से सुना गया है। जब केवल छोटी-मोटी चिंताएँ बची रहती हैं, तो समुदाय आगे बढ़ता है। "आम सहमति की मांग" यह स्वीकार करती है कि एक समुदाय एक सटीक उत्तर तक पहुंचने में सक्षम नहीं हो सकता है। इसके बजाय, यह सुनने और चर्चा को प्राथमिकता देता है।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  एटम मुद्दों के लिए वोटिंग प्रणाली मौजूद न होने का एक कारण यह है कि एटम टीम सभी मामलों में वोटिंग प्रणाली का पालन नहीं करेगी। कभी-कभी हमें वही चुनना पड़ता है जो हमें सही लगता है, भले ही वह अलोकप्रिय हो। (...) मैं जो पेशकश कर सकता हूं और करने की प्रतिज्ञा कर सकता हूं...वह यह है कि समुदाय की बात सुनना मेरा काम है।
  <p markdown="1" class="pquote-credit">
— @lee-dohm on Atom's decision making process
  </p>
</aside>

भले ही आप वास्तव में सर्वसम्मति प्राप्त करने की प्रक्रिया नहीं अपनाते हों, एक परियोजना अनुरक्षक के रूप में, यह महत्वपूर्ण है कि लोग जानें कि आप सुन रहे हैं। अन्य लोगों को यह महसूस कराना कि उनकी बात सुनी जा रही है, और उनकी चिंताओं को हल करने के लिए प्रतिबद्ध होना, संवेदनशील स्थितियों को दूर करने में काफी मदद करता है। फिर, अपने शब्दों को कार्यों के साथ जारी रखें।

किसी संकल्प के लिए निर्णय लेने में जल्दबाजी न करें। सुनिश्चित करें कि हर कोई यह महसूस करे कि समाधान की ओर बढ़ने से पहले सभी जानकारी सार्वजनिक कर दी गई है।

### बातचीत को कार्रवाई पर केंद्रित रखें

चर्चा महत्वपूर्ण है, लेकिन उत्पादक और अनुत्पादक बातचीत में अंतर है।

चर्चा को तब तक प्रोत्साहित करें जब तक यह सक्रिय रूप से समाधान की ओर बढ़ रही हो। यदि यह स्पष्ट है कि बातचीत धीमी हो रही है या विषय से भटक रही है, तीखी नोकझोंक व्यक्तिगत होती जा रही है, या लोग छोटी-छोटी बातों को लेकर झगड़ रहे हैं, तो इसे बंद करने का समय आ गया है।

इन वार्तालापों को जारी रखने की अनुमति देना न केवल मौजूदा मुद्दे के लिए बुरा है, बल्कि आपके समुदाय के स्वास्थ्य के लिए भी बुरा है। यह एक संदेश भेजता है कि इस प्रकार की बातचीत की अनुमति है या इसे प्रोत्साहित भी किया जाता है, और यह लोगों को भविष्य के मुद्दों को उठाने या हल करने से हतोत्साहित कर सकता है।

आपके द्वारा या दूसरों द्वारा उठाए गए प्रत्येक बिंदु पर, अपने आप से पूछें, _"यह हमें किसी समाधान के करीब कैसे लाता है?"_

यदि बातचीत सुलझने लगी है, तो बातचीत पर फिर से ध्यान केंद्रित करने के लिए समूह से पूछें, _"हमें आगे कौन सा कदम उठाना चाहिए?"_

यदि बातचीत स्पष्ट रूप से कहीं नहीं जा रही है, कोई स्पष्ट कार्रवाई नहीं की जानी है, या उचित कार्रवाई पहले ही की जा चुकी है, तो मुद्दे को बंद करें और बताएं कि आपने इसे क्यों बंद किया।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  बिना किसी दबाव के किसी धागे को उपयोगिता की ओर ले जाना एक कला है। केवल लोगों को अपना समय बर्बाद करना बंद करने की चेतावनी देना, या उन्हें पोस्ट न करने के लिए कहना, जब तक कि उनके पास कहने के लिए कुछ रचनात्मक न हो, काम नहीं करेगा। (...) इसके बजाय, आपको आगे की प्रगति के लिए शर्तों का सुझाव देना होगा: लोगों को एक मार्ग दें, अनुसरण करने के लिए एक रास्ता जो आपके इच्छित परिणामों की ओर ले जाए, फिर भी ऐसा लगे बिना कि आप आचरण निर्धारित कर रहे हैं।
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### अपनी लड़ाइयाँ बुद्धिमानी से चुनें

प्रसंग महत्वपूर्ण है. विचार करें कि चर्चा में कौन शामिल है और वे शेष समुदाय का प्रतिनिधित्व कैसे करते हैं।

क्या समुदाय में हर कोई इस मुद्दे से परेशान है, या इससे जुड़ा भी है? या एक अकेला उपद्रवी है? केवल सक्रिय आवाज़ों पर ही नहीं, बल्कि अपने मूक समुदाय के सदस्यों पर भी विचार करना न भूलें।

यदि मुद्दा आपके समुदाय की व्यापक आवश्यकताओं का प्रतिनिधित्व नहीं करता है, तो आपको बस कुछ लोगों की चिंताओं को स्वीकार करने की आवश्यकता हो सकती है। यदि यह बिना किसी स्पष्ट समाधान के बार-बार आने वाला मुद्दा है, तो उन्हें विषय पर पिछली चर्चाओं की ओर इंगित करें और थ्रेड बंद कर दें।

### एक सामुदायिक टाईब्रेकर की पहचान करें

अच्छे रवैये और स्पष्ट संचार के साथ, अधिकांश कठिन परिस्थितियाँ हल हो सकती हैं। हालाँकि, एक सार्थक बातचीत में भी, कैसे आगे बढ़ना है, इस पर राय में अंतर हो सकता है। इन मामलों में, ऐसे व्यक्ति या लोगों के समूह की पहचान करें जो टाईब्रेकर के रूप में काम कर सकते हैं।

एक टाईब्रेकर परियोजना का प्राथमिक अनुरक्षक हो सकता है, या यह लोगों का एक छोटा समूह हो सकता है जो मतदान के आधार पर निर्णय लेता है। आदर्श रूप से, आपने गवर्नेंस फ़ाइल का उपयोग करने से पहले उसमें एक टाईब्रेकर और संबंधित प्रक्रिया की पहचान कर ली है।

आपका टाईब्रेकर अंतिम उपाय होना चाहिए। विभाजनकारी मुद्दे आपके समुदाय के लिए बढ़ने और सीखने का एक अवसर हैं। इन अवसरों को स्वीकार करें और जहां भी संभव हो समाधान की ओर बढ़ने के लिए सहयोगात्मक प्रक्रिया का उपयोग करें।

## समुदाय खुले स्रोत का ❤️ है

स्वस्थ, संपन्न समुदाय हर सप्ताह खुले स्रोत में खर्च किए गए हजारों घंटों को ऊर्जा प्रदान करते हैं। कई योगदानकर्ता खुले स्रोत पर काम करने - या काम न करने - का कारण अन्य लोगों को बताते हैं। रचनात्मक रूप से उस शक्ति का उपयोग करना सीखकर, आप किसी को अविस्मरणीय ओपन सोर्स अनुभव प्राप्त करने में मदद करेंगे।
