---
lang: hi
title: मेंटेनर्स के लिए सर्वोत्तम प्रैक्टिस
description: आपके जीवन को आसान बनाने के तरीके, संग्रहणिक प्रक्रियाओं से लेकर आपकी समुदाय का उपयोग करने तक, एक ओपन सोर्स मेंटेनर के रूप में।
class: best-practices
order: 5
image: /assets/images/cards/best-practices.png
related:
  - metrics
  - leadership
---

## मेंटेनर का मतलब क्या है?

अगर आप किसी खुले स्रोत परियोजना का पालन करते हैं जिसका बहुत सारे लोग उपयोग करते हैं, तो आपने देखा होगा कि आप कोडिंग कम और मुद्दों के जवाब देने ज्यादा कर रहे हैं।

परियोजना के प्रारंभिक चरण में, आप नए विचारों की प्रायोगिकता कर रहे होते हैं और निर्णय वही लेते हैं जो आप चाहते हैं। जब आपकी परियोजना लोकप्रिय होने लगती है, तो आप अपने उपयोगकर्ताओं और सहयोगियों के साथ काम करने के बारे में अधिक सोचेंगे।

परियोजना को संभालने के लिए कोड से ज्यादा की आवश्यकता होती है। ये कार्य अक्सर अप्रत्याशित होते हैं, लेकिन एक बढ़ती हुई परियोजना के लिए ये उतने ही महत्वपूर्ण होते हैं। हमने कुछ तरीके जुटाए हैं जो आपके जीवन को आसान बनाने में मदद करेंगे, प्रक्रियाओं की दस्तावेजीकरण से लेकर आपकी समुदाय का उपयोग करने तक।

## प्रक्रियाओं की दस्तावेजीकरण

चीजों को लिखना मेंटेनर के रूप में आपकी सबसे महत्वपूर्ण चीजों में से एक है।

दस्तावेजीकरण न केवल आपके विचारों को स्पष्ट करता है, बल्कि यह दूसरे लोगों को समझने में मदद करता है कि आपकी क्या आवश्यकताएं हैं या आपकी क्या उम्मीदें हैं, उनसे पहले ही।

चीजें लिखने से, कुछ आपके स्कोप में नहीं आने पर "नहीं" कहना आसान हो जाता है। यह लोगों को साथ में आने और मदद करने के लिए भी आसान बनाता है। आप कभी नहीं जान सकते कि कौन-सा व्यक्ति आपकी परियोजना को पढ़ रहा है या उसका उपयोग कर रहा है।

चाहे आप पूरे पैराग्राफ ना भी उपयोग करें, बुलेट पॉइंट्स को लिखना बिना कुछ लिखे होने से बेहतर है।

याद रखें कि आपकी दस्तावेजीकरण को अपडेट रखने की आवश्यकता है। अगर आप हमेशा इसे अपडेट नहीं कर पा रहे हैं, तो अपने पुराने दस्तावेजीकरण को हटा दें या इसे पुराना बताएं ताकि सहयोगी जानें कि अपडेट्स का स्वागत है।

### अपनी परियोजना की दृष्टि लिखें

परियोजना के लक्ष्यों को लिखने की शुरुआत करें। उन्हें अपने README में जोड़ें, या एक अलग फ़ाइल जिसे VISION के नाम से बुलाया जा सकता है, बनाएं। अगर कोई और आर्टिफैक्ट हो सकते हैं जो मदद कर सकते हैं, जैसे कि परियोजना का रोडमैप, तो उन्हें भी सार्वजनिक बनाएं।

स्पष्ट, दस्तावेजीत दृष्टि आपको ध्यान में रखने में मदद करती है और आपको दूसरों के सहयोग से आने वाले "स्कोप क्रीप" से बचाती है।

उदाहरण के लिए, @lord ने यह जानकर पाया कि परियोजना की दृष्टि रखने से उसने यह तय किया कि किन अनुरोधों पर समय खर्च करना चाहिए। एक नए मेंटेनर के रूप में, उसने खेद किया कि उसने अपनी परियोजना की दिशा को न अपनाकर अपने पहले विशेषता अनुरोध के लिए [Slate](https://github.com/lord/slate) को मान्यता दी।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lord?s=180" class="pquote-avatar" alt="avatar">
  मैंने इसे गलती से किया। मैंने किसी पूर्ण समाधान को लाने के लिए प्रयास नहीं किया। आधे-पूरे समाधान की जगह, मुझे खेद है कि मैंने यह नहीं कहा "मेरे पास इसके लिए अभी समय नहीं है, लेकिन मैं इसे दीर्घकालिक सूची में जोड़ दूंगा जिसे हमारे लिए अच्छा हो सकता है।"
  <p markdown="1" class="pquote-credit">
— @lord, ["नए ओपन सोर्स अनुरक्षकों के लिए युक्तियाँ"](https://lord.io/blog/2014/oss-tips/)
  </p>
</aside>

### आपकी उम्मीदाएँ संवाद करें

नियम लिखने के लिए हो सकते हैं और समय-समय पर यह घबराने वाला होता है। कभी-कभी आपको ऐसा लग सकता है कि आप दूसरों के व्यवहार की पुलिसी बना रहे हैं या सब मज़ा खत्म कर रहे हैं।

लेकिन यदि नियम स्पष्ट, लिखित और सावधानीपूर्वक पालन किए जाएं, तो यह मेंटेनर्स को सशक्त बनाते हैं। वे आपको उन कामों में नहीं फंसने से बचाते हैं जिन्हें आप करना नहीं चाहते।

आपकी परियोजना के बारे में ज्यादातर लोग आपके बारे में कुछ भी नहीं जानते हैं या आपके परिस्थितियों के बारे में। वे मान सकते हैं कि आप इस पर काम करने के लिए पैसे प्राप्त करते हैं, विशेष रूप से अगर यह कुछ है जिसका वे नियमित रूप से उपयोग करते हैं और उस पर निर्भर करते हैं। शायद किसी समय आपने अपनी परियोजना में काफी समय लगाया था, लेकिन अब आप एक नई नौकरी या परिवार के सदस्य के साथ व्यस्त हैं।

ये सब बिल्कुल ठीक है! बस यह सुनिश्चित करें कि अन्य लोग इसके बारे में जानते हैं।

यदि आपकी परियोजना को पार्ट-टाइम या पूरी तरह से स्वयंसेवा में बनाए रखना है, तो यह स्पष्ट रूप से बताएं कि आपके पास कितना समय है। यह उस समय के समान नहीं है जिसकी परियोजना को आपकी आवश्यकता है, या उस समय के समान नहीं है जिसे दुसरों को आपके खर्च करने के लिए चाहिए।

यहाँ कुछ नियम हैं जो लिखने योग्य हैं:

* किसी योगदान की समीक्षा और स्वीकार कैसे की जाती है (_क्या उन्हें परीक्षण की आवश्यकता है? एक समस्या टेम्पलेट?_)
* योगदान के प्रकार जिन्हें आप स्वीकार करेंगे (_क्या आप केवल अपने कोड के एक निश्चित भाग के लिए सहायता चाहते हैं?_)
* जब फॉलो-अप करना उचित हो (_उदाहरण के लिए, "आप 7 दिनों के भीतर अनुरक्षक से प्रतिक्रिया की उम्मीद कर सकते हैं। यदि आपने तब तक कुछ नहीं सुना है, तो बेझिझक थ्रेड को पिंग करें।"_)
* आप प्रोजेक्ट पर कितना समय बिताते हैं (उदाहरण के लिए, "हम इस प्रोजेक्ट पर प्रति सप्ताह केवल 5 घंटे खर्च करते हैं"_)

[Jekyll](https://github.com/jekyll/jekyll/tree/master/docs), [CocoaPods](https://github.com/CocoaPods/CocoaPods/wiki/Communication-&-Design-Rules), and [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Maintainers-Avoiding-Burnout.md) अनुरक्षकों और योगदानकर्ताओं के लिए बुनियादी नियमों वाली परियोजनाओं के कई उदाहरण हैं।

### संवाद को सार्वजनिक रखें

अपने संवादों को डॉक्युमेंट करना न भूलें। जहां भी संभव हो, अपनी परियोजना के बारे में होने वाले संवाद को सार्वजनिक रूप से रखें। यदि कोई किसी विशेषता अनुरोध या समर्थन की आवश्यकता के लिए आपसे निजी तौर पर संपर्क करने का प्रयास करता है, तो उन्हें सवालों की सार्वजनिक संवाद स्रोत, जैसे कि मेलिंग सूची या समस्या ट्रैकर, की ओर सभीष्ठता से प्रेषित करें।

यदि आप अन्य संरक्षकों से मिलते हैं, या यदि आप निजी तौर पर महत्वपूर्ण निर्णय लेते हैं, तो इन संवादों को सार्वजनिक डॉक्युमेंट करें, चाहे आपके नोट पोस्ट करने के बारे में भी हो।

इस तरह, जो भी आपकी समुदाय में शामिल होता है, वह उसी जानकारी तक पहुँच पाएगा जो सालों से वहाँ हैने वाले किसी के पास है।

## ना कहना सीखना

आपने बातें लिख दी हैं. आदर्श रूप से, हर कोई आपके दस्तावेज़ को पढ़ेगा, लेकिन वास्तव में, आपको दूसरों को याद दिलाना होगा कि यह ज्ञान मौजूद है।

हालाँकि, सब कुछ लिखित होने से उन स्थितियों को वैयक्तिकृत करने में मदद मिलती है जब आपको अपने नियमों को लागू करने की आवश्यकता होती है।

ना कहना मज़ेदार नहीं है, लेकिन _"आपका योगदान इस परियोजना के मानदंडों से मेल नहीं खाता"__"मुझे आपका योगदान पसंद नहीं है"_ की तुलना में कम व्यक्तिगत लगता है।

ना कहना उन कई स्थितियों पर लागू होता है जिनका सामना आप एक अनुरक्षक के रूप में करेंगे: सुविधा अनुरोध जो दायरे में फिट नहीं होते हैं, कोई व्यक्ति चर्चा को पटरी से उतार रहा है, दूसरों के लिए अनावश्यक काम कर रहा है।

### बातचीत मित्रवत रखें

सबसे महत्वपूर्ण स्थानों में से एक जहां आप ना कहने का अभ्यास करेंगे, वह है आपके मुद्दे पर और अनुरोध कतार को खींचना। एक प्रोजेक्ट अनुरक्षक के रूप में, आपको अनिवार्य रूप से ऐसे सुझाव प्राप्त होंगे जिन्हें आप स्वीकार नहीं करना चाहते हैं।

हो सकता है कि योगदान आपके प्रोजेक्ट का दायरा बदल दे या आपके दृष्टिकोण से मेल न खाए। हो सकता है कि विचार अच्छा हो, लेकिन कार्यान्वयन ख़राब हो।

कारण चाहे जो भी हो, उन योगदानों को चतुराई से संभालना संभव है जो आपके प्रोजेक्ट के मानकों को पूरा नहीं करते हैं।

यदि आपको कोई योगदान मिलता है जिसे आप स्वीकार नहीं करना चाहते हैं, तो आपकी पहली प्रतिक्रिया इसे अनदेखा करना या दिखावा करना हो सकता है कि आपने इसे नहीं देखा है। ऐसा करने से दूसरे व्यक्ति की भावनाएं आहत हो सकती हैं और यहां तक ​​कि आपके समुदाय में अन्य संभावित योगदानकर्ता भी हतोत्साहित हो सकते हैं।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/krausefx?s=180" class="pquote-avatar" alt="avatar">
  बड़े स्केल के ओपन सोर्स प्रोजेक्ट्स के समर्थन को हैंडल करने की कुंजी है, मुद्दों को आगे बढ़ाने की कोशिश करें। मुद्दों को ठप करने से बचने का प्रयास करें। यदि आप एक iOS डेवलपर हैं, तो आप जानते हैं कि रेडर्स (radars) सबमिट करना कितना खिचड़ हो सकता है। आप 2 साल बाद प्रतिक्रिया प्राप्त कर सकते हैं, और आपको नवीनतम iOS संस्करण के साथ पुनः प्रयास करने की सलाह दी जा सकती है।
  <p markdown="1" class="pquote-credit">
— @KrauseFx, ["ओपन सोर्स समुदायों को स्केल करना"](https://krausefx.com/blog/scaling-open-source-communities)
  </p>
</aside>

अनचाहे योगदान को खुले छोडने का कारण यह नहीं होना चाहिए कि आपको आपत्ति महसूस हो रही हो या आप अच्छे बनना चाहते हों। समय के साथ, आपके बिना उत्तरित मुद्दे और पुल रिक्वेस्ट (PRs) से आपके प्रोजेक्ट पर काम करने में अधिक तनावपूर्ण और डरावनी भावना उत्पन्न हो सकती है।

जिन योगदानों को आप जानते हैं कि आप स्वीकार नहीं करना चाहते, उन्हें तुरंत बंद कर देना बेहतर है। यदि आपका प्रोजेक्ट पहले से ही बड़े बैकलॉग से ग्रस्त है, @steveklabnik [how to triage issues efficiently](https://words.steveklabnik.com/how-to-be-an-open-source-gardener) के लिए सुझाव हैं .

योगदान को नज़रअंदाज करना आपके समुदाय को नकारात्मक संकेत भेजता है। किसी प्रोजेक्ट में योगदान देना डराने वाला हो सकता है, खासकर अगर यह किसी के लिए पहली बार हो। भले ही आप उनके योगदान को स्वीकार न करें, इसके पीछे वाले व्यक्ति को स्वीकार करें और उनकी रुचि के लिए उन्हें धन्यवाद दें। यह एक बड़ी प्रशंसा है!

यदि आप कोई योगदान स्वीकार नहीं करना चाहते हैं:

* **उन्हें उनके योगदान के लिए धन्यवाद**
* **स्पष्ट करें कि यह परियोजना के दायरे में क्यों फिट नहीं बैठता**, और यदि आप सक्षम हैं तो सुधार के लिए स्पष्ट सुझाव दें। दयालु बनें, लेकिन दृढ़ रहें।
* **प्रासंगिक दस्तावेज का लिंक**, यदि आपके पास है। यदि आप उन चीज़ों के लिए बार-बार अनुरोध देखते हैं जिन्हें आप स्वीकार नहीं करना चाहते हैं, तो उन्हें दोहराने से बचने के लिए उन्हें अपने दस्तावेज़ में जोड़ें।
* **अनुरोध बंद करें**

You shouldn't need more than 1-2 sentences to respond. For example, when a user of [celery](https://github.com/celery/celery/) reported a Windows-related error, @berkerpeksag [responded with](https://github.com/celery/celery/issues/3383):

![Celery screenshot](/assets/images/best-practices/celery.png)

यदि ना कहने का विचार आपको भयभीत करता है, तो आप अकेले नहीं हैं। जैसा @jessfraz [put it](https://blog.jessfraz.com/post/the-art-of-closing/):

> मैंने कई अलग-अलग ओपन सोर्स प्रोजेक्ट्स, मेसोस, कुबेरनेट्स, क्रोमियम के अनुरक्षकों से बात की है, और वे सभी इस बात से सहमत हैं कि अनुरक्षक होने के सबसे कठिन हिस्सों में से एक उन पैच को "नहीं" कहना है जिन्हें आप नहीं चाहते हैं।

किसी के योगदान को स्वीकार न करने को लेकर दोषी महसूस न करें। ओपन सोर्स का पहला नियम, [according to](https://twitter.com/solomonstre/status/715277134978113536) @shykes: _"
नहीं अस्थायी है, हाँ हमेशा के लिए है।"_ जबकि किसी अन्य व्यक्ति के उत्साह के साथ सहानुभूति रखना अच्छी बात है, किसी योगदान को अस्वीकार करना उसके पीछे वाले व्यक्ति को अस्वीकार करने के समान नहीं है।

अंततः, यदि कोई योगदान पर्याप्त नहीं है, तो आप इसे स्वीकार करने के लिए बाध्य नहीं हैं। जब लोग आपके प्रोजेक्ट में योगदान दें तो दयालु और उत्तरदायी बनें, लेकिन केवल उन बदलावों को स्वीकार करें जिनके बारे में आपको वास्तव में विश्वास है कि वे आपके प्रोजेक्ट को बेहतर बनाएंगे। आप जितनी बार ना कहने का अभ्यास करेंगे, यह उतना ही आसान हो जाएगा। वादा करना।

### सक्रिय होना

सबसे पहले अवांछित योगदान की मात्रा को कम करने के लिए, अपने योगदान मार्गदर्शिका में योगदान जमा करने और स्वीकार करने के लिए अपने प्रोजेक्ट की प्रक्रिया की व्याख्या करें।

यदि आपको बहुत अधिक निम्न-गुणवत्ता वाले योगदान प्राप्त हो रहे हैं, तो आवश्यक है कि योगदानकर्ता पहले से ही थोड़ा काम करें, उदाहरण के लिए:

* कोई अंक या पीआर टेम्पलेट/चेकलिस्ट भरें
* पीआर सबमिट करने से पहले एक मुद्दा खोलें

यदि वे आपके नियमों का पालन नहीं करते हैं, तो समस्या को तुरंत बंद करें और अपने दस्तावेज़ की ओर इंगित करें।

हालाँकि यह दृष्टिकोण पहली बार में निर्दयी लग सकता है, सक्रिय होना वास्तव में दोनों पक्षों के लिए अच्छा है। इससे इस बात की संभावना कम हो जाती है कि कोई व्यक्ति काम के कई घंटे बर्बाद करके ऐसे पुल अनुरोध में लगाएगा जिसे आप स्वीकार नहीं करेंगे। और यह आपके कार्यभार को प्रबंधित करना आसान बनाता है।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
  आदर्श रूप से, उन्हें CONTRIBUTING.md फ़ाइल में समझाएं कि वे भविष्य में काम शुरू करने से पहले बेहतर संकेत कैसे प्राप्त कर सकते हैं कि क्या स्वीकार किया जाएगा या क्या नहीं।
  <p markdown="1" class="pquote-credit">
— @MikeMcQuaid, ["कृपया पुल अनुरोध बंद करें"](https://github.com/blog/2124-kindly-closing-pull-requests)
  </p>
</aside>

कभी-कभी, जब आप ना कहते हैं, तो आपका संभावित योगदानकर्ता परेशान हो सकता है या आपके निर्णय की आलोचना कर सकता है। यदि उनका व्यवहार शत्रुतापूर्ण हो जाए, [स्थिति को शांत करने के लिए कदम उठाएं](https://github.com/jonschlinkert/maintainers-guide-to-staying-positive#action-items) या यदि वे रचनात्मक रूप से सहयोग करने के इच्छुक नहीं हैं, तो उन्हें अपने समुदाय से हटा भी दें।

### मार्गदर्शन को गले लगाओ

हो सकता है कि आपके समुदाय में कोई व्यक्ति नियमित रूप से ऐसे योगदान सबमिट करता हो जो आपके प्रोजेक्ट के मानकों को पूरा नहीं करता हो। बार-बार अस्वीकृतियों से गुजरना दोनों पक्षों के लिए निराशाजनक हो सकता है।

यदि आप देखते हैं कि कोई आपके प्रोजेक्ट को लेकर उत्साहित है, लेकिन उसे थोड़ा निखारने की जरूरत है, तो धैर्य रखें। प्रत्येक स्थिति में स्पष्ट रूप से बताएं कि उनका योगदान परियोजना की अपेक्षाओं को पूरा क्यों नहीं करता है। उन्हें किसी आसान या कम अस्पष्ट कार्य की ओर इंगित करने का प्रयास करें, जैसे उनके पैरों को गीला करने के लिए _"अच्छा पहला अंक,"_ चिह्नित कोई मुद्दा। यदि आपके पास समय है, तो उनके पहले योगदान के माध्यम से उन्हें सलाह देने पर विचार करें, या अपने समुदाय में किसी और को ढूंढें जो उन्हें सलाह देने के लिए तैयार हो सकता है।

## अपने समुदाय का लाभ उठाएं

आपको सब कुछ खुद ही करने की ज़रूरत नहीं है. आपके प्रोजेक्ट का समुदाय किसी कारण से मौजूद है! भले ही आपके पास अभी तक कोई सक्रिय योगदानकर्ता समुदाय नहीं है, यदि आपके पास बहुत सारे उपयोगकर्ता हैं, तो उन्हें काम पर लगाएं।

### कार्यभार साझा करें

यदि आप मदद के लिए दूसरों की तलाश कर रहे हैं, तो आसपास पूछकर शुरुआत करें।

नए योगदानकर्ताओं को प्राप्त करने का एक तरीका स्पष्ट रूप से है [ऐसे लेबल मुद्दे जो शुरुआती लोगों के लिए निपटने के लिए काफी सरल हैं](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). इसके बाद GitHub इन मुद्दों को प्लेटफ़ॉर्म पर विभिन्न स्थानों पर प्रदर्शित करेगा, जिससे उनकी दृश्यता बढ़ेगी।

जब आप नए योगदानकर्ताओं को बार-बार योगदान करते हुए देखें, तो अधिक जिम्मेदारी देकर उनके काम को पहचानें। दस्तावेज़ बनाएं कि यदि अन्य लोग चाहें तो नेतृत्व की भूमिका में कैसे विकसित हो सकते हैं।

दूसरों को इसके लिए प्रोत्साहित करना [अपने प्रोजेक्ट का स्वामित्व साझा करें](../building-community/#अपने-प्रोजेक्ट-का-स्वामित्व-साझा-करें) आपके स्वयं के कार्यभार को बहुत कम कर सकता है, जैसा कि @lmccart ने अपने प्रोजेक्ट पर पाया, [p5.js](https://github.com/processing/p5.js).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lmccart?s=180" class="pquote-avatar" alt="avatar">
  मैं कह रहा था, "हाँ, कोई भी शामिल हो सकता है, आपके पास बहुत अधिक कोडिंग विशेषज्ञता होनी आवश्यक नहीं है [...]।" हमारे पास लोगों ने [एक कार्यक्रम में] आने के लिए साइन अप किया था और तभी मैं वास्तव में सोच रहा था: क्या यह सच है, जो मैं कह रहा हूं? वहाँ 40 लोग आने वाले हैं, और ऐसा नहीं है कि मैं उनमें से प्रत्येक के साथ बैठ सकता हूँ...लेकिन लोग एक साथ आए, और यह काम कर गया। जैसे ही एक व्यक्ति को यह मिल गया, वे अपने पड़ोसी को सिखा सकते थे।
  <p markdown="1" class="pquote-credit">
—  @lmccart, ["ओपन सोर्स" का क्या मतलब है? p5.js Edition"](https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39)
  </p>
</aside>

यदि आपको अपने प्रोजेक्ट से हटना है, या तो अंतराल पर या स्थायी रूप से, तो किसी और को आपकी जगह लेने के लिए कहने में कोई शर्म की बात नहीं है।

यदि अन्य लोग इसकी दिशा को लेकर उत्साहित हैं, तो उन्हें प्रतिबद्ध पहुंच प्रदान करें या औपचारिक रूप से नियंत्रण किसी और को सौंप दें। यदि किसी ने आपके प्रोजेक्ट को फोर्क किया है और इसे कहीं और सक्रिय रूप से बनाए रख रहा है, तो अपने मूल प्रोजेक्ट से फोर्क को जोड़ने पर विचार करें। यह बहुत अच्छा है कि इतने सारे लोग चाहते हैं कि आपका प्रोजेक्ट चालू रहे!

@progrium [ने पाया कि](https://web.archive.org/web/20151204215958/https://progrium.com/blog/2015/12/04/leadership-guilt-and-pull-requests/) अपने प्रोजेक्ट, [Dokku](https://github.com/dokku/dokku) के लिए विज़न का दस्तावेजीकरण करने से, प्रोजेक्ट से जाने के बाद भी उन लक्ष्यों को जीवित रखने में मदद मिली:

> मैंने एक विकी पेज लिखा जिसमें बताया गया कि मैं क्या चाहता था और मैं यह क्यों चाहता था। किसी कारण से यह मेरे लिए आश्चर्य की बात थी कि अनुरक्षकों ने परियोजना को उस दिशा में आगे बढ़ाना शुरू कर दिया! क्या यह बिल्कुल वैसा ही हुआ जैसा मैंने इसे किया था? हमेशा नहीं। लेकिन फिर भी यह परियोजना को मैंने जो लिखा था उसके करीब ले आया।

### दूसरों को वे समाधान बनाने दें जिनकी उन्हें आवश्यकता है

यदि किसी संभावित योगदानकर्ता की इस बारे में अलग राय है कि आपके प्रोजेक्ट को क्या करना चाहिए, तो आप उन्हें धीरे-धीरे अपने स्वयं के कांटे पर काम करने के लिए प्रोत्साहित करना चाह सकते हैं।

किसी प्रोजेक्ट को फोर्क करना कोई बुरी बात नहीं है। प्रोजेक्टों को कॉपी और संशोधित करने में सक्षम होना ओपन सोर्स के बारे में सबसे अच्छी चीजों में से एक है। अपने समुदाय के सदस्यों को अपने स्वयं के फ़ोर्क पर काम करने के लिए प्रोत्साहित करना, आपके प्रोजेक्ट के दृष्टिकोण के साथ टकराव किए बिना, उन्हें आवश्यक रचनात्मक आउटलेट प्रदान कर सकता है।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/geerlingguy?s=180" class="pquote-avatar" alt="avatar">
  मैं 80% उपयोग के मामले को पूरा करता हूं। यदि आप यूनिकॉर्न में से एक हैं, तो कृपया मेरे काम को छोड़ दें। मैं नाराज नहीं होऊंगा! मेरी सार्वजनिक परियोजनाएँ लगभग हमेशा सबसे आम समस्याओं को हल करने के लिए होती हैं; मैं या तो अपने काम को आगे बढ़ाकर या इसे विस्तारित करके गहराई तक जाना आसान बनाने की कोशिश करता हूं।
  <p markdown="1" class="pquote-credit">
— @geerlingguy, ["मैं पीआर क्यों बंद करता हूँ?"](https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes)
  </p>
</aside>

यही बात उस उपयोगकर्ता पर लागू होती है जो वास्तव में एक ऐसा समाधान चाहता है जिसे बनाने के लिए आपके पास बैंडविड्थ नहीं है। एपीआई और अनुकूलन हुक की पेशकश दूसरों को स्रोत को सीधे संशोधित किए बिना, अपनी जरूरतों को पूरा करने में मदद कर सकती है। @orta [ने पाया कि](https://artsy.github.io/blog/2016/07/03/handling-big-projects/) कोकोपोड्स के लिए प्लगइन्स को प्रोत्साहित करने से "कुछ सबसे दिलचस्प विचार" सामने आए:

> यह लगभग अपरिहार्य है कि एक बार जब कोई परियोजना बड़ी हो जाती है, तो अनुरक्षकों को इस बारे में अधिक रूढ़िवादी बनना पड़ता है कि वे नए कोड कैसे पेश करते हैं। आप "नहीं" कहने में अच्छे हो जाते हैं, लेकिन बहुत से लोगों की ज़रूरतें वैध होती हैं। तो, इसके बजाय आप अपने टूल को एक प्लेटफ़ॉर्म में परिवर्तित कर देते हैं।

## रोबोट लाओ

जिस प्रकार ऐसे कार्य हैं जिनमें अन्य लोग आपकी सहायता कर सकते हैं, वैसे ही ऐसे कार्य भी हैं जिन्हें किसी भी मनुष्य को कभी नहीं करना चाहिए। रोबोट आपके मित्र हैं. एक अनुरक्षक के रूप में अपने जीवन को आसान बनाने के लिए उनका उपयोग करें।

### आपके कोड की गुणवत्ता में सुधार के लिए परीक्षण और अन्य जांच की आवश्यकता है

परीक्षण जोड़कर अपने प्रोजेक्ट को स्वचालित करने का सबसे महत्वपूर्ण तरीका है।

परीक्षण योगदानकर्ताओं को यह विश्वास दिलाने में मदद करते हैं कि वे कुछ भी नहीं तोड़ेंगे। वे आपके लिए योगदान की शीघ्रता से समीक्षा करना और स्वीकार करना भी आसान बनाते हैं। आप जितने अधिक संवेदनशील होंगे, आपका समुदाय उतना ही अधिक सक्रिय हो सकता है।

स्वचालित परीक्षण सेट करें जो आने वाले सभी योगदानों पर चलेंगे, और सुनिश्चित करें कि आपके परीक्षण योगदानकर्ताओं द्वारा स्थानीय स्तर पर आसानी से चलाए जा सकें। आवश्यक है कि सबमिट किए जाने से पहले सभी कोड योगदान आपके परीक्षणों में उत्तीर्ण हों। आप सभी प्रस्तुतियों के लिए गुणवत्ता का न्यूनतम मानक निर्धारित करने में मदद करेंगे। GitHub पर [आवश्यक स्थिति जांच](https://help.github.com/articles/about-required-status-checks/) यह सुनिश्चित करने में मदद कर सकता है कि आपके परीक्षण पास किए बिना कोई भी परिवर्तन मर्ज नहीं किया जाएगा।

यदि आप परीक्षण जोड़ते हैं, तो यह बताना सुनिश्चित करें कि वे आपकी CONTRIBUTING फ़ाइल में कैसे काम करते हैं।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/edunham?s=180" class="pquote-avatar" alt="avatar">
  मेरा मानना ​​है कि उन सभी कोड के लिए परीक्षण आवश्यक हैं जिन पर लोग काम करते हैं। यदि कोड पूरी तरह से और पूरी तरह से सही था, तो इसमें बदलाव की आवश्यकता नहीं होगी - हम केवल तभी कोड लिखते हैं जब कुछ गलत होता है, चाहे वह "यह क्रैश हो जाता है" या "इसमें ऐसी और ऐसी सुविधा का अभाव है"। और चाहे आप जो भी बदलाव कर रहे हों, आपके द्वारा गलती से पेश किए गए किसी भी प्रतिगमन को पकड़ने के लिए परीक्षण आवश्यक हैं।
  <p markdown="1" class="pquote-credit">
— @edunham, ["Rust का सामुदायिक स्वचालन"](https://edunham.net/2016/09/27/rust_s_community_automation.html)
  </p>
</aside>

### बुनियादी रखरखाव कार्यों को स्वचालित करने के लिए टूल का उपयोग करें

एक लोकप्रिय परियोजना को बनाए रखने के बारे में अच्छी खबर यह है कि अन्य रखरखावकर्ताओं ने संभवतः इसी तरह के मुद्दों का सामना किया है और उनके लिए एक समाधान तैयार किया है।

रखरखाव कार्य के कुछ पहलुओं को स्वचालित करने में मदद के लिए [विभिन्न प्रकार के उपकरण उपलब्ध हैं](https://github.com/showcases/tools-for-open-source) हैं। कुछ उदाहरण:

* [semantic-release](https://github.com/semantic-release/semantic-release) automates your releases
* [mention-bot](https://github.com/facebook/mention-bot) mentions potential reviewers for pull requests
* [Danger](https://github.com/danger/danger) helps automate code review
* [no-response](https://github.com/probot/no-response) closes issues where the author hasn't responded to a request for more information
* [dependabot](https://github.com/dependabot) checks your dependency files every day for outdated requirements and opens individual pull requests for any it finds

बग रिपोर्ट और अन्य सामान्य योगदानों के लिए, GitHub के पास [इश्यू टेम्प्लेट्स और पुल रिक्वेस्ट टेम्प्लेट्स](https://github.com/blog/2111-issue-and-pull-request-templates) हैं, जिन्हें आप संचार को सुव्यवस्थित करने के लिए बना सकते हैं आपको प्राप्त हुया। @TalAter ने आपके मुद्दे और पीआर टेम्प्लेट लिखने में आपकी मदद करने के लिए एक [अपनी खुद की एडवेंचर गाइड चुनें](https://www.talater.com/open-source-templates/#/) बनाई है।

अपनी ईमेल सूचनाओं को प्रबंधित करने के लिए, आप प्राथमिकता के आधार पर व्यवस्थित करने के लिए [ईमेल फ़िल्टर](https://github.com/blog/2203-email-updates-about-your-own-activity) सेट कर सकते हैं।

यदि आप थोड़ा और उन्नत होना चाहते हैं, तो स्टाइल गाइड और लिंटर परियोजना योगदान को मानकीकृत कर सकते हैं और उनकी समीक्षा करना और स्वीकार करना आसान बना सकते हैं।

हालाँकि, यदि आपके मानक बहुत जटिल हैं, तो वे योगदान में बाधाएँ बढ़ा सकते हैं। सुनिश्चित करें कि आप सभी के जीवन को आसान बनाने के लिए केवल पर्याप्त नियम जोड़ रहे हैं।

यदि आप निश्चित नहीं हैं कि कौन से टूल का उपयोग करना है, तो देखें कि अन्य लोकप्रिय प्रोजेक्ट क्या करते हैं, विशेष रूप से आपके पारिस्थितिकी तंत्र में। उदाहरण के लिए, अन्य नोड मॉड्यूल के लिए योगदान प्रक्रिया कैसी दिखती है? समान टूल और दृष्टिकोण का उपयोग करने से आपकी प्रक्रिया आपके लक्षित योगदानकर्ताओं के लिए अधिक परिचित हो जाएगी।

## विराम देना ठीक है

ओपन सोर्स का काम एक बार आपके लिए खुशी लेकर आया। शायद अब यह आपको टालने या दोषी महसूस कराने लगा है।

जब आप अपनी परियोजनाओं के बारे में सोचते हैं तो शायद आप अभिभूत महसूस कर रहे हों या भय की भावना बढ़ रही हो। और इस बीच, मुद्दों और पुल अनुरोधों का ढेर लग जाता है।

ओपन सोर्स कार्य में बर्नआउट एक वास्तविक और व्यापक मुद्दा है, विशेषकर अनुरक्षकों के बीच। एक अनुरक्षक के रूप में, किसी भी ओपन सोर्स प्रोजेक्ट के अस्तित्व के लिए आपकी खुशी एक गैर-परक्राम्य आवश्यकता है।

हालाँकि यह बिना कहे चला जाना चाहिए, एक ब्रेक लें! आपको छुट्टी लेने के लिए तब तक इंतजार नहीं करना चाहिए जब तक आप थका हुआ महसूस न करें। @brettcannon, एक पायथन कोर डेवलपर, ने 14 साल के स्वयंसेवक OSS के बाद [एक महीने की छुट्टी](https://snarky.ca/why-i-took-october-off-from-oss-volunteering/) लेने का फैसला किया काम।

किसी भी अन्य प्रकार के काम की तरह, नियमित ब्रेक लेने से आप अपने काम के प्रति तरोताजा, खुश और उत्साहित रहेंगे।

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielbachhuber?s=180" class="pquote-avatar" alt="avatar">
  WP-CLI को बनाए रखने में, मैंने पाया है कि मुझे पहले खुद को खुश करने की ज़रूरत है, और अपनी भागीदारी पर स्पष्ट सीमाएँ निर्धारित करनी होंगी। मेरे सामान्य कार्य शेड्यूल के एक भाग के रूप में, मुझे जो सबसे अच्छा संतुलन मिला है, वह प्रति सप्ताह 2-5 घंटे है। इससे मेरी भागीदारी एक जुनून बनी रहती है, और मुझे काम जैसा महसूस नहीं होता। क्योंकि मैं उन मुद्दों को प्राथमिकता देता हूं जिन पर मैं काम कर रहा हूं, मैं उस पर नियमित प्रगति कर सकता हूं जो मुझे लगता है कि सबसे महत्वपूर्ण है।
  <p markdown="1" class="pquote-credit">
— @danielbachhuber, ["मेरी संवेदनाएं, अब आप एक लोकप्रिय ओपन सोर्स प्रोजेक्ट के अनुरक्षक हैं"](https://web.archive.org/web/20220306014037/https://danielbachhuber.com/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/)
  </p>
</aside>

कभी-कभी, जब ऐसा महसूस हो कि हर किसी को आपकी ज़रूरत है तो ओपन सोर्स कार्य से ब्रेक लेना कठिन हो सकता है। लोग आपको दूर जाने के लिए दोषी महसूस कराने का प्रयास भी कर सकते हैं।

जब आप किसी प्रोजेक्ट से दूर हों तो अपने उपयोगकर्ताओं और समुदाय के लिए समर्थन पाने की पूरी कोशिश करें। यदि आपको आवश्यक सहायता नहीं मिल पा रही है, तो फिर भी एक ब्रेक ले लें। जब आप उपलब्ध न हों तो संवाद करना सुनिश्चित करें, ताकि लोग आपकी प्रतिक्रियाशीलता की कमी से भ्रमित न हों।

ब्रेक लेना केवल छुट्टियों के अलावा और भी बहुत कुछ पर लागू होता है। यदि आप सप्ताहांत पर या काम के घंटों के दौरान ओपन सोर्स काम नहीं करना चाहते हैं, तो उन अपेक्षाओं को दूसरों को बताएं, ताकि वे जान सकें कि आपको परेशान नहीं करना है।

## पहले अपना ख्याल रखें!

किसी लोकप्रिय प्रोजेक्ट को बनाए रखने के लिए विकास के शुरुआती चरणों की तुलना में अलग कौशल की आवश्यकता होती है, लेकिन यह कम फायदेमंद नहीं है। एक अनुरक्षक के रूप में, आप नेतृत्व और व्यक्तिगत कौशल का उस स्तर पर अभ्यास करेंगे जिसका अनुभव बहुत कम लोगों को होता है। हालाँकि इसे प्रबंधित करना हमेशा आसान नहीं होता है, स्पष्ट सीमाएँ निर्धारित करना और केवल वही लेना जिसमें आप सहज हों, आपको खुश, तरोताज़ा और उत्पादक रहने में मदद करेगा।
