---
lang: fr
untranslated: true
title: Maintaining Balance for Open Source Maintainers
description: Tips for self-care and avoiding burnout as a maintainer.
class: balance
order: 0
image: /assets/images/cards/maintaining-balance-for-open-source-maintainers.png
---

Au fure et a mesure qu'un projet open source gagne en popularité, il devient important de fixer des limites claires pour vous aider à maintenir l'équilibre afin de rester frais et productif à long terme. 

Afin de mieux comprendre les expériences des mainteneurs et leurs stratégies pour trouver un équilibre, nous avons organisé un atelier avec 40 membres de la <a href="http://maintainers.github.com/">communauté des mainteneurs</a>, ce qui nous a permis d'apprendre de leurs expériences directes de l'épuisement professionnel dans l'open source et des pratiques qui les ont aidés à maintenir l'équilibre dans leur travail. C'est là que le concept d'écologie personnelle entre en jeu.

Alors, qu'est-ce que l'écologie personnelle ? Comme <a href="https://rockwoodleadership.org/nonprofit-four-day-workweek-can-take-care-still-change-world/#:~:text=personal%20ecology%3A%20maintaining%20balance%2C%20pacing%20and%20efficiency%20to%20sustain%20your%20energy%20over%20a%20lifetime%20of%20activism">le décrit le Rockwood Leadership Institute</a>, il s'agit de « maintenir l'équilibre, le rythme et l'efficacité pour soutenir notre énergie tout au long de la vie ». Cela a encadré nos conversations, en aidant les responsables à reconnaître que leurs actions et leurs contributions font partie d'un écosystème plus large qui évolue au fil du temps. L'épuisement professionnel, un syndrome résultant d'un stress chronique sur le lieu de travail [tel que défini par l'OMS](https://icd.who.int/browse/2024-01/mms/fr#129180281), n'est pas rare chez les responsables de la maintenance. Il se traduit souvent par une perte de motivation, une incapacité à se concentrer et un manque d'empathie à l'égard des contributeurs et de la communauté avec laquelle vous travaillez.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  J'étais incapable de me concentrer ou de commencer une tâche. Je manquais d'empathie pour les utilisateurs.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, mainteneur du serveur de streaming en direct Owncast, à propos de l'impact de l'épuisement professionnel sur son travail dans le domaine de l'open source.
  </p>
</aside>

En adoptant le concept d'écologie personnelle, les responsables de la maintenance peuvent éviter de manière proactive l'épuisement professionnel, donner la priorité aux soins personnels et maintenir un sens de l'équilibre afin de faire leur meilleur travail.

## Astuces pour prendre soin de soi et éviter l'épuisement en tant que responsable de maintenance :

### Identifier vos motivations pour travailler dans l'open source

Prenez le temps de réfléchir aux aspects de la maintenance des logiciels libres qui vous stimulent. Comprendre vos motivations peut vous aider à prioriser le travail de manière à rester engagé et prêt à relever de nouveaux défis. Qu'il s'agisse des réactions positives des utilisateurs, de la joie de collaborer et de socialiser avec la communauté ou de la satisfaction de se plonger dans le code, le fait de reconnaître vos motivations peut vous aider à vous concentrer.

### Réfléchissez à ce qui vous déséquilibre et vous stresse.

Il est important de comprendre les causes de l'épuisement professionnel. Voici quelques thèmes communs aux mainteneurs de logiciels libres :

* **Absence de retours positifs:** Les utilisateurs sont beaucoup plus enclins à se manifester lorsqu'ils ont une plainte à formuler. Si tout fonctionne parfaitement, ils ont tendance à rester silencieux. Il peut être décourageant de voir la liste des problèmes s'allonger sans que les commentaires positifs montrent que votre contribution fait la différence.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/thisisnic?s=180" class="pquote-avatar" alt="avatar">
  Parfois, j'ai l'impression de crier dans le vide et je trouve que le retour d'information me donne beaucoup d'énergie. Nous avons beaucoup d'utilisateurs heureux mais silencieux.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/thisisnic">@thisisnic</a>, mainteneur d'Apache Arrow
  </p>
</aside>

* **Ne pas dire « non »:** Il peut être facile de prendre plus de responsabilités qu'on ne le devrait sur un projet open source. Que ce soit de la part des utilisateurs, des contributeurs ou d'autres mainteneurs, nous ne pouvons pas toujours répondre à leurs attentes.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/agnostic-apollo?s=180" class="pquote-avatar" alt="avatar">
 Je me suis rendu compte que j'assumais plus qu'il ne fallait et que je devais faire le travail de plusieurs personnes, comme c'est souvent le cas dans les logiciels libres.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/agnostic-apollo">@agnostic-apollo</a>, mainteneur de Termux, sur les causes de l'épuisement au travail
  </p>
</aside>

* **Travailler en solitaire :** Être un mainteneur peut être incroyablement solitaire. Même si vous travaillez avec un groupe de mainteneurs, les dernières années ont été difficiles pour réunir des équipes dispersées en personne.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
 Surtout depuis COVID et le travail à domicile, il est plus difficile de ne voir personne et de ne parler à personne.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, mainteneur du serveur de streaming en direct Owncast, à propos de l'impact de l'épuisement professionnel sur son travail dans le domaine de l'open source.
  </p>
</aside>

* **Manque de temps et de ressources :** C'est particulièrement vrai pour les mainteneurs bénévoles qui doivent sacrifier leur temps libre pour travailler sur un projet.

<aside markdown="1" class="pquote">
  [J'aimerais avoir]  plus de soutien financier, afin que je puisse me concentrer sur le travail de l'open source sans brûler mes économies et en sachant que je devrai faire beaucoup de contrats pour me rattraper plus tard.
  <p markdown="1" class="pquote-credit">
— Un Mainteneur Open Source
  </p>
</aside>

* **Demandes contradictoires :**  L'open source est un ensemble de groupes aux motivations diverses, dans lequel il peut être difficile de s'y retrouver. Si vous êtes payé pour faire de l'open source, les intérêts de votre employeur peuvent parfois être en contradiction avec ceux de la communauté.

<aside markdown="1" class="pquote">
  Dans le cas des logiciels libres payants, il existe un conflit entre l'objectif de l'employeur et ce qui est le mieux pour la communauté.
  
  <p markdown="1" class="pquote-credit">
— Un Mainteneur Open Source
  </p>
</aside>

### Faites attention aux signes d'épuisement professionnel

Pouvez-vous maintenir votre rythme pendant 10 semaines ? 10 mois ? 10 ans ?

Il existe des outils comme la [Burnout Checklist](https://governingopen.com/resources/signs-of-burnout-checklist.html) de [@shaunagm](https://github.com/shaunagm) qui peuvent vous aider à réfléchir à votre rythme actuel et à voir s'il y a des ajustements à faire. Certains mainteneurs utilisent également une technologie portable pour suivre des paramètres tels que la qualité du sommeil et la variabilité du rythme cardiaque (tous deux liés au stress).

<aside markdown="1" class="pquote">
 Je suis un fervent partisan des outils portables de qualité. Grâce à la science, vous pouvez comprendre comment vous auriez pu faire mieux et comment atteindre un état optimal de ce que vous voulez faire.
  
  <p markdown="1" class="pquote-credit">
— Un Mainteneur Open Source
  </p>
</aside>

### De quoi auriez-vous besoin pour continuer à subvenir à vos besoins et à ceux de votre communauté ?

Cela sera différent pour chaque responsable, et changera en fonction de votre phase de vie et d'autres facteurs externes. Mais voici quelques thèmes que nous avons entendus :

* **Appuyez-vous sur la communauté:**  La délégation et la recherche de collaborateurs peuvent alléger la charge de travail. Le fait d'avoir plusieurs points de contact pour un projet peut vous aider à faire une pause sans vous inquiéter. Entrez en contact avec d'autres mainteneurs et la communauté au sens large, dans des groupes tels que la [Communauté des mainteneurs](http://maintainers.github.com/). Il peut s'agir d'une excellente ressource pour l'entraide et l'apprentissage.

  Vous pouvez également chercher des moyens de vous engager auprès de la communauté des utilisateurs, afin d'obtenir régulièrement des informations en retour et de comprendre l'impact de votre travail sur les logiciels libres.

* **Explorer le financement :** Que vous soyez à la recherche d'un peu d'argent pour une pizza ou que vous essayiez de vous lancer à plein temps dans l'open source, il existe de nombreuses ressources pour vous aider ! Dans un premier temps, pensez à activer [GitHub Sponsors](https://github.com/sponsors) pour permettre à d'autres de sponsoriser votre travail open source. Si vous envisagez de passer à temps plein, postulez pour le prochain cycle de l'[Accélérateur GitHub](http://accelerator.github.com/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mansona?s=180" class="pquote-avatar" alt="avatar">
 Il y a quelque temps, j'ai participé à un podcast et nous avons discuté de la maintenance et de la durabilité des logiciels libres. J'ai constaté que même un petit nombre de personnes soutenant mon travail sur GitHub m'a aidé à prendre la décision rapide de ne pas m'asseoir devant un jeu, mais plutôt de faire une petite chose avec l'open source.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mansona">@mansona</a>, maintainer de EmberJS
  </p>
</aside>

* **Utilisez les outils:** Profitez d'outils tels que [GitHub Copilot](https://github.com/features/copilot/) et [GitHub Actions](https://github.com/features/actions) pour automatiser les tâches banales et libérer votre temps pour des contributions plus significatives.

<aside markdown="1" class="pquote">
 Utilisez [Copilot](https://github.com/features/copilot/) pour les choses ennuyeuses - faites les choses amusantes.
  
  <p markdown="1" class="pquote-credit">
— Un Mainteneur Open Source
  </p>
</aside>

* **Se reposer et se ressourcer :** Consacrez du temps à vos loisirs et à vos centres d'intérêt en dehors de l'open source. Prenez vos week-ends pour vous détendre et vous ressourcer, et réglez votre [statut GitHub](https://docs.github.com/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/personalizing-your-profile#setting-a-status) pour qu'il reflète votre disponibilité ! Une bonne nuit de sommeil peut faire une grande différence dans votre capacité à soutenir vos efforts à long terme.
Si certains aspects de votre projet vous plaisent particulièrement, essayez de structurer votre travail de manière à en faire l'expérience tout au long de la journée.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielroe?s=180" class="pquote-avatar" alt="avatar">
   Je trouve davantage d'occasions de ménager des « moments de créativité » au milieu de la journée plutôt que d'essayer de me déconnecter le soir.
  
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/danielroe">@danielroe</a>, maintaineur de Nuxt
  </p>
</aside>

* **Definir des limites :** Vous ne pouvez pas dire oui à toutes les demandes. Cela peut être aussi simple que de dire « Je ne peux pas le faire maintenant et je n'ai pas l'intention de le faire à l'avenir », ou d'énumérer ce que vous souhaitez faire et ne pas faire dans le fichier README. Par exemple, vous pourriez dire : « Je ne fusionne que les PR dont les raisons sont clairement listées » ou "Je n'examine les problèmes qu'un jeudi sur deux, de 18 à 19 heures". Cela définit les attentes des autres et vous donne un point de repère à d'autres moments pour aider à désamorcer les demandes de contributeurs ou d'utilisateurs sur votre temps.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
Pour faire confiance aux autres sur ces axes, vous ne pouvez pas être quelqu'un qui dit oui à toutes les demandes. Ce faisant, vous ne respectez aucune limite, ni sur le plan professionnel ni sur le plan personnel, et vous ne serez pas un collègue fiable.
  
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mikemcquaid">@mikemcquaid</a>, mainteneur de Homebrew sur [Saying No](https://mikemcquaid.com/saying-no/)
  </p>
</aside>

  Apprenez à faire preuve de fermeté pour mettre fin aux comportements toxiques et aux interactions négatives. Il est normal de ne pas donner d'énergie à des choses qui ne vous intéressent pas.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/IvanSanchez?s=180" class="pquote-avatar" alt="avatar">
Mon logiciel est gratuit, mais mon temps et mon attention ne le sont pas.
  
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/IvanSanchez">@IvanSanchez</a>, maintaineur de Leaflet
  </p>
</aside>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/foosel?s=180" class="pquote-avatar" alt="avatar">
Ce n'est un secret pour personne que la maintenance des logiciels libres a ses côtés sombres, et l'un d'entre eux est d'avoir parfois à interagir avec des personnes assez ingrates, qui ont le droit d'agir ou qui sont carrément toxiques. À mesure que la popularité d'un projet augmente, la fréquence de ce type d'interaction s'accroît, ce qui alourdit le fardeau des mainteneurs et peut devenir un facteur de risque important pour l'épuisement des mainteneurs.
  
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/foosel">@foosel</a>, mainteneur de Octoprint sur [Comment gérer les personnes toxiques](https://www.youtube.com/watch?v=7lIpP3GEyXs)
  </p>
</aside>

N'oubliez pas que l'écologie personnelle est une pratique permanente qui évoluera au fur et à mesure que vous progresserez dans votre voyage vers l'open source. En accordant la priorité à la prise en charge de soi et au maintien d'un équilibre, vous pouvez contribuer à la communauté open source de manière efficace et durable, en assurant à la fois votre bien-être et le succès de vos projets sur le long terme.

## Ressources complémentaires

* [Maintainer Community](http://maintainers.github.com/)
* [The social contract of open source](https://snarky.ca/the-social-contract-of-open-source/), Brett Cannon
* [Uncurled](https://daniel.haxx.se/uncurled/), Daniel Stenberg 
* [How to deal with toxic people](https://www.youtube.com/watch?v=7lIpP3GEyXs), Gina Häußge
* [SustainOSS](https://sustainoss.org/)
* [Rockwood Art of Leadership](https://rockwoodleadership.org/art-of-leadership/)
* [Saying No](hhttps://mikemcquaid.com/saying-no/), Mike McQuaid
* [Governing Open](https://governingopen.com/)
* Workshop agenda was remixed from [Mozilla's Movement Building from Home](https://foundation.mozilla.org/en/blog/its-a-wrap-movement-building-from-home/) series

## Contributors

Many thanks to all the maintainers who shared their experiences and tips with us for this guide!

This guide was written by [@abbycabs](https://github.com/abbycabs) with contributions from: 

[@agnostic-apollo](https://github.com/agnostic-apollo)
[@AndreaGriffiths11](https://github.com/AndreaGriffiths11)
[@antfu](https://github.com/antfu)
[@anthonyronda](https://github.com/anthonyronda)
[@CBID2](https://github.com/CBID2)
[@Cli4d](https://github.com/Cli4d)
[@confused-Techie](https://github.com/confused-Techie)
[@danielroe](https://github.com/danielroe)
[@Dexters-Hub](https://github.com/Dexters-Hub)
[@eddiejaoude](https://github.com/eddiejaoude)
[@Eugeny](https://github.com/Eugeny)
[@ferki](https://github.com/ferki)
[@gabek](https://github.com/gabek)
[@geromegrignon](https://github.com/geromegrignon)
[@hynek](https://github.com/hynek)
[@IvanSanchez](https://github.com/IvanSanchez)
[@karasowles](https://github.com/karasowles)
[@KoolTheba](https://github.com/KoolTheba)
[@leereilly](https://github.com/leereilly)
[@ljharb](https://github.com/ljharb)
[@nightlark](https://github.com/nightlark)
[@plarson3427](https://github.com/plarson3427)
[@Pradumnasaraf](https://github.com/Pradumnasaraf)
[@RichardLitt](https://github.com/RichardLitt)
[@rrousselGit](https://github.com/rrousselGit)
[@sansyrox](https://github.com/sansyrox)
[@schlessera](https://github.com/schlessera)
[@shyim](https://github.com/shyim)
[@smashah](https://github.com/smashah)
[@ssalbdivad](https://github.com/ssalbdivad)
[@The-Compiler](https://github.com/The-Compiler)
[@thehale](https://github.com/thehale)
[@thisisnic](https://github.com/thisisnic)
[@tudoramariei](https://github.com/tudoramariei)
[@UlisesGascon](https://github.com/UlisesGascon)
[@waldyrious](https://github.com/waldyrious) + many others!
