---
lang: fr
title: Comment contribuer à l'Open Source
description: Vous voulez contribuer à l'Open Source ? Un guide pour faire des contributions Open Source, pour les débutants et pour les vétérans.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## Pourquoi contribuer &agrave; l'open source

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  Travailler sur \[freenode\] m'a aidé à acquérir plusieurs des compétences que j'ai utilisées plus tard pour mes études à l'université et mon travail actuel. Je pense que travailler sur des projets open source m'aide autant que ça aide le projet !
  <p markdown="1" class="pquote-credit">
— @errietta, ["Why I love contributing to open source software"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

Contribuer à l'open source peut être une manière enrichissante d'apprendre, d'enseigner et de construire une expérience dans presque toutes les compétences que vous pouvez imaginer.

Pourquoi les gens contribuent-ils à l'open source ? Beaucoup de raisons !

### Améliorer les compétences existantes

Que ce soit le codage, la conception de l'interface utilisateur, la conception graphique, la rédaction ou l'organisation, si vous cherchez de la pratique, il y a une tâche pour vous sur un projet open source.

### Rencontrez des gens qui s'intéressent à des choses similaires

Les projets Open Source avec des communautés chaleureuses et accueillantes font que les gens reviennent pendant des années. Beaucoup de gens forment des amitiés à vie grâce à leur participation à l'open source, que ce soit dans le cadre de conférences ou de bavardages en ligne tard dans la nuit sur les burritos.

### Trouver des mentors et enseigner aux autres

Travailler avec d'autres sur un projet partagé signifie que vous devrez expliquer comment vous faites les choses, ainsi que de demander de l'aide à d'autres personnes. Les actes d'apprentissage et d'enseignement peuvent être une activité enrichissante pour tous ceux qui sont impliqués.

### Construire des artefacts publics qui vous aident à acquérir une réputation (et une carrière)

Par définition, tout votre travail open source est public, ce qui signifie que vous obtenez des exemples gratuits à emporter pour démontrer ce que vous pouvez faire.

### Apprendre les compétences des personnes

L'Open Source offre des opportunités de pratiquer des compétences de leadership et de gestion, telles que la résolution de conflits, l'organisation d'équipes de personnes et la hiérarchisation du travail.

### Cela permet de faire des changements, même les plus petits

Vous n'avez pas besoin de devenir un contributeur permanent pour profiter de la participation à l'open source. Avez-vous déjà vu une faute de frappe sur un site Web et souhaité que quelqu'un la corrige ? Sur un projet open source, vous pouvez le faire. L'Open Source aide les gens à se sentir interpellés par leur vie et leur expérience du monde, ce qui est en soi gratifiant.

## Que signifie contribuer

Si vous êtes un nouveau contributeur open source, le processus peut être intimidant. Comment trouvez-vous le bon projet ? Que faire si vous ne savez pas coder ? Et si quelque chose ne va pas ?

Ne pas s'inquiéter ! Il y a toutes sortes de façons de s'impliquer dans un projet open source, et quelques conseils vous aideront à tirer le meilleur parti de votre expérience.

### Vous n'avez pas à contribuer au code

Une idée commune fausse sur la contribution à l'open source est que vous devez contribuer au code. En fait, ce sont souvent les autres parties d'un projet qui sont [le plus négligées ou négligées](https://github.com/blog/2195-the-shape-of-open-source). Vous allez faire une faveur au projet en offrant de participer à ces types de contributions !

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  Je suis renommé pour mon travail sur CocoaPods, mais la plupart des gens ne savent pas que je ne travaille pas vraiment sur l'outil CocoaPods lui-même. Mon temps sur le projet est principalement passé à faire des choses comme la documentation et à travailler sur l'image de marque.
  <p markdown="1" class="pquote-credit">
— @orta, ["Moving to OSS by default"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

Même si vous aimez écrire du code, d'autres types de contributions sont un excellent moyen de s'impliquer dans un projet et de rencontrer d'autres membres de la communauté. Construire ces relations vous donnera l'opportunité de travailler sur d'autres parties du projet.

### Aimez-vous la planification d'événements ?

* Organiser des ateliers ou des meetups sur le projet, [comme @fzamperin a fait pour NodeSchool](https://github.com/nodeschool/organizers/issues/406)
* Organiser la conférence du projet (s'ils en ont une)
* Aider les membres de la communauté à trouver les bonnes conférences et soumettre des propositions de talk

### Aimez-vous créer ?

* Restructurer les mises en page pour améliorer la convivialité du projet
* Effectuer des recherches utilisateur pour réorganiser et affiner la navigation ou les menus du projet, [comme suggère Drupal](https://www.drupal.org/community-initiatives/drupal-core/usability)
* Mettre en place un guide de style pour aider le projet à avoir un design visuel cohérent
* Créer de l'art pour des t-shirts ou un nouveau logo, [comme les contributeurs de hapi.js l'ont fait](https://github.com/hapijs/contrib/issues/68)

### Aimez-vous écrire ?

* Écrire et améliorer la documentation du projet
* Curate un dossier d'exemples montrant comment le projet est utilisé
* Démarrer un bulletin d'information pour le projet, ou organiser des faits marquants de la liste de diffusion
* Rédiger des tutoriels pour le projet, [comme les contributeurs de PyPA l'ont fait](https://packaging.python.org/)
* Écrire une traduction pour la documentation du projet

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  Sérieusement, \[documentation\] est méga-important. La documentation à ce jour a été excellente et a été une caractéristique de Babel. Il y a des sections qui pourraient certainement utiliser un peu de travail et même l'ajout d'un paragraphe ici ou là est extrêmement apprécié.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Call for contributors"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### Aimez-vous l'organisation ?

* Lien vers des questions en double, et suggérer de nouveaux labels pour les issues, pour garder les choses organisées
* Passer en revue les problèmes ouverts et suggérer de fermer les anciens, [comme @nzakas a fait pour ESLint](https://github.com/eslint/eslint/issues/6765)
* Posez des questions de clarification sur les issues récemment ouvertes pour faire avancer la discussion

### Aimez-vous le code ?

* Trouver un problème ouvert à aborder, [comme @dianjin a fait pour Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560)
* Demandez si vous pouvez aider à écrire une nouvelle fonctionnalité
* Automatiser la configuration du projet
* Améliorer l'outillage et les tests

### Aimez-vous aider les gens ?

* Répondez aux questions sur le projet sur, par exemple, Stack Overflow ([comme cet exemple Postgres](https://stackoverflow.com/questions/18664074/getting-error-peer-authentication-failed-for-user-postgres-when-trying-to-ge)) ou Reddit
* Répondre aux questions pour les personnes sur les questions ouvertes
* Aider à modérer les forums de discussion ou les canaux de conversation

### Aimez-vous aider les autres ?

* Réviser le code sur les soumissions d'autres personnes
* Écrire des tutoriels sur la façon dont un projet peut être utilisé
* Proposer de parrainer un autre contributeur, [comme @ereichert l'a fait pour @bronzdoc sur Rust](https://github.com/rust-lang/book/issues/123#issuecomment-238049666)

### Il ne suffit pas de travailler sur des projets logiciels !

Alors que "open source" se réfère souvent à un logiciel, vous pouvez collaborer sur à peu près n'importe quoi. Il existe des livres, des recettes, des listes et des classes qui sont développés en tant que projets open source.

Par exemple:

* @sindresorhus gère une [liste de listes "géniales"](https://github.com/sindresorhus/awesome)
* @h5bp tient à jour une [liste des questions potentielles lors d'entretiens](https://github.com/h5bp/Front-end-Developer-Interview-Questions) pour les candidats développeurs
* @stuartlynn et @nicole-a-tesla ont fait une [collection de faits amusants sur les macareux](https://github.com/stuartlynn/puffin_facts)

Même si vous êtes un développeur de logiciels, travailler sur un projet de documentation peut vous aider à démarrer en open source. Il est souvent moins intimidant de travailler sur des projets qui n'impliquent pas de code, et le processus de collaboration renforcera votre confiance et votre expérience.

## S'orienter vers un nouveau projet

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  Si vous allez sur un issue tracker et les choses semblent confuses, ce n'est pas seulement vous. Ces outils nécessitent beaucoup de connaissances implicites, mais les gens peuvent vous aider à les parcourir et vous pouvez leur poser des questions.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["How to Contribute to Open Source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

Pour tout ce qui n'est pas une faute de frappe, contribuer à l'open source, c'est comme aller à un groupe d'étrangers lors d'une fête. Si vous commencez à parler des lamas, alors qu'ils étaient plongés dans une discussion sur les poissons rouges, ils vous regarderont probablement un peu étrangement.

Avant de sauter à l'aveuglette avec vos propres suggestions, commencez par apprendre à lire la pièce. Cela augmente les chances que vos idées soient remarquées et entendues.

### Anatomie d'un projet open source

Chaque communauté open source est différente.

Passer des années sur un projet open source signifie que vous avez appris à connaître un projet open source. Déplacez-vous vers un projet différent, et vous pourriez trouver le vocabulaire, les normes et les styles de communication complètement différents.

Cela dit, de nombreux projets open source suivent une structure organisationnelle similaire. Comprendre les différents rôles de la communauté et le processus global vous aidera à vous orienter rapidement vers tout nouveau projet.

Un projet Open Source typique comprend les types de personnes suivants:

* **Auteur :** La personne / l'organisation qui a créé le projet
* **Propriétaire :** La ou les personnes qui ont la propriété administrative de l'organisation ou du repository (pas toujours les mêmes que l'auteur original)
* **Responsables :** Collaborateurs responsables de la vision et de la gestion des aspects organisationnels du projet. (Ils peuvent aussi être auteurs ou propriétaires du projet.)
* **Contributeurs :** Tous ceux qui ont contribué au projet.
* **Membres de la communauté :** Les personnes qui utilisent le projet. Ils peuvent être actifs dans les conversations ou exprimer leur opinion sur la direction du projet.

Les plus grands projets peuvent également avoir des sous-comités ou des groupes de travail axés sur différentes tâches, telles que l'outillage, le triage, la modération communautaire et l'organisation d'événements. Regardez sur le site Web d'un projet pour une page «équipe», ou dans le repository pour la documentation de gouvernance, pour trouver cette information.

Un projet a également une documentation. Ces fichiers sont généralement répertoriés à la racine d'un repository.

* **LICENCE :** Par définition, chaque projet open source doit avoir une [licence open source](https://choosealicense.com). Si le projet n'a pas de licence, il n'est pas open source.
* **README :** Le README est le manuel d'instructions qui accueille les nouveaux membres de la communauté au projet. Cela explique pourquoi le projet est utile et comment démarrer.
* **CONTRIBUTING :** Alors que les fichiers README aident les gens à utiliser le projet, les documents de contribution aident les gens à contribuer au projet. Il explique quels types de contributions sont nécessaires et comment le processus fonctionne. Bien que tous les projets n'aient pas de fichier CONTRIBUTING, sa présence indique qu'il s'agit d'un projet accueillant auquel contribuer.
* **CODE_OF_CONDUCT :** Le code de conduite établit des règles de base pour le comportement des participants et contribue à faciliter un environnement amical et accueillant. Bien que tous les projets n'aient pas de fichier CODE_OF_CONDUCT, sa présence indique qu'il s'agit d'un projet accueillant auquel contribuer.
* **Autre documentation :** Il pourrait y avoir de la documentation supplémentaire, comme des tutoriels, des procédures pas à pas, ou des politiques de gouvernance, en particulier sur des projets plus importants.

Enfin, les projets open source utilisent les outils suivants pour organiser la discussion. La lecture des archives vous donnera une bonne idée de la façon dont la communauté pense et travaille.

* **Suivi des issues :** Lorsque les gens discutent des issues liés au projet.
* **Pull Requests :** Où les gens discutent et examinent les changements en cours.
* **Forums de discussion ou listes de diffusion :** Certains projets peuvent utiliser ces canaux pour des sujets conversationnels (par exemple, _"Comment puis-je..."_ ou _"Que pensez-vous de..."_ au lieu d'un rapport de bug ou demandes de fonctionnalités). D'autres utilisent le suivi des issues pour toutes les conversations.
* **Canal de discussion synchrone :** Certains projets utilisent des canaux de discussion (tels que Slack ou IRC) pour des conversations informelles, la collaboration et des échanges rapides.

## Trouver un projet auquel contribuer

Maintenant que vous avez compris comment fonctionnent les projets open source, il est temps de trouver un projet auquel contribuer !

Si vous n'avez jamais contribué à l'open source auparavant, prenez quelques conseils du président américain John F. Kennedy, qui a dit: _"Ne demandez pas ce que votre pays peut faire pour vous - demandez ce que vous pouvez faire pour votre pays."_

Contribuer à l'open source se produit à tous les niveaux, à travers les projets. Vous n'avez pas besoin de trop réfléchir sur ce que sera exactement votre première contribution ou sur ce à quoi elle ressemblera.

Au lieu de cela, commencez par penser aux projets que vous utilisez déjà ou que vous voulez utiliser. Les projets auxquels vous contribuez activement sont ceux auxquels vous revenez.

Dans ces projets, chaque fois que vous pensez que quelque chose pourrait être meilleur ou différent, agissez selon votre instinct.

L'open source n'est pas un club exclusif. C'est fait par des gens comme vous. "Open source" est juste un terme de fantaisie pour traiter les problèmes du monde comme réparable.

Vous pouvez scanner un fichier README et trouver un lien cassé ou une faute de frappe. Ou vous êtes un nouvel utilisateur et vous avez remarqué que quelque chose est cassé, ou un problème que vous pensez devrait vraiment être dans la documentation. Au lieu de l'ignorer et de passer à autre chose, ou de demander à quelqu'un d'autre de le réparer, voyez si vous pouvez aider en faisant un descriptif du problème. C'est cela l'open source !

> [28% des contributions occasionnelles](https://www.igor.pro.br/publica/papers/saner2016.pdf) à l'open source sont de la documentation, une correction de faute de frappe, un reformatage ou l'écriture d'une traduction.

Vous pouvez également utiliser l'une des ressources suivantes pour vous aider à découvrir et à contribuer à de nouveaux projets :

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://web.archive.org/web/20201111233803/https://www.sourcesort.com/)

### Une checklist avant de contribuer

Lorsque vous avez trouvé un projet auquel vous souhaitez contribuer, effectuez une analyse rapide pour vous assurer que le projet est adapté à l'acceptation des contributions. Sinon, votre travail acharné pourrait ne jamais avoir de réponse.

Voici une liste de contrôle pratique pour évaluer si un projet est bon pour les nouveaux contributeurs.

**Répondre à la définition de l'open source**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  A-t-il une licence ? Généralement, il s'agit d'un fichier appelé LICENSE à la racine du repository.
  </label>
</div>

**Le projet accepte activement les contributions**

Regardez l'activité des commits sur la branche principale. Sur GitHub, vous pouvez voir cette information sur la page d'accueil d'un repository.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  À quand remonte le dernier commit ?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  Combien de contributeurs le projet a-t-il ?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  À quelle fréquence les gens commits ? (Sur GitHub, vous pouvez le trouver en cliquant sur "Commits" dans la barre du haut.)
  </label>
</div>

Ensuite, regardez les issues du projet.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Combien d'issues sont ouvertes?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Les responsables répondent-ils rapidement aux issues lorsqu'elles sont ouvertes ?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Y a-t-il une discussion active sur les issues ?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Les issues sont-elles récentes ?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Les issues sont-elles fermées ? (Sur GitHub, cliquez sur l'onglet "closed" de la page issue pour voir les issues résolues.)
  </label>
</div>

Faites la même chose pour les pull requests du projet.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Combien de pull requests sont ouvertes ?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    Les responsables répondent-ils rapidement aux pull requests lorsqu'elles sont ouvertes ?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Y a-t-il une discussion active sur les pull requests ?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Les pull requests sont récentes ?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    Dans quelle mesure les pull requests ont-elles été mergées récemment ? (Sur GitHub, cliquez sur l'onglet "Closed" de la page Pull Requests pour voir les PR fermés.)
  </label>
</div>

**Le projet est accueillant**

Un projet convivial et accueillant signale qu'il sera réceptif aux nouveaux contributeurs.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    Les responsables répondent-ils utilement aux questions dans les issues ?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    Les gens sont-ils amicaux dans les issues, le forum de discussion et le chat (par exemple, IRC ou Slack)?
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    Est-ce que les pull request ont bien une review ?
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    Les responsables remercient-ils les gens pour leurs contributions ?
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
 Chaque fois que vous voyez un long fil de discussion, vérifiez les réponses des principaux développeurs arrivant tard dans le fil. Résument-ils de façon constructive la discussion pour prendre une décision tout en restant polis ? Si vous voyez beaucoup de _flame wars_, c'est souvent un signe que l'énergie est dépensée en dispute plutôt qu'en développements.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## Comment proposer une contribution

Vous avez trouvé un projet que vous aimez et vous êtes prêt à apporter votre contribution. Enfin ! Voici comment obtenir votre contribution de la bonne façon.

### Communiquer efficacement

Que vous soyez un contributeur ponctuel ou que vous essayiez de rejoindre une communauté, travailler avec les autres est l'une des compétences les plus importantes que vous développerez dans l'open source.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  \[En tant que nouveau contributeur,\] je me suis rapidement rendu compte que je devais poser des questions si je voulais pouvoir fermer une issue. J'ai parcouru la code base. Une fois que j'ai eu une idée de ce qui se passait, j'ai demandé plus de pistes. Et voilà! J'ai été capable de résoudre le problème après avoir obtenu tous les détails pertinents dont j'avais besoin.
  <p markdown="1" class="pquote-credit">
— @shubheksha, [A Beginner's Very Bumpy Journey Through The World of Open Source](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

Avant d'ouvrir une issue ou une pull request, ou de poser une question dans une discussion, gardez ces points à l'esprit pour que vos idées soient bien comprises.

**Donner le contexte.** Aider les autres à se mettre rapidement à jour. Si vous rencontrez une erreur, expliquez ce que vous essayez de faire et comment le reproduire. Si vous suggérez une nouvelle idée, expliquez pourquoi vous pensez que ce serait utile pour le projet (pas seulement pour vous !).

> 😇 _"X n'arrive pas quand je fais Y"_
>
> 😢 _"X est cassé ! Veuillez le réparer."_

**Faites vos devoirs à l'avance.** C'est OK de ne pas savoir des choses, mais montrez que vous avez essayé. Avant de demander de l'aide, assurez-vous de consulter le fichier README, la documentation, les issues (ouvertes ou fermées), la liste de diffusion et la recherche sur Internet pour obtenir une réponse. Les gens apprécieront quand vous démontrerez que vous essayez d'apprendre.

> 😇 _"Je ne sais pas comment implémenter X. J'ai vérifié les documents d'aide et je n'ai trouvé aucune mention."_
>
> 😢 _"Comment puis-je X ?"_

**Gardez les demandes courtes et directes.** Tout comme pour l'envoi d'un courriel, chaque contribution, aussi simple ou utile soit-elle, nécessite l'avis de quelqu'un d'autre. De nombreux projets ont plus de demandes entrantes que de personnes disponibles pour aider. Soyez concis. Vous augmenterez les chances que quelqu'un puisse vous aider.

> 😇 _"J'aimerais écrire un tutoriel sur l'API."_
>
> 😢 _"Je roulais sur l'autoroute l'autre jour et je me suis arrêté pour faire le plein d'essence, et puis j'ai eu cette idée incroyable pour quelque chose que nous devrions faire, mais avant que j'explique cela, laissez-moi vous montrer..."_

**Gardez toute communication publique.** Bien que cela soit tentant, ne communiquez pas avec les responsables en privé à moins que vous ayez besoin de partager des informations sensibles (comme un problème de sécurité ou une violation grave de la conduite). Lorsque vous maintenez la conversation publique, plus de personnes peuvent apprendre et bénéficier de votre échange. Les discussions peuvent être, en elles-mêmes, des contributions.

> 😇 _(comme un commentaire) "@-mainainer Salut ! Comment devrions-nous procéder sur cette PR ?"_
>
> 😢 _(comme un e-mail) "Hello, désolé de vous déranger par e-mail, mais je me demandais si vous aviez eu l'occasion de revoir mes pull requests ?"_

**Il est acceptable de poser des questions (mais soyez patient!).** Tout le monde était nouveau au projet à un moment donné, et même les contributeurs expérimentés ont besoin de se mettre à jour quand ils regardent un nouveau projet. De même, même les responsables de longue date ne sont pas toujours familiers avec chaque partie du projet. Montrez-leur la même patience que vous voudriez qu'ils vous montrent.

> 😇 _"Merci d'avoir examiné cette erreur, j'ai suivi vos suggestions, voici la sortie."_
>
> 😢 _"Pourquoi ne voulez-vous pas résoudre mon problème, n'est-ce pas votre projet ?"_

**Respectez les décisions de la communauté.** Vos idées peuvent différer des priorités ou de la vision de la communauté. Ils peuvent offrir des commentaires ou décider de ne pas poursuivre votre idée. Alors que vous devriez discuter et chercher des compromis, les responsables doivent vivre avec votre décision plus longtemps que vous ne le ferez. Si vous n'êtes pas d'accord avec leur direction, vous pouvez toujours travailler sur votre propre fork ou démarrer votre propre projet.

> 😇 _"Je suis déçu que vous ne puissiez pas supporter mon cas d'utilisation, mais comme vous l'avez expliqué, cela ne concerne qu'une partie mineure des utilisateurs, je comprends pourquoi."_
>
> 😢 _"Pourquoi ne soutenez-vous pas mon cas d'utilisation ? C'est inacceptable !"_

**Surtout, gardez-le classique.** L'open source est composé de collaborateurs du monde entier. Le contexte se perd dans les langues, les cultures, les zones géographiques et les fuseaux horaires. De plus, la communication écrite rend plus difficile la transmission d'un ton ou d'une humeur. Supposer de bonnes intentions dans ces conversations. Il est bon de repousser poliment une idée, de demander plus de contexte ou de clarifier davantage votre position. Juste essayer de laisser l'Internet un meilleur endroit que lorsque vous l'avez trouvé.

### Rassembler le contexte

Avant de faire quoi que ce soit, faites une vérification rapide pour vous assurer que votre idée n'a pas été discutée ailleurs. Parcourez le fichier README du projet, les issues (ouvertes et fermées), la liste de diffusion et Stack Overflow. Vous n'avez pas à passer des heures à tout faire, mais une recherche rapide de quelques termes clés va aider.

Si vous ne trouvez pas votre idée ailleurs, vous êtes prêt à faire un geste. Si le projet est sur GitHub, vous communiquerez probablement en ouvrant une issue ou une pull request :

* **Les issues** sont comme démarrer une conversation ou une discussion
* **Les Pull Request** sont pour commencer à travailler sur une solution
* **Pour une communication légère,** comme une question de clarification ou de procédure, essayez de demander sur Stack Overflow, IRC, Slack ou d'autres canaux de discussion, si le projet en a un.

Avant d'ouvrir une issue ou une pull request, vérifiez les documents de contribution du projet (généralement un fichier appelé CONTRIBUTING, ou dans le fichier README), pour voir si vous devez inclure quelque chose de spécifique. Par exemple, ils peuvent vous demander de suivre un modèle ou d'exiger que vous utilisiez des tests.

Si vous voulez apporter une contribution substantielle, ouvrez une issue pour demander avant de travailler dessus. Il est utile de regarder le projet pendant un moment (sur GitHub, [vous pouvez cliquer sur "Watch"](https://help.github.com/articles/watching-repositories/) pour être averti de toutes les conversations), et arriver à connaître les membres de la communauté, avant de faire un travail qui pourrait ne pas être accepté.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  Vous apprendrez <em>beaucoup</em> à prendre un seul projet que vous utilisez activement, à le «regarder» sur GitHub et à lire toutes les issues et PR.
<p markdown="1" class="pquote-credit">
— @gaearon [on joining projects](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### Ouvrir une issue

Vous devrez généralement ouvrir une issue dans les situations suivantes:

* Signaler une erreur que vous ne pouvez pas résoudre vous-même
* Discuter d'un sujet ou d'une idée de haut niveau (par exemple, communauté, vision ou politiques)
* Proposer une nouvelle fonctionnalité ou une autre idée de projet

Conseils pour communiquer sur les problèmes:

* **Si vous voyez un problème ouvert auquel vous voulez vous attaquer,** commentez le problème pour faire savoir aux autres que vous travaillez dessus. De cette façon, les gens seront moins susceptibles de dupliquer votre travail.
* **Si une issue a été ouverte il y a un certain temps,** il est possible qu'elle soit adressée ailleurs ou qu'elle ait déjà été résolue, alors commentez pour demander une confirmation avant de commencer le travail.
* **Si vous avez ouvert une issue, mais que vous avez trouvé la réponse plus tard,** commentez l'issue pour informer les gens, puis fermez-la. Même documenter ce résultat est une contribution au projet.

### Ouvrir une Pull Request

Vous devrez généralement ouvrir une pull request dans les situations suivantes :

* Soumettre des corrections triviales (par exemple, une faute de frappe, un lien cassé ou une erreur évidente)
* Commencer à travailler sur une contribution qui a déjà été demandée, ou dont vous avez déjà discuté, dans une issue

Une pull request n'a pas à représenter le travail fini. Il est généralement préférable d'ouvrir une pull request au début afin que les autres puissent regarder ou donner leur avis sur vos progrès. Il suffit de marquer "WIP" (Work in Progress) dans la ligne d'objet. Vous pouvez toujours ajouter plus de commits plus tard.

Si le projet est sur GitHub, voici comment soumettre une pull request:

* **[Forker le repository](https://guides.github.com/activities/forking/)** et clonez-le localement. Connectez votre repository local au repository original "upstream" en l'ajoutant en tant que remote. Pullez souvent des changements de "upstream" de sorte que vous restiez à jour afin que lorsque vous soumettez votre pull request, les conflits de merge seront moins probables. (Voir plus d'instructions détaillées [ici](https://help.github.com/articles/syncing-a-fork/).)
* **[Créer une branche](https://guides.github.com/introduction/flow/)** pour vos modifications.
* **Faites référence à toutes les questions pertinentes** ou aux éléments de documentations dans votre PR (par exemple, «Close #37»).
* **Inclure des captures d'écran avant et après** si vos modifications incluent des différences en HTML/CSS. Faites glisser et déposez les images dans le corps de votre pull request.
* **Testez vos modifications !** Exécutez vos modifications par rapport aux tests existants s'ils existent et créez-en de nouveaux si nécessaire. Que les tests existent ou non, assurez-vous que vos modifications ne cassent pas le projet existant.
* **Contribuer dans le style du projet** au mieux de vos capacités. Cela peut signifier utiliser des indentations, des points-virgules ou des commentaires différemment de ce que vous feriez dans votre propre repository, mais il est plus facile pour le mainteneur de fusionner, d'autres à comprendre et à maintenir dans le futur.

S'il s'agit de votre première Pull Request, consultez [Make a Pull Request](http://makeapullrequest.com/), que @kentcdodds a créé comme didacticiel vidéo. Vous pouvez également vous entraîner à faire une pull request dans le repository [Premières contributions](https://github.com/Roshanjossey/first-contributions), créé par @Roshanjossey.

## Que se passe-t-il apr&egrave;s avoir propos&eacute; une contribution

Vous l'avez fait ! Félicitations pour devenir un contributeur open source. Nous espérons que c'est le premier de plusieurs.

Après avoir soumis une contribution, l'un des événements suivants se produira:

### 😭 Vous n'obtenez pas de réponse.

J'espère que vous avez [vérifié les signes d'activité dans le projet](#une-checklist-avant-de-contribuer) avant de faire une contribution. Même sur un projet actif, il est possible que votre contribution n'obtienne pas de réponse.

Si vous n'avez pas reçu de réponse depuis plus d'une semaine, il est juste de répondre poliment dans ce même fil, en demandant à quelqu'un de donner son avis. Si vous connaissez le nom de la bonne personne à consulter votre contribution, vous pouvez @-mentionner dans ce fil.

**Ne pas** tendre la main à cette personne en privé. Rappelez-vous que la communication publique est vitale pour les projets open source.

Si vous faites une contribution et que personne ne répond, il est possible que personne ne réponde, jamais. Ce n'est pas génial, mais ne vous laissez pas décourager. C'est arrivé à tout le monde ! Il y a plusieurs raisons possibles pour lesquelles vous n'avez pas reçu de réponse, y compris des circonstances personnelles qui peuvent être hors de votre contrôle. Essayez de trouver un autre projet ou un moyen de contribuer. Si c'est le cas, c'est une bonne raison de ne pas consacrer trop de temps à faire une contribution avant que les autres membres de la communauté soient engagés et réceptifs.

### 🚧 Quelqu'un demande des modifications à votre contribution.

Il est courant que l'on vous demande d'apporter des modifications à votre contribution, qu'il s'agisse de commentaires sur la portée de votre idée ou de modifications apportées à votre code.

Quand quelqu'un demande des changements, soyez flexible. Ils ont pris le temps d'examiner votre contribution. Ouvrir une PR et passer à autre chose est une mauvaise idée. Si vous ne savez pas comment faire des changements, recherchez le problème, puis demandez de l'aide si vous en avez besoin.

Si vous n'avez plus le temps de travailler sur le problème (par exemple, si la conversation dure depuis des mois et que votre situation a changé), informez le responsable pour qu'il n'attende pas de réponse. Quelqu'un d'autre peut être heureux de prendre le relais.

### 👎 Votre contribution ne sera pas acceptée.

Votre contribution peut ou pas être acceptée à la fin. J'espère que vous n'y avez pas déjà mis trop de travail. Si vous ne savez pas pourquoi cela n'a pas été accepté, il est tout à fait raisonnable de demander des commentaires et des éclaircissements au responsable. En fin de compte, cependant, vous devrez respecter que c'est leur décision. Ne discutez pas et ne soyez pas hostile. Vous êtes toujours le bienvenu pour forker et travailler sur votre propre version si vous n'êtes pas d'accord !

### 🎉 Votre contribution est acceptée.

Hourra! Vous avez réussi à faire une contribution open source!

## Vous l'avez fait!

Que vous veniez de faire votre première contribution open source, ou que vous cherchiez de nouvelles façons de contribuer, nous espérons que vous êtes inspirés à agir. Même si votre contribution n'a pas été acceptée, n'oubliez pas de dire merci quand un responsable a fait des efforts pour vous aider. L'open source est créé par des personnes comme vous: une issue, une pull request, un commentaire ou une salutation à la fois.
