---
lang: fr
title: Trouver des utilisateurs pour votre projet
description: Aidez votre projet Open Source à se développer en le mettant entre les mains d'utilisateurs satisfaits.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Passer le mot

Il n'y a pas de règle qui stipule que vous devez promouvoir un projet open source lors de votre lancement. Il existe de nombreuses raisons satisfaisantes de travailler en open source qui n'ont rien à voir avec la popularité. Au lieu d'espérer que les autres trouveront et utiliseront votre projet open source, vous devez passer le mot au sujet de votre dur labeur !

## Bien concevoir votre message

Avant de commencer le travail de promotion de votre projet, vous devriez être en mesure d'expliquer ce qu'il fait et pourquoi c'est important.

Qu'est-ce qui rend votre projet différent ou intéressant ? Pourquoi l'avez-vous créé ? Répondre à ces questions par vous-même vous aidera à communiquer l'importance de votre projet.

Rappelez-vous que les gens s'impliquent en tant qu'utilisateurs et deviennent éventuellement des contributeurs, car votre projet résout un problème pour eux. En réfléchissant au message et à la valeur de votre projet, essayez de les voir sous l'angle de ce que les _utilisateurs et les contributeurs_ pourraient vouloir.

Par exemple, @robb utilise des exemples de code pour expliquer clairement pourquoi son projet, [Cartography](https://github.com/robb/Cartography), est utile:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Pour plus d'information concernant la messagerie, consultez l'exercice de Mozilla ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) pour développer des utilisateurs.

## Aidez les gens à trouver et à suivre votre projet

<aside markdown="1" class="pquote">
  Dans l'idéal, vous avez besoin d'une seule URL "d'accueil" que vous pouvez promouvoir et diriger vers des personnes en relation avec votre projet. Vous n'avez pas besoin de vous dépenser sur un modèle fantaisie ou même un nom de domaine, mais votre projet a besoin d'un point focal.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Aidez les internautes à trouver et à retenir votre projet en les pointant vers un espace de nom unique.

**Ayez une poignée claire pour promouvoir votre travail.** Un Twitter, une URL GitHub, ou un canal IRC est un moyen facile de diriger les gens vers votre projet. Ces points de vente permettent également à la communauté grandissante de votre projet de se réunir.

Si vous ne souhaitez pas encore créer de points de vente pour votre projet, faites la promotion de votre propre compte Twitter ou GitHub dans tout ce que vous faites. La promotion de votre compte Twitter ou GitHub permettra aux gens de savoir comment vous contacter ou suivre votre travail. Si vous parlez lors d'une rencontre ou d'un événement, assurez-vous que vos coordonnées sont incluses dans votre bio ou vos diapositives.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Une erreur que j'ai commise à mes débuts (...) a été de ne pas créer de compte Twitter pour le projet. Twitter est un excellent moyen de tenir les gens au courant d'un projet et d'exposer constamment les gens au projet.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Envisagez de créer un site Web pour votre projet.** Un site Web rend votre projet plus convivial et plus facile à parcourir, surtout lorsqu'il est associé à une documentation et à des tutoriels clairs. Avoir un site Web suggère également que votre projet est actif, ce qui rendra votre auditoire plus à l'aise pour l'utiliser. Donnez des exemples pour donner aux gens des idées sur la façon d'utiliser votre projet.

[@adrianholovaty](https://news.ycombinator.com/item?id=7531689), co-créateur de Django, a déclaré qu'un site web était _"de loin la meilleure chose que nous ayons faite avec Django au début"_.

Si votre projet est hébergé sur GitHub, vous pouvez utiliser [les Pages GitHub](https://pages.github.com/) pour créer facilement un site web. [Yeoman](http://yeoman.io/), [Vagrant](https://www.vagrantup.com/), et [Middleman](https://middlemanapp.com/) sont [quelques exemples](https://github.com/showcases/github-pages-examples) d'excellents sites Web complets.

![Page d'accueil Vagrant](/assets/images/finding-users/vagrant_homepage.png)

Maintenant que vous avez un message pour votre projet et un moyen facile pour les gens de trouver votre projet, allez-y et parlez à votre auditoire !

## Allez l&agrave; o&ugrave; se trouve le public de votre projet (en ligne)

La sensibilisation en ligne est un excellent moyen de partager et de répandre le mot rapidement. En utilisant les canaux en ligne, vous avez le potentiel d'atteindre un très large public.

Tirez parti des communautés et des plateformes en ligne existantes pour atteindre votre public. Si votre projet open source est un projet logiciel, vous pouvez probablement trouver votre public sur [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/), ou [Quora](https://www.quora.com/). Trouvez les canaux dont vous pensez que les gens vont le plus tirer profit ou seront le plus enthousiasmés par votre travail.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Chaque programme a des fonctions très spécifiques que seule une fraction des utilisateurs trouveront utiles. Ne spammez pas toutes les personnes possible. Ciblez plutôt vos efforts sur les communautés qui trouveront un bénéfice à connaître votre projet.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Voyez si vous pouvez trouver des moyens de partager votre projet de manière pertinente :

* **Apprenez à connaître les projets open source pertinents et les communautés.** Parfois, vous n'avez pas à promouvoir directement votre projet. Si votre projet est parfait pour les scientifiques de données qui utilisent Python, familiarisez-vous avec la communauté de la science des données Python. Au fur et à mesure que les gens vous connaîtront, des occasions naturelles se présenteront pour parler et partager votre travail.
* **Trouvez des personnes rencontrant le problème que votre projet résout.** Recherchez dans les forums connexes pour les personnes qui tombent dans le public cible de votre projet. Répondez à leur question et trouvez avec tact un moyen de suggérer votre projet comme solution.
* **Demandez des commentaires.** Présentez-vous et votre travail à un public qui le trouverait pertinent et intéressant. Soyez précis au sujet de qui, selon vous, bénéficierait de votre projet. Essayez de finir la phrase: _"Je pense que mon projet aiderait vraiment X, qui essaye de faire Y"_. Écoutez et répondez aux commentaires des autres, plutôt que de simplement promouvoir votre travail.

En général, concentrez-vous sur l'aide aux autres avant de demander des choses en retour. Parce que n'importe qui peut facilement promouvoir un projet en ligne, il y aura beaucoup de bruit. Pour se démarquer de la foule, donnez aux gens un contexte pour ce que vous êtes et pas seulement ce que vous voulez.

Si personne ne fait attention ou répond à vos premiers contacts, ne vous découragez pas ! La plupart des lancements de projets sont un processus itératif qui peut prendre des mois ou des années. Si vous n'obtenez pas de réponse la première fois, essayez une tactique différente, ou cherchez d'abord des façons d'ajouter de la valeur au travail des autres. La promotion et le lancement de votre projet demandent du temps et du dévouement.

## Allez l&agrave; o&ugrave; se trouve le public de votre projet (hors ligne)

![Conférence publique](/assets/images/finding-users/public_speaking.jpg)

Les événements hors ligne sont un moyen populaire de promouvoir de nouveaux projets auprès des publics. Ils constituent un excellent moyen d'atteindre un public engagé et de tisser des liens humains plus profonds, en particulier si vous souhaitez toucher les développeurs.

Si vous êtes [nouveau sur la prise de parole en public](https://speaking.io/), commencez par trouver une rencontre locale liée à la langue ou à l'écosystème de votre projet.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  J'étais plutôt nerveux d'aller à PyCon. Je donnais une conférence, je n'allais connaître que quelques personnes, j'y allais pendant une semaine entière. (...) Je n'aurais pas dû m'inquiéter, cependant. PyCon était phénoménalement génial ! (...) Tout le monde était incroyablement amical et extraverti, tellement que j'ai rarement trouvé le temps de ne pas parler aux gens !
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Si vous n'avez jamais parlé à un événement auparavant, il est tout à fait normal de vous sentir nerveux ! Rappelez-vous que votre auditoire est là parce qu'il veut vraiment entendre parler de votre travail.

Au fur et à mesure que vous écrivez votre exposé, concentrez-vous sur ce que votre auditoire trouvera intéressant et dont vous tirerez profit. Gardez votre ton amical et accessible. Souriez, respirez et amusez-vous.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Lorsque vous commencez à écrire votre discours, quel que soit votre sujet, cela peut aider si vous voyez votre conversation comme une histoire que vous racontez.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Lorsque vous êtes prêt, envisagez de prendre la parole lors d'une conférence pour promouvoir votre projet. Les conférences peuvent vous aider à atteindre plus de gens, parfois de partout dans le monde.

Recherchez des conférences spécifiques à votre langue ou à votre écosystème. Avant de soumettre votre exposé, faites des recherches sur la conférence pour adapter votre discours aux participants et augmenter vos chances d'être accepté pour prendre la parole à la conférence. Vous pouvez souvent avoir une idée de votre auditoire en regardant les conférenciers d'une conférence.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  J'ai écrit très gentiment aux gens de JSConf et je les ai suppliés de me donner un emplacement où je pourrais le présenter à JSConf EU. (...) J'avais très peur de présenter cette chose sur laquelle je travaillais depuis six mois. (...) Tout le temps je pensais juste, oh mon Dieu. Qu'est ce que je fais ici ?
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Construire une r&eacute;putation

En plus des stratégies décrites ci-dessus, la meilleure façon d'inviter les gens à partager et à contribuer à votre projet est de partager et de contribuer à leurs projets.

Aider les nouveaux arrivants, partager des ressources et apporter une contribution réfléchie aux projets des autres vous aidera à vous bâtir une réputation positive. Être un membre actif dans la communauté open source aidera les gens à avoir un contexte pour votre travail et sera plus susceptible de prêter attention et de partager votre projet. Développer des relations avec d'autres projets open source peut même conduire à des partenariats officiels.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  La seule raison pour laquelle urllib3 est la bibliothèque Python tierce la plus populaire aujourd'hui est parce qu'elle fait partie des requêtes.
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Il n'est jamais trop tôt ou trop tard pour commencer à bâtir votre réputation. Même si vous avez déjà lancé votre propre projet, continuez de chercher des moyens d'aider les autres.

Il n'y a pas de solution du jour au lendemain pour créer un public. Gagner la confiance et le respect des autres prend du temps, et bâtir votre réputation ne s'arrête jamais.

## Persévérez !

Cela peut prendre beaucoup de temps avant que les gens remarquent votre projet open source. C'est bon ! Certains des projets les plus populaires aujourd'hui ont pris des années pour atteindre des niveaux d'activité élevés. Concentrez-vous sur l'établissement de relations au lieu d'espérer que votre projet gagnera spontanément en popularité. Soyez patient et continuez à partager votre travail avec ceux qui l'apprécient.
