---
lang: fa
title: شروع یک پروژه‌ی متن باز / منبع باز / اوپن سورس
description: در این مقاله چیزهای زیادی درباره‌ی دنیای متن بازها می‌آموزید و آماده‌ی انتشار پروژه‌ی متن باز خودتان می‌شوید.
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## چیستی و چرایی متن باز

اگر به این فکر میکنید که پروژه‌ی متن باز خودتان را شروع کنید؟ به شما تبریک می‌گوییم! دنیا قدردان کمک و مشارکت شماست. اجازه دهید در ادامه درباره پروژه‌های متن باز بیشتر صحبت کنیم و ببینیم چرا مردم پروژه‌هایشان را متن باز می‌کنند.

### متن باز به چه معناست؟

زمانی که یک پروژه متن باز یا اوپن سورس باشد، **هر کسی می‌تواند و اجازه دارد به صورت رایگان از آن استفاده، مطالعه، ویرایش و برای هر هدفی که می‌خواهد، توزیع کند**. این اجازه‌ها در [لایسنس متن باز](https://opensource.org/licenses) قید شده و قابل اجراست

پروژه‌های متن باز قدرتمند هستند، چون موانعی که در اختیارات و مشارکت‌ها دیده می‌شود را کاهش و به افراد اجازه می‌دهد پروژه‌های خود را به سرعت گستردش و بهبود دهند. یکی دیگر از دلایل قدرتمند بودن متن بازها این است که پتانسیل کنترل محاسبه را بسته به منابع محدود به کاربران می‌دهد. اگر بخواهیم برای روشن شدن مطلب نمونه‌ای بیاوریم، می‌توانیم به کسب‌وکارهایی اشاره کنیم که به جای تکیه بر منابع محصور و محدود محصولات انحصاری فروشنده‌های نرم‌افزار، از نرم‌افزارهای متن بازی استفاده می‌کنند که به آن‌ها اجازه می‌دهد شخصی را استخدام کنند تا آن نرم‌افزار را برای آن‌ها شخصی‌سازی یا بهینه کند.

_نرم‌افزارهای رایگان_ همچنین به پروژه‌های متن باز منسوب می‌شود. گاهی هم ممکن است برنامه‌هایی ببینید که [ترکیبی](https://en.wikipedia.org/wiki/Free_and_open-source_software) از اصلاحات «نرم‌افزار متن باز و رایگان» (FOSS) یا «نرم‌افزار متن باز، آزاد و رایگان» (FLOSS) استفاده می‌کنند. خب، باید بگوییم که کلمه‌ی _Free_ (رایگان) و _libre_ (آزاد / رایگان) هر دو به معنای آزادی در استفاده و دسترسی اطلاق می‌شود، [نه قیمت آن](#آیا-پروژهای-متن-باز-مجانی--رایگان-هستند)

### چرا مردم پروژه‌های‌شان را متن باز می‌کنند؟

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">
  یکی از رضایت‌بخش‌ترین تجربه‌هایی که از استفاده و مشارکت در پروژه‌های متن باز به دست آوردم، آشنایی با افراد و توسعه‌دهنده‌هایی بود که همان مشکلاتی را داشتند که من با آن‌ها مواجه شده بودم.
  <p markdown="1" class="pquote-credit">
— @kentcdodds, ["How getting into Open Source has been awesome for me"](https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me)
  </p>
</aside>

[دلایل زیادی وجود دارد](https://ben.balter.com/2015/11/23/why-open-source/) که یک شخص یا سازمان بخواهد پروژه‌های خود را متن باز کند. این دلایل عبارتند از:

* **مشارکت:** هر فردی در دنیا می‌تواند پروژه‌های متن باز را تغییر دهد و در ویرایش آن مشارکت داشته باشد. به عنوان نمونه، Exercism که به عنوان یک پلتفرم متن باز برای تمرین برنامه‌نویسی شناخته می‌شود، با مشارکت افراد مختلف تا به الان بیش از 350 توزیع و ویرایش داشته است.

* **اقتباس و تغییر مجدد:** هر فردی تقریباً با هر هدفی می‌تواند از پروژه‌های متن باز استفاده کند. افراد حتی می‌توانند از یک پروژه، پروژه‌های دیگری به وجود بیاورند. به عنوان مثال می‌توانیم به [وردپرس](https://github.com/WordPress) اشاره کنیم که از پروژه موجودی به نام [b2](https://github.com/WordPress/book/blob/HEAD/Content/Part%201/2-b2-cafelog.md) منشعب شده است.

* **شفافیت:** هرکسی می‌تواند خطاها و تناقض پروژه‌های متن باز را بازرسی کند. از این رو، شفافیت برای دولت‌هایی مانند دولت [بلغارستان](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-open-source-98bf626cf70a) یا [ایالات متحده آمریکا](https://www.cio.gov/2016/08/11/peoples-code.html) و صنایع مقرراتی مانند بانکداری، مراکز بهداشت وُ درمانی و نرم‌افزار امنیتی مانند [Let's Encrypt](https://github.com/letsencrypt) اهمیت بالایی پیدا می‌کند تا زمان بازرسی خطاها توسط افراد مختلف، دچار مشکل نشوند.

ویژگی متن باز فقط مختص به نرم‌افزارها نیست، شما هر چیزی حتی مجموعه‌ای از داده‌های یک کتابخانه را می‌توانید متن باز کنید. اگر می‌خواهید بیشتر بدانید که چه چیزهای دیگری را می‌شود متن باز کرد، می‌توانید به [GitHub Explore](https://github.com/explore) مراجعه کنید.

### آیا پروژ‌های متن باز «مجانی / رایگان» هستند؟

یکی از بزرگ‌ترین جذابیت‌های متن بازها این است که پولی نیستند. هرچند، رایگان بودن، یک محصول جانبی با ارزش کلی یک پروژه‌ی متن باز است.

به عبارت دیگر، [در لایسنس و گواهینامه‌ی پروژه‌های متن بازها آورده شده است](https://opensource.org/osd-annotated) که هر کسی می‌تواند آن‌ها را استفاده، ویرایش و تقریباً با هر هدفی به اشتراک بگذارد. از این رو، پروژه‌های متن باز به صورت رایگان عرضه می‌شوند و اگر هم استفاده‌ از این پروژه‌ها پولی شود، هر کسی به صورت قانونی می‌تواند از آن کپی بگیرد و درعوض، از نسخه‌ی رایگان آن استفاده کند

در نتیجه، بیشتر پروژه‌های متن باز به صورت رایگان ارائه می‌شوند و از طرفی هم «رایگان بودن / مجانی بودن» به عنوان بخشی از تعریف پروژه‌های متن باز به حساب نمی‌آید، یعنی پروژه‌های متن باز هم به صورت رایگان و هم به صورت پولی هستند. البته راههایی سازگار با مجوزهای متن باز مثل ارائه مجوز دوگانه یا محدودکردن ویژگی ها به دو دسته رایگان و پولی برای کسب درآمد غیرمستقیم از پروژه‌های متن باز وجود دارد.

## آیا پروژه‌ی متن باز خودم را باید منتشر کنم؟

اگر بخواهیم کوتاه جواب بدهیم، بله. چون خروجی پروژه‌ی شما مهم نیست. مهم این است که پروژه‌تان منتشر شود و بهترین راه برای یاد گرفتن نحوه‌ی کار پروژه‌های متن باز انتشار آن‌هاست.

اگر هیچوقت پروژه‌ی متن بازتان را منتشر نکرده‌اید، ممکن است این نگرانی برای‌تان پیش بیاید افراد مختلف چه چیزی درباره‌ی پروژه‌تان می‌گویند یا اصلا به پروژه‌ی شما توجه می‌کنند یا خیر. اگر چنین احساسی دارید، باید بگوییم که تنها نیستید.

کار یک پروژه‌ی متن باز مانند هر فعالیت خلاقانه‌ی دیگری مثل نویسندگی و نقاشی است. زمانی که شما به عنوان یک هنرمند اولین اثر خود را با دنیا به اشتراک می‌گذارید، احساس ترس به سراغتان می‌آید. اما این کار را باید انجام دهید، چون تمرین تنها راه بهتر شدن است؛ حتی اگر یک مخاطب هم نداشته باشید.

اگر هنوز هم متقاعد نشدید، به این فکر کنید که اهداف‌تان چه چیزهایی می‌توانند باشند.

### اهداف‌تان را مشخص کنید

اهداف می‌تواند به شما کمک کند تا متوجه شوید که بر روی چه چیزی کار کنید، به چه چیزی نه بگویید و کجا به کمک دیگران نیاز دارید. با سوال کردن از خودتان شروع کنید. از خودتان بپرسید: _چرا می‌خواهم این پروژه را متن باز کنم؟_

خب، واضح است که هیچ کس جواب درستی برای این سوال ندارد. چون ممکن است چندین هدف برای یک پروژه یا پروژه‌های مختلفی با اهداف متفاوتی وجود داشته باشد.

اگر نمایش دادن کارتان تنها هدف برای متن باز کردن پروژه‌تان باشد، احتمالاً مشارکت دیگران را نمی‌خواهید و این نخواستن مشارکت را هم در فایل README پروژه‌تان نیز می‌آورید. از طرف دیگر، اگر واقعاً مشارکت دیگران را بخواهید، زمان خود را صرف مرتب کردن اسناد و صرف خوشامدگویی به افرادی می‌کنید که تازه وارد این حوزه شدند.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">
  زمانی که پروژه‌ی UIAlertView شخصی را تولید و استفاده کردم ....  و تصمیم گرفتم آن را متن باز کنم، تغییراتی در آن اعمال کردم تا پویایی بیشتری داشته باشد و آن را در GitHub آپلود کردم. من همچنین اولین سندی (که توضیح پروژه در آن نوشته می‌شود) را برای سایر توسعه‌دهنده‌ها نوشتم که نحوه‌ی کار با پروژه‌ی من چگونه است. احتمالاً به خاطر اینکه پروژه‌ی ساده‌ای بود، هیچ‌کس از آن استفاده نکرد. هرچند، اما به خاطر مشارکتم به سایر توسعه‌دهنده‌ها احساس خوبی داشتم.
  <p markdown="1" class="pquote-credit">
— @mavris, ["Self-taught Software Developers: Why Open Source is important to us"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

وقتی که پروژه‌ی شما رشد می‌کند، جامعه‌ی مخاطب پروژه‌هایتان احتمالاً بیشتر از یک کد به شما نیاز خواهند داشت. وظایف مهمی که در یک پروژه‌ی متن باز به شما محول می‌شود این است که برای مشکلات پاسخی داشته باشید، کدها را بررسی کنید و مژده‌ی پروژه‌ی متن بازتان را به دیگران بدهید.

اگرچه مدت زمانی که صرف کارهای غیرکدنویسی می‌کنید، به اندازه و دامنه‌ی پروژه‌یتان بستگی دارد، اما به عنوان یک مسئول‌نگهداری پروژه باید خودتان را آماده کنید آن‌ها را انجام دهید یا حداقل شخصی را پیدا کنید که در کارهای غیرکدنویسی به شما کمک کند.

**اگر جزئی از یک پروژه‌ی متن باز یک شرکت هستید،** مطمئن شوید پروژه‌یتان منابع لازم داخلی برای پیشرفت را داشته باشد. از این رو، باید بدانید که چه کسی مسئول نگهداری پروژه‌ی متن بازتان است و چگونه می‌خواهید این وظایف را با جامعه‌ی خود به اشتراک بگذارید

اگر برای ارتقاء، بهره‌برداری و نگهداری پروژه به بودجه خاص یا کارمند نیاز دارید، می‌توانید این نیازها را در ابتدا اعلام کنید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">
  زمانی که پروژه‌ی متن بازتان را شروع می‌کنید، مهم است که اطمینان حاصل کنید که فرآیندهای مدیریتی شما ظرفیت مشارکت‌ها و توانایی‌های جامعه‌ی پیرامونی و مخاطب پروژه‌تان را در برگیرد. از مشارکت دادن مشارکت‌کننده‌هایی نترسید که از جنبه‌های کلیدی پروژه، کارمند کسب و کارتان نیستند، به خصوص اگر مشارکت آن‌ها با شما مکرر باشد.
  <p markdown="1" class="pquote-credit">
— @captainsafia, ["So you wanna open source a project, eh?"](https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779)
  </p>
</aside>

### مشارکت در سایر پروژه‌ها

اگر هدف‌تان این باشد که با دیگران در پروژه‌های متن باز همکاری کنید یا می‌خواهید نحوه‌ی عملکرد یک پروژ‌ه‌ی متن باز را درک کنید، همکاری و مشارکت با پروژه‌های موجود را در نظر بگیرید. با پروژه‌ای شروع کنید که قبلا به آن علاقه‌مند بودید و از آن استفاده می‌کردید. مشارکت در یک پروژه‌ی متن باز می‌تواند به سادگی اصلاح یک کد اشتباه یا آپدیت / به‌روزرسانی اسناد باشد.

اگر مطمئن نیستید که چگونه می‌توانید در سایر پروژه‌ها مشارکت کنید، به مقاله‌ی [راهنمای نحوه‌ی همکاری در پروژه‌ی متن باز](../how-to-contribute/) مراجعه کنید

## انتشار پروژه‌ی متن باز خودتان

زمان مناسبی برای متن باز کردن پروژه‌تان وجود ندارد. از این رو، می‌توانید یک ایده، کارهایی در دست اقدام یا پروژه‌هایی که بعد از سال‌ها بسته ماندند، را متن باز کنید.

به طور کلی، هر زمان که احساس کردید با دیدگاه‌ها و بازخوردهای دیگران راحت هستید، باید پروژه‌یتان را متن باز کنید.

مهم نیست در چه مرحله‌ای تصمیم گرفتید پروژه‌تان را متن باز کنید. هر پروژه‌ای باید حاوی اسناد زیر باشد:

* [لایسنس متن باز](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [راهنمای مشارکت](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [آیین نامه رفتار](../code-of-conduct/)

این مؤلفه‌ها به شما به عنوان مسئول‌نگهداری پروژه کمک می‌کند تا انتظارات‌تان را بیان، مشارکت‌ها را مدیریت و از حقوق قانونی خود و دیگران محافظت کنید. این موارد شانس شما را برای داشتن یک تجربه‌ی خوب افزایش می‌دهد.

اگر پروژه‌ی شما در GitHub قرار دارد، قرار دادن فایل‌های فوق به همراه نام فایل‌های توصیه‌شده در پوشه ریشه (root) می‌تواند به GitHub کمک کند تا آن‌ها را به صورت خودکار به مخاطبان‌تان شناسایی کند و نمایش دهد.

### انتخاب لایسنس یا مجوز

لایسنسِ یا مجوز یک پروژه‌ی متن باز به دیگران ضمانت می‌دهد از پروژه‌ی متن باز استفاده، کپی، ویرایش و بدون هیچ عواقبی در آن مشارکت کنند. لایسنس همچنین از شما در برابر موقعیت‌های سخت قانونی محافظت می‌کند. **زمانی که می‌خواهید پروژه‌ی متن بازتان را منتشر کنید، حتما لایسنس آن را هم ضمیمه کنید**.

کارهای ادارای و حقوقی برای گرفتن لایسنس هیچ جذابیتی ندارد، اما خبر خوب اینجاست که می‌توانید لایسنس‌های موجود و در دسترس را که از قبل توسط دیگران تدوین شده را در repository (مخزن) خود کپی و پیست کنید. برای محافظت از تلاشی که برای متن باز کردن پروژه‌تان انجام دادید، این کار تنها یک دقیقه وقت شما را می‌گیرد.

[MIT](https://choosealicense.com/licenses/mit/)، [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) و [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) جزء محبوب‌ترین لایسنس‌های متن باز هستند. هرچند، لایسنس‌های دیگری هم وجود دارد که می‌توانید از آن‌ها استفاده کنید.

زمانی که پروژه‌ی جدیدی در GitHub ایجاد می‌کنید، به شما امکان انتخاب لایسنس داده می‌شود. انتخاب کردن لایسنس باعث می‌شود GitHub پروژه‌ی شما را متن باز نشان دهد.

![انتخاب مجوز](/assets/images/starting-a-project/repository-license-picker.png)

در ادامه‌ی مقاله، سایر سوالات و نگرانی‌هایتان درباره‌ی [جنبه‌های قانونی](../legal/) مدیریت پروژه‌ی متن بازتان را بررسی خواهیم کرد.

### نوشتن فایل «README» (فایلی که توضیحات پروژه در آن آورده می‌شود)

فایل README اطلاعات بیشتری نسبت به این دارد که نحوه‌ی استفاده از پروژه‌تان را به کاربر توضیح دهد. این فایل همچنین توضیح می‌دهد که پروژه‌ی شما چه اهمیتی دارد و کاربران‌تان با این پروژه چه کارهای می‌توانند انجام دهند.

سعی کنید در فایل README خودتان به سوالات زیر پاسخ دهید و جواب آن‌ها را در فایل بیاورید:

* پروژه‌ی شما چه کاری انجام می‌دهد؟
* چرا این پروژه مفید است؟
* چگونه شروع کردم؟
* در صورت نیاز، از کجا می‌توانم کمک بیشتری دریافت کنم؟

شما با فایل README می‌توانید به سایر سوالات نیز پاسخ دهید؛ سوالاتی مانند اینکه چگونه مشارکت‌تان را مدیریت می‌کنید، اهداف پروژه‌تان چیست و اطلاعات لایسنس و اختیارات پروژه‌تان را هم می‌توانید بیاورید. اگر مشارکت کسی را نمی‌خواهید قبول کنید، یا پروژه‌ی شما هنوز برای ارائه آماده نشده باشد، می‌توانید این توضیحات را در فایل README بیاورید

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">
  هرچه اسنادتان اعم از فایل README، راهنمای مشارکت، آیین نامه رفتار و لایسنس در پروژه‌ی متن باز شما بهتر باشد، کاربران بیشتری به شما جذب می‌شود، پشتیبانی کمتری درخواست می‌شود و مشارکت‌کننده‌های بیشتری در پروژه مشارکت می‌کنند. به یاد داشته باشید که مخاطبانتان جای شما نیستند و افرادی ممکن است وارد پروژه‌ی شما شوند که تجربه‌های کاملاً متفاوتی دارند.
  <p markdown="1" class="pquote-credit">
— @tracymakes, ["Writing So Your Words Are Read (video)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

بعضی از افراد از نوشتن فایل README خودداری می‌کنند، چون فکر می‌کنند پروژه‌ی آن‌ها هنوز تکمیل نشده یا اینکه نمی‌خواهند کسی مشارکتی داشته باشد. همین‌ها دلایل خیلی خوبی برای نوشتن یک فایل README محسوب می‌شوند.

برای نوشتن یک فایل README کامل، می‌توانید به مقالات @dguo's ["Make a README" guide](https://www.makeareadme.com/) یا @PurpleBooth's [README template](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2) مراجعه کنید و از آن‌ها الهام بگیرید

زمانی که فایل README را در دایرکتوری ریشه خود قرار می‌دهید، GitHub به صورت خودکار آن را در صفحه‌ی اصلی repository (انبار) نشان می‌دهد.

### نوشتن راهنمای مشارکت

فایل CONTRIBUTING (مشارکت) به مخاطبان‌تان می‌گوید که چگونه در پروژه‌ی شما مشارکت کنند. به عنوان مثال، می‌توانید اطلاعات زیر را در آن قید کنید:

* چگونه یک باگ یا مشکل گزارش شود
* چگونه ویژگی جدیدی پیشنهاد دهند
* چگونه محیط پروژه‌تان را تنظیم و آن را برای تست اجرا کنند

به علاوه، در فایل CONTRIBUTING می‌توانید جزئیات فنی و انتظارات‌تان را برای مشارکت‌کننده‌ها بیان کنید. به عنوان مثال:

* نوع مشارکتی که به دنبال آن هستید
* نقشه‌ی راه یا دیدگاهی که به پروژه دارید
* چگونه مشارکت‌کننده‌ها باید (یا نباید) با شما در تماس باشند

زمانی که با خونگرمی، حس دوستانه و دادن پیشنهادهای خاص (مانند نوشتن اسناد، یا طراحی وب‌سایت) با  مشارکت‌کننده‌هایتان برخورد می‌کنید، بیشتر راه را برای استقبال از تازه‌واردها رفته‌اید و همین کار شما باعث می‌شود آن‌ها برای همکاری با شما هیجان‌زده شوند.

برای روشن شدن مطلب اجازه دهید نمونه‌ای بیاوریم. به عنوان مثال، [Active Admin](https://github.com/activeadmin/activeadmin/) [راهنمای مشارکت خود](https://github.com/activeadmin/activeadmin/blob/HEAD/CONTRIBUTING.md) به مشارکت‌کننده‌ها را اینگونه شروع می‌کند

> در ابتدا، از شما ممنون هستم که می‌خواهید با Active Admin مشارکت کنید. افرادی مثل شما هستند که باعث می‌شوند Active Admin عملکرد خوبی داشته باشد.

در ابتدایی‌ترین مرحله‌ی پروژه‌تان، فایل CONTRIBUTING می‌تواند ساده باشد. شما در این فایل همیشه باید نحوه‌ی گزارش دادن باگ‌ها (خطاها) یا مشکلات فایل و هر نیاز فنی مانند تست کردن را برای مشارکت‌کننده‌ها توضیح دهید.

در طول زمان، ممکن است اطلاعات و سوالات مکرر زیادی به فایل CONTRIBUTING خود اضافه کنید. از این رو، افراد کمتری پیدا می‌شوند که سوالات تکراری از شما بپرسند.

برای اینکه بدانید چگونه اطلاعات فایل CONTRIBUTING خود را بنویسید، می‌توانید به مقالات @nayafia's [contributing guide template](https://github.com/nayafia/contributing-template/blob/HEAD/CONTRIBUTING-template.md) یا @mozilla's ["How to Build a CONTRIBUTING.md"](https://mozillascience.github.io/working-open-workshop/contributing/) مراجعه کنید.

[لینک فایل CONTRIBUTING خود را در فایل README قرار دهید](https://help.github.com/articles/setting-guidelines-for-repository-contributors/) تا افرادی که آن را مطالعه می‌کنند این فایل مشارکت را هم ببینند. اگر فایل CONTRIBUTING خود را در repository (انبار) (مخزن) پروژه‌تان قرار داده باشید، زمانی که یک مشارکت‌کننده طرح مشکل یا گزارش یک باگ یا درخواست ادغام کند، GitHub به صورت خودکار او را به لینک فایل CONTRIBUTING هدایت می‌کند

![راهنماهای مشارکت](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### تعیین آیین نامه‌ی رفتاری (Code of Conduct)

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">
  همه‌ی ما به عنوان یک مسئول‌نگهداری پروژه با سوءاستفاده‌هایی مواجه شده‌ایم که در آن سعی می‌کردیم توضیح دهیم چرا چیزی را باید از مسیر خاص خودش طی کنیم، یا به عنوان یک کاربر تلاش می‌کردیم یک سوال ساده بپرسیم. آیین نامه‌ی رفتاری به سندی قابل ارجاع و پیوندی تبدیل شده که نشان می‌دهد تیم شما اجرای گفتمان سازنده را بسیار جدی می‌گیرد.
  <p markdown="1" class="pquote-credit">
— @mlynch, ["Making Open Source a Happier Place"](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

بالاخره، آیین نامه‌ی رفتاری به ما کمک می‌کند برای رفتارهای مشارکت‌کننده‌های پروژه‌تان قوائدی تعیین کنید. زمانی که بخواهید یک پروژه‌ی متن بازی را برای انجمن یا یک شرکت منتشر کنید، این قوائد می‌تواند ارزشمند باشد. آیین نامه‌ی رفتاری یا (Code of Conduct) این قدرت را به شما می‌دهد تا رفتارهای سازنده و سالم  را در بین جامعه کاربران ترویج کنید که در آینده به عنوان یک مسئول‌نگهداری پروژه احساس استرس کمتری داشته باشید.

برای اطلاعات بیشتر می‌توانید به [راهنمای آیین نامه‌ی رفتاری](../code-of-conduct/) مراجعه کنید.

علاوه بر اینکه یک آیین نامه‌ی رفتاری رفتارهایی که از شرکت‌کنند‌هایتان انتظار دارید را باید به آن‌ها بگوید، این را هم باید تعریف کنید که اجرای این انتظارات به چه کسانی و در چه زمان‌هایی باید انجام می‌شود. آیین نامه‌ی رفتاری همچنین مشخص می‌کند که درصورت بروز تخلف چه کاری باید انجام شود.

مشابه استفاده از مجوزهایی که از قبل توسط دیگران تدوین شده استانداردهای نوظهوری برای آیین نامه‌ی رفتاری وجود دارد که لازم نیست خودتان آن را بنویسید. [Contributor Covenant](https://contributor-covenant.org/) یکی از جاهایی است که آیین نامه‌هایی در همین خصوص ارائه می‌کند و حاصل کار آن در [بیش از 40.000 پروژه‌ی متن باز](https://www.contributor-covenant.org/adopters) مانند Kubernetes، Rails و Swift استفاده می‌شود. مهم نیست متن آیین نامه‌ی رفتاری شما چیست، مهم این است که در صورت لزوم باید از آیین نامه‌ی رفتاری خودتان استفاده کنید

متن آیین نامه‌ی رفتاری خود را مستقیما در فایل CODE_OF_CONDUCT در مخزن گیت هاب خودتان کپی و پیست کنید. فایل را در دایرکتوری روت پروژه‌تان ذخیره کنید تا پیدا کردن و لینک دادن آن به فایل README راحت باشد.

## نام‌گذاری و برندسازی پروژه

برندسازی چیزی فراتر از یک لوگوی پُر زرق وُ برق یا یک نام جذاب برای پروژه‌تان است. برندسازی نحوه‌ی صبحت کردن درباره‌ی پروژه و نحوه رساندن پیام به مخاطب‌تان را نشان می‌دهد.

### انتخاب نام درست

برای پروژه‌تان از نامی استفاده کنید که یادآوری آن ساده باشد. به طور ایده آل، می‌توانید بعضی از ایده‌ها را از پروژه‌های زیر مشاهده کنید. به عنوان نمونه:

* [Sentry](https://github.com/getsentry/sentry) اپ ها را با هدف گزارش خطاهای رخ داده در آنها پایش می کند
* [Thin](https://github.com/macournoyer/thin) یک وب سرور ساده و سریع روبی است

اگر در حال طراحی پروژه‌تان هستید، به کارگیری نام آن‌ها به عنوان پیشوند می‌تواند به شفاف کردن پروژه‌تان کمک کند. به عنوان نمونه، ([node-fetch](https://github.com/bitinn/node-fetch)، Window.fetch را به Node.js می‌آورد).

با در نظر گرفتن توصیه بالا. می‌توان عناوین بامزه یا خوب زیادی ساخت، اما این را به یاد داشته باشید که بعضی از بازی با کلمات و جناس‌ها ممکن است در سایر فرهنگ‌ها یا افرادی که تجربه‌های متفاوتی نسبت به شما دارند، مفهوم یا ترجمه‌ی نادرستی داشته باشد. برخی از کاربران بالقوه شما هم ممکن است کارمندان یک شرکت باشند و حتما نمی‌خواهید زمانی که در حال توضیح دادن نحوه‌ی پروژه‌تان در محل کارشان هستند، احساس نامساعدی داشته باشند.

### از نام‌گذاری‌های دارای منافات خودداری کنید

اگر پروژه‌ی شما زبان و اکوسیستم یکسانی دارد، می‌توانید نام پروژه‌های مشابه با پروژه‌تان را [بررسی کنید](http://ivantomic.com/projects/ospnc/). اگر نام پروژه‌ی شما با پروژه‌ی دیگری شباهت زیادی داشته باشد، مخاطب شما ممکن است سردرگم شود.

اگر در یک وب‌سایت، توئیتر یا دیگر شبکه‌های اجتماعی می‌خواهید پروژه‌تان را نشان دهید، مطمئن شوید همان نامی را انتخاب کنید که می‌خواهید. به طور ایده آل، حتی اگر هنوز نمی‌‌خواهید از آن نام استفاده کنید و برای اینکه خیال‌تان راحت باشد، آن نام را [وارونه کنید](https://instantdomainsearch.com/)

مطمئن شوید نام پروژه‌ی شما هیچ برند تجاری را نقض نمی‌کند. اگر چنین باشد، آن شرکت می‌تواند بعدها از شما درخواست کند پروژه‌تان را کنسل کرده یا حتی به صورت قانونی با شما برخورد کند. بنابراین، ارزش این همه ریسک را ندارد و برای جلوگیری از چنین مشکلاتی حتما از نام مناسبی استفاده کنید.

برای بررسی تضاد و منافات برندهای تجاری می‌توانید به پایگاه داده برندهای جهانی [WIPO Global Brand Database](http://www.wipo.int/branddb/en/) مراجعه کنید. اگر شما یک شخص حقوقی هستید و در یک شرکت فعالیت می‌کنید، این یکی از چیزهایی است که [تیم حقوقی‌تان می‌تواند](../legal/) به شما کمک کند

در نهایت، نام پروژه‌تان را به سرعت در گوگل جستجو کنید. ببینید که افراد به راحتی می‌توانند پروژه‌تان را پیدا کنند؟ در نتایج جستجوی شما چیزی دیگر پیدا می‌شود که نمی‌خواهید کاربران آن را مشاهده کنند؟

### چگونه نوشتن و کدنویسی شما روی برندتان اثر می‌گذارد!

در طول عمر پروژه‌تان، در حال نوشتن چیزهای زیادی خواهید بود که می‌توان به نوشتن فایل‌های README، آموزش‌ها، اسناد انجمن، نوشتن پاسخ به مشکلات، حتی شاید نوشتن و پاسخ دادن به خبرنامه و فهرست پستی، اشاره کرد.

سبک نویسندگی شما چه در اسناد رسمی و چه در ایمیل‌های محاوره‌ای بخشی از برند پروژه‌تان است. به این فکر کنید چگونه می‌خواهید با مخاطب‌تان برخورد کنید و ببینید این لحن نوشتاری همان چیزی است که می‌خواهید به مخاطب فرستاده شود یا خیر.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  زمان ارسال هر پست، تلاش می‌کردم رفتار ستوده‌ای داشته باشم، با مردم درست رفتار کنم، مشکلات‌شان را جدی بگیرم و در کل سعی می‌کردم مفید باشم. بعد از مدتی، افراد نه تنها سوال می‌پرسیدند، بلکه در جواب دادن در برخی سوالات به من کمک می‌کردند و در نهایت لذت آن‌ها از سبک نویسندگی من تقلید می‌کردند
  <p markdown="1" class="pquote-credit">
— @janl on [CouchDB](https://github.com/apache/couchdb), ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

زمانی که از یک زبان جامع و گرم استفاده می‌کنید و حتی زمانی که با یک فرد صحبت می‌کنید، به جای کلمه‌ی «تو» کلمه‌ی «شما» را به کار می‌برید، کمک زیادی به شما می‌کند تا مشارکت‌کننده‌های جدید از پروژه‌ی شما استقبال کنند. اگر می‌خواهید به زبان انگلیسی بنویسید، سعی کنید ساده باشد. چون زبان بیشتر خواننده‌های شما بومی نیست.

جدا از کلماتی که در نوشتن اسناد مختلف استفاده می‌کنید، سبک کدنویسی شما هم ممکن است به بخشی از برند پروژه‌تان تبدیل شود. به عنوان مثال می‌توانیم به دو نمونه پروژه به نام‌های [Angular](https://angular.io/guide/styleguide) و [jQuery](https://contribute.jquery.org/style-guide/js/) اشاره کنیم که راهنما و سبک کدنویسی سختی دارند

در ابتدای کار لازم نیست از راهنمای سبک نویسندگی استفاده کنید. به هر حال، به مرور از ترکیب سبک متفاوت کدنویسی خود در پروژه‌تان لذت خواهید برد. هرچند، این را باید پیش‌بینی کنید که نحوه‌ی نویسندگی و سبک کدنویسی شما ممکن است انواع مختلف افراد را جذب یا دفع کند. در ابتدای‌ترین مرحله‌ی پروژه‌تان فرصت دارید مقدماتی که می‌خواهید مخاطبان ببنند را ارائه دهید.

## مرور (چک لیست / لیست بررسی) قبل از انتشار پروژه‌ی متن باز

خب، آماده هستید تا پروژه‌تان را متن باز کنید؟ چک لیست در این مرحله می‌تواند به شما کمک کند. تمام گزینه‌ها و تیک‌ها را بررسی کرده‌اید؟ به محض آماده شدن، روی انتشار [publish](https://help.github.com/articles/making-a-private-repository-public/) کلیک کنید و به خودتان تبریک بگویید.

**مستندات**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    پروژه حاوی فایل (LICENSE)  لایسنس متن باز است
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    پروژه حاوی اسناد پایه اعم از (فایل README، CONTRIBUTING و فایل CODE_OF_CONDUCT) است
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    نام پروژه ساده است، می‌توان آن را به راحتی به خاطر سپرد، نام پروژه این ایده را به مخاطب می‌دهد که پروژه چه کارهایی انجام می‌دهد و نام پروژه با هیچ پروژه موجودی منافات ندارد یا هیچ برند تجاری را نقض نمی‌کند.
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    صف مشکلات و مسائل گزارش شده با زدن برچسب های مناسب سازماندهی شده و بروز است.
  </label>
</div>

**کد**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    پروژه از توافق‌های از پیش تعیین شده در خصوص نام‌های متغیر/متدها و توابع استفاده می‌کند
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
	کد به خوبی کامنت‌گذاری شده و تو رفتگی‌ها و کوچکی و بزرگی حروف در جای لازم رعایت شده است.    
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    There are no sensitive materials in the revision history, issues, or pull requests (for example, passwords or other non-public information)
	اطلاعات حساسی مثل کلمه های عبور یا کلیدهای خصوصی از طریق Pull Request یا گزارش مشکل و... برای عموم آشکار نشود
  </label>
</div>

**افراد**

اگر شما شخص حقیقی هستید:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  (اگر در جایی کارمند هستید)، با دپارتمان / بخش حقوقی خود صحبت کرده‌اید، IP و شرایط و قوانین متن باز شرکت را متوجه شده‌اید.
  </label>
</div>

اگر شخص حقوقی هستید و در یک سازمان یا یک شرکت فعالیت می‌کنید:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    با دپارتمان / بخش حقوقی صحبت کرده‌اید.
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    برای اطلاع رسانی و ترویج پروژه‌ام برنامه‌ی بازاریابی دارم.
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
	یک شخص برای مدیریت تعاملات اجتماعی (پاسخ به مشکلات، بررسی و درخواست ادغام) که متعهد باشد حضور دارد.
    </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    حداقل دو نفر دسترسی مدیریتی (Admin) به پروژه داشته باشند
  </label>
</div>

## انجامش دادی!

اولین پروژه‌ی متن بازتان را تبریک می‌گوییم. بهتر است بدانید که خروجی آن مهم نیست، فقط با این کار تجربه‌ی کار در فضای جامعه را به دست آوردید. با هر کامیت (Commit)، کامنت (Comment) و پاسخ به درخواست ادغام فرصتی برای رشد و یادگیری خود و دیگران ایجاد می‌کنید.
