---
lang: fa
title: سنجه‌های پروژه‌های متن باز
description: آگاهانه تصمیم‌گیری کنید تا با ارزیابی و پیگیری موفقیت، به پیشرفت پروژۀ متن باز خود کمک کنید.
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
---

## چرا چیزی را ارزیابی کنیم؟

هنگامی که داده‌ها هوشمندانه استفاده شوند، به شما کمک می‌کنند تا به عنوان یک نگهدارندۀ متن باز تصمیمات بهتری بگیرید.

با اطلاعات بیشتر، می‌توانید:

* درک بهتری از واکنش کاربران به ویژگی‌های جدید داشته باشید
* بفهمید کاربران جدید از کجا آمده‌اند
* موارد کاربردی برجسته و قابلیت‌ها را شناسایی کنید و تصمیم بگیرید که آیا به پشتیبانی از آن‌ها ادامه می‌دهید یا خیر
* محبوبیت پروژۀ خود را بسنجید
* جنبه‌های کاربردی پروژه را درک کنید
* از طریق اسپانسرها و کمک‌هزینه‌ها، پول جمع‌آوری کنید

به عنوان مثال، پروژۀ متن باز [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md) دریافت که «Google Analytics» به آن‌ها در اولویت‌بندی کارها کمک می‌کند.

> «Homebrew» بصورت رایگان در اختیار کاربران قرار می‌گیرد و توسط داوطلبان در اوقات فراغت‌شان اداره می‌شود. در نتیجه، ما منابع لازم برای انجام مطالعات دقیق دربارۀ کاربران «Homebrew» را نداریم تا در مورد چگونگی بهترین طراحی برای ‌آینده و اولویت‌بندی کارهای فعلی تصمیم بگیریم. تجزیه و تحلیل کلی و ناشناس در رابطه با کاربران به ما امکان می‌دهد اصلاحات و ویژگی‌ها را بر اساس شیوه، مکان و زمان استفادۀ کاربران از «Homebrew» اولویت‌بندی کنیم.

محبوبیت، همه چیز نیست. دلایل متفاوت زیادی برای ورود افراد در پروژه‌های متن باز وجود دارد. اگر هدف شما به عنوان نگهدارندۀ متن باز این است که کار خود را در معرض نمایش بگذارید، پس همینطور برخورد کنید یا فقط از آن لذت ببرید؛ معیارها برای شما آنچنان مهم نیستند.

اگر _می‌خواهید_ به سطح درک عمیق‌تری دربارۀ پروژۀ خودتان برسید، روش‌های تجزیه و تحلیل فعالیت‌های پروژه خود را بدانید.

## کشف و پیدا کردن

قبل از اینکه کسی بتواند از پروژۀ شما استفاده کند یا در آن مشارکت داشته باشد، باید بداند که همچین پروژه‌ای وجود دارد. از خودتان بپرسید: _آیا مردم می‌توانند این پروژه را پیدا کنند؟_

![Traffic graph](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

اگر پروژۀ شما در «GitHub» قرار دارد، [می‌توانید ببینید](https://help.github.com/articles/about-repository-graphs/#traffic) افرادی که در پروژۀ شما هستند از کجا آمده‌اند؟ در صفحه پروژۀ خود، روی «Insights» و سپس «Traffic» کلیک کنید. در این صفحه، این موارد را می‌توانید ببینید:

* **تعداد بازدیدها از صفحه:** به شما می‌گوید پروژه چند بار دیده شده است

* **تعداد بازدیدکنندگان منحصر به فرد:** به شما می‌گوید چند نفر پروژه را دیده‌اند

* **سایت‌های ارجاع دهنده یا معرفی‌کننده:** به شما می‌گوید، بازدیدکنندگان از کجا آمده‌اند. این معیار به شما کمک می‌کند تا بفهمید در کجا می‌توانید به مخاطب خود دسترسی پیدا کنید و آیا تلاش‌های تبلیغاتی شما موثر واقع شده است یا خیر.

* **محتوای محبوب:** به شما می‌گوید، بازدیدکنندگان به کدام بخش پروژۀ شما می‌روند و شمار بازدیدهای صفحه و بازدیدکنندگان منحصر به فرد را نشان می‌دهد.

قسمت [GitHub stars](https://help.github.com/articles/about-stars/) هم می‌تواند به صورت معیاری برای محبوبیت عمل کند.اگرچه «GitHub stars» لزوماً با تعداد دانلودها و استفاده از محتوا ارتباط مستقیمی ندارد، اما این قسمت می‌تواند به شما بگوید که چه تعدادی از آدم‌ها متوجه پروژۀ شما شده‌اند..

همچنین شاید بخواهید قابلیت کشف شدن (شناخته‌ شدن) را در [بخش‌های مشخصی ردیابی کنید](https://opensource.com/business/16/6/pirate-metrics): به عنوان مثال، «Google PageRank»، ترافیک رجوعی به وب‌سایت پروژۀ شما، یا مراجعات از سایر پروژه‌های متن‌باز یا سایر وب‌سایت‌ها.

## استفاده

مردم پروژۀ شما را در این دنیای عجیب‌غریبی که اینترنت می‌نامیم، پیدا می‌کنند. در بهترین حالت، وقتی پروژۀ شما را ببینند، به آن مشتاق می‌شوند و می‌خواهند کاری انجام دهند. دومین سوالی که باید از خود بپرسید این است که: _آیا مردم از این پروژه استفاده می‌کنند؟_

اگر از یک برنامۀ مدیریت پکیج (package manager) مانند «npm» یا «RubyGems.org» برای انتشار پروژۀ خود استفاده می‌کنید، می‌توانید دانلودهای مربوط به پروژه را ردیابی کنید.

هر برنامۀ  مدیریت پکیجی ممکن است تعریف متفاوتی از دانلود داشته باشد و دانلود لزوماً با نصب یا استفاده ارتباط داشته باشد، اما مبنایی را برای مقایسه فراهم می‌کند. برای پیگیری آمارهای مختلف می‌توانید در میان بسیاری از مدیریت‌های محبوب پیکیج، از [Libraries.io](https://libraries.io/) استفاده کنید.

اگر پروژۀ شما در «GitHub» است، دوباره به صفحۀ «Traffic» بروید. می‌توانید از نمودار کلون [clone graph](https://github.com/blog/1873-clone-graphs) استفاده کنید تا ببینید چند بار پروژۀ شما در یک روز مشخص کپی شده است، که این نمودار براساس کل کلون‌ها (کپی‌ها) و کپی‌های منحصر به فرد مشخص شده است.

![Clone graph](/assets/images/metrics/clone_graph.png)

اگر میزان استفاده در مقایسه با تعداد افرادی که پروژۀ شما را پیدا می‌کنند کم است، دو مسئله وجود دارد که باید در نظر بگیرید:

* مخاطبان به طور موفقیت‌آمیز با پروژۀ شما ارتباط نمی‌گیرند
* یا مخاطبان اشتباهی را جذب کرده‌اید

به عنوان مثال، اگر پروژۀ شما در صفحۀ اول «Hacker News» قرار گیرد، احتمالاً جهشی در میزان کشف (ترافیک) اما با نرخ گرایش پایینی را مشاهده خواهید کرد؛ زیرا در Hacker News، افراد زیادی پروژۀ شما را پیدا می‌کنند. اگر پروژۀ «Ruby» شما در یک مجمع «Ruby» ارائه شده باشد، به احتمال زیاد نرخ گرایش بالایی از مخاطبان هدف را شاهد خواهید بود.

سعی کنید بفهمید مخاطبان شما از کجا می‌آیند و از نظرات دیگران در مورد صفحۀ پروژۀ خود بهره ببرید تا متوجه شوید با کدام یک از این دو مسئله روبرو هستید.

وقتی با مخاطبان و افرادی که از پروژۀ شما استفاده می‌کنند آشنا شدید، بهتر است بفهمید که آن‌ها چه استفاده‌ای از پروژه می‌کنند. آیا آن‌ها با فورک کردن کد شما و افزودن ویژگی‌های مختلف، بر روی آن کار می‌کنند؟ آیا آن‌ها از آن برای مصارف علمی یا تجاری استفاده می‌کنند؟

## استمرار و نگهداری

مردم پروژۀ شما را پیدا می‌کنند و از آن استفاده می‌کنند. سوالی که باید از خودتان بپرسید این است که: _آیا مردم در آن مشارکت هم می‌کنند یا خیر؟_

هیچ‌وقت برای فکر کردن به مشارکت‌کنندگان دیر نیست. اگر پروژۀ شما محبوب باشد (بسیاری از آن استفاده کنند) و سایر افراد دست به کار نشوند و از آن _پشتیبانی نکنند_ خود را در موقعیتی ناسالم قرار می‌دهید (به اندازۀ کافی نگهدارنده نداشته باشید).

نگهداری، مستلزم [ورود مشارکت‌کنندگان جدید](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2) است، زیرا مشارکت‌کنندگان فعال قبلی در نهایت به سراغ کارهای دیگر می‌روند.

نمونه‌هایی از معیارهای انجمن که باید مرتباً آن‌ها را بررسی کنید، شامل این موارد می‌شود:

* **تعداد کل مشارکت‌کنندگان و تعداد تعهدات هر مشارکت‌کننده:** به شما می‌گوید چه تعداد مشارکت‌کننده دارید و چه کسانی کم و بیش فعال هستند. این بخش را می‌توانید در «GitHub» در قسمت «Insights -> Contributors» مشاهده کنید. در حال حاضر، این نمودار فقط مشارکت‌کنندگانی که متعهد به شاخۀ پیش‌فرض مرکز ذخیره‌سازی شده‌اند را مشخص می‌کند.

![Contributor graph](/assets/images/metrics/repo_contributors_specific_graph.png)

* **مشارکت‌کنندگان تازه‌کار، عادی، همیشگی:**  کمک می‌کند تا پیگیری کنید که آیا مشارکت‌کنندگان جدیدی دریافت می‌کنید یا خیر. (مشارکت‌کنندگان عادی، مشارکت‌کنندگانی با تعهدات کم هستند که البته تعریف «تعهدات کم» به خود شما بستگی دارد و می‌تواند یک یا پنج یا کمتر باشد) بدون مشارکت‌کنندگان جدید، انجمن پروژه راکد و کم‌رونق می‌شود.

* **تعداد مسائل در جریان و درخواست‌های باز pull:** اگر بیش از حد زیاد شوند، ممکن است در اولویت‌بندی مسائل و بررسی کدها به کمک نیاز داشته باشید.

* **تعداد مسائل باز شده (open issued)  و درخواست های باز شدۀ pull:** مسائل باز شده، یعنی کسی به اندازه کافی به پروژۀ شما اهمیت بدهد تا مسئله‌ای را باز کند. اگر این تعداد با گذشت زمان افزایش یابد، نشان‌دهندۀ این است که مردم به پروژۀ شما علاقه‌مند هستند.

* **انواع مشارکت‌ها:** به عنوان مثال، نوع تعهدها، رفع اشتباهات یا اشکالات یا اظهار نظر در مورد یک موضوع.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
  پروژه‌های متن باز، چیزی فراتر از کد هستند. پروژه‌های متن باز موفق شامل مشارکت در کد و مستند سازی به همراه مکالماتی در مورد این تغییرات هستند.
  <p markdown="1" class="pquote-credit">
— @arfon, ["The Shape of Open Source"](https://github.com/blog/2195-the-shape-of-open-source)
  </p>
</aside>

## فعالیت‌های شخص نگهدارنده

نگهدارنده‌هایی که پاسخگو نیستند به نقطۀ ضعف پروژه‌های متن باز تبدیل می‌شوند. اگر کسی مشارکتی از خود به جای بگذارد اما هرگز از یک نگهدارنده پاسخی دریافت نکند، ممکن است احساس دلسردی کرده و آنجا را ترک کند.

[تحقیقات که در Mozilla شکل گرفت](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) نشان می‌دهد که پاسخگو بودن نگهدارنده عاملی حیاتی در تشویق به مشارکت‌های بیشتر است.

در نظر بگیرید که چه مدت طول می‌کشد تا شما (یا نگهدارنده‌ای دیگر) به مشارکت‌ها پاسخ دهید، خواه مسئله‌ای باشد یا درخواست pull. پاسخگو بودن نیاز به اقدام خاصی ندارد. می‌تواند به این سادگی باشد: _«ممنون از درخواست شما! در عرض یک هفته آن را بررسی می‌کنم.»_

همچنین می‌توانید مدت زمانی که برای تکمیل مراحل مختلف فرآیند مشارکت لازم است را اندازه بگیرید، همچون:

* متوسط زمان باز ماندن مسئله
* بسته شدن مسئله توسط روابط عمومی (PR)
* بسته شدن مسائل قدیمی
* متوسط زمان ادغام کردن درخواست‌های pull

## از آمار 📊 برای درک مردم استفاده کنید

درک معیارها (استانداردها) به شما کمک می‌کند تا پروژۀ متن باز فعال و رو به‌ رشدی داشته باشید. حتی اگر هم تمامی معیارها را پیگیری نمی‌کنید، از چارچوب بالا استفاده کنید تا توجه خود را به نوع رفتاری که به پیشرفت پروژه کمک می‌کند متمرکز کنید.
