---
lang: fa
title: جنبه‌های حقوقی پروژه‌های متن باز
description: تمامی چیزهایی که در مورد جنبه‌های حقوقی متن باز برای شما سوال شده و چیزهایی که سوال نشده.
class: legal
order: 10
image: /assets/images/cards/legal.png
related:
  - contribute
  - leadership
---

## درک پیامدهای حقوقی پروژه‌های منبع آزاد

اشتراک گذاشتن کارهای خلاقانه با جهانیان می‌تواند تجربه‌ای هیجان‌انگیز و ارزشمند باشد. همچنین می‌تواند به معنای درگیر شدن با یک سری موارد حقوقی باشد که در رابطه با آن‌ها چیزی نمی‌دانید. خوشبختانه، نیازی نیست از ابتدا شروع کنید. ما نیازهای حقوقی شما را برآورده کرده و پوشش داده‌ایم. (قبل از شروع، حتماً متن [سلب مسئولیت](/notices/) ما را بخوانید.)

## چرا مردم اینقدر به جنبه‌های حقوقی متن آزاد اهمیت می‌دهند؟

به طور کلی، به این معنی است که هیچ کس دیگری نمی‌تواند از اثر شما استفاده کند، کپی کند، پخش کند یا اصلاحاتی روی آن انجام دهد؛ بدون اینکه در معرض ریسک دعوی قضایی و پیگیری قرار بگیرد.

هرچند پروژه‌های متن باز شرایطی غیرمعمول دارند، زیرا خالق اثر انتظار دارد که دیگران از اثر استفاده کنند و آن را اصلاح نمایند و به اشتراک بگذارند. اما از آنجا که پیش‌فرض قانونی همچنان شامل حق نشر می‌شود، شما به مجوزی نیاز دارید که صریحاً این دسترسی‌ها را میسر سازد.

اگر مجوز (لایسنس) مربوط به پروژه‌های متن باز را اعمال نکنید، همه کسانی که در پروژۀ شما مشارکت می‌کنند نیز به عنوان دارندۀ حق نشر برای کارهای منحصر به فرد خود شناخته می‌شوند. این بدان معناست که هیچ کس نمی‌تواند از مشارکت‌های خود استفاده یا کپی کند و آن را توزیع یا اصلاح نماید و این «هیچ کس» شامل شما هم می‌شود.

در آخر اینکه ممکن است پروژۀ شما وابستگی‌هایی با ملزومات مجوز داشته باشد که از آن‌ها اطلاع نداشته باشید. انجمن (community) پروژه یا سیاست‌های کارفرمایی شما نیز ممکن است پروژه را ملزم به استفاده از مجوز‌های متن باز خاصی بکند. در زیر دربارۀ آن توضیح می‌دهیم.

## آیا پروژه‌های عمومی «GitHub» متن باز محسوب می‌شوند؟

هنگام ایجاد [پروژه‌ای جدید](https://help.github.com/articles/creating-a-new-repository/) در «GitHub»، این انتخاب را دارید که منبع را **خصوصی** یا **عمومی** مشخص کنید

![Create repository](/assets/images/legal/repo-create-name.png)

**عمومی کردن پروژه‌تان در «GitHub» به منزلۀ مجوزدار کردن پروژه نیست.** پروژه‌های عمومی‌ای که [تحت شرایط خدمات «GitHub»](https://docs.github.com/en/site-policy/github-terms/github-terms-of-service#3-ownership-of-content-right-to-post-and-license-grants) قرار می‌گیرند این امکان را برای افراد میسر می‌سازد که پروژه شما را مشاهده کنند و آن را فورک (fork) کنند، اما در غیر این افراد همچین اجازه‌ای ندارند.

اگر می‌خواهید دیگران از پروژۀ شما استفاده کنند، آن را توزیع دهند یا اصلاح نمایند و در آن مشارکت کنند، باید پروانۀ مخصوص پروژه‌های متن باز داشته باشید. به عنوان مثال، کسی قانونا نمی‌تواند از هر بخشی از پروژۀ «GitHub» شما در کد خود استفاده کند، حتی اگر عمومی باشد؛ مگر اینکه صریحاً به او اجازۀ چنین کاری را بدهید.

## به من توضیحات تکمیلی را در مورد چگونگی مراقبت از پروژه بدهید

امروزه کار خیلی ساده‌تر شده است زیرا مجوز‌های پروژه‌های متن باز استاندارد شده و استفاده از آن‌ها آسان است. می‌توانید مجوزهای (پروانه‌های) موجود را مستقیماً در پروژۀ خود کپی کنید.

[MIT](https://choosealicense.com/licenses/mit/) ، [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) و [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) معروف‌ترین مجوزهای متن باز هستند، اما گزینه‌های دیگری نیز برای انتخاب وجود دارد. می‌توانید متن کامل این مجوزها و دستورالعمل‌های مربوط به نحوۀ استفاده از آن‌ها را در سایت [choosealicense.com](https://choosealicense.com/) پیدا کنید.

وقتی پروژۀ جدیدی را در «GitHub» ایجاد می‌کنید، [از شما خواسته می‌شود مجوزی را انتخاب کرده و به پروژه اضافه کنید](https://help.github.com/articles/open-source-licensing/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/benbalter?s=180" class="pquote-avatar" alt="avatar">
  یک مجوز استاندارد به عنوان جایگزینی برای کسانی که اطلاعات کافی از مسائل حقوقی ندارند و نمی‌دانند چه کارهایی می‌توانند با این نرم‌افزار انجام دهند، عمل می‌کند. تا جایی که می‌توانید از شرایط و ضوابط دستکاری شده، اصلاح شده یا غیراستاندارد اجتناب کنید، چونکه آن‌ها در آینده به صورت مانعی در استفاده و دریافت کدها عمل می‌کنند.
  <p markdown="1" class="pquote-credit">
— @benbalter, ["Everything a government attorney needs to know about open source software&nbsp;licensing"](https://ben.balter.com/2014/10/08/open-source-licensing-for-government-attorneys/)
  </p>
</aside>

## چه مجوز متن بازی برای پروژۀ من مناسب است؟

اگر تازه‌کار هستید، [مجوز MIT](https://choosealicense.com/licenses/mit/) به درد شما می‌خورد. کوتاه است، درک آن بسیار آسان می‌باشد و به هر کسی اجازه می‌دهد هر کاری انجام دهد تا زمانی که کپی مجوز، از جمله اخطار حق نشر شما را نگه دارند. در صورت نیاز، می‌توانید پروژه را تحت هر مجوز دیگری انتشار دهید.

در غیر این صورت، انتخاب مجوز متن باز مناسب برای پروژۀ شما به اهداف‌تان بستگی دارد.

پروژۀ شما به احتمال زیاد **وابستگی‌ها** و مولفه‌های فراوانی داشته باشد (یا خواهد داشت). به عنوان مثال، اگر در پروژۀ متن باز خود از «Node.js» استفاده می‌کنید، احتمالاً از کتابخانه‌های Node Package Manager (npm) (مدیریت پکیج Node) استفاده خواهید کرد. هر کدام از این کتابخانه‌هایی که به آن‌ها وابسته هستید، مجوز (لایسنس، پروانه) متن باز مخصوص به خود را دارند. اگر هر یک از مجوزهای آن‌ها «اختیاری» باشد (بدون هیچ گونه شرطی برای فعالیت‌های آینده، اجازۀ استفاده، اصلاح، تغییر و اشتراک‌گذاری را به عموم مردم می‌دهد)، می‌توانید از هر مجوزی که می‌خواهید استفاده کنید. مجوزهای اختیاری متداول شامل «MIT»، «Apache 2.0»، «ISC» و «BSD» می‌شوند.

از طرف دیگر، اگر هر یک از مجوزهای وابستگی شما، «کپی‌لفت قوی» باشند (مشروط به استفاده از همان مجوز در آینده، مجوزهای عمومی مشابهی را می‌دهد)، در این صورت پروژۀ شما باید از همان مجوز استفاده کند. مجوزهای متداول کپی‌لفت قوی شامل  «GPLv2»، «GPLv3»  و «AGPLv3» می‌شوند. (تعریف Copyleft : کپی‌لفت نوعی بازی با کلمهٔ کپی‌رایت است. کپی‌لفت عملی را توصیف می‌کند که در آن تضمین می‌شود که اجازهٔ نسخه‌برداری و ویرایش یک اثر برای همگان محفوظ می‌مانَد و هیچ شخصی اجازه ندارد حق ویرایش و نسخه‌برداری را از دیگر افراد سلب کند.)

همچنین ممکن است بخواهید **انجمن‌هایی** را در نظر بگیرید که امیدوار هستید از پروژۀ شما استفاده کنند و در آن مشارکت کنند:

* **آیا می‌خواهید پروژۀ شما به عنوان وابستگی توسط سایر پروژه‌ها مورد استفاده قرار گیرد؟** بهتر است محبوب‌ترین نوع مجوز را در انجمن‌تان استفاده کنید. به عنوان مثال، [MIT](https://choosealicense.com/licenses/mit/) محبوب‌ترین مجوز برای [کتابخانه‌های npm](https://libraries.io/search?platforms=NPM) است.

* **آیا می‌خواهید پروژۀ شما مورد توجه کسب و کارهای بزرگ قرار بگیرد؟** کسب‌وکارهای بزرگ احتمالاً سریعا مجوز ثبت اختراع را از تمامی مشارکت‌کنندگان می‌خواهند. در این صورت، [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) به درد شما و آن‌ها می‌خورد.

* **آیا می‌خواهید پروژه شما مورد توجه مشارکت‌کنندگانی قرار بگیرد که نمی‌خواهند مشارکت‌های آن‌ها در نرم‌افزارهای متن بسته مورد استفاده قرار بگیرد؟** [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) یا (همچنین اگر آن‌ها تمایلی به مشارکت در خدمات متن بسته ندارند) [AGPLv3](https://choosealicense.com/licenses/agpl-3.0/) به درد خواهد خورد.

ممکن است **شرکت** شما در پروژه‌های متن باز، شرایط خاصی برای مجوزها داشته باشد. به عنوان مثال، ممکن است به مجوز اختیاری نیاز داشته باشد تا شرکت بتواند از پروژۀ شما در محصول متن بستۀ خود استفاده کند. یا ممکن است شرکت شما به یک مجوز کپی‌لفت قوی و یک توافق‌نامۀ همکاری اضافی نیاز داشته باشد (به زیر مراجعه کنید) تا فقط منحصرا شرکت شما بتواند از پروژه در نرم‌افزارهای متن بسته استفاده کند. یا ممکن است شرکت شما نیازها و شرایط خاصی در رابطه با استانداردها، مسئولیت‌های اجتماعی یا شفافیت داشته باشد، که هر یک از آن‌ها ممکن است به یک استراتژی خاص دیگری در ارتباط با مجوز نیاز داشته باشد. با [بخش حقوقی شرکت](#تیم-حقوقی-شرکت-من-چه-چیزهایی-را-باید-بداند) خود در رابطه با این موارد صحبت کنید.

هنگام ایجاد پروژه جدید در «GitHub»، به شما امکان انتخاب نوع مجوز داده می‌شود. انتخاب یکی از مجوزهایی که در بالا ذکر شد، پروژۀ «GitHub» شما را متن باز می‌کند. اگر مایل به دیدن گزینه‌های دیگه‌ای هستید، [choosealicense.com](https://choosealicense.com) را بررسی کنید تا مجوز مناسب‌تان را پیدا کنید حتی اگر برای [نرم‌افزار](https://choosealicense.com/non-software/) نباشد.

## اگر بخواهم مجوز پروژۀ خود را تغییر دهم چه کاری باید بکنم؟

اکثر پروژه‌ها به تغییر دادن مجوز خود، نیازی پیدا نمی‌کنند. ولی گاهی اوقات شرایط فرق می‌کند.

به عنوان مثال، با رشد پروژۀ شما، وابستگی‌ها یا کاربران آن اضافه می‌شود یا شرکت شما استراتژی‌های خود را تغییر می‌دهد که هرکدام از آن‌ها نیاز به مجوز دیگری دارند. همچنین، اگر از ابتدا مجوزی برای پروژۀ خود انتخاب نکردید، افزودن مجوز در واقع تفاوتی با تغییر مجوز ندارد. هنگام افزودن یا تغییر مجوز پروژه، سه نکتۀ اساسی باید در نظر گرفته شود:

**کاری پیچیده است.** تعیین سازگاری و انطباق مجوز و حق نشر می تواند خیلی زود پیچیده و گیج‌کننده شود. تغییر مجوز به مجوزی جدید و سازگار برای نسخه‌های جدید و مشارکت‌ها با تغییر مجوز تمامی مشارکت‌های موجود، تفاوت‌هایی دارد. در اولین قدم، در صورت تمایل به تغییر مجوزها، تیم حقوقی شما درگیر می‌شود. حتی اگر برای تغییر مجوز از دارندگان حق نشر پروژه خود اجازه دارید یا می‌توانید از آن‌ها اجازه بگیرید، تأثیر این تغییر را بر سایر کاربران و مشارکت‌کنندگان پروژۀ خود در نظر داشته باشید. تغییر مجوز را به صورت یک «رویداد مدیریتی» برای پروژۀ خود تصور کنید که به احتمال زیاد با برقراری ارتباط صریح و مشورت با ذی‌نفعان پروژه، هموارتر پیش خواهد رفت. بنابراین بهتر است از بدو تأسیس، مجوزی مناسب را برای پروژۀ خودتان انتخاب کنید!

**مجوز موجود و فعلی پروژه‌تان.** در صورتی که مجوز کنونی پروژۀ شما با مجوزی که می‌خواهید به آن تغییر دهید سازگار باشد، می‌توانید از مجوز جدید استفاده کنید. به این دلیل که اگر مجوز A با مجوز B سازگار باشد، در حالی که با شرایط B مطابقت دارید، با شرایط A نیز منطبق خواهید بود (اما لزوما برعکس آن درست نیست). بنابراین اگر در حال حاضر از مجوزی اختیاری استفاده می‌کنید (به عنوان مثال، «MIT»)، می‌توانید به مجوزی با شرایط بیشتری تغییر مجوز دهید، به شرطی که نسخه‌ای از مجوز «MIT» و هرگونه شرط حق نشر دیگری مربوط به آن را حفظ کنید (یعنی همچنان با حداقل شرایط مجوز «MIT» سازگار باشید). اما اگر مجوز فعلی شما اختیاری نباشد (به عنوان مثال کپی‌لفت باشد یا مجوزی نداشته باشید) و تنها دارندۀ حق نشر نیستید، نمی‌توانید مجوز پروژۀ خود را به «MIT» تغییر دهید. اساساً، صاحبان حق نشر پروژه با داشتن مجوز اختیاری از قبل اجازۀ تغییر مجوزها را داده‌اند.

**صاحبان کنونی حق‌نشر پروژه‌تان.** اگر تنها مشارکت‌کننده در پروژه‌تان هستید، شما یا شرکت شما تنها صاحبان حق‌نشر این پروژه خواهید بود. خودتان یا شرکت می‌توانید، مجوز را تغییر دهید یا مجوز جدیدی اضافه کنید. در غیر این صورت ممکن است باید قبل از تغییر مجوز، با دیگر صاحبان حق‌نشر به توافق برسید. آن‌ها چه کسانی هستند؟ افرادی که متعهد به پروژه هستند، نقطۀ خوبی برای شروع است. اما در برخی موارد حق‌نشر توسط افراد بالادستی این افراد حفظ می‌شود. در برخی موارد افراد مشارکت کم و حداقلی داشته‌اند، اما هیچ قانون سخت و جدی وجود ندارد که بگوید افرادی که مشارکتی در برخی از خطوط کد داشته‌اند مشمول حق‌نشر نباشد. چه کار باید کرد؟ بستگی دارد. برای پروژه‌ای نسبتاً کوچک و تازه‌شکل گرفته، ممکن است امکان‌پذیر باشد که همۀ مشارکت‌کنندگان موجود با تغییر مجوز در طرح مسئله‌ای یا در درخواست pullی موافقت کنند. برای پروژه‌های بزرگ و قدیمی، ممکن است برای مثلا تغییر مجوز مجبور شوید به جستجوی بسیاری از مشارکت‌کنندگان و حتی ورثه‌های آن‌ها مشغول شوید. موزیلا سال‌ها به طول انجامید (2001 تا 2006) تا مجوز «Firefox»، «Thunderbird» و دیگر نرم‌افزارهای مربوطه را تغییر دهد.

همچنین می‌توانید موافقت مشارکت‌کنندگان را از قبل جلب کنید (از طریق توافق‌نامه‌های مشارکتی اضافی - به زیر مراجعه کنید) تا بتوانید کارتان را در مورد برخی از تغییرات مجوز تحت شرایط خاصی را فراتر از شرایط مجاز مجوز متن باز موجود پیش ببرید. این موضوع پیچیدگی تغییر مجوزها را کمی تغییر می‌دهد. برای اینکار به کمک وکلای خود بیشتر احتیاج خواهید داشت و هنوز هم باید در هنگام اجرای تغییر مجوز، به طور واضح با ذی‌نفعان پروژۀ خود صحبت کنید.

## آیا پروژۀ من به توافق‌نامه‌های همکاری (مشارکتی) اضافی نیاز دارد؟

به احتمال زیاد نه. برای اکثریت قریب به اتفاق پروژه‌های متن باز، یک مجوز متن آزاد به طور ضمنی به عنوان مجوز درونی (برای مشارکت‌کنندگان) و مجوز خارجی (برای سایر مشارکت‌کنندگان و کاربران) عمل می‌کند. اگر پروژۀ شما در «GitHub» میزبانی می‌شود، شرایط خدمات‌دهی «GitHub»، «مجوزهای درونی و مجوزهای خروجی را [صریحا پیش‌فرض](https://help.github.com/en/github/site-policy/github-terms-of-service#6-contributions-under-repository-license) درنظر می‌گیرد.

توافق‌نامه‌های همکاری اضافی - که اغلب به آن توافق‌نامه مجوز مشارکت‌کننده (CLA) گفته می‌شود - برای نگهدارندگان پروژه می‌تواند کارهای مدیریتی ایجاد کند. اینکه توافق‌نامه چه مقدار کار اضافه می‌کند به پروژه و نحوۀ اجرای آن بستگی دارد. یک توافق‌نامه‌ی ساده ممکن است نیاز داشته باشد که مشارکت‌کنندگان با یک کلیک تأیید کنند که از حقوق لازم برای مشارکت در مجوز پروژه متن باز برخوردار هستند. یک توافق‌نامه‌ی پیچیده‌تر ممکن است نیاز به بررسی قانونی داشته باشد و مربوط به کارفرمایان مشارکت‌کنندگان شود.

همچنین، با افزودن «تشریفات اداری» که به عقیدۀ برخی غیرضروری می‌باشد و فهم آن سخت یا ناعادلانه است (وقتی که ذی‌نفعان توافق‌نامه حقوق و مزایای بیشتری از مشارکت‌کنندگان یا عموم مردمی که کارهایی در پروژه‌ی متن باز انجام می‌دهند، به دست می‌آورند)؛ به همین خاطر ممکن است یک توافق‌نامه‌ی همکاری اضافی غیرمنصفانه نسبت به انجمن پروژه تلقی شود.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/bcantrill?s=180" class="pquote-avatar" alt="avatar">
    ما «توافق‌نامه مجوز مشارکت‌کننده» را برای «Node.js» حذف کردیم. انجام این کار موانع ورود مشارکت‌کنندگان به Node.js را کاهش می‌دهد و در نتیجه میزان مشارکت‌کنندگان را گسترش می‌دهد.
  <p markdown="1" class="pquote-credit">
— @bcantrill, ["Broadening Node.js Contributions"](https://www.tritondatacenter.com/blog/broadening-node-js-contributions)
  </p>
</aside>

برخی از شرایطی که ممکن است بخواهید یک توافق‌نامه‌ی همکاری اضافی را برای پروژۀ خود در نظر بگیرید، شامل این موارد می‌شود:

* شما یا وکیل‌هایتان از توسعه‌دهندگان بخواهید نشان دهند هر تعهدی که روی آن کار می‌کنند مجاز است. الزام [گواهی مبدا توسعه‌دهنده](https://developercertificate.org/) برای این است که چه تعداد پروژه به این صورت هستند. به عنوان مثال، انجمن «Node.js» به جای «توافق‌نامۀ مجوز مشارکت‌کننده» قبلی خود از «گواهی مبدا توسعه‌دهنده» استفاده می کند. راهکار ساده برای اجرای خودکار «گواهی مبدا توسعه‌دهنده» در منبع (repository) شما، «ربات گواهی مبدا توسعه‌دهنده» است.

* اگر پروژه شما از یک مجوز متن باز استفاده بکند که شامل امتیاز ثبت اختراع (مانند MIT) نباشد و شما به داشتن سریع امتیاز ثبت اختراع  مشارکت‌کنندگان نیاز داشته باشید؛ برخی از آن‌ها ممکن است در شرکت‌هایی با مجموعه‌های بزرگ حق ثبت اختراع کار کنند که می‌تواند شما یا سایر مشارکت‌کنندگان و کاربران پروژه را مورد هدف قرار دهد. [توافق‌نامۀ مجوز مشارکت‌کنندگان حقیقی Apache](https://www.apache.org/licenses/icla.pdf)، یک توافق‌نامۀ همکاری اضافی است که معمولاً مورد استفاده قرار می‌گیرد و شامل امتیاز ثبت اختراع است که همانند آنچه در مجوز «Apache 2.0» یافت می‌شود، است.

* پروژۀ شما تحت مجوز کپی‌لفت باشد ، اما شما همچنین باید نسخه‌ای اختصاصی از پروژه را توزیع و پخش کنید. هر مشارکت‌کننده باید به شما حق نشر اختصاص دهد یا به شما (اما نه به عموم) مجوز اختیاری بدهد. [توافق‌نامۀ همکاری MongoDB](https://www.mongodb.com/legal/contributor-agreement) نمونه‌ای از این نوع توافق‌نامه است.

* ممکن باشد پروژۀ شما در طول عمر خود مجوزهایش را تغییر بدهد و بخواهید مشارکت‌کنندگان از قبل با چنین تغییراتی موافقت کنند.

اگر در پروژۀ خود نیازی به استفاده از توافق‌نامه‌های همکاری اضافی داشته باشید، استفاده از توافق‌نامه‌های یکپارچه‌سازی مانند [توافق‌نامۀ مجوز مشارکت‌کننده](https://github.com/cla-assistant/cla-assistant) را برای به حداقل رساندن حواس‌پرتی مشارکت‌کنندگان در نظر بگیرید.

## تیم حقوقی شرکت من چه چیزهایی را باید بداند؟

اگر به عنوان کارمند شرکت، پروژه‌ای متن باز را منتشر می‌کنید، ابتدا تیم حقوقی باید بداند که شما در حال تهیۀ پروژه‌ای متن باز هستید.

حتما این موضوع را به آن‌ها بگویید حتی اگر این پروژه‌ای شخصی باشد. شما احتمالاً با شرکت خود «توافق‌نامۀ کارمندی» دارید که به آن‌ها تا حدودی کنترلی بر روی پروژه های شما می‌دهد، به خصوص اگر مربوط به شرکت باشند یا از منابع شرکت برای توسعۀ پروژه استفاده کرده باشید. شرکت شما _باید_ به شما اجازه دهد و ممکن است از قبل از طریق توافق‌نامه‌ی کارمندی یا سایر سیاست‌های شرکت مجوز داشته باشد. در غیر این صورت، می‌توانید مذاکره کنید (به عنوان مثال، توضیح دهید که پروژۀ شما اهداف یادگیری و توسعۀ حرفه‌ای شرکت را دنبال می‌کند)، یا تا زمانی که شرکت بهتری پیدا نکردید از کار بر روی پروژۀ خودتان خودداری کنید..

**اگر در جستجوی پروژه‌ای برای شرکت هستید،** قطعاً آن‌ها را در جریان بگذارید. تیم حقوقی شما احتمالاً قبلاً سیاست‌هایی را برای استفاده از مجوزهای متن باز (و شاید توافق‌نامه‌های همکاری اضافی) برای استفاده بر اساس الزامات تجاری و تخصصی شرکت در مورد اطمینان از مطابقت پروژۀ شما با مجوزهای وابستگی شرکت، در نظر گرفته است. اگر نه، به نفع هم شما و هم شرکت است! تیم حقوقی شما باید مشتاق همکاری با شما برای مشخص کردن این موارد باشد. چند مسئلۀ مهم:

* **نهادهای واسط**  آیا پروژه شما وابستگی‌هایی به کار دیگران دارد یا در غیر این صورت کد دیگران را شامل می شود یا از آن‌ها استفاده می‌کند؟ اگر پروژه متن باز باشد، باید پروژۀ شما با مجوزهای متن باز مطابقت داشته باشد. این کار با انتخاب مجوز شروع می‌شود که مربوط به مجوزهای متن باز واسط می‌شود (نگاه کنید به بالا). اگر پروژۀ شما پروژه‌های متن باز واسط دیگر را اصلاح یا توزیع می‌کند، تیم حقوقی شما همچنین می‌خواهد بداند که شما سایر شرایط‌های مجوزهای متن باز واسط مانند حفظ اخطارهای حق نشر را رعایت می‌کنید یا خیر. اگر پروژۀ شما از کدهای دیگران استفاده می‌کند که فاقد مجوز متن باز هستند، احتمالاً باید از نگهدارندگان واسط بخواهید که [مجوز متن باز را اضافه کنند](https://choosealicense.com/no-license/#for-users) و اگر نمی‌توانید مجوز را دریافت کنید، استفاده از کد دیگران را در پروژۀ خودتان متوقف کنید.

* **اسرار کاری:** به این توجه داشته باشید که آیا چیزی در پروژه وجود دارد که شرکت نخواهد آن را در دسترس عموم قرار دهد. در این صورت، پس از مشخص کردن مطالبی که می‌خواهید خصوصی نگه دارید، می‌توانید بقیۀ پروژۀ خود را با متن باز کنید.

* **حق ثبت اختراع:** آیا شرکت شما متقاضی ثبت اختراعی است که متن باز آن پروژه در [دسترس عموم](https://en.wikipedia.org/wiki/Public_disclosure) است؟ متأسفانه، ممکن است از شما خواسته شود صبر کنید (یا شاید این شرکت در دیدگاه خود تجدید نظر کند). اگر انتظار دارید که کارمندان شرکت‌های بزرگی که دارای حق ثبت اختراع هستند، به پروژۀ شما کمک کنند و در آن مشارکت داشته باشند، ممکن است تیم حقوقی از شما بخواهد از یک مجوز با امتیاز ثبت اختراع سریع (از جمله Apache 2.0 یا GPLv3) یا توافق‌نامۀ همکاری اضافی استفاده کنید ( به بالا نگاه کنید).

* **نشان تجاری:** بررسی کنید تا نام پروژۀ شما با [هیچ نشان تجاری موجودی مغایرت نداشته باشد](../starting-a-project/#از-نامگذاریهای-دارای-منافات-خودداری-کنید). اگر از نشان‌های تجاری شرکت خود در پروژه استفاده می‌کنید، بررسی کنید تا هیچ مشکلی ایجاد نکند. [FOSSmarks](http://fossmarks.org/) یک راهنمای جامع برای شناخت نشان‌های تجاری در زمینه‌ی پروژه‌های متن باز و رایگان است.

* **حریم خصوصی:** آیا پروژۀ شما اطلاعات مربوط به کاربران را جمع‌آوری می‌کند؟ سرورهای شرکت، مکالمات را ضبط می‌کند؟ تیم حقوقی می‌تواند به شما در زمینه‌ی پیروی از سیاست‌های شرکت و آیین‌نامه‌های خارجی کمک کند.

اگر دارید اولین پروژه متن باز شرکت خود را منتشر می‌کنید، رعایت موارد فوق کافی است (اما نگران نباشید، اکثر پروژه‌ها نگرانی‌های اساسی خاصی نباید ایجاد کنند).

در بلند مدت، تیم حقوقی می‌تواند کمک بیشتری به شرکت کند تا از مشارکت خود در پروژه‌های متن باز بهره‌ی بیشتری ببرد و در امان بماند:

* **سیاست های مربوط به مشارکت کارمندان:** سیاست‌هایی را تدوین کنید که مشخص سازد کارمندان شما در پروژه‌های متن باز چه نوع مشارکتی داشته باشند. داشتن سیاست‌های مشخص و واضح باعث کاهش سردرگمی در بین کارمندان و کمک به آن‌ها در مشارکت هرچه بهتر در پروژه‌های متن باز شرکت می‌شود؛ چه به عنوان بخشی از شغل آنها و چه به صورت فعالیت در اوقات فراغت‌شان. یک مثال خوب، [مدل‌های استاندارد و سیاست‌های همکاری در پروژه‌های متن باز](https://processmechanics.com/2015/07/23/a-model-ip-and-open-source-contribution-policy/) «Rackspace» است.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/vanl?s=180" class="pquote-avatar" alt="avatar">
  منتشر کردن شناسه همراه با مشخصات سازندۀ پَچ، باعث ایجاد اعتبار و شناخته شدن کارمند می‌شود. این کار نشان می‌دهد که شرکت در توسعۀ کارمندان سرمایه‌گذاری کرده و باعث به وجود آمدن حس اختیار و استقلال کارمندان می‌شود. تمامی این منفعت‌ها، منجر به روحیۀ بالاتر و حفظ بهتر کارمندان می‌شود.
  <p markdown="1" class="pquote-credit">
— @vanl, ["A Model IP and Open Source Contribution Policy"](https://processmechanics.com/2015/07/23/a-model-ip-and-open-source-contribution-policy/)
  </p>
</aside>

* **چه چیزهایی را منتشر کنیم:** [(تقریبا) همه چیز؟](http://tom.preston-werner.com/2011/11/22/open-source-everything.html) اگر تیم حقوقی شما استراتژی متن باز شرکت شما را درک کرده و در آن سرمایه‌گذاری کرده باشد، به جای جلوگیری از تلاش‌هایتان، به بهترین وجه به شما کمک می‌کند.

* **سازگاری:** حتی اگر شرکت شما هیچ پروژۀ متن بازی را منتشر نکند، از دیگر نرم‌افزارهای متن باز استفاده می‌کند. [داشتن آگاهی از روند کار](https://www.linuxfoundation.org/blog/blog/why-companies-that-use-open-source-need-a-compliance-program/) می‌تواند از بروز مشکلات بی‌جا، تأخیر در محصول و شکایات جلوگیری کند.

<aside markdown="1" class="pquote">
 شرکت‌ها باید دارای مجوزها و استراتژی‌های انطباقی باشند که متناسب با هر دو دستۀ [«اختیاری» و «کپی‌لفت»] باشد. این کار با ثبت سوابق مجوزهایی که برای نرم‌افزارهای متن باز مورد استفاده شما اعمال می‌شود - از جمله مؤلفه‌های فرعی و وابستگی‌ها - آغاز می‌شود.
  <p markdown="1" class="pquote-credit">
— Heather Meeker, ["Open Source Software: Compliance Basics And Best Practices"](https://techcrunch.com/2012/12/14/open-source-software-compliance-basics-and-best-practices/)
  </p>
</aside>

* **امتیاز ثبت اختراع:** ممکن است شرکت شما مایل باشد به شبکۀ [Open Invention Network](https://www.openinventionnetwork.com/)، که یک مجموعۀ ثبت اختراع مشترک برای محافظت از اعضا و استفادۀ آن‌ها از پروژه‌های بزرگ متن باز یا جستجوی سایر [مجوزهای اختراع ثبت جایگزین](https://www.eff.org/document/hacking-patent-system-2016) است، بپیوندد.

* **نظارت:** مخصوصاً زمانی منطقی است که پروژه‌ای را به یک [شخص حقوقی خارج از شرکت](../leadership-and-governance/#آیا-برای-حمایت-و-پشتیبانی-از-پروژهی-خود-به-نهاد-قانونی-نیاز-خواهم-داشت) منتقل کنید.
