---
lang: fa
title: مدیریت و نظارت
description: وجود نقش‌های رسمی جهت تصمیم‌گیری، منافع زیادی برای پروژه‌های متن باز در حال رشد به همراه دارد.
class: leadership
order: 6
image: /assets/images/cards/leadership.png
related:
  - best-practices
  - metrics
---

## نظارت درست بر روی پروژه‌ی در حال رشد

پروژه‌ی شما رشد می‌کند، مردم درگیر پروژه‌ی شما می‌شوند، و شما به ادامه دادن این کار متعهد می‌شوید. در این مرحله، ممکن است از خود بپرسید که چگونه می‌توانید مشارکت‌کنندگان پروژه‌ی خود را منسجم و یکپارچه کنید، خواه دادن دسترسی کامیت باشد یا حل و فصل کردن بحث‌ها و گفتگوهای درون اجتماع. اگر سوالاتی دارید، جواب‌ها پیش ماست.

## مثال‌هایی از نقش‌های رسمی مورد استفاده در پروژه های متن باز، چه هستند؟

بسیاری از پروژه‌ها، ساختار مشابهی را در حوزه‌ی نقش‌های مشارکتی و شناختی دنبال می‌کنند.

مضمون و معنای این نقش‌ها، در واقع کاملا به شما بستگی دارد. در اینجا، چند نوع نقشی که ممکن است آن‌ها را تشخیص دهید، نام بردیم:

* **نگهدارنده (Maintainer)**
* **مشارکت‌کننده (Contributor)**
* **کامیت کننده (Committer)**

**در برخی از پروژه‌ها، نگهدارندگان** تنها افرادی در پروژه هستند که دسترسی کامیت دارند. در برخی دیگر از پروژه‌ها، فقط افرادی دسترسی دارند که در <span dir="rtl">«README»</span> به عنوان نگهدارنده ذکر شده‌اند.

نگهدارنده لزوماً کسی نیست که برای پروژه‌ی شما کد می‌نویسد. بلکه می‌تواند کسی باشد که در تبلیغ پروژه‌ی شما کارهای زیادی انجام داده باشد یا مستنداتی را نوشته باشد که پروژه را برای دیگران قابل دسترسی‌تر کرده است. صرف نظر از کاری که آن‌ها در طی روز انجام می‌دهند، نگهدارنده کسی است که نسبت به مسیر و اجرای پروژه احساس مسئولیت می‌کند و متعهد به بهبود بخشیدن آن است.

**مشارکت‌کننده می‌تواند هر کسی باشد**: کسی که مسئله یا درخواست <span dir="rtl">«Pull»</span>ی را مطرح می‌کند، یا افرادی باشند که به پروژه ارزش می‌بخشند (خواه این که مسائل مربوط به اولویت‌بندی درخواست‌ها، نوشتن کد یا سازماندهی رویدادها باشد) یا هر کسی باشد که درخواست <span dir="rtl">«Pull»</span>ی را ادغام <span dir="rtl">(merge)</span> بکند (جزئی‌ترین تعریف از مشارکت‌کننده)

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  \[در پروژه‌ی <span dir="rtl">Node.js</span>\]، هر شخصی که درباره یک موضوع اظهارنظر یا کدی را ارسال کند، عضوی از پروژه است. تنها دیدن نظرات یا ارسال کد به منزله‌ی عبور آن‌ها از فقط کاربر بودن به مشارکت‌کننده بودن است.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Healthy Open Source"](https://medium.com/the-javascript-collection/healthy-open-source-967fa8be7951)
  </p>
</aside>

**اصطلاح «کامیت کننده»،** ممکن است برای وجه تمایز دسترسی کامیت، که نوع خاصی از مسئولیت در مقابل سایر اشکال مشارکت است، استفاده شود.

در حالی که می‌توانید نقش‌ها را در پروژه‌ی خود به هر روشی که دوست دارید تعریف کنید، استفاده از تعاریف گسترده‌تر را برای تقویت اشکال بیشتری از مشارکت، [مد نظر خود قرار دهید](../how-to-contribute/#مشارکت-به-چه-معناست). شما می‌توانید از نقش‌های مدیریتی برای شناسایی رسمی افرادی که مشارکت برجسته‌ای به پروژه‌ی شما کرده‌اند، صرف نظر از مهارت‌های فنی آن‌ها استفاده کنید

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jacobian?s=180" class="pquote-avatar" alt="avatar">
  ممکن است من را به عنوان سازنده‌ی <span dir="rtl">«Django»</span> بشناسید... اما در واقع من کسی هستم که یک سال بعد از ساخت <span dir="rtl">«Django»</span>، برای کار در بخشی از آن استخدام شدم. (...)مردم فکر می‌کنند به دلیل مهارت برنامه‌نویسی است که موفق شدم... اما در بهترین حالت می‌توان گفت که من یک برنامه‌نویس متوسط هستم.
  <p markdown="1" class="pquote-credit">
— @jacobian, ["PyCon 2015 Keynote" (video)](https://www.youtube.com/watch?v=hIJdFxYlEKE#t=5m0s)
  </p>
</aside>

## چگونه به این نقش‌های مدیریتی، رسمیت ببخشیم؟

رسمیت بخشیدن به نقش‌های مدیریتی، باعث می‌شود افراد احساس مالکیت کنند و به اعضای سایر اجتماع‌ها بگویند برای کمک به چه کسانی روی آورند.

در پروژه‌های کوچک‌تر، تعیین کردن مدیران می‌تواند به سادگی افزودن نام آن‌ها به فایل‌های <span dir="rtl">«README»</span> یا به یک فایل متنی <span dir="rtl">«CONTRIBUTORS»</span> باشد.

برای پروژه‌های بزرگ‌تر، اگر وب‌سایتی دارید، یک صفحه‌ی تیمی ایجاد کنید یا اسامی مدیران پروژه را در آنجا لیست کنید. به عنوان مثال، [Postgres](https://github.com/postgres/postgres/) یک [صفحه‌ی تیمی جامع](https://www.postgresql.org/community/contributors/) و فراگیر با مشخصاتی کوتاه برای هر مشارکت‌کننده دارد.

اگر پروژه‌ی شما دارای جامعه‌ی مشارکت‌کننده‌ی بسیار فعالی است، شما می‌توانید یک «تیم اصلی» از نگهدارنده‌ها، یا حتی کمیته‌های فرعی از افرادی که مالکیت حوزه‌های  موضوعات مختلف را دارند (به عنوان مثال، امنیت، اولویت‌بندی درخواست‌ها یا هدایت اجتماع) تشکیل دهید. به جای اینکه به هر کسی، وظایف خاصی را محول کنید، بگذارید افراد خودشان، برای نقش‌هایی که بیشتر از همه هیجان زده‌اند سازمان یابند و داوطلب شوند.

<aside markdown="1" class="pquote">
  \[ما\] تیم اصلی را با چندین «زیرگروه (گروه‌های فرعی)» تکمیل می‌کنیم. هر زیرگروه، بر روی حوزه‌ای خاص متمرکز می‌شود، به عنوان مثال، طراحی زبان یا کتابخانه‌ها. (…)به منظور اطمینان از هماهنگی کلی و داشتن چشم‌اندازی قوی و منسجم برای کل پروژه، هر زیرگروه توسط یکی از اعضای تیم اصلی هدایت می‌شود
  <p markdown="1" class="pquote-credit">
— ["Rust Governance RFC"](https://github.com/rust-lang/rfcs/blob/HEAD/text/1068-rust-governance.md)
  </p>
</aside>

تیم‌های مدیریت، ممکن است بخواهند کانالی مشخص (مانند <span dir="rtl">IRC</span>) ایجاد کنند یا به طور منظم برای بحث درمورد پروژه با هم ملاقات کنند (مانند <span dir="rtl">Gitter</span> یا <span dir="rtl">Google Hangout</span>). حتی می‌توانید آن جلسات را علنی برگزار کنید تا سایر افراد بتوانند گوش دهند. به عنوان مثال، [Cucumber-ruby](https://github.com/cucumber/cucumber-ruby) همچین کاری می‌کند

پس از اینکه نقش‌های مدیریتی را ایجاد کردید، ثبت چگونگی نحوه‌ی دسترسی افراد به آن‌ها را فراموش نکنید! فرآیند روشن و واضحی را برای چگونگی کسی که می‌خواهد نگهدارنده شود یا به کمیته‌ای فرعی در پروژه شما بپیوندد، ایجاد کنید و آن را در <span dir="rtl">«GOVERNANCE.md»</span> خود بنویسید.

ابزارهایی مانند [Vossibility](https://github.com/icecrime/vossibility-stack)، می‌تواند به شما کمک کند تا به طور عمومی افرادی که در پروژه مشارکت می‌کنند (یا نمی‌کنند) را ردیابی کنید. ثبت این اطلاعات، جلوی این ذهنیت اجتماع که نگهدارندگان گروهی هستند که تصمیمات خود را به صورت خصوصی اتخاذ می‌کنند، می‌گیرد

در آخر اینکه اگر پروژه‌ی شما در <span dir="rtl">«GitHub»</span> است، انتقال پروژه‌ی خود را از حساب شخصی خود به یک تشکل و اضافه کردن حداقل یک مدیر پشتیبان را مد نظر خود قرار دهید. [تشکل‌های «GitHub»](https://help.github.com/articles/creating-a-new-organization-account/)، مدیریت دسترسی‌ها و مراکز ذخیره‌سازی متعدد را آسان‌تر می‌کنند و پیشینه‌ی پروژه‌ی شما را از طریق [مالکیت مشترک](../building-community/#مالکیت-پروژه-تان-را-به-اشتراک-بگذارید) محافظت می‌کنند.

## چه موقع باید به کسی اجازه‌ی دسترسی کامیت بدهیم؟

برخی از افراد فکر می‌کنند که شما باید به هر کسی که در پروژه مشارکت می‌کند، دسترسی کامیت بدهید. با انجام این کار، افراد بیشتری ترغیب به داشتن احساس مالکیت نسبت به پروژه‌ی شما، می‌شوند.

از طرف دیگر، به خصوص برای پروژه‌های بزرگتر و پیچیده‌تر، ممکن است بخواهید فقط به افرادی که تعهد خود را نشان داده و به اثبات رسانده‌اند، دسترسی کامیت بدهید. هیچ راه درستی برای انجام این کار وجود ندارد - هر جور که راحت‌تر هستید، عمل کنید!

اگر پروژه‌ی شما در <span dir="rtl">«GitHub»</span> است، می توانید از شاخه‌های محافظت شده [protected branches](https://help.github.com/articles/about-protected-branches/) برای مدیریت افرادی که می‌توانند تحت شرایط خاصی در شاخه‌ای خاص عمل کنند، استفاده کنید

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/felixge?s=180" class="pquote-avatar" alt="avatar">
  هر زمان کسی درخواست <span dir="rtl">«Pull»</span>ی را برای شما ارسال کرد، به او اجازه‌ی دسترسی کامیت به پروژه را بدهید. اگرچه ممکن است در ابتدا بسیار احمقانه به نظر برسد، اما استفاده از این استراتژی به شما این امکان را می‌دهد تا قدرت واقعی <span dir="rtl">«GitHub»</span> را تجربه کنید. (...)به محض دسترسی کامیت افراد، آن‌ها دیگر نگران این نیستند که <span dir="rtl">«patch»</span>هاشان ادغام نشود و باعث زحمت و کار زیادی برای آن‌ها شود.
  <p markdown="1" class="pquote-credit">
— @felixge, ["The Pull Request Hack"](https://felixge.de/2013/03/11/the-pull-request-hack.html)
  </p>
</aside>

## برخی از ساختارهای نظارتی متداول برای پروژه‌های متن باز چیست؟

سه ساختار نظارتی متداول در ارتباط با پروژه‌های متن باز وجود دارد.

* **BDFL** مخفف <span dir="rtl"> "Benevolent Dictator for Life" </span> یا «دیکتاتور خیرخواه جاویدان» است تحت این ساختار،  یک نفر (معمولاً نویسنده‌ی اولیه‌ی پروژه) در مورد تمام تصمیمات مهم پروژه، حرف آخر را می‌زند. [Python](https://github.com/python)، نمونه‌ای موثق در این مورد است. پروژه‌های کوچک‌تر احتمالاً به طور پیش‌فرض به صورت <span dir="rtl">BDFL</span> هستند، زیرا فقط یک یا دو نگهدارنده وجود دارد. پروژه‌هایی که از یک شرکت منشأ گرفته شده باشند نیز ممکن است در طبقه‌بندی <span dir="rtl">BDFL</span> قرار گیرند

* **Meritocracy:** (شایسته سالاری) (توجه داشته باشید که اصطلاح شایسته سالاری برای برخی اجتماع‌ها، مفهومی منفی دارد و ساختار آن [دارای پیشینه‌ی پیچیده‌ی اجتماعی و سیاسی](http://geekfeminism.wikia.com/wiki/Meritocracy).)است.) تحت ساختار «شایسته سالاری»، به مشارکت‌کنندگان فعال پروژه (کسانی که از خود «شایستگی» نشان می‌دهند) نقش تصمیم‌گیرندگی رسمی داده می‌شود. تصمیم‌‌ها، معمولاً براساس اجماع رای گرفته می‌شوند. مفهوم شایسته سالاری، نخستین بار توسط بنیاد <span dir="rtl">«Apache»</span>، به وجود آمد. تمامی پروژه‌های <span dir="rtl">«Apache»</span> بر اساس شایسته سالاری هستند. مشارکت‌ها فقط توسط افراد حقیقی صورت می‌گیرد؛ نه توسط یک شرکت.

* **Liberal contribution:** (مشارکت آزادنه) تحت مدل مشارکت آزادانه، افرادی که بیشترین کار را انجام می‌دهند به عنوان تأثیرگذارترین افراد شناخته می‌شوند، اما این مدل براساس کاری که اکنون انجام می‌دهند است و نه مشارکت‌های که در گذشته داشته‌اند. تصمیمات بزرگ‌ پروژه بر اساس فرآیندی در اجتماع به صورت اجماعی (بحث‌ در مورد مسائل اساسی) به جای رأی‌گیری تنها گرفته می‌شود، و تلاش می‌شود تا آنجا که ممکن است دیدگاه‌های بیشتری از اجتماع را شامل شود. از جمله پروژه‌هایی که از مدل مشارکت آزادانه استفاده کردند، می‌توان [Node.js](https://foundation.nodejs.org/) و [Rust](https://www.rust-lang.org/) را نام برد.

از کدام مدل بهتر است استفاده کنید؟ به خودتان بستگی دارد! هر مدل، شامل نکات منفی و مثبتی می‌شود. اگرچه ممکن است این مدل‌ها در ابتدا کاملاً متفاوت به نظر برسند؛ اما هر سه مدل، بیشتری از آنچه که به نظر می رسد اشتراکاتی دارند:

* [BDFL model template](http://oss-watch.ac.uk/resources/benevolentdictatorgovernancemodel)
* [Meritocracy model template](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel)
* [Node.js's liberal contribution policy](https://medium.com/the-node-js-collection/healthy-open-source-967fa8be7951)

## آیا هنگام راه‌اندازی پروژه‌ی خود به اسناد نظارتی نیاز دارم؟

زمان مناسب و دقیقی برای نوشتن اسناد نظارتی پروژه وجود ندارد، اما هنگامی که شرایط اجتماع خود را دیدید و با جو آن آشنا گشتید، به ثبت رساندن اسناد بسیار ساده‌تر می‌شود. بهترین (و سخت‌ترین) بخش در مورد نظارت پروژه‌های متن باز این است که توسط خود اجتماع شکل می‌گیرد!

هر چند برخی اسناد اولیه‌ی نظارتی به طور اجتناب ناپذیری در پروژه‌ی شما خواهد بود، ولی شروع به نوشتن آنچه می‌توانید بکنید. به عنوان مثال، شما می‌توانید حتی در زمان راه‌اندازی پروژه‌ی خود، انتظارات واضح و شفاف خودتان از رفتار یا فرآیند‌ مشارکت کاری را تعریف کنید.

اگر شما عضوی از شرکتی هستید که پروژه‌ای متن باز راه‌اندازی می‌کند، بد نیست قبل از راه‌اندازی، بحثی درون‌سازمانی درباره نحوه‌ی نگهداری شرکت و تصمیم‌گیری در مورد پیشرفت پروژه داشته باشید. همچنین بهتر است در مورد مسیری که شرکت شما در رابطه با پروژه پیش خواهد گرفت، به صورت علنی صحبت دهید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/caabernathy?s=180" class="pquote-avatar" alt="avatar">
 ما تیم‌های کوچکی را برای مدیریت پروژه‌ها در <span dir="rtl">«GitHub»</span> اختصاص می‌دهیم که در واقع در فیس‌بوک نیز بر روی آن‌ها کار می‌کنند. برای مثال، پروژه‌ی <span dir="rtl">«React»</span> توسط <span dir="rtl">«React engineer»</span>، اداره می‌شود.
  <p markdown="1" class="pquote-credit">
— @caabernathy, ["An inside look at open source at Facebook"](https://opensource.com/life/15/10/ato-interview-christine-abernathy-facebook)
  </p>
</aside>

## اگر کارمندان شاغل در شرکت شروع به ارائه‌ی خدمات کنند، چه می‌شود؟

پروژه‌های متن باز موفق، توسط بسیاری از افراد و شرکت‌ها مورد استفاده قرار می‌گیرند و در نهایت ممکن است برخی از شرکت‌ها شروع به کسب درآمد از آن پروژه‌ها بکنند. به عنوان مثال، شرکتی ممکن است از کدهای پروژه به عنوان یک بخش سازنده‌ی محصولات خدمات تجاری استفاده کند.

هنگامی که استفاده از پروژه بیشتر شود، افراد زیادی خواستار کسانی که در آن پروژه تخصص دارند می‌شوند؛ ممکن است شما یکی از آن‌ها باشید! و گاهی اوقات نیز به خاطر کاری که در پروژه‌ می‌کنید، حقوق دریافت کنید.

بسیار مهم است که رفتاری عادی در قبال فعالیت‌های تجاری داشت؛ درست رفتاری مانند فعالیت‌های توسعه‌ای در پروژه‌های دیگر. البته نباید برخورد خاص و رفتار ویژه‌ای با توسعه‌دهندگانی که به آن‌ها پول داده می‌شود در برابر آن‌هایی که بدون دریافت پول به کارشان مشغول هستند، قائل شد. هر یک از مشارکت‌ها باید بر اساس شایستگی‌های فنی ارزیابی شود. با این حال، افرادی که مشغول به فعالیت‌های تجاری هستند، باید احساس راحتی داشته باشند و هنگام بحث و گفتگو در مورد پیشرفت یا ویژگی خاصی، در بیان موارد کاربردی و کارهایی که قبلا داشتند، باید احساس راحتی کنند.

پروژه‌های «تجاری» هیچ فرقی با پروژه‌های «متن باز» ندارند. «تجاری» فقط به این معنی است که پول هم در کار است؛ به این معنی که نرم افزاری که در تجارت مورد استفاده قرار می‌گیرد، نرم‌افزاری در پروژه بوده است که در فعالیت تجاری پذیرفته شده است. (هنگامی که از یک نرم‌افزار «متن باز» به عنوان بخشی سازنده از محصولی «غیر متن باز» استفاده می‌شود، محصول نهایی همچنان نرم‌افزاری «دارای حقوق انحصاری» است، هرچند مانند «متن باز» ممکن است برای اهداف تجاری یا غیر تجاری استفاده شود.)

مانند هر کس دیگری، توسعه‌دهندگانی که انگیزه‌های تجاری دارند از طریق کیفیت و کمیت مشارکت‌های خودشان است که در پروژه اهمیت می‌یابند و تاثیرگذار می‌شوند. بدیهی است که توسعه‌دهنده‌ای که برای کاری که می‌کند حقوق می‌گیرد، احتمالا بیشتر از شخصی که حقوق نمی‌گیرد، توانایی کار کردن دارد ولی اهمیتی ندارد، پرداخت حقوق فقط یکی از بسیار عامل‌های احتمالی است که می‌تواند بر میزان کاری که شخص می‌کند، تأثیر بگذارد. مشارکت‌ها رو معطوف به بحث‌های مربوط به پروژه بکنید، و نه معطوف به موضوعاتی خارج از پروژه.

## آیا برای حمایت و پشتیبانی از پروژه‌ی خود به نهاد قانونی نیاز خواهم داشت؟

شما برای پشتیبانی از پروژه‌ی متن باز خود احتیاج به نهاد قانونی نخواهید داشت، مگر اینکه با پول سر و کار داشته باشید.

به عنوان مثال، اگر می‌خواهید کسب و کاری ایجاد کنید، باید از طریق <span dir="rtl">«C Corp»</span> یا <span dir="rtl">«LLC»</span> (اگر در ایالات متحده مستقر هستید) اقدام کنید. اگر فقط کارهای پیمانکاری مربوط به پروژه متن باز خود را انجام می‌دهید، می‌توانید به عنوان یک مالک شخصی پول را بپذیرید یا یک <span dir="rtl">«LLC»</span> (اگر در ایالات متحده مستقر هستید) ایجاد کنید.

اگر می‌خواهید کمک‌های مالی برای پروژه‌ی متن باز خود بپذیرید، می‌توانید بستری را برای کمک‌های مالی (مثلاً با استفاده از <span dir="rtl">PayPal</span> یا <span dir="rtl">Stripe</span>) ایجاد کنید، اما این مبلغ مشمول کسر مالیات می‌شود، مگر اینکه به عنوان یک سازمان غیرانتفاعی واجد شرایط باشید (اگر در ایالات متحده مستقر هستید).

بسیاری از پروژه‌ها مایل به پذیرفتن مشکلات ناشی از ایجاد سازمانی غیرانتفاعی نیستند، بنابراین در عوض یک حامی مالی غیرانتفاعی پیدا می‌کنند. یک حامی مالی، معمولاً در ازای درصدی از کمک مالی، کمک‌های مالی را از طرف شما قبول می‌کند. [Software Freedom Conservancy](https://sfconservancy.org/)،[Apache Foundation](https://www.apache.org/) ،[Eclipse Foundation](https://eclipse.org/org/foundation/) ، [Linux Foundation](https://www.linuxfoundation.org/projects) و [Open Collective](https://opencollective.com/opensource)، نمونه‌هایی از سازمان‌ها هستند که به عنوان حامی‌های مالی در پروژه‌های متن باز فعالیت می‌کنند

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/piamancini?s=180" class="pquote-avatar" alt="avatar">
  هدف ما فراهم آوردن زیرساختی است که اجتماع‌هامان <span dir="rtl">(communities)</span> بتوانند از آن برای پایداری خود استفاده کنند، بنابراین محیطی ایجاد می‌کنیم که همه - مشارکت‌کنندگان، پشتیبانان، حامیان مالی - از مزایای آن بهره‌مند شوند
  <p markdown="1" class="pquote-credit">
— @piamancini, ["Moving beyond the charity framework"](https://medium.com/open-collective/moving-beyond-the-charity-framework-b1191c33141)
  </p>
</aside>

اگر پروژه‌ی شما رابطه‌ی نزدیکی با زبان یا اکوسیستم خاصی داشته باشد، ممکن است پیش‌زمینه‌ی نرم‌افزاری مرتبط با آن وجود داشته باشد که بتوانید با آن کار کنید. به عنوان مثال، [Python Software Foundation](https://www.python.org/psf/) از [PyPI](https://pypi.org/) پشتیبانی می‌کند، [Python package manager](https://www.python.org/psf/) و [Node.js Foundation](https://foundation.nodejs.org/) به [Express.js](https://expressjs.com/)، که مبتنی بر Node است، کمک می‌کند.
