---
lang: fa
title: چگونه در یک پروژه‌ی متن باز مشارکت کنیم
description: می‌خواهید در یک پروژه‌ی متن باز مشارکت کنید؟ در ادامه‌ی مقاله نحوه‌ی مشارکت در یک پروژه‌ی متن باز برای افراد مبتدی و باتجربه شرح داده شده است.
class: contribute
order: 1
image: /assets/images/cards/contribute.png
related:
  - beginners
  - building
---

## چرایی مشارکت در یک پروژه‌ی متن باز؟

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/errietta?s=180" class="pquote-avatar" alt="avatar">
  کار کردن در <span dir="rtl">Freenode</span> به من در یادگیری بسیاری از مهارت‌ها کمک کرد و توانستم از آن‌ها در تحقیقات دانشگاهی و شغلم استفاده کنم. فکر می‌کنم به همان اندازه که کار کردن روی پروژه‌های متن باز به پیشبرد پروژه کمک می‌کند به همان اندازه به من هم کمک می‌کند!
  <p markdown="1" class="pquote-credit">
— @errietta, ["Why I love contributing to open source software"](https://www.errietta.me/blog/open-source/)
  </p>
</aside>

زمانی که در پروژه‌های متن باز مشارکت می‌کنید، چیزهای زیادی یاد می‌گیرید یا یاد می‌دهید، حتی می‌توانید در هر مهارتی که تصورش را می‌کنید تجربه کسب کنید.

چرا افراد در پروژه‌های متن باز مشارکت می‌کنند؟ خب، دلایل زیادی وجود دارد!

### نرم‌افزاری که به آن متکی هستید را بهبود می‌دهید

مشارکت‌کننده‌ها مشارکت خود از پروژه‌هایی شروع می‌کنند که کاربر آن می‌شوند. زمانی که در نرم‌افزار یک پروژه‌ی متن باز باگ یا خطایی مشاهده کردید، در صورتی که توانایی برطرف کردن آن را داشته باشید می‌توانید به سورس کد آن نگاهی بیندازید و خودتان اصلاحیه‌ای برایش بنویسید. اگر با چنین موردی روبه‌رو شدید، مشارکت در اصلاح آن باگ بهترین راه برای مطمئن کردن دوستان (و خودتان مخصوصاً زمانی که نسخه‌ی بعدی آن به روز شود) باشد که می‌تواند مزیت‌های داشته باشد.

### مهارت‌های موجودتان تقویت می‌شود

اگر به دنبال تمرین کدنویسی، طراحی رابط‌کاربری کاربر، طراحی گرافیک، نویسندگی یا سازماندهی کردن هستید، پروژه‌ی متن باز این تمرین‌ها را در اختیارتان قرار می‌دهد.

### با افرادی ملاقات می‌کنید که علایق‌شان با شما مشابه است

پروژه‌های متن باز با انجمن‌های گرم و گیرایش باعث می‌شود افرادی که در آن حضور دارند برای سال‌ها به آن مراجعه کنند. حتی بسیاری هستند که به واسطه‌ی همکاری‌شان در راه‌اندازی کنفرانس‌ها یا چت‌های آنلاین شبانه‌شان درباره‌ی <span dir="rtl">burritos</span> ، روابط دوستانه‌ی طولانی مدتی دارند.

### استاد پیدا می‌کنید و به دیگران آموزش می‌دهید

کار کردن با دیگران در پروژه‌های مشترک شما را مجبور می‌کند نحوه‌ی انجام دادن کارها را توضیح دهید و به همان اندازه هم از دیگران کمک بخواهید. هر کسی می‌تواند خود را درگیرِ فعالیت‌های یادگیری و آموزشی کند.

### محصولی عمومی تولید کنید که به رشد اعتبار و حرفه‌ی کاری‌تان کمک کند

بر اساس تعریف، تمام پروژه‌های متن باز شما عمومی هستند. به این معنا که نمونه پروژه‌ها را دریافت می‌کنید و می‌توانید آن را همه جا ببرید و نشان دهید که چه کارهایی می‌توانید با آن انجام دهید.

### مهارت‌های دیگران را یاد می‌گیرید

پروژه‌های متن باز فرصتی فراهم می‌کنند که به واسطه‌ی آن می‌توانید مهارت‌های مدیریت و رهبری پروژه‌ی خود مانند برطرف کردن تضادها، سازماندهی کردن تیم و اولویت بندی کارها، را تقویت کنید.

### به شما قدرت اعمال تغییرات هرچند کوچک را می‌دهد

لازم نیست برای لذت بردن از همکاری در یک پروژه‌ی متن باز، به یک مشارکت‌کننده‌ی درازمدت تبدیل شوید. تا حالا شده در یک وب‌سایت چند غلط‌ املائی ببینید و دوست داشتید یک نفر آن را اصلاح کند؟ خب، اگر چنین حالتی برای پروژه‌تان به وجود بیاید، به راحتی می‌توانید آن را برطرف کنید. پروژه‌ی متن باز می‌تواند به افراد کمک کند تا شرکتی که در آن فعالیت می‌کنند و نحوه‌ی کسب کردن تجربه‌شان را از زندگی خود مهم‌تر بدانند و همین مسئله حس رضایت‌بخشی به آن‌ها می‌دهد.

## مشارکت به چه معناست؟

اگر در مشارکت یک پروژه‌ی متن باز تازه‌وارد هستید، فرآیند آن می‌تواند ترسناک باشد. شما چگونه یک پروژه درست برای مشارکت کردن در آن را انتخاب می‌کنید؟ اگر چیزی از کد نویسی ندانید، چی؟ اگر چیزی درست پیش نرود، چی؟

خب، نگران نباشید! راه‌های زیادی برای مشارکت در پروژه‌های متن باز وجود دارد که در ادامه‌ی مقاله مواردی از آن‌ها را می‌آوریم که می‌تواند به بدست آوردن تجربه‌های بیشتر به شما کمک کند.

### الزماً قرار نیست در فرایند کدنویسی مشارکت کنید

یک دید غلط و مرسومی که برای مشارکت در پروژه‌های متن باز وجود دارد این است که فکر می‌کنند برای مشارکت در آن باید حتما کدنویسی شود. در حقیقت، [اغلب بخش‌های دیگر پروژه](https://github.com/blog/2195-the-shape-of-open-source) است که از آن غفلت یا بیش از حد به آن توجه می‌شود. شما با برطرف کردن مشکلات و مشارکت در آن بخش‌ها لطف بزرگی به پروژه‌های متن باز می‌کنید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/orta?s=180" class="pquote-avatar" alt="avatar">
  من شهرتم را از کار در <span dir="rtl">CocoaPods</span> به دست آوردم، اما بیشتر مردم نمی‌دانند که من واقعاً هیچ کار واقعی با ابزار <span dir="rtl">CocoaPods</span> انجام نمی‌دادم. زمانم در آن پروژه بیشتر روی چیزهایی مانند اسناد یا کار روی برندسازی صرف می‌شد.
  <p markdown="1" class="pquote-credit">
— @orta, ["Moving to OSS by default"](https://academy.realm.io/posts/orta-therox-moving-to-oss-by-default/)
  </p>
</aside>

حتی اگر هم به کدنویسی در پروژه علاقه‌مند باشید، روش‌های دیگر مشارکت بهترین راه‌برای درگیر شدن در یک پروژه و ملاقات با اعضای انجمن‌های دیگر وجود دارد. ساختن این روابط به شما فرصت‌هایی می‌دهد تا در بخش‌های دیگر پروژه مشارکت کنید.

### آیا به برگزاری رویدادها علاقه‌مند هستید؟

* ورکشاپ‌ها (کارگاه‌ها) را سازماندهی یا جلسات پروژه را برگزار کنید، مانند کاری که @fzamperin برای  [NodeSchool](https://github.com/nodeschool/organizers/issues/406) انجام داد
* در صورت امکان، برای یک پروژه کنفرانس برگزار کنید
* به اعضای انجمن کمک کنید تا کنفرانس‌های درستی پیدا و برای کنفرانس پرپوزال خود را ارسال کنند.

### آیا به طراحی علاقه‌مند هستید؟

* با هدف افزایش قابلیت استفاده به بهبود ساختار برنامه ها کمک کنید.
* مشابه [دروپال](https://www.drupal.org/community-initiatives/drupal-core/usability) می‌توانید با هدف بهبود رابط کاربری اقدام به کاربرپژوهی و مطالعاتی از این دست کنید.
* با جمع آوری و یک کاسه کردن الگوهای طراحی به کار گرفته شده در پروژه یک شیوه‌نامه (استایل گاید) متمرکز ایجاد کنید.
* اقدام به خلق کارهای هنری مثل طراحی لوگو یا تی شرت مخصوص کنید. مثل کاری که [hapi.js](https://github.com/hapijs/contrib/issues/68) انجام داد.

### آیا به نویسندگی در پروژه علاقه‌مند هستید؟

* اسناد پروژه را بنویسید و اصلاح کنید
* پوشه‌ی نمونه‌ها را تنظیم کنید تا نحوه‌ی استفاده‌ی پروژه را نشان دهد
* برای پروژه یک خبرنامه راه‌اندازی کنید، یا شاخصه‌های آن را نوشته و تنظیم کنید
* برای پروژه، مطالب آموزشی بنویسید، مانند مشارکت‌کننده‌هایی که برای [PyPA](https://packaging.python.org/) مطالب آموزشی نوشتند
* مستندات پروژه را به زبانی دیگر ترجمه کنید

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kittens?s=180" class="pquote-avatar" alt="avatar">
  اسناد یک پروژه به طور جدی مهم هستند. اسناد پروژه تا به الان عالی پیش رفتند و یکی از ویژگی‌های بی‌نظیر<span dir="rtl">Babel</span> نیز بوده است. بخش‌هایی در اسناد یک پروژه وجود دارد که مطمئناً می‌تواند از آن در برخی کارها استفاده کرد، حتی افزودن یک پاراگراف در این‌جا یا آن‌جا بی‌نهایت قایل تقدیر است.
  <p markdown="1" class="pquote-credit">
— @kittens, ["Call for contributors"](https://github.com/babel/babel/issues/1347)
  </p>
</aside>

### آیا به سازماندهی پروژه علاقه‌مند هستید؟

* برای سازماندهی کردن همه چیز، مشکلات تکراری را لینک کنید و مسائل جدیدی مطرح کنید
* با مسئله‌های (issue) باز رودرو شوید و پیشنهاد دهید مسائل قدیمی حل شوند، مانند کاری که <span dir="rtl">@nzakas</span> برای [ESLin](https://github.com/eslint/eslint/issues/6765) انجام داد
* برای پیشبرد بحث، سوالات شفافی درباره‌ی مسائل باز اخیر بپرسید

### آیا به کدنویسی علاقه دارید؟

* مسائل باز و حل نشده را پیدا و حل کنید، مانند کاری که <span dir="rtl">@dianjin</span> برای [Leaflet](https://github.com/Leaflet/Leaflet/issues/4528#issuecomment-216520560) انجام داد
* اگر می‌توانید برای اعمال یک ویژگی جدید به پروژه کمک کنید، درخواست‌تان را مطرح کنید
* نصب پروژه را خودکار کنید
* ابزارهای مرتبط و تسهیل کننده و تست پروژه را تقویت کنید

### آیا از کمک کردن به مردم لذت می‌برید؟

* به سوالاتی که افراد درباره‌ی پروژه در سایت‌هایی مانند <span dir="rtl">Stack، Postgres، یا Reddit</span> می‌پرسند، جواب بدهید
* سوالات افرادی که مسائل حل نشده‌ای دارند را جواب بدهید
* در اداره کانال‌های گفتگو و تالارهای گفتمان مشارکت کنید

### آیا دوست دارید در کدنویسی به دیگران کمک کنید؟

* کدنویسی سایر افراد را بررسی کنید
* برای نحوه‌ی استفاده‌ی یک پروژه‌ی متن باز، مطلب آموزشی بنویسید
* یک مشارکت کننده دیگر که می‌شناسید را پیشنهاد دهید، [مثل کاری که @ereichert در Rust برای @bronzdoc کرد](https://github.com/rust-lang/book/issues/123#issuecomment-238049666).

### لازم نیست فقط روی پروژه‌های نرم‌افزاری وقت صرف کنید!

با اینکه بیشتر پروژه‌های متن باز به نرم‌افزارها اطلاق می‌شود، اما می‌توانید هرچیزی از جمله کتاب‌ها، دستورالعمل، لیست چیزهای مختلف و کلاس‌ها را در پروژه‌های متن باز توسعه دهید.

به عنوان مثال:

* @sindresorhus [لیست‌هایی موسوم به <span dir="rtl">«awesome»</span>](https://github.com/sindresorhus/awesome) گردآوری و تنظیم می‌کند
* @h5bp [یک لیست حاوی سوالاتی جهت مصاحبه برای توسعه دهندگان فرانت اند](https://github.com/h5bp/Front-end-Developer-Interview-Questions) را نگهداری و مرتب می‌کند
* @stuartivnn و @nicole-a-tesla [مجموعه‌ای از حقایق جالب درباره‌ی طوطی دریایی](https://github.com/stuartlynn/puffin_facts) ایجاد کرده‌اند.

حتی اگر توسعه‌دهنده‌ی نرم‌افزار هم باشید، کار روی اسناد یک پروژه می‌توانید به شما کمک کند تا پروژه‌ی متن بازتان را شروع کنید. کار روی پروژه‌هایی که کدنویسی کمتری دارد اغلب ترس کمتری دارد و فرآیند همکاری در آن باعث می‌شود اعتمادبه‌نفس و تجربه‌ی شما افزایش پیدا کند.

## ورود و وفق دادن خودمان به یک پروژه جدید

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shaunagm?s=180" class="pquote-avatar" alt="avatar">
  اگر به یک ایشو ترکر <span dir="rtl">(issue tracker)</span> برخوردید و چیزهای گیج‌کننده‌ای دیدید، نگران نباشید چون شما تنها نیستید. این ابزارها به دانش ضمنی زیادی نیاز دارند، اما سایرین می‌توانند به شما کمک کند و می‌توانید از آن‌ها سوالاتی بپرسید.
  <p markdown="1" class="pquote-credit">
— @shaunagm, ["How to Contribute to Open Source"](https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/)
  </p>
</aside>

مشارکت کردن در یک پروژه‌ی متن باز که بیشتر از اصلاح غلط‌هایی املائی است، مانند وارد شدن به پارتی غریبه‌هاست. اگر در این پارتی درباره ماهی قرمز بحث عمیقی شکل گرفته، شما درباره‌ی لاماها صحبت کنید، احتمالاً نگاه عجیبی به شما می‌شود.

بنابراین، قبل از اینکه کورکورانه با پیشنهادهای‌تان وارد کاری شوید، یاد بگیرید که چگونه در چت روم‌ها گفتگو کنید. این کار شانس شما را برای شنیده شدن و توجه به ایده‌هایتان را بالا می‌برد.

### آناتومی یک پروژه‌ی متن باز

جامعه‌ها در پروژه‌های متن باز متفاوت هستند.

زمانی که سال‌ها روی یک پروژه‌ی متن باز صرف می‌کنید، باید آن پروژه‌ی متن باز را بشناسید. از طرفی، زمانی هم که به پروژه‌ی متفاوتی منتقل می‌شوید، لغات، قوائد و سبک ارتباطاتی آن که ممکن است کاملاً متفاوت باشد را باید پیدا کنید.

گفته می‌شود بیشتر پروژه‌های متن باز از یک ساختار سازماندهی مشابه پیروی می‌کنند. شناخت و درک نقش‌ها در جوامع مختلف و فرآیند کلی آن به شما کمک می‌کند به سرعت وارد هر پروژه‌ی جدیدی شوید.

افراد مختلفی در یک پروژه‌ی متن باز معمولی مشارکت می‌کنند:

* **نویسنده:** شخص یا سازمانی که یک پروژه را خلق می‌کند
* **صاحب مالک:** شخص یا اشخاصی که صاحب اداری آن سازمان یا مخزن هستند (البته صاحب پروژه همیشه با نویسنده‌ی اصلی یکسان نیست)
* **مسئول‌نگهداری پروژه:** مشارکت‌کننده‌هایی که مسئول پیش بردن چشم انداز و مدیریت جنبه‌های سازمانی یک پروژه باشند (این افراد همچنین می‌توانند نویسنده یا صاحب پروژه باشند)
* **مشارکت‌کننده:** هر کسی که در پروژه مشارکت داشته باشد
* **اعضای انجمن:** افرادی که از پروژه استفاده می‌کنند، می‌توانند مکالمات فعالانه‌ای داشته باشند یا نظرات‌شان را برای مسیر دادن به پروژه ابراز کنند

پروژه‌های بزرگ‌تر همچنین ممکن است زیرکمیته‌ها یا گروه‌های کاری داشته باشند که روی وظایف متفاوتی مانند مجهز کردن، <span dir="rtl">triage</span> (تریاژ)، معتدل کردن انجمن و سازماندهی رویداد متمرکز می‌شوند. زمانی که به صفحه‌ی «تیم» پروژه‌ی یک وب‌سایت، یا مخزن مراجعه کنید، می‌توانید اطلاعات این زیرکمیته‌ها و نقش افراد کلیدی را مشاهده کنید.

پروژه‌های متن باز اسناد مختلفی دارند که این فایل‌ها معمولا در بالای لیست مخزن قرار می‌گیرند.

* **لایسنس/ گواهینامه (LICENSE):** طبق تعریف، هر پروژه‌ی متن بازی باید لایسنس مخصوص به خود را داشته باشد. اگر یک پروژه لایسنس نداشته باشد، اصلاً متن باز محسوب نمی‌شود
* **فایل README:** فایل <span dir="rtl">README</span> یک دستورالعمل ساختاری برای تمام اعضای جدید انجمن است که می‌توانند آن را مطالعه می‌کنند. در این فایل به خوبی آورده شده که پروژه‌ی در دست چه فوایدی دارد و چگونه باید از آن استفاده کرد
* **فایل CONTRIBUTING:** زمانی که یک فایل <span dir="rtl">README</span> می‌تواند به مردم برای استفاده از پروژه کمک کنند، فایل <span dir="rtl">CONTRIBUTING</span> هم می‌تواند برای مشارکت افراد در پروژه به شما و به آن‌ها کمک کند. در این فایل توضیح داده شده که به چه نوع مشارکتی نیاز است و فرآیند کاری پروژه به چه نحوه است. با اینکه هر پروژه فایل <span dir="rtl">CONTRIBUTING</span> ندارد، اما در صورت وجود چنین فایلی در پروژه می‌تواند به افراد مختلف سیگنال مشارکت در پروژه بدهد.
* **CODE_OF_CONDUCT:** در فایل <span dir="rtl">code of conduct</span> می‌توانید قوائدی که شرکت‌کنندگان باید با در نظر گرفتن آن به صورت دوستانه و راحت و در یک محیط پذیرا با سایرین برخورد کنند را بنویسید. با اینکه هر پروژه ممکن است حاوی این فایل نباشد، اما زمانی که یک پروژه‌ی متن باز این فایل را داشته باشد، به مشارکت‌کننده‌ها این سیگنال را می‌فرستد می‌توانند در پروژه مشارکت داشته باشند. این فایل تقریباً حاوی توصیه‌هایی رفتاری برای تعامل است.
* **اسناد دیگر:** یک پروژه‌ی متن باز به خصوص پروژه‌های بزرگ‌تر ممکن است حاوی اسناد دیگری مانند فایل‌های آموزشی، بازنگری فنی، راهنمای گام به گام <span dir="rtl">(walkthroughs)</span> ، یا سیاست‌های دولتی باشند.

در نهایت، پروژه‌های متن باز برای سازماندهی بحث‌ها از ابزارهای زیر  استفاده می‌کنند. مطالعه‌ی آرشیو پروژه‌ها می‌تواند دید خوبی از نحوه‌ی فکر و کار انجمن‌ها بدهد.

* **ایشو ترکر (Issue tracker):** جایی که افراد درباره‌ی مشکلات مرتبط با پروژه بحث می‌کنند
* **درخواست Pull (Pull requests):** جایی که افراد درباره‌ی تغییرات جاری بحث و بازبینی می‌کنند.
* **انجمن گفتگو یا خبرنامه های ایمیلی:** برخی از پروژه ها ممکن است برای موضوعات نیازمند بحث و گفتگو از انجمن های گفتگو یا خبرنامه ایمیلی به جای ایشو ترکر استفاده کنند. البته برخی دیگر ممکن است همین کار را به صورت کامل در بخش ایشو ترکر انجام دهند.
* **Synchronous chat channel:** بعضی از پروژه‌های از کانال‌های چت مانند <span dir="rtl">Slack</span> یا <span dir="rtl">IRC</span> برای مکالمات محاوره‌ای، همکاری یا تبادلات سریع استفاده می‌کنند.

## یافتن یک پروژه جهت مشارکت کردن در آن

اکنون می‌دانید نحوه‌ی کار یک پروژه‌ی متن باز چگونه است. بنابراین، زمانش رسیده تا برای مشارکت، یک پروژه‌ی متن باز پیدا کنید!

اگر قبلا در هیچ پروژه‌ی متن بازی مشارکت نداشته‌اید، نصیحت رئیس جمهور آمریکا، جان. اف. کندی را بشنوید که گفت:«نگویید کشورتان برای شما چه کار کرده– بپرسید شما برای کشورتان چه کار کرده‌اید.»

مشارکت‌کننده‌ها در تمام سطح‌های می‌توانند در پروژه‌های متن باز مشارکت کنند. لازم نیست بیش از حد به ذهن خود فشار بیاورید که اولین مشارکت شما در یک پروژه دقیقاً به چه صورت است، یا اولین مشارکت‌تان در آن پروژه چگونه خواهد شد.

در عوض، به پروژه‌هایی فکر کنید که قبلا استفاده شده، یا می‌خواهید استفاده کنید. پروژه‌هایی که به صورت فعال در آن مشارکت می‌کنید، پروژه‌هایی هستند که برمی‌گردند.

هر زمان در چنین پروژه‌هایی به این موضوع فکر کردید که می‌توانستید بهتر از این یا متفاوت‌تر باشد، بهتر است از روی غریزه کار کنید.

فکر نکنید یک پروژه‌ی متن باز انحصاری است، چون پروژه‌های متن باز توسط افرادی مانند شما طراحی شده است. یک پروژه‌ی متن باز تنها یک لفظ فانتزی برای برطرف کردن و حل مشکلات در دنیاست.

شما در پروژه‌های متن باز می‌توانید فایل <span dir="rtl">README</span> را مطالعه، لینک‌های خراب و غلط‌های املائی را پیدا و برطرف کنید. شما و کاربران جدیدتان هم می‌توانند متوجه مشکل یا مسئله‌ای شوند که فکر کی‌کند باید از اسناد پروژه باشد. به جای نادیده گرفتن، عبور کردن یا سپردن آن مسائل به افراد دیگر، برای اصلاح آن مشکلات می‌توانید کمک کنید. این تمام چیزی است که یک پروژه‌ی متن باز می‌تواند داشته باشد!

> [28% از مشارکت‌کننده‌های معمولی](https://www.igor.pro.br/publica/papers/saner2016.pdf) روی اسناد پروژه‌ی متن باز مانند اصلاح غلط‌های املائی، شکل ‌دهی مجدد، یا نوشتن ترجمه مشارکت می‌کنند.

اگر به دنبال مسائل موجود پروژه‌ی متن بازتان هستید تا آن را برطرف کنید، می‌توانید وارد صفحه‌ی <span dir="rtl">`/contribute`</span> هر پروژه‌ی متن باز شوید که مشکلات را برای تازه‌واردها برجسته می‌کند. شما می‌توانید با حل کردن آن مشکلات، در مشارکت پروژه‌ی متن باز همکاری داشته باشد. برای این منظور می‌توانید به صفحه‌ی اصلی <span dir="rtl">repository</span>  (مخزن) در سایت <span dir="rtl">GitHub</span> مراجعه کنید و کلمه‌ی <span dir="rtl">`/contribute`</span> را به انتهای آدرس URL آن اضافه کنید. به عنوان مثال:
[`https://github.com/facebook/react/contribute`](https://github.com/facebook/react/contribute)).

شما همچنین می‌توانید از منابع زیر برای کشف و مشارکت در پروژه‌های جدید کمک بگیرید:

* [GitHub Explore](https://github.com/explore/)
* [Open Source Friday](https://opensourcefriday.com)
* [First Timers Only](https://www.firsttimersonly.com/)
* [CodeTriage](https://www.codetriage.com/)
* [24 Pull Requests](https://24pullrequests.com/)
* [Up For Grabs](https://up-for-grabs.net/)
* [First Contributions](https://firstcontributions.github.io)
* [SourceSort](https://www.sourcesort.com/)

### بررسی چک لیست قبل از مشارکت در پروژه‌ی متن باز

زمانی که پروژه‌ی مورد علاقه‌تان برای مشارکت را پیدا کردید، نگاهی سریعی داشته باشید که آیا آن پروژه مناسب است تا درخواست همکاری‌تان را بفرستید. در غیر این صورت، کار پُرتلاش شما ممکن است هیچوقت به نتیجه نرسد.

در ادامه می‌توانید چک لیست دستی را ببینید که می‌تواند مشارکت‌کننده‌های جدید یک پروژه را ارزیابی کند.

**پروژه با تعریف پروژه‌ی متن باز مطابقت داشته باشد**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
  پروژه‌ای که می‌خواهید در آن مشارکت کنید، لایسنس دارد؟ در هر پروژه‌ی متن باز معمولاً فایلی با نام <span dir="rtl">LICENSE</span> در روت ریپاستوری (مخزن) آن وجود دارد
  </label>
</div>

**پروژه‌ی متن باز به صورت فعالانه‌ای حضور مشارکت‌کننده‌ها را قبول می‌کند**

نگاهی به کامیت های اخیر در شاخه اصلی بیاندازید. در گیت‌هاب این این مورد در صفحه اصلی مخزن دیده می‌شود.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
  آخرین کامیت چه زمانی بود؟
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
  چه تعداد مشارکت‌کننده در پروژه حضور دارند؟
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
  افراد چند بار کامیت می‌کنند؟ (در <span dir="rtl">GitHub</span> ، با کلیک روی <span dir="rtl">«commits»</span> روی بالای بار می‌توانید آن را متوجه شوید.)
  </label>
</div>

در قدم بعدی به مسائل پروژه <span dir="rtl">(issue)</span> نگاهی بیندازید.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    چه تعداد مسائل حل‌نشده و باز در پروژه وجود دارد؟
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    آیا نگهدارندگان به موقع به مسائلی که مطرح می‌شوند واکنش نشان می‌دهند؟
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    آیا بحث‌ها و گفتگوهای فعالی جهت حل مسائل وجود دارد؟
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    آیا اخیراً مسائلی گزارش شده است؟
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    مسائل پروژه‌ی متن باز برطرف شدند؟ (می‌توانید به صفحه‌ی <span dir="rtl">Issues</span> در <span dir="rtl">GitHub</span> و تب <span dir="rtl">«closed»</span> مراجعه کنید تا مسائل حل‌شده را ببینید.)
  </label>
</div>

حالا، تمام این مراحل را برای درخواست ادغام یا <span dir="rtl">Pull Request</span> پروژه هم در نظر بگیرید.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    چه تعداد درخواست ادغام یا <span dir="rtl">Pull Request</span> در پروژه وجود دارد؟
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox20" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox20" class="overflow-hidden d-block text-normal">
    آیا زمان دریافت درخواست‌های ادغام، مسئول‌نگهداری به سرعت به آن‌ها جواب می‌دهد؟
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    آیا بحث‌های فعالی برای درخواست‌های ادغام وجود دارد؟
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    آیا درخواست‌های ادغام جدیدی در پروژه وجود دارد؟
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox13" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox13" class="overflow-hidden d-block text-normal">
    جدیدترین درخواست‌هایی که ادغام شدن چه بودند؟ (می‌توانید در صفحه‌ی <span dir="rtl">Pull Request</span> و تب <span dir="rtl">«closed»</span> در سایت <span dir="rtl">GitHub</span> بروید تا درخواست‌های ادغام انجام شده را ببینید
  </label>
</div>

**پروژه پذیرای مشارکت است**

زمانی که یک پروژه‌ی متن باز پذیرای مشارکت‌کننده‌های جدید باشد، سیگنال‌های دوستانه‌ای برای مشارکت‌کننده‌ها می‌فرستد.

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox14" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox14" class="overflow-hidden d-block text-normal">
    آیا مسئول ‌نگهداری جواب مفیدی به سوالات در بخش مسائل <span dir="rtl">(Issues)</span> می‌دهد؟
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox15" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox15" class="overflow-hidden d-block text-normal">
    آیا افراد در صفحه‌ی issue، تالارهای گفتگو، و صفحات چت مانند <span dir="rtl">IRC</span> یا <span dir="rtl">Slack</span> به طور دوستانه‌ای رفتار می‌کنند؟
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox16" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox16" class="overflow-hidden d-block text-normal">
    آیا درخواست‌های ادغام بررسی می‌شوند؟
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox17" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox17" class="overflow-hidden d-block text-normal">
    آیا مسئول ‌نگهداری از افراد به خاطر مشارکت‌شان تشکر می‌کند؟
  </label>
</div>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  هر زمان که با یک موضوع طولانی روبه‌رو شدید، جواب‌های توسعه‌دهندگان اصلی که در اواخر موضوع قرار دادند را بررسی کنید. آیا جواب آن‌ها به طور سازنده‌ای خلاصه است و با لحن مودبانه‌ای تصمیم می‌گیرند؟ اگر چیزهای بی‌ادبانه‌ای می‌بینید، اغلب به این خاطر است که به جای توسعه، انرژی منفی می‌دهند
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/evaluating-oss-projects.html)
  </p>
</aside>

## چگونه درخواست مشارکت را ارسال کنیم

زمانی که پروژه‌ی مورد علاقه‌تان را پیدا کردید، آماده‌ی مشارکت در آن می‌شوید و در نهایت باید راهی برای ارسال مشارکت خود به آن پیدا کنید.

### ارتباط موثر

خواه مشارکت‌کننده‌ی یک‌باره باشید، یا سعی داشته باشید در یک انجمن عضو شوید، کار کردن با دیگران می‌تواند یکی از مهم‌ترین مهارت‌هایی باشد که در مشارکت در پروژه‌ی متن باز می‌توانید آن‌ را توسعه و بهبود دهید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shubheksha?s=180" class="pquote-avatar" alt="avatar">
  من به عنوان یک مشارکت‌کننده‌ی جدید به سرعت متوجه شدم که اگر می‌خواهم مسائل مرتبط با پروژه متن باز را برطرف کنم، باید سوال بپرسم. کد را سرسری مطالعه کردم، به خود آمدم و خواستم من را بیشتر راهنمایی کنند. در نتیجه، بعد از دریافت تمام جزئیاتی که نیاز داشتم، توانستم مسائل پروژه را برطرف کنم
  <p markdown="1" class="pquote-credit">
— @shubheksha, [A Beginner's Very Bumpy Journey Through The World of Open Source](https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/)
  </p>
</aside>

قبل از درخواست ادغام یا باز کردن <span dir="rtl">issue</span> در بخش گزارش مسئله یا پرسیدن سوال در چت، نکته‌های زیر را در نظر داشته باشید تا به شما کمک کند تا ایده‌هایتان کارآمد و موثرتر باشد.

**ارائه‌ی زمینه:** به دیگران کمک کنید تا سرعت خود را افزایش دهند. اگر خطایی پیدا کردید و در حال برطرف کردن آن هستید، به دیگران توضیح دهید که سعی دارید چه کاری انجام می‌دهید و چگونه آن مشکل را حل می‌کنید. اگر ایده‌ی جدیدی هم پیشنهاد می‌دهید، نه تنها برای خود، بلکه برای دیگران توضیح دهید که چرا فکر می‌کنید این ایده‌ی شما می‌تواند برای پروژه مفید باشد.

> 😇 _"زمانی که <span dir="rtl">Y</span> را انجام می‌دهم، <span dir="rtl">X</span> اتفاق نمی‌افتد"_
>
> 😢 _"X به مشکل برخورد کرده است! لطفا برطرفش کنید."_

**تکالیف‌تان را از قبل انجام دهید.** اگر چیزی نمی‌دانید مشکلی نیست، اما باید نشان دهید که تلاش‌تان را می‌کنید. قبل از اینکه از دیگران کمک بخواهید، مطمئن شوید که فایل <span dir="rtl">README</span>، اسناد، مسائل حل شده یا حل نشده، لیست پست پروژه را خوانده‌اید، یا در اینترنت به دنبال جواب‌تان گشته‌اید. وقتی تلاش‌تان برای یادگیری را نشان می‌دهید، مورد توجه تحسین دیگران قرار می‌گیرید

> 😇 _"مطمئن نیستم چگونه <span dir="rtl">X</span> را اجرا کنم. برای پیدا کردن جواب، فایل‌ها را بررسی کردم و هیچ جوابی نگرفتم."_
>
> 😢 _"چگونه مسئله <span dir="rtl">X</span> را برطرف کنم؟"_

**درخواست‌ها را مختصر و مفید مطرح کنید** هر مشارکتی مانند ارسال یک ایمیل، بدون در نظر گرفتن ساده یا مفید بودنش، به توجه‌ی دیگران نیاز دارد. معمولاً درخواست‌ها و سوالات اکثر پروژه‌ها از افرادی که می‌خواهند به آن‌ها جواب بدهند بیشتر است. بنابراین، درخواست‌ها باید مختصر باشد. با کوتاه بودن درخواست‌ها به افراد شانس بیشتری می‌دهید تا فرصت کمک کردن به شما را پیدا کنند.

> 😇 _"تمایل دارم یک فایل آموزشی <span dir="rtl">API</span> بنویسم"_
>
> 😢 _"زمانی که در بزرگ‌راه در حال رانندگی کردن بودم، کنار یک پمپ بنزین توقف کردم و ایده‌ی شگفت‌انگیزی به ذهنم رسید که باید آن را عملی کنیم، اما قبل از توضیح، اجازه دهید ایده‌ام را به شما نشان بدهم ..."_

**تمام ارتباطات و تعاملات را به صورت عمومی نگهدارید.** هرچند وسوسه‌کننده است، اما به طور خصوصی با مسئول‌نگهداری پروژه تماس نگیرید مگر اینکه لازم باشد اطلاعات حساس مانند مسائل امنیتی یا نقض رفتار جدیدی را رد و بدل کنید. زمانی که مکالمه‌ی شما عمومی شود، افراد بیشتری از تبادل این ارتباطات یاد می‌گیرند و بهره می‌گیرند. بحث و گفتگوها می‌تواند خودبه خود کمک‌رسان باشد.

> 😇 (در کامنت) «@-مسئول‌نگهداری: سلام! چگونه درخواست ادغام را پیش ببریم؟"_
>
> 😢 (در ایمیل) «سلام، ببخشید از طریق ایمیل مزاحم می‌شم، اما نمی‌دانم که می‌توانید درخواست ادغام من را بررسی کنید.»_

**سوال کردن عیب نیست (اما صبور باشید!).** هرکسی در ابتدای کار در پروژه تازه‌وارد بوده است. حتی مشارکت‌کننده‌های باتجربه زمانی که به پروژه‌ی جدیدی مراجعه می‌کنند، باید سرعت خود را افزایش دهند. با این حساب، حتی مسئول‌نگهدارهای طولانی مدت هم همیشه با تمام بخش‌های یک پروژه آشنا نیستند. بنابراین، سعی کنید صبور باشید تا فرصت نشان دادن آن را به شما بدهند.

> 😇 _"بابت بررسی کردن این خطا ممنونم. پیشنهادهای شما را دنبال می‌کنم. این خروجی کار است"_
>
> 😢 _"چرا مشکل من را نمی‌توانید حل کنید؟ این پروژه مگر پروژه‌ی شما نیست؟"_

**به تصمیمات انجمن احترام بگذارید.** ایده‌های شما ممکن است با اولویت‌ها و دید انجمن متفاوت باشد. آن‌ها یا می‌توانند به ایده‌های شما بازخورد بدهند یا آن را دنبال نکنند. درحالی‌که باید بحث و گفتگو کنید و به دنبال مصالحه باشید، مسئول‌نگهداری باید با تصمیمات شما بیشتر از شما زندگی کند. اگر با مسیر آن‌ها مخالف هستید، همیشه می‌توانید روی کار خود تمرکز کنید و پروژه‌ی خودتان را شروع کنید.

> 😇 _"ناامید شدم که نمی‌توانید پرونده‌ی من را پشتیبانی کنید، اما همانطور که توضیح دادید این مسئله تنها روی بخشی از کاربران تاثیر می‌گذارد. متوجه هستم چرا. بابت شنیدن پیامم ممنون هستم"_
>
> 😢 _"چرا مورد من را پشتیبانی نمی‌کنید؟ این کار شما غیرقابل قبول است!"_

**فراتر از همه اینها.** مشارکت‌کننده‌های سراسر دنیا پروژه‌های متن باز را می‌سازند. متن‌های پروژه‌ها می‌تواند با زبان‌ها، فرهنگ‌ها، جغرافیاها و مناطق زمانی زیادی باشد. مدل ارتباط نوشتاری رساندن لحن و حالت مشارکت‌کننده‌های یک پروژه را مشکل می‌کند. اما نیت خیر تمام این گفتگوها را در نظر داشته باشید. خوب است که ایده‌ی خود را مودبانه منتقل کنید، متن و محتوای بیشتری درخواست کنید، یا موقعیت‌تان را روشن‌تر کنید. فقط سعی کنید اینترنت را از زمانی که وارد شدید، را جای بهتری کرده باشید

### Gathering context

قبل از اینکه کاری انجام دهید، به سرعت بررسی کنید و مطمئن شوید که ایده‌ی شما در هیج جای مورد بحث قرار نگرفته باشد. فایل <span dir="rtl">README</span>، مسائل حل‌شده یا حل‌نشده، لیست پست و گفتگوهای <span dir="rtl">Stack</span> را به طور سرسری مطالعه کنید. لازم نیست ساعت‌ها صرف خواندن آن‌ها کنید، اما جستجوی سریع درباره‌ی کلمات کلیدی می‌تواند تا حد زیادی به شما کمک کند

اگر ایده‌ی شما در جای دیگری مطرح نشده بود، می‌توانید آن را بیان کنید. اگر پروژه در <span dir="rtl">GitHub</span> باشد، با باز کردن <span dir="rtl">Issue</span> یا درخواست ادغام <span dir="rtl">Pull Request</span> احتمالاً می‌توانید مکالمه داشته باشید:

* **Issues** مانند شروع یک مکالمه یا گفتگو است
* **Pull Requests** برای کار روی راه‌حل است
* **سایر راه های ارتباطی راه‌های ارتباطی** مانند شفاف‌سازی، نحوه‌ی پرسیدن سوال <span dir="rtl">(How-to question)</span>، پرسیدن سوال در <span dir="rtl">Stack</span> ، <span dir="rtl">IRC</span> ، <span dir="rtl">Slack</span> یا دیگر کانال‌های چت است، البته اگر یک پروژه چنین راه‌های ارتباطی را باز گذاشته باشد.

قبل از باز کردن <span dir="rtl">issue</span> یا درخواست ادغام، اسناد مشارکت پروژه را بررسی کنید که معمولاً در فایل‌هایی به نام  <span dir="rtl">CONTRIBUTING</span> یا <span dir="rtl">README</span> آورده شدند تا چیزهای خاصی که دنبالش هستید را مطالعه کنید. به عنوان مثال، آن‌ها ممکن است از شما درخواست کنند الگوها را پیروی کنید یا به این نیاز داشته باشند که از این تست‌ها استفاده کنند.

اگر در یک پروژه مشارکت عمیق و اساسی داشته باشید، قبل از مشارکت در پروژه، یک <span dir="rtl">issue</span> باز کنید و سوال کنید. این کار مفید است و باعث می‌شود پروژه‌ی شما مدتی مشاهده شود. (در سایت <span dir="rtl">GitHub</span> می‌توانید [روی «Watch» کلیک کنید](https://help.github.com/articles/watching-repositories/) تا از تمام مکالمات مطلع شوید)، و قبل از انجام دادم کار که ممکن است پذیرفته نشود، اعضای انجمن را بشناسید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gaearon?s=180" class="pquote-avatar" alt="avatar">
  با فعالیت در پروژه‌های <span dir="rtl">GitHub</span> و مطالعه‌ی تمام <span dir="rtl">issue</span> و درخواست‌های ادغام می‌توانید چیزهای زیادی یاد بگیرید.
<p markdown="1" class="pquote-credit">
— @gaearon [on joining projects](https://twitter.com/dan_abramov/status/819555257055322112)
  </p>
</aside>

### باز کردن <span dir="rtl">issue</span> یا طرح سوال و گفتگو

در موقعیت‌های زیر معمولاً باید یک <span dir="rtl">issue</span> باز کنید:

* جهت گزارش خطایی که خودتان نمی‌توانید آن را حل کنید
* درباره‌ی موضوعات یا ایده‌ی سطح بالا بحث کنید (به عنوان مثال، درباره‎ی جامعه، دیدگاه یا سیاست‌ها)
* ویژگی جدید یا ایده‌ی جدیدی برای پروژه پیشنهاد دهید

نکاتی برای برقراری ارتباط با مشکلات <span dir="rtl">issue</span> :

* **اگر با مسئله‌ی بازی روبه‌رو شدید که می‌خواهید آن را برطرف کنید**، کامنت کردن برای یک مسئله به افراد اجازه می‌دهد بدانند که شما این مسئله را باز کردید. به این ترتیب، افراد احتمالاً کمتر با مشکلات مشابه‌ی شما برخورد می‌کنند
* **اگر یک issue مدتی پیش باز بوده است**، احتمال دارد جای دیگر به آن جواب داده شده باشد، یا قبلا حل شده است. بنابراین، قبل از شروع کار می‌توانید برای تایید حل شدن یا حل نشدن آن درخوست کامنت بدهید.
* **اگر یک issue باز کردید**، اما جواب آن را بعدها متوجه شدید، روی issue کامنت بگذارید تا مردم متوجه شوند، سپس <span dir="rtl">issue</span> را ببندید. حتی با نوشتن اسناد می‌تواند سهمی در مشارکت پروژه داشته باشید.

### ارسال Pull request (درخواست ادغام)

شما معمولاً در موقیعت‌های زیر باید درخواست ادغام باز کنید:

* ارائه اصلاحات ناچیز (به عنوان نمونه، غلط‌های املائی، لینک‌های خراب یا خطاهای مشهود)
* کار کردن روی مشارکتی که قبلا درخواست شده یا درباره‌ی آن بحث و گفتگو شده باشد

درخواست ادغام لزوماً به معنای پایان کار نیست. معمولاً بهتر است درخواست ادغام را قبلا باز کنید تا دیگران بتوانند آن را مشاهده و بازخوردهای خود را برای پیشرفت شما ارسال کنند. فقط آن را به <span dir="rtl">«WIP»</span> (کار در حال انجام) در کادر عنوان نشانه‌گذاری کنید. شما بعدها می‌توانید کامیت‌های بیشتری اضافه کنید.

اگر پروژه در <span dir="rtl">GitHub</span> باشد، با روش‌های زیر می‌توانید درخواست ادغام ارسال کنید:

* **[Fork the repository](https://guides.github.com/activities/forking/)** و یک نسخه برای خودتان کپی کنید. نسخه محلی خود را به مخزن بالادستی متصل کنید. هر از چندگاهی با دستور <span dir="rtl">Pull</span> آخرین نسخه تغییرات در مخزن اصلی را دریافت کنید تا پیش از اینکه تعارضی ما بین نسخه محلی و مخزن ایجاد شد بتوانید با مشکلات احتمالی کمتری تغییرات خود را به سمت مخزن اصلی ارسال کنید. [برای کسب اطلاعات بیشتر اینجا را مرور کنید](https://help.github.com/articles/syncing-a-fork/)
* **[ایجاد یک شاخه](https://guides.github.com/introduction/flow/)** برای اعمال ویرایش ها.
* در حین ارسال ها **به مسائل <span dir="rtl">(issue)</span> مرتبط ارجاع دهید** یا در کامنت مربوط به تغییرات جدید به مستندات مربوطه اشاره کنید.(مثال: این تغییر مشکل مطرح شده در مسئله شماره 37 را برطرف می‌کند.)
* اگر تغییرات شما حاوی تفاوت‌های <span dir="rtl">HTML/CSS</span> باشد، **تصاویر مربوط به قبل و بعد آن را اضافه کنید**. تصاویر را وارد بدنه‌ی درخواست ادغام کنید و رها کنید.
* تغییرات‌تان را **تست کنید!** تغییرات خود را در برابر تست‌های موجود اجرا کنید و در صورت لزوم تغییرات جدیدی خلق کنید. اگر حتی تست‌هایی تعریف نشده بود، مطمئن شوید تغییرات‌تان پروژه‌ی موجود شما را خراب نکند.
* با تمام توانایی‌تان  **الگوها را رعایت کرده و مطابق سبک پروژه مشارکت کنید**. این توانایی می‌تواند به معنای استفاده از تورفتگی‌ها، نقطه ویرگول <span dir="rtl">(semi-colons)</span> ، یا کامنت‌های متفاوتی باشد که شما در مخزن‌تان خودتان دارید. این کار ادغام مسئول‌نگهداری را ساده می‌کند، دیگران هم متوجه آن می‌شوند و می‌توانند آن را برای زمان‌های آتی حفظ کنند.

اگر این اولین درخواست ادغام شماست، فیلم آموزشی [Make a Pull Request](http://makeapullrequest.com/) که @kentcdodds آن را خلق کرده، بررسی کنید. شما همچنین می‌توانید از [Make a Pull Request](https://github.com/Roshanjossey/first-contributions) که توسط @Roshanjossey ایجاد شده به عنوان یک محزن تمرینی برای اولین تجربه خود استفاده کنید.

## بعد از ارسال درخواست مشارکت چه اتفاقی می‌افتد

شما درخواست‌تان را ارسال کردید! شروع مشارکت‌تان در یک پروژه‌ی متن باز را تبریک می‌گوییم. امیدواریم این اولین قدم‌تان باشد.

بعد از ارسال درخواست مشارکت‌تان، یکی از اتفاقات زیر رخ می‌دهد:

### 😭 جوابی دریافت نمی‌کنید.

امیدواریم قبل از ارسال درخواست مشارکت، [چک لیست فعالیت‌های پروژه](#بررسی-چک-لیست-قبل-از-مشارکت-در-پروژهی-متن-باز) را برررسی کرده باشید. هرچند، حتی در پروژه‌ی فعال هم این احتمال وجود دارد که به درخواست مشارکت شما پاسخ ندهند.

اگر بیش از یک هفته جوابی برایتان ارسال نشد، به طور مودبانه می‌توانید درخواست جواب دهید و از کسی بخواهید درخواست شما را بررسی کند. اگر نام کسی که می‌خواهید درخواست شما را بررسی کند می‌دانید، می توانید به اون اشاره (منشن: با گذاشتن علامت @ در ابتدای نام کاربری) کنید.

به صورت خصوصی با آن شخص **تماس نگیرید**. به یاد داشته باشید ارتباط عمومی برای پروژه‌ها بسیار حیاتی است.

اگر به طور مودبانه درخواست‌هایتان را فرستاده باشید اما هنوز هیچ‌کس پاسخگو نیست، احتمالاً هیچ‌کس هیچوقت پاسخ شما را نخواهد داد. می‌دانیم که حس خوبی ندارد، اما اجازه ندهید این موضوع شما را دلسرد کند چون این اتفاق ممکن است برای همه رخ دهد!

برای برطرف کردن این مشکل دلایل زیادی وجود دارد که به شما می‌گوید چرا پاسخ درخواست‌تان داده نمی‌شود؛ دلایلی مانند شرایط شخصی که ممکن است از کنترل خارج شود. شما می‌تواند پروژه‌ی دیگر یا راهی برای مشارکت پیدا کنید. قبل از اینکه اعضای یک انجمن متعهد یا پاسخگو باشند، زمان زیادی را صرف ارسال درخواست مشارکت‌تان نکنید.

### 🚧 یک نفر برای تغییر درخواست‌تان به شما پیام می‌دهد.

مرسوم است کسی بخواهید درخواست مشارکت خود را تغییر دهید، این درخواست تغییر می‌تواند در بازخورد ایده‌ یا در تغییرات کد شما باشد.

اگر کسی درخواست تغییر برای‌تان ارسال کرد، پاسخگو باشید، چون آن‌ها برای بررسی درخواست مشارکت شما زمان گذاشتند. باز گذاشتن <span dir="rtl">PR</span> (درخواست ادغام) و نادیده گرفتن آن صورت خوبی ندارد. اگر نمی‌دانید چگونه روی درخواست‌تان آن تغییرات را اعمال کنید، مشکلات را جستجو کنید و در صورت نیاز از کسی کمک بخواهید.

اگر برای برطرف کردن مسائل پروژه دیگر زمان کافی ندارید (به عنوان نمونه، اگر مکالمه‌ی شما ماه‌ها طول کشید، و اکنون شرایط شما تغییر کند)، اجازه دهید مسئول‌نگهداری پروژه از این موضوع مطلع شود تا منتظر جواب شما نباشد. حتی کسی دیگری ممکن است جای شما را بگیرد.

### 👎 درخواست مشارکت‌تان پذیرفته نشد

در پایان، درخواست مشارکت‌تان ممکن است پذیرفته شود یا نشود. هرچند، در صورت پذیرفته نشدن درخواست‌تان امیدواریم زمان زیادی روی آن صرف نکرده باشید. اگر مطمئن نیستید که چرا درخواست‌تان پذیرفته نشده، کاملاً معقولانه است که برای درخواست بازخورد و شفاف‌سازی از مسئول‌نگهداری جواب بخواهید. در نهایت، با احترام به تصمیم آن‌ها نباید خشمگین و عصبانی شوید. همیشه می‌توانید پروژه‌ی دیگری انتخاب کنید و اگر هم نمی‌خواهید در پروژه‌ای مشرکت کنید، می‌توانید پروژه‌ی خودتان را داشته باشید!

### 🎉 درخواست مشارکت شما پذیرفته شد.

هوررا! درخواست مشارکت شما برای پروژه‌ی متن باز موفقیت‌آمیز بوده است

## انجامش دادی!

خواه دنبال ارسال درخواست مشارکت خود برای اولین پروژه‌تان باشید، یا دنبال یک راه جدید برای مشارکت در پروژه‌ای متن باز، امیدواریم انگیزه این کار را داشته باشید. حتی اگر درخواست‌تان هم پذیرفته نشد، فراموش نکنید از تلاش مسئول‌نگهداری پروژه تشکر کنید که تمام تلاش خود را برای کمک به شما گذاشت. پروژه‌های متن باز، مسائل، درخواست ادغام، کامنت توسط افرادی مانند شما تولید می‌شود.
