---
lang: fa
title: گرفتن دستمزد برای کارهای متن باز
description: با دریافت پشتیبانی‌های مالی در ازای زمانی که می‌گذارید یا به خاطر پروژه‌ای که پیش می‌برید، کار متن باز خود را حمایت کنید.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## چرا برخی افراد به دنبال پشتیبانی‌های‌ مالی هستند

بیشتر کارهای متن باز داوطلبانه است. به عنوان مثال، کسی ممکن است در پروژه‌ای که از آن استفاده می‌کند با ایرادی (باگ) روبرو شود و راه‌حلی آسان برای ایراد ارائه کند، یا ممکن است کسی در اوقات فراغت خود از دستکاری در پروژه‌ی متن باز لذت ببرد.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
	من به دنبال یک پروژه‌ی برنامه نویسی به دید «سرگرمی» بودم که بتواند مرا در طول هفته در ایام کریسمس به خود مشغول کند. (…) و فقط یک کامپیوتر در دست و بالم بود. تصمیم گرفتم برای «زبان اسکریپتی» جدیدی که اخیراً به آن فکر می‌کردم، مفسر بنویسم. پایتون را به عنوان اسم موقت انتخاب کردم
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

دلایل زیادی برای مایل نبودن شخص برای دریافت دستمزد در ازای کار متن باز خود، وجود دارد.

* ممکن است از قبل، **کار تمام وقت مورد علاقه‌ی خود را داشته باشند** که به آن‌ها این امکان را می‌دهد تا در اوقات فراغت خود در کارهای متن باز مشارکت داشته باشند.
* آن‌ها از تصور کردن کارهای متن باز **به عنوان یک سرگرمی یا فرآیندی خلاقانه لذت می‌برند** و نمی‌خواهند از نظر مالی ملزم به کار در پروژه‌های خود باشند.
* آن‌ها از طریق مشارکت در کارهای متن باز **از مزایای دیگری برخوردار می‌شوند**، همچون ایجاد نمونه‌کار یا شهرت و اعتباری برای خود، یادگیری مهارت جدید یا احساس نزدیک‌تر بودن و صمیمیت بیشتر با اجتماع.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  کمک‌های مالی باعث ایجاد احساس مسئولیت برای برخی می‌شود. (…)برای ما مهم است که در جهان شتابان و و بهم پیوسته‌ای که در آن زندگی می‌کنیم، بتوانیم بگوییم «نه، الان حس و حال انجام کار دیگه‌ای را دارم».
  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

برای دیگران، به ویژه هنگامی که مشارکت‌ها باید ادامه بیابد و یا به زمان قابل توجهی نیاز داشته باشد؛ اگر پروژه به آن‌ها نیاز داشته باشد یا به دلایل شخصی باید به کار ادامه دهند، پرداخت دستمزد برای مشارکت در کار متن باز، تنها راه برای مشارکت است.

حفظ پروژه‌های پرطرفدار، می‌تواند مسئولیت سنگینی را بر روی دوش افراد بگذارد، می‌تواند بجای چند ساعت در ماه 10 یا 20 ساعت در هفته را به خود اختصاص دهد.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  از هر نگهدارنده‌ی پروژه‌ی متن بازی که خواستید بپرسید، و آن‌ها در مورد واقعیت میزان کاری که برای مدیریت یک پروژه انجام می‌دهند، به شما می‌گویند. شما موکل‌هایی خواهید داشت. مسائلی را برای آن‌ها حل و فصل می‌کنید. ویژگی‌های جدیدی را خلق می‌کنید. و این‌ها، زمانی زیادی را از شما می‌طلبند.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

همچنین کارهای با دستمزد، این امکان برای افراد از اقشار مختلف جامعه را فراهم می‌آورد تا مشارکت‌های قابل‌توجه و معناداری انجام دهند. برخی از افراد، به سبب وضعیت مالی کنونی‌شان، بدهی یا خانواده یا سایر تعهدات، امکان مشارکت بدون دستمزد در پروژه‌های متن باز را ندارند. این بدان معناست که جهان هرگز مشارکت افراد مستعدی را که توانایی مالی برای مشارکت داوطلبانه را ندارند، نمی‌بیند. همانطور که @ashedryden [گفته است](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)، پیامدهایی اخلاقی در این میان وجود دارد، زیرا کسانی که از قبل در زندگی دارای مزایایی هستند، شانس بیشتری در کارهایی که انجام می‌شود دارند، درنتیجه بر اساس مشارکت‌های داوطلبانه‌ی خود مزایای بیشتری کسب می‌کنند، در حالی که سایر افرادی که قادر به داوطلب شدن نیستند، فرصت‌های آتی را از دست می‌دهند، که این عدم تنوع را در اجتماع کنونی (community) متن باز گسترش می‌دهد.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   «OSS»، مزایای زیادی برای صنعت فناوری به همراه دارد که به نوبه‌ی خود به معنای مزایایی برای کلیه‌ی صنایع است. (…)با این حال، اگر تنها افراد خوش‌شانس (کسانی که قادر به مشارکت داوطلبانه هستند) و به شدت علاقه‌مند هستند که می‌توانند در پروژه‌های متن باز تمرکز کنند، ظرفیتی فوق‌العاده از استعدادهای استفاده نشده وجود خواهد داشت.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

اگر به دنبال حمایت‌های مالی هستید، دو راه وجود دارد. می‌توانید زمان مناسب را برای مشارکت پیدا کنید، یا می‌توانید بودجه‌ای برای پروژه‌ی خودتان پیدا کنید.

## وقت خود را سرمایه‌گذاری کنید

امروزه بسیاری از افراد برای کار به صورت پاره وقت یا تمام وقت در پروژه‌های متن باز دستمزد دریافت می‌کنند. متداول‌ترین راه برای دریافت دستمزد برای وقتی که صرف می‌کنید، صحبت کردن با کارفرمای خودتان است.

متقاعد کردن کارفرما در پروژه‌ای که واقعا از آن استفاده ‌می‌کند آسان‌تر است، اما در مورد صحبتی که با او خواهید کرد، رویه‌ای خلاقانه در نظر بگیرید. شاید کارفرمای شما از این پروژه استفاده نکند، اما آن‌ها از پایتون استفاده می‌کنند و نگهداری از  پروژه‌ی پایتون محبوب به جذب توسعه‌دهندگان جدید پایتون کمک می‌کند. شاید این امر باعث شود که کارفرمای شما به طور کلی در در ارتباط با توسعه‌دهندگان سازنده‌تر و دوستانه‌تر به نظر برسد.

اگر در حال حاضر پروژه‌ای متن باز ندارید که بخواهید روی آن کار کنید، اما ترجیح می‌دهید که خروجی کار فعلی شما متن باز باشد، از کارفرمای خود درخواست کنید که برخی از نرم‌افزارهای داخلی خود را متن باز کند.

بسیاری از شرکت‌ها برنامه‌هایی متن باز توسعه می‌دهند تا اعتباری برای نام برند خود ایجاد کنند و افرادی با استعداد استخدام کنند.

به عنوان مثال، @hueniverse دریافت که دلایلی تجاری برای توجیه [سرمایه‌گذاری والمارت (Walmart)] (https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html)در متن باز وجود دارد. و jamesgpearce@، دریافت که برنامه‌ی متن باز فیس‌بوک، [تفاوت‌هایی را در استخدام ایجاد کرده است](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon)

> کاملا با فرهنگ خلاقیت‌جویانه‌ی ما و آنچه که سازمان ما با آن شناخته می‌شود، سازگار و همسو است. ما از کارمندان خود پرسیدیم، «آیا از برنامه‌ی نرم‌افزاری متن باز فیس‌بوک آگاهی داشتید؟» دو سوم آن‌ها گفتند «بله» یک دوم آن‌ها گفتند که این برنامه به تصمیم‌شان برای کار کردن در فیس‌بوک تاثیر داشت. اینها اعداد کمی نیستند و امیدواریم که این روند ادامه داشته باشد.

اگر شرکت شما این مسیر را طی می‌کند، مهم است که مرزهای بین اجتماع و فعالیت‌های شرکتی را روشن کنید. در آخر، پروژه‌های متن باز از طریق مشارکت‌های مردم در سرتاسر جهان از خود نگهداری می‌کند؛ این پروژه‌ها بزرگ‌تر از هر شرکت یا فضایی هستند.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  دریافت دستمزد برای کار در پروژه‌های متن باز فرصتی نادر و شگفت‌انگیز است، اما نباید اشتیاق خود در راه را از دست بدهید. اشتیاق شما باید چیزی باشد که شرکت به دنبال آن است.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

اگر نمی‌توانید کارفرمای کنونی خودتان را متقاعد به اولویت‌بندی کارهای متن باز بکنید، سعی کنید کارفرماهای جدیدی پیدا کنید که کارمندان را تشویق به مشارکت در متن باز می‌کنند. به دنبال شرکت‌هایی بگردید که تعهد صریحی برای کار با پروژه‌های متن باز داشته باشند. به عنوان مثال:

* برخی شرکت‌ها مانند [Netflix](https://netflix.github.io/)، وب‌سایت‌هایی دارند که مشارکت آن‌ها در متن باز را برجسته و نمایان می‌کند
* 	شرکت [Zalando](https://opensource.zalando.com)، «سیاست‌های مشارکت متن باز» خود برای کارمندان را منتشر کرد

پروژه‌هایی که از شرکت‌های بزرگی مانند [Go](https://github.com/golang) یا [React](https://github.com/facebook/react) سرچشمه گرفته‌اند و به آن وصل‌اند نیز احتمالاً افرادی را برای کار با متن باز استخدام خواهند کرد

بسته به شرایط شخصی خودتان، می‌توانید به طور مستقل برای تأمین هزینه‌های کار متن باز خود، پول جمع کنید. به عنوان مثال:

* نرم‌افزار متن باز @Homebrew ([و بسیاری از نگهدارندگان و سازمان‌ها](https://github.com/sponsors/community))، کار خودشان را از طریق حامیان مالی [GitHub](https://github.com/sponsors) تأمین می‌کنند
* @gaearon کار خود در [Redux](https://github.com/reactjs/redux) را از طریق کمپین سرمایه‌گذاری جمعی «Patreon» تأمین مالی کرد
* @andrewgodwin از [طریق کمپین Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django) کارش در مورد مایگریشن‌های دیتابیس «Django» را تأمین مالی کرد. (Schema Migration)

در آخر اینکه گاهی اوقات پروژه‌های متن باز درمورد موضوعاتی که ممکن است در آن بخواهید کمک کنید پاداش‌هایی قرار می‌دهند.

* @ConnorChristie توانست بابت [کمک](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) به @MARKETProtocol در «JavaScript library» (کتابخانه‌ی جاوا اسکریپت) از طریق پاداشی‌ تعیین شده در [gitcoin](https://gitcoin.co/)، دستمزد بگیرد
* @mamiM پس از تأمین اعتبار مربوط به مشکلِ شبکه‌ی Bounties، ترجمه‌ی ژاپنی برای @MetaMask انجام داد.

## یافتن بودجه برای پروژه‌

علاوه‌ بر توافق‌های اولیه با مشارکت‌کنندگان، گاهی اوقات پروژه‌ها از شرکت‌ها، افراد حقیقی یا دیگران برای تأمین بودجه‌ی کارهای جاری پول جمع‌آوری می‌کنند.

بودجه‌های سازمانی ممکن است به پرداخت دستمزد مشارکت‌کنندگان، تأمین هزینه‌های اجرای پروژه (مانند هزینه‌های میزبانی) یا سرمایه‌گذاری بر روی ویژگی‌ها یا ایده‌های جدید اختصاص یابد.

با افزایش محبوبیت ‌متن باز، هنوز هم یافتن بودجه برای پروژه‌ها به صورت تجربی و آزمایشی است، اما چندین گزینه‌ی متداول در دسترس است.

### جمع‌آوری سرمایه از طریق کمپین‌های سرمایه‌گذاری جمعی یا حمایت‌های مالی

اگر از قبل مخاطب یا اعتبار بالایی داشته باشید یا پروژه‌ی شما از محبوبیت بالایی برخوردار باشد، یافتن حمایت‌های مالی امکان‌پذیر است. چند نمونه از پروژه‌های حمایت شده:

* پروژه‌ی **[webpack](https://github.com/webpack)** از طریق [OpenCollective](https://opencollective.com/webpack) از شرکت‌ها و اشخاص پول جمع‌آوری می‌کند
* **[Ruby Together](https://rubytogether.org/)،** یک سازمان غیر‌انتفاعی است که هزینه‌های کار در [bundler](https://github.com/bundler/bundler)،  [RubyGems](https://github.com/rubygems/rubygems) و سایر پروژه‌های بر پایه‌ی زیرساختی «Ruby» را پرداخت می‌کند

### ایجاد یک منبع درآمدی

بسته به پروژه‌ی خود، ممکن است بتوانید از طریق تبلیغات، گزینه‌های میزبانی شده یا ویژگی‌های اضافی کسب درآمد داشته باشید. چندین مثال در این زمینه:

* **[Sidekiq](https://github.com/mperham/sidekiq)**، نسخه‌هایی پولی به منظور پشتیبانی بیشتر ارائه می‌دهد
* **[Travis CI](https://github.com/travis-ci)**، نسخه‌های پولی محصولات خود را ارائه می‌دهد
* **[Ghost](https://github.com/TryGhost/Ghost)**، یک سازمان غیرانتفاعی است که خدمات مدیریتی پولی ارائه می‌دهد

بعضی از پروژه‌های محبوب مانند [npm](https://github.com/npm/npm) و [Docker](https://github.com/docker/docker)، برای حمایت از رشد کسب و کار خود، حتی سرمایه‌های مخاطره‌آمیزی را جمع‌آوری می‌کنند

### برای بودجه، درخواست کمک هزینه (بورسیه) دهید

برخی از موسسات و شرکت‌های نرم‌افزاری، کمک‌هزینه‌های مالی برای کارهای متن باز ارائه می‌دهند. گاهی اوقات، بدون ایجاد نهاد قانونی‌ای برای پروژه، کمک‌هزینه‌های مالی به افراد حقیقی پرداخت می‌شود.

* **نرم‌افزار [Read the Docs](https://github.com/rtfd/readthedocs.org)**، از پشتیبانی بخش متن باز [Mozilla](https://www.mozilla.org/en-US/grants/)، کمک‌هزینه دریافت کرد
* **بودجه‌ی کار [OpenMRS](https://github.com/openmrs)** توسط [Stripe's Open Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees) تأمین شد
* **[Libraries.io](https://github.com/librariesio)** از موسسه‌ی [Sloan](https://sloan.org/programs/digital-technology) کمک‌هزینه‌ دریافت کرد
* **موسسه‌ی نرم‌افزار پایتون (Python Software Foundation)**، کمک‌های مالی برای کارهای مرتبط با پایتون ارائه می‌دهد

برای جزئیات دقیق‌تر و مطالعات موردی، @nayafia راهنمای دریافت دستمزد برای کارهای متن باز را [نوشت](https://github.com/nayafia/lemonade-stand). انواع بودجه‌ها به مهارت‌های مختلفی نیاز دارد، بنابراین نقاط قوت خود را در نظر بگیرید تا  گزینه‌ی مناسب برای کار خودتان را دریابید.

## ایجاد پرونده‌ی موردی (فایل) به منظور دریافت حمایت مالی

این که آیا پروژه‌ی شما ایده‌ی جدیدی است یا سال‌هاست که وجود دارد؛ باید برای شناسایی و مشخص کردن سرمایه‌گذار هدف و ایجاد یک پرونده‌‌ی اغواکننده، باید به خوبی راجع به آن فکر کنید.

چه بخواهید هزینه‌ی زمانی که صرف می‌کنید را خودتان پرداخت کنید و یا موسسه‌ای هزینه‌ی پروژه‌ی شما را پرداخت کند، باید بتوانید به سوالات زیر پاسخ دهید.

### تاثیرگذاری

این پروژه به چه دردی می‌خورد؟ برای چه کاربران شما، یا کاربران بالقوه‌ی شما، پروژه‌ را دوست داشته باشند؟ پروژه‌ی خود را در پنج سال آینده چطور می‌بینید؟

### مقبولیت

سعی کنید شواهدی را در مورد اهمیت پروژه‌ی خود جمع‌آوری کنید؛ چه بخواهد معیارهای سنجش، تجربه‌های گذشته، یا اظهارنظرهای مثبتی باشد. آیا شرکت‌ها یا افراد قابل ذکری وجود دارند که از پروژه‌ی شما استفاده بکنند؟ اگر نه، آیا شخص برجسته‌ای پروژه‌ی شما را تأیید کرده است؟

### ارزش آن برای سرمایه‌گذار

سرمایه‌گذاران، چه کارفرمای شما باشد و یا چه یک موسسه‌ی اعطای کمک‌هزینه، اکثرا جذب فرصت‌ها می‌شوند. چرا آن‌ها باید از پروژه‌ی شما در برابر سایر فرصت‌ها حمایت کنند؟ از پروژه‌ی شما چه منفعت شخصی‌ای می‌برند؟

### مصارف بودجه

با بودجه پیشنهادی، دقیقاً به چه نتیجه‌ای دست خواهید یافت؟ به جای فکر کردن به پرداخت حقوق و دستمزد، روی نقاط عطف یا نتایج پروژه متمرکز شوید.

### چگونه بودجه را دریافت خواهید کرد

آیا سرمایه‌گذار، الزاماتی در مورد پرداخت هزینه مدنظر دارد؟ به عنوان مثال، ممکن است لازم باشد شما سازمانی غیرانتفاعی باشید یا یک حامی مالی غیرانتفاعی داشته باشید. یا شاید بودجه باید به جای سازمان به یک پیمانکار حقیقی داده شود. هر شخص سرمایه‌گذاری الزامات متفاوتی دارد، بنابراین حتماً از قبل تحقیقات خود را انجام دهید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  سال‌هاست که ما با داشتن بیش از 20 میلیون نفر در اجتماع‌مان، وب‌سایت برتر در زمینه‌ی نماد‌ها (آیکون) در بیش از 70 میلیون وب‌سایت، از جمله «Whitehouse.gov»، مشخص شده‌ایم. (…)نسخه‌ی 4، سه سال پیش بود. فناوری وب از آن زمان با تغییرات زیادی همراه بوده است و صادقانه بگویم، «Font Awesome»، کمی قدیمی شده است. (…)به همین دلیل است که ما «Font Awesome 5» را معرفی می‌کنیم. ما در حال مدرن‌سازی و بازنویسی «CSS» و طراحی مجدد همه‌ی نمادها هستیم. داریم درباره‌ی طراحی بهتر، سازگاری بهتر و خوانایی بهتر صحبت میکنیم.
  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## آزمایش و تجربه کنید و تسلیم نشوید

جمع‌آوری پول آسان نیست، چه پروژه‌ای متن باز باشید، چه یک سازمان غیرانتفاعی و یا یک استارت‌آپ نرم‌افزاری؛ باید در بیشتر موارد با دیدی خلاقانه به موضوع نگاه کنید. با مشخص کردن اینکه چگونه می‌خواهید دستمزد بگیرید، با تحقیقات خود و قرار دادن خود به جای سرمایه‌گذار، به شما کمک می‌کند تا پرونده‌ای قانع‌کننده برای تأمین بودجه بسازید.
