---
lang: fa
title: پیدا کردن کاربر برای پروژه‌هایتان
description: با داشتن کاربرانی راضی و خوشحال، به پروژه‌ی اوپن سورس خود کمک کنید تا رشد کند..
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## به اطلاع همگان برسانید

هیچ قانونی وجود ندارد که بگوید هنگام راه‌اندازی، باید پروژه‌ی اوپن سورس را تبلیغ کنید. دلایل رضایت‌بخش زیادی برای کار کردن در پروژه‌ای اوپن سورس وجود دارد که هیچ ارتباطی با محبوبیت ندارد. به جای امیدواری برای اینکه دیگران پروژه‌ی اوپن سورس شما را پیدا کنند و از آن استفاده کنند، باید در مورد پروژه و سخت‌کوشی خودتان صحبت کنید و آن را به گوش دیگران برسانید!

## از پیامی که می‌خواهید به گوش دیگران برسانید، اطمینان حاصل کنید

قبل از اینکه شروع به تبلیغ و ترویج پروژه‌ بکنید، باید بتوانید که کارآیی و چرایی اهمیت آن را توضیح بدهید.

چه چیزی موجب تفاوت و جالب بودن پروژه‌ی شما نسبت به دیگر پروژه‌ها می‌شود؟ به چه منظور آن را ساختید؟ پاسخ دادن به این سوالات، به شما کمک می‌کند تا به اهمیت پروژه‌ی خودتان پی ببرید و آن را واضح‌تر بیان کنید.

به یاد داشته باشید به این دلیل که پروژه‌ی شما مشکلی را برای کاربران برطرف می‌کند؛ افراد به عنوان کاربر به پروژه‌ی شما ملحق می‌شوند و در نهایت به عنوان یک مشارکت‌کننده معرفی می‌شوند. همانطور که درباره‌ی پیام و ارزش پروژه‌‌ی خود فکر می‌کنید، سعی کنید آن‌ها را از دریچه‌ی آنچه که کاربران و مشارکت‌کنندگان می‌خواهند نظاره کنید.

به عنوان مثال، <span dir="rtl">@robb</span> از کدها استفاده می‌کند تا به طور واضح اهمیت پروژه‌ی خود را نشان دهد؛ نقشه‌نگاری [Cartography](https://github.com/robb/Cartography) مفید واقع می‌شود:

![Cartography README](/assets/images/finding-users/cartography.jpg)

برای درک بهتر مفهوم، مورد [Personas and Pathways](https://mozillascience.github.io/working-open-workshop/personas_pathways/) موزیلا <span dir="rtl">(Mozilla)</span> را برای توسعه‌ی پرسونای کاربران بررسی کنید

## مردم را در پیدا کردن و دنبال کردن پروژه‌ی خودتان یاری کنید

<aside markdown="1" class="pquote">
  شما ترجیحاً به یک <span dir="rtl">URL</span> (نشانی وب) نیاز دارید تا بتوانید پروژه‌ی خود را تبلیغ کنید و مردم را به آن مشتاق سازید. لازم نیست که قالب و یا حتی یک آدرس اینترنتی شیک و فانتزی داشته باشید، اما پروژه‌ی شما به یک نقطه‌ی توجه (مطلب اصلی و مهم) نیاز دارد.
  <p markdown="1" class="pquote-credit">
— Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

طوری باشد که با اشاره‌ای کوچک، مردم پروژه‌ی شما را به یاد بیاورند.

**برای توسعه‌ی پروژه‌ی خود، کاملا بر کار خویش آگاه و از آن اطمینان داشته باشید.** یک آدرس توییتری، آدرس <span dir="rtl">GitHub</span> یا کانال <span dir="rtl">IRC</span> راهی آسان برای مشایعت و هدایت افراد به سمت پروژه‌ی خودتان است. این رسانه‌ها همچنین به اجتماع در حال رشد پروژه‌ی شما، محلی برای تجمع و تبادل نظر می‌دهند.

اگر هنوز مایل به راه‌اندازی رسانه‌هایی برای پروژه‌ی خودتان نیستید، در همه‌ی کارهایی که انجام می‌دهید <span dir="rtl">Twitter</span> یا <span dir="rtl">GitHub</span> خود را ترویج دهید. توسعه و تبلیغ <span dir="rtl">Twitter</span> یا <span dir="rtl">GitHub</span> به مردم این امکان را می‌دهد تا با شما در ارتباط باشند یا کارهای شما را دنبال کنند. اگر در جلسه یا رویدادی صحبت می‌کنید، اطمینان حاصل کنید تا اطلاعات تماس شما در مشخصات شما یا اسلایدها آمده باشد.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  اشتباهی که در همان روزهای اولیه مرتکب به آن شدم، افتتاح نکردن یک حساب توییتر برای پروژه بود. توییتر راهی عالی برای به روز نگه داشتن مردم در مورد پروژه و همچنین نشان دادن پروژه به آدم‌های جدید است.
  <p markdown="1" class="pquote-credit">
— @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**ساخت وب‌سایتی را برای پروژه‌ی خود مد نظر قرار دهید.** داشتن وب‌سایت، پروژه‌ی شما را دوستانه‌تر و برای وب‌گردی و گشت‌زنی ساده‌تر می‌کند؛ به ویژه هنگامی که با مستندات و آموزش‌های واضح همراه باشد. داشتن یک وب سایت همچنین بیانگر این است که پروژه‌ی شما فعال است که همین باعث می‌شود مخاطبان شما احساس راحتی بیشتری در استفاده از آن داشته باشند. مثال‌هایی را ارائه دهید تا به افراد در مورد چگونگی استفاده از پروژه‌تان ایده بدهد.

[@Adrianholovaty](https://news.ycombinator.com/item?id=7531689)، یکی از سازند‌گان شرکت <span dir="rtl">Django</span> گفت که وب‌سایت «بهترین کاری بود که می‌توانستیم برای <span dir="rtl">Django</span> در آن روزهای اولیه انجام دهیم». اگر پروژه‌ی شما در <span dir="rtl">GitHub</span> باشد، می‌توانید با استفاده از [GitHub Pages](https://pages.github.com/)، به راحتی وب‌سایت ایجاد کنید. [Yeoman](http://yeoman.io/)، [Vagrant](https://www.vagrantup.com/)  و [Middleman](https://middlemanapp.com/) چند نمونه از وب‌سایت‌های عالی و جامع هستند.

![Vagrant homepage](/assets/images/finding-users/vagrant_homepage.png)

اکنون که برای پروژه‌ی خود رسالت و راهی آسان برای یافتن پروژه‌تان توسط مردم  دارید، وقت آن است که بیرون بزنیم و با مخاطبان ارتباط برقرار کنیم و با آن‌ها صحبت کنیم!

## هر جا که مخاطبان شما بودند، شما هم به آنجا بروید (آنلاین)

اطلاع‌رسانی آنلاین، روشی عالی برای به اشتراک گذاشتن و انتقال سریع اخبار و اطلاعات است. با استفاده از مجرا‌های آنلاین، این امکان را خواهید داشت که به مخاطبان بسیار گسترده‌ای دسترسی پیدا کنید.

برای دسترسی به مخاطبان خود از ارتباطات‌ و بسترهای آنلاین موجود استفاده کنید. اگر پروژه‌ی اوپن سورس شما پروژه‌ای نرم‌افزاری است، احتمالاً بتوانید مخاطبان خود را در [Stack Overflow](https://stackoverflow.com/) ،[Hacker News](https://news.ycombinator.com/)  یا [Quora](https://www.quora.com/) پیدا کنید. کانال‌هایی را پیدا کنید که فکر می‌کنید مردم در آن از کار شما بیشترین استفاده را می‌برند یا مشتاق آن هستند.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  هر برنامه‌ای، عملکرد بسیار خاص خود را دارد که فقط برای کسری از کاربران مفید واقع می‌شود. مردم را با تبلیغات بیش از حد برنامه، بمباران نکنید! درعوض، تلاش‌های خود را معطوف گروهی از افراد کنید که از مطلع شدن از پروژه‌ی شما بهره‌مند می‌شوند و برنامه برای آن‌ها مفید واقع می‌شود.
  <p markdown="1" class="pquote-credit">
— @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

ببینید آیا می‌توانید روش‌هایی برای به اشتراک گذاشتن پروژه خود به صورت متناسبی پیدا کنید:

* **با پروژه‌ها و انجمن‌های اوپن سورس مرتبط و مدنظرتان آشنا شوید.** گاهی اوقات، لازم نیست که مستقیماً پروژه‌ی خود را تبلیغ کنید. اگر پروژه‌ی شما برای متخصصین علم داده که از پایتون استفاده می‌کنند عالی است، با انجمن علوم داده‌ی پایتون ملاقات کنید و آشنا شوید. هنگامی که مردم با شما آشنا شوند، فرصت‌ها به صورت خودکار و طبیعی برای بحث و گفت و گو و به اشتراک گذاشتن کارهای شما بوجود می‌آید.
* **افرادی که مشکلاتی دارند و پروژه‌ی شما، آن مشکلات را حل و فصل می‌کند را پیدا کنید.**از طریق تالارهای گفتگوی (فروم‌ها) مرتبط، به جستجوی افرادی که می‌توانندمخاطبانِ هدفِ پروژه‌ی شما باشند، بپردازید. به سوالات آن‌ها پاسخ دهید و در زمانی مناسب، روشی مدبرانه تعبیه کنید تا پروژه‌ی خود را به عنوان یک راه‌حل پیشنهاد دهید.
* **از انتقادات و پیشنهادات روی‌گردان نباشید.** خود و کارهایتان را به مخاطب‌هایی مرتبط و متناسب که به کار شما علاقه دارند، معرفی کنید. مخاطبان خود را بشناسید و کسانی که از پروژه‌ی شما سود و منفعت حاصل می‌کنند را مشخص کنید. سعی کنید این جمله را کامل کنید:  «من فکر می‌کنم پروژه‌ی من واقعاً به <span dir="rtl">X</span>، که در تلاش برای انجام کار <span dir="rtl">Y</span> است، کمک خواهد کرد». به جای اینکه صرفاً فقط کار خود را تبلیغ کنید، به بازخورد دیگران گوش دهید و پاسخگو باشید.

به طور کلی، به کمک کردن به دیگران تمرکز کنید قبل از اینکه چیزهایی را در عوض درخواست کنید؛ چون که اگر هر کسی بخواهد پروژه‌های خودش را به صورت آنلاین تبلیغ کند، همهمه و شلوغی زیادی بر پا خواهد شد. برای اینکه در جمعی شناخته شوید، سعی کنید خود را به دیگران معرفی کنید و نه اینکه فقط آنچه که می‌خواهید را بازگو کنید.

اگر کسی به فعالیت‌های اولیه‌ی شما پاسخی نداد و یا توجه نکرد، ناامید نشوید! اکثر راه‌اندازی‌های پروژه‌ها، فرآیندهایی هستند که باید چندین و چند بار تکرار شوند که ممکن است ماه‌ها یا سال‌ها به طول انجامد. اگر بار اول پاسخی دریافت نکردید، تاکتیک دیگری را امتحان کنید یا ابتدا به دنبال روش‌هایی برای افزودن ارزش به کار دیگران باشید. راه‌اندازی و توسعه‌ی پروژه، به وقت و تعهد نیاز دارد.

## هر جا که مخاطبان شما بودند، شما هم به آنجا بروید (آفلاین)

![Public speaking](/assets/images/finding-users/public_speaking.jpg)

رویدادهای آفلاین، روشی متداول برای تبلیغ پروژه‌های جدید برای مخاطبان است. این رویدادها راهی عالی برای دستیابی به مخاطبان مشتاق و ایجاد ارتباطات انسانی عمیق‌تر هستند؛ به خصوص که اگر شما می‌خواهید با توسعه‌دهندگان ارتباط برقرار کنید.

اگر [تجربه‌ی چندانی در حوزه‌ی سخنرانی در عموم](https://speaking.io/), ندارید و تازه‌کار هستید، با پیدا کردن یک جلسه‌ی محلی که مرتبط با محتوا یا اکوسیستم پروژه‌ی خودتان است شروع کنید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  من از اینکه بخواهم به <span dir="rtl">«PyCon»</span> بروم، خیلی استرس داشتم. قرار بود که سخنرانی بکنم، قرار بود فقط با چند نفر در آنجا آشنا شوم، قرار بود یک هفته‌ی تمام آنجا می‌بودم. .... هر چند نیازی نبود که استرس داشته باشم. <span dir="rtl">PyCon</span>  فراتر از انتظارهایم فوق‌العاده بود! همگی به طرز خار‌ق‌العاده‌ای رفتاری دوستانه داشتند و خوش‌برخورد بودند، به قدری که من به ندرت وقت می‌کردم که با مردم صحبت نکنم!
  <p markdown="1" class="pquote-credit">
— @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

اگر قبلاً هرگز در رویدادی صحبت نکرده‌اید، اینکه استرس داشته باشید، کاملاً طبیعی است! به یاد داشته باشید که مخاطبان شما آنجا هستند زیرا واقعاً می‌خواهند در مورد کارهای شما بشنوند.
هنگام نوشتن سخنرانی خود، بر آنچه که مخاطبان جالب می‌پندارند و از آن ارزش و درسی می‌گیرند، تمرکز کنید. دوستانه و صمیمانه سخن بگویید. لبخند به لب داشته باشید، تنفس کنید و لذت ببرید.

هنگامی که کار را بر روی متن سخنرانی خود آغاز می‌کنید، خواه هر چه موضوع سخنرانی شما باشد، اگر سخنرانی خود را همانند داستانی که برای مردم تعریف می‌کنید تصور کنید، می‌تواند به شما کمک بسزایی بکند.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  وقتی احساس کردید که آماده‌اید، سخنرانی در کنفرانس‌ها به منظور تبلیغ پروژه‌ی خود را مد نظر قرار دهید. کنفرانس‌ها می‌توانند به شما کمک کنند تا به افراد بیشتری، گاهی اوقات از سراسر جهان، دسترسی پیدا کنید.
  <p markdown="1" class="pquote-credit">
— Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

به دنبال کنفرانس‌هایی باشید که مرتبط با محتوا یا اکوسیستم مورد نظر شما باشد. قبل از ارسال سخنرانی خود، در مورد کنفرانس تحقیق کنید تا سخنرانی خود را برای حاضران تنظیم و اصلاح کرده و در نتیجه شانس پذیرفته شدن برای سخنرانی در کنفرانس را افزایش دهید. شما همچنین می‌توانید با مراجعه به لیست سخنرانان کنفرانس، از نوع و کیفیت مخاطبان خود آگاه شوید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  من خیلی محترمانه برای مسئولان کنفرانس <span dir="rtl">JS</span> نامه نوشتم و از آن‌ها خواهش کردم تا نوبتی به من برای سخنرانی در کنفرانس <span dir="rtl">JS</span> اروپا به من بدهند. ...برای این سخنرانی که شش ماه بر روی آن کار کرده بودم، بسیار ترسیده بودم. ...فقط با خودم می‌گفتم، خدایا! من اینجا چیکار می‌کنم؟
  <p markdown="1" class="pquote-credit">
— @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## برای خود اعتبار و شهرت دست و پا کنید

علاوه بر استراتژی‌های ذکر شده در بالا، بهترین راه برای دعوت مردم برای به اشتراک‌‌گذاری و مشارکت در پروژه‌ی شما، اشتراک و مشارکت در پروژه‌های آن‌ها است.

کمک به تازه‌واردان، به اشتراک گذاشتن منابع و مشارکت مدبرانه در پروژه‌های دیگران به شما کمک می‌کند تا اعتبار خوبی برای خود بسازید. اگر عضوی فعال در اجتماع (انجمن) اوپن سورس باشید به شما کمک می‌کند تا مردم کار و محتوای شما را بشناسند و احتمال اینکه به پروژه شما توجه کنند و آن را به اشتراک بگذارند، بیشتر می‌شود. توسعه‌ی روابط با سایر پروژه‌های اوپن سورس، می‌تواند منجر به مشارکت و همکاری  رسمی شود.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
 تنها به خاطر درخواست‌های زیاد از <span dir="rtl">urllib3</span> است که <span dir="rtl">urllib3</span> محبوب‌ترین کتابخانه‌ی پایتون شخص ثالث <span dir="rtl">(third-party)</span> امروزی است.
  <p markdown="1" class="pquote-credit">
— @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

برای ایجاد و کسب اعتبار، هیچوقت خیلی زود و یا خیلی دیر نیست. حتی اگر پروژه‌ی خود را از قبل راه‌اندازی کرده‌اید، به جستجوی راه‌هایی برای کمک به دیگران ادامه دهید. برای ایجاد و جذب مخاطب، هیچ راه‌حل یک شبه‌ای وجود ندارد.

جلب اعتماد و احترامِ دیگران نیازمند زمان است و هیچ پایانی برای ایجاد و کسب اعتبار  وجود ندارد

## تسلیم نشوید!

ممکن است مدت‌ها طول بکشد تا اینکه مردم متوجه پروژه‌ی اوپن سورس شما شوند. هیچ اشکالی نداره! برخی از محبوب‌ترین پروژه‌های امروزی، برای رسیدن به سطح بالایی از فعالیت، سال‌ها به طول انجامید. به جای اینکه امیدوار باشید پروژه‌ی شما به طور خود به خود محبوبیت پیدا کند، بر ایجاد روابط متمرکز شوید. صبور باشید و مدام کار خود را با کسانی که قدر آن را می‌دانند به اشتراک بگذارید.
