---
lang: fa
title: منشور اخلاقی
description: با تصویب و اجرای منشور اخلاقی، رفتار سالم و سازنده را در انجمن (community) خود تسهیل کنید.
class: coc
order: 8
image: /assets/images/cards/coc.png
related:
  - building
  - leadership
---

## چرا به منشور اخلاقی نیاز داریم؟

منشور اخلاقی سندی است که انتظارات مربوط به رفتار را برای شرکت‌کنندگان پروژه تعیین میکند. تصویب و اجرای منشور اخلاقی می‌تواند به ایجاد جو اجتماعی مثبت و سازنده برای انجمن شما کمک کند.

منشور اخلاقی نه تنها از شرکت‌کنندگان پروژه بلکه از شما هم محافظت می‌کند. اگر شما از پروژه‌ای نگهداری می‌کنید، ممکن است متوجه شده باشید که نگرش‌های مخرب از طرف دیگر شرکت‌کنندگان باعث می‌شود در طول کار از کار خود خسته یا ناراضی شوید.

منشور اخلاقی این امکان را به شما می‌دهد تا رفتاری سالم و سازنده را در جامعه تسهیل کنید. داشتن نگرشی پیشگیرانه، احتمال اینکه شما یا دیگران از پروژه خسته شوید را کاهش می‌دهد و این امکان را برای شما فراهم می‌سازد تا وقتی کسی کاری را اشتباه انجام داد بتوانید با آن مقابله و جلوی آن را بگیرید.

## ایجاد منشور اخلاقی

سعی کنید هر چه زودتر منشور اخلاق را ایجاد کنید: در حالت ایده‌آل، هنگامی که پروژۀ خود را شروع می‌کنید.

علاوه بر ابلاغ انتظاراتی که دارید، منشور اخلاقی موارد زیر را شرح می‌دهد:

* منشور اخلاقی در چه جاهایی اعمال می‌شود _(فقط در مورد مشکلات و درخواست‌های pull، یا دیگر فعالیت‌های انجمن مانند رویدادها؟)_
* منشور اخلاقی برای چه کسانی اعمال می‌شود _(اعضای انجمن و نگه‌دارندگان، در مورد حامیان مالی چطور؟)_
* اگر کسی منشور اخلاقی را نقض کند چه اتفاقی می‌افتد؟
* چگونه می‌توان تخلفها را گزارش داد؟

در هر جا که می‌توانید، از دانش پیشین خود استفاده کنید. [عهدنامۀ مشارکت‌کنندگان](https://contributor-covenant.org/) نوعی منشور اخلاقی جا افتاده و مقبول است که بیش از 40،000 پروژۀ متن باز از جمله «Kubernetes»، « «Rails و «Swift» از آن استفاده می‌کنند.

[منشور اخلاقی Django](https://www.djangoproject.com/conduct/) و [منشور اخلاقی Citizen](http://citizencodeofconduct.org/) نیز دو نمونۀ خوب دیگر هستند.

فایل «منشور اخلاقی» را در فهرست اصلی پروژه قرار دهید و با لینک کردن آن با فایل‌های CONTRIBUTING یا README، آن را در دیدگاه انجمن خود قرار دهید.

## تصمیم‌گیری در مورد نحوۀ پیش بردن منشور اخلاقی

<aside markdown="1" class="pquote">
  منشور اخلاقی‌ای که اجرا نمی‌شود (یا نمی‌توان آن را اجرا کرد) بدتر از نبود هیچ منشور اخلاقی‌ای می‌باشد: نبود منشور اخلاقی این پیام را با خود به همراه دارد که ارزش‌های درج شده در منشور اخلاقی در انجمن شما مهم نیستد و مورد احترام واقع نمی‌شوند.
  <p markdown="1" class="pquote-credit">
— [Ada Initiative](https://webcache.googleusercontent.com/search?q=cache:YfqdTk5H9ikJ:https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community)
  </p>
</aside>

شما باید **قبل از وقوع** هر گونه تخلفی ابتدا توضیح دهید که منشور اخلاقی شما چگونه عملیاتی می‌شود. چندین دلیل برای اینکار وجود دارد:

* نشان می‌دهد که شما جدی هستید و در صورت لزوم اقدام می‌کنید.

* انجمن‌تان نسبت به بررسی شدن شکایات، اطمینان بیشتری پیدا می‌کند.

* به انجمن خود در صورت مرتکب شدن به تخلفی اطمینان خواهید داد که روند بازبینی منصفانه و شفاف خواهد بود.

شما باید روشی ویژه‌ای (مانند آدرس ایمیل) برای مردم فراهم آورید تا بتوانند تخلفات ناشی از منشور اخلاقی را گزارش دهند و توضیح دهند که چه کسی مرتکب تخلفات شده است. می‌تواند یک نگهدارنده، گروهی از نگهدارنده‌ها یا یک کارگروه ویژۀ منشور اخلاقی باشد.

فراموش نکنید که ممکن است کسی بخواهد در مورد شخصی که این گزارشات را دریافت می‌کند تخلفی را گزارش دهد. در این صورت، برای آن‌ها گزینه‌ای تعبیه کنید تا بتوانند تخلفات را به شخص دیگری گزارش دهند. به عنوان مثال، @ctb و @mr-c در مورد [پروژۀ خود «khmer»](https://github.com/dib-lab/khmer) می‌گویند: 

> مواردی از سوءرفتار، آزار و اذیت و رفتارهای غیر‌قابل‌قبول را می توان با ایمیل زدن به **khmer project@idyll.org** گزارش داد که فقط «C. Titus Brown» و Michael R. Crusoe» به آن دسترسی دارند. برای گزارش مسئله‌ای در رابطه با هر کدام از آن‌ها، لطفاً به **Judi Brown Clarke** دکترای مدیریت در مرکز «BEACON» برای مطالعۀ تکامل در عمل، مرکز علوم و فناوری «NSF» ایمیل بزنید.

برای ایده گرفتن، به [کتابچۀ راهنمای اجرای](https://www.djangoproject.com/conduct/enforcement-manual/) «Django» مراجعه کنید (اگرچه ممکن است بنا به اندازه پروژۀ خود، نیازی به چنین کتابچۀ جامعی نداشته باشید).

## عملیاتی کردن منشور اخلاقی

گاهی اوقات علی‌رغم تلاشی که می‌کنید، شخصی کاری خلاف منشور اخلاقی انجام می‌دهد. روش‌های مختلفی برای پرداختن و عکس‌العمل نشان دادن به رفتار منفی و مضر در هنگام بروز آن وجود دارد.

### جمع‌آوری اطلاعات در مورد وضعیت

با هر یک از اعضای انجمن خود، رفتاری یکسان داشته باشید. اگر گزارشی منوط بر نقص منشور اخلاقی دریافت کردید، آن را جدی بگیرید و موضوع را بررسی کنید، حتی اگر با آن شخص رابطه‌ای نزدیک دارید. با این کار به انجمن خود نشان می‌دهید که برای دیدگاه آن‌ها ارزش قائل هستید و به قضاوت آن‌ها اعتماد دارید.

آن عضو خطاکار انجمن ممکن است اولین بار نباشد که مرتکب به خطایی شده و به طور مداوم دیگران را ناراحت می‌کند، یا ممکن است اولین بار آن‌ها باشد. بسته به خطایی که مرتکب می‌شوند، اقدامات لازمی باید اجرا شود.

قبل از عکس‌العمل نشان دادن، زمان کافی را برای فهمیدن کامل ماجرا صرف کنید. نظرات و گفتگوهای مربوط به گذشتۀ شخص را بررسی کنید تا آن‌ها را بهتر بشناسید و  متوجه شوید چرا ممکن است چنین رفتاری از آن‌ها سر بزند. سعی کنید دیدگاه‌های دیگری را غیر از دیدگاه‌های خودتان دربارۀ این فرد و رفتار او جمع‌آوری کنید.

<aside markdown="1" class="pquote">
  وارد بحث و جدل با شخص نشوید. قبل از اتمام شدن رسیدگی به موضوع مورد بحث، وارد موضوع دیگر و رسیدگی به شخص دیگری نشوید. بر آنچه که نیاز هست تمرکز کنید.
  <p markdown="1" class="pquote-credit">
— Stephanie Zvan, ["So You've Got Yourself a Policy. Now What?"](https://the-orbit.net/almostdiamonds/2014/04/10/so-youve-got-yourself-a-policy-now-what/)
  </p>
</aside>

### اقداماتی مناسب به کار ببرید

پس از جمع آوری و بررسی اطلاعات کافی، باید تصمیم بگیرید که چه کاری انجام دهید. همانطور که به قدم بعدی می‌اندیشید، به یاد داشته باشید که هدف شما به عنوان ناظر، ایجاد محیطی امن، محترم و فضایی مشارکتی است. در نظر داشته باشید که تنها مسئلۀ چگونگی برخورد در آن موقعیت مهم نیست، بلکه چگونگی پاسخ و عکس‌العمل شما در آینده‌ی رفتار و انتظارات افراد حاضر در انجمن شما تأثیر می‌گذارد.

وقتی کسی گزارشی منوط بر تخلف در منشور اخلاقی می‌دهد، رسیدگی به آن وظیفۀ شماست و نه خود او. گاهی اوقات، فرد گزارش‌دهنده با افشای این اطلاعات، آیندۀ شغلی، اعتبار یا ایمنی خود را ممکن است در معرض خطر بزرگی قرار دهد. وادار کردن آن‌ها به مقابله کردن با فرد مزاحم و خاطی می‌تواند فرد گزارش‌دهنده را در موقعیتی مخاطره‌آمیز قرار دهد. شما باید شخصا ارتباط مستقیم با فرد خاطی مورد نظر را مدیریت کنید، مگر اینکه فرد گزارش‌دهنده صریحاً خلاف آن را درخواست کند.

چند روش وجود دارد که شما می‌توانید با استفاده از آن‌ها با موارد نقض منشور اخلاقی برخورد کنید:

* **به شخص مورد نظر ترجیحاً به طور مشخص‌ و واضح اخطار عمومی دهید** و توضیح دهید که چگونه رفتار او بر دیگران تأثیر منفی می‌گذارد. اخطار به صورت عمومی به بقیۀ افراد انجمن این پیام را می‌رساند که منشور اخلاقی را جدی می‌گیرید. در مکالمه‌های خود خوش‌برخود باشید ولی جدی بمانید.

* **به طور خصوصی با شخص مورد نظر صحبت بکنید** تا توضیح دهید که چگونه رفتار او بر دیگران تأثیر منفی می‌گذارد. اگر موقعیت طوری باشد که اطلاعات حساس شخصی فرد در میان باشد، بهتر است از کانال‌های ارتباطی خصوصی استفاده کنید. اگر با شخص به طور خصوصی صحبت می‌کنید، بهتر است کسانی را که برای اولین بار وضعیت را گزارش کرده‌اند مطلع کنید تا بدانند که اقدام کرده‌اید. قبل از پیگیری کردن گزارش مربوطه، از شخص گزارش‌دهنده رضایت بگیرید.

گاهی اوقات، نمی‌توان به نتیجه‌ای قطعی رسید. فرد مورد نظر ممکن است در مواجهه با او پرخاشگر یا خصمانه برخورد کند یا  تغییری در رفتار خود ایجاد نکند. در این شرایط، ممکن است بخواهید اقدامات جدی‌تری را در نظر بگیرید. مثلا:

* **فرد مورد نظر را از ادامۀ همکاری در پروژه تعلیق کنید**، که از طریق منع موقت یا شرکت در هر جنبه‌ای از پروژه اعمال می‌شود

* **فرد مورد نظر را به طور دائمی** از ادامۀ همکاری در پروژه تعلیق کنید

منع کردن اعضا نباید امری ساده تلقی شود و باید نشان‌دهندۀ اختلاف دائمی در دیدگاه و آشتی‌ناپذیری تلقی شود. این اقدامات را فقط باید در مواقعی پیش بگیرید که مشخص باشد امکان دستیابی به نتیجه‌ای قطعی وجود ندارد.

## وظایف شما به عنوان یک نگهدارنده

منشور اخلاقی آیین‌نامه‌ای نیست که به صورت خودسرانه اجرا شود. شما مجری منشور اخلاقی هستید و مسئولیت پیروی از قوانین تعیین شده به وسیله‌ی منشور اخلاقی از وظایف شماست.

شما به عنوان نگهدارنده، دستورالعمل‌هایی را برای انجمن خود تعیین می‌کنید و آن دستورالعمل‌ها را مطابق با قوانین مندرج در منشور اخلاقی اجرا می‌کنید. این به معنای جدی گرفتن هر گونه گزارش مربوطی به نقض منشور اخلاقی است. گزارش فرد گزارش‌دهنده باید کاملا جامع و منصفانه بررسی شود. اگر تشخیص دادید رفتاری که آن‌ها گزارش داده‌اند، نقض منشور اخلاقی نیست، این مسئله را به وضوح با آن‌ها در میان بگذارید و توضیح دهید که چرا در این زمینه اقدامی نمی‌کنید. عکس‌العملی که نشان می‌دهند به خودشان مربوط است: باید رفتاری که آن‌ها با آن روبرو بوده‌اند را تحمل کنند یا مشارکت‌شان در انجمن را متوقف سازند.

گزارش رفتاری که در واقع منشور اخلاقی شما را نقض نمی‌کند، همچنان نشان‌دهندۀ مشکلی در انجمن شما است و شما باید این مشکل بالقوه را بررسی کرده و چاره‌ای برای آن پیدا کنید. که این ممکن است شامل بازنگری در منشور اخلاقی برای روشن ساختن رفتار قابل‌قبول یا صحبت با شخصی باشد که رفتار وی گزارش شده است و شما باید به فرد بگویید که اگرچه منشور اخلاقی را نقض نکرده‌اند، اما دارند در لبۀ آنچه که از آن‌ها انتظار می‌رود راه می‌روند و موجب ناراحتی در برخی از شرکت‌کنندگان شده‌اند.

موضوع مهم این است که شما به عنوان یک نگهدارنده، باید استانداردهای رفتار قابل‌قبول را تعیین و عملیاتی کنید. شما توانایی شکل دادن به ارزش‌های اجتماعی پروژه را دارید و شرکت‌کنندگان انتظار دارند که شما این ارزش‌ها را به صورت منصفانه و یکسان اجرا کنید.

## ترغیب‌کنندۀ رفتاری باشید که می‌خواهید در دنیا آن را مشاهده کنید 🌎

هنگامی که یک پروژه خصمانه یا ناخوشایند به نظر می‌رسد، حتی اگر فقط یک نفر باشد که رفتار او غیرقابل‌تحمل باشد، ممکن است مشارکت‌کنندگان بیشتری را از دست بدهید که حتی ممکن است بعضی از آن‌ها را هرگز ملاقات نکرده باشید. اتخاذ یا اجرای منشور اخلاقی همیشه ساده نیست، اما ایجاد فضایی دوستانه به رشد انجمن شما کمک می کند.
