---
lang: fa
title: ساخت انجمن های پذیرا
description: ساخت یک انجمن که افراد را به استفاده کردن ، اشتراک گذاری و تبلیغ کردن پروژه تان ترغیب کند.
class: building
order: 4
image: /assets/images/cards/building.png
related:
  - best-practices
  - coc
---

## پروژه تان  را برای موفقیت راه اندازی کنید

وقتی شما پروژه خود را راه اندازی کنید، مطالبی را پخش می کنید و افراد در حال بررسی آنها هستند. حالا سوال اینجا است که چطور باید از آنها بخواهید که در انتظار مطالب‌تان باشند؟

یک انجمن پذیرا ، یک نوع سرمایه گذاری برای شهرت و آینده پروژه تان است. اگر پروژه تان در حال آغاز کسب مشارکتهای اولیه اش است، با اعطای یک تجربه مثبت به مشارکت کننده های اولیه شروع کنید، و برای آنها به عقب برگشتن را ساده سازید

### کاری کنید تا افراد احساس پذیرفته شدن داشته باشند

یک راه برای تفکر درباره انجمن پروژه تان از طریق آنچه مایک مک کویید آن را [قیف مشارکت کننده](https://mikemcquaid.com/2018/08/14/the-open-source-contributor-funnel-why-people-dont-contribute-to-your-open-source-project/) می نامد میسر است.

![Contributor funnel](/assets/images/building-community/contributor_funnel_mikemcquaid.png)

در حین اینکه شما انجمن خود را می سازید، در نظر بگیرید چطور فردی در بالای قیف( یک کاربر بالقوه) می تواند از لحاظ نظری راهش را به ته قیف ( یک نگهدارنده فعال) هموار سازد. هدف شما این است که ناسازگاری در هر مرحله تجربه مشارکت کننده را کاهش دهید. وقتی افراد، بردهای آسانی دارند، آنها انگیزه بیشتری برای ادامه کار دارند.

با مستندات خود شروع کنید:

* **برای افراد استفاده از پروژه خود را ساده سازید:** یک مثال از آن کد واضح و [README دوستانه](../starting-a-project/#نوشتن-راهنمای-مشارکت) است که راه اندازی پروژه تان را برای هر کسی هموارتر می سازد.
* **بطور واضح توضیح دهید که مشارکت چگونه است،** البته این کار با استفاده از [فایل مشارکت](../starting-a-project/#نوشتن-راهنمای-مشارکت) و به روز نگه داشتن موضوعات میسر است.

* **موضوعات اولیه خوب:** برای کمک کردن به اینکه مشارکت کنندگان جدید کار خود را شروع کنند، [برچسب زدن به موضوعاتی که برای موفقیت مبتدی ها به قدر کافی ساده هستند](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels) را بطور آشکار لحاظ کنید. سپس <span dir="rtl">GitHub</span> ، این موضوعات را در محل های مختلف روی پلتفورم هموار می سازد، و مشارکت های مفید را افزایش می دهد و سپس ناسازگاری از کاربران مختلف در فائق آمدن بر موضوعاتی که در سطح آنها خیلی دشوار است را کاهش می دهد.

[نظرسنجی منبع باز( اوپن سورس) 2017 <span dir="rtl">GitHub</span>](http://opensourcesurvey.org/2017/) که مستندات ناقص و گیچ کننده ای را نشان می داد، بزرگترین مشکل برای کاربران منبع باز می باشد. مستندات خوب، افراد را دعوت می کند که با پروژه‌تان تعامل کنند. در نهایت افراد یک موضوع یا یک درخواست <span dir="rtl">pull</span>( ادغام یا یکپارچگی) را باز خواهند کرد. از این تعاملات به عنوان فرصتهایی برای سوق دادن آنها به پایین قیف استفاده کنید.

* **وقتی شخص جدیدی وارد پروژه شما می شود، از وی از روی علاقه تشکر کنید!** این یک تجربه منفی خواهد بود که از فردی بخواهید که به پروژه تان برنگردد.
* **پاسخگو باشید:** اگر شما به موضوعاتشان در عرض یک ماه پاسخ نمی دهید، شانس اینکه پروژه تان را فراموش کنند بالا می رود.
* **درباره انواع مشارکت هایی که خواهید پذیرفت ، پذیرای عقاید و افکار جدید باشید.** بسیاری از مشارکت کننده ها با یک گزارش باگ یا ترمیم جزئی آغاز می کنند. راه های زیادی برای مشارکت در یک پروژه وجود دارد. به افراد اجازه دهید تا بازگو کنند [چطور می خواهند مساعدت کنند](../how-to-contribute/#مشارکت-به-چه-معناست).
* **اگر یک مشارکتی وجود دارد که شما با آن مخالف هستید،** از آنها به خاطر بیان ایده تشکر کرده و [توضیح دهید](../best-practices/#نه-گفتن-را-یاد-بگیرید) چرا آن ایده با محدوده پروژه تان تناسب ندارد، و اگر مستندات خوبی دارید رو کنید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  مشارکت کردن در پروژه منبع باز برای برخی نسبت به دیگران آسانتر است. ترس زیادی از مورد سرزنش قرار گرفتن به خاطر انجام غلط کاری یا کار نامتناسب وجود دارد، با اعطای یک محل به مشارکت کنندگان با مهارت فنی خیلی کم ( از لحاظ مستندات و محتوای وب و غیره) تا در پروژه تان کمک کنند می توانید تا حد زیادی این نگرانی ها را کاهش دهید.
  <p markdown="1" class="pquote-credit">
— @mikeal, ["Growing a contributor base in modern open source"](https://opensource.com/life/16/5/growing-contributor-base-modern-open-source)
  </p>
</aside>

اکثریت مشارکت کنندگان منبع باز، مشارکت کنندگان اتفاقی هستند: افرادی که تنها گهگاه در یک پروژه مشارکت می کنند. یک مشارکت کننده اتفاقی شاید زمان کافی برای همگامی با پروژه تان را نداشته باشد، پس کارتان این است که مشارکت را برای او تا حد ممکن ساده تر سازید.

ترغیب کردن مشارکت کنندگان دیگر یک سرمایه گذاری روی خودتان می باشد. وقتی شما بزرگترین طرفدارانتان را توانمند می سازید تا با کاری که آنها با انجامش هیجان زده می شوند همگام شوند، فشار کمی برای انجام کامل کار توسط خودتان اعمال می شود.

### مستند کردن همه چیز

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  آیا شما تاکنون در یک رویداد (فناوری) بوده اید که در آن  هیچ کس را نشناسید، اما افراد دیگر همدیگر را می شناسند و با دوستان قدیمیشان چت می کنند؟ (...) حالا  تصور کنید می خواهید در یک پروژه منبع باز مشارکت کنید، اما چرایی و چگونگی رخ دادن آن را نمی بینید.
  <p markdown="1" class="pquote-credit">
— @janl, ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

وقتی شما یک پروژه جدید را آغاز می کنید، شاید احساس طبیعی تان این باشد که کارتان را باید خصوصی ادامه دهید. اما پروژه های منبع باز هنگامی شما را برمی انگیزند که شما پروسه تان را بطور علنی مستند می سازید.

وقتی شما کارها را می نویسید، افراد بیشتری می توانند در هر مرحله از رویه ها مشارکت کنند. شما ممکن است درباره چیزی کمک بخواهید چیزی که حتی در حد لزوم هم آن را نمی دانستید.

مکتوب کردن چیزها معنایی بیشتر از مستندسازی فنی صرف دارد. هر زمان شما احساس می کنید که مصر هستید تا کاری را مکتوب کنید یا بطور خصوصی پروژه تان را بحث کنید، از خودتان بپرسید که آیا می توانید آنرا علنی کنید یا نه؟

درباره نقشه مسیر پروژه تان ، انواع مشارکت هایی که شما در پی آنها هستید، اینکه چطور مشارکت ها بررسی می شوند یا اینکه چرا تصمیمات خاصی را اتخاذ می کنید ، شفاف سازی کنید.

اگر شما کاربران متعددی را مطلع سازید تا مسئله مشابهی را بررسی کنند، جوابها را در <span dir="rtl">README</span> مستند سازید.

برای جلسات، منتشر کردن یادداشت ها و نقشه های مسیر خود در یک موضوع مرتبط را مدنظر قرار دهید. بازخوردی که از این سطح از شفافیت کسب می کنید شاید شما را شگفت زده کند.

مستندسازی همه چیزها با کاری که شما انجام می دهید نیز همگام است. اگر شما در حال کار بر روی آپدیت کردن پروژه تان در حجم زیاد هستید، برای آن یک بخش درخواست <span dir="rtl">pull</span> اعمال کنید و آن را به عنوان کاری که در حال پیشرفت است نمره دهید <span dir="rtl">(WIP)</span> .از این طریق، افراد دیگر می توانند در پروسه شما اعمال نظر کنند

### پاسخگو باشید

در حین اینکه شما [پروژه تان را ارتقا می دهید](../finding-users)، افراد شاید بازخوردهایی برای شما داشته باشند. آنها ممکن است درباره اینکه چطور موارد کار می کنند سوالاتی داشته باشند، یا برای شروع نیاز به کمک داشته باشند.

سعی کنید که هنگامی که شخصی یک موضوع را پیوست می کند، تحویل می دهد یا درخواستی دارد یا درباره پروژه تان سوالی می پرسد پاسخگو باشید. وقتی شما به سرعت پاسخ دهید، افراد احساس خواهند کرد که آنها بخشی از یک گفتگو هستند و درباره مشارکت با شما مشتاق تر خواهند بود.

حتی اگر نمی توانید درخواستشان را فوراً بررسی کنید،حداقل از آنها تشکر کنید تا به افزایش مشارکت کمک کرده باشید. اینجا بیان می شود چطور @tdreyno به یک درخواست <span dir="rtl">pull</span> در سایت [Middleman](https://github.com/middleman/middleman/pull/1466) پاسخ داده است:

![Middleman pull request](/assets/images/building-community/middleman_pr.png)

[در‌یک مطالعه موزیلا](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) پی برده است که مشارکت کنندگانی که بررسی های کدگونه را در ظرف 48 ساعت دریافت کرده بودند میزان برگشت و تکرار مشارکت خیلی بیشتری داشتند

همچنین مکالمات درباره پروژه تان می تواند در محل های دیگری در اینترنت مانند <span dir="rtl">Stackverflow</span> ، توییتر، یا <span dir="rtl">Reddit</span> روی دهد. شما می توانید در برخی از این محل ها نوتیفیکیشن هایی را اجرا کنید و بدین طریق هنگامی که شخصی به پروژه تان اشاره می کند، با خبر شوید.

### محلی برای مشارکت کردن انجمن تان اختصاص دهید

دو دلیل برای اعطای یک محل برای مشارکت در انجمن‌تان وجود دارد.

اولین دلیل به خاطر مشارکت کنندگان است. به افراد کمک کنید تا همدیگر را بشناسند. افراد دارای منافع مشترک، بطور اجتناب ناپذیری می خواهند که محلی برای گفتگو درباره آن منافع داشته باشند و وقتی ارتباطات علنی و قابل دسترس باشد، هر کسی می تواند آرشیوهای گذشته را بخواند تا به مشارکت خود شتاب بخشد.

دلیل دوم به خاطر خود شما است. اگر شما به افراد محل عمومی برای صحبت درباره پروژه تان ندهید، آنها احتمالاً با شما مستقیماً تماس خواهند گرفت. در شروع، ظاهراً ساده است که به پیامهای خصوصی  با موضوع « فقط این بار»پاسخ دهید. اما در طول زمان مخصوصاً اگر پروژه تان معروف شود، شما کلافه خواهید شد. در برابر وسوسه ارتباط برقرار کردن با افراد درباره پروژه تان بطور خصوصی مقاومت کنید. در عوض آنها را به یک کانال عمومی معین هدایت کنید.

ارتباطات عمومی می تواند در حقیقت هدایت کردن مردم برای باز کردن یک موضوع به جای ایمیل مستقیم یا اظهار نظر کردن روی وبلاگ‌تان باشد. همچنین شما می توانید یک لیست مِیلی داشته باشید، یا یک حساب توییتر، <span dir="rtl">Slack</span> یا کانال <span dir="rtl">IRC</span> برای افراد راه بیاندازید تا درباره پروژه تان گفتگو کنند. یا همه موارد بالا را با هم اعمال کنید!

[Kubernetes kops](https://github.com/kubernetes/kops#getting-involved) هر هفته وقت خود را در ساعات اداری به کمک به اعضای انجمن اختصاص می دهد:

> همچنین کاپس هر هفته زمانی را برای پیشنهاد دادن کمک و راهنمایی به انجمن اختصاص می دهد. مالکان کاپس با اختصاص زمان اختصاصی برای کار کردن با تازه واردها، کمک به <span dir="rtl">PRs</span> ، و بحث درباره ویژگی های جدید موافقت کرده اند.

استثنائات قابل توجهی در مورد ارتباطات عمومی وجود دارد از قبیلِ: موضوعات امنیتی و نقض کدهای رفتاری حساس. شما باید همیشه راهی پیش پای افراد بگذارید تا این موضوعات را بطور خصوصی گزارش کنند. اگر نمی خواهید که از ایمیل شخصی خود استفاده کنید، یک آدرس ایمیل اختصاصی ایجاد کنید.

## انجمن‌تان را رشد دهید

انجمنها بی نهایت قدرتمند هستند. این قدرت می تواند مفید یا مضر باشد که به این بستگی دارد که چطور آن را اعمال می کنید. در حین اینکه انجمن پروژه تان رشد می کند، راه هایی برای کمک به آن وجود دارد تا به جای نیروی مخرب یک نیروی سازنده باشد.

### بازیگران بد را تحمل نکنید

هر پروژه معروفی ناگزیر افرادی که ضرررسان هستند را نیز جذب خواهد کرد. آنها شاید بحثهای غیرضروری را شروع کنند، درباره ویژگی های جزئی خرده گیری کنند یا برای بقیه قلدری کنند.

شما به بهترین نحو تلاش کنید تا یک خطی مشی تحمل-صفر نسبت به این نوع افراد اقتباس کنید. اگر افراد منفی را چک نکنید ، افراد دیگر در جامعه تان را نیز ناراحت خواهند ساخت. آنها حتی شاید پروژه تان را ترک کنند.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/okdistribute?s=180" class="pquote-avatar" alt="avatar">
  حقیقت این است که داشتن یک جامعه حامی بسیار حیاتی است. من هرگز قادر به انجام چنین کاری بدون کمک همکارانم، غریبه هایی که در اینترنت و کانال های <span dir="rtl">IRC</span> چت با آنها دوست شدم نبودم(...). البته نباید به دون مایه ها و عوضی ها اکتفا نمود.
  <p markdown="1" class="pquote-credit">
— @okdistribute, ["How to Run a FOSS Project"](https://okdistribute.xyz/post/okf-de)
  </p>
</aside>

بحثهای دائمی بر روی جنبه های جزئی پروژه تان، افرا دیگر از جمله خود شما را از تمرکز روی کارهای مهم دیگر بازمی دارد. افراد جدیدی که وارد پروژه تان می شوند شاید این مکالمات را ببینند و در نتیجه مشارکت نکنند.

وقتی می بینید رفتار منفی‌ای در پروژه تان رخ می دهد، آن را علنی کنید. با لحن قاطع توضیح  دهید که چرا رفتارشان قابل قبول نیست. اگر این مسئله دائماً وجود داشت شاید نیاز داشته باشید که از [آنها بخواهید تا پروژه تان را ترک کنند](../code-of-conduct/#عملیاتی-کردن-منشور-اخلاقی). [کد رفتاری‌تان](../code-of-conduct/) می تواند یک رهنمود سازنده برای این مکالمات باشد.

### با مشارکت کنندگان تماس بگیرید و در جریان قرار بگیرید که آنها در کجای کار هستند

مستندسازی خوب تنها هنگامی مهمتر می شود که انجمن تان رشد می کند. مشارکت کنندگان اتفاقی که ممکن است با پروژه تان آشنا نباشند ، مستنداتتان را می خوانند تا به سرعت متنی که آنها نیاز دارند را بدست آورند.

در فایل <span dir="rtl">Contributing</span> خود، بطور آشکار به مشارکت کنندگان جدید بگویید که چگونه کار خود را شروع کنند. شما شاید حتی بخواهید که یک بخش اختصاصی برای این منظور بسازید. برای مثال [Django](https://github.com/django/django) یک صفحه ویژه برای خوشامدگویی به مشارکت کنندگان جدید دارد

![Django new contributors page](/assets/images/building-community/django_new_contributors.png)

در صف موضوعتان ، باگهایی که برای انواع مختلف مشارکت کنندگان مناسب هستند، وجود دارد: برای مثال [_تنها اولین دفعه_](https://kentcdodds.com/blog/first-timers-only) ، « اولین موضوع خوب» یا « مستندات» را برچسب بزنید. این برچسب ها برای فرد جدید، بررسی سریع پروژه و شروع به کار بر روی موضوعاتتان را آسان می سازد

سرانجام از مستندات‌تان استفاده کنید تا افراد را در هر مرحله از این رویه خرسند سازید.

شما هرگز با اکثر افرادی که وارد پروژه تان می شوند تعامل نخواهید کرد. شاید مشارکتهایی وجود داشته باشد که آنها را دریافت نکرده اید چون برخی از افراد نمی دانند از کجا باید مشارکت خود را شروع کنند. حتی کلمات کمی وجود دارند که با آن می توان افراد را از ترک کردن پروژه تان به خاطر اشباع شدن بازداشت.

برای مثال، در اینجا ما [رهنمودهای مشارکت](https://github.com/rubinius/rubinius/blob/HEAD/.github/contributing.md) پروژه [روبینیوس](https://github.com/rubinius/rubinius/) را می آوریم:

> ما می خواهیم که کار خود را با قدردانی از شما برای استفاده از روبینیوس شروع کنیم. این پروژه یک کار عاشقانه است و ما از همه کاربرانی که باگها را معرفی می کنند، عملکردها را بهبود می دهند و به مستندسازی کمک می کنند، قدردانی می کنیم. هر مشارکتی مهم است پس از شما برای مشارکت سپاسگزاری می کنیم. اینکه گفته می شود اینجا رهنمودهای کمی وجود دارند که ما از شما بخواهیم تا از آنها پیروی کنید، می تواند باعث موفقیت رسیدگی به موضوعتان شود.

### مالکیت پروژه تان را به اشتراک بگذارید

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/sagesharp?s=180" class="pquote-avatar" alt="avatar">
  رهبرانتان، عقاید متفاوتی دارند همانطوری که همه جوامع سالم آن را می طلبند! البته شما باید گامهایی را برای تضمین این مطلب بردارید که بلندترین صدا همیشه به خاطر رنجاندن مردم همیشه پیروز نیست و اینکه صداهای اقلیت و کمتر برجسته نیز شنیده خواهند شد.
  <p markdown="1" class="pquote-credit">
— @sagesharp, ["What makes a good community?"](https://sage.thesharps.us/2015/10/06/what-makes-a-good-community/)
  </p>
</aside>

افراد با مشارکت در پروژه هایتان هنگام احساس مالکیت بر آن، هیجان زده می شوند. این بدان معنی نیست که شما باید چشم انداز پروژه تان را تغییر دهید یا مشارکتهایی که شما نمی خواهید را بپذیرید. اما هرچه به دیگران اعتبار بیشتری ببخشید، آنها بیشتر انتظار آن را می کشند.

ببینید آیا می توانید تا آنجا که ممکن است راه هایی را برای تسهیم مالکیت با انجمن تان بیابید. در اینجا بعضی ایده ها در این باره ارائه می شوند:

* **در برابر رفع باگ های ( غیرسرنوشت ساز) ساده مقاومت کنید:** در عوض از آنها به عنوان فرصتهایی برای پذیرش مشارکت کنندگان جدید استفاده کنید، یا شخصی که تمایل به مشارکت دارد، را راهنمایی کنید. شاید در اول غیرطبیعی به نظر برسد، اما سرمایه گذاری‌تان در طول زمان بازدهی‌اش را به تدریج بدست خواهد داد. برای مثال،<span dir="rtl">@michaeljoseph</span> از یک مشارکت کننده خواست تا درخواست <span dir="rtl">pull</span> خود را درباره موضوع [Cookiecutter](https://github.com/audreyr/cookiecutter) به جای تعمیر آن توسط خودش ارائه دهد.

![Cookiecutter issue](/assets/images/building-community/cookiecutter_submit_pr.png)

* **یک فایل مشارکت کننده یا مولف در پروژه تان را شروع کنید** تا همه افرادی که به پروژه تان کمک می کردند مانند [Sinatra](https://github.com/sinatra/sinatra/blob/HEAD/AUTHORS.md) را لیست کنید.

* **اگر شما یک انجمن بزرگ دارید، یک خبرنامه منتشر کنید یا یک پست وبلاگی بنویسید** که قدردان مشارکت کنندگان هستید. خبرنامه های [This Week in Rust](https://this-week-in-rust.org/) و [Shoutouts](http://hood.ie/blog/shoutouts-week-24.html) هودی دو نمونه خوب از این موارد هستند.

* **به همه مشارکت کنندگان دسترسی <span dir="rtl">Commit</span> کردن بدهید.** <span dir="rtl">@fleixge</span> پی برد که این کار، [افراد را وادار می کند](https://felixge.de/2013/03/11/the-pull-request-hack.html) تا با هیجان بیشتری <span dir="rtl">patch</span> هایشان را اصلاح کنند و حتی باعث می شود اعضای جدید برای پروژه هایی بیابید که روی آنها سرمایه گذاری نکرده بودید.

* اگر پروژه تان روی گیت هاب است، **آن را از حساب شخصی خود به یک [سازمان](https://help.github.com/articles/creating-a-new-organization-account/) انتقال دهید** و حداقل یک ادمین پشتیبان به آن بیافزایید. سازمان ها کار کردن روی پروژه هایی با همکاران خارجی را آسانتر می سازند.

واقعیت این است که [اکثر پروژه ها](https://peerj.com/preprints/1233/) تنها دارای یک یا دو عضو هستند کسانی که اکثر کار را انجام می دهند. هرچه پروژه تان بزرگتر باشد، و هرچه انجمن تان بزرگتر باشد، دستیابی به کمک ساده تر خواهد بود.

در حالی که شاید همیشه شخصی را برای جواب دادن به تماس ها نیابید، اما فرستادن سیگنالهایی به آنجا شانسی که افراد دیگر در پروژه همکاری بکنند را افزایش خواهد داد. و اینکه هرچه زودتر اقدام کنید، افراد زودتر می توانند به شما کمک کنند.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gr2m?s=180" class="pquote-avatar" alt="avatar">
  به بهترین وجه به نفعتان است که مشارکت کنندگانی را به عضویت بگیرید که از کارشان لذت می برند و کسانی که قادر به انجام کارهایی هستند که شما نمی توانید انجام دهید. آیا شما از کدگذاری لذت می برید، اما از جواب دادن به موضوعات لذت نمی برید؟ پس آن افرادی را در انجمن خود شناسایی کنید که این کارها را انجام می دهند.
  <p markdown="1" class="pquote-credit">
— @gr2m, ["Welcoming Communities"](http://hood.ie/blog/welcoming-communities.html)
  </p>
</aside>

## حل و فصل تضادها

در مراحل اولیۀ پروژه تان، اتخاذ کردن تصمیمات بزرگ ساده است. وقتی می خواهید که کاری را انجام دهید، شما فقط مشغول انجام آن شوید.

در حین اینکه پروژه تان معروف تر می شود، مردم بیشتری از تصمیماتی که شما اتخاذ می کنید سود می برند. حتی اگر انجمن بزرگی از مشارکت کنندگان را ندارید، و اگر پروژه تان دارای کاربران زیادی نیست، شما افرادی را خواهید یافت که تصمیمات را می سنجند و موضوعاتی مرتبط با خودشان را مطرح می کنند.

برای اکثر بخش ها، اگر شما یک انجمن محترم و صمیمی را پرورش می دهید و پروسه تان را علنی مستندسازی کنید، انجمن تان باید قادر باشد تا راه حل را پیدا کند. اما گاهی اوقات شما موضوعی را مطرح می کنید که پرداختن به آن یک کمی دشوارتر است.

### قالبی برای نوع دوستی تعیین کنید

وقتی انجمن تان با یک موضوع خاص مواجه است، مجرب ها ممکن است داوطلب شوند. افراد ممکن است عصبی شوند یا اشباع شوند و آن وظیفه را به شما یا دیگری محول کنند.

کارتان به عنوان یک نگاهدارنده آن است که از وخیم تر شدن شرایط جلوگیری کنید. حتی اگر شما عقیده قوی‌ای به این موضوع دارید، سعی کنید که جایگاه یک میانجی یا تسهیل کننده را داشته باشید به جای اینکه به نبرد با دیدگاه تان وارد شوید. اگر شخصی در حال بی مهر شدن است یا دارد مکالمات را انحصاری می سازد، [فوراً اقدام کنید](../building-community/#بازیگران-بد-را-تحمل-نکنید) تا مباحثات را مدنی و سودمند نگه دارید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kennethreitz?s=180" class="pquote-avatar" alt="avatar">
  به عنوان یک نگهدارنده پروژه، بی نهایت مهم است که نسبت به مشارکت کنندگانتان فروتن باشید. اغلب آنها آنچه شما خیلی شخصی می پندارید را محرمانه نگه می دارند.
  <p markdown="1" class="pquote-credit">
— @kennethreitz, ["Be Cordial or Be on Your Way"](https://web.archive.org/web/20200509154531/https://kenreitz.org/essays/be-cordial-or-be-on-your-way)
  </p>
</aside>

افراد دیگر به رهنمودهای شما نگاه می کنند. یک نمونه خوب را تعیین کنید، شما هنوز می توانید ناامیدی، ناراحتی یا نگرانی را اظهار کنید اما آرامش خود را کاملاً حفظ کنید.

خونسرد بودن آسان نیست، اما نشان دادن رهبری ، سلامت انجمن تان را بهبود می بخشد. اینترنت از شما تشکر می کند.

### فایل <span dir="rtl">README</span> خود را به عنوان یک قانون اساسی در نظر بگیرید

فایل <span dir="rtl">README</span> تان [بیشتر از یک مجموعه رهنمودها است](../starting-a-project/#نوشتن-راهنمای-مشارکت)، همچنین یک محلی برای گفتگو درباره اهداف، دیدگاه و نقشه مسیرتان است. اگر افراد آشکارا روی بحث درباره ارزش یک ویژگی خاص تمرکز می کنند، این کار به تجدیدنظر درباره <span dir="rtl">README</span> تان و صحبت درباره دیدگاه بهتر درباره پروژه تان کمک می کند. تمرکز روی <span dir="rtl">README</span> تان همچنین این مکالمات را غیرمحرمانه می سازد، بنابراین شما می توانید یک بحث سازنده را دنبال کنید.

### تمرکز روی سفر نه مقصد

برخی پروژه ها از یک فرایند رای گیری استفاده می کنند تا تصمیمات بزرگی را اتخاذ کنند. در حالی که در نگاه اول معقول به نظر می رسد، اما رای گیری به جای گوش دادن و پرداختن به نگرانی های همدیگر روی دستیابی به یک جواب تاکید می کند.

رای گیری می تواند سیاسی باشد، که در آن اعضای انجمن برای انجام منافع همدیگر یا رای دادن در یک راه خاص احساس تحت فشار قرار داشتن کنند. البته همه رای نمی دهند، چه [اکثریت انجمن تان سکوت پیشه کنند](https://ben.balter.com/2016/03/08/optimizing-for-power-users-and-edge-cases/#the-silent-majority-of-users) چه کاربران فعلی که از رای آگاهی ندارند در حال جایگزین شدن باشند.

گاهی اوقات، رای گیری یک رهگشای ضروری است. هرچه شما بیشتر توانمند باشید به جای خودِ اجماع بیشتر روی « اجماع‌جویی» تاکید می کنید.

تحت یک فرایند اجماع جویی ، اعضای انجمن، نگرانی های بزرگ خود را بحث می کنند تا آنها احساس کنند که حرفهایشان شنیده می شود. وقتی تنها نگرانی های کوچک باقی می ماند، انجمن روی به جلو حرکت می کند.« اجماع جویی مهر تاییدی بر این مطلب است که یک انجمن شاید قادر نباشد که به یک جواب جامع دست یابد. در عوض، آن به گوش سپاری و مباحثه اولویت می دهد.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lee-dohm?s=180" class="pquote-avatar" alt="avatar">
  بخشی از دلیل اینکه چرا یک سامانه رای گیری برای موضوعات اتمی وجود ندارد بدین خاطر است که تیم اتمی قصد ندارد که از یک سیستم رای گیری در همه موارد بهره گیرد. گاهی اوقات ما باید آنچیزی را انتخاب کنیم که درست است حتی اگر آن معروف نباشد. (...) آنچه من می توانم پیشنهاد کنم و برای انجام آن تقاضا کنم این است که کار من این است که به انجمن گوش فرا دهم.
  <p markdown="1" class="pquote-credit">
— @lee-dohm on Atom's decision making process
  </p>
</aside>

حتی اگر شما در عمل به عنوان یک نگهدارنده پروژه یک فرایند اجماع‌جویی را اقتباس کنید، مهم است که بدانید چه افرادی در حال گوش دادن هستند. وادار کنید دیگر افراد احساس کنند که شنیده می شوند و متعهد شوید که نگرانی هایشان را حل می کنید، و راه طولانی انتشار شرایط حساس را طی می کنید. سپس حرفهایتان را با اقداماتتان مقایسه کنید.

با به خاطر داشتن یک راه حل به یک تصمیم متمایل نشوید. مطمئن شوید که همه افراد احساس شنیده شدن می کنند و اینکه همه اطلاعات قبل از حرکت به سوی راه حل علنی شده اند.

### مکالمه را بطور متمرکز روی کار عملی حفظ کرده و پیش ببرید

مباحثه مهم است اما یک تفاوت بین مکالمات سودمند و غیرمفید وجود دارد.

مباحثات مادامی که فعالانه به سوی راه حل سوق می یابند را تشویق کنید. اگر واضح است که مکالمه بی فروغ شده یا به خارج از موضوع هدایت شده، گفتگوها دارد شخصی می شود یا افراد وارد بحثهای جزئی و حاشیه ای می شوند، زمان آن فرا رسیده که به مباحثات خاتمه دهید.

اجازه دادن به این مکالمات که همچنان ادامه یابد نه تنها برای موضوع تحت بررسی بد است بلکه برای سلامت انجمن تان نیز بد است. این کار پیامی می فرستد مبنی بر اینکه این نوع مکالمات مجاز هستند یا حتی انجام آنها مورد تشویق قرار می گیرد و در نتیجه می تواند روحیه افراد را از مطرح کردن و حل کردن موضوعات آتی تضعیف کند.

با ذکر هر نکته توسط دیگران یا خودتان، از خود بپرسید که _«چطور این نکته ما را به راه حل نزدیکتر می کند؟»_

اگر مکالمه به سوی حل شدن سوق یافته است از گروه بپرسید که در مرحله بعد باید _چه گامهایی را انتخاب کنید؟_ تا دوباره روی مکالمه متمرکز شوید.

اگر یک مکالمه بطور واضح هیچ روزنه ای به سوی راه حل نیافته یا هیچ اقدام واضحی برای عملیاتی شدن وجود ندارد یا اقدام مناسب قبلا اتخاذ شده، موضوع را ببندید و توضیح دهید چرا شما آن را بسته اید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kfogel?s=180" class="pquote-avatar" alt="avatar">
  رهنمون سازی یک رشته جریانات به سوی راه حلی مفید بدون تحت فشار قرار گرفتن یک هنر ناب است. این کار برای سرزنش کردن افراد که تلف کردن زمانشان را متوقف کنند یا برای خواستن از آنها که اگر چیز سازنده ای برای گفتن ندارند مطلبی پست نکنند، کارساز نیست. در عوض شما باید شرایط برای پیشرفت بیشتر را پیشنهاد کنید: به افراد یک مسیر بدهید، مسیری که دنبال کنند تا آنها را به نتایجی که شما می خواهید هدایت کند با وجود این، این کار باید بدون رفتار مستبدانه صورت گیرد.
  <p markdown="1" class="pquote-credit">
— @kfogel, [_Producing OSS_](https://producingoss.com/en/producingoss.html#common-pitfalls)
  </p>
</aside>

### نبردهایتان را عاقلانه سازید

متن مهم است، در نظر بگیرید چه کسانی در بحث درگیر می شوند و چطور آنها بقیه انجمن را تحت تاثیر قرار می دهند.

آیا همه افراد در انجمن در این باره ناراحت هستند یا حتی درگیر این موضوع هستند؟ یا آیا یک دردسرساز منحصر به فرد وجود دارد؟ فراموش نکنید که فقط صداهای فعال را در نظر نگیرید و اعضای ساکت جامعه تان را نیز لحاظ کنید.

اگر موضوع ، نیازهای گسترده تر انجمن تان را متجلی نمی سازد، شما شاید نیاز به تایید نگرانی های افراد کمی از انجمن تان داشته باشید. اگر این یک موضوع تکرار شونده بدون یک راه حل واضح باشد، آنها را به مباحثات قبلی درباره این موضوع ارجاع دهید و موضوع را ببندید.

### راهگشای انجمن تان را شناسایی کنید

با یک نگرش خوب و ارتباطات واضح، اکثر شرایط دشوار قابل حل هستند. البته حتی در مکالمه سودمند، می تواند یک تفاوت در عقیده درباره چگونگی پیشرفت رویه ها وجود داشته باشد. در این موارد، یک فرد یا گروه از افرادی را شناسایی کنید که می توانند به عنوان رهگشا عمل کنند.

یک رهگشا می تواند نگه دارنده اولیه پروژه باشد یا می تواند یک گروه کوچک از کسانی باشند که مبتنی بر رای گیری تصمیم می گیرند. بطور ایده آل شما یک رهگشا و یک فرایند مرتبط در یک فایل <span dir="rtl">GOVERNANCE</span> را شناسایی کرده اید قبل از اینکه ملزم باشید که از آن استفاده کنید.

رهگشایتان، باید یک تصمیم گیرنده نهایی باشد. موضوعات نفاق انگیز فرصتی برای انجمن تان است تا درس بگیرد و تکامل یابد. در آغوش کشیدن این فرصتها و استفاده از یک فرایند همکارانه برای حرکت به سوی یک راه حل هرجایی شدنی است.

## اجتماع ها و انجمن ها ❤️ متن باز هستند

انجمنهای سالم اما کوشا هزاران ساعت را برای منبع باز در هر هفته اختصاص می دهند. خیلی از مشارکت کنندگان به افراد دیگر به عنوان دلیلی برای کار کردن یا نکردن روی منبع باز اشاره می کنند. با یادگیری اینکه چطور از قدرت بطور سازنده بهره برداری کنید شما باید به افراد خارج از آنجا کمک کنید تا از یک تجربه منبع باز فراموش نشدنی برخوردار شوند.
