---
lang: fa
title: بهترین روال‌های تجربه شده برای نگهدارنده‌ها
description: زندگی خود را به عنوان یک نگهدارنده‌ی اوپن سورس آسان‌تر کنید؛ از ثبت‌کردن فرآیندها گرفته تا بهره‌بردن از اجتماع‌تان.
class: best-practices
order: 5
image: /assets/images/cards/best-practices.png
related:
  - metrics
  - leadership
---

## نگهدارنده بودن به چه معناست؟

اگر شما نگه‌دارنده‌ی پروژه‌ای اوپن سورس باشید که افراد زیادی از آن استفاده می‌کنند، حتما متوجه شده‌اید که کمتر مشغول به کدنویسی هستید و بیشتر نقش پاسخگویی به مشکلات را بر عهده دارید.

در مراحل اولیه‌ی هر پروژه‌ای، شما ایده‌های جدیدی را امتحان می‌کنید و بر اساس آنچه می‌خواهید تصمیم‌گیری می‌کنید. با افزایش محبوبیت پروژه، متوجه می‌شوید که بیشتر مشغول کار با کاربران و همکاران خود خواهید بود.

نگهداری یک پروژه، به چیزی بیشتر از کدنویسی نیاز دارد. این وظایف اغلب به صورت ناگهانی پیش می‌آیند؛ اما آن‌ها به همان اندازه‌ی پروژه‌ی در حال رشد مهم هستند. ما برای آسان‌تر کردن زندگی‌تان چند روش آماده کرده‌ایم؛ از مراحل ثبت کردن فرآیند گرفته تا بهره‌بردن از اجتماع‌تان.

## ثبت کردن فرآیندها

نوشتن مطالب، یکی از مهم‌ترین کارهایی است که می‌توانید به عنوان نگهدارنده انجام دهید.

ثبت کردن مطالب، نه تنها باعث شفافیت تفکر شما می‌شود، بلکه به دیگران کمک می‌کند تا حتی بدون پرسیدن سوالی، با احتیاجات و انتظارات شما آشنا شوند.

نوشتن مطالب، نه گفتن به چیزی که به درد شما نمی‌خورد را آسان‌تر می‌کند. همچنین فرآیند کمک کردن به شما را برای سایرین آسان‌تر می‌کند. شما هرگز نمی‌دانید که چه کسی ممکن است پروژه‌ی شما را مطالعه یا از آن استفاده کند.

حتی اگر از پاراگراف‌های طولانی استفاده نمی‌کنید!، نوشتن نکات مهم بهتر از چیزی ننوشتن است.

به یاد داشته باشید که نوشتن مطالب را به روز نگه دارید. اگر همیشه قادر به انجام این کار نیستید، مطالب قدیمی خود را حذف کنید یا مشخص کنید که این مطالب  منسوخ شده‌اند تا مانع به روز رسانی‌های مشارکت‌کنندگان نشوید.

### چشم انداز خودتان از پروژه را یادداشت کنید

با نوشتن هدف‌های خودتان از پروژه، شروع کنید. آن‌ها را به «README» (من را بخوانید) خود اضافه کنید یا یک فایل جداگانه به نام  «VISION » (چشم انداز) ایجاد کنید. اگر موارد دیگری وجود دارد که می‌تواند به شما کمک کند؛ مانند نقشه‌ی راه پروژه، آن‌ها را نیز به صورت عمومی منتشر کنید.

داشتن چشم‌اندازی واضح و ثبت شده، شما را متمرکز نگه می‌دارد و به شما کمک می‌کند تا از بسط یا تغییرات در اهداف اولیه جلوگیری شود.

به عنوان مثال، @lord، متوجه شد که داشتن چشم‌انداز پروژه به او کمک می‌کند تا بفهمد برای کدام درخواست‌ها وقت بگذارد. به عنوان یک نگهدارنده‌ی جدید، وقتی اولین درخواست خود را برای [Slate](https://github.com/lord/slate) دریافت کرد، از عدم پایبندی به اهداف پروژه‌ی خود پشیمان شد.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lord?s=180" class="pquote-avatar" alt="avatar">
 دستپاچه شدم. تلاشی نکردم تا به راه‌حلی کامل دست پیدا کنم. ای کاش به جای یک راه‌حل بی‌فکر، می‌گفتم: «الان برای این وقت ندارم، اما آن را به لیست بلند مدت خودم اضافه کردم».
  <p markdown="1" class="pquote-credit">
— @lord, ["Tips for new open source maintainers"](https://lord.io/blog/2014/oss-tips/)
  </p>
</aside>

### انتظارات خود را اعلام کنید

نوشتن قوانین، می‌تواند اعصاب خردکن باشد. گاهی اوقات ممکن است این حس را داشته باشید که در حال کنترل رفتار دیگران و یا از بین بردن هیجان و لذت در میان دیگران هستید.

با این حال، اگر قوانین، مناسب و به طور عادلانه‌ای نوشته و اجرا شوند باعث نگهداری هر چه بهتر می‌شوند. این قوانین، جلوی کارهایی که نمی‌خواهید انجام دهید را می‌گیرد.

اکثر افرادی که با پروژه‌ی شما روبرو می‌شوند، چیزی از شما و شرایط شما نمی‌دانند. ممکن است فرض کنند که شما برای کار کردن بر روی پروژه حقوق می‌گیرید، به ویژه اگر آن پروژه چیزی باشد که آن‌ها مرتباً استفاده می‌کنند و به آن وابستگی دارند. ممکن است زمانی وقت زیادی را صرف پروژه‌ی خود می‌کردید، اما اکنون مشغول کار یا گذران زمان با خانواده‌ی خود هستید.

شما مرتکب کار اشتباهی نشده‌اید! ولی اطمینان حاصل کنید که بقیه‌ هم راجع به این مسائل اطلاع داشته باشند.

اگر نگهداری پروژه برای شما کاری نیمه وقت است یا کاملاً داوطلبانه است، درمورد آن صادق باشید و روشن کنید که چقدر زمان برای این کار دارید. این مسئله با میزان زمانی که شما فکر می‌کنید پروژه به آن نیاز دارد یا مدت زمانی که دیگران می‌خواهند شما در آن صرف کنید، یکی نیست و با هم فرق می‌کند.

در اینجا چند قانون داریم که به یاد داشتن آن‌ها ارزش دارد:

* مشارکت چگونه تعریف و پذیرفته می‌شود (_آیا نیاز به آزمون دارد؟ یا قالب طرح مشکل؟_)
* انواع مشارکت‌هایی که می‌پذیرید (_آیا فقط برای قسمت‌های خاصی از کد خود کمک می‌خواهید؟_)
* چه زمانی برای پیگیری مناسب است (_به عنوان مثال، «شما در طی 7 روز از  نگهدارنده می‌توانید انتظار پاسخگویی داشته باشید. اگر تا آن موقع خبری نشد، یادآوری کنید._)
* چه مدت زمان صرف پروژه می‌کنید (_به عنوان مثال، «ما فقط 5 ساعت در هفته برای این پروژه وقت می‌گذاریم»_)

[Jekyll](https://github.com/jekyll/jekyll/tree/master/docs), [CocoaPods](https://github.com/CocoaPods/CocoaPods/wiki/Communication-&-Design-Rules), و [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Maintainers-Avoiding-Burnout.md) نمونه‌هایی از پروژه‌ها با دستور‌العمل‌هایی برای نگهدارندگان و مشارکت‌کنندگان هستند.

### ابلاغیه‌های خود را به صورت عمومی اعلام کنید

تعاملات خود با بیرون را نیز ثبت کنید. در هر جایی که ممکن بود، ابلاغیه‌های مربوط به پروژ‌ه‌ی خود را به صورت عمومی اعلام کنید. اگر کسی خواست که به طور خصوصی درباره‌ی درخواستی یا پشتیبانی با شما به گفتگو بپردازد، مودبانه او را به کانال ارتباطی عمومی، همچون فهرست پستی (mailing list) یا «issue tracker» هدایت کنید.

اگر با سایر نگهدارنده‌ها ملاقات کردید یا در خلوت تصمیم مهمی گرفتید، این مکالمه‌ها را به صورت عمومی ثبت کنید؛ حتی اگر بخواهد به صورت پست کردن یادداشت‌هایتان باشد.

به این ترتیب، هر کسی که به انجمن شما بپیوندد به همان اطلاعاتی که سال‌ها در آنجا بوده است، دسترسی خواهد داشت.

## نه گفتن، را یاد بگیرید

شما مطالب خود را ثبت کردید. در حالت ایده آل، همه نوشته‌ها و مستندات شما را می‌خوانند، اما در واقع، شما باید به دیگران وجود این اطلاعات را نیز یادآوری کنید.

درصورتی که لازم باشد قوانین خود را اجرا کنید، با نوشتن و ثبت کردن همه چیز، به شما کمک می‌کند تا شرایط را از حالت شخصی‌سازی شده در‌آورید.

نه گفتن، لذت‌بخش نیست؛ اما گفتن «مشارکت شما با معیارهای این پروژه مطابقت ندارد» کمتر از «من مشارکت با شما را دوست ندارم»، به شخصیت طرف برمی‌خورد.

نه گفتن در بسیاری از شرایطی که به عنوان نگهدارنده با آن روبرو خواهید شد، به کار می‌آید: درخواست‌هایی که با ویژگی‌های پروژه‌ی شما متناسب نیستند، کسی که بحث را به بیراهه می‌کشاند، انجام کارهای غیرضروری برای دیگران.

### دوستانه با دیگران ارتباط برقرار کنید

یکی از مهم‌ترین جاهایی که شما باید تمرین نه گفتن را انجام دهید، در سر برخی از مسائل و «درخواست‌های pull» ای است که از شما می‌شود. به عنوان نگهدارنده‌ی پروژه، ناگزیر پیشنهادهایی دریافت خواهید کرد که نمی‌خواهید آن‌ها را بپذیرید.

چونکه شاید آن مشارکت، اهداف پروژه‌ی شما را تغییر دهد یا با چشم‌انداز شما مطابقت نداشته باشد. یا شاید ایده خوب باشد، ولی اجرای آن ضعیف باشد.

صرف نظر از هرچه که دلیل بخواهد باشد، می‌توان مشارکت‌هایی را که مطابق با استانداردهای پروژه‌ی شما نیستند را با درایت مدیریت کرد.

اگر مشارکتی به شما پیشنهاد بشود که نخواهید آن را بپذیرید؛ اولین واکنش شما ممکن است نادیده گرفتن آن یا تظاهر به ندیدن آن باشد. انجام این کار می‌تواند به احساسات طرف مقابل ضربه بزند و حتی باعث کاهش انگیزه‌ی سایر مشارکت‌کنندگان بالقوه‌ی اجتماع (community) شما شود.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/krausefx?s=180" class="pquote-avatar" alt="avatar">
  نکته‌ی مهم در مدیریت پروژه‌های اوپن سورس در مقیاسی بزرگ، حرکت رو به جلو است. سعی کنید از ماندگاری مسائل و مشکلات، جلوگیری کنید. اگر توسعه‌دهنده‌ی iOS باشید، می‌دانید که این مسائل چقدر طاقت‌فرسا هستند. ممکن است 2 سال بعد دوباره این مسائل به سراغ شما بیاد و به شما گفته شود که با آخرین نسخه iOS دوباره امتحان کنید.
  <p markdown="1" class="pquote-credit">
— @KrauseFx, ["Scaling open source communities"](https://krausefx.com/blog/scaling-open-source-communities)
  </p>
</aside>

مشارکت ناخواسته را صرف اینکه آدم خوبی به نظر برسید، ادامه ندهید زیرا در ادامه‌ی راه احساس گناه خواهید کرد. با گذشت زمان، مسائل و روابط عمومی بی‌پاسخ باعث می‌شود که کارتان روی پروژه بسیار استرس‌زا و ترسناک پیش برود.

بهتر است فوراً به مشارکت‌هایی که آن‌ها را نمی‌خواهید، پایان دهید. اگر پروژه شما از کمبود بک لاگ رنج می برد, @steveklabnik در مقاله [how to triage issues efficiently](https://words.steveklabnik.com/how-to-be-an-open-source-gardener) پیشنهاداتی در این خصوص ارائه کرده است.

ثانیاً، بی‌توجهی به مشارکت‌هایتان، سیگنال‌های منفی‌ای به درون اجتماع می‌فرستد. مشارکت در هر پروژه‌ای می‌تواند دلهره‌آور باشد، خصوصاً اگر برای اولین بار باشد که در پروژه‌ای شرکت می‌کنید. حتی اگر مشارکت آن‌ها را قبول نکردید، از آن شخص تشکر کرده و از توجه او سپاسگزار باشید. کار پسندیده‌ای است!

اگر نمی‌خواهید مشارکت کسی را قبول کنید:

* از توجه آن‌ها **تشکر کنید**.
* **توضیح دهید که چرا نمی‌توانید با آن‌ها همکاری داشته باشید** و اگر می‌توانید، پیشنهادهای واضحی را برای بهبود آن‌ها برای آینده ارائه دهید؛ مهربان باشید، اما مصمم.
* در صورت داشتن دسترسی، آن‌ها را **به مستندات مربوطه ارجاع دهید**. اگر با درخواست‌های مکرر برای مواردی که نمی‌خواهید آن‌ها را بپذیرید، مواجه شدید؛ آن موارد را برای جلوگیری از مکررات به مستندات خود اضافه کنید.
* **درخواست مشارکت را ببندید**.

شما به 1 یا 2 جمله بیشتر، برای پاسخگویی نیاز نخواهید داشت. به عنوان مثال، هنگامی که [celery](https://github.com/celery/celery/)، خطایی مربوط به ویندوز را گزارش داد، «berkerpeksag» [اینگونه پاسخ](https://github.com/celery/celery/issues/3383) داد:

![Celery screenshot](/assets/images/best-practices/celery.png)

اگر فکر نه گفتن شما را وحشت زده می‌کند، بدانید که شما تنها نیستید. همانطور که @jessfraz می‌گوید:

> من با نگهدارنده‌هایی از پروژه‌های اوپن سورس مختلف مانندMesos» ،«Kubernetes» «Chromium صحبت کرده‌ام و همه موافق هستند که یکی از سخت‌ترین قسمت‌های نگهدارنده بودن، «نه» گفتن به اصلاحاتی است که نمی‌خواهید.

در نپذیرفتن پیشنهاد مشارکت کسی، احساس گناه نکنید. [طبق گفته‌ی](https://twitter.com/solomonstre/status/715277134978113536) @shykes، اولین قانون پروژه‌های اوپن سورس این است که: «نه موقتی‌ست، بله برای همیشه». در حالی که همدردی با اشتیاق فرد دیگر، چیز پسندیده‌ای است؛ اما رد کردن پیشنهاد مشارکت به معنای رد کردن هویت فرد پشت سر آن پیشنهاد نیست.

ختم کلام این است که اگر مشارکت با دیگری به اندازه کافی خوب نباشد، شما ملزم به پذیرفتن هیچ تعهدی نیستید. وقتی دیگران در پروژه‌ی شما مشارکت می‌کنند، مهربان و پاسخگو باشید؛ اما فقط تغییراتی را قبول کنید که واقعاً معتقد هستید پروژه‌ی شما را بهتر می‌کند. هر چه در نه گفتن، تمرین بیشتری داشته باشید؛ گفتن آن راحت‌تر می‌شود. به شما قول می‌دهم.

### فعال باشید

برای کاهش حجم مشارکت‌های ناخواسته در وهله‌ی اول، روند پروژه خود را در راهنمای ارسال و پذیرش مشارکت‌ها توضیح دهید.

اگر درخواست‌های مشارکت بسیار کم کیفیت دریافت می‌کنید، از افراد متقاضی بخواهید کمی قبل از ارسال پیشنهاد، کارهایی انجام دهند؛ به عنوان مثال:

* Fill out a issue or PR template/checklist
* قبل از ارسال درخواست Pull یک گزارش اشکال ارسال کنند.

اگر از قوانین شما پیروی نکردند، بلافاصله درخواست را رد کنید و آن‌ها را به راهنمای ارسال مرجوع کنید.

اگرچه ممکن است در ابتدا این رویکرد کمی خشن به نظر برسد، اما فعال بودن برای هر دو طرف خوب است. در نتیجه این احتمال را کاهش می‌دهد که کسی ساعت‌های زیادی صرف «درخواست Pull»ی که شما آن را قبول نخواهید کرد، نکند. و ثانیا حجم کاری شما را نیز کمتر می‌کند و مدیریت آن ساده‌تر می‌شود

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
 بهتر است که به افراد متقاضی در یک فایل «CONTRIBUTING.md» توضیح دهید که چه چیزهایی مورد قبول و چه چیزهایی مورد قبول شما برای شروع کردن کارشان نیست.
  <p markdown="1" class="pquote-credit">
— @MikeMcQuaid, ["Kindly Closing Pull Requests"](https://github.com/blog/2124-kindly-closing-pull-requests)
  </p>
</aside>

بعضی اوقات، وقتی نه می‌گویید، مشارکت‌کننده‌ی بالقوه ممکن است ناراحت شود یا از تصمیم شما انتقاد کند. اگر آن‌ها خصومت‌آمیز رفتار کردند و اگر نخواستند به طور سازنده همکاری کنند، [قدم‌هایی را برای خنثی کردن موقعیت](https://github.com/jonschlinkert/maintainers-guide-to-staying-positive#action-items) بردارید یا حتی آن‌ها را از اجتماع خودتان اخراج کنید.

### با آغوش باز، پذیرای راهنمایی‌ و مشاوره باشید

شاید کسانی در اجتماع شما باشند که مرتباً درخواست‌های مشارکتی پیشنهاد می‌کنند که با استانداردهای پروژه‌ی شما مطابقت نداشته باشد. مسلما رد شدن پیاپی برای هر دو طرف، طاقت‌فرساست.

اگر دیدید کسی مشتاق پروژه‌ی شما است، اما به کمی پیشرفت نیاز دارد، صبور باشید. در هر شرایطی به روشنی توضیح دهید که چرا مشارکت آن‌ها متناسب با انتظارات پروژه‌ی شما نیست. سعی کنید ابتدا وظایفی ساده‌تر و با ابهامات کمتر به آن‌ها بسپرید تا به قول معروف «آماده‌ی کار شوند». اگر وقت داشتید، در اولین مشارکت، آن‌ها را راهنمایی کنید، یا شخص دیگری را در اجتماع خود پیدا کنید که تمایل به راهنمایی کردن آن‌ها داشته باشد.

## از اجتماع خود بهره ببرید

لازم نیست همه‌ی کارها را خودتان انجام دهید. دلیلی دارد که پروژه‌ی شما، اجتماعی برای خود دارد! حتی اگر هنوز اجتماعی فعال ندارید، اگر کاربران زیادی دارید، کارها را به آن‌ها بسپرید.

### حجم کار را با دیگران تقسیم کنید

اگر می‌خواهید که دیگران به شما کمک کنند، از آن‌ها درخواست کنید.

راهی برای جذب مشارکت‌کنندگان این است که کارها را از نظر سختی درجه‌بندی کنید و [کارهای ساده را به مبتدی‌ها بسپرید](https://help.github.com/en/articles/helping-new-contributors-find-your-project-with-labels). سپس GitHub این موضوعات را در فضاهای مختلف خودش به نمایش می‌گذارد و باعث افزایش دیده شدن آن‌ها می‌شود.

وقتی مشاهده کردید که مشارکت‌کنندگان جدید به صورت مکرر همکاری می‌کنند، با دادن مسئولیت‌های بیشتر، آن‌ها را تصدیق کنید و به رسمیت بشناسید. مشخص کنید که چگونه دیگران می‌توانند در صورت اشتیاق به جایگاه‌های رهبری دست یابند.

همانطور که @lmccart در پروژه‌ی خود متوجه شد، تشویق دیگران [به اشتراک گذاشتن مالکیت پروژه](../building-community/#مالکیت-پروژه-تان-را-به-اشتراک-بگذارید) می‌تواند حجم کاری شما را بسیار کاهش دهد[p5.js](https://github.com/processing/p5.js).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/lmccart?s=180" class="pquote-avatar" alt="avatar">
  من می‌گفتم، «هر کسی می‌تواند در پروژه سهیم شود، لازم نیست که حتما مهارت زیادی در زمینه‌ی کدنویسی داشته باشید [...]» افرادی بودند که برای ورود به رویداد ما ثبت‌نام کردند و آن وقت بود که من واقعاً با خودم فکر کردم «آیا حرف‌هایی که می‌زدم واقعیت دارند؟» قرار هست که 40 نفر در رویداد حضور پیدا کنند و اینطور نیست که من بتوانم با هرکدام بنشینم و با آن‌ها صحبت کنم... اما مردم دور هم جمع شدند و خود به خود همه چی به خوبی پیش رفت. به محض اینکه یک نفر یاد گرفت، آن‌ها می‌توانند به یکدیگر یاد دهند.
  <p markdown="1" class="pquote-credit">
—  @lmccart, ["What Does "Open Source" Even Mean? p5.js Edition"](https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39)
  </p>
</aside>

اگر لازم است کمی از پروژه‌ی خود فاصله بگیرید، یا وقفه‌ای در آن ایجاد کنید یا به طور کلی کنار بکشید؛ به هیچ وجه شرم‌آمور نیست که از شخص دیگری بخواهید مسئولیت کار شما را به عهده بگیرد.

اگر افراد دیگری مشتاق این هستند، به آن‌ها اجازه‌ی دسترسی دهید یا کنترل پروژه را به طور رسمی به شخص دیگری بسپارید. اگر کسی پروژه‌ی شما را به چند شاخه تبدیل کرد و به طور فعال آن را در جای دیگری نگهداری کرد، پیوند دادن پروژه‌ی اصلی خود به شاخه را مد نظر قرار دهید. این خیلی خوب است که مردم می‌خواهند پروژه شما ادامه یابد!

@progrium [متوجه شد]( https://web.archive.org/web/20151204215958/https://progrium.com/blog/2015/12/04/leadership-guilt-and-pull-requests/) که ثبت کردن چشم‌انداز [پروژه](https://github.com/dokku/dokku)، کمک کرد تا آن اهداف حتی پس از کنار کشیدن او ادامه یابند:

> من یک صفحه‌ در ویکی نوشتم و آنچه را که می‌خواهم و چرایی آن را توصیف کردم. بنا به دلایلی برای من تعجب‌آور بود که نگهدارندگان شروع به انتقال پروژه به سمت و سوی دلخواه خود کردند! آیا آنطور که می‌خواستم، پیش رفت؟ نه همیشه. ولی پروژه را به آنچه که نوشته‌ بودم، نزدیک‌تر کرد.

### به دیگران اجازه دهید تا راه حل‌های مورد نیاز خودشان را طراحی کنند

اگر فرد مشارکت‌کننده‌ای نظر دیگری در مورد کاری که پروژه باید انجام دهد داشته باشد، بهتر است که آن‌ها را با مهربانی تشویق به کار بر روی شاخه‌ی خودشان از پروژه بکنید.

به چند شاخه تقسیم کردن پروژه، الزاما چیز بدی نیست. امکان کپی و اصلاح پروژه‌ها، یکی از بهترین ویژگی‌های اوپن سورس بودن است. تشویق اجتماع (community) خودتان به کار بر روی شاخه‌های خودشان می‌تواند فضای خلاقانه‌ی مورد نیاز را فراهم آورد، بدون اینکه با چشم‌اندازهای پروژه‌ی شما تداخلی ایجاد کند.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/geerlingguy?s=180" class="pquote-avatar" alt="avatar">
  من زمینه‌ی 80% موارد کاربردی را فراهم می‌کنم.  اگر از کار خود اطمینان دارید، لطفا شاخه‌ای از پروژه‌ی من را بردارید. دلخور نخواهم شد! پروژه‌های عمومی من اکثرا برای حل رایج‌ترین مشکلات هستند؛ سعی می‌کنم با شاخه شاخه کردن کارم یا بسط دادن، آن را کاربردی‌تر بکنم.
  <p markdown="1" class="pquote-credit">
— @geerlingguy, ["Why I Close PRs"](https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes)
  </p>
</aside>

این موضوع همچنین درمورد کاربری صدق می‌کند که واقعاً نیاز به راه‌حلی دارد که ظرفیت طراحی آن را ندارید. ارائه‌ی APIها و هوک‌های سفارشی‌سازی (customization hooks)، بدون نیاز به تغییر مستقیم سورس، می‌توانند به دیگران در تأمین نیازهاشان کمک کنند. @orta [متوجه شد](https://artsy.github.io/blog/2016/07/03/handling-big-projects/) که افزونه‌های پرورشی برای «CocoaPods» منجر به «برخی از جالب‌ترین ایده‌ها» شد:

> تقریباً اجتناب‌ناپذیر به نظر می‌رسد که به محض بزرگ‌تر شدن پروژه، نگهدارنده‌ها باید در مورد نحوه تعریف کدهای جدید بسیار محافظه‌کارانه‌تر عمل کنند. شاید در گفتن «نه» تبحر پیدا کرده باشید، اما هنوز بسیاری از مردم نیازهایی معقول و منطقی دارند. بنابراین، در نهایت ابزار شما به یک پلتفرم تبدیل می‌شود.

## از ربات‌ها استفاده کنید

همانطور که وظایفی وجود دارد که دیگران می‌توانند در انجام آن‌ها به شما کمک کنند، وظایفی نیز وجود دارد که هیچ انسانی هرگز نباید آن‌ها را انجام دهد. ربات‌ها دوست شما هستند. به عنوان یک نگهدارنده، از آن‌ها برای سهولت زندگی خود استفاده کنید.

### برای بهبود کیفیت کدهای خود، از تست‌ها و دیگر ابزار استفاده کنید.

یکی از مهم‌ترین راه‌ها برای اتوماتیک کردن پروژه‌ی خود،افزودن تست است.
تست‌ها به مشارکت‌کنندگان کمک می‌کند تا اطمینان داشته باشند که چیزی را خراب نمی کنند. تست‌ها،همچنین بررسی و پذیرش سریع مشارکت‌ها را برای شما آسان می‌کند.
هر چقدر از خود علاقه‌ی بیشتری نمایش دهید و مشتاق‌تر باشید،اجتماع شما مشارکت بیشتری خواهد داشت.

تست‌های خودکاری را طراحی کنید که برای همه مشارکت‌های آتی اجرا شود و اطمینان حاصل کنید که تست‌های شما به راحتی توسط مشارکت‌کنندگان قابل اجرا باشند. قبول کردن درخواست‌های مشارکت در کدها را ملزم به قبول شدن در آن تست بکنید. با این کار، حداقل استاندارد کیفیتی را برای همه‌ی درخواست‌ها تعیین می‌کنید. [با بررسی وضعیت](https://help.github.com/articles/about-required-status-checks/) در GitHub می‌توانید اطمینان حاصل کنید که بدون گذراندن تست‌های شما اجازه‌ی هیچ گونه تغییری داده نمی‌شود.

اگر تست‌هایی اضافه کردید، حتماً نحوه‌ی کارکرد آن‌ها را در فایل «CONTRIBUTING» (مشارکت) خود توضیح دهید.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/edunham?s=180" class="pquote-avatar" alt="avatar">
  من معتقد هستم که تست‌ها برای همه‌ی کدهایی که افراد روی آن‌‌ها کار می‌کنند، لازم است. اگر کد کاملاً صحیح و سالم باشد، دیگر نیازی به تغییر نخواهد داشت - ما فقط درصورتی که مشکلی پیش آمده باشد کد می‌نویسیم؛ مگر در زمان‌هایی که کد «خراب شود» یا «فاقد فلان ویژگی باشد». و صرف نظر از تغییراتی که ایجاد می‌کنید، تست‌ها برای دستیابی به رگرسیون‌هایی که به طور تصادفی به وجود می‌آ‌ورید، ضروری است.
  <p markdown="1" class="pquote-credit">
— @edunham, ["Rust's Community Automation"](https://edunham.net/2016/09/27/rust_s_community_automation.html)
  </p>
</aside>

### از ابزارها برای اتوماتیک کردن کارهای ساده‌ی نگهداری استفاده کنید

خبر خوب در مورد نگهداری پروژه‌های محبوب این است که نگهدارندگان دیگر احتمالاً با مسائل مشابهی روبرو شده‌اند و راه‌حلی از قبل برای آن طراحی کرده‌اند.

[ابزارهای متنوعی برای کمک](https://github.com/showcases/tools-for-open-source) به اتوماتیک کردن برخی جنبه‌های کار نگهداری وجود دارد. به عنوان مثال:

* ابزار [semantic-release](https://github.com/semantic-release/semantic-release)، عرضه نسخه‌های جدید شما را اتوماتیک می‌کند.
* ابزار [mention-bot](https://github.com/facebook/mention-bot)، به بازبین‌های بالقوه برای «درخواست pull»ها خبر می دهد.
* ابزار [Danger](https://github.com/danger/danger)، به بررسی و بازبینی اتوماتیک کد کمک می‌کند.
* ابزار [no-response](https://github.com/probot/no-response)، مسائلی را که نویسنده به درخواست‌ها برای اطلاعات بیشتر پاسخ نداده است، می‌بندد.
* ابزار [dependabot](https://github.com/dependabot)، هر روز «فایل‌های وابسته» (مثل کتابخانه‌ها یا کلاس‌های جانبی یا ماژول‌ها) شما را از نظر الزامات منسوخ شده بررسی می‌کند و «درخواست‌های pull» را برای هر موردی که پیدا می‌کند، باز می‌کند.

برای گزارش اشکالات (bug) و سایر مشارکت‌های متداول، GitHub دارای [قالب‌های طرح مشکل و قالب‌های درخواست‌های pull](https://github.com/blog/2111-issue-and-pull-request-templates) است، که می‌توانید برای کارآمد ساختن ارتباطاتی که دریافت می‌کنید، استفاده کنید. «TalAter»، برای کمک کردن به شما برای طرح مشکلات و مسائل روابط عمومی (PR templates)، ابزار [Choose Your Own Adventure guide](https://www.talater.com/open-source-templates/#/) را ساخت.

برای مدیریت اعلان‌های ایمیل خود، می‌توانید [فیلترهای ایمیل](https://github.com/blog/2203-email-updates-about-your-own-activity) را تنظیم کنید تا ایمیل‌ها براساس اولویت سازماندهی شوند.

اگر می خواهید فراتر از حد معمول باشید، شیوه‌نامه‌ها (style guides) و ابزار «linters» می‌توانند مشارکت‌های پروژه را استاندارد کرده و بررسی و پذیرش آن‌ها را آسان کنند.

اگرچه اگر استانداردهای شما بسیار پیچیده باشد، می تواند موانع و مسائل مشارکت را افزایش دهند. مطمئن شوید که فقط به اندازه‌ی کافی قوانینی را برای در آسایش قرار گرفتن دیگران اضافه کنید.

اگر مطمئن نیستید که از چه ابزاری استفاده کنید، به سایر پروژه‌های معروف به ویژه آن پروژه‌هایی که مربوط به اکوسیستم خودتان است، توجه کنید. به عنوان مثال، فرآیند مشارکت برای سایر ماژول‌های «Node»، چگونه است؟ همچنین استفاده از ابزارها و رویکردهای مشابه، فرآیند کارتان را برای مشارکت‌کنندگان‌ شما آشناتر می‌کند.

## اشکالی ندارد اگر که وقفه‌ای در کار خود ایجاد کنید

کار کردن به صورت اوپن سورس برای شما شادی آورد. شاید اکنون باعث شده است شما احساس انزواطلبی داشته باشید یا احساس گناه کنید.

شاید وقتی به پروژه‌های خود فکر می‌کنید بیش از حد احساس آشفتگی و یا احساس ترس می‌کنید. و در همین حال، «مشکلات» و «درخواست‌های pull» روی هم انباشته می‌شود.

فرسودگی و خسته شدن از کار، مسئله‌ای واقعی و فراگیر در پروژه‌های اوپن سورس است؛ مخصوصاً در میان نگهدارندگان. به عنوان یک فرد نگهدارنده، خوشحالی و رضایت شما برای بقای هر پروژه‌ی‌ اوپن سورسی، ضروری است.

پس نیازی به گفتن نیست؛ به خودتان استراحت بدهید! نیازی نیست تا سر حد خستگی و فرسودگی پیش بروید تا سپس به تعطیلات بروید. @brettcannon، توسعه‌دهنده‌ی پایتون، [تصمیم گرفت پس از 14 سال کار داوطلبانه در OSS، به تعطیلات یک ماهه برود](https://snarky.ca/why-i-took-october-off-from-oss-volunteering/).

درست مانند هر کار دیگری، تعطیلات منظم، شما را باطراوت نگه می‌دارد و باعث خوشحالی و هیجان شما نسبت به کارتان می‌شود.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielbachhuber?s=180" class="pquote-avatar" alt="avatar">
  در حین نگهداری «WP CLI»، متوجه شدم که باید ابتدا خودم را خوشحال کنم و مرزهای مشخصی را برای مشارکت خودم تعیین کنم. بهترین تعادلی که پیدا کردم این بود که 2 تا 5 ساعت را در هفته صرف این مشارکت جدای از برنامه‌ی عادی کارم، بکنم. این باعث شد که اشتیاقم به این کار مانند روز اول باشد و آن حس اجباری بودن کار را بر روی دوش حس نکنم. از آنجا که من موضوعاتی که بر روی آن‌ها کار می‌کنم را اولویت‌بندی می‌کنم، می‌توانم مرتباً در آن کارهایی که از نظرم مهم هستند، پیشرفت داشته باشم.
  <p markdown="1" class="pquote-credit">
— @danielbachhuber, ["My condolences, you're now the maintainer of a popular open source project"](https://runcommand.io/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/)
  </p>
</aside>

گاهی اوقات، زمان‌هایی که حس می‌کنید همه به شما احتیاج دارند؛ ممکن است فاصله گرفتن از پروژه‌ی اوپن سورس سخت باشد. حتی ممکن است دیگران، شما را به خاطر فاصله گرفتن سرزنش کنند.

در حالی که از پروژه فاصله گرفتید، تلاش خود را برای یافتن پشتیبانی از کاربران و اجتماع خود بکنید. اگر نتوانستید پشتیبانی دیگران را به دست آورید، به هر حال کار خودتان را بکنید و فاصله‌ای را که نیاز دارید از پروژه بگیرید. زمانی که حضور نداشتید، حتماً ارتباط خود را با دیگران حفظ کنید؛ تا مردم از نبود پاسخگویی گیج نشوند.

فاصله گرفتن، فقط منحصر به تعطیلات می‌شود. اگر نمی‌خواهید آخر هفته‌ یا در ساعات کاری، پروژه‌های اوپن سورس انجام دهید، این را به اطلاع دیگران برسانید تا بدانند که در آن اوقات مزاحم شما نشوند.

## ابتدا به فکر خودتان باشید!

نگهداری یک پروژه‌ی محبوب به مهارت‌های متفاوتی در مقایسه با مهارت‌های مراحل اولیه‌ی رشد نیاز دارد، اما به همان میزان پاداش بیشتری هم خواهد داشت. به عنوان یک نگهدارنده، شما باید مهارت‌های رهبری و شخصی در سطحی فرای دیگران داشته باشید. اگرچه مدیریت آن همیشه آسان نیست، اما تعیین مرزهای مشخص و تنها پذیرفتن آنچه که با آن راحت هستید به شما کمک می‌کند تا شاد، سرحال و کارآمد باشید.
