---
lang: es
title: Comenzando un proyecto de C&oacute;digo Abierto
description: Aprende m&aacute;s acerca del mundo del Código Abierto y prep&aacute;rate a lanzar tu propio proyecto.
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## El c&oacute;mo y el por qu&eacute; del C&oacute;digo Abierto

&iquest;Est&aacute;s pensando c&oacute;mo comenzar un proyecto de c&oacute;digo abierto? &iexcl;Felicitaciones! El mundo aprecia tu contribuci&oacute;n. Hablemos sobre lo que es un proyecto de c&oacute;digo abierto y por qu&eacute; la gente lo lleva adelante

### &iquest;Qu&eacute; significa "C&oacute;digo Abierto"?

Cuando un proyecto es de c&oacute;digo abierto, significa que **cualquier persona puede ver, modificar, usar o distribuir tu proyecto para cualquier fin.** Estos permisos est&aacute;n reforzados a trav&eacute;s de [una licencia de c&oacute;digo abierto](https://opensource.org/licenses).

"C&oacute;digo Abierto" es poderoso debido a que reduce las dificultades de adopci&oacute;n, permitiendo que las ideas se esparzan r&aacute;pidamente.

Para entender c&oacute;mo funciona, imagina a un amigo que organiza una comida, te invita, y llevas una torta.

* Todos prueban la torta. (_usarlo_)
* &iexcl;La torta es un &eacute;xito! Te piden la receta, la cual tu das. (_estudiarlo/verlo_)
* Un amigo, Pedro, es cocinero, y te sugiere colocar menos az&uacute;car. (_modificarlo_)
* Otro amigo, Juan, te pide permiso para usarlo en una cena que tendr&aacute; la pr&oacute;xima semana. (_distribuirlo_)

Realicemos una comparaci&oacute;n: un proceso de c&oacute;digo cerrado ser&iacute;a ir a un restaurante y pedir una porci&oacute;n de torta. Para ello tendr&iacute;as que pagar por la misma, y el restaurante muy probablemente no te dar&aacute; su receta. Si decidieras copiar su torta y venderla bajo otro nombre, el restaurante podr&iacute;a recurrir a acciones legales en contra.

### &iquest;Por qu&eacute; las personas utilizan el "C&oacute;digo Abierto"?

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">
  Una de las experiencias m&aacute;s gratificantes que obtengo de usar y colaborar en "C&oacute;digo abierto" proviene de las relaciones que construyo con cada uno de los desarrolladores que se encuentran enfrentando los mismos problemas que yo.
  <p markdown="1" class="pquote-credit">
— @kentcdodds, ["How getting into Open Source has been awesome for me"](https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me)
  </p>
</aside>

[Hay muchas razones](https://ben.balter.com/2015/11/23/why-open-source/) por las cuales una persona u organizaci&oacute;n querr&iacute;an involucrarse en un proyecto de c&oacute;digo abierto. Algunos ejemplos son:

* **Colaboraci&oacute;n:** Los proyectos de c&oacute;digo abierto pueden aceptar cambios efectuados por cualquier persona alrededor del mundo. [Exercism](https://github.com/exercism/), por ejemplo, es una plataforma para ejercicios de programaci&oacute;n con m&aacute;s de 350 colaboradores.

* **Adopci&oacute;n y remezcla:** Los proyectos de c&oacute;digo abierto pueden ser usados por cualquiera para casi cualquier prop&oacute;sito. Las personas pueden usarlos hasta para construir otras cosas. [WordPress](https://github.com/WordPress), por ejemplo, comenzaron como un "fork" de un proyecto existente llamado [b2](https://github.com/WordPress/book/blob/HEAD/Content/Part%201/2-b2-cafelog.md).

* **Transparencia:** Cualquiera puede inspeccionar un proyecto de este tipo, ya sea para encontrar errores como inconsistencias. La transparencia es de importancia para gobiernos como el de [Bulgaria](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-open-source-98bf626cf70a) o [United States](https://www.cio.gov/2016/08/11/peoples-code.html), para industrias reguladas como la bancaria o la del cuidado de la salud, y para la seguridad del software como [Let's Encrypt](https://github.com/letsencrypt).

C&oacute;digo abierto no es solamente software. Uno puede "abrir" cualquier cosa, desde conjuntos de datos, hasta libros. Mira esto [GitHub Explore](https://github.com/explore) para tener otros ejemplos.

### &iquest;"C&oacute;digo Abierto" significa gratis?

Una de las cosas que causa confusi&oacute;n es el que el c&oacute;digo abierto no cuesta dinero, es decir, es gratuito. Sin embargo, es un subproducto del valor general del "C&oacute;digo abierto".

Esto es debido a que [una licencia open source requiere](https://opensource.org/osd-annotated) que cualquiera pueda usar, modificar, y compartir sus proyectos para casi cualquier prop&oacute;sito, y los proyectos en s&iacute; mismos suelen ser gratuitos. Si el uso del proyecto cuesta dinero, cualquiera puede legalmente hacer una copia del mismo y usar la versi&oacute;n gratuita en su lugar.

El resultado es que la mayor parte de los proyectos de este tipo son gratuitos, pero "gratuito" no forma parte de la definici&oacute;n del "C&oacute;digo Abierto". Hay formas de cobrar por estos proyectos en forma indirecta a trav&eacute;s de licencias duales o funcionalidad limitada, y al mismo tiempo cumplir con la definici&oacute;n oficial del "C&oacute;digo Abierto".

## ¿Deber&iacute;a lanzar mi propio proyecto de C&oacute;digo Abierto?

La respuesta corta es "S&iacute;", debido a que, sin importar lo que suceda, lanzar tu propio proyecto es una buena forma de aprender acerca de c&oacute;mo funciona el c&oacute;digo abierto.

Si nunca has utilizado este concepto en el pasado, probablemente est&eacute;s preocupado de lo que otras personas digan, o que no digan nada. Si esto es as&iacute;, debes saber que no est&aacute;s solo.

El c&oacute;digo abierto funciona como cualquier otra actividad creativa, ya sea escribir o pintar. Puede dar miedo de compartir algo con el mundo, pero la &uacute;nica forma de mejorar es practicar (a&uacute;n si no tienes una audiencia).

Si no estás convencido todav&iacute;a, toma un momento para pensar acerca de cu&aacute;les ser&aacute;n tus objetivos.

### Definiendo tus objetivos

Los objetivos pueden ayudarte a detectar puntos en los que continuar trabajando, a qu&eacute; decirle que no, y a d&oacute;nde recurrir por ayuda. Comienza pregunt&aacute;ndote, _&iquest;Por qu&eacute; estoy haciendo "c&oacute;digo abierto" a mi proyecto?_

No hay nunca una respuesta correcta a esta pregunta. Puedes tener m&uacute;ltiples objetivos para un solo proyecto o diferentes proyectos con diferentes objetivos.

Si tu &uacute;nico objetivo es mostrar al mundo tu trabajo, quiz&aacute;s no necesites ni quieras contribuci&oacute;n, y quiz&aacute;s digas eso en el README. Por otra parte, si quieres ayuda, invertir&aacute;s tiempo en clarificar la documentaci&oacute;n y en hacer sentir a los reci&eacute;n llegados bienvenidos.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">
  En alg&uacute;n punto cre&eacute; un UIAlertView personalizado que estaba usando... Y decid&iacute; hacerlo c&oacute;digo abierto. Entonces lo modifiqu&eacute; para que fuera m&aacute;s din&aacute;mico y lo sub&iacute; a GitHub. Adem&aacute;s escrib&iacute; mi primera documentaci&oacute;n explicando a otros desarrolladores c&oacute;mo usarlo en sus proyectos. Probablemente nadie jam&aacute;s lo haya usado porque era un proyecto muy simple, pero me sent&iacute;a bien habiendo contribuido.
  <p markdown="1" class="pquote-credit">
— @mavris, ["Self-taught Software Developers: Why Open Source is important to us"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

A medida que tu proyecto crezca, tu comunidad podr&aacute; llegar a necesitar m&aacute;s que solamente el c&oacute;digo. Es decir, necesitar&aacute; que respondas a issues, que revises el c&oacute;digo, entre otras tareas importantes en un proyecto de esta clase.

El tiempo que dediques a tareas ajenas a codificar depender&aacute; del tama&ntilde;o y alcance de tus proyectos, deber&iacute;as estar preparado, como encargado de mantenimiento, a afrontarlas por tu cuenta o encontrar a alguien que pueda ayudarte.

**Si eres parte de una compa&ntilde;ia que quiere "abrir" el c&oacute;digo de un proyecto,** debes asegurarte que el mismo tiene recursos internos que necesitan mejorar. Necesitar&aacute;s identificar al responsable de mantener el proyecto una vez lanzado y definir c&oacute;mo vas a compartir esas tareas con tu comunidad.

Si necesitas un presupuesto dedicado o personal para la promoci&oacute;n, operaci&oacute;n y mantenimiento del proyecto, empieza esas conversaciones de forma temprana.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">
  A medida que abres el c&oacute;digo de tu proyecto, es importante que puedas asegurarte de que los procesos de administraci&oacute;n tengan en cuenta a las contribuciones y a las habilidades de la comunidad alrededor de tu proyecto. No hay que asustarse al involucrar contribuyentes, que no est&eacute;n empleados en tu empresa, en aspectos claves del proyecto (especialmente si son contribuyentes frecuentes).
  <p markdown="1" class="pquote-credit">
— @captainsafia, ["So you wanna open source a project, eh?"](https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779)
  </p>
</aside>

### Contribuyendo en otros proyectos.

Si tu meta es aprender c&oacute;mo contribuir con otros o entender c&oacute;mo funciona el "C&oacute;digo Abierto", considera contribuir en proyectos existentes. Comienza con proyectos que ya has estado usando y que te gustan. Contribuir a un proyecto puede ser tan simple como arreglar "typos" o actualizar documentaci&oacute;n.

Si no sab&eacute;s como comenzar a contribuir, mira esta [Gu&iacute;a sobre c&oacute;mo contribuir](../how-to-contribute/).

## Lanzando tu propio proyecto de C&oacute;digo Abierto

No hay momento perfecto para abrir el c&oacute;digo de tu trabajo. Puedes abrir el de una idea, el de un trabajo en progreso o despu&eacute;s de varios a&ntilde;os de ser un proyecto cerrado.

Generalmente, puedes abrir el c&oacute;digo de tu proyecto cuando te sientas c&oacute;modo de que otras personas vean y te aconsejen sobre tu trabajo.

No importa en qu&eacute; etapa decidas hacerlo, cada proyecto debe incluir la siguiente documentaci&oacute;n.

* [Licencia de C&oacute;digo Abierto](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [Pautas para contribuir](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [C&oacute;digo de conducta](../code-of-conduct/)

Como encargado de mantenimiento, estos componentes ayudar&aacute;n a comunicar tus deseos, manejar tus contribuciones y proteger los derechos legales de cada uno (incluy&eacute;ndote). Incrementan significativamente tus posibilidades de tener una experiencia positiva.

Si tu proyecto est&aacute; en GitHub, colocar estos archivos en tu directorio ra&iacute;z con las recomendaciones de nombrado de los mismos, te ayudar&aacute; a que GitHub los reconozca autom&aacute;ticamente y muestre a tus lectores.

### Eligiendo una licencia

Una licencia de C&oacute;digo Abierto garantiza que otros puedan usar, copiar, modificar y contribuir en tu proyecto sin problemas. Adem&aacute;s ayuda a protegerte de situaciones legales complejas. **&iexcl;Debes elegir una licencia cuando inicias tu proyecto!**

El trabajo legal no es divertido. La buena noticia es que puedes copiar y pegar una licencia existente en tu repositorio. Solo llevar&aacute; un minuto proteger tu trabajo.

[MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/), y [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) son las licencias m&aacute;s populares, pero [hay otras opciones](https://choosealicense.com) para elegir.

Cuando creas un nuevo proyecto en GitHub, te dan la opci&oacute;n de seleccionar una licencia. Incluir una licencia de C&oacute;digo Abierto har&aacute; tu proyecto efectivamente de C&oacute;digo Abierto.

![&iexcl;Debes elegir una licencia!](/assets/images/starting-a-project/repository-license-picker.png)

Si tienes otras preguntas acerca del aspecto legal al manejar proyectos de este tipo, [te tenemos cubierto](../legal/).

### Escribiendo un README

Los README hacen m&aacute;s que explicar c&oacute;mo usar tu proyecto, tambi&eacute;n explican por qu&eacute; importa el mismo, y qu&eacute; pueden hacer los usuarios con &eacute;l.

Trata de que tu README responda a las siguientes preguntas:

* &iquest;Qu&eacute; hace el proyecto?
* &iquest;Por qu&eacute; es &uacute;til?
* &iquest;C&oacute;mo se debe comenzar?
* &iquest;D&oacute;nde puedo buscar m&aacute;s informaci&oacute;n? (si es que la necesito)

Puedes usarlo para responder otras preguntas: c&oacute;mo manejo las contribuciones, cu&aacute;les son las metas del proyecto, e informaci&oacute;n acerca de licencias y atribuciones. Si no quieres aceptar contribuciones, o tu proyecto no est&aacute; listo para producci&oacute;n, lo escribes.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">
  Mejor documentaci&oacute;n significa m&aacute;s usuarios, menos pedidos de soporte, y m&aacute;s contribuyentes. Recuerda que tus lectores no son t&uacute;, son personas que quiz&aacute;s acudan al proyecto con experiencias totalmente distintas a las tuyas.
  <p markdown="1" class="pquote-credit">
— @tracymakes, ["Writing So Your Words Are Read (video)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

Algunas veces las personas evitan escribir el README debido a que sienten que su proyecto est&aacute; incompleto, o qu&eacute; no quiere contribuciones. Ambas son muy buenas razones para escribir uno...

Para m&aacute;s inspiraci&oacute;n, trata de usar @18F's ["Making READMEs Readable"](https://pages.18f.gov/open-source-guide/making-readmes-readable/) o @PurpleBooth's [README template](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2) para escribir un README.

Cuando incluyes un archivo de este tipo en tu directorio ra&iacute;z, GitHub autom&aacute;ticamente lo mostrar&aacute; en la p&aacute;gina principal del repositorio.

### Escribiendo las pautas para contribuir

Un archivo CONTRIBUTING le da informaci&oacute;n a la audiencia acerca de c&oacute;mo participar en el proyecto, por ejemplo:

* C&oacute;mo archivar un reporte de bug (trata de usar [issue and pull request templates](https://github.com/blog/2111-issue-and-pull-request-templates))
* C&oacute;mo sugerir una nueva funcionalidad/caracter&iacute;stica
* C&oacute;mo establecer tu entorno y correr pruebas

Adem&aacute;s de detalles t&eacute;cnicos, este archivo es una oportunidad para comunicar tus expectativas, como:

* Los tipos de contribuci&oacute;n que esperas
* Tu visi&oacute;n del proyecto (La hoja de ruta)
* C&oacute;mo deber&iacute;an comunicarse (o c&oacute;mo no) los contribuyentes contigo

Usando un tono c&aacute;lido y amigable, y ofreciendo sugerencias espec&iacute;ficas para contribuciones puede ayudar a los iniciados a sentirse bienvenidos y ansiosos de participar.

Por ejemplo, [Active Admin](https://github.com/activeadmin/activeadmin/) comienza [su gu&iacute;a de contribuciones](https://github.com/activeadmin/activeadmin/blob/HEAD/CONTRIBUTING.md) con:

> Primero, muchas gracias por considerar contribuir a Active Admin. Son personas como ustedes las que la hacen una gran herramienta.

En las primeras etapas del proyecto, tu archivo CONTRIBUTING puede ser simple. Siempre debes explicar c&oacute;mo reportar bugs o issues, y cualquier requerimiento t&eacute;cnico (como tests) para hacer una contribuci&oacute;n.

Con el tiempo, quiz&aacute;s debas agregar otras "preguntas frecuentes" a tu archivo. Escribir esta informaci&oacute;n significa que menos personas te preguntar&aacute;n nuevamente la misma pregunta.

Para m&aacute;s informaci&oacute;n sobre este tema, puedes acceder a @nayafia's [contributing guide template](https://github.com/nayafia/contributing-template/blob/HEAD/CONTRIBUTING-template.md) o @mozilla's ["How to Build a CONTRIBUTING.md"](https://mozillascience.github.io/working-open-workshop/contributing/).

Vincula tu CONTRIBUTING desde tu README, as&iacute; m&aacute;s personas pueden verlo.Si tu [colocas el archivo en tu repositorio](https://help.github.com/articles/setting-guidelines-for-repository-contributors/), GitHub autom&aacute;ticamente lo vincular&aacute; cuando un contribuyente cree un issue o abra un pull request.

![Pautas para contribuir](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### Estableciendo un c&oacute;digo de conducta.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">
  Todos hemos experimentado cierta sensaci&oacute;n de abuso cuando nos han tratado de explicar por qu&eacute; algo tiene que ser de determinada forma, o como usuarios al hacer una pregunta simple. (...) Un c&oacute;digo de conducta se vuelve una forma sencilla (referenciable y vinculable) de documento que nos indica que un equipo toma las cr&iacute;ticas constructivas seriamente.
  <p markdown="1" class="pquote-credit">
— @mlynch, ["Making Open Source a Happier Place"](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

Finalmente, un c&oacute;digo de conducta ayuda a establecer reglas base de comportamiento para los participantes de tus proyectos. Esto es muy deseable si est&aacute;s lanzando un nuevo proyecto de c&oacute;digo abierto para una compa&ntilde;&iacute;a o comunidad. Un c&oacute;digo de conducta facilita un comportamiento en comunidad sano y constructivo, reduciendo tu estr&eacute;s como encargado de mantenimiento.

Para m&aacute;s informaci&oacute;n, entra a [Gu&iacute;a del C&oacute;digo de Conducta](../code-of-conduct/).

Adem&aacute;s de comunicar _c&oacute;mo_ esperas que se comporten los participantes, un c&oacute;digo de conducta tiende a describir a qui&eacute;n se aplican las expectativas, cuando apliquen, y qu&eacute; hacer si una violaci&oacute;n a las mismas ocurre.

Como muchas licencias de c&oacute;digo abierto, existen est&aacute;ndares emergentes para c&oacute;digos de conducta para que no debas escribir uno propio. El [Contributor Covenant](https://www.contributor-covenant.org/) es un c&oacute;digo de conducta usado por [m&aacute;s de 40000 proyectos de c&oacute;digo abierto](https://www.contributor-covenant.org/adopters), incluyendo Kubernetes, Rails, and Swift. Debes estar preparado para redefinir el tuyo cuando sea necesario.

Copia el texto directamente en el archivo CODE_OF_CONDUCT dentro de tu repositorio, en el directorio ra&iacute;z, y vincúlalo desde tu README.

## Dando un nombre y una marca a tu proyecto

La marca es m&aacute;s que elegir un nombre atractivo y un buen logo. Es acerca de c&oacute;mo hablar de tu proyecto y llegar a la gente.

### Eligiendo el nombre correcto

Debes elegir un nombre sencillo de recordar y que en lo posible de una idea de lo que el proyecto hace. Ejemplos son:

* [Sentry](https://github.com/getsentry/sentry) monitorea apps
* [Thin](https://github.com/macournoyer/thin) es un server de Ruby

Si est&aacute;s construyendo sobre un proyecto ya existente, usar su nombre como prefijo suele clarificar lo que el mismo hace (ejemplo: [node-fetch](https://github.com/bitinn/node-fetch) trae `window.fetch` a Node.js).

Considera claridad por sobre todo. Los chismes son divertidos, pero recuerda que algunas bromas pueden no ser traducidas otros idiomas o llevadas a otras culturas, con gente que posee diferentes experiencias a las tuyas. Algunos de tus potenciales usuarios pueden ser empleados de la compa&ntilde;&iacute;a: &iexcl;no debes hacerlos sentir inc&oacute;modos cuando tienen que explicar tu proyecto en el trabajo!

### Evitando conflictos con los nombres

Busca proyectos con el mismo nombre, o similar, especialmente si compartes el mismo ecosistema o idioma. Si tu nombre coincide con alg&uacute;n otro proyecto popular, puede confundir a las personas.

Si quieres una p&aacute;gina web, manejo de Twitter, u otros &iacute;tems que representen tu proyecto, asegúrate de que puedas asignar el nombre que quieras. En lo posible, [reserva tu nombre ahora](https://instantdomainsearch.com/) para estar tranquilo, aunque a&uacute;n no lo vayas a usar.

Tu nombre no debe infringir ninguna marca (trademark), de ser as&iacute; la compa&ntilde;&iacute;a puede pedirte que des de baja a tu proyecto, o puede tomar acciones legales en tu contra. No vale el riesgo.

Puedes verificar [WIPO](http://www.wipo.int/branddb/en/) para verificar conflictos de este tipo. Si est&aacute;s en una compa&ntilde;&iacute;a, &eacute;sta es una de las cosas con las cual tu [equipo legal puede ayudar](../legal/).

Finalmente, haz una b&uacute;squeda r&aacute;pida en Google: &iquest;Las personas podr&aacute;n encontrar r&aacute;pidamente el nombre? &iquest;En los resultados de b&uacute;squeda aparece algo que no quieres que ellos vean?

### C&oacute;mo escribir y codificar afecta tu marca

Durante el ciclo de vida de tu proyecto, escribir&aacute;s una serie grande de documentos: README, tutoriales, issues, etc..

Ya sea documentaci&oacute;n oficial como casual (un email), tu estilo de redacci&oacute;n debe ser parte de la marca de tu proyecto. Considera c&oacute;mo ser&aacute; visto por tu audiencia y si es o no adecuado.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  He tratado de involucrarme con cada hilo del listado de emails, y mostrando un comportamiento ejemplar, siendo agradable con las personas, tomando sus issues seriamente y tratando de ser de ayuda por sobre todo. Despu&eacute;s de un tiempo las personas no solo me buscaban para hacerme preguntas si no para ayudarme a responderlas, y, para mi sorpresa, imitaban mi estilo.
  <p markdown="1" class="pquote-credit">
— @janl on [CouchDB](https://github.com/apache/couchdb), ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Usando un lenguaje inclusivo, puede ir lejos haciendo que tus proyectos reciban de forma m&aacute;s c&aacute;lida a los nuevos participantes. Mant&eacute;n un lenguaje simple.

Luego de c&oacute;mo expresarte, tu estilo a la hora de codificar puede ser importante tambi&eacute;n. [Angular](https://github.com/johnpapa/angular-styleguide) y [jQuery](https://contribute.jquery.org/style-guide/js/) son ejemplos de proyectos con un riguroso trato en este sentido.

No es necesario escribir una "gu&iacute;a de estilo" para tus proyectos cuando reci&eacute;n est&aacute;s comenzando, y quiz&aacute;s hasta descubras que disfrutas al incorporar distintos estilos de codificaci&oacute;n en tu proyecto. Pero deber&iacute;as anticiparte y definir c&oacute;mo tu redacci&oacute;n y estilo de codificaci&oacute;n puede atraer o no a distintos tipos de personas. Define esto al comienzo.

## Tu checklist a armar previamente al lanzamiento del proyecto

Est&aacute;s listo para iniciar tu propio proyecto de C&oacute;digo Abierto. Aqu&iacute; dejamos un checklist que puede ayudar. &iexcl;Una vez marcadas todas las casillas estás listo para continuar! [Clickea "publish"](https://help.github.com/articles/making-a-private-repository-public/).

**Documentaci&oacute;n**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    El proyecto tiene un archivo LICENCIA con una licencia de C&oacute;digo Abierto.
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    El proyecto tiene documentaci&oacute;n b&aacute;sica (README, CONTRIBUYENDO, C&oacute;DIGO_DE_CONDUCTA).
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    El nombre es f&aacute;cil de recordar, da una idea de lo que el proyecto hace, y no entra en conflicto con un proyecto preexistente ni infringe en marcas registadas.
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    La cola de issues est&aacute; actualizada, organizada y etiquetada.
  </label>
</div>

**Code**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Los proyectos usan c&oacute;digo consistente en cuanto a las convenciones usadas, adem&aacute;s de nombres claros de funciones, m&eacute;todos y variables.
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    El c&oacute;digo est&aacute; comentado correctamente, y documentado.
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    No hay material sensible en la revisi&oacute;n hist&oacute;rica, issues, o pull requests. (Ejemplo: contrase&ntilde;as)
  </label>
</div>

**Personas**

Si eres un individuo:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
    Has hablado con el departamento legal y/o entiendes el IP y las pol&iacute;ticas de C&oacute;digo Abierto de tu compa&ntilde;&iacute;a (Si eres empleado en alg&uacute;n lado)
  </label>
</div>

Si eres una compa&ntilde;&iacute;a u organizaci&oacute;n:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Has hablado con tu departamento legal.
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Tienes un plan de marketing para anunciar y promocionar tu proyecto.
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Alguien se ha comprometido a administrar las interacciones de la comunidad.
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Al menos dos personas tienen rol y acceso de administradores al proyecto.
  </label>
</div>

## &iexcl;Lo has hecho!

&iexcl;Felicitaciones por abrir el c&oacute;digo de tu primer proyecto! Sin importar el devenir, trabajar en p&uacute;blico es un regalo a la comunidad. Con cada commit, comentario y pull request, est&aacute;s creando oportunidades no solo para ti, si no para que otras personas puedan aprender y crecer.
