---
lang: es
untranslated: true
title: Mantener el equilibrio para los contribuidores de código abierto
description: Consejos para el autocuidado y evitar el agotamiento como contribuidor.
class: balance
order: 0
image: /assets/images/cards/maintaining-balance-for-open-source-maintainers.png
---

A medida que un proyecto de código abierto gana popularidad, se vuelve importante establecer límites claros para ayudarte a mantener el equilibrio y mantenerte fresco y productivo a largo plazo.

Para obtener información sobre las experiencias de los contribuidores y sus estrategias para encontrar el equilibrio, realizamos un taller con 40 miembros de la <a href="http://maintainers.github.com/">Comunidad de Contribuidores</a>, lo que nos permitió aprender de sus experiencias de primera mano con el agotamiento en el código abierto y las prácticas que les han ayudado a mantener el equilibrio en su trabajo. Aquí es donde entra en juego el concepto de ecología personal.

Entonces, ¿qué es la ecología personal? Como <a href="https://rockwoodleadership.org/nonprofit-four-day-workweek-can-take-care-still-change-world/#:~:text=personal%20ecology%3A%20maintaining%20balance%2C%20pacing%20and%20efficiency%20to%20sustain%20your%20energy%20over%20a%20lifetime%20of%20activism">describió el Instituto de Liderazgo Rockwood</a>, implica "<strong>mantener el equilibrio, el ritmo y la eficiencia para mantener nuestra energía a lo largo de toda nuestra vida</strong>." Esto enmarcó nuestras conversaciones, ayudando a los contribuidores a reconocer sus acciones y contribuciones como parte de un ecosistema más amplio que evoluciona con el tiempo. El agotamiento, un síndrome resultante del estrés crónico en el lugar de trabajo según lo <a href="https://icd.who.int/browse11/l-m/en#/http://id.who.int/icd/entity/129180281">definido por la OMS</a>, no es infrecuente entre los contribuidores. Esto a menudo conduce a una pérdida de motivación, una incapacidad para concentrarse y una falta de empatía hacia los contribuyentes y la comunidad con la que trabajas.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  No podía concentrarme ni comenzar una tarea. Tenía falta de empatía hacia los usuarios.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, contribuidor del servidor de transmisión en vivo Owncast, sobre el impacto del agotamiento en su trabajo de código abierto
  </p>
</aside>

Al abrazar el concepto de ecología personal, los contribuidores pueden evitar el agotamiento de manera proactiva, priorizar el autocuidado y mantener un sentido de equilibrio para hacer su mejor trabajo.

## Consejos para el autocuidado y evitar el agotamiento como contribuidor:

### Identifica tus motivaciones para trabajar en código abierto

Tómate un tiempo para reflexionar sobre qué partes del mantenimiento de código abierto te energizan. Comprender tus motivaciones puede ayudarte a priorizar el trabajo de una manera que te mantenga comprometido y listo para enfrentar nuevos desafíos. Ya sea por los comentarios positivos de los usuarios, la alegría de colaborar y socializar con la comunidad o la satisfacción de sumergirte en el código, reconocer tus motivaciones puede ayudarte a dirigir tu enfoque.

### Reflexiona sobre lo que te lleva a desequilibrarte y estresarte

Es importante entender qué nos lleva al agotamiento. Aquí hay algunas temas comunes que vimos entre los contribuidores de código abierto:

* **Falta de comentarios positivos:** Los usuarios son mucho más propensos a comunicarse cuando tienen una queja. Si todo funciona bien, tienden a quedarse en silencio. Puede ser desalentador ver una creciente lista de problemas sin los comentarios positivos que muestren cómo tus contribuciones están marcando la diferencia.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/thisisnic?s=180" class="pquote-avatar" alt="avatar">
  A veces se siente un poco como gritar en el vacío y encuentro que los comentarios realmente me energizan. Tenemos muchos usuarios felices pero callados.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/thisisnic">@thisisnic</a>, contribuidor de Apache Arrow
  </p>
</aside>

* **No decir 'no':** Puede ser fácil asumir más responsabilidades de las que deberías en un proyecto de código abierto. Ya sea de usuarios, contribuyentes u otros contribuidores, no siempre podemos cumplir con sus expectativas.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/agnostic-apollo?s=180" class="pquote-avatar" alt="avatar">
  Descubrí que estaba asumiendo más de lo que uno debería y teniendo que hacer el trabajo de varias personas, como comúnmente se hace en el software de código abierto.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/agnostic-apollo">@agnostic-apollo</a>, contribuidor de Termux, sobre lo que causa el agotamiento en su trabajo
  </p>
</aside>

* **Trabajar solo:** Ser un contribuidor puede ser increíblemente solitario. Incluso si trabajas con un grupo de contribuidores, los últimos años han sido difíciles para reunir equipos distribuidos en persona.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gabek?s=180" class="pquote-avatar" alt="avatar">
  Especialmente desde la COVID-19 y el trabajo desde casa, es más difícil no ver a nadie ni hablar con nadie.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/gabek">@gabek</a>, contribuidor del servidor de transmisión en vivo Owncast, sobre el impacto del agotamiento en su trabajo de código abierto
  </p>
</aside>

* **Falta de tiempo o recursos:** Esto es especialmente cierto para los contribuidores voluntarios que tienen que sacrificar su tiempo libre para trabajar en un proyecto.

<aside markdown="1" class="pquote">
  [Me gustaría tener] más apoyo financiero, para poder enfocarme en el trabajo de código abierto sin gastar mis ahorros y sabiendo que tendré que hacer muchos contratos para compensarlo más tarde.
  <p markdown="1" class="pquote-credit">
— contribuidor de código abierto
  </p>
</aside>

* **Demandas en conflicto:** El código abierto está lleno de grupos con diferentes motivaciones, lo que puede ser difícil de navegar. Si te pagan por hacer código abierto, los intereses de tu empleador a veces pueden entrar en conflicto con la comunidad.

<aside markdown="1" class="pquote">
  Con el código abierto pagado, conflicto entre el enfoque del empleador y lo que es mejor para la comunidad.
  <p markdown="1" class="pquote-credit">
— contribuidor de código abierto
  </p>
</aside>

### Esté atento a los signos de agotamiento

¿Puedes mantener tu ritmo durante 10 semanas? ¿10 meses? ¿10 años?

Existen herramientas como la [Lista de verificación de agotamiento](https://governingopen.com/resources/signs-of-burnout-checklist.html) de [@shaunagm](https://github.com/shaunagm) que pueden ayudarte a reflexionar sobre tu ritmo actual y ver si hay ajustes que puedas hacer. Algunos contribuidores también utilizan tecnología portátil para realizar un seguimiento de métricas como la calidad del sueño y la variabilidad de la frecuencia cardíaca (ambas vinculadas al estrés).

<aside markdown="1" class="pquote">
  Soy un gran creyente en las buenas tecnologías portátiles. Con la ciencia detrás de ello, puedes entender cómo podrías haberlo hecho mejor y cómo llegar a un estado óptimo de lo que quieres hacer.
  <p markdown="1" class="pquote-credit">
— contribuidor de código abierto
  </p>
</aside>

### ¿Qué necesitarías para seguir sosteniéndote a ti mismo y a tu comunidad?

Esto será diferente para cada contribuidor y cambiará según tu fase de vida y otros factores externos. Pero aquí hay algunas temas que escuchamos:

* **Apóyate en la comunidad:** Delegar y encontrar colaboradores puede aliviar la carga de trabajo. Tener múltiples puntos de contacto para un proyecto puede ayudarte a tomar un descanso sin preocupaciones. Conéctate con otros contribuidores y la comunidad en general, en grupos como la [Comunidad de Contribuidores](http://maintainers.github.com/). Esto puede ser un gran recurso para el apoyo entre pares y el aprendizaje.

  También puedes buscar formas de involucrarte con la comunidad de usuarios para escuchar regularmente comentarios y comprender el impacto de tu trabajo de código abierto.

* **Explora financiamiento:** Ya sea que estés buscando algo de dinero extra o tratando de dedicarte por completo al código abierto, ¡hay muchos recursos para ayudarte! Como primer paso, considera activar [Patrocinadores de GitHub](https://github.com/sponsors) para permitir que otros patrocinen tu trabajo de código abierto. Si estás pensando en dar el salto a tiempo completo, solicita la próxima ronda del [Acelerador de GitHub](http://accelerator.github.com/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mansona?s=180" class="pquote-avatar" alt="avatar">
  Estuve en un podcast hace un tiempo y estábamos hablando sobre el mantenimiento de código abierto y la sostenibilidad. Descubrí que incluso un pequeño número de personas que apoyan mi trabajo en GitHub me ayudó a tomar una decisión rápida de no sentarme frente a un juego, sino de hacer una pequeña cosa con el código abierto.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mansona">@mansona</a>, contribuidor de EmberJS
  </p>
</aside>

* **Utiliza herramientas:** Explora herramientas como [GitHub Copilot](https://github.com/features/copilot/) y [GitHub Actions](https://github.com/features/actions/) para automatizar tareas mundanas y liberar tu tiempo para contribuciones más significativas.

<aside markdown="1" class="pquote">
  Usa [Copilot](https://github.com/features/copilot/) para las cosas aburridas; haz las cosas divertidas.
  <p markdown="1" class="pquote-credit">
— contribuidor de código abierto
  </p>
</aside>

* **Descansa y recarga energías:** Dedica tiempo a tus pasatiempos e intereses fuera del código abierto. ¡Tómate los fines de semana libres para relajarte y rejuvenecer, y establece tu [estado de GitHub](https://docs.github.com/account-and-profile/setting-up-and-managing-your-github-profile/customizing-your-profile/personalizing-your-profile#setting-a-status) para reflejar tu disponibilidad! Una buena noche de sueño puede marcar una gran diferencia en tu capacidad para mantener tus esfuerzos a largo plazo.

  Si encuentras que ciertos aspectos de tu proyecto son especialmente gratificantes, trata de estructurar tu trabajo para que puedas experimentarlos a lo largo del día.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/danielroe?s=180" class="pquote-avatar" alt="avatar">
  Estoy encontrando más oportunidades para "momentos de creatividad" en medio del día en lugar de intentar desconectar por la noche.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/danielroe">@danielroe</a>, contribuidor de Nuxt
  </p>
</aside>

* **Establece límites:** No puedes decir que sí a todas las solicitudes. Esto puede ser tan simple como decir: "No puedo ocuparme de eso en este momento y no tengo planes de hacerlo en el futuro", o listar lo que estás interesado en hacer y lo que no en el README. Por ejemplo, podrías decir: "Solo fusiono PR que tengan razones claramente enumeradas por las que se hicieron", o "Solo reviso problemas los jueves alternos de 6 a 7 pm". Esto establece expectativas para los demás y te da algo a lo que puedes hacer referencia en otros momentos para ayudar a reducir las demandas de los contribuyentes o usuarios sobre tu tiempo.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikemcquaid?s=180" class="pquote-avatar" alt="avatar">
  Para confiar de manera significativa en otros en estos aspectos, no puedes ser alguien que diga sí a todas las solicitudes. Al hacerlo, no mantienes límites, profesional o personalmente, y no serás un compañero confiable.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/mikemcquaid">@mikemcquaid</a>, contribuidor de Homebrew sobre [Cómo decir no](https://mikemcquaid.com/saying-no/)
  </p>
</aside>

  Aprende a ser firme en la eliminación del comportamiento tóxico y las interacciones negativas. Está bien no dar energía a las cosas que no te importan.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/IvanSanchez?s=180" class="pquote-avatar" alt="avatar">
  Mi software es gratuito, pero mi tiempo y atención no lo son.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/IvanSanchez">@IvanSanchez</a>, contribuidor de Leaflet
  </p>
</aside>

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/foosel?s=180" class="pquote-avatar" alt="avatar">
  No es un secreto que el mantenimiento de código abierto tiene sus lados oscuros, y uno de ellos es tener que interactuar a veces con personas bastante ingratas, exigentes o directamente tóxicas. A medida que aumenta la popularidad de un proyecto, también aumenta la frecuencia de este tipo de interacción, lo que añade una carga adicional a los contribuidores y posiblemente se convierte en un factor de riesgo significativo para el agotamiento de los contribuidores.
  <p markdown="1" class="pquote-credit">
— <a href="https://github.com/foosel">@foosel</a>, contribuidor de Octoprint sobre [Cómo lidiar con personas tóxicas](https://www.youtube.com/watch?v=7lIpP3GEyXs)
  </p>
</aside>

Recuerda, la ecología personal es una práctica continua que evolucionará a medida que avances en tu viaje de código abierto. Al priorizar el autocuidado y mantener un sentido de equilibrio, puedes contribuir eficazmente a la comunidad de código abierto de manera sostenible, asegurando tanto tu bienestar como el éxito de tus proyectos a largo plazo.

## Recursos adicionales

* [Comunidad de Contribuidores](http://maintainers.github.com/)
* [El contrato social del código abierto](https://snarky.ca/the-social-contract-of-open-source/), Brett Cannon
* [Uncurled](https://daniel.haxx.se/uncurled/), Daniel Stenberg
* [Cómo lidiar con personas tóxicas](https://www.youtube.com/watch?v=7lIpP3GEyXs), Gina Häußge
* [SustainOSS](https://sustainoss.org/)
* [Rockwood Art of Leadership](https://rockwoodleadership.org/art-of-leadership/)
* [Cómo decir no](https://mikemcquaid.com/saying-no/), Mike McQuaid
* [Gobernanza del Código Abierto](https://governingopen.com/)
* La agenda del taller se basó en [Movimiento de construcción desde casa de Mozilla](https://foundation.mozilla.org/en/blog/its-a-wrap-movement-building-from-home/)

## Colaboradores

¡Muchas gracias a todos los contribuidores que compartieron sus experiencias y consejos con nosotros para esta guía!

Esta guía fue escrita por [@abbycabs](https://github.com/abbycabs) con contribuciones de:

[@agnostic-apollo](https://github.com/agnostic-apollo)
[@AndreaGriffiths11](https://github.com/AndreaGriffiths11)
[@antfu](https://github.com/antfu)
[@anthonyronda](https://github.com/anthonyronda)
[@CBID2](https://github.com/CBID2)
[@Cli4d](https://github.com/Cli4d)
[@confused-Techie](https://github.com/confused-Techie)
[@danielroe](https://github.com/danielroe)
[@Dexters-Hub](https://github.com/Dexters-Hub)
[@eddiejaoude](https://github.com/eddiejaoude)
[@Eugeny](https://github.com/Eugeny)
[@ferki](https://github.com/ferki)
[@gabek](https://github.com/gabek)
[@geromegrignon](https://github.com/geromegrignon)
[@hynek](https://github.com/hynek)
[@IvanSanchez](https://github.com/IvanSanchez)
[@karasowles](https://github.com/karasowles)
[@KoolTheba](https://github.com/KoolTheba)
[@leereilly](https://github.com/leereilly)
[@ljharb](https://github.com/ljharb)
[@nightlark](https://github.com/nightlark)
[@plarson3427](https://github.com/plarson3427)
[@Pradumnasaraf](https://github.com/Pradumnasaraf)
[@RichardLitt](https://github.com/RichardLitt)
[@rrousselGit](https://github.com/rrousselGit)
[@sansyrox](https://github.com/sansyrox)
[@schlessera](https://github.com/schlessera)
[@shyim](https://github.com/shyim)
[@smashah](https://github.com/smashah)
[@ssalbdivad](https://github.com/ssalbdivad)
[@The-Compiler](https://github.com/The-Compiler)
[@thehale](https://github.com/thehale)
[@thisisnic](https://github.com/thisisnic)
[@tudoramariei](https://github.com/tudoramariei)
[@UlisesGascon](https://github.com/UlisesGascon)
[@waldyrious](https://github.com/waldyrious) + muchos más!
