---
lang: es
title: Recibir Pagos por Trabajos en C&oacute;digo Abierto
description: Mant&eacute;n tu trabajo de c&oacute;digo abierto al encontrar apoyo financiero por tu tiempo o tu proyecto.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## ¿Por qu&eacute; algunas personas buscan apoyo financiero?

La mayor parte del trabajo realizado en proyectos de c&oacute;digo abierto es voluntario. Por ejemplo, alguien puede encontrarse con un error en un proyecto que usan y aplican una correcci&oacute;n r&aacute;pida, o simplemente les puede gustar corregir proyectos de c&oacute;digo abierto en su tiempo libre.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Estaba buscando un proyecto de programaci&oacute;n para tenerlo como "hobby" y que me mantuviese ocupado en la semana de Navidad. (...) Ten&iacute;a un ordenador personal y no mucho m&aacute;s. Decid&iacute; escribir un interpretador para un nuevo lenguaje en el que he estado pensando &uacute;ltimamente. (...) Eleg&iacute; Python como t&iacute;tulo de mi trabajo.
  <p markdown="1" class="pquote-credit">
— @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Hay muchas razones por las cuales a una persona no le gustar&iacute;a que le pagaran por su trabajo en c&oacute;digo abierto.

* **Ellos pueden llegar a tener ya un trabajo de tiempo completo que disfruten**, que los habilite a contribuir al c&oacute;digo abierto en su tiempo libre.
* **Les gusta contribuir a los proyectos de c&oacute;digo abierto como un hobby** o escape creativo y no quieren sentirse financieramente obligados a trabajar.
* **Reciben otros beneficios al contribuir al c&oacute;digo abierto,** como construir su portfolio de reputaci&oacute;n, obtener nuevas habilidades, o sentirse cercanos a una comunidad.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Las donaciones financieras agregan un sentimiento de responsabilidad, para algunos. (...) Es importante para nosotros, en el mundo globalmente conectado y apresurado en el que vivimos, ser capaces de decir: "Espera, no ahora, quiero hacer algo completamente diferente".
  <p markdown="1" class="pquote-credit">
— @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Para otros, especialmente cuando las contribuciones est&aacute;n en proceso o requieren tiempo significativo, recibir dinero al contribuir al c&oacute;digo abierto es la &uacute;nica manera en la que pueden participar. Porque el proyecto lo requiera o por razones personales.

Mantener proyectos populares puede ser una responsabilidad significativa, tomando de 10 a 20 horas por semana en vez de un par de horas por mes.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Preg&uacute;ntale a cualquier responsable de proyecto de c&oacute;digo abierto, y te informar&aacute; sobre la realidad de la cantidad de trabajo que se dedica a la gesti&oacute;n de un proyecto. Tienes clientes. Est&aacute;s arreglando los problemas para ellos. Est&aacute;s creando nuevas funciones. Esto se convierte en una demanda real de tu tiempo.
  <p markdown="1" class="pquote-credit">
— @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

El trabajo pagado tambi&eacute;n habilita a todo tipo de personas a aportar significativamente. Algunas no pueden afrontar un trabajo ad-honorem (trabajo gratis) en proyectos de c&oacute;digo abierto, ya sea por su posici&oacute;n financiera, deudas, familia u otras responsabilidades. Eso significa que el mundo nunca ve contribuciones de personas talentosas que no pueden donar horas de trabajo. Estas implicaciones &eacute;ticas como @ashedryden [ha descrito](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community), desde que el trabajo hecho es parcialmente en favor de las personas que tienen ventajas en su vida, quienes de vuelta ganan ventajas adicionales basadas en sus contribuciones voluntarias, mientras que otros que no pueden ofrecerse voluntariamente no obtiene nuevas oportunidades, lo cual refuerza la actual falta de diversidad en la comunidad de c&oacute;digo abierto.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   OSS obtiene beneficios mas&iacute;vos de la industria de la tecnolog&iacute;a, que, al mismo tiempo, significa beneficios para todas las industrias. (...) Por otro lado, si las &uacute;nicas personas que pueden concentrarse en ello son aquellas con suerte y obsesionadas, entonces hay un gran potencial no explotado.
  <p markdown="1" class="pquote-credit">
— @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Si tu est&aacute;s buscando apoyo financiero, hay dos posibles caminos a seguir: puedes pagar por tu propio tiempo como contribuyente, o puedes encontrar organizaciones que aporten a tu proyecto.

## Financiando tu propio tiempo

Hoy en d&iacute;a, muchas personas reciben pagos por trabajos a tiempo parcial o tiempo completo en c&oacute;digo abierto. El modo m&aacute;s com&uacute;n de recibir una paga por tu tiempo es hablar con tu empleador.

Es m&aacute;s f&aacute;cil establecer un trabajo en c&oacute;digo abierto si tu empleador usa el proyecto, pero ponte creativo. Puede que tu empleador no use el proyecto, pero usa Python, y mantener un proyecto popular de Python puede atraer nuevos desarrolladores de Python. Tambi&eacute;n puede que haga que tu empleador se vea m&aacute;s desarrollador-amigable en general.

Si tu no tienes un excitante proyecto de c&oacute;digo abierto en el que quisieras trabajar, pero te gustar&iacute;a que tu actual trabajo genere aportes al c&oacute;digo abierto, establece un acuerdo con tu empleador para aportar algo del software interno de la organizaci&oacute;n a la comunidad de c&oacute;digo abierto.

Muchas empresas est&aacute;n desarrollando programas de c&oacute;digo abierto para construir su marca y reclutar talentos de calidad.

@hueniverse, por ejemplo, encontr&oacute; que hab&iacute;a razones financieras para justificar [la inversi&oacute;n de Walmart al c&oacute;digo abierto](http://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). Y @jamesgpearce descubri&oacute; que el programa de c&oacute;digo abierto de Facebook [hizo la diferencia](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) en el reclutamiento:

> Est&aacute; alineado con nuestra cultura hacker, y c&oacute;mo nuestra organizacion era percibida. Le preguntamos a nuestros empleados, "¿Sab&iacute;as del programa de software de c&oacute;digo abierto de Facebook?. Dos tercios dijeron "S&iacute;". Una mitad dijo que el programa contribu&iacute;a positivamente en la decisi&oacute;n de trabajar para nosotros. Estos no son n&uacute;meros marginales, y, espero, que la moda contin&uacute;e.

Si tu empresa va por esta ruta, es importante mantener clara la relaci&oacute;n entre la comunidad y la actividad corporativa. &uacute;ltimamente, el c&oacute;digo abierto se mantiene a s&iacute; mismo a trav&eacute;s de contribuciones de personas de todo el mundo, y eso es m&aacute;s importante que la empresa o la ubicaci&oacute;n de la misma.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Recibir dinero por trabajar en proyectos de c&oacute;digo abierto es una rara y hermosa oportunidad, pero no tienes que dejar de lado tu pasi&oacute;n en el proceso. Tu pasi&oacute;n deber&iacute;a ser el porqu&eacute; las empresas te pagar&iacute;an a t&iacute;.
  <p markdown="1" class="pquote-credit">
— @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Si no pueden convencer a tu actual empleador de priorizar un trabajo de c&oacute;digo abierto, considera encontrar un nuevo empleador que motive a los empleados a contribuir. Busca empresas que hagan su dedicaci&oacute;n al c&oacute;digo abierto expl&iacute;cita. Por ejemplo:

* Algunas empresas, como [Netflix](https://netflix.github.io/), tienen p&aacute;ginas web que resaltan su participaci&oacute;n en el c&oacute;digo abierto.
* [Zalando](https://opensource.zalando.com) public&oacute; su [pol&iacute;ticas de contribuci&oacute;n al c&oacute;digo abierto](https://opensource.zalando.com/docs/using/contributing/) para empleados.

Proyectos que se originaron en una empresa grande, como [Go](https://github.com/golang) o [React](https://github.com/facebook/react), ser&aacute;n susceptibles a contratar personas que trabajen en c&oacute;digo abierto.

Finalmente, dependiendo de tus circunstancias personales, puedes probar generar dinero de forma independiente para financiar tu trabajo de c&oacute;digo abierto. Por ejemplo:

* @Homebrew (y [varios mantenedores y organizaciones](https://github.com/sponsors/community)) financian su trabajo a través de [GitHub Sponsors](https://github.com/sponsors)
* @gaearon financi&oacute; su propio trabajo [Redux](https://github.com/reactjs/redux) a trav&eacute;s de [Patreon crowdfunding campaign](https://redux.js.org/)
* @andrewgodwin financi&oacute; su trabajo de migraci&oacute;n de esquemas de Django [a trav&eacute;s de una campa&ntilde;a kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

## Encontrando financiaci&oacute;n para tu proyecto.

M&aacute;s all&aacute; de los arreglos con contribuyentes individuales, a veces los proyectos generan dinero de empresas, individuos, u otras para financiar trabajos en proceso.

La financiaci&oacute;n organizacional podr&iacute;a ir a favor de pagar a los contribuyentes, cubriendo los costos de correr los proyectos (como los costos de hosting), o investigando nuevas funcionalidades o ideas.

Mientras aumenta la popularidad de c&oacute;digo abierto, encontrar financiaci&oacute;n para proyectos sigue siendo experimental, pero hay algunas opciones que comunmente estan disponibles.

### Genera dinero para trabajo a trav&eacute;s de campa&ntilde;as de crowdfunding o sponsors.

Encontrar sponsors funciona si tienes una fuerte audiencia o reputaci&oacute;n ya establecida, o tu proyecto es muy popular.
Algunos ejemplos comunes de proyectos sponsoreados incluyen:

* **[webpack](https://github.com/webpack)** genera dinero de empresas e individuos [a trav&eacute;s de OpenCollective](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** una organizaci&oacute;n sin fines de lucro que paga por el trabajo en [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), y otros proyectos de la infraestructura de Ruby.

### Crea un flujo de ingresos.

Dependiendo de tu proyecto, puede que seas capaz de cobrar por soporte comercial o funciones adicionales. Algunos ejemplos incluyen:

* **[Sidekiq](https://github.com/mperham/sidekiq)** ofrecen versiones pagas por soporte adicional.
* **[Travis CI](https://github.com/travis-ci)** ofrece versiones pagas de su producto.
* **[Ghost](https://github.com/TryGhost/Ghost)** es sin fines de lucro con una gesti&oacute;n de servicio paga.

Algunos proyectos populares, como [npm](https://github.com/npm/cli) y [Docker](https://github.com/docker/docker), generan capital de riesgo para soportar el crecimiento de su negocio.

### Suscr&iacute;bete a subvenciones

Algunas fundaciones de software y compa&ntilde;ias ofrecen subvenciones por trabajo en c&oacute;digo abierto. A veces, las subvenciones puede ser pagadas a individuos sin establecer una entidad legal para el proyecto.

* **[Lee los documentos](https://github.com/rtfd/readthedocs.org)** recibe una subvenci&oacute;n del [Soporte al c&oacute;digo abierto de Mozilla](https://www.mozilla.org/en-US/grants/)
* **[OpenMRS](https://github.com/openmrs)** fue financiado por [un retiro de Stripe](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** recibi&oacute; una subvenci&oacute;n de [Sloan Foundation](https://sloan.org/programs/digital-technology)
* La **[fundaci&oacute;n de software de Python](https://www.python.org/psf/grants/)** ofrece subvenciones a trabajos relacionados con Python.

Por m&aacute;s opciones y casos de estudio, @nayafia [escribi&oacute; una gu&iacute;a](https://github.com/nayafia/lemonade-stand) para recibir pagos por trabajos en proyectos de c&oacute;digo abierto. Diferentes tipos de financiaci&oacute;n requieren diferentes tipos de habilidades, entonces considera tus fortalezas para descubrir que opciones funcionan mejor para ti.

## Creando un caso de apoyo financiero

Sin importar si tu proyecto es una nueva idea, o estuvo dando vueltas por a&ntilde;os, deber&iacute;as preveer que tendr&aacute;s que ponerle mucho esfuerzo en identificar a tu financiador objetivo y construir un caso acorde.

Sin importar si est&aacute;s buscando pagar por tu propio tiempo, o invertir/generar en un proyecto, deber&iacute;as poder responderte las siguientes preguntas:

### Impacto

¿Por qu&eacute; es &uacute;til este proyecto? ¿Por qu&eacute; nuestros usuarios, o potenciales usuarios, les gusta tanto? ¿D&oacute;nde se encontrar&aacute; dentro de cinco a&ntilde;os?

### Atracci&oacute;n

Intenta recolectar evidencia de que tu proyecto importa, sin importar las m&eacute;tricas, an&eacute;cdotas, o testimonios. ¿Hay alguna compa&ntilde;&iacute;a o alg&uacute;n grupo notorio de personas usando tu proyecto ahora mismo? Si no, ¿Hubo alguna persona prominente que lo aprob&oacute;?

### Valor para el financiador

Los financiadores, sin importar si tu empleador o tu fundaci&oacute;n generadora de subvenciones, son frecuentemente ofertados con oportunidades. ¿Porqu&eacute; deber&iacute;an apoyar tu proyecto por sobre toda otra oportunidad? ¿Como se benefician ellos personalmente?

### Uso de la financiaci&oacute;n

¿Qu&eacute; exactamente lograr&aacute;s con la financiaci&oacute;n propuesta? Conc&eacute;ntrate en hitos de proyectos o imprevistos en vez de los pagos de salario.

### Como recibir&aacute;s la financiaci&oacute;n.

¿El financiador tiene algun requisito de como recibir&aacute;s el dinero? Por ejemplo, puede que necesites ser un sponsor o tener un sponsor fiscal sin fines de lucro. O tal vez la financiaci&oacute;n debe ser entregada a un contratador individual en vez de a una organizaci&oacute;n. Estos requisitos var&iacute;an entre los financiadores, as&iacute; que asegurate de hacer averiguaciones de antemano.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">

  Durante a&ntilde;os, hemos sido el principal recurso de iconos amigables de sitios web, con una comunidad de m&aacute;s de 20 millones de personas y hemos destacado en m&aacute;s de 70 millones de sitios web, incluyendo Whitehouse.gov. (...) La versi&oacute;n 4 fue hace tres a&ntilde;os. La tecnolog&iacute;a web ha cambiado mucho desde entonces, y, francamente, Font Awesome se ha vuelto un poco obsoleto. (...) Es por eso que estamos introduciendo Font Awesome 5. Estamos modernizando y reescribiendo el CSS y redise&ntilde;ando cada icono de arriba hacia abajo. Estamos hablando de mejor dise&ntilde;o, mejor consistencia y mejor legibilidad.

  <p markdown="1" class="pquote-credit">
— @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Experimenta y no te rindas

Recaudar dinero no es f&aacute;cil, ya sea un proyecto de c&oacute;digo abierto, una organizaci&oacute;n sin fines de lucro, o un emprendimiento de software, y la mayor&iacute;a de los casos requieren que seas creativo. Debes identificar c&oacute;mo quieres que te paguen, debes investigar y debes ponerte en el lugar de tu financiador, de esta manera podr&aacute;s construir un caso convicente para que te financien.
