---
lang: el
title: Ξεκινώντας ένα Πρότζεκτ Ανοιχτού Κώδικα
description: Μάθετε περισσότερα για τον κόσμο του ανοιχτού κώδικα και ετοιμαστείτε να ξεκινήσετε το δικό σας πρότζεκτ. 
class: beginners
order: 2
image: /assets/images/cards/beginner.png
related:
  - finding
  - building
---

## Το "τι" και το "γιατί" του ανοικτού κώδικα

Σκέφτεστε λοιπόν να ξεκινήσετε με τον ανοιχτό κώδικα; Συγχαρητήρια! Ο κόσμος εκτιμά τη συνεισφορά σας. Ας μιλήσουμε για το τι είναι ο ανοιχτός κώδικας και γιατί οι άνθρωποι το κάνουν.

### Τι σημαίνει "ανοιχτός κώδικας";

Όταν ένα πρότζεκτ είναι ανοικτού κώδικα, αυτό σημαίνει ότι **ο καθένας είναι ελεύθερος να χρησιμοποιήσει, να μελετήσει, να τροποποιήσει και να διανείμει το πρότζεκτ σας για οποιονδήποτε σκοπό.** Αυτά τα δικαιώματα επιβάλλονται μέσω [μιας άδειας ανοικτού κώδικα](https://opensource.org/licenses).

Ο ανοικτός κώδικας είναι ισχυρός επειδή μειώνει τα εμπόδια στην υιοθέτηση και τη συνεργασία, επιτρέποντας στους ανθρώπους να διαδίδουν και να βελτιώνουν πρότζεκτ γρήγορα. Επίσης, επειδή δίνει στους χρήστες τη δυνατότητα να ελέγχουν τους υπολογιστές τους, σε σχέση με τον κλειστό κώδικα. Για παράδειγμα, μια επιχείρηση που χρησιμοποιεί λογισμικό ανοικτού κώδικα έχει τη δυνατότητα να προσλάβει κάποιον για να κάνει προσαρμοσμένες βελτιώσεις στο λογισμικό, αντί να βασίζεται αποκλειστικά στις αποφάσεις ενός προμηθευτή κλειστού κώδικα για το προϊόν.

Το _ελεύθερο λογισμικό_ αναφέρεται στο ίδιο σύνολο πρότζεκτ με το _ανοικτού κώδικα_. Μερικές φορές θα δείτε επίσης [αυτούς τους όρους](https://en.wikipedia.org/wiki/Free_and_open-source_software) συνδυασμένους ως "ελεύθερο λογισμικό και λογισμικό ανοικτού κώδικα" (FOSS) ή "ελεύθερο, ελεύθερο και λογισμικό ανοικτού κώδικα" (FLOSS). Τα _Free_ και _libre_ αναφέρονται στην ελευθερία, [όχι στην τιμή](#ανοιχτός-κώδικας-σημαίνει-δωρεάν).

### Γιατί οι άνθρωποι ανοίγουν το λογισμικό τους;

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/kentcdodds?s=180" class="pquote-avatar" alt="avatar">
  Μια από τις πιο ικανοποιητικές εμπειρίες που αποκομίζω από τη χρήση και τη συνεργασία σε θέματα ανοικτού κώδικα προέρχεται από τις σχέσεις που χτίζω με άλλους προγραμματιστές που αντιμετωπίζουν πολλά από τα ίδια προβλήματα με εμένα.
  <p markdown="1" class="pquote-credit">
- @kentcdodds, ["How getting into Open Source has been awesome for me"](https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me)
  </p>
</aside>

[Υπάρχουν πολλοί λόγοι](https://ben.balter.com/2015/11/23/why-open-source/) για τους οποίους ένα άτομο ή ένας οργανισμός θα ήθελε να ανοίξει τον κώδικα ενός έργου. Μερικά παραδείγματα περιλαμβάνουν:

* **Συνεργασία:** Τα πρότζεκτ ανοικτού κώδικα μπορούν να δέχονται αλλαγές από οποιονδήποτε στον κόσμο. Το [Exercism](https://github.com/exercism/), για παράδειγμα, είναι μια πλατφόρμα ασκήσεων προγραμματισμού με πάνω από 350 συνεισφέροντες.

* **Υιοθέτηση και επανασύνθεση:** Τα πρότζεκτ ανοικτού κώδικα μπορούν να χρησιμοποιηθούν από οποιονδήποτε για σχεδόν οποιονδήποτε σκοπό. Οι άνθρωποι μπορούν ακόμη και να τα χρησιμοποιήσουν για να κατασκευάσουν άλλα πράγματα. Το [WordPress](https://github.com/WordPress), για παράδειγμα, ξεκίνησε ως διακλάδωση ενός υπάρχοντος έργου που ονομαζόταν [b2](https://github.com/WordPress/book/blob/HEAD/Content/Part%201/2-b2-cafelog.md).

* **Διαφάνεια:** Οποιοσδήποτε μπορεί να επιθεωρήσει ένα πρότζεκτ ανοικτού κώδικα για λάθη ή ασυνέπειες. Η διαφάνεια έχει σημασία για κυβερνήσεις όπως η [Βουλγαρία](https://medium.com/@bozhobg/bulgaria-got-a-law-requiring-open-source-98bf626cf70a) ή οι [Ηνωμένες Πολιτείες](https://www.cio.gov/2016/08/11/peoples-code.html), ρυθμιζόμενες βιομηχανίες όπως οι τράπεζες ή η υγειονομική περίθαλψη και λογισμικό ασφαλείας όπως το [Let's Encrypt](https://github.com/letsencrypt).

Ο ανοικτός κώδικας δεν είναι μόνο για το λογισμικό. Μπορείτε να ανοίξετε τα πάντα, από σύνολα δεδομένων μέχρι βιβλία. Ελέγξτε το [GitHub Explore](https://github.com/explore) για ιδέες σχετικά με το τι άλλο μπορείτε να ανοίξετε με ανοικτό κώδικα.

### Ανοιχτός κώδικας σημαίνει "δωρεάν";

Ένα από τα μεγαλύτερα πλεονεκτήματα του ανοικτού κώδικα είναι ότι δεν κοστίζει χρήματα. Το "δωρεάν", ωστόσο, είναι ένα υποπροϊόν της συνολικής αξίας του ανοικτού κώδικα.

Επειδή [μια άδεια χρήσης ανοικτού κώδικα απαιτεί](https://opensource.org/osd-annotated) ότι ο καθένας μπορεί να χρησιμοποιήσει, να τροποποιήσει και να μοιραστεί το πρότζεκτ σας για σχεδόν οποιονδήποτε σκοπό, τα ίδια τα πρότζεκτ τείνουν να είναι δωρεάν. Αν το πρότζεκτ κόστιζε χρήματα για τη χρήση του, ο καθένας θα μπορούσε νόμιμα να δημιουργήσει ένα αντίγραφο και να χρησιμοποιήσει τη δωρεάν έκδοση αντί αυτού.

Ως αποτέλεσμα, τα περισσότερα πρότζεκτ ανοικτού κώδικα είναι δωρεάν, αλλά το "δωρεάν" δεν αποτελεί μέρος του ορισμού του ανοικτού κώδικα. Υπάρχουν τρόποι να χρεώνετε τα πρότζεκτ ανοικτού κώδικα έμμεσα μέσω διπλής αδειοδότησης ή περιορισμένων χαρακτηριστικών, ενώ παράλληλα εξακολουθούν να συμμορφώνονται με τον επίσημο ορισμό του ανοικτού κώδικα.

## Πρέπει να ξεκινήσω το δικό μου πρότζεκτ ανοιχτού κώδικα;

Η σύντομη απάντηση είναι ναι, διότι, ανεξάρτητα από το αποτέλεσμα, το να ξεκινήσετε το δικό σας πρότζεκτ είναι ένας πολύ καλός τρόπος για να μάθετε πώς λειτουργεί ο ανοιχτός κώδικας.

Αν δεν έχετε ποτέ στο παρελθόν ανοίξει ένα πρότζεκτ, μπορεί να έχετε άγχος για το τι θα πει ο κόσμος ή αν θα το προσέξει κανείς. Αν αυτό σας μοιάζει, δεν είστε οι μόνοι!

Η εργασία ανοιχτού κώδικα είναι όπως κάθε άλλη δημιουργική δραστηριότητα, είτε πρόκειται για συγγραφή είτε για ζωγραφική. Μπορεί να αισθάνεστε τρομακτικό να μοιράζεστε τη δουλειά σας με τον κόσμο, αλλά ο μόνος τρόπος για να βελτιωθείτε είναι να εξασκηθείτε - ακόμη και αν δεν έχετε κοινό.

Αν δεν έχετε πειστεί ακόμα, σκεφτείτε για λίγο ποιοι μπορεί να είναι οι στόχοι σας.

### Θέτοντας τους στόχους σας

Οι στόχοι μπορούν να σας βοηθήσουν να καταλάβετε τι πρέπει να δουλέψετε, σε τι να πείτε όχι και πού χρειάζεστε βοήθεια από άλλους. Ξεκινήστε ρωτώντας τον εαυτό σας, _γιατί κάνω open sourcing αυτό το πρότζεκτ;_

Δεν υπάρχει μια σωστή απάντηση σε αυτό το ερώτημα. Μπορεί να έχετε πολλαπλούς στόχους για ένα πρότζεκτ ή διαφορετικά πρότζεκτ με διαφορετικούς στόχους.

Αν ο μόνος σας στόχος είναι να επιδείξετε τη δουλειά σας, μπορεί να μην θέλετε καν συνεισφορές, και μάλιστα να το πείτε αυτό στο README σας. Από την άλλη πλευρά, αν θέλετε συνεισφέροντες, θα επενδύσετε χρόνο σε σαφή τεκμηρίωση και θα κάνετε τους νεοεισερχόμενους να αισθάνονται ευπρόσδεκτοι.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mavris?s=180" class="pquote-avatar" alt="avatar">
  Κάποια στιγμή δημιούργησα ένα προσαρμοσμένο UIAlertView που χρησιμοποιούσα... και αποφάσισα να το κάνω open source. Έτσι το τροποποίησα για να είναι πιο δυναμικό και το ανέβασα στο GitHub. Έγραψα επίσης την πρώτη μου τεκμηρίωση εξηγώντας σε άλλους προγραμματιστές πώς να το χρησιμοποιήσουν στα πρότζεκτ τους. Πιθανότατα κανείς δεν το χρησιμοποίησε ποτέ επειδή ήταν ένα απλό πρότζεκτ, αλλά ένιωθα καλά για τη συνεισφορά μου.
  <p markdown="1" class="pquote-credit">
- @mavris, ["Self-taught Software Developers: Why Open Source is important to us"](https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576)
  </p>
</aside>

Καθώς το πρότζεκτ σας αναπτύσσεται, η κοινότητά σας μπορεί να χρειάζεται κάτι περισσότερο από τον κώδικα που θα σας παρέχει. Η ανταπόκριση σε ζητήματα, η αναθεώρηση κώδικα και η προώθηση του έργου σας είναι όλα σημαντικά καθήκοντα σε ένα πρότζεκτ ανοικτού κώδικα.

Αν και ο χρόνος που αφιερώνετε σε εργασίες που δεν σχετίζονται με τον προγραμματισμό εξαρτάται από το μέγεθος και το πεδίο εφαρμογής του έργου σας, θα πρέπει να είστε προετοιμασμένοι ως συντηρητής να τις αντιμετωπίσετε μόνοι σας ή να βρείτε κάποιον να σας βοηθήσει.

**Αν ανήκετε σε μια εταιρεία με ανοικτό sourcing ενός έργου,** βεβαιωθείτε ότι το πρότζεκτ σας διαθέτει τους εσωτερικούς πόρους που χρειάζεται για να ευδοκιμήσει. Θα πρέπει να προσδιορίσετε ποιος είναι υπεύθυνος για τη συντήρηση του έργου μετά την έναρξη και πώς θα μοιραστείτε αυτά τα καθήκοντα με την κοινότητά σας.

Αν χρειάζεστε ειδικό προϋπολογισμό ή προσωπικό για την προώθηση, τις λειτουργίες και τη συντήρηση του έργου, ξεκινήστε τις συζητήσεις αυτές από νωρίς.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/captainsafia?s=180" class="pquote-avatar" alt="avatar">
  Καθώς αρχίζετε να ανοίγετε το πρότζεκτ, είναι σημαντικό να βεβαιωθείτε ότι οι διαδικασίες διαχείρισης λαμβάνουν υπόψη τις συνεισφορές και τις ικανότητες της κοινότητας γύρω από το πρότζεκτ σας. Μη φοβάστε να εμπλέξετε συνεισφέροντες που δεν απασχολούνται στην επιχείρησή σας σε βασικές πτυχές του έργου - ειδικά αν είναι συχνοί συνεισφέροντες.
  <p markdown="1" class="pquote-credit">
- @captainsafia, ["Ώστε θέλεις να ανοίξεις ένα πρότζεκτ με ανοιχτό κώδικα, ε;"](https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779)
  </p>
</aside>

### Συμβολή σε άλλα πρότζεκτ

Αν ο στόχος σας είναι να μάθετε πώς να συνεργάζεστε με άλλους ή να κατανοήσετε πώς λειτουργεί ο ανοιχτός κώδικας, σκεφτείτε να συνεισφέρετε σε ένα υπάρχον πρότζεκτ. Ξεκινήστε με ένα πρότζεκτ που ήδη χρησιμοποιείτε και αγαπάτε. Η συνεισφορά σε ένα πρότζεκτ μπορεί να είναι τόσο απλή όσο η διόρθωση τυπογραφικών λαθών ή η ενημέρωση της τεκμηρίωσης.

Αν δεν είστε σίγουροι για το πώς να ξεκινήσετε να συνεισφέρετε, ανατρέξτε στον οδηγό μας [Πώς να συνεισφέρετε στον Ανοιχτό Κώδικα](../how-to-contribute/).

## Ξεκινώντας το δικό σας πρότζεκτ ανοιχτού κώδικα

Δεν υπάρχει ιδανική στιγμή για να ανοίξετε το πρότζεκτ σας. Μπορείτε να ανοίξετε τον κώδικα μιας ιδέας, μιας εργασίας σε εξέλιξη ή μετά από χρόνια κλειστού κώδικα.

Σε γενικές γραμμές, θα πρέπει να ανοίγετε το πρότζεκτ σας όταν αισθάνεστε άνετα να αφήσετε άλλους να δουν και να δώσουν ανατροφοδότηση σχετικά με το πρότζεκτ σας.

Ανεξάρτητα από το στάδιο στο οποίο θα αποφασίσετε να ανοίξετε το πρότζεκτ σας, κάθε πρότζεκτ θα πρέπει να περιλαμβάνει την ακόλουθη τεκμηρίωση:

* [Άδεια χρήσης ανοικτού κώδικα](https://help.github.com/articles/open-source-licensing/#where-does-the-license-live-on-my-repository)
* [README](https://help.github.com/articles/create-a-repo/#commit-your-first-change)
* [Κανόνες για τους συνεισφέροντες](https://help.github.com/articles/setting-guidelines-for-repository-contributors/)
* [Κώδικας δεοντολογίας](../code-of-conduct/)

Ως συντηρητής, αυτά τα στοιχεία θα σας βοηθήσουν να επικοινωνήσετε τις προσδοκίες, να διαχειριστείτε τις συνεισφορές και να προστατεύσετε τα νομικά δικαιώματα όλων (συμπεριλαμβανομένων των δικών σας). Αυξάνουν σημαντικά τις πιθανότητές σας να έχετε μια θετική εμπειρία.

Εάν το πρότζεκτ σας βρίσκεται στο GitHub, η τοποθέτηση αυτών των αρχείων στον ριζικό σας κατάλογο με τα συνιστώμενα ονόματα αρχείων θα βοηθήσει το GitHub να τα αναγνωρίσει και να τα εμφανίσει αυτόματα στους αναγνώστες σας.

### Επιλέγοντας μια άδεια

Μια άδεια ανοικτού κώδικα εγγυάται ότι άλλοι μπορούν να χρησιμοποιούν, να αντιγράφουν, να τροποποιούν και να συνεισφέρουν στο πρότζεκτ σας χωρίς επιπτώσεις. Σας προστατεύει επίσης από δύσκολες νομικές καταστάσεις. **Πρέπει να συμπεριλάβετε μια άδεια χρήσης όταν ξεκινάτε ένα πρότζεκτ ανοικτού κώδικα**.

Η νομική εργασία δεν είναι διασκεδαστική. Τα καλά νέα είναι ότι μπορείτε να αντιγράψετε και να επικολλήσετε μια υπάρχουσα άδεια χρήσης στο αποθετήριό σας. Θα χρειαστεί μόνο ένα λεπτό για να προστατέψετε τη σκληρή δουλειά σας.

Οι [MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) και [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) είναι οι πιο δημοφιλείς άδειες ανοικτού κώδικα, αλλά [υπάρχουν και άλλες επιλογές](https://choosealicense.com) για να επιλέξετε.

Όταν δημιουργείτε ένα νέο πρότζεκτ στο GitHub, σας δίνεται η δυνατότητα να επιλέξετε μια άδεια χρήσης. Η συμπερίληψη μιας άδειας ανοικτού κώδικα θα καταστήσει το πρότζεκτ σας στο GitHub ανοικτού κώδικα.

![Διαλέξτε μια άδεια](/assets/images/starting-a-project/repository-license-picker.png)

Αν έχετε άλλες ερωτήσεις ή ανησυχίες σχετικά με τις νομικές πτυχές της διαχείρισης ενός έργου ανοικτού κώδικα, [σας καλύπτουμε](../legal/).

### Γράφοντας ένα README

Τα READMEs κάνουν περισσότερα από το να εξηγούν πώς να χρησιμοποιήσετε το πρότζεκτ σας. Εξηγούν επίσης γιατί το πρότζεκτ σας έχει σημασία και τι μπορούν να κάνουν οι χρήστες σας με αυτό.

Στο README σας, προσπαθήστε να απαντήσετε στις ακόλουθες ερωτήσεις:

* Τι κάνει αυτό το πρότζεκτ;
* Γιατί είναι χρήσιμο αυτό το πρότζεκτ;
* Πώς μπορώ να ξεκινήσω;
* Πού μπορώ να βρω περισσότερη βοήθεια, αν τη χρειαστώ;

Μπορείτε να χρησιμοποιήσετε το README για να απαντήσετε σε άλλες ερωτήσεις, όπως πώς χειρίζεστε τις συνεισφορές, ποιοι είναι οι στόχοι του έργου και πληροφορίες σχετικά με τις άδειες χρήσης και την απόδοση. Αν δεν θέλετε να δέχεστε συνεισφορές ή αν το πρότζεκτ σας δεν είναι ακόμα έτοιμο για παραγωγή, γράψτε αυτές τις πληροφορίες.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/tracymakes?s=180" class="pquote-avatar" alt="avatar">
  Καλύτερη τεκμηρίωση σημαίνει περισσότερους χρήστες, λιγότερα αιτήματα υποστήριξης και περισσότερους συνεργάτες. (...) Να θυμάστε ότι οι αναγνώστες σας δεν είναι εσείς. Υπάρχουν άνθρωποι που μπορεί να έρθουν σε ένα πρότζεκτ που έχουν εντελώς διαφορετικές εμπειρίες.
  <p markdown="1" class="pquote-credit">
- @tracymakes, ["Writing So Your Words Are Read (video)"](https://www.youtube.com/watch?v=8LiV759Bje0&list=PLmV2D6sIiX3U03qc-FPXgLFGFkccCEtfv&index=10)
  </p>
</aside>

Μερικές φορές, οι άνθρωποι αποφεύγουν να γράψουν ένα README επειδή αισθάνονται ότι το πρότζεκτ είναι ημιτελές ή δεν θέλουν συνεισφορές. Όλοι αυτοί είναι πολύ καλοί λόγοι για να γράψετε ένα τέτοιο κείμενο.

Για περισσότερη έμπνευση, δοκιμάστε να χρησιμοποιήσετε τον ["Make a README" guide](https://www.makeareadme.com/) του @dguo ή το [README template](https://gist.github.com/PurpleBooth/109311bb0361f32d87a2) του @PurpleBooth για να γράψετε ένα πλήρες README.

Όταν συμπεριλαμβάνετε ένα αρχείο README στον ριζικό κατάλογο, το GitHub θα το εμφανίσει αυτόματα στην αρχική σελίδα του αποθετηρίου.

### Γράφοντας τις κατευθυντήριες γραμμές συνεισφοράς σας

Ένα αρχείο CONTRIBUTING λέει στο κοινό σας πώς να συμμετάσχει στο πρότζεκτ σας. Για παράδειγμα, θα μπορούσατε να συμπεριλάβετε πληροφορίες σχετικά με:

* Πώς να καταθέσετε μια αναφορά σφάλματος (δοκιμάστε να χρησιμοποιήσετε τα [πρότυπα issue και pull request](https://github.com/blog/2111-issue-and-pull-request-templates))
* Πώς να προτείνετε ένα νέο χαρακτηριστικό
* Πώς να ρυθμίσετε το περιβάλλον σας και να εκτελέσετε δοκιμές

Εκτός από τις τεχνικές λεπτομέρειες, ένα αρχείο ΣΥΜΒΟΛΗΣ είναι μια ευκαιρία να επικοινωνήσετε τις προσδοκίες σας για τις συνεισφορές, όπως:

* Τα είδη των συνεισφορών που αναζητάτε
* Ο οδικός χάρτης ή το όραμά σας για το πρότζεκτ
* Πώς οι συνεργάτες θα πρέπει (ή δεν θα πρέπει) να έρθουν σε επαφή μαζί σας

Χρησιμοποιώντας ένα ζεστό, φιλικό τόνο και προσφέροντας συγκεκριμένες προτάσεις για συνεισφορές (όπως η συγγραφή τεκμηρίωσης ή η δημιουργία ενός ιστότοπου) μπορείτε να κάνετε τους νεοεισερχόμενους να αισθάνονται ευπρόσδεκτοι και ενθουσιασμένοι να συμμετάσχουν.

Για παράδειγμα, το [Active Admin](https://github.com/activeadmin/activeadmin/) ξεκινά [τον οδηγό συνεισφοράς του](https://github.com/activeadmin/activeadmin/blob/HEAD/CONTRIBUTING.md) με:

> Πρώτα απ' όλα, σας ευχαριστώ που σκέφτεστε να συνεισφέρετε στο Active Admin. Είναι άνθρωποι σαν εσάς που κάνουν το Active Admin ένα τόσο σπουδαίο εργαλείο.

Στα πρώτα στάδια του έργου σας, το αρχείο CONTRIBUTING μπορεί να είναι απλό. Θα πρέπει πάντα να εξηγείτε πώς να αναφέρετε σφάλματα ή θέματα αρχείων, καθώς και τυχόν τεχνικές απαιτήσεις (όπως δοκιμές) για να κάνετε μια συνεισφορά.

Με την πάροδο του χρόνου, μπορεί να προσθέσετε και άλλες συχνές ερωτήσεις στο αρχείο ΣΥΝΔΡΟΜΗ. Η καταγραφή αυτών των πληροφοριών σημαίνει ότι λιγότεροι άνθρωποι θα σας κάνουν τις ίδιες ερωτήσεις ξανά και ξανά.

Για περισσότερη βοήθεια σχετικά με τη σύνταξη του αρχείου CONTRIBUTING, δείτε το [πρότυπο οδηγού συνεισφοράς](https://github.com/nayafia/contributing-template/blob/HEAD/CONTRIBUTING-template.md) του @nayafia ή το ["How to Build a CONTRIBUTING.md"](https://mozillascience.github.io/working-open-workshop/contributing/) του @mozilla.

Συνδέστε το αρχείο CONTRIBUTING από το README, ώστε να το βλέπουν περισσότεροι άνθρωποι. Εάν [τοποθετήσετε το αρχείο CONTRIBUTING στο αποθετήριο του έργου σας](https://help.github.com/articles/setting-guidelines-for-repository-contributors/), το GitHub θα συνδέει αυτόματα το αρχείο σας όταν ένας συνεργάτης δημιουργεί ένα ζήτημα ή ανοίγει ένα pull request.

![Οδηγίες συνεισφοράς](/assets/images/starting-a-project/Contributing-guidelines.jpg)

### Καθιέρωση κώδικα δεοντολογίας

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mlynch?s=180" class="pquote-avatar" alt="avatar">
  Όλοι έχουμε βιώσει εμπειρίες όπου αντιμετωπίσαμε κάτι που πιθανώς ήταν κατάχρηση, είτε ως συντηρητής που προσπαθούσε να εξηγήσει γιατί κάτι έπρεπε να γίνει με έναν συγκεκριμένο τρόπο, είτε ως χρήστης... που έκανε μια απλή ερώτηση. (...) Ένας κώδικας δεοντολογίας γίνεται ένα έγγραφο στο οποίο γίνεται εύκολα αναφορά και το οποίο μπορεί να συνδεθεί και το οποίο δείχνει ότι η ομάδα σας παίρνει τον εποικοδομητικό διάλογο πολύ σοβαρά.
  <p markdown="1" class="pquote-credit">
- @mlynch, ["Making Open Source a Happier Place"](https://medium.com/ionic-and-the-mobile-web/making-open-source-a-happier-place-3b90d254f5f)
  </p>
</aside>

Τέλος, ένας κώδικας δεοντολογίας βοηθά στον καθορισμό βασικών κανόνων συμπεριφοράς για τους συμμετέχοντες στο πρότζεκτ σας. Αυτό είναι ιδιαίτερα πολύτιμο αν ξεκινάτε ένα πρότζεκτ ανοικτού κώδικα για μια κοινότητα ή μια εταιρεία. Ένας κώδικας δεοντολογίας σας δίνει τη δυνατότητα να διευκολύνετε την υγιή, εποικοδομητική συμπεριφορά της κοινότητας, γεγονός που θα μειώσει το άγχος σας ως συντηρητής.

Για περισσότερες πληροφορίες, ανατρέξτε στον οδηγό [Κώδικας δεοντολογίας](../code-of-conduct/).

Εκτός από το να γνωστοποιεί _πώς_ περιμένετε από τους συμμετέχοντες να συμπεριφέρονται, ένας κώδικας συμπεριφοράς τείνει επίσης να περιγράφει ποιους αφορούν αυτές οι προσδοκίες, πότε ισχύουν και τι πρέπει να γίνει σε περίπτωση παραβίασης.

Όπως οι άδειες ανοικτού κώδικα, έτσι και για τους κώδικες δεοντολογίας υπάρχουν αναδυόμενα πρότυπα, ώστε να μην χρειάζεται να γράψετε τους δικούς σας. Το [Contributor Covenant](https://contributor-covenant.org/) είναι ένας drop-in κώδικας συμπεριφοράς που χρησιμοποιείται από [πάνω από 40.000 πρότζεκτ ανοικτού κώδικα](https://www.contributor-covenant.org/adopters), συμπεριλαμβανομένων των Kubernetes, Rails και Swift. Ανεξάρτητα από το κείμενο που χρησιμοποιείτε, θα πρέπει να είστε προετοιμασμένοι να επιβάλλετε τον κώδικα συμπεριφοράς σας όταν είναι απαραίτητο.

Επικολλήστε το κείμενο απευθείας σε ένα αρχείο CODE_OF_CONDUCT στο αποθετήριό σας. Κρατήστε το αρχείο στο ριζικό κατάλογο του έργου σας, ώστε να είναι εύκολο να το βρείτε, και παραπέμψτε σε αυτό από το README σας.

## Ονομασία και branding του έργου σας

Το branding είναι κάτι περισσότερο από ένα φανταχτερό λογότυπο ή ένα πιασάρικο όνομα έργου. Έχει να κάνει με το πώς μιλάτε για το πρότζεκτ σας και σε ποιον απευθύνεστε με το μήνυμά σας.

### Επιλέγοντας το σωστό όνομα

Διαλέξτε ένα όνομα που να είναι εύκολο να το θυμάστε και, ιδανικά, να δίνει μια ιδέα για το τι κάνει το πρότζεκτ. Για παράδειγμα:

* [Sentry](https://github.com/getsentry/sentry) παρακολουθεί τις εφαρμογές για αναφορά ατυχημάτων
* [Thin](https://github.com/macournoyer/thin) είναι ένας γρήγορος και απλός διακομιστής ιστοσελίδων Ruby

Αν βασίζεστε σε ένα υπάρχον πρότζεκτ, η χρήση του ονόματός του ως πρόθεμα μπορεί να βοηθήσει να αποσαφηνιστεί τι κάνει το πρότζεκτ σας (για παράδειγμα, το [node-fetch](https://github.com/bitinn/node-fetch) φέρνει το `window.fetch` στο Node.js).

Σκεφτείτε πάνω απ' όλα τη σαφήνεια. Τα λογοπαίγνια είναι διασκεδαστικά, αλλά να θυμάστε ότι ορισμένα αστεία μπορεί να μη μεταφράζονται σε άλλους πολιτισμούς ή σε ανθρώπους με διαφορετικές εμπειρίες από εσάς. Ορισμένοι από τους δυνητικούς χρήστες σας μπορεί να είναι υπάλληλοι της εταιρείας: δεν θέλετε να τους κάνετε να νιώσουν άβολα όταν θα πρέπει να εξηγήσουν το πρότζεκτ σας στη δουλειά!

### Αποφυγή συγκρούσεων ονομάτων

[Ελέγξτε για πρότζεκτ ανοικτού κώδικα με παρόμοιο όνομα](http://ivantomic.com/projects/ospnc/), ειδικά αν μοιράζεστε την ίδια γλώσσα ή το ίδιο οικοσύστημα. Εάν το όνομά σας συμπίπτει με ένα δημοφιλές υπάρχον πρότζεκτ, μπορεί να προκαλέσετε σύγχυση στο κοινό σας.

Αν θέλετε έναν ιστότοπο, μια λαβή στο Twitter ή άλλες ιδιότητες που θα αντιπροσωπεύουν το πρότζεκτ σας, βεβαιωθείτε ότι μπορείτε να πάρετε τα ονόματα που θέλετε. Ιδανικά, [κρατήστε αυτά τα ονόματα τώρα](https://instantdomainsearch.com/) για να είστε ήσυχοι, ακόμη και αν δεν σκοπεύετε να τα χρησιμοποιήσετε ακόμη.

Βεβαιωθείτε ότι το όνομα του έργου σας δεν παραβιάζει κανένα εμπορικό σήμα. Μια εταιρεία μπορεί να σας ζητήσει αργότερα να καταργήσετε το πρότζεκτ σας ή ακόμη και να κινηθεί νομικά εναντίον σας. Δεν αξίζει τον κόπο να το ρισκάρετε.

Μπορείτε να ελέγξετε τη [WIPO Global Brand Database](http://www.wipo.int/branddb/en/) για συγκρούσεις εμπορικών σημάτων. Αν είστε σε μια εταιρεία, αυτό είναι ένα από τα πράγματα με τα οποία μπορεί να σας βοηθήσει η [νομική ομάδα](../legal/).

Τέλος, κάντε μια γρήγορη αναζήτηση στο Google για το όνομα του έργου σας. Θα μπορούν οι άνθρωποι να βρουν εύκολα το πρότζεκτ σας; Εμφανίζεται κάτι άλλο στα αποτελέσματα της αναζήτησης που δεν θα θέλατε να δουν;

### Ο τρόπος που γράφετε (και κωδικοποιείτε) επηρεάζει και το brand σας!

Καθ' όλη τη διάρκεια του έργου σας, θα γράφετε πολύ: READMEs, tutorials, έγγραφα της κοινότητας, απαντήσεις σε θέματα, ίσως ακόμη και ενημερωτικά δελτία και λίστες αλληλογραφίας.

Είτε πρόκειται για επίσημη τεκμηρίωση είτε για ένα απλό μήνυμα ηλεκτρονικού ταχυδρομείου, το στυλ γραφής σας αποτελεί μέρος της επωνυμίας του έργου σας. Σκεφτείτε πώς θα μπορούσατε να φανείτε στο κοινό σας και αν αυτός είναι ο τόνος που θέλετε να μεταδώσετε.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/janl?s=180" class="pquote-avatar" alt="avatar">
  Προσπάθησα να συμμετέχω σε κάθε νήμα της λίστας αλληλογραφίας και να δείχνω υποδειγματική συμπεριφορά, να είμαι καλός με τους ανθρώπους, να παίρνω σοβαρά τα θέματά τους και να προσπαθώ να είμαι χρήσιμος συνολικά. Μετά από λίγο, οι άνθρωποι έμειναν κοντά μου όχι μόνο για να κάνουν ερωτήσεις, αλλά και για να βοηθήσουν με τις απαντήσεις, και προς μεγάλη μου χαρά, μιμούνταν το στυλ μου.
  <p markdown="1" class="pquote-credit">
- @janl on [CouchDB](https://github.com/apache/couchdb), ["Sustainable Open Source"](https://web.archive.org/web/20200723213552/https://writing.jan.io/2015/11/20/sustainable-open-source.html)
  </p>
</aside>

Η χρήση θερμής, περιεκτικής γλώσσας (όπως "τους", ακόμη και όταν αναφέρεται σε ένα άτομο) μπορεί να συμβάλει σημαντικά στο να γίνει το πρότζεκτ σας φιλόξενο για τους νέους συνεισφέροντες. Μείνετε σε απλή γλώσσα, καθώς πολλοί από τους αναγνώστες σας μπορεί να μην έχουν ως μητρική γλώσσα τα αγγλικά.

Πέρα από τον τρόπο που γράφετε λέξεις, το στυλ κωδικοποίησης μπορεί επίσης να γίνει μέρος της επωνυμίας του έργου σας. Το [Angular](https://angular.io/guide/styleguide) και το [jQuery](https://contribute.jquery.org/style-guide/js/) είναι δύο παραδείγματα πρότζεκτ με αυστηρό στυλ κωδικοποίησης και κατευθυντήριες γραμμές.

Δεν είναι απαραίτητο να γράψετε έναν οδηγό στυλ για το πρότζεκτ σας όταν ξεκινάτε, και μπορεί να διαπιστώσετε ότι σας αρέσει να ενσωματώνετε διαφορετικά στυλ κωδικοποίησης στο πρότζεκτ σας ούτως ή άλλως. Θα πρέπει όμως να προβλέψετε πώς το στυλ γραφής και κωδικοποίησης που χρησιμοποιείτε μπορεί να προσελκύσει ή να αποθαρρύνει διαφορετικούς τύπους ανθρώπων. Τα πρώτα στάδια του έργου σας είναι η ευκαιρία σας να δημιουργήσετε το προηγούμενο που επιθυμείτε.

## Ο κατάλογος ελέγχου πριν από την έναρξη

Είστε έτοιμοι να ανοίξετε το πρότζεκτ σας; Ακολουθεί ένας κατάλογος ελέγχου για να σας βοηθήσει. Έχετε τσεκάρει όλα τα κουτάκια; Είστε έτοιμοι να ξεκινήσετε! [Κάντε κλικ στο "publish"](https://help.github.com/articles/making-a-private-repository-public/) και χτυπήστε τον εαυτό σας στην πλάτη.

**Έγγραφα**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox1" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox1" class="overflow-hidden d-block text-normal">
    Το πρότζεκτ έχει ένα αρχείο LICENSE με άδεια χρήσης ανοικτού κώδικα
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox2" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox2" class="overflow-hidden d-block text-normal">
    Το πρότζεκτ έχει βασική τεκμηρίωση (README, CONTRIBUTING, CODE_OF_CONDUCT)
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox3" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox3" class="overflow-hidden d-block text-normal">
    Το όνομα είναι εύκολο να το θυμάται κανείς, δίνει μια ιδέα για το τι κάνει το πρότζεκτ και δεν έρχεται σε σύγκρουση με ένα υπάρχον πρότζεκτ ή παραβιάζει εμπορικά σήματα.
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox4" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox4" class="overflow-hidden d-block text-normal">
    Η ουρά θεμάτων είναι ενημερωμένη, με τα θέματα σαφώς οργανωμένα και επισημασμένα.
  </label>
</div>

**Κώδικας**

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox5" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox5" class="overflow-hidden d-block text-normal">
    Το πρότζεκτ χρησιμοποιεί συνεπείς συμβάσεις κώδικα και σαφή ονόματα συναρτήσεων/μεθόδων/μεταβλητών
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox6" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox6" class="overflow-hidden d-block text-normal">
    Ο κώδικας είναι σαφώς σχολιασμένος, τεκμηριώνοντας τις προθέσεις και τις ακραίες περιπτώσεις
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox7" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox7" class="overflow-hidden d-block text-normal">
    Δεν υπάρχει ευαίσθητο υλικό στο ιστορικό αναθεωρήσεων, στα ζητήματα ή στα αιτήματα έλξης (για παράδειγμα, κωδικοί πρόσβασης ή άλλες μη δημόσιες πληροφορίες).
  </label>
</div>

**Άνθρωποι**

Αν είστε άτομο:

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox8" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox8" class="overflow-hidden d-block text-normal">
  Έχετε μιλήσει με το νομικό τμήμα ή/και έχετε κατανοήσει τις πολιτικές IP και ανοιχτού κώδικα της εταιρείας σας (αν είστε υπάλληλος κάπου)
  </label>
</div>

Εάν είστε εταιρεία ή οργανισμός:

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox9" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox9" class="overflow-hidden d-block text-normal">
    Μιλήσατε με το νομικό σας τμήμα
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox10" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox10" class="overflow-hidden d-block text-normal">
    Έχετε σχέδιο μάρκετινγκ για την ανακοίνωση και την προώθηση του έργου
  </label>
</div>

<div class="clearfix mb-2">
  <input type="checkbox" id="cbox11" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox11" class="overflow-hidden d-block text-normal">
    Κάποιος που έχει δεσμευτεί να διαχειρίζεται τις αλληλεπιδράσεις της κοινότητας (απάντηση σε θέματα, εξέταση και συγχώνευση αιτημάτων έλξης)
  </label>
</div>

<div class="clearfix mb-4">
  <input type="checkbox" id="cbox12" class="d-block float-left mt-1 mr-2" value="checkbox">
  <label for="cbox12" class="overflow-hidden d-block text-normal">
    Τουλάχιστον δύο άτομα έχουν διοικητική πρόσβαση στο πρότζεκτ
  </label>
</div>

## Τα καταφέρατε!

Συγχαρητήρια για την ανοιχτή διάθεση του πρώτου σας έργου. Ανεξάρτητα από το αποτέλεσμα, η δημόσια εργασία είναι ένα δώρο στην κοινότητα. Με κάθε δέσμευση, σχόλιο και pull request, δημιουργείτε ευκαιρίες για τον εαυτό σας και για τους άλλους να μάθουν και να αναπτυχθούν.
