---
lang: el
title: Στατιστικά Ανοικτού Κώδικα
description: Λάβετε τεκμηριωμένες αποφάσεις για να βοηθήσετε το πρότζεκτ ανοιχτού κώδικά σας να ευημερήσει, μετρώντας και παρακολουθώντας την επιτυχία του.
class: metrics
order: 9
image: /assets/images/cards/metrics.png
related:
  - finding
  - best-practices
---

## Γιατί να μετρήσουμε οτιδήποτε;

Τα δεδομένα, όταν χρησιμοποιούνται με σύνεση, μπορούν να σας βοηθήσουν να λάβετε καλύτερες αποφάσεις ως συντηρητής ανοικτού κώδικα.

Με περισσότερες πληροφορίες, μπορείτε:

* Κατανόηση του τρόπου με τον οποίο οι χρήστες ανταποκρίνονται σε ένα νέο χαρακτηριστικό
* Ανακαλύψτε από πού προέρχονται οι νέοι χρήστες
* Εντοπισμός και απόφαση σχετικά με την υποστήριξη μιας περίπτωσης χρήσης ή μιας λειτουργικότητας που ξεφεύγει από τα συνηθισμένα
* Ποσοτικοποιήστε τη δημοτικότητα του πρότζεκτ σας
* Κατανοήστε πώς χρησιμοποιείται το πρότζεκτ σας
* Συγκέντρωση χρημάτων μέσω χορηγιών και επιχορηγήσεων

Για παράδειγμα, το [Homebrew](https://github.com/Homebrew/brew/blob/bbed7246bc5c5b7acb8c1d427d10b43e090dfd39/docs/Analytics.md) διαπιστώνει ότι το Google Analytics τους βοηθάει να θέτουν προτεραιότητες στην εργασία τους:

> Το Homebrew παρέχεται δωρεάν και διευθύνεται εξ ολοκλήρου από εθελοντές στον ελεύθερο χρόνο τους. Ως αποτέλεσμα, δεν έχουμε τους πόρους για να κάνουμε λεπτομερείς μελέτες χρηστών του Homebrew για να αποφασίσουμε πώς θα σχεδιάσουμε καλύτερα τα μελλοντικά χαρακτηριστικά και να δώσουμε προτεραιότητα στις τρέχουσες εργασίες. Οι ανώνυμες συγκεντρωτικές αναλύσεις χρηστών μας επιτρέπουν να δώσουμε προτεραιότητα στις διορθώσεις και τα χαρακτηριστικά με βάση το πώς, πού και πότε οι χρήστες χρησιμοποιούν το Homebrew.

Η δημοτικότητα δεν είναι το παν. Όλοι ασχολούνται με τον ανοιχτό κώδικα για διαφορετικούς λόγους. Αν ο στόχος σας ως συντηρητής ανοιχτού κώδικα είναι να επιδείξετε τη δουλειά σας, να είστε διαφανείς σχετικά με τον κώδικά σας ή απλά να διασκεδάσετε, οι μετρήσεις μπορεί να μην είναι σημαντικές για εσάς.

Αν _ενδιαφέρεστε_ να κατανοήσετε το πρότζεκτ σας σε βαθύτερο επίπεδο, διαβάστε παρακάτω για τρόπους ανάλυσης της δραστηριότητας του έργου σας.

## Ανακάλυψη

Πριν κάποιος μπορεί να χρησιμοποιήσει ή να συνεισφέρει στο πρότζεκτ σας, πρέπει να γνωρίζει ότι υπάρχει. Ρωτήστε τον εαυτό σας: _βρίσκουν οι άνθρωποι αυτό το πρότζεκτ;_

![Διάγραμμα κυκλοφορίας](/assets/images/metrics/repo_traffic_graphs_tooltip.png)

Εάν το πρότζεκτ σας φιλοξενείται στο GitHub, [μπορείτε να δείτε](https://help.github.com/articles/about-repository-graphs/#traffic) πόσοι άνθρωποι μπαίνουν στο πρότζεκτ σας και από πού προέρχονται. Από τη σελίδα του έργου σας, κάντε κλικ στην επιλογή "Insights" και στη συνέχεια στην επιλογή "Traffic". Σε αυτή τη σελίδα, μπορείτε να δείτε: "Το πρότζεκτ σας":

* **Συνολικές προβολές σελίδων:** Σας λέει πόσες φορές προβλήθηκε το πρότζεκτ σας

* **Συνολικοί μοναδικοί επισκέπτες:** Σας λέει πόσοι άνθρωποι είδαν το πρότζεκτ σας

* **Συμβαλλόμενοι ιστότοποι:** Σας λέει από πού προήλθαν οι επισκέπτες. Αυτή η μέτρηση μπορεί να σας βοηθήσει να καταλάβετε πού να προσεγγίσετε το κοινό σας και αν οι προσπάθειες προώθησής σας αποδίδουν.

* **Δημοφιλές περιεχόμενο:** Σας λέει πού πηγαίνουν οι επισκέπτες στο πρότζεκτ σας, κατανεμημένο σε προβολές σελίδων και μοναδικούς επισκέπτες.

[GitHub stars](https://help.github.com/articles/about-stars/) μπορεί επίσης να βοηθήσει στην παροχή ενός βασικού μέτρου δημοτικότητας. Αν και τα αστέρια του GitHub δεν συσχετίζονται απαραίτητα με τις λήψεις και τη χρήση, μπορούν να σας δείξουν πόσοι άνθρωποι λαμβάνουν γνώση της εργασίας σας.

Μπορεί επίσης να θέλετε να [παρακολουθείτε την ανιχνευσιμότητα σε συγκεκριμένα μέρη](https://opensource.com/business/16/6/pirate-metrics): για παράδειγμα, το Google PageRank, την επισκεψιμότητα παραπομπών από τον ιστότοπο του έργου σας ή παραπομπές από άλλα πρότζεκτ ή ιστότοπους ανοικτού κώδικα.

## Χρήση

Οι άνθρωποι βρίσκουν το πρότζεκτ σας σε αυτό το άγριο και τρελό πράγμα που αποκαλούμε διαδίκτυο. Ιδανικά, όταν δουν το πρότζεκτ σας, θα νιώσουν την ανάγκη να κάνουν κάτι. Η δεύτερη ερώτηση που θα πρέπει να κάνετε είναι: _χρησιμοποιούν οι άνθρωποι αυτό το πρότζεκτ;_

Αν χρησιμοποιείτε έναν διαχειριστή πακέτων, όπως το npm ή το RubyGems.org, για να διανείμετε το πρότζεκτ σας, μπορεί να μπορείτε να παρακολουθείτε τις λήψεις του έργου σας.

Κάθε διαχειριστής πακέτων μπορεί να χρησιμοποιεί έναν ελαφρώς διαφορετικό ορισμό της "λήψης" και οι λήψεις δεν συσχετίζονται απαραίτητα με τις εγκαταστάσεις ή τη χρήση, αλλά παρέχει κάποια βάση σύγκρισης. Δοκιμάστε να χρησιμοποιήσετε το [Libraries.io](https://libraries.io/) για να παρακολουθήσετε στατιστικά στοιχεία χρήσης σε πολλούς δημοφιλείς διαχειριστές πακέτων.

Αν το πρότζεκτ σας βρίσκεται στο GitHub, μεταβείτε ξανά στη σελίδα "Traffic". Μπορείτε να χρησιμοποιήσετε το [clone graph](https://github.com/blog/1873-clone-graphs) για να δείτε πόσες φορές έχει κλωνοποιηθεί το πρότζεκτ σας σε μια δεδομένη ημέρα, αναλυτικά με βάση το σύνολο των κλώνων και τους μοναδικούς κλώνους.

![Clone graph](/assets/images/metrics/clone_graph.png)

Εάν η χρήση είναι χαμηλή σε σύγκριση με τον αριθμό των ατόμων που ανακαλύπτουν το πρότζεκτ σας, υπάρχουν δύο ζητήματα που πρέπει να εξετάσετε. Είτε:

* Το πρότζεκτ σας δεν μετατρέπει με επιτυχία το κοινό σας, ή
* Προσελκύετε το λάθος κοινό

Για παράδειγμα, αν το πρότζεκτ σας βρεθεί στην πρώτη σελίδα του Hacker News, θα δείτε πιθανότατα μια αύξηση στην ανακάλυψη (επισκεψιμότητα), αλλά ένα χαμηλότερο ποσοστό μετατροπής, επειδή θα φτάσετε σε όλους τους χρήστες του Hacker News. Αν το Ruby πρότζεκτ σας παρουσιάζεται σε ένα συνέδριο Ruby, ωστόσο, είναι πιο πιθανό να δείτε υψηλό ποσοστό μετατροπής από ένα στοχευμένο κοινό.

Προσπαθήστε να καταλάβετε από πού προέρχεται το κοινό σας και ζητήστε από τους άλλους σχόλια για τη σελίδα του πρότζεκτ σας για να καταλάβετε ποιο από αυτά τα δύο ζητήματα αντιμετωπίζετε.

Μόλις μάθετε ότι οι άνθρωποι χρησιμοποιούν το πρότζεκτ σας, ίσως θελήσετε να προσπαθήσετε να καταλάβετε τι κάνουν με αυτό. Χτίζουν πάνω σε αυτό με το να διακλαδώνουν τον κώδικά σας και να προσθέτουν χαρακτηριστικά; Το χρησιμοποιούν για επιστημονικούς ή επιχειρηματικούς σκοπούς;

## Διατήρηση

Οι άνθρωποι βρίσκουν το πρότζεκτ σας και το χρησιμοποιούν. Το επόμενο ερώτημα που θα πρέπει να θέσετε στον εαυτό σας είναι: _Συμβάλλουν οι άνθρωποι σε αυτό το πρότζεκτ;_

Ποτέ δεν είναι πολύ νωρίς για να αρχίσετε να σκέφτεστε τους συνεισφέροντες. Χωρίς τη συμμετοχή άλλων ανθρώπων, κινδυνεύετε να βρεθείτε σε μια ανθυγιεινή κατάσταση όπου το πρότζεκτ σας είναι _δημοφιλές_ (πολλοί το χρησιμοποιούν) αλλά δεν _υποστηρίζεται_ (δεν υπάρχει αρκετός χρόνος συντηρητών για να καλύψει τη ζήτηση).

Η διατήρηση απαιτεί επίσης [εισροή νέων συνεισφερόντων](http://blog.abigailcabunoc.com/increasing-developer-engagement-at-mozilla-science-learning-advocacy#contributor-pathways_2), καθώς οι προηγουμένως ενεργοί συνεισφέροντες θα προχωρήσουν τελικά σε άλλα πράγματα.

Παραδείγματα μετρήσεων της κοινότητας που μπορεί να θέλετε να παρακολουθείτε τακτικά περιλαμβάνουν:

* **Συνολικός αριθμός συνεργατών και αριθμός κοινοποιήσεων ανά συνεργάτη:** Σας λέει πόσους συνεργάτες έχετε και ποιοι είναι περισσότερο ή λιγότερο ενεργοί. Στο GitHub, μπορείτε να το δείτε αυτό στην ενότητα "Insights" -> "Contributors". Αυτή τη στιγμή, αυτό το γράφημα μετράει μόνο τους συνεισφέροντες που έχουν δεσμευτεί στον προεπιλεγμένο κλάδο του αποθετηρίου.

![Διάγραμμα συνεισφερόντων](/assets/images/metrics/repo_contributors_specific_graph.png)

* **Πρώτη φορά, περιστασιακοί και επαναλαμβανόμενοι συνεισφέροντες:** Σας βοηθά να παρακολουθείτε αν έχετε νέους συνεισφέροντες και αν επιστρέφουν. (Οι περιστασιακοί συνεισφέροντες είναι συνεισφέροντες με χαμηλό αριθμό κοινοποιήσεων. Το αν αυτό είναι μία δέσμευση, λιγότερες από πέντε δεσμεύσεις ή κάτι άλλο εξαρτάται από εσάς). Χωρίς νέους συνεισφέροντες, η κοινότητα του έργου σας μπορεί να μείνει στάσιμη.

* **Αριθμός ανοιχτών ζητημάτων και ανοιχτών pull request:** Αν αυτοί οι αριθμοί είναι πολύ υψηλοί, ίσως χρειαστείτε βοήθεια με την ταξινόμηση ζητημάτων και τις ανασκοπήσεις κώδικα.

* **Αριθμός _ανοικτών_ θεμάτων και _ανοικτών_ pull request:** Τα ανοικτά θέματα σημαίνουν ότι κάποιος ενδιαφέρεται αρκετά για το πρότζεκτ σας ώστε να ανοίξει ένα θέμα. Αν ο αριθμός αυτός αυξάνεται με την πάροδο του χρόνου, αυτό υποδηλώνει ότι οι άνθρωποι ενδιαφέρονται για το πρότζεκτ σας.

* **Τύποι συνεισφορών:** Για παράδειγμα, μεταβιβάσεις, διόρθωση τυπογραφικών λαθών ή σφαλμάτων ή σχολιασμός ενός θέματος.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/arfon?s=180" class="pquote-avatar" alt="avatar">
  Ο ανοικτός κώδικας είναι κάτι περισσότερο από απλός κώδικας. Τα επιτυχημένα πρότζεκτ ανοικτού κώδικα περιλαμβάνουν συνεισφορές σε κώδικα και τεκμηρίωση μαζί με συζητήσεις σχετικά με αυτές τις αλλαγές.
  <p markdown="1" class="pquote-credit">
- @arfon, ["The Shape of Open Source"](https://github.com/blog/2195-the-shape-of-open-source)
  </p>
</aside>

## Δραστηριότητα συντηρητή

Τέλος, θα πρέπει να κλείσετε το βρόχο διασφαλίζοντας ότι οι συντηρητές του έργου σας είναι σε θέση να διαχειριστούν τον όγκο των συνεισφορών που λαμβάνουν. Το τελευταίο ερώτημα που θα πρέπει να θέσετε στον εαυτό σας είναι: Ανταποκρίνομαι (ή ανταποκρινόμαστε) στην κοινότητά μας;

Οι μη ανταποκρινόμενοι συντηρητές γίνονται τροχοπέδη για τα πρότζεκτ ανοικτού κώδικα. Αν κάποιος υποβάλλει μια συνεισφορά αλλά δεν λαμβάνει ποτέ απάντηση από έναν συντηρητή, μπορεί να αποθαρρυνθεί και να φύγει.

[Έρευνα από τη Mozilla](https://docs.google.com/presentation/d/1hsJLv1ieSqtXBzd5YZusY-mB8e1VJzaeOmh8Q4VeMio/edit#slide=id.g43d857af8_0177) δείχνει ότι η ανταπόκριση του συντηρητή είναι ένας κρίσιμος παράγοντας για την ενθάρρυνση της επανάληψης των συνεισφορών.

Εξετάστε το ενδεχόμενο να παρακολουθείτε πόσος χρόνος χρειάζεται για να απαντήσετε εσείς (ή κάποιος άλλος συντηρητής) σε συνεισφορές, είτε πρόκειται για ένα θέμα είτε για ένα pull request. Η ανταπόκριση δεν απαιτεί την ανάληψη δράσης. Μπορεί να είναι τόσο απλό όσο το να πείτε: _"Ευχαριστώ για την υποβολή σας! Θα το επανεξετάσω μέσα στην επόμενη εβδομάδα."_

Θα μπορούσατε επίσης να μετρήσετε το χρόνο που απαιτείται για να μετακινηθείτε μεταξύ των σταδίων της διαδικασίας συνεισφοράς, όπως:

* Μέσος χρόνος που ένα ζήτημα παραμένει ανοικτό
* Αν τα θέματα κλείνουν από τις δημόσιες σχέσεις
* Αν τα θέματα που έχουν μείνει στάσιμα κλείνουν
* Μέσος χρόνος για τη συγχώνευση ενός pull request

## Χρησιμοποιήστε το 📊 για να μάθετε για τους ανθρώπους

Η κατανόηση των μετρήσεων θα σας βοηθήσει να δημιουργήσετε ένα ενεργό, αναπτυσσόμενο πρότζεκτ ανοικτού κώδικα. Ακόμα και αν δεν παρακολουθείτε κάθε μετρική σε ένα ταμπλό, χρησιμοποιήστε το παραπάνω πλαίσιο για να εστιάσετε την προσοχή σας στο είδος της συμπεριφοράς που θα βοηθήσει το πρότζεκτ σας να ευδοκιμήσει.

[CHAOSS](https://chaoss.community/) είναι μια φιλόξενη κοινότητα ανοικτού κώδικα που επικεντρώνεται στην ανάλυση, τις μετρήσεις και το λογισμικό για την κοινοτική υγεία.
