---
lang: el
title: Η Νομική Πλευρά του Ανοιχτού Κώδικα
description: Όλα όσα αναρωτηθήκατε ποτέ σχετικά με την νομική πλευρά του ανοιχτού κώδικα, και μερικά πράγματα που δεν γνωρίζατε.
class: legal
order: 10
image: /assets/images/cards/legal.png
related:
  - contribute
  - leadership
---

## Κατανόηση των νομικών επιπτώσεων του ανοικτού κώδικα

Το να μοιραστείτε το δημιουργικό σας πρότζεκτ με τον κόσμο μπορεί να είναι μια συναρπαστική και ικανοποιητική εμπειρία. Μπορεί επίσης να σημαίνει ένα σωρό νομικά πράγματα για τα οποία δεν γνωρίζατε ότι έπρεπε να ανησυχείτε. Ευτυχώς, δεν χρειάζεται να ξεκινήσετε από το μηδέν. Έχουμε καλύψει τις νομικές σας ανάγκες. (Πριν ξεκινήσετε, φροντίστε να διαβάσετε την [αποποίηση ευθυνών](/notices/) μας).

## Γιατί οι άνθρωποι ενδιαφέρονται τόσο πολύ για τη νομική πλευρά του ανοιχτού κώδικα;

Χαίρομαι που ρωτάτε! Όταν δημιουργείτε ένα δημιουργικό πρότζεκτ (όπως συγγραφή, γραφικά ή κώδικα), το πρότζεκτ αυτό υπόκειται εξ ορισμού σε αποκλειστικά πνευματικά δικαιώματα. Δηλαδή, ο νόμος υποθέτει ότι ως δημιουργός του πρότζεκτ σας, έχετε λόγο στο τι μπορούν να κάνουν οι άλλοι με αυτό.

Σε γενικές γραμμές, αυτό σημαίνει ότι κανένας άλλος δεν μπορεί να χρησιμοποιήσει, να αντιγράψει, να διανείμει ή να τροποποιήσει το πρότζεκτ σας χωρίς να κινδυνεύει από αποκοπές, εκβιασμούς ή δικαστικές διενέξεις.

Ωστόσο, ο ανοικτός κώδικας αποτελεί μια ασυνήθιστη περίπτωση, επειδή ο συγγραφέας αναμένει ότι άλλοι θα χρησιμοποιήσουν, θα τροποποιήσουν και θα μοιραστούν το πρότζεκτ. Αλλά επειδή η νομική προεπιλογή εξακολουθεί να είναι η αποκλειστική πνευματική ιδιοκτησία, χρειάζεστε μια άδεια που να δηλώνει ρητά αυτές τις άδειες.

Εάν δεν εφαρμόσετε μια άδεια χρήσης ανοικτού κώδικα, όλοι όσοι συνεισφέρουν στο πρότζεκτ σας γίνονται επίσης αποκλειστικοί κάτοχοι πνευματικών δικαιωμάτων της εργασίας τους. Αυτό σημαίνει ότι κανείς δεν μπορεί να χρησιμοποιήσει, να αντιγράψει, να διανείμει ή να τροποποιήσει τις συνεισφορές του - και σε αυτό το "κανείς" συμπεριλαμβάνεστε και εσείς.

Τέλος, το πρότζεκτ σας μπορεί να έχει εξαρτήσεις με απαιτήσεις άδειας χρήσης που δεν γνωρίζατε. Η κοινότητα του πρότζεκτ σας ή οι πολιτικές του εργοδότη σας μπορεί επίσης να απαιτούν από το πρότζεκτ σας να χρησιμοποιεί συγκεκριμένες άδειες ανοικτού κώδικα. Θα καλύψουμε αυτές τις καταστάσεις παρακάτω.

## Είναι τα δημόσια πρότζεκτ GitHub ανοιχτού κώδικα;

Όταν [δημιουργείτε ένα νέο πρότζεκτ](https://help.github.com/articles/creating-a-new-repository/) στο GitHub, έχετε την επιλογή να κάνετε το αποθετήριο **ιδιωτικό** ή **δημόσιο**.

![Δημιουργία αποθετηρίου](/assets/images/legal/repo-create-name.png)

**Η δημοσιοποίηση του έργου σας στο GitHub δεν είναι το ίδιο με την αδειοδότηση του έργου σας.** Τα δημόσια πρότζεκτ καλύπτονται από τους [Όρους χρήσης του GitHub](https://docs.github.com/en/site-policy/github-terms/github-terms-of-service#3-ownership-of-content-right-to-post-and-license-grants), οι οποίοι επιτρέπουν σε άλλους να βλέπουν και να διαιρούν το πρότζεκτ σας, αλλά η εργασία σας δεν συνοδεύεται από άλλα δικαιώματα.

Αν θέλετε να χρησιμοποιούν, να διανέμουν, να τροποποιούν ή να συνεισφέρουν άλλοι στο πρότζεκτ σας, πρέπει να συμπεριλάβετε μια άδεια χρήσης ανοικτού κώδικα. Για παράδειγμα, κάποιος δεν μπορεί νομικά να χρησιμοποιήσει οποιοδήποτε μέρος του έργου σας στο GitHub στον κώδικά του, ακόμη και αν είναι δημόσιο, εκτός αν του δώσετε ρητά το δικαίωμα να το κάνει.

## Απλά δώστε μου ένα TL;DR σχετικά με το τι χρειάζομαι για να προστατεύσω το πρότζεκτ μου.

Είστε τυχεροί, διότι σήμερα οι άδειες χρήσης ανοικτού κώδικα είναι τυποποιημένες και εύκολες στη χρήση. Μπορείτε να αντιγράψετε-επικολλήσετε μια υπάρχουσα άδεια απευθείας στο πρότζεκτ σας.

Οι [MIT](https://choosealicense.com/licenses/mit/), [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) και [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) είναι οι πιο δημοφιλείς άδειες ανοιχτού κώδικα, αλλά υπάρχουν και άλλες επιλογές για να επιλέξετε. Μπορείτε να βρείτε το πλήρες κείμενο αυτών των αδειών, καθώς και οδηγίες για τον τρόπο χρήσης τους, στην ιστοσελίδα [choosealicense.com](https://choosealicense.com/).

Όταν δημιουργείτε ένα νέο πρότζεκτ στο GitHub, θα σας ζητηθεί [να προσθέσετε μια άδεια](https://help.github.com/articles/open-source-licensing/).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/benbalter?s=180" class="pquote-avatar" alt="avatar">
  Μια τυποποιημένη άδεια χρησιμεύει ως πληρεξούσιο για όσους δεν έχουν νομική κατάρτιση, ώστε να γνωρίζουν ακριβώς τι μπορούν και τι δεν μπορούν να κάνουν με το λογισμικό. Εκτός αν είναι απολύτως απαραίτητο, αποφύγετε τους προσαρμοσμένους, τροποποιημένους ή μη τυποποιημένους όρους, οι οποίοι θα αποτελέσουν εμπόδιο για τη μεταγενέστερη χρήση του κώδικα του οργανισμού.
  <p markdown="1" class="pquote-credit">
- @benbalter, ["Everything a government attorney needs to know about open source software&nbsp;licensing"](https://ben.balter.com/2014/10/08/open-source-licensing-for-government-attorneys/)
  </p>
</aside>

## Ποια άδεια ανοιχτού κώδικα είναι κατάλληλη για το πρότζεκτ μου;

Αν ξεκινάτε από μια κενή πλάκα, είναι δύσκολο να κάνετε λάθος με την [MIT License](https://choosealicense.com/licenses/mit/). Είναι σύντομη, πολύ εύκολη στην κατανόηση και επιτρέπει σε οποιονδήποτε να κάνει οτιδήποτε, αρκεί να κρατήσει ένα αντίγραφο της άδειας, συμπεριλαμβανομένης της ειδοποίησης για τα πνευματικά σας δικαιώματα. Θα είστε σε θέση να κυκλοφορήσετε το πρότζεκτ με μια διαφορετική άδεια αν ποτέ χρειαστεί.

Διαφορετικά, η επιλογή της σωστής άδειας ανοικτού κώδικα για το πρότζεκτ σας εξαρτάται από τους στόχους σας.

Το πρότζεκτ σας είναι πολύ πιθανό να έχει (ή θα έχει) **εξαρτήσεις**. Για παράδειγμα, αν έχετε ένα πρότζεκτ που βασίζεται στο Node.js, πιθανότατα θα χρησιμοποιείτε βιβλιοθήκες από τον Node Package Manager (npm). Κάθε μία από αυτές τις βιβλιοθήκες από τις οποίες εξαρτάστε θα έχει τη δική της άδεια χρήσης ανοικτού κώδικα. Αν κάθε μία από τις άδειες τους είναι "επιτρεπτή" (δίνει στο κοινό την άδεια χρήσης, τροποποίησης και διαμοιρασμού, χωρίς καμία προϋπόθεση για την αδειοδότηση σε μεταγενέστερο στάδιο), μπορείτε να χρησιμοποιήσετε οποιαδήποτε άδεια θέλετε. Οι συνήθεις άδειες με επιτρεπτικό χαρακτήρα περιλαμβάνουν τις MIT, Apache 2.0, ISC και BSD.

Από την άλλη πλευρά, εάν οι άδειες οποιασδήποτε από τις εξαρτήσεις σας είναι "strong copyleft" (δίνει επίσης στο κοινό τα ίδια δικαιώματα, υπό την προϋπόθεση ότι θα χρησιμοποιείτε την ίδια άδεια στα επόμενα στάδια), τότε το πρότζεκτ σας θα πρέπει να χρησιμοποιεί την ίδια άδεια. Οι συνήθεις άδειες με ισχυρό copyleft περιλαμβάνουν τις GPLv2, GPLv3 και AGPLv3.

Μπορεί επίσης να θέλετε να εξετάσετε τις **κοινότητες** που ελπίζετε ότι θα χρησιμοποιήσουν και θα συνεισφέρουν στο πρότζεκτ σας:

* **Θέλετε το πρότζεκτ σας να χρησιμοποιηθεί ως εξάρτηση από άλλα πρότζεκτ;** Πιθανώς είναι καλύτερο να χρησιμοποιήσετε την πιο δημοφιλή άδεια χρήσης στη σχετική κοινότητα. Για παράδειγμα, η [MIT](https://choosealicense.com/licenses/mit/) είναι η πιο δημοφιλής άδεια για τις [npm libraries](https://libraries.io/search?platforms=NPM).
* **Θέλετε το πρότζεκτ σας να απευθύνεται σε μεγάλες επιχειρήσεις;** Μια μεγάλη επιχείρηση θα θέλει πιθανότατα ρητή άδεια χρήσης διπλωμάτων ευρεσιτεχνίας από όλους τους συνεισφέροντες. Σε αυτή την περίπτωση, το [Apache 2.0](https://choosealicense.com/licenses/apache-2.0/) σας καλύπτει (και αυτούς).
* **Θέλετε το πρότζεκτ σας να απευθύνεται σε συνεισφέροντες που δεν επιθυμούν οι συνεισφορές τους να χρησιμοποιηθούν σε λογισμικό κλειστού κώδικα;** Η [GPLv3](https://choosealicense.com/licenses/gpl-3.0/) ή (αν επίσης δεν επιθυμούν να συνεισφέρουν σε υπηρεσίες κλειστού κώδικα) η [AGPLv3](https://choosealicense.com/licenses/agpl-3.0/) θα είναι καλή επιλογή.

Η **επιχείρησή σας** μπορεί να έχει συγκεκριμένες απαιτήσεις αδειοδότησης για τα πρότζεκτ ανοικτού κώδικα. Για παράδειγμα, μπορεί να απαιτεί μια επιτρεπτική άδεια ώστε η εταιρεία να μπορεί να χρησιμοποιήσει το πρότζεκτ σας στο προϊόν κλειστού κώδικα της εταιρείας. Ή η εταιρεία σας μπορεί να απαιτεί μια ισχυρή άδεια copyleft και μια πρόσθετη συμφωνία συνεισφοράς (βλ. παρακάτω), έτσι ώστε μόνο η εταιρεία σας, και κανένας άλλος, να μπορεί να χρησιμοποιήσει το πρότζεκτ σας σε λογισμικό κλειστού κώδικα. Ή η εταιρεία σας μπορεί να έχει ορισμένες ανάγκες που σχετίζονται με πρότυπα, κοινωνική ευθύνη ή διαφάνεια, οι οποίες μπορεί να απαιτούν μια συγκεκριμένη στρατηγική αδειοδότησης. Μιλήστε με το νομικό τμήμα της [εταιρείας σας](#τι-πρέπει-να-γνωρίζει-η-νομική-ομάδα-της-εταιρείας-μου).

Όταν δημιουργείτε ένα νέο πρότζεκτ στο GitHub, σας δίνεται η δυνατότητα να επιλέξετε μια άδεια χρήσης. Η συμπερίληψη μιας από τις άδειες που αναφέρονται παραπάνω θα καταστήσει το πρότζεκτ σας στο GitHub ανοικτού κώδικα. Αν θέλετε να δείτε και άλλες επιλογές, επισκεφθείτε την ιστοσελίδα [choosealicense.com](https://choosealicense.com) για να βρείτε την κατάλληλη άδεια για το πρότζεκτ σας, ακόμη και αν αυτό [δεν είναι λογισμικό](https://choosealicense.com/non-software/).

## Τι γίνεται αν θέλω να αλλάξω την άδεια χρήσης του έργου μου;

Τα περισσότερα πρότζεκτ δεν χρειάζεται ποτέ να αλλάξουν άδειες χρήσης. Αλλά περιστασιακά οι συνθήκες αλλάζουν.

Για παράδειγμα, καθώς το πρότζεκτ σας μεγαλώνει, προσθέτει εξαρτήσεις ή χρήστες, ή η εταιρεία σας αλλάζει στρατηγικές, κάτι που μπορεί να απαιτεί ή να επιθυμεί διαφορετική άδεια χρήσης. Επίσης, αν αμελήσατε να αδειοδοτήσετε το πρότζεκτ σας από την αρχή, η προσθήκη άδειας είναι ουσιαστικά το ίδιο με την αλλαγή αδειών. Υπάρχουν τρία θεμελιώδη πράγματα που πρέπει να λάβετε υπόψη όταν προσθέτετε ή αλλάζετε την άδεια του έργου σας:

**Είναι περίπλοκο.** Ο προσδιορισμός της συμβατότητας και της συμμόρφωσης με τις άδειες χρήσης και το ποιος κατέχει τα πνευματικά δικαιώματα μπορεί να γίνει πολύπλοκος και συγκεχυμένος πολύ γρήγορα. Η μετάβαση σε μια νέα, αλλά συμβατή άδεια για νέες εκδόσεις και συνεισφορές είναι διαφορετική από την εκ νέου αδειοδότηση όλων των υφιστάμενων συνεισφορών. Εμπλέξτε τη νομική σας ομάδα με την πρώτη ένδειξη οποιασδήποτε επιθυμίας αλλαγής αδειών χρήσης. Ακόμη και αν έχετε ή μπορείτε να λάβετε άδεια από τους κατόχους των πνευματικών δικαιωμάτων του έργου σας για μια αλλαγή άδειας χρήσης, λάβετε υπόψη σας τον αντίκτυπο της αλλαγής στους άλλους χρήστες και συνεισφέροντες του έργου σας. Σκεφτείτε μια αλλαγή άδειας χρήσης ως ένα "γεγονός διακυβέρνησης" για το πρότζεκτ σας, το οποίο είναι πιθανότερο να εξελιχθεί ομαλά με σαφή επικοινωνία και διαβούλευση με τους ενδιαφερόμενους φορείς του έργου σας. Ένας λόγος παραπάνω για να επιλέξετε και να χρησιμοποιήσετε την κατάλληλη άδεια για το πρότζεκτ σας από την αρχή του!

**Η υπάρχουσα άδεια του έργου σας.** Αν η υπάρχουσα άδεια του έργου σας είναι συμβατή με την άδεια στην οποία θέλετε να αλλάξετε, μπορείτε απλά να αρχίσετε να χρησιμοποιείτε τη νέα άδεια. Αυτό συμβαίνει επειδή, αν η άδεια Α είναι συμβατή με την άδεια Β, θα συμμορφώνεστε με τους όρους της Α, ενώ παράλληλα θα συμμορφώνεστε με τους όρους της Β (αλλά όχι απαραίτητα το αντίστροφο). Έτσι, αν χρησιμοποιείτε επί του παρόντος μια επιτρεπτική άδεια (π.χ. MIT), θα μπορούσατε να αλλάξετε σε μια άδεια με περισσότερους όρους, αρκεί να διατηρήσετε ένα αντίγραφο της άδειας MIT και οποιεσδήποτε σχετικές ειδοποιήσεις πνευματικών δικαιωμάτων (δηλαδή, να συνεχίσετε να συμμορφώνεστε με τους ελάχιστους όρους της άδειας MIT). Αλλά αν η τρέχουσα άδειά σας δεν είναι επιτρεπτή (π.χ. copyleft, ή δεν έχετε άδεια) και δεν είστε ο μοναδικός κάτοχος των πνευματικών δικαιωμάτων, δεν θα μπορούσατε απλά να αλλάξετε την άδεια του έργου σας σε MIT. Ουσιαστικά, με μια επιτρεπτική άδεια οι κάτοχοι των πνευματικών δικαιωμάτων του έργου έχουν δώσει εκ των προτέρων την άδεια να αλλάξουν τις άδειες.

**Οι υπάρχοντες κάτοχοι πνευματικών δικαιωμάτων του έργου σας.** Εάν είστε ο μοναδικός συντελεστής του έργου σας, τότε είτε εσείς είτε η εταιρεία σας είστε ο μοναδικός κάτοχος πνευματικών δικαιωμάτων του έργου. Μπορείτε να προσθέσετε ή να αλλάξετε σε όποια άδεια χρήσης θέλετε εσείς ή η εταιρεία σας. Διαφορετικά, μπορεί να υπάρχουν άλλοι κάτοχοι πνευματικών δικαιωμάτων από τους οποίους θα πρέπει να έχετε τη σύμφωνη γνώμη για να αλλάξετε τις άδειες χρήσης. Ποιοι είναι αυτοί; Οι άνθρωποι που έχουν commits στο πρότζεκτ σας είναι ένα καλό μέρος για να ξεκινήσετε. Αλλά σε ορισμένες περιπτώσεις τα πνευματικά δικαιώματα θα κατέχονται από τους εργοδότες αυτών των ανθρώπων. Σε ορισμένες περιπτώσεις οι άνθρωποι θα έχουν κάνει μόνο ελάχιστες συνεισφορές, αλλά δεν υπάρχει κανένας αυστηρός και σταθερός κανόνας ότι συνεισφορές κάτω από κάποιο αριθμό γραμμών κώδικα δεν υπόκεινται σε πνευματικά δικαιώματα. Τι πρέπει να γίνει; Εξαρτάται. Για ένα σχετικά μικρό και νεαρό πρότζεκτ, μπορεί να είναι εφικτό να πείσετε όλους τους υπάρχοντες συνεισφέροντες να συμφωνήσουν σε μια αλλαγή άδειας χρήσης σε ένα θέμα ή σε ένα pull request. Για μεγάλα και μακροχρόνια πρότζεκτ, μπορεί να χρειαστεί να αναζητήσετε πολλούς συνεισφέροντες, ακόμη και τους κληρονόμους τους. Η Mozilla χρειάστηκε πολλά χρόνια (2001-2006) για να ανανεώσει την άδεια χρήσης του Firefox, του Thunderbird και του σχετικού λογισμικού.

Εναλλακτικά, μπορείτε να ζητήσετε από τους συνεισφέροντες να συμφωνήσουν εκ των προτέρων (μέσω μιας πρόσθετης συμφωνίας συνεισφέροντος -- δείτε παρακάτω) σε ορισμένες αλλαγές στην άδεια χρήσης υπό ορισμένες προϋποθέσεις, πέραν αυτών που επιτρέπονται από την υπάρχουσα άδεια χρήσης ανοικτού κώδικα. Αυτό μετατοπίζει λίγο την πολυπλοκότητα της αλλαγής των αδειών χρήσης. Θα χρειαστείτε περισσότερη βοήθεια από τους δικηγόρους σας εκ των προτέρων, και θα εξακολουθείτε να θέλετε να επικοινωνείτε με σαφήνεια με τα ενδιαφερόμενα μέρη του έργου σας όταν εκτελείτε μια αλλαγή άδειας χρήσης.

## Χρειάζεται το πρότζεκτ μου μια πρόσθετη συμφωνία συνεισφοράς;

Μάλλον όχι. Για τη συντριπτική πλειονότητα των πρότζεκτ ανοικτού κώδικα, μια άδεια ανοικτού κώδικα χρησιμεύει σιωπηρά τόσο ως η εισερχόμενη (από τους συνεισφέροντες) όσο και ως η εξερχόμενη (προς άλλους συνεισφέροντες και χρήστες) άδεια. Εάν το πρότζεκτ σας βρίσκεται στο GitHub, οι όροι χρήσης του GitHub καθιστούν το "inbound=outbound" τη [ρητή προεπιλογή](https://help.github.com/en/github/site-policy/github-terms-of-service#6-contributions-under-repository-license).

Μια πρόσθετη συμφωνία συνεισφέροντος -- συχνά αποκαλούμενη Συμφωνία άδειας χρήσης συνεισφέροντος (CLA) -- μπορεί να δημιουργήσει διοικητική εργασία για τους συντηρητές του έργου. Το πόση εργασία προσθέτει μια συμφωνία εξαρτάται από το πρότζεκτ και την εφαρμογή. Μια απλή συμφωνία μπορεί να απαιτεί από τους συνεισφέροντες να επιβεβαιώνουν, με ένα κλικ, ότι έχουν τα απαραίτητα δικαιώματα για να συνεισφέρουν σύμφωνα με την άδεια χρήσης ανοικτού κώδικα του έργου. Μια πιο περίπλοκη συμφωνία μπορεί να απαιτεί νομικό έλεγχο και υπογραφή από τους εργοδότες των συνεισφερόντων.

Επίσης, προσθέτοντας "γραφειοκρατία" που κάποιοι θεωρούν περιττή, δυσνόητη ή άδικη (όταν ο παραλήπτης της συμφωνίας αποκτά περισσότερα δικαιώματα από ό,τι οι συνεισφέροντες ή το κοινό μέσω της άδειας χρήσης ανοικτού κώδικα του έργου), μια πρόσθετη συμφωνία συνεισφοράς μπορεί να θεωρηθεί μη φιλική προς την κοινότητα του έργου.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/bcantrill?s=180" class="pquote-avatar" alt="avatar">
    Εξαλείψαμε το CLA για το Node.js. Με αυτόν τον τρόπο μειώνουμε το εμπόδιο εισόδου για τους συνεισφέροντες του Node.js, διευρύνοντας έτσι τη βάση των συνεισφερόντων.
  <p markdown="1" class="pquote-credit">
- @bcantrill, ["Broadening Node.js Contributions"](https://www.tritondatacenter.com/blog/broadening-node-js-contributions)
  </p>
</aside>

Ορισμένες περιπτώσεις στις οποίες μπορεί να θέλετε να εξετάσετε το ενδεχόμενο σύναψης πρόσθετης συμφωνίας συνεισφοράς για το πρότζεκτ σας περιλαμβάνουν:

* Οι δικηγόροι σας θέλουν όλοι οι συνεισφέροντες να αποδέχονται ρητά (_υπογράφουν_, online ή offline) τους όρους συνεισφοράς, ίσως επειδή θεωρούν ότι η ίδια η άδεια ανοιχτού κώδικα δεν είναι αρκετή (παρόλο που είναι!). Εάν αυτό είναι το μόνο πρόβλημα, μια συμφωνία συνεισφοράς που επιβεβαιώνει την άδεια χρήσης ανοικτού κώδικα του έργου θα πρέπει να είναι αρκετή. Η [jQuery Individual Contributor License Agreement](https://web.archive.org/web/20161013062112/http://contribute.jquery.org/CLA/) είναι ένα καλό παράδειγμα μιας ελαφριάς πρόσθετης συμφωνίας συνεισφοράς.
* Εσείς ή οι δικηγόροι σας θέλετε οι προγραμματιστές να δηλώνουν ότι κάθε δέσμευση που κάνουν είναι εξουσιοδοτημένη. Η απαίτηση [Πιστοποιητικό προέλευσης προγραμματιστή](https://developercertificate.org/) είναι ο τρόπος με τον οποίο πολλά πρότζεκτ το επιτυγχάνουν αυτό. Για παράδειγμα, η κοινότητα Node.js [χρησιμοποιεί](https://github.com/nodejs/node/blob/HEAD/CONTRIBUTING.md) το DCO [αντί](https://nodejs.org/en/blog/uncategorized/notes-from-the-road/#easier-contribution) του προηγούμενου CLA. Μια απλή επιλογή για να αυτοματοποιήσετε την επιβολή του DCO στο αποθετήριο σας είναι το [DCO Probot](https://github.com/probot/dco).
* Το πρότζεκτ σας χρησιμοποιεί μια άδεια χρήσης ανοικτού κώδικα που δεν περιλαμβάνει ρητή παραχώρηση διπλωμάτων ευρεσιτεχνίας (όπως η MIT) και χρειάζεστε παραχώρηση διπλώματος ευρεσιτεχνίας από όλους τους συνεισφέροντες, ορισμένοι από τους οποίους μπορεί να εργάζονται σε εταιρείες με μεγάλα χαρτοφυλάκια διπλωμάτων ευρεσιτεχνίας που θα μπορούσαν να χρησιμοποιηθούν για να στοχεύσουν εσάς ή άλλους συνεισφέροντες και χρήστες του έργου. Η [Apache Individual Contributor License Agreement](https://www.apache.org/licenses/icla.pdf) είναι μια ευρέως χρησιμοποιούμενη πρόσθετη συμφωνία συνεισφοράς που έχει μια παραχώρηση διπλώματος ευρεσιτεχνίας που αντικατοπτρίζει αυτή που υπάρχει στην Άδεια Apache 2.0.
* Το πρότζεκτ σας τελεί υπό άδεια copyleft, αλλά πρέπει επίσης να διανείμετε μια ιδιόκτητη έκδοση του έργου. Θα χρειαστείτε κάθε συνεισφέροντα να σας εκχωρήσει τα πνευματικά δικαιώματα ή να σας παραχωρήσει (αλλά όχι στο κοινό) μια επιτρεπτική άδεια. Το [MongoDB Contributor Agreement](https://www.mongodb.com/legal/contributor-agreement) είναι ένα παράδειγμα αυτού του τύπου συμφωνίας.
* Πιστεύετε ότι το πρότζεκτ σας μπορεί να χρειαστεί να αλλάξει άδειες χρήσης κατά τη διάρκεια της ζωής του και θέλετε οι συνεισφέροντες να συμφωνήσουν εκ των προτέρων σε τέτοιες αλλαγές.

Εάν χρειάζεται να χρησιμοποιήσετε μια πρόσθετη συμφωνία συνεισφοράς με το πρότζεκτ σας, εξετάστε το ενδεχόμενο να χρησιμοποιήσετε μια ενσωμάτωση όπως η [CLA assistant](https://github.com/cla-assistant/cla-assistant) για να ελαχιστοποιήσετε την απόσπαση της προσοχής των συνεισφερόντων.

## Τι πρέπει να γνωρίζει η νομική ομάδα της εταιρείας μου;

Εάν κυκλοφορείτε ένα πρότζεκτ ανοικτού κώδικα ως υπάλληλος της εταιρείας, πρώτα απ' όλα, η νομική σας ομάδα θα πρέπει να γνωρίζει ότι χρησιμοποιείτε ένα πρότζεκτ ανοικτού κώδικα.

Καλώς ή κακώς, σκεφτείτε να τους ενημερώσετε, ακόμη και αν πρόκειται για ένα προσωπικό πρότζεκτ. Πιθανόν να έχετε μια "συμφωνία διανοητικής ιδιοκτησίας εργαζομένων" με την εταιρεία σας που τους δίνει κάποιο έλεγχο των πρότζεκτ σας, ειδικά αν αυτά σχετίζονται καθόλου με την επιχειρηματική δραστηριότητα της εταιρείας ή αν χρησιμοποιείτε πόρους της εταιρείας για την ανάπτυξη του έργου. Η εταιρεία σας _θα πρέπει_ να σας δώσει εύκολα την άδεια, και ίσως το έχει ήδη κάνει μέσω μιας φιλικής προς τους εργαζόμενους συμφωνίας πνευματικής ιδιοκτησίας ή μιας εταιρικής πολιτικής. Αν όχι, μπορείτε να διαπραγματευτείτε (για παράδειγμα, να εξηγήσετε ότι το πρότζεκτ σας εξυπηρετεί τους στόχους επαγγελματικής μάθησης και ανάπτυξης της εταιρείας για εσάς) ή να αποφύγετε να εργαστείτε στο πρότζεκτ σας μέχρι να βρείτε μια καλύτερη εταιρεία.

**Αν κάνετε ένα πρότζεκτ ανοιχτού κώδικα για την εταιρεία σας,** τότε σίγουρα ενημερώστε τους. Η νομική σας ομάδα πιθανότατα έχει ήδη πολιτικές για το ποια άδεια ανοικτού κώδικα (και ίσως πρόσθετη συμφωνία συνεισφοράς) θα πρέπει να χρησιμοποιηθεί με βάση τις επιχειρηματικές απαιτήσεις της εταιρείας και την τεχνογνωσία γύρω από τη διασφάλιση της συμμόρφωσης του έργου σας με τις άδειες των εξαρτήσεών του. Εάν όχι, εσείς και αυτοί είστε τυχεροί! Η νομική σας ομάδα θα πρέπει να είναι πρόθυμη να συνεργαστεί μαζί σας για να τα βρείτε αυτά τα πράγματα. Μερικά πράγματα που πρέπει να σκεφτείτε:

* **Υλικό τρίτων:** Έχει το πρότζεκτ σας εξαρτήσεις που δημιουργήθηκαν από άλλους ή περιλαμβάνει ή χρησιμοποιεί κώδικα άλλων; Εάν αυτά είναι ανοιχτού κώδικα, θα πρέπει να συμμορφωθείτε με τις άδειες χρήσης του υλικού ανοιχτού κώδικα. Αυτό ξεκινάει με την επιλογή μιας άδειας που συνεργάζεται με τις άδειες ανοικτού κώδικα τρίτων (βλ. παραπάνω). Εάν το πρότζεκτ σας τροποποιεί ή διανέμει υλικό ανοικτού κώδικα τρίτων, τότε η νομική σας ομάδα θα θέλει επίσης να γνωρίζει ότι πληροίτε άλλους όρους των αδειών ανοικτού κώδικα τρίτων, όπως η διατήρηση των σημειώσεων περί πνευματικών δικαιωμάτων. Εάν το πρότζεκτ σας χρησιμοποιεί κώδικα άλλων που δεν έχει άδεια χρήσης ανοικτού κώδικα, θα πρέπει πιθανώς να ζητήσετε από τους συντηρητές του τρίτου μέρους να [προσθέσουν μια άδεια χρήσης ανοικτού κώδικα](https://choosealicense.com/no-license/#for-users), και εάν δεν μπορείτε να πάρετε μια τέτοια άδεια, να σταματήσετε να χρησιμοποιείτε τον κώδικά τους στο πρότζεκτ σας.

* **Εμπορικά μυστικά:** Εξετάστε αν υπάρχει κάτι στο πρότζεκτ που η εταιρεία δεν θέλει να διαθέσει στο ευρύ κοινό. Αν ναι, θα μπορούσατε να ανοίξετε τον κώδικα του υπόλοιπου έργου σας, αφού εξάγετε το υλικό που θέλετε να κρατήσετε ιδιωτικό.

* **Διπλώματα ευρεσιτεχνίας:** Υποβάλλει η εταιρεία σας αίτηση για δίπλωμα ευρεσιτεχνίας του οποίου η ανοικτή διάθεση του έργου σας θα αποτελούσε [δημόσια αποκάλυψη](https://en.wikipedia.org/wiki/Public_disclosure); Δυστυχώς, μπορεί να σας ζητηθεί να περιμένετε (ή ίσως η εταιρεία να επανεξετάσει τη σοφία της αίτησης). Αν περιμένετε συνεισφορές στο πρότζεκτ σας από υπαλλήλους εταιρειών με μεγάλα χαρτοφυλάκια διπλωμάτων ευρεσιτεχνίας, η νομική σας ομάδα μπορεί να θέλει να χρησιμοποιήσετε μια άδεια με ρητή παραχώρηση διπλωμάτων ευρεσιτεχνίας από τους συνεισφέροντες (όπως η Apache 2.0 ή η GPLv3), ή μια πρόσθετη συμφωνία συνεισφοράς (βλ. παραπάνω).

* **Εμπορικά σήματα:** Ελέγξτε δύο φορές ότι το όνομα του έργου σας [δεν συγκρούεται με τυχόν υπάρχοντα εμπορικά σήματα](../starting-a-project/#αποφυγή-συγκρούσεων-ονομάτων). Εάν χρησιμοποιείτε τα εμπορικά σήματα της εταιρείας σας στο πρότζεκτ, ελέγξτε ότι δεν προκαλούνται συγκρούσεις. Το [FOSSmarks](http://fossmarks.org/) είναι ένας πρακτικός οδηγός για την κατανόηση των εμπορικών σημάτων στο πλαίσιο των πρότζεκτ ελεύθερου και ανοικτού κώδικα.

* **Απόρρητο:** Το πρότζεκτ σας συλλέγει δεδομένα για τους χρήστες; "Τηλεφωνεί στο σπίτι" σε διακομιστές της εταιρείας; Η νομική σας ομάδα μπορεί να σας βοηθήσει να συμμορφωθείτε με τις εταιρικές πολιτικές και τους εξωτερικούς κανονισμούς.

Αν πρόκειται να κυκλοφορήσετε το πρώτο πρότζεκτ ανοικτού κώδικα της εταιρείας σας, τα παραπάνω είναι υπεραρκετά για να τα ξεπεράσετε (αλλά μην ανησυχείτε, τα περισσότερα πρότζεκτ δεν θα πρέπει να εγείρουν σημαντικές ανησυχίες).

Μακροπρόθεσμα, η νομική σας ομάδα μπορεί να κάνει περισσότερα για να βοηθήσει την εταιρεία να αποκομίσει περισσότερα από τη συμμετοχή της στον ανοικτό κώδικα και να παραμείνει ασφαλής:

* **Πολιτικές συνεισφοράς των υπαλλήλων:** Εξετάστε το ενδεχόμενο να αναπτύξετε μια εταιρική πολιτική που να καθορίζει τον τρόπο με τον οποίο οι υπάλληλοί σας συνεισφέρουν σε πρότζεκτ ανοικτού κώδικα. Μια σαφής πολιτική θα μειώσει τη σύγχυση μεταξύ των υπαλλήλων σας και θα τους βοηθήσει να συνεισφέρουν σε πρότζεκτ ανοικτού κώδικα προς το συμφέρον της εταιρείας, είτε ως μέρος της εργασίας τους είτε στον ελεύθερο χρόνο τους. Ένα καλό παράδειγμα είναι η [Πρότυπη πολιτική IP και συνεισφοράς σε ανοικτό κώδικα](https://processmechanics.com/2015/07/23/a-model-ip-and-open-source-contribution-policy/) της Rackspace.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/vanl?s=180" class="pquote-avatar" alt="avatar">
  Η εκμίσθωση της IP που σχετίζεται με μια επιδιόρθωση δημιουργεί τη βάση γνώσεων και τη φήμη του υπαλλήλου. Δείχνει ότι η εταιρεία επενδύει στην ανάπτυξη του συγκεκριμένου εργαζομένου και δημιουργεί μια αίσθηση ενδυνάμωσης και αυτονομίας. Όλα αυτά τα οφέλη οδηγούν επίσης σε υψηλότερο ηθικό και καλύτερη διατήρηση των εργαζομένων.
  <p markdown="1" class="pquote-credit">
- @vanl, ["A Model IP and Open Source Contribution Policy"](https://processmechanics.com/2015/07/23/a-model-ip-and-open-source-contribution-policy/)
  </p>
</aside>

* **Τι να δημοσιεύσετε:** [(Σχεδόν) τα πάντα;](http://tom.preston-werner.com/2011/11/22/open-source-everything.html) Εάν η νομική σας ομάδα κατανοεί και έχει επενδύσει στη στρατηγική ανοικτού κώδικα της εταιρείας σας, θα είναι σε θέση να βοηθήσει καλύτερα παρά να εμποδίσει τις προσπάθειές σας.
* **Συμμόρφωση:** Ακόμα και αν η εταιρεία σας δεν εκδίδει πρότζεκτ ανοικτού κώδικα, χρησιμοποιεί λογισμικό ανοικτού κώδικα άλλων. Η [Ενημέρωση και διαδικασία](https://www.linuxfoundation.org/blog/blog/why-companies-that-use-open-source-need-a-compliance-program/) μπορεί να αποτρέψει πονοκεφάλους, καθυστερήσεις προϊόντων και αγωγές.

<aside markdown="1" class="pquote">
  Οι οργανισμοί πρέπει να διαθέτουν μια στρατηγική αδειοδότησης και συμμόρφωσης που να ταιριάζει και στις δύο κατηγορίες \["επιτρεπτή" και "copyleft"\]. Αυτό ξεκινά με την τήρηση αρχείου των όρων αδειοδότησης που ισχύουν για το λογισμικό ανοικτού κώδικα που χρησιμοποιείτε - συμπεριλαμβανομένων των υποσυνιστωσών και των εξαρτήσεων.
  <p markdown="1" class="pquote-credit">
- Heather Meeker, ["Open Source Software: Compliance Basics And Best Practices"](https://techcrunch.com/2012/12/14/open-source-software-compliance-basics-and-best-practices/)
  </p>
</aside>

* **Διπλώματα ευρεσιτεχνίας:** Η εταιρεία σας μπορεί να επιθυμεί να ενταχθεί στο [Open Invention Network](https://www.openinventionnetwork.com/), μια κοινή αμυντική δεξαμενή διπλωμάτων ευρεσιτεχνίας για την προστασία της χρήσης μεγάλων πρότζεκτ ανοικτού κώδικα από τα μέλη, ή να διερευνήσει άλλες [εναλλακτικές αδειοδοτήσεις διπλωμάτων ευρεσιτεχνίας](https://www.eff.org/document/hacking-patent-system-2016).
* **Διακυβέρνηση:** Ειδικά εάν και εφόσον έχει νόημα να μεταφερθεί ένα πρότζεκτ σε μια [νομική οντότητα εκτός της εταιρείας](../leadership-and-governance/#χρειάζομαι-μια-νομική-οντότητα-για-να-υποστηρίξω-το-πρότζεκτ-μου).
