---
lang: el
title: Ηγεσία και Διοίκηση
description: Τα αναπτυσσόμενα πρότζεκτς ανοιχτού κώδικα μπορούν να επωφεληθούν από επίσημους κανόνες για τη λήψη αποφάσεων.
class: leadership
order: 6
image: /assets/images/cards/leadership.png
related:
  - best-practices
  - metrics
---

## Κατανόηση της διακυβέρνησης για το αναπτυσσόμενο πρότζεκτ σας

Το πρότζεκτ σας αναπτύσσεται, οι άνθρωποι είναι αφοσιωμένοι και είστε αποφασισμένοι να το συνεχίσετε. Σε αυτό το στάδιο, μπορεί να αναρωτιέστε πώς να ενσωματώσετε τους τακτικούς συνεργάτες του πρότζεκτ στη ροή εργασίας σας, είτε πρόκειται για την παροχή σε κάποιον πρόσβασης στη δέσμευση είτε για την επίλυση των συζητήσεων της κοινότητας. Αν έχετε απορίες, έχουμε απαντήσεις.

## Ποια είναι παραδείγματα επίσημων ρόλων που χρησιμοποιούνται σε πρότζεκτ ανοικτού κώδικα;

Πολλά πρότζεκτ ακολουθούν μια παρόμοια δομή για τους ρόλους και την αναγνώριση των συνεισφερόντων.

Το τι σημαίνουν στην πραγματικότητα αυτοί οι ρόλοι, όμως, εξαρτάται αποκλειστικά από εσάς. Ακολουθούν μερικοί τύποι ρόλων που μπορεί να αναγνωρίσετε:

* **Συντηρητής**
* **Contributor**
* **Committer**

**Για ορισμένα πρότζεκτ, οι "συντηρητές"** είναι τα μόνα άτομα σε ένα πρότζεκτ με πρόσβαση στa commits. Σε άλλα πρότζεκτ, είναι απλά τα άτομα που αναφέρονται στο README ως συντηρητές.

Ένας συντηρητής δεν χρειάζεται απαραίτητα να είναι κάποιος που γράφει κώδικα για το πρότζεκτ σας. Θα μπορούσε να είναι κάποιος που έχει κάνει πολλή δουλειά για να ευαγγελιστεί το πρότζεκτ σας, ή έχει γράψει τεκμηρίωση που έκανε το πρότζεκτ πιο προσιτό σε άλλους. Ανεξάρτητα από το τι κάνει καθημερινά, ένας συντηρητής είναι πιθανότατα κάποιος που αισθάνεται την ευθύνη για την κατεύθυνση του πρότζεκτ και δεσμεύεται να το βελτιώσει.

**Ένας "contributor" θα μπορούσε να είναι οποιοσδήποτε** που σχολιάζει ένα θέμα ή ένα pull request, άνθρωποι που προσθέτουν αξία στο πρότζεκτ (είτε πρόκειται για τη διαχείριση θεμάτων, τη συγγραφή κώδικα ή τη διοργάνωση εκδηλώσεων), ή οποιοσδήποτε με ένα συγχωνευμένο pull request (ίσως ο στενότερος ορισμός ενός contributor).

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/mikeal?s=180" class="pquote-avatar" alt="avatar">
  \[Για το Node.js,\] κάθε άτομο που εμφανίζεται για να σχολιάσει ένα θέμα ή να υποβάλει κώδικα είναι μέλος της κοινότητας ενός πρότζεκτ. Και μόνο το γεγονός ότι είναι σε θέση να τους βλέπεις σημαίνει ότι είναι πια συνεισφέροντες και όχι απλώς χρήστες.
  <p markdown="1" class="pquote-credit">
- @mikeal, ["Healthy Open Source"](https://medium.com/the-javascript-collection/healthy-open-source-967fa8be7951)
  </p>
</aside>

**Ο όρος "committer"** θα μπορούσε να χρησιμοποιηθεί για να διακρίνει την πρόσβαση στα commits, η οποία είναι ένας συγκεκριμένος τύπος ευθύνης, από άλλες μορφές συνεισφοράς.

Ενώ μπορείτε να ορίσετε τους ρόλους του πρότζεκτ σας με όποιον τρόπο θέλετε, [εξετάστε το ενδεχόμενο να χρησιμοποιήσετε ευρύτερους ορισμούς](../how-to-contribute/#τι-σημαίνει-να-συνεισφέρετε) για να ενθαρρύνετε περισσότερες μορφές συνεισφοράς. Μπορείτε να χρησιμοποιήσετε τους ρόλους ηγεσίας για να αναγνωρίσετε επίσημα τους ανθρώπους που έχουν συνεισφέρει εξαιρετικά στο πρότζεκτ σας, ανεξάρτητα από τις τεχνικές τους δεξιότητες.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jacobian?s=180" class="pquote-avatar" alt="avatar">
  Μπορεί να με ξέρετε ως τον "εφευρέτη" του Django... αλλά στην πραγματικότητα είμαι ο τύπος που προσλήφθηκε για να δουλέψει πάνω σε ένα πράγμα ένα χρόνο αφότου είχε ήδη φτιαχτεί. (...) Οι άνθρωποι υποψιάζονται ότι είμαι επιτυχημένος λόγω των προγραμματιστικών μου ικανοτήτων... αλλά είμαι στην καλύτερη περίπτωση ένας μέτριος προγραμματιστής.
  <p markdown="1" class="pquote-credit">
- @jacobian, ["PyCon 2015 Keynote" (video)](https://www.youtube.com/watch?v=hIJdFxYlEKE#t=5m0s)
  </p>
</aside>

## Πώς μπορώ να επισημοποιήσω αυτούς τους ηγετικούς ρόλους;

Η επισημοποίηση των ηγετικών σας ρόλων βοηθάει τους ανθρώπους να αισθάνονται ιδιοκτησία και λέει στα άλλα μέλη της κοινότητας σε ποιον να απευθυνθούν για βοήθεια.

Για ένα μικρότερο πρότζεκτ, ο ορισμός των ηγετών μπορεί να είναι τόσο απλός όσο η προσθήκη των ονομάτων τους στο README ή σε ένα αρχείο κειμένου CONTRIBUTORS.

Για ένα μεγαλύτερο πρότζεκτ, αν έχετε έναν ιστότοπο, δημιουργήστε μια σελίδα ομάδας ή αναφέρετε εκεί τους επικεφαλής του πρότζεκτ σας. Για παράδειγμα, το [Postgres](https://github.com/postgres/postgres/) έχει μια [ολοκληρωμένη σελίδα ομάδας](https://www.postgresql.org/community/contributors/) με σύντομα προφίλ για κάθε συνεισφέροντα.

Εάν το πρότζεκτ σας έχει μια πολύ ενεργή κοινότητα συνεισφερόντων, μπορείτε να δημιουργήσετε μια "βασική ομάδα" συντηρητών ή ακόμη και υποεπιτροπές ατόμων που αναλαμβάνουν την ευθύνη για διαφορετικούς τομείς θεμάτων (για παράδειγμα, ασφάλεια, διαχείριση θεμάτων ή συμπεριφορά της κοινότητας). Αφήστε τους ανθρώπους να αυτοοργανωθούν και να αναλάβουν εθελοντικά τους ρόλους που τους ενθουσιάζουν περισσότερο, αντί να τους αναθέσετε.

<aside markdown="1" class="pquote">
  \[Εμείς\] συμπληρώνουμε τη βασική ομάδα με διάφορες "υποομάδες". Κάθε υποομάδα επικεντρώνεται σε έναν συγκεκριμένο τομέα, π.χ. στο σχεδιασμό γλωσσών ή στις βιβλιοθήκες. (...) Για να εξασφαλιστεί ο συνολικός συντονισμός και ένα ισχυρό, συνεκτικό όραμα για το πρότζεκτ ως σύνολο, κάθε υποομάδα καθοδηγείται από ένα μέλος της βασικής ομάδας.
  <p markdown="1" class="pquote-credit">
- ["Rust Governance RFC"](https://github.com/rust-lang/rfcs/blob/HEAD/text/1068-rust-governance.md)
  </p>
</aside>

Οι ηγετικές ομάδες μπορεί να θέλουν να δημιουργήσουν ένα καθορισμένο κανάλι (όπως στο IRC) ή να συναντώνται τακτικά για να συζητούν το πρότζεκτ (όπως στο Gitter ή στο Google Hangout). Μπορείτε ακόμη και να κάνετε αυτές τις συναντήσεις δημόσιες ώστε να μπορούν να τις ακούνε και άλλοι. Το [Cucumber-ruby](https://github.com/cucumber/cucumber-ruby), για παράδειγμα, [φιλοξενεί ώρες γραφείου κάθε εβδομάδα](https://github.com/cucumber/cucumber-ruby/blob/HEAD/CONTRIBUTING.md#talking-with-other-devs).

Αφού καθιερώσετε ηγετικούς ρόλους, μην ξεχάσετε να τεκμηριώσετε πώς οι άνθρωποι μπορούν να τους αποκτήσουν! Καθορίστε μια σαφή διαδικασία για το πώς κάποιος μπορεί να γίνει συντηρητής ή να ενταχθεί σε μια υποεπιτροπή του πρότζεκτ σας και γράψτε την στο GOVERNANCE.md.

Εργαλεία όπως το [Vossibility](https://github.com/icecrime/vossibility-stack) μπορούν να σας βοηθήσουν να παρακολουθείτε δημόσια ποιος συνεισφέρει (ή δεν συνεισφέρει) στο πρότζεκτ. Η τεκμηρίωση αυτών των πληροφοριών αποφεύγει την αντίληψη της κοινότητας ότι οι συντηρητές είναι μια κλίκα που παίρνει τις αποφάσεις της ιδιωτικά.

Τέλος, αν το πρότζεκτ σας βρίσκεται στο GitHub, εξετάστε το ενδεχόμενο να μεταφέρετε το πρότζεκτ σας από τον προσωπικό σας λογαριασμό σε έναν Οργανισμό και να προσθέσετε τουλάχιστον έναν εφεδρικό διαχειριστή. Οι [Οργανισμοί του GitHub](https://help.github.com/articles/creating-a-new-organization-account/) διευκολύνουν τη διαχείριση των δικαιωμάτων και των πολλαπλών αποθετηρίων και προστατεύουν την κληρονομιά του πρότζεκτ σας μέσω της [κοινής ιδιοκτησίας](../building-community/#μοιραστείτε-την-ιδιοκτησία-του-πρότζεκτ-σας).

## Πότε θα πρέπει να δώσω σε κάποιον πρόσβαση στα commits;

Κάποιοι πιστεύουν ότι πρέπει να δίνετε πρόσβαση στα commits σε όλους όσους συνεισφέρουν. Κάτι τέτοιο θα μπορούσε να ενθαρρύνει περισσότερους ανθρώπους να νιώσουν ιδιοκτησία του πρότζεκτ σας.

Από την άλλη πλευρά, ειδικά για μεγαλύτερα, πιο σύνθετα πρότζεκτ, μπορεί να θέλετε να δώσετε πρόσβαση στη δέσμευση μόνο σε άτομα που έχουν αποδείξει τη δέσμευσή τους. Δεν υπάρχει ένας μόνο σωστός τρόπος - κάντε αυτό που σας κάνει να αισθάνεστε πιο άνετα!

Αν το πρότζεκτ σας βρίσκεται στο GitHub, μπορείτε να χρησιμοποιήσετε το [protected branches](https://help.github.com/articles/about-protected-branches/) για να διαχειριστείτε ποιος μπορεί να προωθήσει σε ένα συγκεκριμένο κλάδο και υπό ποιες συνθήκες.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/felixge?s=180" class="pquote-avatar" alt="avatar">
  Κάθε φορά που κάποιος σας στέλνει ένα pull request, δώστε του πρόσβαση στα commits στο πρότζεκτ σας. Αν και μπορεί να ακούγεται απίστευτα ανόητο στην αρχή, η χρήση αυτής της στρατηγικής θα σας επιτρέψει να απελευθερώσετε την πραγματική δύναμη του GitHub. (...) Μόλις οι άνθρωποι έχουν πρόσβαση στα commits, δεν ανησυχούν πλέον ότι η διόρθωσή τους μπορεί να μην ενσωματωθεί... με αποτέλεσμα να βάλουν πολύ περισσότερη δουλειά σε αυτήν.
  <p markdown="1" class="pquote-credit">
- @felixge, ["The Pull Request Hack"](https://felixge.de/2013/03/11/the-pull-request-hack.html)
  </p>
</aside>

## Ποιες είναι μερικές από τις συνήθεις δομές διακυβέρνησης για πρότζεκτ ανοικτού κώδικα;

Υπάρχουν τρεις κοινές δομές διακυβέρνησης που σχετίζονται με πρότζεκτ ανοικτού κώδικα.

* **BDFL:** Το BDFL σημαίνει "καλοπροαίρετος δικτάτορας για όλη τη ζωή" (Benevolent Dictator For Life). Σύμφωνα με αυτή τη δομή, ένα άτομο (συνήθως ο αρχικός ιδιοκτήτης του πρότζεκτ) έχει τον τελικό λόγο σε όλες τις σημαντικές αποφάσεις του πρότζεκτ. Η [Python](https://github.com/python) είναι ένα κλασικό παράδειγμα. Τα μικρότερα πρότζεκτ είναι πιθανώς εξ ορισμού BDFL, επειδή υπάρχουν μόνο ένας ή δύο συντηρητές. Ένα πρότζεκτ που προέρχεται από μια εταιρεία μπορεί επίσης να εμπίπτει στην κατηγορία BDFL.

* **Μεριτοκρατία:** **(Σημείωση: ο όρος "αξιοκρατία" έχει αρνητική χροιά για ορισμένες κοινότητες και έχει μια [πολύπλοκη κοινωνική και πολιτική ιστορία](http://geekfeminism.wikia.com/wiki/Meritocracy).)** Στο πλαίσιο μιας αξιοκρατίας, στους ενεργούς συνεισφέροντες στο πρότζεκτ (αυτούς που επιδεικνύουν "αξία") δίνεται επίσημος ρόλος στη λήψη αποφάσεων. Οι αποφάσεις λαμβάνονται συνήθως με βάση την καθαρή συναίνεση της ψηφοφορίας. Η έννοια της αξιοκρατίας πρωτοπορήθηκε από το [Apache Foundation](https://www.apache.org/)- [όλα τα πρότζεκτ του Apache](https://www.apache.org/index.html#projects-list) είναι αξιοκρατίες. Οι συνεισφορές μπορούν να γίνουν μόνο από άτομα που εκπροσωπούν τον εαυτό τους, όχι από μια εταιρεία.

* **Φιλελεύθερη συνεισφορά:** Σύμφωνα με το μοντέλο της φιλελεύθερης συνεισφοράς, τα άτομα που κάνουν τη μεγαλύτερη δουλειά αναγνωρίζονται ως τα άτομα με τη μεγαλύτερη επιρροή, αλλά αυτό βασίζεται στην τρέχουσα δουλειά και όχι στις ιστορικές συνεισφορές. Οι σημαντικές αποφάσεις για το πρότζεκτ λαμβάνονται με βάση μια διαδικασία αναζήτησης συναίνεσης (συζήτηση των σημαντικότερων παραπόνων) και όχι με καθαρή ψηφοφορία, και επιδιώκεται να συμπεριληφθούν όσο το δυνατόν περισσότερες προοπτικές της κοινότητας. Δημοφιλή παραδείγματα πρότζεκτ που χρησιμοποιούν ένα φιλελεύθερο μοντέλο συνεισφοράς περιλαμβάνουν το [Node.js](https://foundation.nodejs.org/) και το [Rust](https://www.rust-lang.org/).

Ποιο από τα δύο πρέπει να χρησιμοποιήσετε; Εξαρτάται από εσάς! Κάθε μοντέλο έχει πλεονεκτήματα και συμβιβασμούς. Και παρόλο που μπορεί να φαίνονται αρκετά διαφορετικά στην αρχή, και τα τρία μοντέλα έχουν περισσότερα κοινά απ' όσα φαίνονται. Αν ενδιαφέρεστε να υιοθετήσετε ένα από αυτά τα μοντέλα, δείτε αυτά τα πρότυπα:

* [Πρότυπο μοντέλου BDFL](http://oss-watch.ac.uk/resources/benevolentdictatorgovernancemodel)
* [Πρότυπο μοντέλου αξιοκρατίας](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel)
* [Η φιλελεύθερη πολιτική συνεισφοράς του Node.js](https://medium.com/the-node-js-collection/healthy-open-source-967fa8be7951)

## Χρειάζομαι έγγραφα διακυβέρνησης όταν ξεκινάω το πρότζεκτ μου;

Δεν υπάρχει σωστή στιγμή για να καταγράψετε τη διακυβέρνηση του πρότζεκτ σας, αλλά είναι πολύ πιο εύκολο να την ορίσετε μόλις δείτε τη δυναμική της κοινότητάς σας να εξελίσσεται. Το καλύτερο (και δυσκολότερο) μέρος της διακυβέρνησης του ανοιχτού κώδικα είναι ότι διαμορφώνεται από την κοινότητα!

Ωστόσο, κάποια πρώιμη τεκμηρίωση θα συμβάλει αναπόφευκτα στη διακυβέρνηση του πρότζεκτ σας, οπότε αρχίστε να γράφετε ό,τι μπορείτε. Για παράδειγμα, μπορείτε να ορίσετε σαφείς προσδοκίες για τη συμπεριφορά ή τον τρόπο λειτουργίας της διαδικασίας συνεισφοράς σας, ακόμη και κατά την έναρξη του πρότζεκτ σας.

Αν ανήκετε σε μια εταιρεία που εγκαινιάζει ένα πρότζεκτ ανοιχτού κώδικα, αξίζει να κάνετε μια εσωτερική συζήτηση πριν από την έναρξη σχετικά με το πώς η εταιρεία σας αναμένει να συντηρεί και να λαμβάνει αποφάσεις σχετικά με το πρότζεκτ που προχωράει. Μπορεί επίσης να θέλετε να εξηγήσετε δημόσια οτιδήποτε ιδιαίτερο σχετικά με τον τρόπο με τον οποίο η εταιρεία σας θα συμμετέχει (ή δεν θα συμμετέχει!) στο πρότζεκτ.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/caabernathy?s=180" class="pquote-avatar" alt="avatar">
  Αναθέτουμε τη διαχείριση πρότζεκτ στο GitHub σε μικρές ομάδες που εργάζονται πραγματικά σε αυτά στο Facebook. Για παράδειγμα, το React διευθύνεται από έναν μηχανικό του React.
  <p markdown="1" class="pquote-credit">
- @caabernathy, ["An inside look at open source at Facebook"](https://opensource.com/life/15/10/ato-interview-christine-abernathy-facebook)
  </p>
</aside>

## Τι θα συμβεί αν οι εταιρικοί υπάλληλοι αρχίσουν να υποβάλλουν συνεισφορές;

Τα επιτυχημένα πρότζεκτ ανοικτού κώδικα χρησιμοποιούνται από πολλούς ανθρώπους και εταιρείες, και ορισμένες εταιρείες μπορεί τελικά να έχουν ροές εσόδων που συνδέονται τελικά με το πρότζεκτ. Για παράδειγμα, μια εταιρεία μπορεί να χρησιμοποιήσει τον κώδικα του πρότζεκτ ως ένα συστατικό στοιχείο σε μια εμπορική προσφορά υπηρεσιών.

Καθώς το πρότζεκτ χρησιμοποιείται ευρύτερα, οι άνθρωποι που έχουν εμπειρία σε αυτό γίνονται πιο περιζήτητοι - ίσως είστε ένας από αυτούς! - και μερικές φορές θα πληρώνονται για τη δουλειά που κάνουν στο πρότζεκτ.

Είναι σημαντικό να αντιμετωπίζετε την εμπορική δραστηριότητα ως φυσιολογική και ως μια ακόμη πηγή ενέργειας ανάπτυξης. Φυσικά, οι αμειβόμενοι προγραμματιστές δεν πρέπει να τυγχάνουν ιδιαίτερης μεταχείρισης σε σχέση με τους μη αμειβόμενους- κάθε συνεισφορά πρέπει να αξιολογείται με βάση την τεχνική της αξία. Ωστόσο, οι άνθρωποι θα πρέπει να αισθάνονται άνετα να συμμετέχουν σε εμπορική δραστηριότητα και να αισθάνονται άνετα να αναφέρουν τις περιπτώσεις χρήσης τους όταν επιχειρηματολογούν υπέρ μιας συγκεκριμένης βελτίωσης ή λειτουργίας.

Το "εμπορικό" είναι απολύτως συμβατό με το "ανοιχτό κώδικα". "Εμπορικό" σημαίνει απλώς ότι κάπου εμπλέκονται χρήματα - ότι το λογισμικό χρησιμοποιείται στο εμπόριο, κάτι που είναι όλο και πιο πιθανό καθώς ένα πρότζεκτ κερδίζει την αποδοχή του. (Όταν το λογισμικό ανοικτού κώδικα χρησιμοποιείται ως μέρος ενός προϊόντος μη ανοικτού κώδικα, το συνολικό προϊόν εξακολουθεί να είναι "ιδιόκτητο" λογισμικό, αν και, όπως και ο ανοικτός κώδικας, μπορεί να χρησιμοποιηθεί για εμπορικούς ή μη εμπορικούς σκοπούς).

Όπως όλοι οι άλλοι, οι προγραμματιστές με εμπορικά κίνητρα αποκτούν επιρροή στο πρότζεκτ μέσω της ποιότητας και της ποσότητας των συνεισφορών τους. Προφανώς, ένας προγραμματιστής που πληρώνεται για το χρόνο του μπορεί να είναι σε θέση να κάνει περισσότερα από κάποιον που δεν πληρώνεται, αλλά αυτό δεν πειράζει: η πληρωμή είναι απλώς ένας από τους πολλούς πιθανούς παράγοντες που θα μπορούσαν να επηρεάσουν το πόσο κάνει κάποιος. Κρατήστε τις συζητήσεις σας για το πρότζεκτ επικεντρωμένες στις συνεισφορές και όχι στους εξωτερικούς παράγοντες που επιτρέπουν στους ανθρώπους να κάνουν αυτές τις συνεισφορές.

## Χρειάζομαι μια νομική οντότητα για να υποστηρίξω το πρότζεκτ μου;

Δεν χρειάζεστε μια νομική οντότητα για την υποστήριξη του πρότζεκτ σας ανοικτού κώδικα, εκτός αν διαχειρίζεστε χρήματα.

Για παράδειγμα, αν θέλετε να δημιουργήσετε μια εμπορική επιχείρηση, θα πρέπει να δημιουργήσετε μια C Corp ή LLC (αν έχετε την έδρα σας στις ΗΠΑ). Αν απλά κάνετε εργασίες συμβολαίου που σχετίζονται με το πρότζεκτ σας ανοικτού κώδικα, μπορείτε να δεχτείτε χρήματα ως ατομική επιχείρηση ή να δημιουργήσετε μια LLC (αν έχετε την έδρα σας στις ΗΠΑ).

Αν θέλετε να δέχεστε δωρεές για το ανοικτού κώδικα πρότζεκτ σας, μπορείτε να δημιουργήσετε ένα κουμπί δωρεάς (χρησιμοποιώντας το PayPal ή το Stripe, για παράδειγμα), αλλά τα χρήματα δεν θα εκπίπτουν από τη φορολογία, εκτός αν είστε αναγνωρισμένος μη κερδοσκοπικός οργανισμός (501c3, αν είστε στις ΗΠΑ).

Πολλά πρότζεκτ δεν επιθυμούν να μπουν στον κόπο να δημιουργήσουν έναν μη κερδοσκοπικό οργανισμό, οπότε βρίσκουν έναν μη κερδοσκοπικό φορολογικό χορηγό. Ένας φορολογικός χορηγός δέχεται δωρεές εκ μέρους σας, συνήθως με αντάλλαγμα ένα ποσοστό της δωρεάς. [Software Freedom Conservancy](https://sfconservancy.org/), [Apache Foundation](https://www.apache.org/), [Eclipse Foundation](https://eclipse.org/org/foundation/), [Linux Foundation](https://www.linuxfoundation.org/projects) και [Open Collective](https://opencollective.com/opensource) είναι παραδείγματα οργανισμών που λειτουργούν ως φορολογικοί χορηγοί για πρότζεκτ ανοικτού κώδικα.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/piamancini?s=180" class="pquote-avatar" alt="avatar">
  Στόχος μας είναι να παρέχουμε μια υποδομή που οι κοινότητες μπορούν να χρησιμοποιήσουν για να είναι αυτοσυντηρούμενες, δημιουργώντας έτσι ένα περιβάλλον όπου όλοι - συνεισφέροντες, υποστηρικτές, χορηγοί - θα έχουν συγκεκριμένα οφέλη.
  <p markdown="1" class="pquote-credit">
- @piamancini, ["Moving beyond the charity framework"](https://medium.com/open-collective/moving-beyond-the-charity-framework-b1191c33141)
  </p>
</aside>

Εάν το πρότζεκτ σας συνδέεται στενά με μια συγκεκριμένη γλώσσα ή οικοσύστημα, μπορεί επίσης να υπάρχει ένα σχετικό ίδρυμα λογισμικού με το οποίο μπορείτε να συνεργαστείτε. Για παράδειγμα, το [Python Software Foundation](https://www.python.org/psf/) βοηθά στην υποστήριξη του [PyPI](https://pypi.org/), του διαχειριστή πακέτων Python, και το [Node.js Foundation](https://foundation.nodejs.org/) βοηθά στην υποστήριξη του [Express.js](https://expressjs.com/), ενός πλαισίου βασισμένου στο Node.
