---
lang: el
title: Λαμβάνοντας Αμοιβή για Συνεισφορά Ανοιχτού Κώδικα
description: Διατηρήστε το πρότζεκτ σας στον ανοιχτό κώδικα λαμβάνοντας οικονομική υποστήριξη για τον χρόνο σας ή το πρότζεκτ σας.
class: getting-paid
order: 7
image: /assets/images/cards/getting-paid.png
related:
  - best-practices
  - leadership
---

## Γιατί κάποιοι άνθρωποι ζητούν οικονομική στήριξη

Μεγάλο μέρος του πρότζεκτ του ανοικτού κώδικα είναι εθελοντικό. Για παράδειγμα, κάποιος μπορεί να συναντήσει ένα σφάλμα σε ένα πρότζεκτ που χρησιμοποιεί και να υποβάλει μια γρήγορη διόρθωση, ή μπορεί να του αρέσει να ασχολείται με ένα πρότζεκτ ανοιχτού κώδικα στον ελεύθερο χρόνο του.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/gvanrossum?s=180" class="pquote-avatar" alt="avatar">
Έψαχνα για ένα "χόμπι" προγραμματισμού που θα με απασχολούσε κατά τη διάρκεια της εβδομάδας γύρω από τα Χριστούγεννα. (...) Είχα έναν υπολογιστή στο σπίτι και όχι πολλά άλλα πράγματα στα χέρια μου. Αποφάσισα να γράψω έναν διερμηνέα για τη νέα γλώσσα σεναρίων που σκεφτόμουν τελευταία. (...) Επέλεξα την Python ως τίτλο εργασίας.
  <p markdown="1" class="pquote-credit">
- @gvanrossum, ["Programming Python"](https://www.python.org/doc/essays/foreword/)
  </p>
</aside>

Υπάρχουν πολλοί λόγοι για τους οποίους ένα άτομο δεν θα ήθελε να πληρωθεί για την εργασία του στον ανοικτό κώδικα.

* **Μπορεί να έχουν ήδη μια δουλειά πλήρους απασχόλησης που αγαπούν,** η οποία τους επιτρέπει να συνεισφέρουν στον ανοιχτό κώδικα στον ελεύθερο χρόνο τους.
* **Απολαμβάνουν να σκέφτονται τον ανοιχτό κώδικα ως χόμπι** ή ως δημιουργική απόδραση και δεν θέλουν να αισθάνονται οικονομικά υποχρεωμένοι να εργάζονται στα έργα τους.
* **Αποκομίζουν άλλα οφέλη από τη συνεισφορά τους στον ανοικτό κώδικα,** όπως η δημιουργία της φήμης τους ή του χαρτοφυλακίου τους, η εκμάθηση μιας νέας δεξιότητας ή το αίσθημα ότι βρίσκονται πιο κοντά σε μια κοινότητα.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/alloy?s=180" class="pquote-avatar" alt="avatar">
  Οι οικονομικές δωρεές προσθέτουν ένα αίσθημα ευθύνης, για κάποιους. (...) Είναι σημαντικό για εμάς, στον παγκοσμίως συνδεδεμένο, γρήγορο κόσμο που ζούμε, να μπορούμε να πούμε "όχι τώρα, έχω όρεξη να κάνω κάτι εντελώς διαφορετικό".
  <p markdown="1" class="pquote-credit">
- @alloy, ["Why We Don't Accept Donations"](https://blog.cocoapods.org/Why-we-dont-accept-donations/)
  </p>
</aside>

Για άλλους, ειδικά όταν οι συνεισφορές είναι συνεχείς ή απαιτούν σημαντικό χρόνο, το να πληρώνονται για να συνεισφέρουν στον ανοιχτό κώδικα είναι ο μόνος τρόπος που μπορούν να συμμετέχουν, είτε επειδή το απαιτεί το πρότζεκτ, είτε για προσωπικούς λόγους.

Η συντήρηση δημοφιλών έργων μπορεί να αποτελεί σημαντική ευθύνη, καταλαμβάνοντας 10 ή 20 ώρες την εβδομάδα αντί για λίγες ώρες το μήνα.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ashedryden?s=180" class="pquote-avatar" alt="avatar">
  Ρωτήστε οποιονδήποτε συντηρητή πρότζεκτ ανοιχτού κώδικα και θα σας πει για την πραγματικότητα του όγκου εργασίας που απαιτείται για τη διαχείριση ενός πρότζεκτ. Έχετε πελάτες. Διορθώνετε προβλήματα γι' αυτούς. Δημιουργείτε νέα χαρακτηριστικά. Αυτό γίνεται μια πραγματική απαίτηση για το χρόνο σας.
  <p markdown="1" class="pquote-credit">
- @ashedryden, ["The Ethics of Unpaid Labor and the OSS Community"](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community)
  </p>
</aside>

Η αμειβόμενη εργασία δίνει επίσης τη δυνατότητα σε ανθρώπους από διαφορετικά κοινωνικά στρώματα να συνεισφέρουν ουσιαστικά. Ορισμένοι άνθρωποι δεν έχουν την οικονομική δυνατότητα να αφιερώσουν απλήρωτο χρόνο σε έργα ανοικτού κώδικα, με βάση την τρέχουσα οικονομική τους κατάσταση, τα χρέη τους ή τις οικογενειακές ή άλλες υποχρεώσεις φροντίδας. Αυτό σημαίνει ότι ο κόσμος δεν βλέπει ποτέ συνεισφορές από ταλαντούχους ανθρώπους που δεν έχουν την οικονομική δυνατότητα να προσφέρουν εθελοντικά τον χρόνο τους. Αυτό έχει ηθικές επιπτώσεις, όπως [έχει περιγράψει](https://www.ashedryden.com/blog/the-ethics-of-unpaid-labor-and-the-oss-community) ο @ashedryden, καθώς η εργασία που γίνεται μεροληπτεί υπέρ εκείνων που έχουν ήδη πλεονεκτήματα στη ζωή τους, οι οποίοι στη συνέχεια αποκτούν πρόσθετα πλεονεκτήματα με βάση τις εθελοντικές συνεισφορές τους, ενώ άλλοι που δεν είναι σε θέση να προσφέρουν εθελοντικά, τότε δεν παίρνουν αργότερα ευκαιρίες, γεγονός που ενισχύει την τρέχουσα έλλειψη ποικιλομορφίας στην κοινότητα ανοιχτού κώδικα.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/isaacs?s=180" class="pquote-avatar" alt="avatar">
   Ο OSS αποφέρει τεράστια οφέλη στην τεχνολογική βιομηχανία, τα οποία με τη σειρά τους σημαίνουν οφέλη για όλες τις βιομηχανίες. (...) Ωστόσο, αν οι μόνοι που μπορούν να εστιάσουν σε αυτό είναι οι τυχεροί και οι εμμονικοί, τότε υπάρχει ένα τεράστιο ανεκμετάλλευτο δυναμικό.
  <p markdown="1" class="pquote-credit">
- @isaacs, ["Money and Open Source"](https://medium.com/open-source-life/money-and-open-source-d44a1953749c)
  </p>
</aside>

Εάν αναζητάτε οικονομική στήριξη, υπάρχουν δύο τρόποι που μπορείτε να εξετάσετε. Μπορείτε να χρηματοδοτήσετε το χρόνο σας ως συνεργάτης, ή μπορείτε να βρείτε οργανωτική χρηματοδότηση για το πρότζεκτ.

## Χρηματοδότηση του χρόνου σας

Σήμερα, πολλοί άνθρωποι αμείβονται για να εργάζονται με μερική ή πλήρη απασχόληση στον ανοικτό κώδικα. Ο πιο συνηθισμένος τρόπος για να πληρωθείτε για το χρόνο σας είναι να μιλήσετε με τον εργοδότη σας.

Είναι πιο εύκολο να υποστηρίξετε την εργασία σε ανοιχτό κώδικα αν ο εργοδότης σας χρησιμοποιεί πραγματικά το πρότζεκτ, αλλά γίνετε δημιουργικοί με την προσφορά σας. Ίσως ο εργοδότης σας δεν χρησιμοποιεί το πρότζεκτ, αλλά χρησιμοποιεί την Python, και η διατήρηση ενός δημοφιλούς πρότζεκτ Python συμβάλλει στην προσέλκυση νέων προγραμματιστών Python. Ίσως αυτό κάνει τον εργοδότη σας να φαίνεται γενικά πιο φιλικός προς τους προγραμματιστές.

Αν δεν έχετε κάποιο υπάρχον πρότζεκτ ανοικτού κώδικα στο οποίο θα θέλατε να εργαστείτε, αλλά θα προτιμούσατε να είναι ανοικτού κώδικα το τρέχον αποτέλεσμα της δουλειάς σας, κάντε μια πρόταση στον εργοδότη σας να ανοίξει κάποιο από τα εσωτερικά του λογισμικά.

Πολλές εταιρείες αναπτύσσουν προγράμματα ανοικτού κώδικα για να χτίσουν το εμπορικό τους σήμα και να προσλάβουν ποιοτικά ταλέντα.

Η @hueniverse, για παράδειγμα, διαπίστωσε ότι υπάρχουν οικονομικοί λόγοι που δικαιολογούν [την επένδυση της Walmart στον ανοικτό κώδικα](https://www.infoworld.com/article/2608897/open-source-software/walmart-s-investment-in-open-source-isn-t-cheap.html). Και ο @jamesgpearce διαπίστωσε ότι το πρόγραμμα ανοικτού κώδικα του Facebook [έκανε τη διαφορά](https://opensource.com/business/14/10/head-of-open-source-facebook-oscon) στην πρόσληψη προσωπικού:

> Είναι στενά ευθυγραμμισμένο με την κουλτούρα μας ως χάκερ και με το πώς αντιλαμβανόταν ο οργανισμός μας. Ρωτήσαμε τους υπαλλήλους μας: "Γνωρίζατε το πρόγραμμα λογισμικού ανοικτού κώδικα στο Facebook;". Τα δύο τρίτα απάντησαν "Ναι". Οι μισοί δήλωσαν ότι το πρόγραμμα συνέβαλε θετικά στην απόφασή τους να εργαστούν σε εμάς. Αυτά δεν είναι οριακά νούμερα, και ελπίζω, μια τάση που συνεχίζεται.

Εάν η εταιρεία σας ακολουθήσει αυτόν τον δρόμο, είναι σημαντικό να διατηρήσετε σαφή τα όρια μεταξύ της κοινοτικής και της εταιρικής δραστηριότητας. Τελικά, ο ανοιχτός κώδικας συντηρείται μέσω των συνεισφορών ανθρώπων από όλο τον κόσμο, και αυτό είναι μεγαλύτερο από οποιαδήποτε εταιρεία ή τοποθεσία.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jessfraz?s=180" class="pquote-avatar" alt="avatar">
  Το να πληρώνεσαι για να δουλεύεις πάνω στον ανοιχτό κώδικα είναι μια σπάνια και θαυμάσια ευκαιρία, αλλά δεν θα πρέπει να εγκαταλείψεις το πάθος σου στη διαδικασία. Το πάθος σας θα πρέπει να είναι ο λόγος για τον οποίο οι εταιρείες θέλουν να σας πληρώσουν.
  <p markdown="1" class="pquote-credit">
- @jessfraz, ["Blurred Lines"](https://blog.jessfraz.com/post/blurred-lines/)
  </p>
</aside>

Αν δεν μπορείτε να πείσετε τον σημερινό σας εργοδότη να δώσει προτεραιότητα στην εργασία ανοιχτού κώδικα, σκεφτείτε να βρείτε έναν νέο εργοδότη που ενθαρρύνει τις συνεισφορές των εργαζομένων στον ανοιχτό κώδικα. Αναζητήστε εταιρείες που καθιστούν ρητή την αφοσίωσή τους στην εργασία ανοικτού κώδικα. Για παράδειγμα:

* Ορισμένες εταιρείες, όπως η [Netflix](https://netflix.github.io/), διαθέτουν ιστότοπους που αναδεικνύουν τη συμμετοχή τους στον ανοικτό κώδικα.
* Η [Zalando](https://opensource.zalando.com) δημοσίευσε την [πολιτική συνεισφοράς στον ανοικτό κώδικα](https://opensource.zalando.com/docs/using/contributing/) για τους υπαλλήλους της.

Έργα που ξεκίνησαν από μια μεγάλη εταιρεία, όπως το [Go](https://github.com/golang) ή το [React](https://github.com/facebook/react), είναι επίσης πιθανό να απασχολούν άτομα που εργάζονται στον ανοιχτό κώδικα.

Ανάλογα με τις προσωπικές σας συνθήκες, μπορείτε να προσπαθήσετε να μαζέψετε χρήματα ανεξάρτητα για να χρηματοδοτήσετε την εργασία σας στον ανοικτό κώδικα. Για παράδειγμα:

* Το @Homebrew (και [πολλοί άλλοι συντηρητές και οργανισμοί](https://github.com/sponsors/community)) χρηματοδοτούν το πρότζεκτ τους μέσω του [GitHub Sponsors](https://github.com/sponsors)
* Ο @gaearon χρηματοδότησε το πρότζεκτ του στο [Redux](https://github.com/reactjs/redux) μέσω μιας [Patreon crowdfunding campaign](https://redux.js.org/)
* Ο @andrewgodwin χρηματοδότησε το πρότζεκτ του για τις μεταναστεύσεις σχημάτων Django [μέσω μιας καμπάνιας Kickstarter](https://www.kickstarter.com/projects/andrewgodwin/schema-migrations-for-django)

Τέλος, μερικές φορές τα έργα ανοικτού κώδικα προκηρύσσουν αμοιβές για θέματα που θα μπορούσατε να σκεφτείτε να βοηθήσετε.

* Ο @ConnorChristie μπόρεσε να πληρωθεί για [βοήθεια](https://web.archive.org/web/20181030123412/https://webcache.googleusercontent.com/search?strip=1&q=cache:https%3A%2F%2Fgithub.com%2FMARKETProtocol%2FMARKET.js%2Fissues%2F14) Η @MARKETProtocol εργάζεται στη βιβλιοθήκη JavaScript [μέσω μιας επικήρυξης στο gitcoin](https://gitcoin.co/).
* Η @mamiM έκανε μεταφράσεις στα ιαπωνικά για την @MetaMask μετά την [χρηματοδότηση του θέματος στο Bounties Network](https://explorer.bounties.network/bounty/134).

## Εύρεση χρηματοδότησης για το πρότζεκτ σας

Πέρα από τους διακανονισμούς για μεμονωμένους συνεισφέροντες, μερικές φορές τα έργα συγκεντρώνουν χρήματα από εταιρείες, ιδιώτες ή άλλους για τη χρηματοδότηση της τρέχουσας εργασίας.

Η οργανωτική χρηματοδότηση μπορεί να προορίζεται για την πληρωμή των σημερινών συνεισφερόντων, την κάλυψη των εξόδων λειτουργίας του πρότζεκτ (όπως τα τέλη φιλοξενίας) ή την επένδυση σε νέα χαρακτηριστικά ή ιδέες.

Καθώς η δημοτικότητα του ανοικτού κώδικα αυξάνεται, η εξεύρεση χρηματοδότησης για έργα είναι ακόμη πειραματική, αλλά υπάρχουν μερικές κοινές επιλογές.

### Συγκεντρώστε χρήματα για το πρότζεκτ σας μέσω εκστρατειών crowdfunding ή χορηγιών

Η εξεύρεση χορηγιών λειτουργεί καλά αν έχετε ήδη ένα ισχυρό κοινό ή φήμη ή αν το πρότζεκτ σας είναι πολύ δημοφιλές.
Μερικά παραδείγματα έργων με χορηγίες περιλαμβάνουν:

* **[webpack](https://github.com/webpack)** συγκεντρώνει χρήματα από εταιρείες και ιδιώτες [μέσω του OpenCollective](https://opencollective.com/webpack)
* **[Ruby Together](https://rubytogether.org/),** ένας μη κερδοσκοπικός οργανισμός που πληρώνει για εργασίες στα [bundler](https://github.com/bundler/bundler), [RubyGems](https://github.com/rubygems/rubygems), και άλλα έργα υποδομής Ruby

### Δημιουργία μιας ροής εσόδων

Ανάλογα με το πρότζεκτ σας, μπορεί να είστε σε θέση να χρεώνετε για εμπορική υποστήριξη, επιλογές φιλοξενίας ή πρόσθετα χαρακτηριστικά. Μερικά παραδείγματα περιλαμβάνουν:

* **[Sidekiq](https://github.com/mperham/sidekiq)** προσφέρει εκδόσεις επί πληρωμή για πρόσθετη υποστήριξη
* **[Travis CI](https://github.com/travis-ci)** προσφέρει εκδόσεις επί πληρωμή του προϊόντος του
* **[Ghost](https://github.com/TryGhost/Ghost)** είναι ένα μη κερδοσκοπικό ίδρυμα με επί πληρωμή υπηρεσία διαχείρισης

Ορισμένα δημοφιλή έργα, όπως το [npm](https://github.com/npm/cli) και το [Docker](https://github.com/docker/docker), συγκεντρώνουν ακόμη και επιχειρηματικά κεφάλαια για να υποστηρίξουν την επιχειρηματική τους ανάπτυξη.

### Υποβολή αίτησης για επιχορήγηση

Ορισμένα ιδρύματα λογισμικού και εταιρείες προσφέρουν επιχορηγήσεις για εργασίες ανοικτού κώδικα. Ορισμένες φορές, οι επιχορηγήσεις μπορούν να καταβληθούν σε ιδιώτες χωρίς τη δημιουργία νομικής οντότητας για το πρότζεκτ.

* **[Διαβάστε τα έγγραφα](https://github.com/rtfd/readthedocs.org)** έλαβε επιχορήγηση από την [Mozilla Open Source Support](https://www.mozilla.org/en-US/grants/)
* **[OpenMRS](https://github.com/openmrs)** το πρότζεκτ χρηματοδοτήθηκε από το [Stripe's Open-Source Retreat](https://stripe.com/blog/open-source-retreat-2016-grantees)
* **[Libraries.io](https://github.com/librariesio)** έλαβε επιχορήγηση από το [Sloan Foundation](https://sloan.org/programs/digital-technology)
* Το **[Python Software Foundation](https://www.python.org/psf/grants/)** προσφέρει επιχορηγήσεις για εργασίες που σχετίζονται με την Python.

Για πιο λεπτομερείς επιλογές και μελέτες περιπτώσεων, ο @nayafia [έγραψε έναν οδηγό](https://github.com/nayafia/lemonade-stand) για να πληρωθείτε για εργασία ανοιχτού κώδικα. Διαφορετικοί τύποι χρηματοδότησης απαιτούν διαφορετικές δεξιότητες, οπότε λάβετε υπόψη τα δυνατά σας σημεία για να βρείτε ποια επιλογή σας ταιριάζει καλύτερα.

## Χτίζοντας μια υπόθεση για οικονομική υποστήριξη

Είτε το πρότζεκτ σας είναι μια νέα ιδέα, είτε υπάρχει εδώ και χρόνια, θα πρέπει να περιμένετε να βάλετε σημαντική σκέψη για να εντοπίσετε τον χρηματοδότη-στόχο σας και να παρουσιάσετε μια πειστική υπόθεση.

Είτε επιθυμείτε να πληρώσετε για τον δικό σας χρόνο, είτε να συγκεντρώσετε χρήματα για ένα πρότζεκτ, θα πρέπει να είστε σε θέση να απαντήσετε στις ακόλουθες ερωτήσεις.

### Αντίκτυπος

Γιατί είναι χρήσιμο αυτό το πρότζεκτ; Γιατί αρέσει τόσο πολύ στους χρήστες σας ή στους δυνητικούς χρήστες; Πού θα βρίσκεται σε πέντε χρόνια;

### Έλξη

Προσπαθήστε να συγκεντρώσετε αποδείξεις ότι το πρότζεκτ σας έχει σημασία, είτε πρόκειται για μετρήσεις, είτε για ανέκδοτα, είτε για μαρτυρίες. Υπάρχουν εταιρείες ή αξιόλογοι άνθρωποι που χρησιμοποιούν το πρότζεκτ σας αυτή τη στιγμή; Αν όχι, το έχει υποστηρίξει κάποιο εξέχον πρόσωπο;

### Αξία για τον χρηματοδότη

Οι χρηματοδότες, είτε πρόκειται για τον εργοδότη σας είτε για ένα ίδρυμα που χορηγεί επιχορηγήσεις, προσεγγίζονται συχνά με ευκαιρίες. Γιατί θα πρέπει να υποστηρίξουν το πρότζεκτ σας έναντι οποιασδήποτε άλλης ευκαιρίας; Πώς ωφελούνται προσωπικά;

### Χρήση των κονδυλίων

Τι ακριβώς θα επιτύχετε με την προτεινόμενη χρηματοδότηση; Επικεντρωθείτε σε ορόσημα ή αποτελέσματα του πρότζεκτ και όχι στην καταβολή μισθού.

### Πώς θα λάβετε τα κεφάλαια

Έχει ο χρηματοδότης οποιεσδήποτε απαιτήσεις σχετικά με την εκταμίευση; Για παράδειγμα, μπορεί να χρειαστεί να είστε μη κερδοσκοπικός οργανισμός ή να έχετε μη κερδοσκοπικό φορολογικό χορηγό. Ή ίσως τα κονδύλια πρέπει να δοθούν σε μεμονωμένο ανάδοχο και όχι σε οργανισμό. Οι απαιτήσεις αυτές διαφέρουν από χρηματοδότη σε χρηματοδότη, οπότε φροντίστε να κάνετε την έρευνά σας εκ των προτέρων.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/davegandy?s=180" class="pquote-avatar" alt="avatar">
  Εδώ και χρόνια, είμαστε η κορυφαία πηγή εικονιδίων φιλικών προς τον ιστότοπο, με μια κοινότητα άνω των 20 εκατομμυρίων ανθρώπων και έχουμε εμφανιστεί σε περισσότερους από 70 εκατομμύρια ιστότοπους, συμπεριλαμβανομένου του Whitehouse.gov. (...) Η έκδοση 4 ήταν πριν από τρία χρόνια. Η τεχνολογία του Web έχει αλλάξει πολύ από τότε και ειλικρινά, το Font Awesome έχει γίνει λίγο μπαγιάτικο. (...) Γι' αυτό παρουσιάζουμε τη Font Awesome 5. Εκσυγχρονίζουμε και ξαναγράφουμε το CSS και επανασχεδιάζουμε κάθε εικονίδιο από πάνω μέχρι κάτω. Μιλάμε για καλύτερο σχεδιασμό, καλύτερη συνοχή και καλύτερη αναγνωσιμότητα.
  <p markdown="1" class="pquote-credit">
- @davegandy, [Font Awesome Kickstarter video](https://www.kickstarter.com/projects/232193852/font-awesome-5)
  </p>
</aside>

## Πειραματιστείτε και μην τα παρατάτε

Η συγκέντρωση χρημάτων δεν είναι εύκολη υπόθεση, είτε πρόκειται για πρότζεκτ ανοιχτού κώδικα, είτε για μη κερδοσκοπικό οργανισμό, είτε για νεοσύστατη επιχείρηση λογισμικού, και στις περισσότερες περιπτώσεις απαιτεί να γίνετε δημιουργικοί. Το να προσδιορίσετε πώς θέλετε να πληρωθείτε, να κάνετε την έρευνά σας και να μπείτε στη θέση του χρηματοδότη σας θα σας βοηθήσει να δημιουργήσετε μια πειστική υπόθεση για χρηματοδότηση.
