---
lang: el
title: Βρίσκοντας Χρήστες για το Πρότζεκτ σας
description: Βοηθήστε το πρότζεκτ ανοιχτού κώδικά σας να μεγαλώσει, δίνοντας το στα χέρια ευχαριστημένων χρηστών.
class: finding
order: 3
image: /assets/images/cards/finding.png
related:
  - beginners
  - building
---

## Διαδίδοντας τη λέξη

Δεν υπάρχει κανένας κανόνας που να λέει ότι πρέπει να προωθήσετε ένα πρότζεκτ ανοιχτού κώδικα όταν το ξεκινάτε. Υπάρχουν πολλοί ικανοποιητικοί λόγοι για να εργαστείτε στον ανοιχτό κώδικα που δεν έχουν καμία σχέση με τη δημοτικότητα. Αντί να ελπίζετε ότι άλλοι θα βρουν και θα χρησιμοποιήσουν το πρότζεκτ σας ανοιχτού κώδικα, πρέπει να διαδώσετε τη σκληρή δουλειά σας!

## Βρείτε το μήνυμά σας

Πριν ξεκινήσετε την πραγματική εργασία προώθησης του πρότζεκτ σας, θα πρέπει να είστε σε θέση να εξηγήσετε τι κάνει και γιατί έχει σημασία.

Τι κάνει το πρότζεκτ σας διαφορετικό ή ενδιαφέρον; Γιατί το δημιουργήσατε; Η απάντηση αυτών των ερωτημάτων για τον εαυτό σας θα σας βοηθήσει να επικοινωνήσετε τη σημασία του πρότζεκτ σας.

Να θυμάστε ότι οι άνθρωποι εμπλέκονται ως χρήστες και τελικά γίνονται συνεισφέροντες, επειδή το πρότζεκτ σας λύνει ένα πρόβλημα γι' αυτούς. Καθώς σκέφτεστε το μήνυμα και την αξία του πρότζεκτ σας, προσπαθήστε να τα δείτε μέσα από το πρίσμα του τι μπορεί να θέλουν οι _χρήστες και οι συνεισφέροντες_.

Για παράδειγμα, ο @robb χρησιμοποιεί παραδείγματα κώδικα για να επικοινωνήσει με σαφήνεια γιατί το πρότζεκτ του, [Cartography](https://github.com/robb/Cartography), είναι χρήσιμο:

![Cartography README](/assets/images/finding-users/cartography.jpg)

Για μια βαθύτερη εμβάθυνση στην ανταλλαγή μηνυμάτων, δείτε την άσκηση ["Personas and Pathways"](https://mozillascience.github.io/working-open-workshop/personas_pathways/) της Mozilla για την ανάπτυξη προσωπικοτήτων χρηστών.

## Βοηθήστε τους ανθρώπους να βρουν και να ακολουθήσουν το πρότζεκτ σας

<aside markdown="1" class="pquote">
  Ιδανικά χρειάζεστε μια ενιαία "αρχική" διεύθυνση URL που μπορείτε να προωθήσετε και να υποδείξετε στους ανθρώπους σε σχέση με το πρότζεκτ σας. Δεν χρειάζεται να ξοδέψετε πολλά χρήματα σε ένα φανταχτερό πρότυπο ή ακόμη και σε ένα όνομα τομέα, αλλά το πρότζεκτ σας χρειάζεται ένα σημείο εστίασης.
  <p markdown="1" class="pquote-credit">
- Peter Cooper & Robert Nyman, ["How to Spread the Word About Your Code"](https://hacks.mozilla.org/2013/05/how-to-spread-the-word-about-your-code/)
  </p>
</aside>

Βοηθήστε τους ανθρώπους να βρουν και να θυμούνται το πρότζεκτ σας, δείχνοντάς τους ένα ενιαίο χώρο ονομάτων.

**Να έχετε ένα ξεκάθαρο χειριστήριο για να προωθήσετε το πρότζεκτ σας.** Ένα χειριστήριο στο Twitter, μια διεύθυνση URL στο GitHub ή ένα κανάλι IRC είναι ένας εύκολος τρόπος για να δείξετε στους ανθρώπους το πρότζεκτ σας. Αυτές οι διέξοδοι δίνουν επίσης στην αναπτυσσόμενη κοινότητα του πρότζεκτ σας ένα μέρος για να συγκεντρώνεται.

Αν δεν επιθυμείτε να δημιουργήσετε ακόμη διεξόδους για το πρότζεκτ σας, προωθήστε τη δική σας λαβή Twitter ή GitHub σε ό,τι κάνετε. Η προώθηση της λαβής σας στο Twitter ή το GitHub θα ενημερώσει τους ανθρώπους για το πώς μπορούν να επικοινωνήσουν μαζί σας ή να παρακολουθήσουν το πρότζεκτ σας. Αν μιλήσετε σε μια συνάντηση ή εκδήλωση, βεβαιωθείτε ότι τα στοιχεία επικοινωνίας σας περιλαμβάνονται στο βιογραφικό σας ή στις διαφάνειές σας.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/nathanmarz?s=180" class="pquote-avatar" alt="avatar">
  Ένα λάθος που έκανα εκείνες τις πρώτες μέρες (...) ήταν ότι δεν ξεκίνησα λογαριασμό στο Twitter για το πρότζεκτ. Το Twitter είναι ένας πολύ καλός τρόπος για να κρατάς τους ανθρώπους ενήμερους για ένα πρότζεκτ καθώς και να εκθέτεις συνεχώς τους ανθρώπους στο πρότζεκτ.
  <p markdown="1" class="pquote-credit">
- @nathanmarz, ["History of Apache Storm and Lessons Learned"](http://nathanmarz.com/blog/history-of-apache-storm-and-lessons-learned.html)
  </p>
</aside>

**Σκεφτείτε να δημιουργήσετε έναν ιστότοπο για το πρότζεκτ σας.** Ένας ιστότοπος κάνει το πρότζεκτ σας πιο φιλικό και πιο εύκολο στην πλοήγηση, ειδικά όταν συνδυάζεται με σαφή τεκμηρίωση και σεμινάρια. Η ύπαρξη ιστότοπου υποδηλώνει επίσης ότι το πρότζεκτ σας είναι ενεργό, γεγονός που θα κάνει το κοινό σας να αισθάνεται πιο άνετα στη χρήση του. Παρέχετε παραδείγματα για να δώσετε στους ανθρώπους ιδέες για το πώς να χρησιμοποιήσουν το πρότζεκτ σας.

Ο [@adrianholovaty](https://news.ycombinator.com/item?id=7531689), συνδημιουργός του Django, δήλωσε ότι ένας ιστότοπος ήταν _"μακράν το καλύτερο πράγμα που κάναμε με το Django τις πρώτες μέρες"_.

Αν το πρότζεκτ σας φιλοξενείται στο GitHub, μπορείτε να χρησιμοποιήσετε το [GitHub Pages](https://pages.github.com/) για να φτιάξετε εύκολα έναν ιστότοπο. Το [Yeoman](http://yeoman.io/), το [Vagrant](https://www.vagrantup.com/) και το [Middleman](https://middlemanapp.com/) είναι [μερικά παραδείγματα](https://github.com/showcases/github-pages-examples) εξαιρετικών, ολοκληρωμένων ιστοσελίδων.

![Αρχική σελίδα του Vagrant](/assets/images/finding-users/vagrant_homepage.png)

Τώρα που έχετε ένα μήνυμα για το πρότζεκτ σας και έναν εύκολο τρόπο για να βρουν οι άνθρωποι το πρότζεκτ σας, ας βγούμε εκεί έξω και ας μιλήσουμε στο κοινό σας!

## Πηγαίνετε εκεί όπου βρίσκεται το κοινό του πρότζεκτ σας (online)

Η διαδικτυακή προβολή είναι ένας πολύ καλός τρόπος για να μοιραστείτε και να διαδώσετε το μήνυμα γρήγορα. Χρησιμοποιώντας διαδικτυακά κανάλια, έχετε τη δυνατότητα να προσεγγίσετε ένα πολύ ευρύ κοινό.

Εκμεταλλευτείτε τις υπάρχουσες διαδικτυακές κοινότητες και πλατφόρμες για να προσεγγίσετε το κοινό σας. Εάν το πρότζεκτ σας ανοικτού κώδικα είναι ένα πρότζεκτ λογισμικού, μπορείτε πιθανώς να βρείτε το κοινό σας στο [Stack Overflow](https://stackoverflow.com/), [Reddit](https://www.reddit.com), [Hacker News](https://news.ycombinator.com/) ή [Quora](https://www.quora.com/). Βρείτε τα κανάλια στα οποία πιστεύετε ότι οι άνθρωποι θα επωφεληθούν περισσότερο ή θα ενθουσιαστούν με το πρότζεκτ σας.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/pazdera?s=180" class="pquote-avatar" alt="avatar">
  Κάθε πρόγραμμα έχει πολύ συγκεκριμένες λειτουργίες που μόνο ένα κλάσμα των χρηστών θα βρει χρήσιμες. Μην κάνετε spam σε όσο το δυνατόν περισσότερους ανθρώπους. Αντίθετα, στοχεύστε τις προσπάθειές σας σε κοινότητες που θα επωφεληθούν από τη γνώση του προγράμματός σας.
  <p markdown="1" class="pquote-credit">
- @pazdera, ["Marketing for open source projects"](https://radek.io/2015/09/28/marketing-for-open-source-projects-3/)
  </p>
</aside>

Δείτε αν μπορείτε να βρείτε τρόπους να μοιραστείτε το πρότζεκτ σας με σχετικούς τρόπους:

* **Γνωρίστε σχετικά έργα και κοινότητες ανοικτού κώδικα.** Μερικές φορές, δεν χρειάζεται να προωθήσετε άμεσα το πρότζεκτ σας. Αν το πρότζεκτ σας είναι ιδανικό για επιστήμονες δεδομένων που χρησιμοποιούν Python, γνωρίστε την κοινότητα επιστήμης δεδομένων Python. Καθώς οι άνθρωποι θα σας γνωρίζουν, θα προκύψουν φυσικές ευκαιρίες για να μιλήσετε και να μοιραστείτε το πρότζεκτ σας.
* **Βρείτε ανθρώπους που αντιμετωπίζουν το πρόβλημα που λύνει το πρότζεκτ σας.** Ψάξτε σε σχετικά φόρουμ για ανθρώπους που ανήκουν στο κοινό-στόχο του πρότζεκτ σας. Απαντήστε στην ερώτησή τους και βρείτε έναν διακριτικό τρόπο, όταν χρειάζεται, να προτείνετε το πρότζεκτ σας ως λύση.
* **Ζητήστε ανατροφοδότηση.** Παρουσιάστε τον εαυτό σας και το πρότζεκτ σας σε ένα κοινό που θα το βρει σχετικό και ενδιαφέρον. Να είστε συγκεκριμένοι σχετικά με το ποιος πιστεύετε ότι θα επωφεληθεί από το πρότζεκτ σας. Προσπαθήστε να ολοκληρώσετε την πρόταση: _"Νομίζω ότι το πρότζεκτ μου θα βοηθούσε πραγματικά τον Χ, ο οποίος προσπαθεί να κάνει Υ_". Ακούστε και απαντήστε στα σχόλια των άλλων, αντί να προωθείτε απλώς το πρότζεκτ σας.

Σε γενικές γραμμές, επικεντρωθείτε στο να βοηθάτε τους άλλους προτού ζητήσετε πράγματα σε αντάλλαγμα. Επειδή ο καθένας μπορεί εύκολα να προωθήσει ένα πρότζεκτ στο διαδίκτυο, θα υπάρχει πολύς θόρυβος. Για να ξεχωρίσετε από το πλήθος, δώστε στους ανθρώπους το πλαίσιο για το ποιοι είστε και όχι απλώς τι θέλετε.

Αν κανείς δεν δώσει σημασία ή δεν ανταποκριθεί στην αρχική σας προβολή, μην αποθαρρύνεστε! Οι περισσότερες εκκινήσεις έργων είναι μια επαναληπτική διαδικασία που μπορεί να διαρκέσει μήνες ή και χρόνια. Αν δεν έχετε ανταπόκριση με την πρώτη φορά, δοκιμάστε μια διαφορετική τακτική ή αναζητήστε πρώτα τρόπους να προσθέσετε αξία στο πρότζεκτ άλλων. Η προώθηση και η έναρξη του πρότζεκτ σας απαιτεί χρόνο και αφοσίωση.

## Πηγαίνετε εκεί όπου βρίσκεται το κοινό του πρότζεκτ σας (εκτός σύνδεσης)

![Δημόσια ομιλία](/assets/images/finding-users/public_speaking.jpg)

Οι offline εκδηλώσεις είναι ένας δημοφιλής τρόπος για την προώθηση νέων έργων στο κοινό. Είναι ένας πολύ καλός τρόπος για να προσεγγίσετε ένα αφοσιωμένο κοινό και να οικοδομήσετε βαθύτερες ανθρώπινες σχέσεις, ειδικά αν ενδιαφέρεστε να προσεγγίσετε προγραμματιστές.

Αν είστε [νέος στη δημόσια ομιλία](https://speaking.io/), ξεκινήστε βρίσκοντας μια τοπική συνάντηση που σχετίζεται με τη γλώσσα ή το οικοσύστημα του πρότζεκτ σας.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/jhamrick?s=180" class="pquote-avatar" alt="avatar">
  Ήμουν αρκετά αγχωμένος που θα πήγαινα στο PyCon. Θα έδινα μια ομιλία, θα γνώριζα μόνο μερικούς ανθρώπους εκεί, θα πήγαινα για μια ολόκληρη εβδομάδα. (...) Δεν έπρεπε να ανησυχώ, όμως. Το PyCon ήταν εκπληκτικά φοβερό! (...) Όλοι ήταν απίστευτα φιλικοί και εξωστρεφείς, τόσο πολύ που σπάνια έβρισκα χρόνο να μην μιλήσω με τους ανθρώπους!
  <p markdown="1" class="pquote-credit">
- @jhamrick, ["How I learned to Stop Worrying and Love PyCon"](http://www.jesshamrick.com/2014/04/18/how-i-learned-to-stop-worrying-and-love-pycon/)
  </p>
</aside>

Αν δεν έχετε ξαναμιλήσει ποτέ σε εκδήλωση, είναι απολύτως φυσιολογικό να αισθάνεστε νευρικοί! Να θυμάστε ότι το κοινό σας είναι εκεί επειδή θέλει πραγματικά να ακούσει για τη δουλειά σας.

Καθώς γράφετε την ομιλία σας, επικεντρωθείτε σε αυτό που το ακροατήριό σας θα βρει ενδιαφέρον και θα έχει αξία. Κρατήστε τη γλώσσα σας φιλική και προσιτή. Χαμογελάστε, αναπνεύστε και διασκεδάστε.

<aside markdown="1" class="pquote">
  <img src="/assets/images/finding-users/lena.jpg" class="pquote-avatar" alt="avatar">
  Όταν αρχίζετε να γράφετε την ομιλία σας, ανεξάρτητα από το θέμα σας, μπορεί να σας βοηθήσει αν δείτε την ομιλία σας ως μια ιστορία που θα αφηγηθείτε στους ανθρώπους.
  <p markdown="1" class="pquote-credit">
- Lena Reinhard, ["How to Prepare and Write a Tech Conference Talk"](https://web.archive.org/web/20201128162836/http://wunder.schoenaberselten.com/2016/02/16/how-to-prepare-and-write-a-tech-conference-talk/)
  </p>
</aside>

Όταν νιώσετε έτοιμοι, σκεφτείτε να μιλήσετε σε ένα συνέδριο για να προωθήσετε το πρότζεκτ σας. Τα συνέδρια μπορούν να σας βοηθήσουν να προσεγγίσετε περισσότερους ανθρώπους, μερικές φορές από όλο τον κόσμο.

Αναζητήστε συνέδρια που είναι ειδικά για τη γλώσσα ή το οικοσύστημά σας. Πριν υποβάλετε την ομιλία σας, ερευνήστε το συνέδριο για να προσαρμόσετε την ομιλία σας στους συμμετέχοντες και να αυξήσετε τις πιθανότητες να γίνετε δεκτοί να μιλήσετε στο συνέδριο. Συχνά μπορείτε να πάρετε μια ιδέα για το ακροατήριό σας κοιτάζοντας τους ομιλητές ενός συνεδρίου.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/ry?s=180" class="pquote-avatar" alt="avatar">
  Έγραψα πολύ ωραία στους ανθρώπους της JSConf και τους παρακάλεσα να μου δώσουν μια θέση όπου θα μπορούσα να το παρουσιάσω στην JSConf EU. (...) Ήμουν εξαιρετικά φοβισμένος, παρουσιάζοντας αυτό το πράγμα πάνω στο οποίο δούλευα έξι μήνες. (...) Όλη την ώρα σκεφτόμουν, ω Θεέ μου. Τι κάνω εδώ;
  <p markdown="1" class="pquote-credit">
- @ry, ["History of Node.js" (video)](https://www.youtube.com/watch?v=SAc0vQCC6UQ&t=24m57s)
  </p>
</aside>

## Δημιουργήστε μια φήμη

Εκτός από τις στρατηγικές που περιγράφονται παραπάνω, ο καλύτερος τρόπος για να προσκαλέσετε τους ανθρώπους να μοιραστούν και να συνεισφέρουν στο πρότζεκτ σας είναι να μοιραστείτε και να συνεισφέρετε στα έργα τους.

Βοηθώντας τους νεοεισερχόμενους, μοιράζοντας πόρους και κάνοντας προσεγμένες συνεισφορές στα έργα των άλλων θα σας βοηθήσουν να χτίσετε μια θετική φήμη. Το να είστε ενεργό μέλος της κοινότητας ανοικτού κώδικα θα βοηθήσει τους ανθρώπους να έχουν πλαίσιο για το πρότζεκτ σας και θα είναι πιο πιθανό να δώσουν προσοχή και να μοιραστούν το πρότζεκτ σας. Η ανάπτυξη σχέσεων με άλλα έργα ανοικτού κώδικα μπορεί να οδηγήσει ακόμη και σε επίσημες συνεργασίες.

<aside markdown="1" class="pquote">
  <img src="https://avatars.githubusercontent.com/shazow?s=180" class="pquote-avatar" alt="avatar">
  Ο μόνος λόγος για τον οποίο η urllib3 είναι η πιο δημοφιλής βιβλιοθήκη τρίτου μέρους της Python σήμερα είναι επειδή αποτελεί μέρος των requests.
  <p markdown="1" class="pquote-credit">
- @shazow, ["How to make your open source project thrive"](https://about.sourcegraph.com/blog/how-to-make-your-open-source-project-thrive-with-andrey-petrov/)
  </p>
</aside>

Ποτέ δεν είναι πολύ νωρίς ή πολύ αργά για να αρχίσετε να χτίζετε τη φήμη σας. Ακόμα και αν έχετε ήδη ξεκινήσει το δικό σας πρότζεκτ, συνεχίστε να αναζητάτε τρόπους για να βοηθήσετε τους άλλους.

Δεν υπάρχει λύση από τη μια μέρα στην άλλη για να χτίσετε ένα κοινό. Το να κερδίσετε την εμπιστοσύνη και τον σεβασμό των άλλων χρειάζεται χρόνο, και το χτίσιμο της φήμης σας δεν τελειώνει ποτέ.

## Συνεχίστε!

Μπορεί να χρειαστεί πολύς χρόνος μέχρι οι άνθρωποι να παρατηρήσουν το πρότζεκτ σας ανοιχτού κώδικα. Αυτό δεν πειράζει! Μερικά από τα πιο δημοφιλή έργα σήμερα χρειάστηκαν χρόνια για να φτάσουν σε υψηλά επίπεδα δραστηριότητας. Επικεντρωθείτε στην οικοδόμηση σχέσεων αντί να ελπίζετε ότι το πρότζεκτ σας θα αποκτήσει αυθόρμητα δημοτικότητα. Κάντε υπομονή και συνεχίστε να μοιράζεστε το πρότζεκτ σας με όσους το εκτιμούν.
